# NAME

Kafka::Consumer::Avro - Avro message consumer for Apache Kafka.

# SYNOPSIS

    use Kafka::Connection;
    use Kafka::Consumer::Avro;

    my $connection = Kafka::Connection->new( host => 'localhost' );

    my $consumer = Kafka::Consumer::Avro->new( Connection => $connection );

    # Do some interactions with Avro & SchemaRegistry before sending messages

    # Fetch messages
    my $response = $consumer->fetch(...);

    # Closes the consumer and cleans up
    undef $consumer;
    $connection->close;
    undef $connection;

# DESCRIPTION

`Kafka::Consumer::Avro` main feature is to provide object-oriented API to 
consume messages according to _Confluent SchemaRegistry_ and _Avro_ serialization.

`Kafka::Consumer::Avro` inerhits from and extends [Kafka::Consumer](https://metacpan.org/pod/Kafka::Consumer).

## CONSTRUCTOR

### `new`

Creates new consumer client object.

`new()` takes arguments in key-value pairs as described in [Kafka::Consumer](https://metacpan.org/pod/Kafka::Consumer) from which it inherits.

In addition, takes in the following arguments:

- `SchemaRegistry => $schema_registry` (**mandatory**)

    Is a [Confluent::SchemaRegistry](https://metacpan.org/pod/Confluent::SchemaRegistry) instance.

## METHODS

The following methods are defined for the `Kafka::Avro::Consumer` class:

### `schema_registry`()

Returns the [Confluent::SchemaRegistry](https://metacpan.org/pod/Confluent::SchemaRegistry) instance supplied to the construcor.

### `get_error`()

Returns a string containing last error message.

### `fetch( %params )`

Gets messages froma a Kafka topic.

Please, see [Kafka::Consumer](https://metacpan.org/pod/Kafka::Consumer->fetch\(\)) for more details.

# AUTHOR

Alvaro Livraghi, <alvarol@cpan.org>

# CONTRIBUTE

[https://github.com/alivraghi/Kafka-Consumer-Avro](https://github.com/alivraghi/Kafka-Consumer-Avro)

# BUGS

Please use GitHub project link above to report problems or contact authors.

# COPYRIGHT AND LICENSE

Copyright 2018 by Alvaro Livraghi

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.
