#!/usr/bin/perl -w

# t::lib::Boot test module / 2020-01-11
#
# Copyright © 2004-2020 by William B. Birkett

use strict;

use lib $ENV{'PWD'}; # add current directory to @INC

use File::Spec;
use t::lib::Boot;
use YAML::Tiny;
use Test::More tests => 5;

# local variables
my ($profile, $yaml);

# test class methods
can_ok('t::lib::Boot', qw(new profile_header tag_table fh));

# read eciRGB_v2 profile
$profile = t::lib::Boot->new(File::Spec->catfile('t', 'data', 'eciRGB_v2.icc'));

# test object class
isa_ok($profile, 't::lib::Boot');

# read eciRGB_v2 structure data
$yaml = YAML::Tiny->read(File::Spec->catfile('t', 'data', 'eciRGB_v2.yml'));

# test profile header
is_deeply($profile->profile_header, $yaml->[0], 'profile header');

# test tag table
is_deeply($profile->tag_table, $yaml->[1], 'tag table');

# test file handle
ok(ref($profile->fh) eq 'GLOB', 'file handle');

# close file
close($profile->fh);

