package OpenInteract::SQLInstall::Base;

# $Id: Base.pm,v 1.8 2002/05/02 12:49:58 lachoy Exp $

use strict;
use vars qw( %HANDLERS );
use base qw( OpenInteract::SQLInstall );

my %files = (
   tables   => [ 'sessions.sql', 'object_keys.sql' ],
   tables_oracle => [ 'sessions_oracle.sql', 'object_keys_oracle.sql' ],
   tables_ib => [ 'sessions_interbase.sql', 'object_keys_interbase.sql' ],
   security => [ 'install_security.dat' ],
);

%HANDLERS = (
   create_structure => { '_default_' => [ 'create_structure',
                                          { table_file_list => $files{tables} } ],
                         'Oracle'    => [ 'create_structure',
                                          { table_file_list => $files{tables_oracle} } ],
                         'InterBase' => [ 'create_structure',
                                          { table_file_list => $files{tables_ib} } ],
   },
   install_security => { '_default_' => [ 'install_data',
                                          { data_file_list => $files{security} } ] },
);

1;
