package config;
use 5.008001;
use strict;
use warnings;

our $VERSION = "1.4.3";

use constant {};

our %_CONFIG;

# Конфигурирует модуль. Должен использоваться в .config.pm
sub config($%) {
	my $pkg = shift;
	$_CONFIG{$pkg} = {@_};
	return;
}

# Конфигурирует модуль. Должен использоваться в .config.pm
#@deprecated
sub config_module($$) {
	my ($pkg, $constants) = @_;
	$_CONFIG{$pkg} = $constants;
	return;
}

# Проект всегда старует от корня своей директории, где и должен лежать модуль
require "./.config.pm" if -e "./.config.pm";

# Импортирует конфиг-константы
sub import {
	my ($cls, $name, $value) = @_;
	return if !defined $name;
	my $hash = ref $name eq "HASH"? $name: +{($name => $value)};
	
	my $pkg = caller;

	if(!$^V or $^V lt 5.22.0) {
		no strict 'refs';
		for(keys %$hash) {
			my $val = exists $_CONFIG{$pkg} && exists $_CONFIG{$pkg}{$_}? $_CONFIG{$pkg}{$_}: $hash->{$_};
			*{"${pkg}::$_"} = sub {$val};
		}
	} else {
		constant->import("${pkg}::$_", exists $_CONFIG{$pkg} && exists $_CONFIG{$pkg}{$_}? $_CONFIG{$pkg}{$_}: $hash->{$_}) for keys %$hash;
	}

}

1;

__END__

=encoding utf-8

=head1 NAME

config - Perl module constant configurator

=head1 VERSION

1.4.3

=head1 SYNOPSIS

lib/Weapons.pm file:

	package Weapons;
	
	use config DAGGER => "mizericordia";
	
	1;

.config.pm file:

	package config;
	
	config Weapons => (
	    DAGGER => "horn",
	);
	
	1;

What should happen:

	use lib 'lib';
	use Weapons;
	
	Weapons::DAGGER # => horn

=head1 DESCRIPTION

C<use config> creates a constant in the same way as C<use constant>, but takes the value from the project's local config file if one is specified there.

The config file B<./.config.pm> is located in the root directory of the project.

The current directory in the project must correspond to the project root.

Since the C<config.pm> pragma module is overridden on <metacpan.org> by the C<config.pod> file from the C<WordNet-Similarity> package, this manual is used ([config::Manual](blob/master/lib/config/ Manual.md)).

=head1 AUTHOR

Yaroslav O. Kosmina L<mailto:dart@cpan.org>

=head1 LICENSE

⚖ B<Perl5>

=head1 COPYRIGHT

The config module is copyright (c) 2023 Yaroslav O. Kosmina. Rusland. All rights reserved.
