package App::Manoc::DB::Result::GroupRole;
#ABSTRACT: A model object representing the JOIN between Group and Roles.

use strict;
use warnings;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->table('group_roles');
__PACKAGE__->add_columns(
    group_id => {
        data_type      => 'int',
        is_foreign_key => 1,
        is_nullable    => 0,
    },
    role_id => {
        data_type      => 'int',
        is_foreign_key => 1,
        is_nullable    => 0,
    }
);

__PACKAGE__->set_primary_key(qw/group_id role_id/);

__PACKAGE__->belongs_to( group => 'App::Manoc::DB::Result::Group', 'group_id' );
__PACKAGE__->belongs_to( role  => 'App::Manoc::DB::Result::Role',  'role_id' );

1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::GroupRole - A model object representing the JOIN between Group and Roles.

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
