package App::Manoc::DB::Result::Building;
#ABSTRACT: A model object for buildings

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->table('buildings');
__PACKAGE__->add_columns(
    id => {
        data_type         => 'int',
        is_nullable       => 0,
        is_auto_increment => 1,
    },
    name => {
        data_type => 'varchar',
        size      => '32',
    },
    description => {
        data_type => 'varchar',
        size      => '255',
    },
    notes => {
        data_type   => 'text',
        is_nullable => 1,
    },
);

__PACKAGE__->set_primary_key('id');
__PACKAGE__->add_unique_constraint( [qw/name/] );

__PACKAGE__->has_many(
    racks => 'App::Manoc::DB::Result::Rack',
    'building_id', { cascade_delete => 0 }
);

__PACKAGE__->has_many(
    warehouses => 'App::Manoc::DB::Result::Warehouse',
    'building_id', { cascade_delete => 0 }
);


sub label {
    my $self  = shift;
    my $label = $self->name;
    $self->description and $label .= " (" . $self->description . ")";
    return $label;
}

1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::Building - A model object for buildings

=head1 VERSION

version 2.99.4

=head1 METHODS

=head2 label

Return a string describing the object

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
