package App::Manoc::DB::ResultSet::ServerHWNIC;
#ABSTRACT: ResultSet class for ServerHWNIC
use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::ResultSet';

use App::Manoc::DB::Search::Result::Iface;


sub search_uncabled {
    my ( $self, $args ) = @_;

    my $search_opts = {
        alias    => 'me',
        prefetch => ['cabling']
    };
    my $conditions = { 'cabling.hwserver_nic_id' => undef };

    my $rs = $self->search( $conditions, $search_opts );
    return wantarray ? $rs->all : $rs;
}

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::DB::ResultSet::ServerHWNIC - ResultSet class for ServerHWNIC

=head1 VERSION

version 2.99.4

=head1 METHODS

=head2 search_uncabled( )

Return a resultset containing all NICs which are not in the cabling matrix.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
