package App::Manoc::DB::Search::Result;

use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use App::Manoc::DB::Search::Result::IPAddr;
use App::Manoc::DB::Search::Result::MacAddr;
use App::Manoc::DB::Search::Result::Name;


has query => ( is => 'ro' );


has message => (
    is  => 'rw',
    isa => 'Str',
);


has groups => (
    is      => 'ro',
    isa     => 'ArrayRef',
    writer  => '_groups',
    default => sub { [] },
);


has group_by_match => (
    is      => 'ro',
    isa     => 'HashRef[String]',
    default => sub { {} },
);


has items => (
    is      => 'ro',
    isa     => 'ArrayRef',
    writer  => '_items',
    default => sub { [] },
);

my %GROUP_ITEM = (
    'logon'   => 'App::Manoc::DB::Search::Result::Name',
    'ipaddr'  => 'App::Manoc::DB::Search::Result::IPAddr',
    'macaddr' => 'App::Manoc::DB::Search::Result::MacAddr',
);


sub add_item {
    my ( $self, $item ) = @_;

    my $match = $item->match;

    my $query_type = $self->query->query_type;

    if ( my $group_class = $GROUP_ITEM{$query_type} ) {
        my $group = $self->group_by_match->{$match};

        if ( !defined($group) ) {
            my $class = $GROUP_ITEM{$query_type};

            $group = $class->new( { match => $match } );
            $self->group_by_match->{$match} = $group;

            push @{ $self->groups }, $group;
            push @{ $self->items },  $group;
        }

        $group->add_item($item);
    }
    else {
        push @{ $self->items }, $item;
    }
}


sub sort_items {
    my $self = shift;

    foreach my $group ( @{ $self->groups } ) {
        $group->sort_items;
    }

    $self->_items( [ sort { $a->key cmp $b->key } @{ $self->items } ] );
}

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::DB::Search::Result

=head1 VERSION

version 2.99.4

=head1 ATTRIBUTES

=head2 query

=head2 message

=head2 groups

The list of L<App::Manoc::Search::Item::Group> objects which will
contain the result items.

=head2 group_by_match

=head2 items

=head1 METHODS

=head2 add_item

Add a new L<App::Manoc::Search::Item> to the result. Creates a new
group if the item has a new match.

=head2 sort_items

Sort the result group by key.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
