package SNMP::Insight::Session;

#ABSTRACT: Role for SNMP client implementantions
use Moose::Role;

our $VERSION = '0.001';    #TRIAL VERSION:

use namespace::autoclean;

use Carp;

use Moose::Util::TypeConstraints;
enum 'SnmpVersion' => [qw(1 2c 3)];
no Moose::Util::TypeConstraints;

requires
  'get_scalar',
  'get_subtree';

has hostname => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
);

has port => (
    is      => 'ro',
    isa     => 'Int',
    default => '161'
);

has version => (
    is       => 'ro',
    isa      => 'SnmpVersion',
    required => 1,
);

has 'timeout' => (
    is      => 'ro',
    isa     => 'Int',
    default => 5
);

has 'retries' => (
    is      => 'ro',
    isa     => 'Int',
    default => 5
);

has 'community' => (
    is  => 'ro',
    isa => 'Str',
);

has 'username' => (
    is  => 'ro',
    isa => 'Str',
);

has 'authkey' => (
    is  => 'ro',
    isa => 'Str',
);

has 'authpassword' => (
    is  => 'ro',
    isa => 'Str',
);

has 'authprotocol' => (
    is  => 'ro',
    isa => 'Str',
);

has 'privkey' => (
    is  => 'ro',
    isa => 'Str',
);

has 'privpassword' => (
    is  => 'ro',
    isa => 'Str',
);

has 'privprotocol' => (
    is  => 'ro',
    isa => 'Str',
);

1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

SNMP::Insight::Session - Role for SNMP client implementantions

=head1 VERSION

version 0.001

=head1 ATTRIBUTES

=head2 hostname

Required.

=head2 port

Default 161

=head2 localaddr

Optional. Can be used to set local address to bind to.

=

has localaddr => (
    is  => 'ro',
    isa => 'Str',
);

=head2 localaddr

Optional. Can be used to set local port to bind to.

=

has localport => (
    is  => 'ro',
    isa => 'Int',
);

=head2 version

Required, should be on of "1", "2c", "3".

=head2 timeout

Transport layer timeout in seconds.

=head2 retries

Number of times to retry sending a SNMP message to the remote host.

=head2 community

The SNMP community name to be used for SNMPv1 and SNMPv2c security model.

=head2 username

securityName for SNMPv3

=head1 METHODS

=head2 get_scalar($oid)

Required method. Should return the value at $oid.0.

=head2 get_subtree($oid)

Required method. Should return all the values at $oid in a list of [ oid, value ] pairs.

=head1 AUTHOR

Gabriele Mambrini <g.mambrini@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
