package SNMP::Insight::MIB::Cisco_VTP;

#ABSTRACT: Support for data in CISCO-VTP-MIB

use Moose::Role;

our $VERSION = '0.002';    #TRIAL VERSION:

use SNMP::Insight::Moose::MIB;

use namespace::autoclean;
with 'SNMP::Insight::MIB';

mib_oid "1.3.6.1.4.1.9.9.";

mib_name "CISCO-VTP-MIB";

has_scalar 'vtpVersion' => ( oid => '1.1.1', );

has_scalar 'vtpMaxVlanStorage' => ( oid => '1.1.2', );

# This table contains information on the VLANs which currently exist.
has_table 'vtpVlanTable' => (
    oid     => '1.3',
    index   => 'vtpVlanIndex',
    columns => {
        vtpVlanIndex   => 1,
        vtpVlanState   => 2,
        vtpVlanType    => 3,
        vtpVlanName    => 4,
        vtpVlanTypeExt => 17,
        vtpVlanIfIndex => 18
    },
);

1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

SNMP::Insight::MIB::Cisco_VTP - Support for data in CISCO-VTP-MIB

=head1 VERSION

version 0.002

=head1 AUTHOR

Gabriele Mambrini <g.mambrini@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
