/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractConnectionPool
implements ConnectionPool,
Dumpable {
    private static final Logger LOG = Log.getLogger(AbstractConnectionPool.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger connectionCount = new AtomicInteger();
    private final Destination destination;
    private final int maxConnections;
    private final Callback requester;

    protected AbstractConnectionPool(Destination destination, int maxConnections, Callback requester) {
        this.destination = destination;
        this.maxConnections = maxConnections;
        this.requester = requester;
    }

    @ManagedAttribute(value="The max number of connections", readonly=true)
    public int getMaxConnectionCount() {
        return this.maxConnections;
    }

    @ManagedAttribute(value="The number of connections", readonly=true)
    public int getConnectionCount() {
        return this.connectionCount.get();
    }

    @Override
    public boolean isEmpty() {
        return this.connectionCount.get() == 0;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public Connection acquire() {
        Connection connection = this.activate();
        if (connection == null) {
            connection = this.tryCreate();
        }
        return connection;
    }

    private Connection tryCreate() {
        int next;
        int current;
        do {
            if ((next = (current = this.getConnectionCount()) + 1) <= this.maxConnections) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Max connections {}/{} reached", current, this.maxConnections);
            }
            return this.activate();
        } while (!this.connectionCount.compareAndSet(current, next));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection {}/{} creation", next, this.maxConnections);
        }
        this.destination.newConnection(new Promise<Connection>(){

            @Override
            public void succeeded(Connection connection) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection {}/{} creation succeeded {}", next, AbstractConnectionPool.this.maxConnections, connection);
                }
                AbstractConnectionPool.this.onCreated(connection);
                AbstractConnectionPool.this.proceed();
            }

            @Override
            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection " + next + "/" + AbstractConnectionPool.this.maxConnections + " creation failed", x);
                }
                AbstractConnectionPool.this.connectionCount.decrementAndGet();
                AbstractConnectionPool.this.requester.failed(x);
            }
        });
        return this.activate();
    }

    protected abstract void onCreated(Connection var1);

    protected void proceed() {
        this.requester.succeeded();
    }

    protected abstract Connection activate();

    protected Connection active(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection active {}", connection);
        }
        this.acquired(connection);
        return connection;
    }

    protected void acquired(Connection connection) {
    }

    protected boolean idle(Connection connection, boolean close) {
        if (close) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection idle close {}", connection);
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection idle {}", connection);
        }
        return true;
    }

    protected void released(Connection connection) {
    }

    protected void removed(Connection connection) {
        int pooled = this.connectionCount.decrementAndGet();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection removed {} - pooled: {}", connection, pooled);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.connectionCount.set(0);
        }
    }

    protected void close(Collection<Connection> connections) {
        connections.forEach(Connection::close);
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }
}

