package Daje::Controller::Workflow;
use Mojo::Base 'Mojolicious::Controller', -signatures;
use v5.40;

# NAME
# ====
#
# Daje::Controller::Workflow - Mojolicious controller for Daje::Workflow
#
# SYNOPSIS
# ========
#
#     use Daje::Controller::Workflow;
#
#     Expected indata format
#
#     'workflow' => {
#                      'workflow' => 'Workflow name',
#                      'activity' => 'name of activity',
#                      'workflow_pkey' => ,
#                      'connector' => 'Name of the connector to the workflow Optional if the workflow_pkey > 0'

#                    },
#      'payload' => {
#                        Something the activity understands
#                    }
#        }
#
#
# DESCRIPTION
# ===========
#
# Daje::Controller::Workflow is the controller for accessing Daje::Workflow
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#
#

use Data::Dumper;
use Mojo::JSON qw{decode_json};
use Daje::Workflow::Database::Model;


sub execute($self) {

    # $self->render_later;
    $self->app->log->debug('Daje::Controller::Workflow::execute');
    my $temp = $self->req->body;
    my ($companies_pkey, $users_pkey) = $self->jwt->companies_users_pkey(
        $self->req->headers->header('X-Token-Check')
    );

    $self->app->log->debug('Daje::Controller::Workflow::execute '  . Dumper($self->req->body));

    my $data->{context} = decode_json ($self->req->body);
    try {
        $self->app->log->debug('Daje::Controller::Workflow::execute ' . Dumper($data));

        if ($data->{context}->{workflow}->{connector_data}->{workflow_pkey} == 0 and
            $data->{context}->{workflow}->{connector_data}->{connector_pkey} > 0) {
            $data->{context}->{workflow}->{connector_data}->{workflow_pkey} =
                Daje::Workflow::Database::Model->new(
                    db => $self->app->pg->db
                )->load_workflow_from_connector_fkey($data->{context}->{workflow});
        }
    } catch($e) {
        $self->app->log->error('Daje::Controller::Workflow::execute ' . $e);
        $self->render(json => {result => 0, data => $e});
    };

    $data->{context}->{users_fkey} = $users_pkey;
    $data->{context}->{companies_fkey} = $companies_pkey;
    #
    # push @{$data->{actions}}, "$self->stash('wf_action')";
    # $data->{workflow}->{workflow} = $self->stash('workflow');
    # $data->{workflow}->{workflow_relation} = $self->stash('workflow_relation');
    # $data->{workflow}->{workflow_relation_key} = $self->stash('workflow_relation_key');
    # $data->{workflow}->{workflow_origin_key} = $self->stash('workflow_origin_key');
    #
    # say Dumper ($data);
    try {
        $self->workflow->workflow_pkey($data->{context}->{workflow}->{connector_data}->{workflow_pkey});
        $self->workflow->workflow_name($data->{context}->{workflow}->{workflow});
        $self->workflow->context($data);
        $self->workflow->process($data->{context}->{workflow}->{activity});
        if($self->workflow->error->has_error() == 0) {
            $self->render(json => {result => 1, data => 'OK'});
        } else {
            $self->render(json =>
                {result => 0, data => $self->workflow->error->error()}
            );
        }
    } catch ($e) {
        $self->app->log->error('Daje::Controller::Workflow::execute ' . $e);
        $self->render(json => {result => 0, data => $e});
    };
    $self->app->log->debug('Daje::Controller::Workflow::execute ends');
}
1;
__END__








#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Controller::Workflow - Mojolicious controller for Daje::Workflow



=head1 SYNOPSIS


    use Daje::Controller::Workflow;

    Expected indata format

    'workflow' => {
                     'workflow' => 'Workflow name',
                     'activity' => 'name of activity',
                     'workflow_pkey' => ,
                     'connector' => 'Name of the connector to the workflow Optional if the workflow_pkey > 0'


=head1 REQUIRES

L<Daje::Workflow::Database::Model> 

L<Mojo::JSON> 

L<Data::Dumper> 

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS

=head2 execute($self)

 execute($self)();


=cut

