/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import com.javonet.utils.DynamicMethodFactory;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class PassDelegateHandler
extends AbstractHandler {
    static String delegateGuid;
    static RuntimeName callingRuntimeName;
    static Object[] delegateArgs;
    static Class<?> delegateReturnType;

    @Override
    public Object process(Command command) throws Exception {
        this.validateCommand(command);
        delegateGuid = (String)command.getPayload()[0];
        callingRuntimeName = RuntimeName.values()[(Integer)command.getPayload()[1]];
        delegateArgs = this.getArguments(command);
        Class<?>[] delegateArgsTypes = this.getArgumentTypes(delegateArgs);
        delegateReturnType = PassDelegateHandler.getReturnType(delegateArgs);
        Class<?> dynamicClass = DynamicMethodFactory.createDynamicClass("DynamicallyCreatedDelegate", delegateReturnType, delegateArgsTypes, callingRuntimeName, delegateGuid);
        Method m = dynamicClass.getMethod("methodToExecute", delegateArgsTypes);
        return m;
    }

    private void validateCommand(Command command) {
        int requiredArgumentsCount = 1;
        if (command.getPayload().length < requiredArgumentsCount) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), requiredArgumentsCount);
        }
    }

    private Object[] getArguments(Command command) {
        return command.getPayload().length > 2 ? Arrays.copyOfRange(command.getPayload(), 2, command.getPayload().length) : new Object[]{};
    }

    private Class<?>[] getArgumentTypes(Object[] args) {
        Class[] argsTypes = new Class[args.length - 1];
        for (int i = 0; i < args.length - 1; ++i) {
            argsTypes[i] = (Class)args[i];
        }
        return argsTypes;
    }

    private static Class<?> getReturnType(Object[] args) {
        Class returnType = (Class)args[args.length - 1];
        return returnType;
    }
}

