/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;

class ExtractorsConjunction
extends RareExtractor {
    private Extractor extractor1;
    private Extractor extractor2;
    volatile boolean isLocal;
    volatile boolean isDynamic;
    private static final long serialVersionUID = 36L;

    ExtractorsConjunction(Extractor e1, Extractor e2) {
        this.extractor1 = e1;
        this.extractor2 = e2;
        this.isLocal = e1.isLocal() && e2.isLocal();
        this.isDynamic = e1.isDynamic() || e2.isDynamic();
    }

    @Override
    protected void setGlobalHolder(MaxentTagger tagger) {
        this.extractor1.setGlobalHolder(tagger);
        this.extractor2.setGlobalHolder(tagger);
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String ex1 = this.extractor1.extract(h, pH);
        if (ex1.equals("0")) {
            return "0";
        }
        String ex2 = this.extractor2.extract(h, pH);
        if (ex2.equals("0")) {
            return "0";
        }
        return ex1 + ':' + ex2;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public boolean isDynamic() {
        return this.isDynamic;
    }
}

