#!/bin/bash
# generate_pmltq_cgi_conf.sh     pajas@ufal.mff.cuni.cz     2010/02/15 12:59:16
#
#
# Use configuration from config.sh to generate a fragment of pmltq_cgi.conf 
#

. "$(dirname "$0")"/config.sh

# we call convert_to_db in order to obtain the layer=(...) variables
# from where we extract the layer's data dir

pml_to_db_configure_only=1
. "$(dirname "$0")"/convert_to_db.sh

driver=''
env=''
if [ $syntax=postgres ]; then
    driver='Pg'
elif [ $syntax=oracle ]; then
    driver='Oracle'
    env="$env
   <environment name=\"ORACLE_HOME\">$ORACLE_HOME</environment>"
fi

sources=''
for layer in "${layers[@]}"; do
    eval 'args=("${'$layer'[@]}")'
    count="${#args[@]}"
    i=0
    dir=''
    while [ $i -lt $count ]; do
	if [ "${args[$i]}" = "--data-dir" ] || [ "${args[$i]}" = "-d" ] ; then
	    i=$((i+1))
	    dir="${args[$i]}"
	    break;
	fi
	i=$((i+1))
    done
    sources="$sources
    <AM schema=\"$layer\">$dir</AM>"
done

cat <<EOF
  <dbi id="$treebank_id" public="1" featured="99">
    <description>
      <moreinfo>$infoURL</moreinfo>
      <title>$title</title>
      <abstract>$abstract</abstract>
    </description>
   <driver>$driver</driver>
   <host>$db_host</host>
   <port>$db_port</port>
   <database>$treebank_id</database>
   <username>$user</username>
   <password>$password</password>
   <sources>$sources
   </sources>$env
  </dbi>
EOF

