package Broadworks::OCIP::Methods;

# ABSTRACT: Broadworks OCI-P Methods autogenerated from XML Schema

use strict;
use warnings;
use utf8;
use namespace::autoclean;
use Method::Signatures;
use Moose;

our $VERSION = '0.08'; # VERSION
our $AUTHORITY = 'cpan:NIGELM'; # AUTHORITY

# ----------------------------------------------------------------------

##
## AS
##
##
## DataTypes
##
##
## Enterprise
##
method EnterpriseBroadWorksMobileManagerAddRequest ($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, $x9, @generic_params) {
    return $self->send_command(
        'EnterpriseBroadWorksMobileManagerAddRequest',
        serviceProviderId     => $x0,
        informationFile       => $x1,
        certificateFile       => $x2,
        isActive              => $x3,
        localToCarrier        => $x4,
        maxTxPerSecondEnabled => $x5,
        @generic_params,
        tldnEnabled                  => $x6,
        genericNumberEnabled         => $x7,
        mobileStateCheckEnabled      => $x8,
        locationBasedServicesEnabled => $x9
    );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerGetRequest ($x0) {
    return $self->send_query( 'EnterpriseBroadWorksMobileManagerGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerGetDomainListRequest ($x0) {
    return $self->send_query( 'EnterpriseBroadWorksMobileManagerGetDomainListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerDeleteRequest ($x0) {
    return $self->send_command( 'EnterpriseBroadWorksMobileManagerDeleteRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'EnterpriseBroadWorksMobileManagerModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerActivationRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseBroadWorksMobileManagerActivationRequest',
        serviceProviderId => $x0,
        isActive          => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerSendCarrierFilesRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseBroadWorksMobileManagerSendCarrierFilesRequest',
        serviceProviderId => $x0,
        emailTo           => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerAddHomeZoneRequest ($x0, $x1, $x2, $x3, $x4, $x5) {
    return $self->send_command(
        'EnterpriseBroadWorksMobileManagerAddHomeZoneRequest',
        serviceProviderId  => $x0,
        homeZoneDomainName => $x1,
        mobileCountryCode  => $x2,
        mobileNetworkCode  => $x3,
        locationAreaCode   => $x4,
        cellIdentity       => $x5
    );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerGetHomeZoneListRequest ($x0) {
    return $self->send_query( 'EnterpriseBroadWorksMobileManagerGetHomeZoneListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerGetHomeZoneRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseBroadWorksMobileManagerGetHomeZoneRequest',
        serviceProviderId => $x0,
        homeZoneId        => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerDeleteHomeZoneRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseBroadWorksMobileManagerDeleteHomeZoneRequest',
        serviceProviderId => $x0,
        homeZoneId        => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerDeleteHomeZoneListRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseBroadWorksMobileManagerDeleteHomeZoneListRequest',
        serviceProviderId => $x0,
        homeZoneId        => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobileManagerModifyHomeZoneRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseBroadWorksMobileManagerModifyHomeZoneRequest',
        serviceProviderId => $x0,
        homeZoneId        => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCommonPhoneListAddListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'EnterpriseCommonPhoneListAddListRequest',
        serviceProviderId => $x0,
        entry             => [ entryName => $x1, phoneNumber => $x2 ]
    );
}

# ----------------------------------------------------------------------
method EnterpriseCommonPhoneListDeleteListRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseCommonPhoneListDeleteListRequest',
        serviceProviderId => $x0,
        entryName         => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCommonPhoneListGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseCommonPhoneListGetListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCommonPhoneListModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseCommonPhoneListModifyRequest',
        serviceProviderId => $x0,
        entryName         => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseDepartmentAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseDepartmentAddRequest',
        enterpriseId   => $x0,
        departmentName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseDepartmentDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseDepartmentDeleteRequest',
        enterpriseId   => $x0,
        departmentName => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseDepartmentGetAvailableParentListRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseDepartmentGetAvailableParentListRequest',
        enterpriseId   => $x0,
        departmentName => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseDepartmentGetListRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseDepartmentGetListRequest',
        enterpriseId            => $x0,
        includeGroupDepartments => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseDepartmentModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseDepartmentModifyRequest',
        enterpriseId   => $x0,
        departmentName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterprisePhoneDirectoryGetListRequest18 ($x0, $x1, @generic_params) {
    return $self->send_query(
        'EnterprisePhoneDirectoryGetListRequest18',
        enterpriseId            => $x0,
        isExtendedInfoRequested => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseSessionAdmissionControlGetAvailableDeviceListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseSessionAdmissionControlGetAvailableDeviceListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseSessionAdmissionControlGroupAddDeviceListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseSessionAdmissionControlGroupAddDeviceListRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseSessionAdmissionControlGroupAddRequest19sp1 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'EnterpriseSessionAdmissionControlGroupAddRequest19sp1',
        serviceProviderId => $x0,
        name              => $x1,
        maxSession        => $x2,
        @generic_params, blockEmergencyAndRepairCallsDueToSACLimits => $x3
    );
}

# ----------------------------------------------------------------------
method EnterpriseSessionAdmissionControlGroupDeleteDeviceListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseSessionAdmissionControlGroupDeleteDeviceListRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseSessionAdmissionControlGroupDeleteListRequest ($x0, @generic_params) {
    return $self->send_command(
        'EnterpriseSessionAdmissionControlGroupDeleteListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseSessionAdmissionControlGroupGetListRequest ($x0) {
    return $self->send_query( 'EnterpriseSessionAdmissionControlGroupGetListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseSessionAdmissionControlGroupGetRequest19sp1 ($x0, $x1) {
    return $self->send_query(
        'EnterpriseSessionAdmissionControlGroupGetRequest19sp1',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseSessionAdmissionControlGroupModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseSessionAdmissionControlGroupModifyRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseVoiceVPNAddPolicyRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'EnterpriseVoiceVPNAddPolicyRequest',
        serviceProviderId   => $x0,
        locationDialingCode => $x1,
        minExtensionLength  => $x2,
        maxExtensionLength  => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseVoiceVPNDeletePolicyRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseVoiceVPNDeletePolicyRequest',
        serviceProviderId   => $x0,
        locationDialingCode => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseVoiceVPNGetDefaultRequest ($x0) {
    return $self->send_query( 'EnterpriseVoiceVPNGetDefaultRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseVoiceVPNGetPolicyRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseVoiceVPNGetPolicyRequest',
        serviceProviderId   => $x0,
        locationDialingCode => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseVoiceVPNGetRequest14sp3 ($x0) {
    return $self->send_query( 'EnterpriseVoiceVPNGetRequest14sp3', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseVoiceVPNGetPolicyListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseVoiceVPNGetPolicyListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseVoiceVPNModifyPolicyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseVoiceVPNModifyPolicyRequest',
        serviceProviderId   => $x0,
        locationDialingCode => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseVoiceVPNModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'EnterpriseVoiceVPNModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## Group
##
method GroupAccessDeviceAddRequest14 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupAccessDeviceAddRequest14',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2,
        deviceType        => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceCustomTagAddRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupAccessDeviceCustomTagAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2,
        tagName           => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceCustomTagDeleteListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupAccessDeviceCustomTagDeleteListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceCustomTagGetListRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupAccessDeviceCustomTagGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceCustomTagModifyRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupAccessDeviceCustomTagModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2,
        tagName           => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupAccessDeviceDeleteRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceFileGetListRequest14sp8 ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupAccessDeviceFileGetListRequest14sp8',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceFileGetRequest20 ($x0, $x1, $x2, $x3) {
    return $self->send_query(
        'GroupAccessDeviceFileGetRequest20',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2,
        fileFormat        => $x3
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceFileModifyRequest14sp8 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupAccessDeviceFileModifyRequest14sp8',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2,
        fileFormat        => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceGetEnhancedConfigurationTypeListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupAccessDeviceGetEnhancedConfigurationTypeListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceGetEnhancedConfigurationTypeRequest14 ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupAccessDeviceGetEnhancedConfigurationTypeRequest14',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceGetAvailableDetailListRequest19 ($x0, $x1, $x2, $x3) {
    return $self->send_query(
        'GroupAccessDeviceGetAvailableDetailListRequest19',
        serviceProviderId => $x0,
        groupId           => $x1,
        isMusicOnHold     => $x2,
        onlyVideoCapable  => $x3
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceGetListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupAccessDeviceGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceGetRequest18sp1 ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupAccessDeviceGetRequest18sp1',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceGetUserListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupAccessDeviceGetUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceModifyRequest14 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupAccessDeviceModifyRequest14',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceModifyUserRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupAccessDeviceModifyUserRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2,
        linePort          => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceResetRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupAccessDeviceResetRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupAnnouncementFileAddRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'GroupAnnouncementFileAddRequest',
        serviceProviderId    => $x0,
        groupId              => $x1,
        announcementFileName => $x2,
        announcementFile     => $x3
    );
}

# ----------------------------------------------------------------------
method GroupAnnouncementFileDeleteListRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'GroupAnnouncementFileDeleteListRequest',
        serviceProviderId   => $x0,
        groupId             => $x1,
        announcementFileKey => [ name => $x2, mediaFileType => $x3 ]
    );
}

# ----------------------------------------------------------------------
method GroupAnnouncementFileGetListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupAnnouncementFileGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAnnouncementFileGetRequest ($x0, $x1, $x2, $x3) {
    return $self->send_query(
        'GroupAnnouncementFileGetRequest',
        serviceProviderId   => $x0,
        groupId             => $x1,
        announcementFileKey => [ name => $x2, mediaFileType => $x3 ]
    );
}

# ----------------------------------------------------------------------
method GroupAnnouncementFileModifyRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupAnnouncementFileModifyRequest',
        serviceProviderId   => $x0,
        groupId             => $x1,
        announcementFileKey => [ name => $x2, mediaFileType => $x3 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDialableCallerIDCriteriaAddRequest ($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10, @generic_params) {
    return $self->send_command(
        'GroupDialableCallerIDCriteriaAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params,
        matchLocalCategory         => $x3,
        matchNationalCategory      => $x4,
        matchInterlataCategory     => $x5,
        matchIntralataCategory     => $x6,
        matchInternationalCategory => $x7,
        matchPrivateCategory       => $x8,
        matchEmergencyCategory     => $x9,
        matchOtherCategory         => $x10
    );
}

# ----------------------------------------------------------------------
method GroupDialableCallerIDCriteriaDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupDialableCallerIDCriteriaDeleteRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupDialableCallerIDCriteriaGetRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupDialableCallerIDCriteriaGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupDialableCallerIDCriteriaModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupDialableCallerIDCriteriaModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDialableCallerIDGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupDialableCallerIDGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDialableCallerIDModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupDialableCallerIDModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAddRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        defaultDomain     => $x2,
        userLimit         => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAdminAddRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupAdminAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        userId            => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAdminDeleteRequest ($x0) {
    return $self->send_command( 'GroupAdminDeleteRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method GroupAdminGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupAdminGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupAdminGetRequest ($x0) {
    return $self->send_query( 'GroupAdminGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method GroupAdminGetPolicyRequest20 ($x0) {
    return $self->send_query( 'GroupAdminGetPolicyRequest20', userId => $x0 );
}

# ----------------------------------------------------------------------
method GroupAdminModifyPolicyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupAdminModifyPolicyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAdminModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupAdminModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerAddRequest ($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10, @generic_params) {
    return $self->send_command(
        'GroupBroadWorksMobileManagerAddRequest',
        serviceProviderId     => $x0,
        groupId               => $x1,
        informationFile       => $x2,
        certificateFile       => $x3,
        isActive              => $x4,
        localToCarrier        => $x5,
        maxTxPerSecondEnabled => $x6,
        @generic_params,
        tldnEnabled                  => $x7,
        genericNumberEnabled         => $x8,
        mobileStateCheckEnabled      => $x9,
        locationBasedServicesEnabled => $x10
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupBroadWorksMobileManagerGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerGetDomainListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupBroadWorksMobileManagerGetDomainListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'GroupBroadWorksMobileManagerDeleteRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupBroadWorksMobileManagerModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerActivationRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupBroadWorksMobileManagerActivationRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        isActive          => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerSendCarrierFilesRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupBroadWorksMobileManagerSendCarrierFilesRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        emailTo           => $x2
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerAddHomeZoneRequest ($x0, $x1, $x2, $x3, $x4, $x5, $x6) {
    return $self->send_command(
        'GroupBroadWorksMobileManagerAddHomeZoneRequest',
        serviceProviderId  => $x0,
        groupId            => $x1,
        homeZoneDomainName => $x2,
        mobileCountryCode  => $x3,
        mobileNetworkCode  => $x4,
        locationAreaCode   => $x5,
        cellIdentity       => $x6
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerGetHomeZoneListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupBroadWorksMobileManagerGetHomeZoneListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerGetHomeZoneRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupBroadWorksMobileManagerGetHomeZoneRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        homeZoneId        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerDeleteHomeZoneRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupBroadWorksMobileManagerDeleteHomeZoneRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        homeZoneId        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerDeleteHomeZoneListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupBroadWorksMobileManagerDeleteHomeZoneListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        homeZoneId        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobileManagerModifyHomeZoneRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupBroadWorksMobileManagerModifyHomeZoneRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        homeZoneId        => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallProcessingGetPolicyRequest19sp1 ($x0, $x1) {
    return $self->send_query(
        'GroupCallProcessingGetPolicyRequest19sp1',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallProcessingModifyPolicyRequest15sp2 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallProcessingModifyPolicyRequest15sp2',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCommonPhoneListAddListRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'GroupCommonPhoneListAddListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        entry             => [ entryName => $x2, phoneNumber => $x3 ]
    );
}

# ----------------------------------------------------------------------
method GroupCommonPhoneListDeleteListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCommonPhoneListDeleteListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        entryName         => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCommonPhoneListGetListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCommonPhoneListGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCommonPhoneListModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCommonPhoneListModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        entryName         => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCommunicationBarringProfileModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCommunicationBarringProfileModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCommunicationBarringProfileGetAssignedListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCommunicationBarringProfileGetAssignedListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCommunicationBarringAuthorizationCodeAddListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCommunicationBarringAuthorizationCodeAddListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCommunicationBarringAuthorizationCodeDeleteListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCommunicationBarringAuthorizationCodeDeleteListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCommunicationBarringAuthorizationCodeGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCommunicationBarringAuthorizationCodeGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCommunicationBarringGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCommunicationBarringGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCommunicationBarringModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCommunicationBarringModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCPEConfigRebuildConfigFileRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCPEConfigRebuildConfigFileRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCPEConfigRebuildDeviceConfigFileRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCPEConfigRebuildDeviceConfigFileRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCPEConfigReorderDeviceLinePortsRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCPEConfigReorderDeviceLinePortsRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCPEConfigResetDeviceRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCPEConfigResetDeviceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceName        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCPEConfigResetDeviceTypeRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCPEConfigResetDeviceTypeRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCPEConfigSetConfigFileRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'GroupCPEConfigSetConfigFileRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2,
        configFile        => $x3
    );
}

# ----------------------------------------------------------------------
method GroupCustomContactDirectoryAddRequest17 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCustomContactDirectoryAddRequest17',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCustomContactDirectoryDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCustomContactDirectoryDeleteRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCustomContactDirectoryGetAvailableUserListRequest17 ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCustomContactDirectoryGetAvailableUserListRequest17',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCustomContactDirectoryGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCustomContactDirectoryGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCustomContactDirectoryGetRequest17 ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupCustomContactDirectoryGetRequest17',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCustomContactDirectoryModifyRequest17 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCustomContactDirectoryModifyRequest17',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'GroupDeleteRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDepartmentAddRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupDepartmentAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        departmentName    => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDepartmentAdminAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupDepartmentAdminAddRequest',
        departmentKey => $x0,
        userId        => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDepartmentAdminDeleteRequest ($x0) {
    return $self->send_command( 'GroupDepartmentAdminDeleteRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method GroupDepartmentAdminGetListRequest ($x0) {
    return $self->send_query( 'GroupDepartmentAdminGetListRequest', departmentKey => $x0 );
}

# ----------------------------------------------------------------------
method GroupDepartmentAdminGetRequest ($x0) {
    return $self->send_query( 'GroupDepartmentAdminGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method GroupDepartmentAdminModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupDepartmentAdminModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDepartmentDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupDepartmentDeleteRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        departmentName    => $x2
    );
}

# ----------------------------------------------------------------------
method GroupDepartmentGetAvailableParentListRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupDepartmentGetAvailableParentListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        departmentName    => $x2
    );
}

# ----------------------------------------------------------------------
method GroupDepartmentGetListRequest18 ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupDepartmentGetListRequest18',
        serviceProviderId            => $x0,
        groupId                      => $x1,
        includeEnterpriseDepartments => $x2
    );
}

# ----------------------------------------------------------------------
method GroupDepartmentGetRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupDepartmentGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        departmentName    => $x2
    );
}

# ----------------------------------------------------------------------
method GroupDepartmentModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupDepartmentModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        departmentName    => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDeviceManagementEventGetListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupDeviceManagementEventGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDeviceManagementInProgressAndPendingEventCancelRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupDeviceManagementInProgressAndPendingEventCancelRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDeviceTypeCustomTagAddRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupDeviceTypeCustomTagAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2,
        tagName           => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDeviceTypeCustomTagDeleteListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupDeviceTypeCustomTagDeleteListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDeviceTypeCustomTagModifyRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupDeviceTypeCustomTagModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2,
        tagName           => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDeviceTypeCustomTagGetListRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupDeviceTypeCustomTagGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupDeviceTypeFileModifyRequest14sp8 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupDeviceTypeFileModifyRequest14sp8',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2,
        fileFormat        => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDeviceTypeFileGetListRequest14sp8 ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupDeviceTypeFileGetListRequest14sp8',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupDeviceTypeFileGetRequest16sp1 ($x0, $x1, $x2, $x3) {
    return $self->send_query(
        'GroupDeviceTypeFileGetRequest16sp1',
        serviceProviderId => $x0,
        groupId           => $x1,
        deviceType        => $x2,
        fileFormat        => $x3
    );
}

# ----------------------------------------------------------------------
method GroupDialPlanPolicyGetRequest17 ($x0, $x1) {
    return $self->send_query(
        'GroupDialPlanPolicyGetRequest17',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDialPlanPolicyModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupDialPlanPolicyModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDialPlanPolicyGetAccessCodeListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupDialPlanPolicyGetAccessCodeListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDialPlanPolicyGetAccessCodeRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupDialPlanPolicyGetAccessCodeRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        accessCode        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupDialPlanPolicyAddAccessCodeRequest ($x0, $x1, $x2, $x3, $x4, $x5, @generic_params) {
    return $self->send_command(
        'GroupDialPlanPolicyAddAccessCodeRequest',
        serviceProviderId                           => $x0,
        groupId                                     => $x1,
        accessCode                                  => $x2,
        includeCodeForNetworkTranslationsAndRouting => $x3,
        includeCodeForScreeningServices             => $x4,
        enableSecondaryDialTone                     => $x5,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDialPlanPolicyDeleteAccessCodeRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupDialPlanPolicyDeleteAccessCodeRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        accessCode        => $x2
    );
}

# ----------------------------------------------------------------------
method GroupDialPlanPolicyModifyAccessCodeRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupDialPlanPolicyModifyAccessCodeRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        accessCode        => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDigitCollectionGetRequest13mp4 ($x0, $x1) {
    return $self->send_query(
        'GroupDigitCollectionGetRequest13mp4',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDigitCollectionModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupDigitCollectionModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDnActivateListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupDnActivateListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDnAssignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupDnAssignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDnDeactivateListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupDnDeactivateListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDnGetActivationListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupDnGetActivationListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDnGetAssignmentListRequest18 ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupDnGetAssignmentListRequest18',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDnGetDetailedAvailableListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupDnGetDetailedAvailableListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDnGetAvailableListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupDnGetAvailableListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDnGetAvailableRangesListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupDnGetAvailableRangesListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDnGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupDnGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDnGetSummaryListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupDnGetSummaryListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDnListAssignDepartmentRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupDnListAssignDepartmentRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDnUnassignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupDnUnassignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDomainAssignListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupDomainAssignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        domain            => $x2
    );
}

# ----------------------------------------------------------------------
method GroupDomainGetAssignedUserListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupDomainGetAssignedUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        domain            => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupDomainGetAssignedListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupDomainGetAssignedListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupDomainUnassignListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupDomainUnassignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        domain            => $x2
    );
}

# ----------------------------------------------------------------------
method GroupEndpointGetListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupEndpointGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupExchangeIntegrationGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupExchangeIntegrationGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupExchangeIntegrationModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupExchangeIntegrationModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupExistingUsersAssignUserServiceListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupExistingUsersAssignUserServiceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupExistingUsersUnassignUserServiceListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupExistingUsersUnassignUserServiceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupExtensionLengthGetRequest17 ($x0, $x1) {
    return $self->send_query(
        'GroupExtensionLengthGetRequest17',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupExtensionLengthModifyRequest17 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupExtensionLengthModifyRequest17',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFeatureAccessCodeGetRequest20 ($x0, $x1) {
    return $self->send_query(
        'GroupFeatureAccessCodeGetRequest20',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupFeatureAccessCodeModifyRequest20 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupFeatureAccessCodeModifyRequest20',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFileRepositoryDeviceUserAddRequest ($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7) {
    return $self->send_command(
        'GroupFileRepositoryDeviceUserAddRequest',
        serviceProviderId  => $x0,
        groupId            => $x1,
        fileRepositoryName => $x2,
        userName           => $x3,
        password           => $x4,
        allowPut           => $x5,
        allowDelete        => $x6,
        allowGet           => $x7
    );
}

# ----------------------------------------------------------------------
method GroupFileRepositoryDeviceUserDeleteRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'GroupFileRepositoryDeviceUserDeleteRequest',
        serviceProviderId  => $x0,
        groupId            => $x1,
        fileRepositoryName => $x2,
        userName           => $x3
    );
}

# ----------------------------------------------------------------------
method GroupFileRepositoryDeviceUserModifyRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupFileRepositoryDeviceUserModifyRequest',
        serviceProviderId  => $x0,
        groupId            => $x1,
        fileRepositoryName => $x2,
        userName           => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFileRepositoryDeviceUserGetListRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupFileRepositoryDeviceUserGetListRequest',
        serviceProviderId  => $x0,
        groupId            => $x1,
        fileRepositoryName => $x2
    );
}

# ----------------------------------------------------------------------
method GroupGetDefaultRequest ($x0) {
    return $self->send_query( 'GroupGetDefaultRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method GroupGetListInServiceProviderRequest ($x0, @generic_params) {
    return $self->send_query(
        'GroupGetListInServiceProviderRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGetListInSystemRequest (@generic_params) {
    return $self->send_query( 'GroupGetListInSystemRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupGetRequest14sp7 ($x0, $x1) {
    return $self->send_query(
        'GroupGetRequest14sp7',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupGetUserServiceAssignedUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupGetUserServiceAssignedUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupIMRNAssignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupIMRNAssignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupIMRNGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupIMRNGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupIMRNUnassignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupIMRNUnassignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupNetworkClassOfServiceAssignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupNetworkClassOfServiceAssignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupNetworkClassOfServiceAssignToAllUsersRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupNetworkClassOfServiceAssignToAllUsersRequest',
        serviceProviderId     => $x0,
        groupId               => $x1,
        networkClassOfService => $x2
    );
}

# ----------------------------------------------------------------------
method GroupNetworkClassOfServiceGetAssignedListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupNetworkClassOfServiceGetAssignedListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupNetworkClassOfServiceGetAssignedUserListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupNetworkClassOfServiceGetAssignedUserListRequest',
        serviceProviderId     => $x0,
        groupId               => $x1,
        networkClassOfService => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupNetworkClassOfServiceModifyDefaultRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupNetworkClassOfServiceModifyDefaultRequest',
        serviceProviderId     => $x0,
        groupId               => $x1,
        networkClassOfService => $x2
    );
}

# ----------------------------------------------------------------------
method GroupNetworkClassOfServiceUnassignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupNetworkClassOfServiceUnassignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupNewUserTemplateAssignUserServiceListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupNewUserTemplateAssignUserServiceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupNewUserTemplateUnassignUserServiceListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupNewUserTemplateUnassignUserServiceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOfficeZoneAssignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOfficeZoneAssignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOfficeZoneGetAssignedListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOfficeZoneGetAssignedListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOfficeZoneGetAssignedUserListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupOfficeZoneGetAssignedUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        officeZoneName    => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOfficeZoneUnassignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOfficeZoneUnassignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupPasswordRulesGetRequest16 ($x0, $x1) {
    return $self->send_query(
        'GroupPasswordRulesGetRequest16',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupPasswordRulesModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupPasswordRulesModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupPhoneDirectoryGetListRequest18 ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupPhoneDirectoryGetListRequest18',
        serviceProviderId       => $x0,
        groupId                 => $x1,
        isExtendedInfoRequested => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupPolicyGetRequest20 ($x0, $x1) {
    return $self->send_query(
        'GroupPolicyGetRequest20',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupPolicyModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupPolicyModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupServiceGetAuthorizationListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupServiceGetAuthorizationListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupServiceGetAuthorizedListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupServiceGetAuthorizedListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupServiceModifyAuthorizationListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupServiceModifyAuthorizationListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupPortalPasscodeRulesGetRequest19 ($x0, $x1) {
    return $self->send_query(
        'GroupPortalPasscodeRulesGetRequest19',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupPortalPasscodeRulesModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupPortalPasscodeRulesModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointExternalSystemAssignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupRoutePointExternalSystemAssignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointExternalSystemGetAssignedListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupRoutePointExternalSystemGetAssignedListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointExternalSystemGetAssignedRoutePointListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupRoutePointExternalSystemGetAssignedRoutePointListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        externalSystem    => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointExternalSystemUnassignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupRoutePointExternalSystemUnassignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutingProfileGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupRoutingProfileGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupRoutingProfileModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupRoutingProfileModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupScheduleAddEventRequest ($x0, $x1, $x2, $x3, $x4, $x5, @generic_params) {
    return $self->send_command(
        'GroupScheduleAddEventRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        scheduleKey       => [ scheduleName => $x2, scheduleType => $x3 ],
        eventName         => $x4,
        startDate         => $x5,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupScheduleAddRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'GroupScheduleAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        scheduleName      => $x2,
        scheduleType      => $x3
    );
}

# ----------------------------------------------------------------------
method GroupScheduleDeleteEventListRequest ($x0, $x1, $x2, $x3, $x4) {
    return $self->send_command(
        'GroupScheduleDeleteEventListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        scheduleKey       => [ scheduleName => $x2, scheduleType => $x3 ],
        eventName         => $x4
    );
}

# ----------------------------------------------------------------------
method GroupScheduleDeleteListRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'GroupScheduleDeleteListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        scheduleKey       => [ scheduleName => $x2, scheduleType => $x3 ]
    );
}

# ----------------------------------------------------------------------
method GroupScheduleGetEventListRequest ($x0, $x1, $x2, $x3) {
    return $self->send_query(
        'GroupScheduleGetEventListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        scheduleKey       => [ scheduleName => $x2, scheduleType => $x3 ]
    );
}

# ----------------------------------------------------------------------
method GroupScheduleGetEventRequest ($x0, $x1, $x2, $x3, $x4) {
    return $self->send_query(
        'GroupScheduleGetEventRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        scheduleKey       => [ scheduleName => $x2, scheduleType => $x3 ],
        eventName         => $x4
    );
}

# ----------------------------------------------------------------------
method GroupScheduleGetListRequest17sp1 ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupScheduleGetListRequest17sp1',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupScheduleModifyEventRequest ($x0, $x1, $x2, $x3, $x4, @generic_params) {
    return $self->send_command(
        'GroupScheduleModifyEventRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        scheduleKey       => [ scheduleName => $x2, scheduleType => $x3 ],
        eventName         => $x4,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupScheduleModifyRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupScheduleModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        scheduleKey       => [ scheduleName => $x2, scheduleType => $x3 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupServiceAssignListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupServiceAssignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        serviceName       => $x2
    );
}

# ----------------------------------------------------------------------
method GroupServiceIsAssignedRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupServiceIsAssignedRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        serviceName       => $x2
    );
}

# ----------------------------------------------------------------------
method GroupServiceUnassignListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupServiceUnassignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        serviceName       => $x2
    );
}

# ----------------------------------------------------------------------
method GroupSessionAdmissionControlGetAvailableDeviceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupSessionAdmissionControlGetAvailableDeviceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupSessionAdmissionControlGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupSessionAdmissionControlGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupSessionAdmissionControlModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupSessionAdmissionControlModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupSessionAdmissionControlGroupAddDeviceListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupSessionAdmissionControlGroupAddDeviceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupSessionAdmissionControlGroupAddRequest19sp1 ($x0, $x1, $x2, $x3, $x4, @generic_params) {
    return $self->send_command(
        'GroupSessionAdmissionControlGroupAddRequest19sp1',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        maxSession        => $x3,
        @generic_params, blockEmergencyAndRepairCallsDueToSACLimits => $x4
    );
}

# ----------------------------------------------------------------------
method GroupSessionAdmissionControlGroupDeleteDeviceListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupSessionAdmissionControlGroupDeleteDeviceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupSessionAdmissionControlGroupDeleteListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupSessionAdmissionControlGroupDeleteListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupSessionAdmissionControlGroupGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupSessionAdmissionControlGroupGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupSessionAdmissionControlGroupGetRequest19sp1 ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupSessionAdmissionControlGroupGetRequest19sp1',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupSessionAdmissionControlGroupModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupSessionAdmissionControlGroupModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupShInterfaceGetUserListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupShInterfaceGetUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupGetAvailableDetailListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupTrunkGroupGetAvailableDetailListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupApplicationServerSetModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupApplicationServerSetModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupApplicationServerSetGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupApplicationServerSetGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupAccessDeviceAvailablePortGetListRequest ($x0, $x1, $x2, $x3) {
    return $self->send_query(
        'GroupAccessDeviceAvailablePortGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        accessDevice      => [ deviceLevel => $x2, deviceName => $x3 ]
    );
}

# ----------------------------------------------------------------------
##
## Login
##
method AuthenticationRequest ($x0) {
    return $self->send_query( 'AuthenticationRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method AuthenticationVerifyRequest14sp8 (@generic_params) {
    return $self->send_query( 'AuthenticationVerifyRequest14sp8', @generic_params );
}

# ----------------------------------------------------------------------
method AvailabilityTestRequest () {
    return $self->send_command(
        'AvailabilityTestRequest',

    );
}

# ----------------------------------------------------------------------
method DeviceManagementFileAuthLocationGetRequest18 ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'DeviceManagementFileAuthLocationGetRequest18',
        deviceAccessProtocol => $x0,
        deviceAccessMethod   => $x1,
        deviceAccessURI      => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method DeviceManagementPutFileRequest ($x0, $x1) {
    return $self->send_command(
        'DeviceManagementPutFileRequest',
        deviceAccessURI => $x0,
        ipAddress       => $x1
    );
}

# ----------------------------------------------------------------------
method ExternalAuthenticationAuthorizeTokenRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ExternalAuthenticationAuthorizeTokenRequest',
        userId => $x0,
        @generic_params, loginToken => $x1
    );
}

# ----------------------------------------------------------------------
method ExternalAuthenticationCreateLoginTokenRequest ($x0) {
    return $self->send_query( 'ExternalAuthenticationCreateLoginTokenRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method LoginRequest14sp4 ($x0, @generic_params) {
    return $self->send_query(
        'LoginRequest14sp4',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method LogoutRequest ($x0, @generic_params) {
    return $self->send_command(
        'LogoutRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method PasswordModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'PasswordModifyRequest',
        userId => $x0,
        @generic_params, newPassword => $x1
    );
}

# ----------------------------------------------------------------------
method PrimaryInfoGetRequest ($x0, $x1) {
    return $self->send_query(
        'PrimaryInfoGetRequest',
        isPrivate              => $x0,
        isAddressInfoRequested => $x1
    );
}

# ----------------------------------------------------------------------
method PublicClusterGetFullyQualifiedDomainNameRequest () {
    return $self->send_query(
        'PublicClusterGetFullyQualifiedDomainNameRequest',

    );
}

# ----------------------------------------------------------------------
method TutorialFlagGetRequest ($x0) {
    return $self->send_query( 'TutorialFlagGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method TutorialFlagModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'TutorialFlagModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserGetLoginInfoRequest (@generic_params) {
    return $self->send_query( 'UserGetLoginInfoRequest', @generic_params );
}

# ----------------------------------------------------------------------
method VerifySessionIsValidRequest () {
    return $self->send_command(
        'VerifySessionIsValidRequest',

    );
}

# ----------------------------------------------------------------------
##
## SearchCriteria
##
##
## ServiceProvider
##
method ServiceProviderAccessDeviceAddRequest14 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'ServiceProviderAccessDeviceAddRequest14',
        serviceProviderId => $x0,
        deviceName        => $x1,
        deviceType        => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceCustomTagAddRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'ServiceProviderAccessDeviceCustomTagAddRequest',
        serviceProviderId => $x0,
        deviceName        => $x1,
        tagName           => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceCustomTagDeleteListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderAccessDeviceCustomTagDeleteListRequest',
        serviceProviderId => $x0,
        deviceName        => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceCustomTagGetListRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderAccessDeviceCustomTagGetListRequest',
        serviceProviderId => $x0,
        deviceName        => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceCustomTagModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'ServiceProviderAccessDeviceCustomTagModifyRequest',
        serviceProviderId => $x0,
        deviceName        => $x1,
        tagName           => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderAccessDeviceDeleteRequest',
        serviceProviderId => $x0,
        deviceName        => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceFileModifyRequest14sp8 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'ServiceProviderAccessDeviceFileModifyRequest14sp8',
        serviceProviderId => $x0,
        deviceName        => $x1,
        fileFormat        => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceFileGetListRequest14sp8 ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderAccessDeviceFileGetListRequest14sp8',
        serviceProviderId => $x0,
        deviceName        => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceFileGetRequest20 ($x0, $x1, $x2) {
    return $self->send_query(
        'ServiceProviderAccessDeviceFileGetRequest20',
        serviceProviderId => $x0,
        deviceName        => $x1,
        fileFormat        => $x2
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'ServiceProviderAccessDeviceGetListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceGetRequest18sp1 ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderAccessDeviceGetRequest18sp1',
        serviceProviderId => $x0,
        deviceName        => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceGetUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'ServiceProviderAccessDeviceGetUserListRequest',
        serviceProviderId => $x0,
        deviceName        => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceModifyRequest14 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderAccessDeviceModifyRequest14',
        serviceProviderId => $x0,
        deviceName        => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceModifyUserRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'ServiceProviderAccessDeviceModifyUserRequest',
        serviceProviderId => $x0,
        deviceName        => $x1,
        linePort          => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAccessDeviceResetRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderAccessDeviceResetRequest',
        serviceProviderId => $x0,
        deviceName        => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAddRequest13mp2 (@generic_params) {
    return $self->send_command( 'ServiceProviderAddRequest13mp2', @generic_params );
}

# ----------------------------------------------------------------------
method ServiceProviderAdminAddRequest14 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'ServiceProviderAdminAddRequest14',
        serviceProviderId => $x0,
        userId            => $x1,
        @generic_params, administratorType => $x2
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAdminDeleteRequest ($x0) {
    return $self->send_command( 'ServiceProviderAdminDeleteRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderAdminGetListRequest14 ($x0) {
    return $self->send_query( 'ServiceProviderAdminGetListRequest14', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderAdminGetPolicyRequest20 ($x0) {
    return $self->send_query( 'ServiceProviderAdminGetPolicyRequest20', userId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderAdminGetRequest14 ($x0) {
    return $self->send_query( 'ServiceProviderAdminGetRequest14', userId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderAdminModifyPolicyRequest14 ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderAdminModifyPolicyRequest14',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAdminModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderAdminModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderAnswerConfirmationGetRequest16 ($x0) {
    return $self->send_query( 'ServiceProviderAnswerConfirmationGetRequest16', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderAnswerConfirmationModifyRequest16 ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderAnswerConfirmationModifyRequest16',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCallProcessingGetPolicyRequest19sp1 ($x0) {
    return $self->send_query( 'ServiceProviderCallProcessingGetPolicyRequest19sp1', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderCallProcessingModifyPolicyRequest15 ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderCallProcessingModifyPolicyRequest15',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringCriteriaAssignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderCommunicationBarringCriteriaAssignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringCriteriaGetAssignedListRequest ($x0) {
    return $self->send_query( 'ServiceProviderCommunicationBarringCriteriaGetAssignedListRequest',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringCriteriaUnassignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderCommunicationBarringCriteriaUnassignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringDigitPatternCriteriaAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderCommunicationBarringDigitPatternCriteriaAddRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringDigitPatternCriteriaDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderCommunicationBarringDigitPatternCriteriaDeleteRequest',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringDigitPatternCriteriaGetListRequest ($x0) {
    return $self->send_query( 'ServiceProviderCommunicationBarringDigitPatternCriteriaGetListRequest',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringDigitPatternCriteriaGetPatternListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'ServiceProviderCommunicationBarringDigitPatternCriteriaGetPatternListRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringDigitPatternCriteriaGetRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderCommunicationBarringDigitPatternCriteriaGetRequest',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringDigitPatternCriteriaModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderCommunicationBarringDigitPatternCriteriaModifyRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringIncomingCriteriaAssignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderCommunicationBarringIncomingCriteriaAssignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListRequest ($x0) {
    return $self->send_query( 'ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListRequest',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringIncomingCriteriaUnassignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderCommunicationBarringIncomingCriteriaUnassignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringProfileAddRequest19sp1 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'ServiceProviderCommunicationBarringProfileAddRequest19sp1',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params,
        becomeDefault                => $x2,
        applyToAttendedCallTransfers => $x3
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringProfileDeleteRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderCommunicationBarringProfileDeleteRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringProfileGetAssignedGroupListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'ServiceProviderCommunicationBarringProfileGetAssignedGroupListRequest',
        serviceProviderId => $x0,
        profile           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringProfileGetCriteriaUsageListRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderCommunicationBarringProfileGetCriteriaUsageListRequest',
        serviceProviderId => $x0,
        criteriaName      => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListRequest',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringProfileGetIncomingCriteriaUsageListRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderCommunicationBarringProfileGetIncomingCriteriaUsageListRequest',
        serviceProviderId => $x0,
        criteriaName      => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringProfileGetListRequest ($x0) {
    return $self->send_query( 'ServiceProviderCommunicationBarringProfileGetListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringProfileGetRequest19sp1 ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderCommunicationBarringProfileGetRequest19sp1',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringProfileGetRequest19sp1V2 ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderCommunicationBarringProfileGetRequest19sp1V2',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringProfileModifyDefaultRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderCommunicationBarringProfileModifyDefaultRequest',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCommunicationBarringProfileModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderCommunicationBarringProfileModifyRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCPEConfigRebuildDeviceConfigFileRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderCPEConfigRebuildDeviceConfigFileRequest',
        serviceProviderId => $x0,
        deviceName        => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCPEConfigResetDeviceRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderCPEConfigResetDeviceRequest',
        serviceProviderId => $x0,
        deviceName        => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderCPEConfigReorderDeviceLinePortsRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderCPEConfigReorderDeviceLinePortsRequest',
        serviceProviderId => $x0,
        deviceName        => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDeleteRequest ($x0) {
    return $self->send_command( 'ServiceProviderDeleteRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderDeviceManagementEventGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'ServiceProviderDeviceManagementEventGetListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDeviceManagementInProgressAndPendingEventCancelRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderDeviceManagementInProgressAndPendingEventCancelRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDeviceProfileAuthenticationPasswordRulesGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderDeviceProfileAuthenticationPasswordRulesGetRequest',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderDeviceProfileAuthenticationPasswordRulesModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderDeviceProfileAuthenticationPasswordRulesModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDialableCallerIDCriteriaAddRequest ($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, $x9, @generic_params) {
    return $self->send_command(
        'ServiceProviderDialableCallerIDCriteriaAddRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params,
        matchLocalCategory         => $x2,
        matchNationalCategory      => $x3,
        matchInterlataCategory     => $x4,
        matchIntralataCategory     => $x5,
        matchInternationalCategory => $x6,
        matchPrivateCategory       => $x7,
        matchEmergencyCategory     => $x8,
        matchOtherCategory         => $x9
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDialableCallerIDCriteriaDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderDialableCallerIDCriteriaDeleteRequest',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDialableCallerIDCriteriaGetRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderDialableCallerIDCriteriaGetRequest',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDialableCallerIDCriteriaModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderDialableCallerIDCriteriaModifyRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDialableCallerIDGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderDialableCallerIDGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderDialableCallerIDModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderDialableCallerIDModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDialPlanPolicyGetRequest17 ($x0) {
    return $self->send_query( 'ServiceProviderDialPlanPolicyGetRequest17', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderDialPlanPolicyModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderDialPlanPolicyModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDialPlanPolicyGetAccessCodeListRequest ($x0) {
    return $self->send_query( 'ServiceProviderDialPlanPolicyGetAccessCodeListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderDialPlanPolicyGetAccessCodeRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderDialPlanPolicyGetAccessCodeRequest',
        serviceProviderId => $x0,
        accessCode        => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDialPlanPolicyAddAccessCodeRequest ($x0, $x1, $x2, $x3, $x4, @generic_params) {
    return $self->send_command(
        'ServiceProviderDialPlanPolicyAddAccessCodeRequest',
        serviceProviderId                           => $x0,
        accessCode                                  => $x1,
        includeCodeForNetworkTranslationsAndRouting => $x2,
        includeCodeForScreeningServices             => $x3,
        enableSecondaryDialTone                     => $x4,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDialPlanPolicyDeleteAccessCodeRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderDialPlanPolicyDeleteAccessCodeRequest',
        serviceProviderId => $x0,
        accessCode        => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDialPlanPolicyModifyAccessCodeRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderDialPlanPolicyModifyAccessCodeRequest',
        serviceProviderId => $x0,
        accessCode        => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDigitCollectionGetRequest13mp4 ($x0) {
    return $self->send_query( 'ServiceProviderDigitCollectionGetRequest13mp4', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderDigitCollectionModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderDigitCollectionModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDnAddListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderDnAddListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDnDeleteListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderDnDeleteListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDnGetAvailableListRequest ($x0) {
    return $self->send_query( 'ServiceProviderDnGetAvailableListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderDnGetSummaryListRequest ($x0) {
    return $self->send_query( 'ServiceProviderDnGetSummaryListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderDomainAssignListRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderDomainAssignListRequest',
        serviceProviderId => $x0,
        domain            => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDomainGetAssignedGroupListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'ServiceProviderDomainGetAssignedGroupListRequest',
        serviceProviderId => $x0,
        domain            => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderDomainGetAssignedListRequest ($x0) {
    return $self->send_query( 'ServiceProviderDomainGetAssignedListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderDomainUnassignListRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderDomainUnassignListRequest',
        serviceProviderId => $x0,
        domain            => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderEndpointGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'ServiceProviderEndpointGetListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderFeatureAccessCodeGetListRequest20 ($x0) {
    return $self->send_query( 'ServiceProviderFeatureAccessCodeGetListRequest20', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderFeatureAccessCodeModifyListRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderFeatureAccessCodeModifyListRequest20',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderFileRepositoryDeviceUserAddRequest ($x0, $x1, $x2, $x3, $x4, $x5, $x6) {
    return $self->send_command(
        'ServiceProviderFileRepositoryDeviceUserAddRequest',
        serviceProviderId  => $x0,
        fileRepositoryName => $x1,
        userName           => $x2,
        password           => $x3,
        allowPut           => $x4,
        allowDelete        => $x5,
        allowGet           => $x6
    );
}

# ----------------------------------------------------------------------
method ServiceProviderFileRepositoryDeviceUserDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'ServiceProviderFileRepositoryDeviceUserDeleteRequest',
        serviceProviderId  => $x0,
        fileRepositoryName => $x1,
        userName           => $x2
    );
}

# ----------------------------------------------------------------------
method ServiceProviderFileRepositoryDeviceUserModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'ServiceProviderFileRepositoryDeviceUserModifyRequest',
        serviceProviderId  => $x0,
        fileRepositoryName => $x1,
        userName           => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderFileRepositoryDeviceUserGetListRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderFileRepositoryDeviceUserGetListRequest',
        serviceProviderId  => $x0,
        fileRepositoryName => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderGetDefaultRequest () {
    return $self->send_query(
        'ServiceProviderGetDefaultRequest',

    );
}

# ----------------------------------------------------------------------
method ServiceProviderGetListRequest (@generic_params) {
    return $self->send_query( 'ServiceProviderGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method ServiceProviderGetRequest17sp1 ($x0) {
    return $self->send_query( 'ServiceProviderGetRequest17sp1', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderIMRNAssignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderIMRNAssignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderIMRNGetListRequest ($x0) {
    return $self->send_query( 'ServiceProviderIMRNGetListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderIMRNUnassignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderIMRNUnassignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderNetworkClassOfServiceModifyDefaultRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderNetworkClassOfServiceModifyDefaultRequest',
        serviceProviderId     => $x0,
        networkClassOfService => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderNetworkClassOfServiceAssignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderNetworkClassOfServiceAssignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderNetworkClassOfServiceAssignListToAllGroupsRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderNetworkClassOfServiceAssignListToAllGroupsRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderNetworkClassOfServiceAssignToAllUsersRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderNetworkClassOfServiceAssignToAllUsersRequest',
        serviceProviderId     => $x0,
        networkClassOfService => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderNetworkClassOfServiceGetAssignedListRequest ($x0) {
    return $self->send_query( 'ServiceProviderNetworkClassOfServiceGetAssignedListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderNetworkClassOfServiceGetAssignedGroupListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'ServiceProviderNetworkClassOfServiceGetAssignedGroupListRequest',
        serviceProviderId     => $x0,
        networkClassOfService => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderNetworkClassOfServiceUnassignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderNetworkClassOfServiceUnassignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderNumberPortabilityQueryGetRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'ServiceProviderNumberPortabilityQueryGetRequest',
        serviceProviderId    => $x0,
        includeDigitPatterns => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderNumberPortabilityQueryModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderNumberPortabilityQueryModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderNumberPortabilityQueryAddListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderNumberPortabilityQueryAddListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderOfficeZoneAssignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderOfficeZoneAssignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderOfficeZoneGetAssignedListRequest ($x0) {
    return $self->send_query( 'ServiceProviderOfficeZoneGetAssignedListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderOfficeZoneGetAssignedGroupListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'ServiceProviderOfficeZoneGetAssignedGroupListRequest',
        serviceProviderId => $x0,
        officeZoneName    => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderOfficeZoneUnassignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderOfficeZoneUnassignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderPortalPasscodeRulesGetRequest19 ($x0) {
    return $self->send_query( 'ServiceProviderPortalPasscodeRulesGetRequest19', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderPortalPasscodeRulesModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderPortalPasscodeRulesModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderPasswordRulesGetRequest16 ($x0) {
    return $self->send_query( 'ServiceProviderPasswordRulesGetRequest16', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderPasswordRulesModifyRequest14sp3 ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderPasswordRulesModifyRequest14sp3',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderRoutePointExternalSystemAssignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderRoutePointExternalSystemAssignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderRoutePointExternalSystemGetAssignedGroupListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'ServiceProviderRoutePointExternalSystemGetAssignedGroupListRequest',
        serviceProviderId => $x0,
        externalSystem    => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderRoutePointExternalSystemGetAssignedListRequest ($x0) {
    return $self->send_query( 'ServiceProviderRoutePointExternalSystemGetAssignedListRequest',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderRoutePointExternalSystemUnassignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderRoutePointExternalSystemUnassignListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderRoutingProfileGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderRoutingProfileGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderRoutingProfileModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderRoutingProfileModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderScheduleAddEventRequest ($x0, $x1, $x2, $x3, $x4, @generic_params) {
    return $self->send_command(
        'ServiceProviderScheduleAddEventRequest',
        serviceProviderId => $x0,
        scheduleKey       => [ scheduleName => $x1, scheduleType => $x2 ],
        eventName         => $x3,
        startDate         => $x4,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderScheduleAddRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'ServiceProviderScheduleAddRequest',
        serviceProviderId => $x0,
        scheduleName      => $x1,
        scheduleType      => $x2
    );
}

# ----------------------------------------------------------------------
method ServiceProviderScheduleDeleteEventListRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'ServiceProviderScheduleDeleteEventListRequest',
        serviceProviderId => $x0,
        scheduleKey       => [ scheduleName => $x1, scheduleType => $x2 ],
        eventName         => $x3
    );
}

# ----------------------------------------------------------------------
method ServiceProviderScheduleDeleteListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'ServiceProviderScheduleDeleteListRequest',
        serviceProviderId => $x0,
        scheduleKey       => [ scheduleName => $x1, scheduleType => $x2 ]
    );
}

# ----------------------------------------------------------------------
method ServiceProviderScheduleGetEventListRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'ServiceProviderScheduleGetEventListRequest',
        serviceProviderId => $x0,
        scheduleKey       => [ scheduleName => $x1, scheduleType => $x2 ]
    );
}

# ----------------------------------------------------------------------
method ServiceProviderScheduleGetEventRequest ($x0, $x1, $x2, $x3) {
    return $self->send_query(
        'ServiceProviderScheduleGetEventRequest',
        serviceProviderId => $x0,
        scheduleKey       => [ scheduleName => $x1, scheduleType => $x2 ],
        eventName         => $x3
    );
}

# ----------------------------------------------------------------------
method ServiceProviderScheduleGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'ServiceProviderScheduleGetListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderScheduleModifyEventRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'ServiceProviderScheduleModifyEventRequest',
        serviceProviderId => $x0,
        scheduleKey       => [ scheduleName => $x1, scheduleType => $x2 ],
        eventName         => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderScheduleModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'ServiceProviderScheduleModifyRequest',
        serviceProviderId => $x0,
        scheduleKey       => [ scheduleName => $x1, scheduleType => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServiceGetAuthorizationListRequest ($x0) {
    return $self->send_query( 'ServiceProviderServiceGetAuthorizationListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderServiceGetUserAssignableListRequest ($x0) {
    return $self->send_query( 'ServiceProviderServiceGetUserAssignableListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderServiceModifyAuthorizationListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderServiceModifyAuthorizationListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderServicePackAddRequest',
        serviceProviderId => $x0,
        servicePackName   => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackAddServiceListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'ServiceProviderServicePackAddServiceListRequest',
        serviceProviderId => $x0,
        servicePackName   => $x1,
        serviceName       => $x2
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderServicePackDeleteRequest',
        serviceProviderId => $x0,
        servicePackName   => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackGetDetailListRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderServicePackGetDetailListRequest',
        serviceProviderId => $x0,
        servicePackName   => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackGetListRequest ($x0) {
    return $self->send_query( 'ServiceProviderServicePackGetListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackGetServiceUsageListRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderServicePackGetServiceUsageListRequest',
        serviceProviderId => $x0,
        serviceName       => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackGetUtilizationListRequest ($x0) {
    return $self->send_query( 'ServiceProviderServicePackGetUtilizationListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskAddRequest ($x0, $x1, $x2, $x3, $x4, $x5, $x6, @generic_params) {
    return $self->send_command(
        'ServiceProviderServicePackMigrationTaskAddRequest',
        serviceProviderId => $x0,
        taskName          => $x1,
        startTimestamp    => $x2,
        maxDurationHours  => $x3,
        sendReportEmail   => $x4,
        @generic_params,
        reportAllUsers                        => $x5,
        automaticallyIncrementServiceQuantity => $x6
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskCopyRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderServicePackMigrationTaskCopyRequest',
        serviceProviderId => $x0,
        taskName          => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderServicePackMigrationTaskDeleteRequest',
        serviceProviderId => $x0,
        taskName          => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskGetAvailableGroupListRequest ($x0, @generic_params) {
    return $self->send_query(
        'ServiceProviderServicePackMigrationTaskGetAvailableGroupListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskGetListRequest ($x0) {
    return $self->send_query( 'ServiceProviderServicePackMigrationTaskGetListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskGetRequest14sp4 ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderServicePackMigrationTaskGetRequest14sp4',
        serviceProviderId => $x0,
        taskName          => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskModifyAssignmentListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderServicePackMigrationTaskModifyAssignmentListRequest',
        serviceProviderId => $x0,
        taskName          => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskModifyGroupListRequest (@generic_params) {
    return $self->send_query( 'ServiceProviderServicePackMigrationTaskModifyGroupListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskModifyRemovalListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderServicePackMigrationTaskModifyRemovalListRequest',
        serviceProviderId => $x0,
        taskName          => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderServicePackMigrationTaskModifyRequest',
        serviceProviderId => $x0,
        taskName          => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskModifyUserSelectionRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderServicePackMigrationTaskModifyUserSelectionRequest',
        serviceProviderId => $x0,
        taskName          => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackMigrationTaskTerminateRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderServicePackMigrationTaskTerminateRequest',
        serviceProviderId => $x0,
        taskName          => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderServicePackModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderServicePackModifyRequest',
        serviceProviderId => $x0,
        servicePackName   => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderSessionAdmissionControlGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderSessionAdmissionControlGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderSessionAdmissionControlModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderSessionAdmissionControlModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderSessionAdmissionControlWhiteListGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderSessionAdmissionControlWhiteListGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderSessionAdmissionControlWhiteListModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderSessionAdmissionControlWhiteListModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderLanguageAddRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderLanguageAddRequest',
        serviceProviderId => $x0,
        language          => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderLanguageModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderLanguageModifyRequest',
        serviceProviderId => $x0,
        language          => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderLanguageDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderLanguageDeleteRequest',
        serviceProviderId => $x0,
        language          => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderLanguageGetListRequest ($x0) {
    return $self->send_query( 'ServiceProviderLanguageGetListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderLanguageGetAvailableListRequest ($x0) {
    return $self->send_query( 'ServiceProviderLanguageGetAvailableListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderSIPAuthenticationPasswordRulesGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderSIPAuthenticationPasswordRulesGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderSIPAuthenticationPasswordRulesModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderSIPAuthenticationPasswordRulesModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderApplicationServerSetModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'ServiceProviderApplicationServerSetModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderApplicationServerSetGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderApplicationServerSetGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
##
## SortCriteria
##
##
## System
##
method SystemAccessDeviceAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemAccessDeviceAddRequest',
        deviceName => $x0,
        deviceType => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceCustomTagAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemAccessDeviceCustomTagAddRequest',
        deviceName => $x0,
        tagName    => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceCustomTagDeleteListRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemAccessDeviceCustomTagDeleteListRequest',
        deviceName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceCustomTagGetListRequest ($x0) {
    return $self->send_query( 'SystemAccessDeviceCustomTagGetListRequest', deviceName => $x0 );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceCustomTagModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemAccessDeviceCustomTagModifyRequest',
        deviceName => $x0,
        tagName    => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceDeleteRequest ($x0) {
    return $self->send_command( 'SystemAccessDeviceDeleteRequest', deviceName => $x0 );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceFileModifyRequest14sp8 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemAccessDeviceFileModifyRequest14sp8',
        deviceName => $x0,
        fileFormat => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceFileGetListRequest14sp8 ($x0) {
    return $self->send_query( 'SystemAccessDeviceFileGetListRequest14sp8', deviceName => $x0 );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceFileGetRequest20 ($x0, $x1) {
    return $self->send_query(
        'SystemAccessDeviceFileGetRequest20',
        deviceName => $x0,
        fileFormat => $x1
    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceGetAllRequest (@generic_params) {
    return $self->send_query( 'SystemAccessDeviceGetAllRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceGetListRequest14 (@generic_params) {
    return $self->send_query( 'SystemAccessDeviceGetListRequest14', @generic_params );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceGetRequest18sp1 ($x0) {
    return $self->send_query( 'SystemAccessDeviceGetRequest18sp1', deviceName => $x0 );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceGetUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemAccessDeviceGetUserListRequest',
        deviceName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemAccessDeviceModifyRequest',
        deviceName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceModifyUserRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemAccessDeviceModifyUserRequest',
        deviceName => $x0,
        linePort   => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceMonitorAddDeviceTypeRequest (@generic_params) {
    return $self->send_command( 'SystemAccessDeviceMonitorAddDeviceTypeRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceMonitorDeleteDeviceTypeRequest (@generic_params) {
    return $self->send_command( 'SystemAccessDeviceMonitorDeleteDeviceTypeRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceMonitorGetDeviceTypeListRequest () {
    return $self->send_query(
        'SystemAccessDeviceMonitorGetDeviceTypeListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceMonitorParametersGetRequest () {
    return $self->send_query(
        'SystemAccessDeviceMonitorParametersGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceMonitorParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemAccessDeviceMonitorParametersModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceResetRequest ($x0) {
    return $self->send_command( 'SystemAccessDeviceResetRequest', deviceName => $x0 );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceTypeGetEnhancedConfigurableListRequest () {
    return $self->send_query(
        'SystemAccessDeviceTypeGetEnhancedConfigurableListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAccessDeviceTypeGetListRequest () {
    return $self->send_query(
        'SystemAccessDeviceTypeGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAccountingAddChargingFunctionElementServerRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'SystemAccountingAddChargingFunctionElementServerRequest',
        address              => $x0,
        isNetAddressExtended => $x1,
        type                 => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccountingAddRadiusServerRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemAccountingAddRadiusServerRequest',
        netAddress => $x0,
        port       => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccountingDeleteChargingFunctionElementServerRequest ($x0) {
    return $self->send_command( 'SystemAccountingDeleteChargingFunctionElementServerRequest', address => $x0 );
}

# ----------------------------------------------------------------------
method SystemAccountingDeleteRadiusServerRequest ($x0, $x1) {
    return $self->send_command(
        'SystemAccountingDeleteRadiusServerRequest',
        netAddress => $x0,
        port       => $x1
    );
}

# ----------------------------------------------------------------------
method SystemAccountingGetChargingFunctionElementServerListRequest () {
    return $self->send_query(
        'SystemAccountingGetChargingFunctionElementServerListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAccountingGetRadiusServerListRequest () {
    return $self->send_query(
        'SystemAccountingGetRadiusServerListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAccountingInhibitedAttributeValuePairCodeAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemAccountingInhibitedAttributeValuePairCodeAddRequest',
        attributeValuePairCode => $x0,
        vendorId               => $x1
    );
}

# ----------------------------------------------------------------------
method SystemAccountingInhibitedAttributeValuePairCodeDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'SystemAccountingInhibitedAttributeValuePairCodeDeleteRequest',
        attributeValuePairCode => $x0,
        vendorId               => $x1
    );
}

# ----------------------------------------------------------------------
method SystemAccountingInhibitedAttributeValuePairCodeGetListRequest () {
    return $self->send_query(
        'SystemAccountingInhibitedAttributeValuePairCodeGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAccountingModifyChargingFunctionElementServerRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemAccountingModifyChargingFunctionElementServerRequest',
        address => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccountingModifyRadiusServerRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemAccountingModifyRadiusServerRequest',
        netAddress => $x0,
        port       => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAccountingReorderChargingFunctionElementServerRequest (@generic_params) {
    return $self->send_command( 'SystemAccountingReorderChargingFunctionElementServerRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemAdminAddRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'SystemAdminAddRequest',
        userId => $x0,
        @generic_params,
        adminType => $x1,
        readOnly  => $x2
    );
}

# ----------------------------------------------------------------------
method SystemAdminDeleteRequest ($x0) {
    return $self->send_command( 'SystemAdminDeleteRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method SystemAdminGetListRequest () {
    return $self->send_query(
        'SystemAdminGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAdminGetRequest ($x0) {
    return $self->send_query( 'SystemAdminGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method SystemAdminModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemAdminModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAliasAddRequest ($x0) {
    return $self->send_command( 'SystemAliasAddRequest', aliasNetAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemAliasDeleteRequest ($x0) {
    return $self->send_command( 'SystemAliasDeleteRequest', aliasNetAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemAliasGetListRequest () {
    return $self->send_query(
        'SystemAliasGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemApplicationControllerAddRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'SystemApplicationControllerAddRequest',
        name         => $x0,
        subscriberId => $x1,
        channelSetId => $x2
    );
}

# ----------------------------------------------------------------------
method SystemApplicationControllerDeleteRequest ($x0) {
    return $self->send_command( 'SystemApplicationControllerDeleteRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemApplicationControllerGetListRequest () {
    return $self->send_query(
        'SystemApplicationControllerGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemASRParametersGetRequest14sp7 () {
    return $self->send_query(
        'SystemASRParametersGetRequest14sp7',

    );
}

# ----------------------------------------------------------------------
method SystemASRParametersModifyRequest14sp7 (@generic_params) {
    return $self->send_command( 'SystemASRParametersModifyRequest14sp7', @generic_params );
}

# ----------------------------------------------------------------------
method SystemAuthenticationLockoutExportDataGetRequest ($x0) {
    return $self->send_command( 'SystemAuthenticationLockoutExportDataGetRequest', fileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemAuthenticationLockoutSettingsGetRequest () {
    return $self->send_query(
        'SystemAuthenticationLockoutSettingsGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAuthenticationLockoutSettingsModifyRequest (@generic_params) {
    return $self->send_command( 'SystemAuthenticationLockoutSettingsModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemBroadCloudGetRequest () {
    return $self->send_query(
        'SystemBroadCloudGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemBroadCloudModifyRequest (@generic_params) {
    return $self->send_command( 'SystemBroadCloudModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemExportSubscriberRequest () {
    return $self->send_command(
        'SystemExportSubscriberRequest',

    );
}

# ----------------------------------------------------------------------
method SystemBroadWorksMobileManagerGetRequest () {
    return $self->send_query(
        'SystemBroadWorksMobileManagerGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemBroadWorksMobileManagerModifyRequest (@generic_params) {
    return $self->send_command( 'SystemBroadWorksMobileManagerModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemBwDiameterBaseDataGetRequest17sp3 () {
    return $self->send_query(
        'SystemBwDiameterBaseDataGetRequest17sp3',

    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterBaseDataModifyRequest (@generic_params) {
    return $self->send_command( 'SystemBwDiameterBaseDataModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemBwDiameterPeerAddRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'SystemBwDiameterPeerAddRequest',
        instance => $x0,
        identity => $x1,
        @generic_params,
        port    => $x2,
        enabled => $x3
    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterPeerDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'SystemBwDiameterPeerDeleteRequest',
        instance => $x0,
        identity => $x1
    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterPeerGetListRequest () {
    return $self->send_query(
        'SystemBwDiameterPeerGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterPeerModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemBwDiameterPeerModifyRequest',
        instance => $x0,
        identity => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterRoutingRealmAddRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'SystemBwDiameterRoutingRealmAddRequest',
        instance      => $x0,
        realm         => $x1,
        applicationId => $x2,
        default       => $x3
    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterRoutingRealmDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'SystemBwDiameterRoutingRealmDeleteRequest',
        instance      => $x0,
        realm         => $x1,
        applicationId => $x2
    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterRoutingRealmGetListRequest () {
    return $self->send_query(
        'SystemBwDiameterRoutingRealmGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterRoutingRealmModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'SystemBwDiameterRoutingRealmModifyRequest',
        instance      => $x0,
        realm         => $x1,
        applicationId => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterRoutingPeerAddRequest ($x0, $x1, $x2, $x3, $x4, $x5) {
    return $self->send_command(
        'SystemBwDiameterRoutingPeerAddRequest',
        instance      => $x0,
        realm         => $x1,
        applicationId => $x2,
        identity      => $x3,
        priority      => $x4,
        weight        => $x5
    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterRoutingPeerDeleteRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'SystemBwDiameterRoutingPeerDeleteRequest',
        instance      => $x0,
        realm         => $x1,
        applicationId => $x2,
        identity      => $x3
    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterRoutingPeerGetListRequest () {
    return $self->send_query(
        'SystemBwDiameterRoutingPeerGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemBwDiameterRoutingPeerModifyRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'SystemBwDiameterRoutingPeerModifyRequest',
        instance      => $x0,
        realm         => $x1,
        applicationId => $x2,
        identity      => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingGetPolicyRequest19sp1 () {
    return $self->send_query(
        'SystemCallProcessingGetPolicyRequest19sp1',

    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingModifyPolicyRequest15 (@generic_params) {
    return $self->send_command( 'SystemCallProcessingModifyPolicyRequest15', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileAddRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'SystemCallProcessingPolicyProfileAddRequest20',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileDeleteRequest ($x0) {
    return $self->send_command( 'SystemCallProcessingPolicyProfileDeleteRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'SystemCallProcessingPolicyProfileModifyRequest20',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileGetRequest20 ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileGetRequest20', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileGetListRequest () {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileGetAssignedNCOSListRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileGetAssignedNCOSListRequest', profileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileUserProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileUserProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileUserProfileModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCallProcessingPolicyProfileUserProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileTrunkGroupPilotProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileTrunkGroupPilotProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileTrunkGroupPilotProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileTrunkGroupPilotProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileAutoAttendantProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileAutoAttendantProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileAutoAttendantProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileAutoAttendantProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileBroadWorksAnywhereProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileBroadWorksAnywhereProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileBroadWorksAnywhereProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileBroadWorksAnywhereProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileCallCenterProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileCallCenterProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileCallCenterProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileCallCenterProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileFindMeFollowMeProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileFindMeFollowMeProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileFindMeFollowMeProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileFindMeFollowMeProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileFlexibleSeatingHostProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileFlexibleSeatingHostProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileFlexibleSeatingHostProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileFlexibleSeatingHostProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileGroupPagingProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileGroupPagingProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileGroupPagingProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileGroupPagingProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileHuntGroupProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileHuntGroupProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileHuntGroupProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileHuntGroupProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileInstantGroupCallProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileInstantGroupCallProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileInstantGroupCallProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileInstantGroupCallProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileMeetMeConferencingProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileMeetMeConferencingProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileMeetMeConferencingProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileMeetMeConferencingProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileRoutePointProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileRoutePointProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileRoutePointProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileRoutePointProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileVoicePortalProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileVoicePortalProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileVoicePortalProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileVoicePortalProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileVoiceXMLProfileGetRequest ($x0) {
    return $self->send_query( 'SystemCallProcessingPolicyProfileVoiceXMLProfileGetRequest',
        callProcessingPolicyProfileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallProcessingPolicyProfileVoiceXMLProfileModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCallProcessingPolicyProfileVoiceXMLProfileModifyRequest',
        callProcessingPolicyProfileName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCAPAddACLEntryRequest14 ($x0, @generic_params) {
    return $self->send_command(
        'SystemCAPAddACLEntryRequest14',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCAPDeleteACLEntryRequest ($x0) {
    return $self->send_command( 'SystemCAPDeleteACLEntryRequest', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemCAPGetACLListRequest14 () {
    return $self->send_query(
        'SystemCAPGetACLListRequest14',

    );
}

# ----------------------------------------------------------------------
method SystemCAPModifyACLEntryRequest14 ($x0, @generic_params) {
    return $self->send_command(
        'SystemCAPModifyACLEntryRequest14',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCAPParametersGetRequest19 () {
    return $self->send_query(
        'SystemCAPParametersGetRequest19',

    );
}

# ----------------------------------------------------------------------
method SystemCAPParametersModifyRequest19 (@generic_params) {
    return $self->send_command( 'SystemCAPParametersModifyRequest19', @generic_params );
}

# ----------------------------------------------------------------------
method SystemClientSessionParametersGetRequest () {
    return $self->send_query(
        'SystemClientSessionParametersGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemClientSessionParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemClientSessionParametersModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCodecAddRequest ($x0) {
    return $self->send_command( 'SystemCodecAddRequest', codec => $x0 );
}

# ----------------------------------------------------------------------
method SystemCodecDeleteRequest ($x0) {
    return $self->send_command( 'SystemCodecDeleteRequest', codec => $x0 );
}

# ----------------------------------------------------------------------
method SystemCodecGetListRequest () {
    return $self->send_query(
        'SystemCodecGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringAlternateCallIndicatorAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemCommunicationBarringAlternateCallIndicatorAddRequest',
        alternateCallIndicator              => $x0,
        networkServerAlternateCallIndicator => $x1
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringAlternateCallIndicatorDeleteRequest ($x0) {
    return $self->send_command( 'SystemCommunicationBarringAlternateCallIndicatorDeleteRequest',
        alternateCallIndicator => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringAlternateCallIndicatorGetListRequest () {
    return $self->send_query(
        'SystemCommunicationBarringAlternateCallIndicatorGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringAlternateCallIndicatorModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCommunicationBarringAlternateCallIndicatorModifyRequest',
        alternateCallIndicator => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringCallTypeAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemCommunicationBarringCallTypeAddRequest',
        callType              => $x0,
        networkServerCallType => $x1
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringCallTypeDeleteRequest ($x0) {
    return $self->send_command( 'SystemCommunicationBarringCallTypeDeleteRequest', callType => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringCallTypeGetListRequest () {
    return $self->send_query(
        'SystemCommunicationBarringCallTypeGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringCallTypeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCommunicationBarringCallTypeModifyRequest',
        callType => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringCriteriaAddRequest17 ($x0, @generic_params) {
    return $self->send_command(
        'SystemCommunicationBarringCriteriaAddRequest17',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringCriteriaDeleteRequest ($x0) {
    return $self->send_command( 'SystemCommunicationBarringCriteriaDeleteRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringCriteriaGetRequest19sp1 ($x0) {
    return $self->send_query( 'SystemCommunicationBarringCriteriaGetRequest19sp1', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringCriteriaGetListRequest () {
    return $self->send_query(
        'SystemCommunicationBarringCriteriaGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringCriteriaModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCommunicationBarringCriteriaModifyRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringDigitPatternCriteriaAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCommunicationBarringDigitPatternCriteriaAddRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringDigitPatternCriteriaDeleteRequest ($x0) {
    return $self->send_command( 'SystemCommunicationBarringDigitPatternCriteriaDeleteRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringDigitPatternCriteriaGetListRequest () {
    return $self->send_query(
        'SystemCommunicationBarringDigitPatternCriteriaGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringDigitPatternCriteriaGetPatternListRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemCommunicationBarringDigitPatternCriteriaGetPatternListRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringDigitPatternCriteriaGetRequest ($x0) {
    return $self->send_query( 'SystemCommunicationBarringDigitPatternCriteriaGetRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringDigitPatternCriteriaModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCommunicationBarringDigitPatternCriteriaModifyRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringIncomingCriteriaAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCommunicationBarringIncomingCriteriaAddRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringIncomingCriteriaDeleteRequest ($x0) {
    return $self->send_command( 'SystemCommunicationBarringIncomingCriteriaDeleteRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringIncomingCriteriaGetRequest ($x0) {
    return $self->send_query( 'SystemCommunicationBarringIncomingCriteriaGetRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringIncomingCriteriaGetListRequest () {
    return $self->send_query(
        'SystemCommunicationBarringIncomingCriteriaGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringIncomingCriteriaModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCommunicationBarringIncomingCriteriaModifyRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringGetRequest () {
    return $self->send_query(
        'SystemCommunicationBarringGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCommunicationBarringModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringProfileAddRequest19sp1 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemCommunicationBarringProfileAddRequest19sp1',
        name => $x0,
        @generic_params, applyToAttendedCallTransfers => $x1
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringProfileDeleteRequest ($x0) {
    return $self->send_command( 'SystemCommunicationBarringProfileDeleteRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringProfileGetCriteriaUsageListRequest ($x0) {
    return $self->send_query( 'SystemCommunicationBarringProfileGetCriteriaUsageListRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringProfileGetIncomingCriteriaUsageListRequest ($x0) {
    return $self->send_query( 'SystemCommunicationBarringProfileGetIncomingCriteriaUsageListRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringProfileGetDigitPatternCriteriaUsageListRequest ($x0) {
    return $self->send_query( 'SystemCommunicationBarringProfileGetDigitPatternCriteriaUsageListRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringProfileGetListRequest () {
    return $self->send_query(
        'SystemCommunicationBarringProfileGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringProfileGetRequest19sp1 ($x0) {
    return $self->send_query( 'SystemCommunicationBarringProfileGetRequest19sp1', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringProfileGetRequest19sp1V2 ($x0) {
    return $self->send_query( 'SystemCommunicationBarringProfileGetRequest19sp1V2', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringProfileModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCommunicationBarringProfileModifyRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringServiceProviderGetCriteriaUsageListRequest ($x0) {
    return $self->send_query( 'SystemCommunicationBarringServiceProviderGetCriteriaUsageListRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringServiceProviderGetIncomingCriteriaUsageListRequest ($x0) {
    return $self->send_query( 'SystemCommunicationBarringServiceProviderGetIncomingCriteriaUsageListRequest',
        name => $x0 );
}

# ----------------------------------------------------------------------
method SystemConfigurableFileSystemGetRequest () {
    return $self->send_query(
        'SystemConfigurableFileSystemGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemConfigurableFileSystemModifyRequest (@generic_params) {
    return $self->send_query( 'SystemConfigurableFileSystemModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemConfigurableTreatmentAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemConfigurableTreatmentAddRequest',
        treatmentId     => $x0,
        chargeIndicator => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemConfigurableTreatmentDeleteRequest ($x0) {
    return $self->send_command( 'SystemConfigurableTreatmentDeleteRequest', treatmentId => $x0 );
}

# ----------------------------------------------------------------------
method SystemConfigurableTreatmentGetListRequest () {
    return $self->send_query(
        'SystemConfigurableTreatmentGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemConfigurableTreatmentGetRequest16 ($x0) {
    return $self->send_query( 'SystemConfigurableTreatmentGetRequest16', treatmentId => $x0 );
}

# ----------------------------------------------------------------------
method SystemConfigurableTreatmentModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemConfigurableTreatmentModifyRequest',
        treatmentId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingAccessSIPStatusAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemTreatmentMappingAccessSIPStatusAddRequest',
        sipStatusCode => $x0,
        treatmentId   => $x1
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingAccessSIPStatusDeleteRequest ($x0) {
    return $self->send_command( 'SystemTreatmentMappingAccessSIPStatusDeleteRequest', sipStatusCode => $x0 );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingAccessSIPStatusGetListRequest () {
    return $self->send_query(
        'SystemTreatmentMappingAccessSIPStatusGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingAccessSIPStatusModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemTreatmentMappingAccessSIPStatusModifyRequest',
        sipStatusCode => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingCallBlockingServiceAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemTreatmentMappingCallBlockingServiceAddRequest',
        callBlockingService => $x0,
        treatmentId         => $x1
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingCallBlockingServiceDeleteRequest ($x0) {
    return $self->send_command( 'SystemTreatmentMappingCallBlockingServiceDeleteRequest', callBlockingService => $x0 );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingCallBlockingServiceGetListRequest19sp1 () {
    return $self->send_query(
        'SystemTreatmentMappingCallBlockingServiceGetListRequest19sp1',

    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingCallBlockingServiceModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemTreatmentMappingCallBlockingServiceModifyRequest',
        callBlockingService => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingInternalReleaseCauseAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemTreatmentMappingInternalReleaseCauseAddRequest',
        internalReleaseCause => $x0,
        treatmentId          => $x1
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingInternalReleaseCauseDeleteRequest ($x0) {
    return $self->send_command( 'SystemTreatmentMappingInternalReleaseCauseDeleteRequest',
        internalReleaseCause => $x0 );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingInternalReleaseCauseGetListRequest () {
    return $self->send_query(
        'SystemTreatmentMappingInternalReleaseCauseGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingInternalReleaseCauseModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemTreatmentMappingInternalReleaseCauseModifyRequest',
        internalReleaseCause => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingNetworkServerTreatmentAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemTreatmentMappingNetworkServerTreatmentAddRequest',
        nsTreatment => $x0,
        treatmentId => $x1
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingNetworkServerTreatmentDeleteRequest ($x0) {
    return $self->send_command( 'SystemTreatmentMappingNetworkServerTreatmentDeleteRequest', nsTreatment => $x0 );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingNetworkServerTreatmentGetListRequest () {
    return $self->send_query(
        'SystemTreatmentMappingNetworkServerTreatmentGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingNetworkServerTreatmentModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemTreatmentMappingNetworkServerTreatmentModifyRequest',
        nsTreatment => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingNetworkSIPStatusAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemTreatmentMappingNetworkSIPStatusAddRequest',
        sipStatusCode => $x0,
        treatmentId   => $x1
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingNetworkSIPStatusDeleteRequest ($x0) {
    return $self->send_command( 'SystemTreatmentMappingNetworkSIPStatusDeleteRequest', sipStatusCode => $x0 );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingNetworkSIPStatusGetListRequest () {
    return $self->send_query(
        'SystemTreatmentMappingNetworkSIPStatusGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingNetworkSIPStatusModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemTreatmentMappingNetworkSIPStatusModifyRequest',
        sipStatusCode => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingQ850CauseAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemTreatmentMappingQ850CauseAddRequest',
        q850CauseValue => $x0,
        treatmentId    => $x1
    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingQ850CauseDeleteRequest ($x0) {
    return $self->send_command( 'SystemTreatmentMappingQ850CauseDeleteRequest', q850CauseValue => $x0 );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingQ850CauseGetListRequest () {
    return $self->send_query(
        'SystemTreatmentMappingQ850CauseGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemTreatmentMappingQ850CauseModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemTreatmentMappingQ850CauseModifyRequest',
        q850CauseValue => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemVerifyTranslationAndRoutingRequest (@generic_params) {
    return $self->send_query( 'SystemVerifyTranslationAndRoutingRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCountryCodeAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemCountryCodeAddRequest',
        countryCode => $x0,
        countryName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCountryCodeDeleteRequest ($x0) {
    return $self->send_command( 'SystemCountryCodeDeleteRequest', countryCode => $x0 );
}

# ----------------------------------------------------------------------
method SystemCountryCodeGetListRequest () {
    return $self->send_query(
        'SystemCountryCodeGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCountryCodeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCountryCodeModifyRequest',
        countryCode => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallTypeAddMappingRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'SystemCallTypeAddMappingRequest',
        countryCode => $x0,
        digitMap    => $x1,
        callType    => $x2
    );
}

# ----------------------------------------------------------------------
method SystemCallTypeDeleteMappingRequest ($x0, $x1) {
    return $self->send_command(
        'SystemCallTypeDeleteMappingRequest',
        countryCode => $x0,
        digitMap    => $x1
    );
}

# ----------------------------------------------------------------------
method SystemCallTypeGetListRequest () {
    return $self->send_query(
        'SystemCallTypeGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallTypeGetMappingListRequest (@generic_params) {
    return $self->send_query( 'SystemCallTypeGetMappingListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCPEConfigAddFileServerRequest14sp6 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemCPEConfigAddFileServerRequest14sp6',
        deviceType         => $x0,
        fileRepositoryName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCPEConfigDeleteFileServerRequest ($x0) {
    return $self->send_command( 'SystemCPEConfigDeleteFileServerRequest', deviceType => $x0 );
}

# ----------------------------------------------------------------------
method SystemCPEConfigGetFileServerListRequest14sp6 () {
    return $self->send_query(
        'SystemCPEConfigGetFileServerListRequest14sp6',

    );
}

# ----------------------------------------------------------------------
method SystemCPEConfigModifyFileServerRequest14sp6 ($x0, @generic_params) {
    return $self->send_command(
        'SystemCPEConfigModifyFileServerRequest14sp6',
        deviceType => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCPEConfigParametersGetRequest20 () {
    return $self->send_query(
        'SystemCPEConfigParametersGetRequest20',

    );
}

# ----------------------------------------------------------------------
method SystemCPEConfigParametersModifyRequest20 (@generic_params) {
    return $self->send_command( 'SystemCPEConfigParametersModifyRequest20', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCPEConfigRebuildConfigFileRequest (@generic_params) {
    return $self->send_command( 'SystemCPEConfigRebuildConfigFileRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCPEConfigRebuildDeviceConfigFileRequest ($x0) {
    return $self->send_command( 'SystemCPEConfigRebuildDeviceConfigFileRequest', deviceName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCPEConfigResetDeviceRequest ($x0) {
    return $self->send_command( 'SystemCPEConfigResetDeviceRequest', deviceName => $x0 );
}

# ----------------------------------------------------------------------
method SystemCPEConfigResetDeviceTypeRequest (@generic_params) {
    return $self->send_command( 'SystemCPEConfigResetDeviceTypeRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCPEConfigReorderDeviceLinePortsRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCPEConfigReorderDeviceLinePortsRequest',
        deviceName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCPEConfigSetConfigFileRequest ($x0, $x1) {
    return $self->send_command(
        'SystemCPEConfigSetConfigFileRequest',
        deviceType => $x0,
        configFile => $x1
    );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementEventGetListRequest (@generic_params) {
    return $self->send_query( 'SystemDeviceManagementEventGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementGetAccessDeviceCountForDeviceTypeRequest (@generic_params) {
    return $self->send_query( 'SystemDeviceManagementGetAccessDeviceCountForDeviceTypeRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementGetEventStatusSummaryCountRequest () {
    return $self->send_query(
        'SystemDeviceManagementGetEventStatusSummaryCountRequest',

    );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementInProgressAndPendingEventCancelRequest (@generic_params) {
    return $self->send_query( 'SystemDeviceManagementInProgressAndPendingEventCancelRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementTagAddRequest (@generic_params) {
    return $self->send_command( 'SystemDeviceManagementTagAddRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementTagDeleteListRequest (@generic_params) {
    return $self->send_command( 'SystemDeviceManagementTagDeleteListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementTagGetListRequest (@generic_params) {
    return $self->send_query( 'SystemDeviceManagementTagGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementTagModifyRequest (@generic_params) {
    return $self->send_command( 'SystemDeviceManagementTagModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementTagSetAddRequest ($x0) {
    return $self->send_command( 'SystemDeviceManagementTagSetAddRequest', tagSetName => $x0 );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementTagSetModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemDeviceManagementTagSetModifyRequest',
        tagSetName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementTagSetDeleteRequest ($x0) {
    return $self->send_command( 'SystemDeviceManagementTagSetDeleteRequest', tagSetName => $x0 );
}

# ----------------------------------------------------------------------
method SystemDeviceManagementTagSetGetListRequest () {
    return $self->send_query(
        'SystemDeviceManagementTagSetGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemDeviceProfileAuthenticationLockoutGetRequest (@generic_params) {
    return $self->send_query( 'SystemDeviceProfileAuthenticationLockoutGetRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDeviceProfileAuthenticationLockoutClearRequest (@generic_params) {
    return $self->send_command( 'SystemDeviceProfileAuthenticationLockoutClearRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDeviceProfileAuthenticationLockoutClearAllRequest () {
    return $self->send_command(
        'SystemDeviceProfileAuthenticationLockoutClearAllRequest',

    );
}

# ----------------------------------------------------------------------
method SystemDeviceProfileAuthenticationPasswordRulesGetRequest () {
    return $self->send_query(
        'SystemDeviceProfileAuthenticationPasswordRulesGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemDeviceProfileAuthenticationPasswordRulesModifyRequest (@generic_params) {
    return $self->send_command( 'SystemDeviceProfileAuthenticationPasswordRulesModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDeviceTypeExportRequest ($x0) {
    return $self->send_query( 'SystemDeviceTypeExportRequest', deviceType => $x0 );
}

# ----------------------------------------------------------------------
method SystemDeviceTypeImportRequest ($x0) {
    return $self->send_command( 'SystemDeviceTypeImportRequest', file => $x0 );
}

# ----------------------------------------------------------------------
method SystemDeviceTypeGetAvailableListRequest19 ($x0, $x1, $x2, $x3, $x4) {
    return $self->send_query(
        'SystemDeviceTypeGetAvailableListRequest19',
        allowConference       => $x0,
        allowMusicOnHold      => $x1,
        onlyConference        => $x2,
        onlyVideoCapable      => $x3,
        onlyOptionalIpAddress => $x4
    );
}

# ----------------------------------------------------------------------
method SystemDeviceTypeGetRequest19 ($x0) {
    return $self->send_query( 'SystemDeviceTypeGetRequest19', deviceType => $x0 );
}

# ----------------------------------------------------------------------
method SystemDialableCallerIDCriteriaAddRequest ($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, @generic_params) {
    return $self->send_command(
        'SystemDialableCallerIDCriteriaAddRequest',
        name => $x0,
        @generic_params,
        matchLocalCategory         => $x1,
        matchNationalCategory      => $x2,
        matchInterlataCategory     => $x3,
        matchIntralataCategory     => $x4,
        matchInternationalCategory => $x5,
        matchPrivateCategory       => $x6,
        matchEmergencyCategory     => $x7,
        matchOtherCategory         => $x8
    );
}

# ----------------------------------------------------------------------
method SystemDialableCallerIDCriteriaDeleteRequest ($x0) {
    return $self->send_command( 'SystemDialableCallerIDCriteriaDeleteRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemDialableCallerIDCriteriaGetRequest ($x0) {
    return $self->send_query( 'SystemDialableCallerIDCriteriaGetRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemDialableCallerIDCriteriaModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemDialableCallerIDCriteriaModifyRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemDialableCallerIDGetRequest () {
    return $self->send_query(
        'SystemDialableCallerIDGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemDialableCallerIDModifyRequest (@generic_params) {
    return $self->send_command( 'SystemDialableCallerIDModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDialPlanPolicyGetRequest17 () {
    return $self->send_query(
        'SystemDialPlanPolicyGetRequest17',

    );
}

# ----------------------------------------------------------------------
method SystemDialPlanPolicyModifyRequest (@generic_params) {
    return $self->send_command( 'SystemDialPlanPolicyModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDialPlanPolicyGetAccessCodeListRequest () {
    return $self->send_query(
        'SystemDialPlanPolicyGetAccessCodeListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemDialPlanPolicyGetAccessCodeRequest ($x0) {
    return $self->send_query( 'SystemDialPlanPolicyGetAccessCodeRequest', accessCode => $x0 );
}

# ----------------------------------------------------------------------
method SystemDialPlanPolicyAddAccessCodeRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'SystemDialPlanPolicyAddAccessCodeRequest',
        accessCode                                  => $x0,
        includeCodeForNetworkTranslationsAndRouting => $x1,
        includeCodeForScreeningServices             => $x2,
        enableSecondaryDialTone                     => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemDialPlanPolicyDeleteAccessCodeRequest ($x0) {
    return $self->send_command( 'SystemDialPlanPolicyDeleteAccessCodeRequest', accessCode => $x0 );
}

# ----------------------------------------------------------------------
method SystemDialPlanPolicyModifyAccessCodeRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemDialPlanPolicyModifyAccessCodeRequest',
        accessCode => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemDigitCollectionGetRequest13mp4 () {
    return $self->send_query(
        'SystemDigitCollectionGetRequest13mp4',

    );
}

# ----------------------------------------------------------------------
method SystemDigitCollectionModifyRequest (@generic_params) {
    return $self->send_command( 'SystemDigitCollectionModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDnGetSummaryListRequest () {
    return $self->send_query(
        'SystemDnGetSummaryListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemDnGetUtilizationListRequest () {
    return $self->send_query(
        'SystemDnGetUtilizationListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemDnGetUtilizationRequest14sp3 ($x0) {
    return $self->send_query( 'SystemDnGetUtilizationRequest14sp3', phoneNumber => $x0 );
}

# ----------------------------------------------------------------------
method SystemDomainAddRequest ($x0) {
    return $self->send_command( 'SystemDomainAddRequest', domain => $x0 );
}

# ----------------------------------------------------------------------
method SystemDomainDeleteRequest ($x0) {
    return $self->send_command( 'SystemDomainDeleteRequest', domain => $x0 );
}

# ----------------------------------------------------------------------
method SystemDomainGetAssignedServiceProviderListRequest ($x0) {
    return $self->send_query( 'SystemDomainGetAssignedServiceProviderListRequest', domain => $x0 );
}

# ----------------------------------------------------------------------
method SystemDomainGetListRequest () {
    return $self->send_query(
        'SystemDomainGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemDomainParametersGetRequest () {
    return $self->send_query(
        'SystemDomainParametersGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemDomainParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemDomainParametersModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemDTMFTransmissionGetRequest () {
    return $self->send_query(
        'SystemDTMFTransmissionGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemDTMFTransmissionModifyRequest (@generic_params) {
    return $self->send_command( 'SystemDTMFTransmissionModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemEndpointGetListRequest (@generic_params) {
    return $self->send_query( 'SystemEndpointGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemExpensiveCallNotificationGetRequest () {
    return $self->send_query(
        'SystemExpensiveCallNotificationGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemExpensiveCallNotificationModifyRequest (@generic_params) {
    return $self->send_command( 'SystemExpensiveCallNotificationModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemExpensiveCallTypeAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemExpensiveCallTypeAddRequest',
        alternateCallIndicator => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemExpensiveCallTypeDeleteRequest ($x0) {
    return $self->send_command( 'SystemExpensiveCallTypeDeleteRequest', alternateCallIndicator => $x0 );
}

# ----------------------------------------------------------------------
method SystemExpensiveCallTypeGetListRequest16sp1 () {
    return $self->send_query(
        'SystemExpensiveCallTypeGetListRequest16sp1',

    );
}

# ----------------------------------------------------------------------
method SystemExpensiveCallTypeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemExpensiveCallTypeModifyRequest',
        alternateCallIndicator => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemExportAddressingDataRequest ($x0) {
    return $self->send_command( 'SystemExportAddressingDataRequest', fileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemExportBroadCloudDataRequest ($x0) {
    return $self->send_command( 'SystemExportBroadCloudDataRequest', fileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemExtensionLengthGetRequest () {
    return $self->send_query(
        'SystemExtensionLengthGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemExtensionLengthModifyRequest (@generic_params) {
    return $self->send_command( 'SystemExtensionLengthModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemExternalAuthenticationAddACLEntryRequest14sp2 ($x0, @generic_params) {
    return $self->send_command(
        'SystemExternalAuthenticationAddACLEntryRequest14sp2',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemExternalAuthenticationDeleteACLEntryRequest14sp2 ($x0) {
    return $self->send_command( 'SystemExternalAuthenticationDeleteACLEntryRequest14sp2', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemExternalAuthenticationGetACLListRequest () {
    return $self->send_query(
        'SystemExternalAuthenticationGetACLListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemExternalAuthenticationModifyACLEntryRequest14sp2 ($x0, @generic_params) {
    return $self->send_command(
        'SystemExternalAuthenticationModifyACLEntryRequest14sp2',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemExternalEmergencyRoutingParametersGetRequest13mp13 () {
    return $self->send_query(
        'SystemExternalEmergencyRoutingParametersGetRequest13mp13',

    );
}

# ----------------------------------------------------------------------
method SystemExternalEmergencyRoutingParametersModifyRequest13mp13 (@generic_params) {
    return $self->send_command( 'SystemExternalEmergencyRoutingParametersModifyRequest13mp13', @generic_params );
}

# ----------------------------------------------------------------------
method SystemFeatureAccessCodeGetListRequest20 () {
    return $self->send_query(
        'SystemFeatureAccessCodeGetListRequest20',

    );
}

# ----------------------------------------------------------------------
method SystemFeatureAccessCodeModifyListRequest20 (@generic_params) {
    return $self->send_command( 'SystemFeatureAccessCodeModifyListRequest20', @generic_params );
}

# ----------------------------------------------------------------------
method SystemFileGetContentRequest ($x0) {
    return $self->send_query( 'SystemFileGetContentRequest', fileName => $x0 );
}

# ----------------------------------------------------------------------
method SystemFileRepositoryDeviceAddRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'SystemFileRepositoryDeviceAddRequest20',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemFileRepositoryDeviceDeleteRequest ($x0) {
    return $self->send_command( 'SystemFileRepositoryDeviceDeleteRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemFileRepositoryDeviceModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemFileRepositoryDeviceModifyRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemFileRepositoryDeviceGetRequest20 ($x0) {
    return $self->send_query( 'SystemFileRepositoryDeviceGetRequest20', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemFileRepositoryDeviceGetListRequest () {
    return $self->send_query(
        'SystemFileRepositoryDeviceGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemFileRepositoryDeviceUserAddRequest ($x0, $x1, $x2, $x3, $x4, $x5) {
    return $self->send_command(
        'SystemFileRepositoryDeviceUserAddRequest',
        fileRepositoryName => $x0,
        userName           => $x1,
        password           => $x2,
        allowPut           => $x3,
        allowDelete        => $x4,
        allowGet           => $x5
    );
}

# ----------------------------------------------------------------------
method SystemFileRepositoryDeviceUserDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'SystemFileRepositoryDeviceUserDeleteRequest',
        fileRepositoryName => $x0,
        userName           => $x1
    );
}

# ----------------------------------------------------------------------
method SystemFileRepositoryDeviceUserModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemFileRepositoryDeviceUserModifyRequest',
        fileRepositoryName => $x0,
        userName           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemFileRepositoryDeviceUserGetRequest ($x0, $x1) {
    return $self->send_query(
        'SystemFileRepositoryDeviceUserGetRequest',
        fileRepositoryName => $x0,
        userName           => $x1
    );
}

# ----------------------------------------------------------------------
method SystemFileRepositoryDeviceUserGetListRequest ($x0) {
    return $self->send_query( 'SystemFileRepositoryDeviceUserGetListRequest', fileRepositoryName => $x0 );
}

# ----------------------------------------------------------------------
method SystemGeographicRedundancyPeerSipConnectionMonitoringGetRequest () {
    return $self->send_query(
        'SystemGeographicRedundancyPeerSipConnectionMonitoringGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemGeographicRedundancyPeerSipConnectionMonitoringModifyRequest (@generic_params) {
    return $self->send_command( 'SystemGeographicRedundancyPeerSipConnectionMonitoringModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemGeographicRedundancyProxyGetRequest () {
    return $self->send_query(
        'SystemGeographicRedundancyProxyGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemGeographicRedundancyProxyModifyRequest (@generic_params) {
    return $self->send_command( 'SystemGeographicRedundancyProxyModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemGeographicRedundancyUnreachableFromPrimaryGetUserListRequest () {
    return $self->send_query(
        'SystemGeographicRedundancyUnreachableFromPrimaryGetUserListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemGetRegistrationContactListRequest (@generic_params) {
    return $self->send_query( 'SystemGetRegistrationContactListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemHomeNetworkAddRequest ($x0) {
    return $self->send_command( 'SystemHomeNetworkAddRequest', mscAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemHomeNetworkDeleteRequest ($x0) {
    return $self->send_command( 'SystemHomeNetworkDeleteRequest', mscAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemHomeNetworkGetListRequest (@generic_params) {
    return $self->send_query( 'SystemHomeNetworkGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemLanguageAddRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'SystemLanguageAddRequest',
        language => $x0,
        locale   => $x1,
        encoding => $x2
    );
}

# ----------------------------------------------------------------------
method SystemLanguageDeleteRequest ($x0) {
    return $self->send_command( 'SystemLanguageDeleteRequest', language => $x0 );
}

# ----------------------------------------------------------------------
method SystemLanguageGetListRequest () {
    return $self->send_query(
        'SystemLanguageGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemLanguageModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemLanguageModifyRequest',
        language => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemLicensingGetRequest14sp3 () {
    return $self->send_query(
        'SystemLicensingGetRequest14sp3',

    );
}

# ----------------------------------------------------------------------
method SystemLicensingGetSystemLicenseListRequest () {
    return $self->send_query(
        'SystemLicensingGetSystemLicenseListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemLicensingReloadRequest () {
    return $self->send_command(
        'SystemLicensingReloadRequest',

    );
}

# ----------------------------------------------------------------------
method SystemLogConfigModifyRequest (@generic_params) {
    return $self->send_command( 'SystemLogConfigModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemMailParametersGetRequest () {
    return $self->send_query(
        'SystemMailParametersGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemMailParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemMailParametersModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemMediaAddRequest16 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'SystemMediaAddRequest16',
        mediaName                => $x0,
        codecName                => $x1,
        mediaType                => $x2,
        bandwidthEnforcementType => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemMediaDeleteRequest ($x0) {
    return $self->send_command( 'SystemMediaDeleteRequest', mediaName => $x0 );
}

# ----------------------------------------------------------------------
method SystemMediaGetListRequest () {
    return $self->send_query(
        'SystemMediaGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemMediaModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemMediaModifyRequest',
        mediaName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemMediaServerAddRequest14 ($x0, @generic_params) {
    return $self->send_command(
        'SystemMediaServerAddRequest14',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemMediaServerDeleteRequest ($x0) {
    return $self->send_command( 'SystemMediaServerDeleteRequest', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemMediaServerGetListRequest () {
    return $self->send_query(
        'SystemMediaServerGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemMediaServerModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemMediaServerModifyRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemMediaServerParametersGetRequest () {
    return $self->send_query(
        'SystemMediaServerParametersGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemMediaServerParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemMediaServerParametersModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemMediaSetAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemMediaSetAddRequest',
        setName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemMediaSetDeleteRequest ($x0) {
    return $self->send_command( 'SystemMediaSetDeleteRequest', setName => $x0 );
}

# ----------------------------------------------------------------------
method SystemMediaSetGetListRequest () {
    return $self->send_query(
        'SystemMediaSetGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemMediaSetGetRequest ($x0) {
    return $self->send_query( 'SystemMediaSetGetRequest', setName => $x0 );
}

# ----------------------------------------------------------------------
method SystemMediaSetModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemMediaSetModifyRequest',
        setName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemMGCPDeviceTypeGetListRequest () {
    return $self->send_query(
        'SystemMGCPDeviceTypeGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemMGCPDeviceTypeGetRequest ($x0) {
    return $self->send_query( 'SystemMGCPDeviceTypeGetRequest', deviceType => $x0 );
}

# ----------------------------------------------------------------------
method SystemMGCPDeviceTypeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemMGCPDeviceTypeModifyRequest',
        deviceType => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemMigratedUsersGetListRequest () {
    return $self->send_query(
        'SystemMigratedUsersGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemMultimediaPolicyGetRequest () {
    return $self->send_query(
        'SystemMultimediaPolicyGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemMultimediaPolicyModifyRequest (@generic_params) {
    return $self->send_command( 'SystemMultimediaPolicyModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemNetworkClassOfServiceAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemNetworkClassOfServiceAddRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemNetworkClassOfServiceDeleteRequest ($x0) {
    return $self->send_command( 'SystemNetworkClassOfServiceDeleteRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemNetworkClassOfServiceGetRequest19sp1 ($x0) {
    return $self->send_query( 'SystemNetworkClassOfServiceGetRequest19sp1', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemNetworkClassOfServiceGetAssignedServiceProviderListRequest ($x0) {
    return $self->send_query( 'SystemNetworkClassOfServiceGetAssignedServiceProviderListRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemNetworkClassOfServiceGetCommunicationBarringProfileUsageListRequest ($x0) {
    return $self->send_query( 'SystemNetworkClassOfServiceGetCommunicationBarringProfileUsageListRequest',
        name => $x0 );
}

# ----------------------------------------------------------------------
method SystemNetworkClassOfServiceGetListRequest () {
    return $self->send_query(
        'SystemNetworkClassOfServiceGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemNetworkClassOfServiceModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemNetworkClassOfServiceModifyRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemNetworkDeviceMonitorParametersGetRequest () {
    return $self->send_query(
        'SystemNetworkDeviceMonitorParametersGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemNetworkDeviceMonitorParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemNetworkDeviceMonitorParametersModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemNetworkProgressionGetRequest () {
    return $self->send_query(
        'SystemNetworkProgressionGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemNetworkProgressionModifyRequest (@generic_params) {
    return $self->send_command( 'SystemNetworkProgressionModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemNetworkRoutingServerAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemNetworkRoutingServerAddRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemNetworkRoutingServerDeleteRequest ($x0) {
    return $self->send_command( 'SystemNetworkRoutingServerDeleteRequest', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemNetworkRoutingServerGetListRequest () {
    return $self->send_query(
        'SystemNetworkRoutingServerGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemNetworkRoutingServerModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemNetworkRoutingServerModifyRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemNetworkServerSyncParametersGetRequest17sp4 () {
    return $self->send_query(
        'SystemNetworkServerSyncParametersGetRequest17sp4',

    );
}

# ----------------------------------------------------------------------
method SystemNetworkServerSyncParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemNetworkServerSyncParametersModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemNetworkSynchingServerAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemNetworkSynchingServerAddRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemNetworkSynchingServerDeleteRequest ($x0) {
    return $self->send_command( 'SystemNetworkSynchingServerDeleteRequest', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemNetworkSynchingServerGetListRequest () {
    return $self->send_query(
        'SystemNetworkSynchingServerGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemNetworkSynchingServerModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemNetworkSynchingServerModifyRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemNumberActivationGetRequest18sp1 () {
    return $self->send_query(
        'SystemNumberActivationGetRequest18sp1',

    );
}

# ----------------------------------------------------------------------
method SystemNumberActivationModifyRequest18sp1 (@generic_params) {
    return $self->send_command( 'SystemNumberActivationModifyRequest18sp1', @generic_params );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryDigitPatternAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemNumberPortabilityQueryDigitPatternAddRequest',
        digitPattern => $x0,
        status       => $x1
    );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryDigitPatternDeleteListRequest (@generic_params) {
    return $self->send_command( 'SystemNumberPortabilityQueryDigitPatternDeleteListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryDigitPatternGetRequest ($x0) {
    return $self->send_query( 'SystemNumberPortabilityQueryDigitPatternGetRequest', digitPattern => $x0 );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryDigitPatternGetListRequest (@generic_params) {
    return $self->send_query( 'SystemNumberPortabilityQueryDigitPatternGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryDigitPatternModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemNumberPortabilityQueryDigitPatternModifyRequest',
        digitPattern => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryStatusGetListRequest () {
    return $self->send_query(
        'SystemNumberPortabilityQueryStatusGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryStatusDeleteListRequest (@generic_params) {
    return $self->send_command( 'SystemNumberPortabilityQueryStatusDeleteListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryStatusAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemNumberPortabilityQueryStatusAddRequest',
        status => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryStatusGetRequest ($x0) {
    return $self->send_query( 'SystemNumberPortabilityQueryStatusGetRequest', status => $x0 );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryStatusModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemNumberPortabilityQueryStatusModifyRequest',
        statusName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryGetRequest () {
    return $self->send_query(
        'SystemNumberPortabilityQueryGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemNumberPortabilityQueryModifyRequest (@generic_params) {
    return $self->send_command( 'SystemNumberPortabilityQueryModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemOCIAddACLEntryRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemOCIAddACLEntryRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemOCIDeleteACLEntryRequest ($x0) {
    return $self->send_command( 'SystemOCIDeleteACLEntryRequest', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemOCIGetACLListRequest () {
    return $self->send_query(
        'SystemOCIGetACLListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemOCIModifyACLEntryRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemOCIModifyACLEntryRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemOCICallControlAddACLEntryRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemOCICallControlAddACLEntryRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemOCICallControlDeleteACLEntryRequest ($x0) {
    return $self->send_command( 'SystemOCICallControlDeleteACLEntryRequest', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemOCICallControlGetACLListRequest () {
    return $self->send_query(
        'SystemOCICallControlGetACLListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemOCICallControlModifyACLEntryRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemOCICallControlModifyACLEntryRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemOCICallControlApplicationAddRequest17 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'SystemOCICallControlApplicationAddRequest17',
        applicationId              => $x0,
        enableSystemWide           => $x1,
        notificationTimeoutSeconds => $x2,
        @generic_params, maxEventChannelsPerSet => $x3
    );
}

# ----------------------------------------------------------------------
method SystemOCICallControlApplicationDeleteRequest ($x0) {
    return $self->send_command( 'SystemOCICallControlApplicationDeleteRequest', applicationId => $x0 );
}

# ----------------------------------------------------------------------
method SystemOCICallControlApplicationGetListRequest () {
    return $self->send_query(
        'SystemOCICallControlApplicationGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemOCICallControlApplicationModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemOCICallControlApplicationModifyRequest',
        applicationId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemOCICallControlApplicationAddACLEntryRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemOCICallControlApplicationAddACLEntryRequest',
        applicationId => $x0,
        netAddress    => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemOCICallControlApplicationDeleteACLEntryRequest ($x0, $x1) {
    return $self->send_command(
        'SystemOCICallControlApplicationDeleteACLEntryRequest',
        applicationId => $x0,
        netAddress    => $x1
    );
}

# ----------------------------------------------------------------------
method SystemOCICallControlApplicationGetACLListRequest ($x0) {
    return $self->send_query( 'SystemOCICallControlApplicationGetACLListRequest', applicationId => $x0 );
}

# ----------------------------------------------------------------------
method SystemOCICallControlApplicationModifyACLEntryRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemOCICallControlApplicationModifyACLEntryRequest',
        applicationId => $x0,
        netAddress    => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemOCIReportingAddACLEntryRequest13mp9 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemOCIReportingAddACLEntryRequest13mp9',
        netAddress => $x0,
        @generic_params, restrictMessages => $x1
    );
}

# ----------------------------------------------------------------------
method SystemOCIReportingAddMessageNameListRequest ($x0, $x1) {
    return $self->send_command(
        'SystemOCIReportingAddMessageNameListRequest',
        netAddress            => $x0,
        messageNameStartsWith => $x1
    );
}

# ----------------------------------------------------------------------
method SystemOCIReportingDeleteACLEntryRequest ($x0) {
    return $self->send_command( 'SystemOCIReportingDeleteACLEntryRequest', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemOCIReportingDeleteMessageNameListRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemOCIReportingDeleteMessageNameListRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemOCIReportingGetACLListRequest () {
    return $self->send_query(
        'SystemOCIReportingGetACLListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemOCIReportingGetMessageNameListRequest ($x0) {
    return $self->send_query( 'SystemOCIReportingGetMessageNameListRequest', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemOCIReportingModifyACLEntryRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemOCIReportingModifyACLEntryRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemOCIReportingParametersGetRequest14sp1 () {
    return $self->send_query(
        'SystemOCIReportingParametersGetRequest14sp1',

    );
}

# ----------------------------------------------------------------------
method SystemOCIReportingParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemOCIReportingParametersModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemOfficeZoneAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemOfficeZoneAddRequest',
        officeZoneName => $x0,
        @generic_params, primaryZoneName => $x1
    );
}

# ----------------------------------------------------------------------
method SystemOfficeZoneDeleteRequest ($x0) {
    return $self->send_command( 'SystemOfficeZoneDeleteRequest', officeZoneName => $x0 );
}

# ----------------------------------------------------------------------
method SystemOfficeZoneGetRequest ($x0) {
    return $self->send_query( 'SystemOfficeZoneGetRequest', officeZoneName => $x0 );
}

# ----------------------------------------------------------------------
method SystemOfficeZoneGetAssignedServiceProviderListRequest ($x0) {
    return $self->send_query( 'SystemOfficeZoneGetAssignedServiceProviderListRequest', officeZoneName => $x0 );
}

# ----------------------------------------------------------------------
method SystemOfficeZoneGetListRequest () {
    return $self->send_query(
        'SystemOfficeZoneGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemOfficeZoneGetZoneUsageListRequest ($x0) {
    return $self->send_query( 'SystemOfficeZoneGetZoneUsageListRequest', zoneName => $x0 );
}

# ----------------------------------------------------------------------
method SystemOfficeZoneModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemOfficeZoneModifyRequest',
        officeZoneName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemPasswordRulesGetRequest16 () {
    return $self->send_query(
        'SystemPasswordRulesGetRequest16',

    );
}

# ----------------------------------------------------------------------
method SystemPasswordRulesModifyRequest14sp3 (@generic_params) {
    return $self->send_command( 'SystemPasswordRulesModifyRequest14sp3', @generic_params );
}

# ----------------------------------------------------------------------
method SystemPerformanceMeasurementReportingAddFileServerRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'SystemPerformanceMeasurementReportingAddFileServerRequest',
        ftpHostNetAddress => $x0,
        ftpUserId         => $x1,
        ftpUserPassword   => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemPerformanceMeasurementReportingDeleteFileServerRequest ($x0) {
    return $self->send_command( 'SystemPerformanceMeasurementReportingDeleteFileServerRequest',
        ftpHostNetAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemPerformanceMeasurementGenerateReportRequest () {
    return $self->send_command(
        'SystemPerformanceMeasurementGenerateReportRequest',

    );
}

# ----------------------------------------------------------------------
method SystemPerformanceMeasurementReportingGetFileServerListRequest () {
    return $self->send_query(
        'SystemPerformanceMeasurementReportingGetFileServerListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemPerformanceMeasurementReportingGetRequest () {
    return $self->send_query(
        'SystemPerformanceMeasurementReportingGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemPerformanceMeasurementReportingModifyFileServerRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemPerformanceMeasurementReportingModifyFileServerRequest',
        ftpHostNetAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemPerformanceMeasurementReportingModifyRequest (@generic_params) {
    return $self->send_command( 'SystemPerformanceMeasurementReportingModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemPolicyGetDefaultRequest20 () {
    return $self->send_query(
        'SystemPolicyGetDefaultRequest20',

    );
}

# ----------------------------------------------------------------------
method SystemPolicyModifyDefaultRequest14 (@generic_params) {
    return $self->send_command( 'SystemPolicyModifyDefaultRequest14', @generic_params );
}

# ----------------------------------------------------------------------
method SystemPortalAPIAddACLEntryRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemPortalAPIAddACLEntryRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemPortalAPIDeleteACLEntryRequest ($x0) {
    return $self->send_command( 'SystemPortalAPIDeleteACLEntryRequest', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemPortalAPIGetACLListRequest () {
    return $self->send_query(
        'SystemPortalAPIGetACLListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemPortalAPIModifyACLEntryRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemPortalAPIModifyACLEntryRequest',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemPortalPasscodeRulesGetRequest19 () {
    return $self->send_query(
        'SystemPortalPasscodeRulesGetRequest19',

    );
}

# ----------------------------------------------------------------------
method SystemPortalPasscodeRulesModifyRequest (@generic_params) {
    return $self->send_command( 'SystemPortalPasscodeRulesModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemProvisioningValidationGetRequest14sp2 () {
    return $self->send_query(
        'SystemProvisioningValidationGetRequest14sp2',

    );
}

# ----------------------------------------------------------------------
method SystemProvisioningValidationModifyRequest (@generic_params) {
    return $self->send_command( 'SystemProvisioningValidationModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemRedundancyParametersGetRequest16sp2 () {
    return $self->send_query(
        'SystemRedundancyParametersGetRequest16sp2',

    );
}

# ----------------------------------------------------------------------
method SystemRedundancyParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemRedundancyParametersModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemRoamingNetworkAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemRoamingNetworkAddRequest',
        mscAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemRoamingNetworkDeleteRequest ($x0) {
    return $self->send_command( 'SystemRoamingNetworkDeleteRequest', mscAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemRoamingNetworkGetListRequest (@generic_params) {
    return $self->send_query( 'SystemRoamingNetworkGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemRoamingNetworkModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemRoamingNetworkModifyRequest',
        mscAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemRoutePointExternalSystemAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemRoutePointExternalSystemAddRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemRoutePointExternalSystemDeleteRequest ($x0) {
    return $self->send_command( 'SystemRoutePointExternalSystemDeleteRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemRoutePointExternalSystemGetListRequest () {
    return $self->send_query(
        'SystemRoutePointExternalSystemGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemRoutePointExternalSystemModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemRoutePointExternalSystemModifyRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemRoutePointExternalSystemGetRoutePointListRequest ($x0) {
    return $self->send_query( 'SystemRoutePointExternalSystemGetRoutePointListRequest',
        routePointExternalSystem => $x0 );
}

# ----------------------------------------------------------------------
method SystemRoutePointExternalSystemApplicationControllerAddListRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemRoutePointExternalSystemApplicationControllerAddListRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemRoutePointExternalSystemApplicationControllerDeleteListRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemRoutePointExternalSystemApplicationControllerDeleteListRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemRoutePointExternalSystemApplicationControllerGetRequest ($x0) {
    return $self->send_query( 'SystemRoutePointExternalSystemApplicationControllerGetRequest', externalSystem => $x0 );
}

# ----------------------------------------------------------------------
method SystemRoutingAddRouteDeviceRequest14 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemRoutingAddRouteDeviceRequest14',
        routeName  => $x0,
        netAddress => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemRoutingAddRouteRequest ($x0) {
    return $self->send_command( 'SystemRoutingAddRouteRequest', routeName => $x0 );
}

# ----------------------------------------------------------------------
method SystemRoutingAddTranslationRequest ($x0, $x1) {
    return $self->send_command(
        'SystemRoutingAddTranslationRequest',
        digits    => $x0,
        routeName => $x1
    );
}

# ----------------------------------------------------------------------
method SystemRoutingDeleteRouteDeviceRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemRoutingDeleteRouteDeviceRequest',
        routeName  => $x0,
        netAddress => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemRoutingDeleteRouteRequest ($x0) {
    return $self->send_command( 'SystemRoutingDeleteRouteRequest', routeName => $x0 );
}

# ----------------------------------------------------------------------
method SystemRoutingDeleteTranslationRequest ($x0) {
    return $self->send_command( 'SystemRoutingDeleteTranslationRequest', digits => $x0 );
}

# ----------------------------------------------------------------------
method SystemRoutingGetRequest () {
    return $self->send_query(
        'SystemRoutingGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemRoutingGetRouteDeviceListRequest ($x0) {
    return $self->send_query( 'SystemRoutingGetRouteDeviceListRequest', routeName => $x0 );
}

# ----------------------------------------------------------------------
method SystemRoutingGetRouteListRequest () {
    return $self->send_query(
        'SystemRoutingGetRouteListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemRoutingGetTranslationListRequest () {
    return $self->send_query(
        'SystemRoutingGetTranslationListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemRoutingModifyRequest (@generic_params) {
    return $self->send_command( 'SystemRoutingModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemRoutingModifyRouteDeviceRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemRoutingModifyRouteDeviceRequest',
        routeName  => $x0,
        netAddress => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemRoutingModifyTranslationRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemRoutingModifyTranslationRequest',
        digits => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemRoutingProfileGetListRequest () {
    return $self->send_query(
        'SystemRoutingProfileGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemScheduleAddEventRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'SystemScheduleAddEventRequest',
        scheduleKey => [ scheduleName => $x0, scheduleType => $x1 ],
        eventName   => $x2,
        startDate   => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemScheduleAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemScheduleAddRequest',
        scheduleName => $x0,
        scheduleType => $x1
    );
}

# ----------------------------------------------------------------------
method SystemScheduleDeleteEventListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'SystemScheduleDeleteEventListRequest',
        scheduleKey => [ scheduleName => $x0, scheduleType => $x1 ],
        eventName   => $x2
    );
}

# ----------------------------------------------------------------------
method SystemScheduleDeleteListRequest ($x0, $x1) {
    return $self->send_command( 'SystemScheduleDeleteListRequest',
        scheduleKey => [ scheduleName => $x0, scheduleType => $x1 ] );
}

# ----------------------------------------------------------------------
method SystemScheduleGetEventListRequest ($x0, $x1) {
    return $self->send_query( 'SystemScheduleGetEventListRequest',
        scheduleKey => [ scheduleName => $x0, scheduleType => $x1 ] );
}

# ----------------------------------------------------------------------
method SystemScheduleGetEventRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'SystemScheduleGetEventRequest',
        scheduleKey => [ scheduleName => $x0, scheduleType => $x1 ],
        eventName   => $x2
    );
}

# ----------------------------------------------------------------------
method SystemScheduleGetListRequest (@generic_params) {
    return $self->send_query( 'SystemScheduleGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemScheduleModifyEventRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'SystemScheduleModifyEventRequest',
        scheduleKey => [ scheduleName => $x0, scheduleType => $x1 ],
        eventName   => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemScheduleModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemScheduleModifyRequest',
        scheduleKey => [ scheduleName => $x0, scheduleType => $x1 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemServerAddressesGetRequest () {
    return $self->send_query(
        'SystemServerAddressesGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemServerAddressesModifyRequest (@generic_params) {
    return $self->send_command( 'SystemServerAddressesModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemServiceActivationAccessCodeGetRequest () {
    return $self->send_query(
        'SystemServiceActivationAccessCodeGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemServiceActivationAccessCodeModifyRequest (@generic_params) {
    return $self->send_command( 'SystemServiceActivationAccessCodeModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemServiceCodeAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemServiceCodeAddRequest',
        serviceCode => $x0,
        description => $x1
    );
}

# ----------------------------------------------------------------------
method SystemServiceCodeDeleteRequest ($x0) {
    return $self->send_command( 'SystemServiceCodeDeleteRequest', serviceCode => $x0 );
}

# ----------------------------------------------------------------------
method SystemServiceCodeGetListRequest (@generic_params) {
    return $self->send_query( 'SystemServiceCodeGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemServiceCodeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemServiceCodeModifyRequest',
        serviceCode => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemServiceControlParametersGetRequest () {
    return $self->send_query(
        'SystemServiceControlParametersGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemServiceControlParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemServiceControlParametersModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSessionAdmissionControlGetRequest () {
    return $self->send_query(
        'SystemSessionAdmissionControlGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSessionAdmissionControlModifyRequest (@generic_params) {
    return $self->send_command( 'SystemSessionAdmissionControlModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSessionAuditGetRequest17sp3 () {
    return $self->send_query(
        'SystemSessionAuditGetRequest17sp3',

    );
}

# ----------------------------------------------------------------------
method SystemSessionAuditModifyRequest14sp3 (@generic_params) {
    return $self->send_command( 'SystemSessionAuditModifyRequest14sp3', @generic_params );
}

# ----------------------------------------------------------------------
method SystemShInterfaceParametersGetRequest17 () {
    return $self->send_query(
        'SystemShInterfaceParametersGetRequest17',

    );
}

# ----------------------------------------------------------------------
method SystemShInterfaceParametersModifyRequest17 (@generic_params) {
    return $self->send_command( 'SystemShInterfaceParametersModifyRequest17', @generic_params );
}

# ----------------------------------------------------------------------
method SystemShInterfaceRefreshTaskStartRequest () {
    return $self->send_command(
        'SystemShInterfaceRefreshTaskStartRequest',

    );
}

# ----------------------------------------------------------------------
method SystemShInterfaceRefreshTaskGetRequest () {
    return $self->send_query(
        'SystemShInterfaceRefreshTaskGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemShInterfaceRefreshTaskTerminateRequest () {
    return $self->send_command(
        'SystemShInterfaceRefreshTaskTerminateRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSIPAddACLEntryRequest14sp2 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemSIPAddACLEntryRequest14sp2',
        netAddress        => $x0,
        transportProtocol => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSIPAddContentTypeRequest ($x0, $x1) {
    return $self->send_command(
        'SystemSIPAddContentTypeRequest',
        contentType => $x0,
        interface   => $x1
    );
}

# ----------------------------------------------------------------------
method SystemSIPAuthenticationLockoutClearAllRequest () {
    return $self->send_command(
        'SystemSIPAuthenticationLockoutClearAllRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSIPAuthenticationEndpointLockoutClearRequest (@generic_params) {
    return $self->send_command( 'SystemSIPAuthenticationEndpointLockoutClearRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSIPAuthenticationEndpointLockoutGetRequest (@generic_params) {
    return $self->send_query( 'SystemSIPAuthenticationEndpointLockoutGetRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSIPAuthenticationTrunkGroupLockoutGetRequest (@generic_params) {
    return $self->send_query( 'SystemSIPAuthenticationTrunkGroupLockoutGetRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSIPAuthenticationTrunkGroupLockoutClearRequest (@generic_params) {
    return $self->send_command( 'SystemSIPAuthenticationTrunkGroupLockoutClearRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSIPAuthenticationPasswordRulesGetRequest () {
    return $self->send_query(
        'SystemSIPAuthenticationPasswordRulesGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSIPAuthenticationPasswordRulesModifyRequest (@generic_params) {
    return $self->send_command( 'SystemSIPAuthenticationPasswordRulesModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSIPDeleteACLEntryRequest14sp2 ($x0) {
    return $self->send_command( 'SystemSIPDeleteACLEntryRequest14sp2', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemSIPDeleteContentTypeRequest ($x0) {
    return $self->send_command( 'SystemSIPDeleteContentTypeRequest', contentType => $x0 );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceFileApplyExtendedCaptureToAllDeviceProfilesRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'SystemSIPDeviceFileApplyExtendedCaptureToAllDeviceProfilesRequest',
        deviceType                        => $x0,
        fileFormat                        => $x1,
        extendedCaptureOnUploadFromDevice => $x2
    );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeAddRequest20 ($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10, $x11, $x12, $x13, $x14, $x15, $x16, $x17, $x18, $x19, $x20, $x21, $x22, $x23, $x24, $x25, $x26, $x27, $x28, @generic_params) {
    return $self->send_command(
        'SystemSIPDeviceTypeAddRequest20',
        deviceType              => $x0,
        numberOfPorts           => $x1,
        profile                 => $x2,
        registrationCapable     => $x3,
        isConferenceDevice      => $x4,
        isMobilityManagerDevice => $x5,
        isMusicOnHoldDevice     => $x6,
        holdNormalization       => $x7,
        holdAnnouncementMethod  => $x8,
        isTrusted               => $x9,
        E164Capable             => $x10,
        routeAdvance            => $x11,
        forwardingOverride      => $x12,
        wirelessIntegration     => $x13,
        @generic_params,
        supportCallCenterMIMEType                => $x14,
        trunkMode                                => $x15,
        addPCalledPartyId                        => $x16,
        supportIdentityInUpdateAndReInvite       => $x17,
        unscreenedPresentationIdentityPolicy     => $x18,
        enable3G4GContinuity                     => $x19,
        supportEmergencyDisconnectControl        => $x20,
        deviceTypeConfigurationOption            => $x21,
        supportRFC3398                           => $x22,
        staticLineOrdering                       => $x23,
        supportClientSessionInfo                 => $x24,
        supportCallInfoConferenceSubscriptionURI => $x25,
        supportRemotePartyInfo                   => $x26,
        supportVisualDeviceManagement            => $x27,
        bypassMediaTreatment                     => $x28
    );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeFileAddRequest20 ($x0, $x1, $x2, $x3, $x4, $x5, @generic_params) {
    return $self->send_command(
        'SystemSIPDeviceTypeFileAddRequest20',
        deviceType        => $x0,
        fileFormat        => $x1,
        remoteFileFormat  => $x2,
        fileCategory      => $x3,
        fileCustomization => $x4,
        fileSource        => $x5,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeDeleteRequest ($x0) {
    return $self->send_command( 'SystemSIPDeviceTypeDeleteRequest', deviceType => $x0 );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeGetListRequest (@generic_params) {
    return $self->send_query( 'SystemSIPDeviceTypeGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeGetRequest20 ($x0) {
    return $self->send_query( 'SystemSIPDeviceTypeGetRequest20', deviceType => $x0 );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeModifyRequest18sp1 ($x0, @generic_params) {
    return $self->send_command(
        'SystemSIPDeviceTypeModifyRequest18sp1',
        deviceType => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSIPGetACLListRequest () {
    return $self->send_query(
        'SystemSIPGetACLListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSIPGetContentTypeListRequest () {
    return $self->send_query(
        'SystemSIPGetContentTypeListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSIPModifyACLEntryRequest14sp2 ($x0, @generic_params) {
    return $self->send_command(
        'SystemSIPModifyACLEntryRequest14sp2',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSIPModifyContentTypeRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemSIPModifyContentTypeRequest',
        contentType => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSMDIAddACLEntryRequest14sp2 ($x0, @generic_params) {
    return $self->send_command(
        'SystemSMDIAddACLEntryRequest14sp2',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSMDIDeleteACLEntryRequest14sp2 ($x0) {
    return $self->send_command( 'SystemSMDIDeleteACLEntryRequest14sp2', netAddress => $x0 );
}

# ----------------------------------------------------------------------
method SystemSMDIGetACLListRequest () {
    return $self->send_query(
        'SystemSMDIGetACLListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSMDIModifyACLEntryRequest14sp2 ($x0, @generic_params) {
    return $self->send_command(
        'SystemSMDIModifyACLEntryRequest14sp2',
        netAddress => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSMDIParametersGetRequest () {
    return $self->send_query(
        'SystemSMDIParametersGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSMDIParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemSMDIParametersModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSMPPGetRequest14sp5 () {
    return $self->send_query(
        'SystemSMPPGetRequest14sp5',

    );
}

# ----------------------------------------------------------------------
method SystemSMPPModifyRequest (@generic_params) {
    return $self->send_command( 'SystemSMPPModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSoftwareVersionGetRequest () {
    return $self->send_query(
        'SystemSoftwareVersionGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemStateOrProvinceGetListRequest () {
    return $self->send_query(
        'SystemStateOrProvinceGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSubscriberGetLoginParametersRequest () {
    return $self->send_query(
        'SystemSubscriberGetLoginParametersRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSubscriberModifyLoginParametersRequest (@generic_params) {
    return $self->send_command( 'SystemSubscriberModifyLoginParametersRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSubscriberModifyCallProcessingParametersRequest14sp7 (@generic_params) {
    return $self->send_command( 'SystemSubscriberModifyCallProcessingParametersRequest14sp7', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSubscriberGetCallProcessingParametersRequest18sp1 () {
    return $self->send_query(
        'SystemSubscriberGetCallProcessingParametersRequest18sp1',

    );
}

# ----------------------------------------------------------------------
method SystemSystemServiceCallProcessingPoliciesGetRequest () {
    return $self->send_query(
        'SystemSystemServiceCallProcessingPoliciesGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSystemServiceCallProcessingPoliciesModifyRequest (@generic_params) {
    return $self->send_command( 'SystemSystemServiceCallProcessingPoliciesModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSystemServiceDnAddListRequest (@generic_params) {
    return $self->send_command( 'SystemSystemServiceDnAddListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSystemServiceDnDeleteListRequest (@generic_params) {
    return $self->send_command( 'SystemSystemServiceDnDeleteListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSystemServiceDnGetAvailableListRequest () {
    return $self->send_query(
        'SystemSystemServiceDnGetAvailableListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSystemServiceDnGetSummaryListRequest () {
    return $self->send_query(
        'SystemSystemServiceDnGetSummaryListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSystemServiceDnGetUsageListRequest () {
    return $self->send_query(
        'SystemSystemServiceDnGetUsageListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSystemVoicePortalAddRequest ($x0, $x1, $x2, $x3, $x4, @generic_params) {
    return $self->send_command(
        'SystemSystemVoicePortalAddRequest',
        systemVoicePortalId => $x0,
        name                => $x1,
        callingLineIdName   => $x2,
        language            => $x3,
        timeZone            => $x4,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSystemVoicePortalDeleteRequest ($x0) {
    return $self->send_command( 'SystemSystemVoicePortalDeleteRequest', systemVoicePortalId => $x0 );
}

# ----------------------------------------------------------------------
method SystemSystemVoicePortalGetListRequest () {
    return $self->send_query(
        'SystemSystemVoicePortalGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSystemVoicePortalGetRequest ($x0) {
    return $self->send_query( 'SystemSystemVoicePortalGetRequest', systemVoicePortalId => $x0 );
}

# ----------------------------------------------------------------------
method SystemSystemVoicePortalModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemSystemVoicePortalModifyRequest',
        systemVoicePortalId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemTimeZoneGetListRequest20 () {
    return $self->send_query(
        'SystemTimeZoneGetListRequest20',

    );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeLanguageMappingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemSIPDeviceTypeLanguageMappingModifyRequest',
        deviceType => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeLanguageMappingGetListRequest ($x0) {
    return $self->send_query( 'SystemSIPDeviceTypeLanguageMappingGetListRequest', deviceType => $x0 );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeFileDeleteRequest14sp8 ($x0, $x1) {
    return $self->send_command(
        'SystemSIPDeviceTypeFileDeleteRequest14sp8',
        deviceType => $x0,
        fileFormat => $x1
    );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeFileModifyRequest16sp1 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemSIPDeviceTypeFileModifyRequest16sp1',
        deviceType => $x0,
        fileFormat => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeFileGetListRequest14sp8 ($x0) {
    return $self->send_query( 'SystemSIPDeviceTypeFileGetListRequest14sp8', deviceType => $x0 );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeFileGetRequest20 ($x0, $x1) {
    return $self->send_query(
        'SystemSIPDeviceTypeFileGetRequest20',
        deviceType => $x0,
        fileFormat => $x1
    );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeServiceModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemSIPDeviceTypeServiceModifyRequest',
        deviceType => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSIPDeviceTypeServiceGetRequest ($x0) {
    return $self->send_query( 'SystemSIPDeviceTypeServiceGetRequest', deviceType => $x0 );
}

# ----------------------------------------------------------------------
method SystemZoneAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemZoneAddRequest',
        zoneName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemZoneDeleteRequest ($x0) {
    return $self->send_command( 'SystemZoneDeleteRequest', zoneName => $x0 );
}

# ----------------------------------------------------------------------
method SystemZoneGetListRequest () {
    return $self->send_query(
        'SystemZoneGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemZoneCallingZonePhysicalLocationGetRequest ($x0) {
    return $self->send_query( 'SystemZoneCallingZonePhysicalLocationGetRequest', zoneName => $x0 );
}

# ----------------------------------------------------------------------
method SystemZoneCallingZonePhysicalLocationModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemZoneCallingZonePhysicalLocationModifyRequest',
        zoneName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemZoneLocationBasedPhysicalLocationAddListRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemZoneLocationBasedPhysicalLocationAddListRequest',
        zoneName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemZoneLocationBasedPhysicalLocationDeleteListRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemZoneLocationBasedPhysicalLocationDeleteListRequest',
        zoneName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemZoneLocationBasedPhysicalLocationGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemZoneLocationBasedPhysicalLocationGetListRequest',
        zoneName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemZoneNetAddressAddListRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemZoneNetAddressAddListRequest',
        zoneName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemZoneNetAddressDeleteListRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemZoneNetAddressDeleteListRequest',
        zoneName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemZoneNetAddressGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemZoneNetAddressGetListRequest',
        zoneName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSelectiveServicesGetRequest18sp1 () {
    return $self->send_query(
        'SystemSelectiveServicesGetRequest18sp1',

    );
}

# ----------------------------------------------------------------------
method SystemSelectiveServicesModifyRequest (@generic_params) {
    return $self->send_command( 'SystemSelectiveServicesModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## User
##
method UserAccessDeviceFileGetListRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'UserAccessDeviceFileGetListRequest',
        userId       => $x0,
        accessDevice => [ deviceLevel => $x1, deviceName => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserAccessDeviceFileGetRequest ($x0, $x1, $x2, $x3) {
    return $self->send_query(
        'UserAccessDeviceFileGetRequest',
        userId       => $x0,
        accessDevice => [ deviceLevel => $x1, deviceName => $x2 ],
        fileFormat   => $x3
    );
}

# ----------------------------------------------------------------------
method UserAccessDeviceFileModifyRequest ($x0, $x1, $x2, $x3, $x4) {
    return $self->send_command(
        'UserAccessDeviceFileModifyRequest',
        userId       => $x0,
        accessDevice => [ deviceLevel => $x1, deviceName => $x2 ],
        fileFormat   => $x3,
        uploadFile   => $x4
    );
}

# ----------------------------------------------------------------------
method UserAccessDeviceResetRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'UserAccessDeviceResetRequest',
        userId       => $x0,
        accessDevice => [ deviceLevel => $x1, deviceName => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserAccessDeviceTagsGetRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'UserAccessDeviceTagsGetRequest',
        userId       => $x0,
        accessDevice => [ deviceLevel => $x1, deviceName => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserAddRequest17sp4 ($x0, $x1, $x2, $x3, $x4, $x5, $x6, @generic_params) {
    return $self->send_command(
        'UserAddRequest17sp4',
        serviceProviderId      => $x0,
        groupId                => $x1,
        userId                 => $x2,
        lastName               => $x3,
        firstName              => $x4,
        callingLineIdLastName  => $x5,
        callingLineIdFirstName => $x6,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserAnnouncementFileAddRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'UserAnnouncementFileAddRequest',
        userId               => $x0,
        announcementFileName => $x1,
        announcementFile     => $x2
    );
}

# ----------------------------------------------------------------------
method UserAnnouncementFileDeleteListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'UserAnnouncementFileDeleteListRequest',
        userId              => $x0,
        announcementFileKey => [ name => $x1, mediaFileType => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserAnnouncementFileGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserAnnouncementFileGetListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserAnnouncementFileGetAvailableListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserAnnouncementFileGetAvailableListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserAnnouncementFileGetRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'UserAnnouncementFileGetRequest',
        userId              => $x0,
        announcementFileKey => [ name => $x1, mediaFileType => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserAnnouncementFileModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'UserAnnouncementFileModifyRequest',
        userId              => $x0,
        announcementFileKey => [ name => $x1, mediaFileType => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserAssignedServicesGetListRequest (@generic_params) {
    return $self->send_query( 'UserAssignedServicesGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserDeleteRequest ($x0) {
    return $self->send_command( 'UserDeleteRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserDnGetActivationListRequest ($x0) {
    return $self->send_query( 'UserDnGetActivationListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserGetRequest20 ($x0) {
    return $self->send_query( 'UserGetRequest20', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserGetRegistrationListRequest ($x0) {
    return $self->send_query( 'UserGetRegistrationListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserModifyRequest17sp4 (@generic_params) {
    return $self->send_query( 'UserModifyRequest17sp4', @generic_params );
}

# ----------------------------------------------------------------------
method UserCallLogsClearRequest14sp4 (@generic_params) {
    return $self->send_query( 'UserCallLogsClearRequest14sp4', @generic_params );
}

# ----------------------------------------------------------------------
method UserCallPoliciesGetRequest19sp1 ($x0) {
    return $self->send_query( 'UserCallPoliciesGetRequest19sp1', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallPoliciesModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallPoliciesModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallProcessingGetPolicyRequest19sp1 ($x0) {
    return $self->send_query( 'UserCallProcessingGetPolicyRequest19sp1', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallProcessingModifyPolicyRequest14sp7 ($x0, @generic_params) {
    return $self->send_command(
        'UserCallProcessingModifyPolicyRequest14sp7',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCommunicationBarringGetRequest ($x0) {
    return $self->send_query( 'UserCommunicationBarringGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCommunicationBarringModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCommunicationBarringModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCommunicationBarringAuthorizationCodeAddListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCommunicationBarringAuthorizationCodeAddListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCommunicationBarringAuthorizationCodeDeleteListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCommunicationBarringAuthorizationCodeDeleteListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCommunicationBarringAuthorizationCodeGetListRequest ($x0) {
    return $self->send_query( 'UserCommunicationBarringAuthorizationCodeGetListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserDevicePoliciesGetRequest20 ($x0) {
    return $self->send_query( 'UserDevicePoliciesGetRequest20', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserDevicePoliciesModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserDevicePoliciesModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserEnterpriseCommonPhoneListGetPagedSortedListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'UserEnterpriseCommonPhoneListGetPagedSortedListRequest',
        userId                => $x0,
        responsePagingControl => [ responseStartIndex => $x1, responsePageSize => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserFeatureAccessCodeGetListRequest20 ($x0) {
    return $self->send_query( 'UserFeatureAccessCodeGetListRequest20', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserGetListInGroupRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'UserGetListInGroupRequest',
        serviceProviderId => $x0,
        GroupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserGetListInServiceProviderRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserGetListInServiceProviderRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserGetListInSystemRequest (@generic_params) {
    return $self->send_query( 'UserGetListInSystemRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserGetServiceInstanceListInServiceProviderRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserGetServiceInstanceListInServiceProviderRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserGetServiceInstanceListInSystemRequest (@generic_params) {
    return $self->send_query( 'UserGetServiceInstanceListInSystemRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserGroupCommonPhoneListGetPagedSortedListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'UserGroupCommonPhoneListGetPagedSortedListRequest',
        userId                => $x0,
        responsePagingControl => [ responseStartIndex => $x1, responsePageSize => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserGroupCustomContactDirectoryGetPagedSortedListRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_query(
        'UserGroupCustomContactDirectoryGetPagedSortedListRequest',
        userId                => $x0,
        name                  => $x1,
        responsePagingControl => [ responseStartIndex => $x2, responsePageSize => $x3 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserLinePortGetListRequest ($x0) {
    return $self->send_query( 'UserLinePortGetListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserModifyUserIdRequest ($x0, $x1) {
    return $self->send_command(
        'UserModifyUserIdRequest',
        userId    => $x0,
        newUserId => $x1
    );
}

# ----------------------------------------------------------------------
method UserNetworkConferencingGetRequest ($x0) {
    return $self->send_query( 'UserNetworkConferencingGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOCICallControlApplicationGetListRequest ($x0) {
    return $self->send_query( 'UserOCICallControlApplicationGetListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOCICallControlApplicationModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOCICallControlApplicationModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPasswordInfoGetRequest ($x0) {
    return $self->send_query( 'UserPasswordInfoGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserPersonalPhoneListGetPagedSortedListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'UserPersonalPhoneListGetPagedSortedListRequest',
        userId                => $x0,
        responsePagingControl => [ responseStartIndex => $x1, responsePageSize => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPersonalPhoneListAddListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'UserPersonalPhoneListAddListRequest',
        userId => $x0,
        entry  => [ entryName => $x1, phoneNumber => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserPersonalPhoneListDeleteListRequest ($x0, $x1) {
    return $self->send_command(
        'UserPersonalPhoneListDeleteListRequest',
        userId    => $x0,
        entryName => $x1
    );
}

# ----------------------------------------------------------------------
method UserPersonalPhoneListGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserPersonalPhoneListGetListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPersonalPhoneListModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserPersonalPhoneListModifyRequest',
        userId    => $x0,
        entryName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPhoneDirectoryGetPagedSortedListRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_query(
        'UserPhoneDirectoryGetPagedSortedListRequest',
        userId                    => $x0,
        isEnterpriseInfoRequested => $x1,
        responsePagingControl     => [ responseStartIndex => $x2, responsePageSize => $x3 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPhoneDirectoryGetListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'UserPhoneDirectoryGetListRequest',
        userId                 => $x0,
        includeCommonPhoneList => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPhoneDirectoryGetPagedListRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_query(
        'UserPhoneDirectoryGetPagedListRequest',
        userId                    => $x0,
        isEnterpriseInfoRequested => $x1,
        responsePagingControl     => [ responseStartIndex => $x2, responsePageSize => $x3 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPhoneDirectoryGetSearchedListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserPhoneDirectoryGetSearchedListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPortalPasscodeGetInfoRequest ($x0) {
    return $self->send_query( 'UserPortalPasscodeGetInfoRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserPortalPasscodeModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserPortalPasscodeModifyRequest',
        userId => $x0,
        @generic_params, newPasscode => $x1
    );
}

# ----------------------------------------------------------------------
method UserPrimaryEndpointAdvancedSettingGetRequest ($x0) {
    return $self->send_query( 'UserPrimaryEndpointAdvancedSettingGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserPrimaryEndpointAdvancedSettingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserPrimaryEndpointAdvancedSettingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserScheduleAddEventRequest ($x0, $x1, $x2, $x3, $x4, @generic_params) {
    return $self->send_command(
        'UserScheduleAddEventRequest',
        userId      => $x0,
        scheduleKey => [ scheduleName => $x1, scheduleType => $x2 ],
        eventName   => $x3,
        startDate   => $x4,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserScheduleAddRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'UserScheduleAddRequest',
        userId       => $x0,
        scheduleName => $x1,
        scheduleType => $x2
    );
}

# ----------------------------------------------------------------------
method UserScheduleDeleteEventListRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'UserScheduleDeleteEventListRequest',
        userId      => $x0,
        scheduleKey => [ scheduleName => $x1, scheduleType => $x2 ],
        eventName   => $x3
    );
}

# ----------------------------------------------------------------------
method UserScheduleDeleteListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'UserScheduleDeleteListRequest',
        userId      => $x0,
        scheduleKey => [ scheduleName => $x1, scheduleType => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserScheduleGetEventListRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'UserScheduleGetEventListRequest',
        userId      => $x0,
        scheduleKey => [ scheduleName => $x1, scheduleType => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserScheduleGetEventRequest ($x0, $x1, $x2, $x3) {
    return $self->send_query(
        'UserScheduleGetEventRequest',
        userId      => $x0,
        scheduleKey => [ scheduleName => $x1, scheduleType => $x2 ],
        eventName   => $x3
    );
}

# ----------------------------------------------------------------------
method UserScheduleGetListRequest17sp1 ($x0, @generic_params) {
    return $self->send_query(
        'UserScheduleGetListRequest17sp1',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserScheduleModifyEventRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'UserScheduleModifyEventRequest',
        userId      => $x0,
        scheduleKey => [ scheduleName => $x1, scheduleType => $x2 ],
        eventName   => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserScheduleModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'UserScheduleModifyRequest',
        userId      => $x0,
        scheduleKey => [ scheduleName => $x1, scheduleType => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserServiceAssignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserServiceAssignListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserServiceGetAssignmentListRequest ($x0) {
    return $self->send_query( 'UserServiceGetAssignmentListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserServiceIsAssignedRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserServiceIsAssignedRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserServiceUnassignListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserServiceUnassignListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserShInterfaceGetPublicIdDataRequest ($x0) {
    return $self->send_query( 'UserShInterfaceGetPublicIdDataRequest', publicUserIdentity => $x0 );
}

# ----------------------------------------------------------------------
method UserShInterfaceGetUserIdDataRequest ($x0) {
    return $self->send_query( 'UserShInterfaceGetUserIdDataRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserShInterfaceModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserShInterfaceModifyRequest',
        publicUserIdentity => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserShInterfacePublicIdentityRefreshTaskStartRequest ($x0) {
    return $self->send_command( 'UserShInterfacePublicIdentityRefreshTaskStartRequest', publicUserIdentity => $x0 );
}

# ----------------------------------------------------------------------
method UserScheduleGetEventDetailListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserScheduleGetEventDetailListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## Service3G4GContinuity
##
##
## ServiceAccountAuthorizationCodes
##
method GroupAccountAuthorizationCodesAddListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupAccountAuthorizationCodesAddListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        codeEntry         => $x2
    );
}

# ----------------------------------------------------------------------
method GroupAccountAuthorizationCodesDeleteListRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupAccountAuthorizationCodesDeleteListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        code              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupAccountAuthorizationCodesGetAvailableUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupAccountAuthorizationCodesGetAvailableUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAccountAuthorizationCodesGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupAccountAuthorizationCodesGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupAccountAuthorizationCodesGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupAccountAuthorizationCodesGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupAccountAuthorizationCodesModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupAccountAuthorizationCodesModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceAdviceOfCharge
##
method SystemAdviceOfChargeGetRequest19sp1 () {
    return $self->send_query(
        'SystemAdviceOfChargeGetRequest19sp1',

    );
}

# ----------------------------------------------------------------------
method SystemAdviceOfChargeModifyRequest19sp1 (@generic_params) {
    return $self->send_command( 'SystemAdviceOfChargeModifyRequest19sp1', @generic_params );
}

# ----------------------------------------------------------------------
method SystemAdviceOfChargeCostInformationSourceAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemAdviceOfChargeCostInformationSourceAddRequest',
        peerIdentity => $x0,
        priority     => $x1
    );
}

# ----------------------------------------------------------------------
method SystemAdviceOfChargeCostInformationSourceDeleteRequest ($x0) {
    return $self->send_command( 'SystemAdviceOfChargeCostInformationSourceDeleteRequest', peerIdentity => $x0 );
}

# ----------------------------------------------------------------------
method SystemAdviceOfChargeCostInformationSourceGetListRequest () {
    return $self->send_query(
        'SystemAdviceOfChargeCostInformationSourceGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAdviceOfChargeCostInformationSourceModifyRequest ($x0, $x1) {
    return $self->send_command(
        'SystemAdviceOfChargeCostInformationSourceModifyRequest',
        peerIdentity => $x0,
        priority     => $x1
    );
}

# ----------------------------------------------------------------------
method UserAdviceOfChargeGetRequest ($x0) {
    return $self->send_query( 'UserAdviceOfChargeGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderAdviceOfChargeGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderAdviceOfChargeGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderAdviceOfChargeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderAdviceOfChargeModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAdviceOfChargeGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupAdviceOfChargeGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupAdviceOfChargeModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupAdviceOfChargeModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserAdviceOfChargeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserAdviceOfChargeModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceAlternateNumbers
##
method UserAlternateNumbersGetRequest17 ($x0) {
    return $self->send_query( 'UserAlternateNumbersGetRequest17', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserAlternateNumbersModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserAlternateNumbersModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceAnonymousCallRejection
##
method UserAnonymousCallRejectionGetRequest ($x0) {
    return $self->send_query( 'UserAnonymousCallRejectionGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserAnonymousCallRejectionModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserAnonymousCallRejectionModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemAnonymousCallRejectionGetRequest () {
    return $self->send_query(
        'SystemAnonymousCallRejectionGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAnonymousCallRejectionModifyRequest (@generic_params) {
    return $self->send_command( 'SystemAnonymousCallRejectionModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceAttendantConsole
##
method SystemAttendantConsoleGetRequest () {
    return $self->send_query(
        'SystemAttendantConsoleGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAttendantConsoleModifyRequest (@generic_params) {
    return $self->send_command( 'SystemAttendantConsoleModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserAttendantConsoleAddUserListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserAttendantConsoleAddUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserAttendantConsoleDeleteUserListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserAttendantConsoleDeleteUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserAttendantConsoleGetAvailableUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserAttendantConsoleGetAvailableUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserAttendantConsoleGetRequest14sp2 ($x0) {
    return $self->send_query( 'UserAttendantConsoleGetRequest14sp2', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserAttendantConsoleModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserAttendantConsoleModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceAuthentication
##
method UserAuthenticationGetRequest ($x0) {
    return $self->send_query( 'UserAuthenticationGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserAuthenticationModifyRequest (@generic_params) {
    return $self->send_query( 'UserAuthenticationModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceAutoAttendant
##
method GroupAutoAttendantAddInstanceRequest20 ($x0, $x1, $x2, $x3, $x4, $x5, $x6, @generic_params) {
    return $self->send_command(
        'GroupAutoAttendantAddInstanceRequest20',
        serviceProviderId        => $x0,
        groupId                  => $x1,
        serviceUserId            => $x2,
        serviceInstanceProfile   => $x3,
        type                     => $x4,
        firstDigitTimeoutSeconds => $x5,
        enableVideo              => $x6,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAutoAttendantDeleteInstanceRequest ($x0) {
    return $self->send_command( 'GroupAutoAttendantDeleteInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupAutoAttendantGetInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupAutoAttendantGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAutoAttendantGetInstanceRequest20 ($x0) {
    return $self->send_query( 'GroupAutoAttendantGetInstanceRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupAutoAttendantModifyActiveInstanceListRequest (@generic_params) {
    return $self->send_command( 'GroupAutoAttendantModifyActiveInstanceListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupAutoAttendantModifyInstanceRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupAutoAttendantModifyInstanceRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAutoAttendantSubmenuGetListRequest ($x0) {
    return $self->send_query( 'GroupAutoAttendantSubmenuGetListRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupAutoAttendantSubmenuGetUsageListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupAutoAttendantSubmenuGetUsageListRequest',
        serviceUserId => $x0,
        submenuId     => $x1
    );
}

# ----------------------------------------------------------------------
method GroupAutoAttendantSubmenuGetRequest20 ($x0, $x1) {
    return $self->send_query(
        'GroupAutoAttendantSubmenuGetRequest20',
        serviceUserId => $x0,
        submenuId     => $x1
    );
}

# ----------------------------------------------------------------------
method GroupAutoAttendantSubmenuModifyRequest20 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupAutoAttendantSubmenuModifyRequest20',
        serviceUserId => $x0,
        submenuId     => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAutoAttendantSubmenuAddRequest20 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupAutoAttendantSubmenuAddRequest20',
        serviceUserId         => $x0,
        submenuId             => $x1,
        announcementSelection => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupAutoAttendantSubmenuDeleteListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupAutoAttendantSubmenuDeleteListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceAutomaticCallback
##
method SystemAutomaticCallbackGetRequest17 () {
    return $self->send_query(
        'SystemAutomaticCallbackGetRequest17',

    );
}

# ----------------------------------------------------------------------
method SystemAutomaticCallbackModifyRequest15 (@generic_params) {
    return $self->send_command( 'SystemAutomaticCallbackModifyRequest15', @generic_params );
}

# ----------------------------------------------------------------------
method SystemAutomaticCallbackGetReleaseCauseListRequest () {
    return $self->send_query(
        'SystemAutomaticCallbackGetReleaseCauseListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemAutomaticCallbackAddReleaseCauseListRequest (@generic_params) {
    return $self->send_command( 'SystemAutomaticCallbackAddReleaseCauseListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemAutomaticCallbackDeleteReleaseCauseListRequest (@generic_params) {
    return $self->send_command( 'SystemAutomaticCallbackDeleteReleaseCauseListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserAutomaticCallbackGetRequest ($x0) {
    return $self->send_query( 'UserAutomaticCallbackGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserAutomaticCallbackModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserAutomaticCallbackModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceAutomaticHoldRetrieve
##
method UserAutomaticHoldRetrieveGetRequest ($x0) {
    return $self->send_query( 'UserAutomaticHoldRetrieveGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserAutomaticHoldRetrieveModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserAutomaticHoldRetrieveModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceBargeInExempt
##
method UserBargeInExemptGetRequest ($x0) {
    return $self->send_query( 'UserBargeInExemptGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserBargeInExemptModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserBargeInExemptModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceBasicCallLogs
##
method UserBasicCallLogsGetListRequest14sp4 ($x0, @generic_params) {
    return $self->send_query(
        'UserBasicCallLogsGetListRequest14sp4',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceBroadWorksAnywhere
##
method GroupBroadWorksAnywhereAddInstanceRequest ($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, @generic_params) {
    return $self->send_command(
        'GroupBroadWorksAnywhereAddInstanceRequest',
        serviceProviderId       => $x0,
        groupId                 => $x1,
        serviceUserId           => $x2,
        serviceInstanceProfile  => $x3,
        broadWorksAnywhereScope => $x4,
        promptForCLID           => $x5,
        silentPromptMode        => $x6,
        promptForPasscode       => $x7,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksAnywhereDeleteInstanceRequest ($x0) {
    return $self->send_command( 'GroupBroadWorksAnywhereDeleteInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupBroadWorksAnywhereGetInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupBroadWorksAnywhereGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksAnywhereGetInstanceRequest19sp1 ($x0) {
    return $self->send_query( 'GroupBroadWorksAnywhereGetInstanceRequest19sp1', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupBroadWorksAnywhereModifyActiveInstanceListRequest (@generic_params) {
    return $self->send_command( 'GroupBroadWorksAnywhereModifyActiveInstanceListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupBroadWorksAnywhereModifyInstanceRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupBroadWorksAnywhereModifyInstanceRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksAnywhereAddPhoneNumberRequest ($x0, $x1, $x2, $x3, $x4, @generic_params) {
    return $self->send_command(
        'UserBroadWorksAnywhereAddPhoneNumberRequest',
        userId      => $x0,
        phoneNumber => $x1,
        @generic_params,
        broadworksCallControl      => $x2,
        useDiversionInhibitor      => $x3,
        answerConfirmationRequired => $x4
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksAnywhereAddSelectiveCriteriaRequest16 ($x0, $x1, $x2, $x3, $x4, @generic_params) {
    return $self->send_command(
        'UserBroadWorksAnywhereAddSelectiveCriteriaRequest16',
        userId       => $x0,
        phoneNumber  => $x1,
        criteriaName => $x2,
        @generic_params,
        blacklisted    => $x3,
        fromDnCriteria => $x4
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksAnywhereDeletePhoneNumberRequest ($x0, $x1) {
    return $self->send_command(
        'UserBroadWorksAnywhereDeletePhoneNumberRequest',
        userId      => $x0,
        phoneNumber => $x1
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksAnywhereDeleteSelectiveCriteriaRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'UserBroadWorksAnywhereDeleteSelectiveCriteriaRequest',
        userId       => $x0,
        phoneNumber  => $x1,
        criteriaName => $x2
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksAnywhereGetAvailablePortalListRequest ($x0) {
    return $self->send_query( 'UserBroadWorksAnywhereGetAvailablePortalListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserBroadWorksAnywhereGetPhoneNumberRequest ($x0, $x1) {
    return $self->send_query(
        'UserBroadWorksAnywhereGetPhoneNumberRequest',
        userId      => $x0,
        phoneNumber => $x1
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksAnywhereGetRequest16sp2 ($x0) {
    return $self->send_query( 'UserBroadWorksAnywhereGetRequest16sp2', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserBroadWorksAnywhereGetSelectiveCriteriaRequest16 ($x0, $x1, $x2) {
    return $self->send_query(
        'UserBroadWorksAnywhereGetSelectiveCriteriaRequest16',
        userId       => $x0,
        phoneNumber  => $x1,
        criteriaName => $x2
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksAnywhereModifyPhoneNumberRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserBroadWorksAnywhereModifyPhoneNumberRequest',
        userId      => $x0,
        phoneNumber => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksAnywhereModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserBroadWorksAnywhereModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksAnywhereModifySelectiveCriteriaRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'UserBroadWorksAnywhereModifySelectiveCriteriaRequest',
        userId       => $x0,
        phoneNumber  => $x1,
        criteriaName => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceBroadWorksMobility
##
method SystemBroadWorksMobilityAddIMRNListRequest (@generic_params) {
    return $self->send_command( 'SystemBroadWorksMobilityAddIMRNListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemBroadWorksMobilityDeleteIMRNListRequest (@generic_params) {
    return $self->send_command( 'SystemBroadWorksMobilityDeleteIMRNListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemBroadWorksMobilityGetIMRNListRequest (@generic_params) {
    return $self->send_query( 'SystemBroadWorksMobilityGetIMRNListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemBroadWorksMobilityServiceAccessCodeAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemBroadWorksMobilityServiceAccessCodeAddRequest',
        serviceAccessCode => $x0,
        countryCode       => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemBroadWorksMobilityServiceAccessCodeDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'SystemBroadWorksMobilityServiceAccessCodeDeleteRequest',
        countryCode       => $x0,
        serviceAccessCode => $x1
    );
}

# ----------------------------------------------------------------------
method SystemBroadWorksMobilityServiceAccessCodeGetListRequest () {
    return $self->send_query(
        'SystemBroadWorksMobilityServiceAccessCodeGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemBroadWorksMobilityServiceAccessCodeModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemBroadWorksMobilityServiceAccessCodeModifyRequest',
        countryCode       => $x0,
        serviceAccessCode => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemBroadWorksMobilityGetRequest19sp1 () {
    return $self->send_query(
        'SystemBroadWorksMobilityGetRequest19sp1',

    );
}

# ----------------------------------------------------------------------
method SystemBroadWorksMobilityModifyRequest17sp4 (@generic_params) {
    return $self->send_command( 'SystemBroadWorksMobilityModifyRequest17sp4', @generic_params );
}

# ----------------------------------------------------------------------
method ServiceProviderBroadWorksMobilityGetRequest19sp1 ($x0) {
    return $self->send_query( 'ServiceProviderBroadWorksMobilityGetRequest19sp1', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderBroadWorksMobilityModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderBroadWorksMobilityModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberAddListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberAddListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberDeleteListRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberDeleteListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest ($x0) {
    return $self->send_query( 'ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListRequest ($x0, @generic_params) {
    return $self->send_query(
        'ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest22 ($x0) {
    return $self->send_query( 'EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest22',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobilityGetRequest19sp1 ($x0, $x1) {
    return $self->send_query(
        'GroupBroadWorksMobilityGetRequest19sp1',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobilityModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupBroadWorksMobilityModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobilityMobileSubscriberDirectoryNumberAssignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupBroadWorksMobilityMobileSubscriberDirectoryNumberAssignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupBroadWorksMobilityMobileSubscriberDirectoryNumberUnassignListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupBroadWorksMobilityMobileSubscriberDirectoryNumberUnassignListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksMobilityGetRequest ($x0) {
    return $self->send_query( 'UserBroadWorksMobilityGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserBroadWorksMobilityModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'UserBroadWorksMobilityModifyRequest20',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceBusyLampField
##
method SystemBusyLampFieldGetRequest18 () {
    return $self->send_query(
        'SystemBusyLampFieldGetRequest18',

    );
}

# ----------------------------------------------------------------------
method SystemBusyLampFieldModifyRequest (@generic_params) {
    return $self->send_command( 'SystemBusyLampFieldModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserBusyLampFieldGetAvailableUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserBusyLampFieldGetAvailableUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserBusyLampFieldGetRequest16sp2 ($x0) {
    return $self->send_query( 'UserBusyLampFieldGetRequest16sp2', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserBusyLampFieldModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserBusyLampFieldModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallCapacityManagement
##
method GroupCallCapacityManagementAddInstanceRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupCallCapacityManagementAddInstanceRequest',
        serviceProviderId     => $x0,
        groupId               => $x1,
        name                  => $x2,
        maxActiveCallsAllowed => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCapacityManagementDeleteInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallCapacityManagementDeleteInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCapacityManagementGetAvailableUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCallCapacityManagementGetAvailableUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCapacityManagementGetInstanceListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallCapacityManagementGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCapacityManagementGetInstanceRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupCallCapacityManagementGetInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCapacityManagementModifyInstanceRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCapacityManagementModifyInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCapacityManagementAddUserListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCapacityManagementAddUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCapacityManagementDeleteUserListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCapacityManagementDeleteUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallCenter
##
method EnterpriseCallCenterAgentThresholdDefaultProfileGetRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'EnterpriseCallCenterAgentThresholdDefaultProfileGetRequest',
        serviceProviderId  => $x0,
        includeAgentsTable => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentThresholdProfileAddAgentListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterAgentThresholdProfileAddAgentListRequest',
        serviceProviderId => $x0,
        profileName       => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentThresholdProfileAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterAgentThresholdProfileAddRequest',
        serviceProviderId => $x0,
        profileName       => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentThresholdProfileDeleteAgentListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterAgentThresholdProfileDeleteAgentListRequest',
        serviceProviderId => $x0,
        profileName       => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentThresholdProfileDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseCallCenterAgentThresholdProfileDeleteRequest',
        serviceProviderId => $x0,
        profileName       => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentThresholdProfileGetListRequest ($x0) {
    return $self->send_query( 'EnterpriseCallCenterAgentThresholdProfileGetListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentThresholdProfileGetRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseCallCenterAgentThresholdProfileGetRequest',
        serviceProviderId => $x0,
        profileName       => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentThresholdProfileModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterAgentThresholdProfileModifyRequest',
        serviceProviderId => $x0,
        profileName       => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentUnavailableCodeAddRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterAgentUnavailableCodeAddRequest',
        serviceProviderId => $x0,
        isActive          => $x1,
        code              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentUnavailableCodeDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseCallCenterAgentUnavailableCodeDeleteRequest',
        serviceProviderId => $x0,
        code              => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentUnavailableCodeGetListRequest ($x0) {
    return $self->send_query( 'EnterpriseCallCenterAgentUnavailableCodeGetListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentUnavailableCodeGetRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseCallCenterAgentUnavailableCodeGetRequest',
        serviceProviderId => $x0,
        code              => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentUnavailableCodeModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterAgentUnavailableCodeModifyRequest',
        serviceProviderId => $x0,
        code              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4 ($x0) {
    return $self->send_query( 'EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterAgentUnavailableCodeSettingsModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterAgentUnavailableCodeSettingsModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterCallDispositionCodeAddRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterCallDispositionCodeAddRequest',
        serviceProviderId => $x0,
        code              => $x1,
        isActive          => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterCallDispositionCodeDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseCallCenterCallDispositionCodeDeleteRequest',
        serviceProviderId => $x0,
        code              => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterCallDispositionCodeGetListRequest ($x0) {
    return $self->send_query( 'EnterpriseCallCenterCallDispositionCodeGetListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterCallDispositionCodeGetRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseCallCenterCallDispositionCodeGetRequest',
        serviceProviderId => $x0,
        code              => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterCallDispositionCodeGetUsageListRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseCallCenterCallDispositionCodeGetUsageListRequest',
        serviceProviderId => $x0,
        code              => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterCallDispositionCodeModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterCallDispositionCodeModifyRequest',
        serviceProviderId => $x0,
        code              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterCallDispositionCodeModifyActiveListRequest ($x0, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterCallDispositionCodeModifyActiveListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterCurrentAndPastAgentGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseCallCenterCurrentAndPastAgentGetListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterCurrentAndPastCallCenterGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseCallCenterCurrentAndPastCallCenterGetListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterCurrentAndPastDNISGetListRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseCallCenterCurrentAndPastDNISGetListRequest',
        serviceProviderId => $x0,
        serviceUserId     => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingBrandingGetRequest ($x0) {
    return $self->send_query( 'EnterpriseCallCenterEnhancedReportingBrandingGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingBrandingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterEnhancedReportingBrandingModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListRequest ($x0) {
    return $self->send_query( 'EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListRequest',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingGetRequest19 ($x0) {
    return $self->send_query( 'EnterpriseCallCenterEnhancedReportingGetRequest19', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingModifyRequest19 ($x0, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterEnhancedReportingModifyRequest19',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingReportTemplateAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterEnhancedReportingReportTemplateAddRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingReportTemplateDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseCallCenterEnhancedReportingReportTemplateDeleteRequest',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingReportTemplateGetListRequest ($x0) {
    return $self->send_query( 'EnterpriseCallCenterEnhancedReportingReportTemplateGetListRequest',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingReportTemplateGetRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseCallCenterEnhancedReportingReportTemplateGetRequest',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingReportTemplateModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterEnhancedReportingReportTemplateModifyRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingScheduledReportAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterEnhancedReportingScheduledReportAddRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingScheduledReportDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseCallCenterEnhancedReportingScheduledReportDeleteRequest',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingScheduledReportGetActiveListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseCallCenterEnhancedReportingScheduledReportGetActiveListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingScheduledReportGetCompletedListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseCallCenterEnhancedReportingScheduledReportGetCompletedListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingScheduledReportGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseCallCenterEnhancedReportingScheduledReportGetListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingScheduledReportGetRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseCallCenterEnhancedReportingScheduledReportGetRequest',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest',
        serviceProviderId => $x0,
        name              => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterEnhancedReportingScheduledReportModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterEnhancedReportingScheduledReportModifyRequest',
        serviceProviderId => $x0,
        name              => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterGetRequest17sp4 ($x0) {
    return $self->send_query( 'EnterpriseCallCenterGetRequest17sp4', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterGetRoutingPolicyRequest ($x0) {
    return $self->send_query( 'EnterpriseCallCenterGetRoutingPolicyRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseCallCenterModifyRoutingPolicyRequest ($x0, @generic_params) {
    return $self->send_command(
        'EnterpriseCallCenterModifyRoutingPolicyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAddAgentListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterAddAgentListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAddInstanceRequest19 ($x0, $x1, $x2, $x3, $x4, @generic_params) {
    return $self->send_command(
        'GroupCallCenterAddInstanceRequest19',
        serviceProviderId      => $x0,
        groupId                => $x1,
        serviceUserId          => $x2,
        serviceInstanceProfile => $x3,
        type                   => $x4,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAddDNISRequest ($x0, $x1, $x2, $x3, $x4, @generic_params) {
    return $self->send_command(
        'GroupCallCenterAddDNISRequest',
        dnisKey => [ serviceUserId => $x0, name => $x1 ],
        @generic_params,
        useCustomDnisAnnouncementSettings => $x2,
        priority                          => $x3,
        allowOutgoingACDCall              => $x4
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAddSupervisorListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterAddSupervisorListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentThresholdDefaultProfileGetRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupCallCenterAgentThresholdDefaultProfileGetRequest',
        serviceProviderId  => $x0,
        groupId            => $x1,
        includeAgentsTable => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentThresholdProfileAddAgentListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCenterAgentThresholdProfileAddAgentListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        profileName       => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentThresholdProfileAddRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCenterAgentThresholdProfileAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        profileName       => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentThresholdProfileDeleteAgentListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCenterAgentThresholdProfileDeleteAgentListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        profileName       => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentThresholdProfileDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCallCenterAgentThresholdProfileDeleteRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        profileName       => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentThresholdProfileGetAvailableAgentListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCallCenterAgentThresholdProfileGetAvailableAgentListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentThresholdProfileGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterAgentThresholdProfileGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentThresholdProfileGetRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupCallCenterAgentThresholdProfileGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        profileName       => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentThresholdProfileModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCenterAgentThresholdProfileModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        profileName       => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentUnavailableCodeAddRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupCallCenterAgentUnavailableCodeAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        isActive          => $x2,
        code              => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentUnavailableCodeDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCallCenterAgentUnavailableCodeDeleteRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        code              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentUnavailableCodeGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterAgentUnavailableCodeGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentUnavailableCodeGetRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupCallCenterAgentUnavailableCodeGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        code              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentUnavailableCodeModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCenterAgentUnavailableCodeModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        code              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4 ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterAgentUnavailableCodeSettingsModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallCenterAgentUnavailableCodeSettingsModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterBouncedCallGetRequest17 ($x0) {
    return $self->send_query( 'GroupCallCenterBouncedCallGetRequest17', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterBouncedCallModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterBouncedCallModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterCallDispositionCodeAddRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupCallCenterCallDispositionCodeAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        code              => $x2,
        isActive          => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterCallDispositionCodeDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCallCenterCallDispositionCodeDeleteRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        code              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterCallDispositionCodeGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterCallDispositionCodeGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterCallDispositionCodeGetRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupCallCenterCallDispositionCodeGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        code              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterCallDispositionCodeGetUsageListRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupCallCenterCallDispositionCodeGetUsageListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        code              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterCallDispositionCodeModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCenterCallDispositionCodeModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        code              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterCallDispositionCodeModifyActiveListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallCenterCallDispositionCodeModifyActiveListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterComfortMessageBypassGetRequest20 ($x0) {
    return $self->send_query( 'GroupCallCenterComfortMessageBypassGetRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterComfortMessageBypassModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterComfortMessageBypassModifyRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterCurrentAndPastAgentGetListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCallCenterCurrentAndPastAgentGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterCurrentAndPastCallCenterGetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'GroupCallCenterCurrentAndPastCallCenterGetListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterCurrentAndPastDNISGetListRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupCallCenterCurrentAndPastDNISGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        serviceUserId     => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterDeleteAgentListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterDeleteAgentListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterDeleteDNISRequest ($x0, $x1) {
    return $self->send_command( 'GroupCallCenterDeleteDNISRequest', dnisKey => [ serviceUserId => $x0, name => $x1 ] );
}

# ----------------------------------------------------------------------
method GroupCallCenterDeleteInstanceRequest ($x0) {
    return $self->send_command( 'GroupCallCenterDeleteInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterDeleteSupervisorListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterDeleteSupervisorListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterDistinctiveRingingGetRequest ($x0) {
    return $self->send_query( 'GroupCallCenterDistinctiveRingingGetRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterDistinctiveRingingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterDistinctiveRingingModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingBrandingGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterEnhancedReportingBrandingGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingBrandingModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallCenterEnhancedReportingBrandingModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingGetAvailableReportTemplateListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterEnhancedReportingGetAvailableReportTemplateListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingGetRequest19 ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterEnhancedReportingGetRequest19',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingModifyRequest19 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallCenterEnhancedReportingModifyRequest19',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingReportTemplateAddRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCenterEnhancedReportingReportTemplateAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingReportTemplateDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCallCenterEnhancedReportingReportTemplateDeleteRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingReportTemplateGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterEnhancedReportingReportTemplateGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingReportTemplateGetRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupCallCenterEnhancedReportingReportTemplateGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingReportTemplateModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCenterEnhancedReportingReportTemplateModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingScheduledReportAddRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCenterEnhancedReportingScheduledReportAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingScheduledReportDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCallCenterEnhancedReportingScheduledReportDeleteRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingScheduledReportGetActiveListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCallCenterEnhancedReportingScheduledReportGetActiveListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingScheduledReportGetCompletedListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCallCenterEnhancedReportingScheduledReportGetCompletedListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingScheduledReportGetListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCallCenterEnhancedReportingScheduledReportGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingScheduledReportGetRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupCallCenterEnhancedReportingScheduledReportGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterEnhancedReportingScheduledReportModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCenterEnhancedReportingScheduledReportModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterForcedForwardingGetRequest20 ($x0) {
    return $self->send_query( 'GroupCallCenterForcedForwardingGetRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterForcedForwardingModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterForcedForwardingModifyRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetAgentListRequest ($x0, @generic_params) {
    return $self->send_query(
        'GroupCallCenterGetAgentListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetAnnouncementRequest20 ($x0) {
    return $self->send_query( 'GroupCallCenterGetAnnouncementRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetAvailableAgentListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupCallCenterGetAvailableAgentListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        callCenterType    => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetAvailableSupervisorListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCallCenterGetAvailableSupervisorListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetDNISAgentListRequest ($x0, $x1) {
    return $self->send_query( 'GroupCallCenterGetDNISAgentListRequest',
        dnisKey => [ serviceUserId => $x0, name => $x1 ] );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetDNISAnnouncementRequest20 ($x0, $x1) {
    return $self->send_query( 'GroupCallCenterGetDNISAnnouncementRequest20',
        dnisKey => [ serviceUserId => $x0, name => $x1 ] );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetDNISListRequest ($x0) {
    return $self->send_query( 'GroupCallCenterGetDNISListRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetDNISRequest ($x0, $x1) {
    return $self->send_query( 'GroupCallCenterGetDNISRequest', dnisKey => [ serviceUserId => $x0, name => $x1 ] );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCallCenterGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetDistinctiveRingingRequest ($x0) {
    return $self->send_query( 'GroupCallCenterGetDistinctiveRingingRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetInstanceRequest19sp1 ($x0) {
    return $self->send_query( 'GroupCallCenterGetInstanceRequest19sp1', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetInstanceStatisticsReportingRequest17sp1 ($x0) {
    return $self->send_query( 'GroupCallCenterGetInstanceStatisticsReportingRequest17sp1', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetInstanceStatisticsRequest14sp9 ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterGetInstanceStatisticsRequest14sp9',
        serviceUserId   => $x0,
        statisticsRange => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetInstanceQueueStatusRequest ($x0) {
    return $self->send_query( 'GroupCallCenterGetInstanceQueueStatusRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetRequest17sp4 ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterGetRequest17sp4',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetRoutingPolicyRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterGetRoutingPolicyRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetSupervisorListRequest16 ($x0) {
    return $self->send_query( 'GroupCallCenterGetSupervisorListRequest16', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterGetUnlicensedAgentListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterGetUnlicensedAgentListRequest',
        serviceUserId  => $x0,
        callCenterType => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterHolidayServiceGetRequest20 ($x0) {
    return $self->send_query( 'GroupCallCenterHolidayServiceGetRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterHolidayServiceModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterHolidayServiceModifyRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyActiveInstanceListRequest (@generic_params) {
    return $self->send_command( 'GroupCallCenterModifyActiveInstanceListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyAgentListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifyAgentListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyAnnouncementRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifyAnnouncementRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyDNISAnnouncementRequest20 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifyDNISAnnouncementRequest20',
        dnisKey => [ serviceUserId => $x0, name => $x1 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyDistinctiveRingingRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifyDistinctiveRingingRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyDNISParametersRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifyDNISParametersRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyDNISRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifyDNISRequest',
        dnisKey => [ serviceUserId => $x0, name => $x1 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyInstanceRequest19 ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifyInstanceRequest19',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyInstanceStatisticsReportingRequest17sp1 ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifyInstanceStatisticsReportingRequest17sp1',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyInstanceWeightedCallDistributionRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifyInstanceWeightedCallDistributionRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifyRoutingPolicyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifyRoutingPolicyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterModifySupervisorListRequest16 ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterModifySupervisorListRequest16',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterNightServiceGetRequest20 ($x0) {
    return $self->send_query( 'GroupCallCenterNightServiceGetRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterNightServiceModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterNightServiceModifyRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterOverflowGetRequest20 ($x0) {
    return $self->send_query( 'GroupCallCenterOverflowGetRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterOverflowModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterOverflowModifyRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterQueueStatusNotificationGetRequest ($x0) {
    return $self->send_query( 'GroupCallCenterQueueStatusNotificationGetRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterQueueStatusNotificationModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterQueueStatusNotificationModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterQueueCallDispositionCodeAddRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallCenterQueueCallDispositionCodeAddRequest',
        serviceUserId => $x0,
        code          => $x1,
        isActive      => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterQueueCallDispositionCodeDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'GroupCallCenterQueueCallDispositionCodeDeleteRequest',
        serviceUserId => $x0,
        code          => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterQueueCallDispositionCodeGetListRequest ($x0) {
    return $self->send_query( 'GroupCallCenterQueueCallDispositionCodeGetListRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterQueueCallDispositionCodeGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallCenterQueueCallDispositionCodeGetRequest',
        serviceUserId => $x0,
        code          => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterQueueCallDispositionCodeModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallCenterQueueCallDispositionCodeModifyRequest',
        serviceUserId => $x0,
        code          => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterQueueCallDispositionCodeSettingsGetRequest ($x0) {
    return $self->send_query( 'GroupCallCenterQueueCallDispositionCodeSettingsGetRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterQueueCallDispositionCodeSettingsModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterQueueCallDispositionCodeSettingsModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterQueueThresholdsGetRequest ($x0) {
    return $self->send_query( 'GroupCallCenterQueueThresholdsGetRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterQueueThresholdsModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterQueueThresholdsModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterStrandedCallGetRequest20 ($x0) {
    return $self->send_query( 'GroupCallCenterStrandedCallGetRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterStrandedCallModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterStrandedCallModifyRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallCenterStrandedCallUnavailableGetRequest20 ($x0) {
    return $self->send_query( 'GroupCallCenterStrandedCallUnavailableGetRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupCallCenterStrandedCallUnavailableModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupCallCenterStrandedCallUnavailableModifyRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingBrandingGetRequest () {
    return $self->send_query(
        'SystemCallCenterEnhancedReportingBrandingGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingBrandingModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCallCenterEnhancedReportingBrandingModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingDataTemplateGetListRequest () {
    return $self->send_query(
        'SystemCallCenterEnhancedReportingDataTemplateGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingGetRequest () {
    return $self->send_query(
        'SystemCallCenterEnhancedReportingGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCallCenterEnhancedReportingModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingReportTemplateAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCallCenterEnhancedReportingReportTemplateAddRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingReportTemplateDeleteRequest ($x0) {
    return $self->send_command( 'SystemCallCenterEnhancedReportingReportTemplateDeleteRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingReportTemplateGetListRequest () {
    return $self->send_query(
        'SystemCallCenterEnhancedReportingReportTemplateGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingReportTemplateGetRequest ($x0) {
    return $self->send_query( 'SystemCallCenterEnhancedReportingReportTemplateGetRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingReportTemplateModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCallCenterEnhancedReportingReportTemplateModifyRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingScheduledReportGetActiveListRequest (@generic_params) {
    return $self->send_query( 'SystemCallCenterEnhancedReportingScheduledReportGetActiveListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingScheduledReportGetCompletedListRequest (@generic_params) {
    return $self->send_query( 'SystemCallCenterEnhancedReportingScheduledReportGetCompletedListRequest',
        @generic_params );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingScheduledReportGetListRequest (@generic_params) {
    return $self->send_query( 'SystemCallCenterEnhancedReportingScheduledReportGetListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest ($x0) {
    return $self->send_query( 'SystemCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest',
        name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingScheduledTaskParametersGetRequest () {
    return $self->send_query(
        'SystemCallCenterEnhancedReportingScheduledTaskParametersGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallCenterEnhancedReportingScheduledTaskParametersModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCallCenterEnhancedReportingScheduledTaskParametersModifyRequest',
        @generic_params );
}

# ----------------------------------------------------------------------
method SystemCallCenterGetRequest19 () {
    return $self->send_query(
        'SystemCallCenterGetRequest19',

    );
}

# ----------------------------------------------------------------------
method SystemCallCenterModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCallCenterModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserCallCenterAddSupervisedAgentListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserCallCenterAddSupervisedAgentListRequest',
        supervisorUserId => $x0,
        serviceUserId    => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallCenterAgentSignOutRequest ($x0) {
    return $self->send_query( 'UserCallCenterAgentSignOutRequest', agentUserId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallCenterAgentDetailsGetRequest ($x0) {
    return $self->send_query( 'UserCallCenterAgentDetailsGetRequest', agentUserId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallCenterCallDispositionCodeGetAvailableListRequest ($x0) {
    return $self->send_query( 'UserCallCenterCallDispositionCodeGetAvailableListRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallCenterDeleteSupervisedAgentListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserCallCenterDeleteSupervisedAgentListRequest',
        supervisorUserId => $x0,
        serviceUserId    => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallCenterEnhancedReportingReportTemplateParamInfoGetRequest ($x0, $x1) {
    return $self->send_query(
        'UserCallCenterEnhancedReportingReportTemplateParamInfoGetRequest',
        reportTemplate => [ templateLevel => $x0, templateName => $x1 ]
    );
}

# ----------------------------------------------------------------------
method UserCallCenterEnhancedReportingScheduledReportDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'UserCallCenterEnhancedReportingScheduledReportDeleteRequest',
        supervisorUserId => $x0,
        name             => $x1
    );
}

# ----------------------------------------------------------------------
method UserCallCenterEnhancedReportingScheduledReportGetRequest ($x0, $x1) {
    return $self->send_query(
        'UserCallCenterEnhancedReportingScheduledReportGetRequest',
        supervisorUserId => $x0,
        name             => $x1
    );
}

# ----------------------------------------------------------------------
method UserCallCenterEnhancedReportingScheduledReportModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserCallCenterEnhancedReportingScheduledReportModifyRequest',
        supervisorUserId => $x0,
        name             => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallCenterGetAgentSupervisorListRequest ($x0, $x1) {
    return $self->send_query(
        'UserCallCenterGetAgentSupervisorListRequest',
        agentUserId   => $x0,
        serviceUserId => $x1
    );
}

# ----------------------------------------------------------------------
method UserCallCenterGetAvailableCallCenterListRequest ($x0) {
    return $self->send_query( 'UserCallCenterGetAvailableCallCenterListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallCenterGetAvailableDNISListRequest ($x0) {
    return $self->send_query( 'UserCallCenterGetAvailableDNISListRequest', agentUserId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallCenterGetRequest19 ($x0) {
    return $self->send_query( 'UserCallCenterGetRequest19', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallCenterGetSupervisedAgentListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'UserCallCenterGetSupervisedAgentListRequest',
        supervisorUserId => $x0,
        serviceUserId    => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallCenterGetSupervisorCallCenterListRequest ($x0) {
    return $self->send_query( 'UserCallCenterGetSupervisorCallCenterListRequest', supervisorUserId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallCenterModifyCallCenterListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallCenterModifyCallCenterListRequest',
        agentUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallCenterModifyRequest19 ($x0, @generic_params) {
    return $self->send_command(
        'UserCallCenterModifyRequest19',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallCenterModifySupervisedAgentListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserCallCenterModifySupervisedAgentListRequest',
        supervisorUserId => $x0,
        serviceUserId    => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method CallCenterAgentAvailability ($x0, $x1) {
    return $self->send_query(
        'CallCenterAgentAvailability',
        serviceUserId => $x0,
        available     => $x1
    );
}

# ----------------------------------------------------------------------
method CallCenterAgentSettings ($x0, @generic_params) {
    return $self->send_query(
        'CallCenterAgentSettings',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallCenterMonitoring
##
method UserCallCenterMonitoringGetRequest ($x0) {
    return $self->send_query( 'UserCallCenterMonitoringGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallCenterMonitoringModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallCenterMonitoringModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallForwardingAlways
##
method UserCallForwardingAlwaysGetRequest ($x0) {
    return $self->send_query( 'UserCallForwardingAlwaysGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallForwardingAlwaysModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallForwardingAlwaysModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallForwardingBusy
##
method UserCallForwardingBusyGetRequest ($x0) {
    return $self->send_query( 'UserCallForwardingBusyGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallForwardingBusyModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallForwardingBusyModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallForwardingNoAnswer
##
method UserCallForwardingNoAnswerGetRequest13mp16 ($x0) {
    return $self->send_query( 'UserCallForwardingNoAnswerGetRequest13mp16', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallForwardingNoAnswerModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallForwardingNoAnswerModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallForwardingNotReachable
##
method UserCallForwardingNotReachableGetRequest ($x0) {
    return $self->send_query( 'UserCallForwardingNotReachableGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallForwardingNotReachableModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallForwardingNotReachableModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallForwardingSelective
##
method UserCallForwardingSelectiveAddCriteriaRequest16 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'UserCallForwardingSelectiveAddCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params, fromDnCriteria => $x2
    );
}

# ----------------------------------------------------------------------
method UserCallForwardingSelectiveDeleteCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserCallForwardingSelectiveDeleteCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserCallForwardingSelectiveGetCriteriaRequest16 ($x0, $x1) {
    return $self->send_query(
        'UserCallForwardingSelectiveGetCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserCallForwardingSelectiveGetRequest16 ($x0) {
    return $self->send_query( 'UserCallForwardingSelectiveGetRequest16', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallForwardingSelectiveModifyCriteriaRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserCallForwardingSelectiveModifyCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallForwardingSelectiveModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallForwardingSelectiveModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallMeNow
##
method SystemCallMeNowGetRequest () {
    return $self->send_query(
        'SystemCallMeNowGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallMeNowModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCallMeNowModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserCallMeNowAddCriteriaRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'UserCallMeNowAddCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params,
        rejectCall   => $x2,
        toDnCriteria => $x3
    );
}

# ----------------------------------------------------------------------
method UserCallMeNowDeleteCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserCallMeNowDeleteCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserCallMeNowGetCriteriaRequest ($x0, $x1) {
    return $self->send_query(
        'UserCallMeNowGetCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserCallMeNowGetRequest ($x0) {
    return $self->send_query( 'UserCallMeNowGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallMeNowModifyCriteriaRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserCallMeNowModifyCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallMeNowModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallMeNowModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallNotify
##
method SystemCallNotifyGetRequest () {
    return $self->send_query(
        'SystemCallNotifyGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallNotifyModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCallNotifyModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserCallNotifyAddCriteriaRequest16 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'UserCallNotifyAddCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params,
        blacklisted    => $x2,
        fromDnCriteria => $x3
    );
}

# ----------------------------------------------------------------------
method UserCallNotifyGetCriteriaRequest16 ($x0, $x1) {
    return $self->send_query(
        'UserCallNotifyGetCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserCallNotifyDeleteCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserCallNotifyDeleteCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserCallNotifyModifyCriteriaRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserCallNotifyModifyCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallNotifyGetRequest ($x0) {
    return $self->send_query( 'UserCallNotifyGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallNotifyModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallNotifyModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallPark
##
method GroupCallParkAddInstanceRequest16sp2 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupCallParkAddInstanceRequest16sp2',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params, recallTo => $x3
    );
}

# ----------------------------------------------------------------------
method GroupCallParkDeleteInstanceRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCallParkDeleteInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallParkGetAvailableAlternateRecallUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCallParkGetAvailableAlternateRecallUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallParkGetAvailableUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCallParkGetAvailableUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallParkGetInstanceListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallParkGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallParkGetInstanceRequest16sp2 ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupCallParkGetInstanceRequest16sp2',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallParkGetRequest16sp2 ($x0, $x1) {
    return $self->send_query(
        'GroupCallParkGetRequest16sp2',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallParkModifyInstanceRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallParkModifyInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallParkModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallParkModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallParkGetRequest ($x0) {
    return $self->send_query( 'UserCallParkGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
##
## ServiceCallPickup
##
method GroupCallPickupAddInstanceRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallPickupAddInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallPickupDeleteInstanceRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupCallPickupDeleteInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallPickupGetAvailableUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupCallPickupGetAvailableUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallPickupGetInstanceListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallPickupGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallPickupGetInstanceRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupCallPickupGetInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupCallPickupModifyInstanceRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallPickupModifyInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallPickupGetRequest ($x0) {
    return $self->send_query( 'UserCallPickupGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
##
## ServiceCallRecording
##
method GroupCallRecordingGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallRecordingGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallRecordingModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallRecordingModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallRecordingAddPlatformRequest20 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'SystemCallRecordingAddPlatformRequest20',
        name       => $x0,
        netAddress => $x1,
        @generic_params,
        schemaVersion         => $x2,
        supportVideoRecording => $x3
    );
}

# ----------------------------------------------------------------------
method SystemCallRecordingDeletePlatformRequest ($x0) {
    return $self->send_command( 'SystemCallRecordingDeletePlatformRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallRecordingGetPlatformListRequest20sp1 () {
    return $self->send_query(
        'SystemCallRecordingGetPlatformListRequest20sp1',

    );
}

# ----------------------------------------------------------------------
method SystemCallRecordingGetPlatformUsageRequest ($x0) {
    return $self->send_query( 'SystemCallRecordingGetPlatformUsageRequest', name => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallRecordingModifyPlatformRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCallRecordingModifyPlatformRequest',
        name => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallRecordingGetRequest () {
    return $self->send_query(
        'SystemCallRecordingGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallRecordingModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCallRecordingModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserCallRecordingGetRequest20 ($x0) {
    return $self->send_query( 'UserCallRecordingGetRequest20', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallRecordingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallRecordingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallReturn
##
method SystemCallReturnGetRequest () {
    return $self->send_query(
        'SystemCallReturnGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallReturnModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCallReturnModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceCallTransfer
##
method UserCallTransferGetRequest14sp4 ($x0) {
    return $self->send_query( 'UserCallTransferGetRequest14sp4', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallTransferModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallTransferModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallWaiting
##
method UserCallWaitingGetRequest17sp4 ($x0) {
    return $self->send_query( 'UserCallWaitingGetRequest17sp4', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallWaitingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallWaitingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallWaitingGetRequest () {
    return $self->send_query(
        'SystemCallWaitingGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallWaitingModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCallWaitingModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceCallingLineIDBlockingOverride
##
method UserCallingLineIDBlockingOverrideGetRequest ($x0) {
    return $self->send_query( 'UserCallingLineIDBlockingOverrideGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallingLineIDBlockingOverrideModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallingLineIDBlockingOverrideModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallingLineIDDeliveryBlocking
##
method UserCallingLineIDDeliveryBlockingGetRequest ($x0) {
    return $self->send_query( 'UserCallingLineIDDeliveryBlockingGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallingLineIDDeliveryBlockingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallingLineIDDeliveryBlockingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallingNameDelivery
##
method UserCallingNameDeliveryGetRequest ($x0) {
    return $self->send_query( 'UserCallingNameDeliveryGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallingNameDeliveryModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallingNameDeliveryModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallingNameRetrieval
##
method SystemCallingNameRetrievalGetRequest20 () {
    return $self->send_query(
        'SystemCallingNameRetrievalGetRequest20',

    );
}

# ----------------------------------------------------------------------
method SystemCallingNameRetrievalModifyRequest20 (@generic_params) {
    return $self->send_command( 'SystemCallingNameRetrievalModifyRequest20', @generic_params );
}

# ----------------------------------------------------------------------
method UserCallingNameRetrievalGetRequest ($x0) {
    return $self->send_query( 'UserCallingNameRetrievalGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallingNameRetrievalModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallingNameRetrievalModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallingNumberDelivery
##
method UserCallingNumberDeliveryGetRequest ($x0) {
    return $self->send_query( 'UserCallingNumberDeliveryGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallingNumberDeliveryModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCallingNumberDeliveryModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallingPartyCategory
##
method SystemCallingPartyCategoryAddRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCallingPartyCategoryAddRequest',
        category => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemCallingPartyCategoryDeleteRequest ($x0) {
    return $self->send_command( 'SystemCallingPartyCategoryDeleteRequest', category => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallingPartyCategoryGetListRequest () {
    return $self->send_query(
        'SystemCallingPartyCategoryGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCallingPartyCategoryGetRequest ($x0) {
    return $self->send_query( 'SystemCallingPartyCategoryGetRequest', category => $x0 );
}

# ----------------------------------------------------------------------
method SystemCallingPartyCategoryModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemCallingPartyCategoryModifyRequest',
        category => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCallingPartyCategoryGetRequest16 ($x0) {
    return $self->send_query( 'UserCallingPartyCategoryGetRequest16', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCallingPartyCategoryModifyRequest16 ($x0, @generic_params) {
    return $self->send_command(
        'UserCallingPartyCategoryModifyRequest16',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCallingPlan
##
method GroupCallingPlanAddDigitPatternRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'GroupCallingPlanAddDigitPatternRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        digitPattern      => $x3
    );
}

# ----------------------------------------------------------------------
method GroupCallingPlanDeleteDigitPatternListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCallingPlanDeleteDigitPatternListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupCallingPlanGetDigitPatternListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCallingPlanGetDigitPatternListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCallingPlanModifyDigitPatternRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupCallingPlanModifyDigitPatternRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceChargeNumber
##
method UserChargeNumberGetRequest14sp9 ($x0) {
    return $self->send_query( 'UserChargeNumberGetRequest14sp9', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserChargeNumberModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserChargeNumberModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceClassMark
##
method SystemClassmarkAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'SystemClassmarkAddRequest',
        classmark => $x0,
        value     => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemClassmarkDeleteRequest ($x0) {
    return $self->send_command( 'SystemClassmarkDeleteRequest', classmark => $x0 );
}

# ----------------------------------------------------------------------
method SystemClassmarkGetListRequest () {
    return $self->send_query(
        'SystemClassmarkGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemClassmarkModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemClassmarkModifyRequest',
        classmark => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemClassmarkGetUtilizationListRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemClassmarkGetUtilizationListRequest',
        classmark => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserClassmarkGetRequest ($x0) {
    return $self->send_query( 'UserClassmarkGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserClassmarkModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserClassmarkModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCommPilotCallManager
##
method GroupCommPilotCallManagerGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupCommPilotCallManagerGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCommPilotCallManagerModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCommPilotCallManagerModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCommPilotCallManagerGetRequest ($x0) {
    return $self->send_query( 'UserCommPilotCallManagerGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCommPilotCallManagerModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCommPilotCallManagerModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCommPilotExpress
##
method UserCommPilotExpressGetRequest ($x0) {
    return $self->send_query( 'UserCommPilotExpressGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCommPilotExpressModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCommPilotExpressModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCommPilotExpressSR
##
method UserCommPilotExpressSRGetRequest13mp16 ($x0) {
    return $self->send_query( 'UserCommPilotExpressSRGetRequest13mp16', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCommPilotExpressSRModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCommPilotExpressSRModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCommunicationBarringUserControl
##
method SystemCommunicationBarringUserControlGetRequest () {
    return $self->send_query(
        'SystemCommunicationBarringUserControlGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCommunicationBarringUserControlModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCommunicationBarringUserControlModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserCommunicationBarringUserControlGetRequest ($x0) {
    return $self->send_query( 'UserCommunicationBarringUserControlGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCommunicationBarringUserControlModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCommunicationBarringUserControlModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCommunicator
##
method ServiceProviderBroadWorksCommunicatorGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderBroadWorksCommunicatorGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderBroadWorksCommunicatorModifyRequest (@generic_params) {
    return $self->send_command( 'ServiceProviderBroadWorksCommunicatorModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserBroadWorksCommunicatorGetRequest ($x0) {
    return $self->send_query( 'UserBroadWorksCommunicatorGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
##
## ServiceConnectedLineIdentificationPresentation
##
method SystemConnectedLineIdentificationPresentationGetRequest () {
    return $self->send_query(
        'SystemConnectedLineIdentificationPresentationGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemConnectedLineIdentificationPresentationModifyRequest (@generic_params) {
    return $self->send_command( 'SystemConnectedLineIdentificationPresentationModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceConnectedLineIdentificationRestriction
##
method UserConnectedLineIdentificationRestrictionGetRequest ($x0) {
    return $self->send_query( 'UserConnectedLineIdentificationRestrictionGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserConnectedLineIdentificationRestrictionModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserConnectedLineIdentificationRestrictionModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCustomRingback
##
method GroupCustomRingbackGroupGetRequest20 ($x0, $x1) {
    return $self->send_query(
        'GroupCustomRingbackGroupGetRequest20',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupCustomRingbackGroupModifyRequest20 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupCustomRingbackGroupModifyRequest20',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCustomRingbackUserAddCriteriaRequest20 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserCustomRingbackUserAddCriteriaRequest20',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCustomRingbackUserDeleteCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserCustomRingbackUserDeleteCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserCustomRingbackUserGetCriteriaListRequest ($x0) {
    return $self->send_query( 'UserCustomRingbackUserGetCriteriaListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserCustomRingbackUserGetCriteriaRequest20 ($x0, $x1) {
    return $self->send_query(
        'UserCustomRingbackUserGetCriteriaRequest20',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserCustomRingbackUserModifyActiveCriteriaListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserCustomRingbackUserModifyActiveCriteriaListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserCustomRingbackUserModifyCriteriaRequest20 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserCustomRingbackUserModifyCriteriaRequest20',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceCustomerOriginatedTrace
##
method SystemCustomerOriginatedTraceGetRequest () {
    return $self->send_query(
        'SystemCustomerOriginatedTraceGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemCustomerOriginatedTraceModifyRequest (@generic_params) {
    return $self->send_command( 'SystemCustomerOriginatedTraceModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceDirectedCallPickupWithBargeIn
##
method UserDirectedCallPickupWithBargeInGetRequest14sp7 ($x0) {
    return $self->send_query( 'UserDirectedCallPickupWithBargeInGetRequest14sp7', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserDirectedCallPickupWithBargeInModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserDirectedCallPickupWithBargeInModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceDirectoryNumberHunting
##
method GroupDirectoryNumberHuntingGetAvailableUserListRequest ($x0) {
    return $self->send_query( 'GroupDirectoryNumberHuntingGetAvailableUserListRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupDirectoryNumberHuntingGetRequest17sp1 ($x0) {
    return $self->send_query( 'GroupDirectoryNumberHuntingGetRequest17sp1', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupDirectoryNumberHuntingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupDirectoryNumberHuntingModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceDoNotDisturb
##
method UserDoNotDisturbGetRequest ($x0) {
    return $self->send_query( 'UserDoNotDisturbGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserDoNotDisturbModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserDoNotDisturbModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceDualModeVCC
##
method UserDualModeVCCGetRequest ($x0) {
    return $self->send_query( 'UserDualModeVCCGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserDualModeVCCModifyRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserDualModeVCCModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceEmergencyZones
##
method GroupEmergencyZonesAddHomeZoneListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupEmergencyZonesAddHomeZoneListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupEmergencyZonesDeleteHomeZoneListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupEmergencyZonesDeleteHomeZoneListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupEmergencyZonesGetHomeZoneListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupEmergencyZonesGetHomeZoneListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupEmergencyZonesGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupEmergencyZonesGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupEmergencyZonesModifyHomeZoneListRequest (@generic_params) {
    return $self->send_query( 'GroupEmergencyZonesModifyHomeZoneListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupEmergencyZonesModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupEmergencyZonesModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemEmergencyZonesGetRequest () {
    return $self->send_query(
        'SystemEmergencyZonesGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemEmergencyZonesModifyRequest (@generic_params) {
    return $self->send_command( 'SystemEmergencyZonesModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceEnhancedCallLogs
##
method EnterpriseEnhancedCallLogsGetListRequest20 ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseEnhancedCallLogsGetListRequest20',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupEnhancedCallLogsGetListRequest20 ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupEnhancedCallLogsGetListRequest20',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderEnhancedCallLogsGetRequest17sp4 ($x0) {
    return $self->send_query( 'ServiceProviderEnhancedCallLogsGetRequest17sp4', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderEnhancedCallLogsModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderEnhancedCallLogsModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemEnhancedCallLogsGetRequest20sp1 () {
    return $self->send_query(
        'SystemEnhancedCallLogsGetRequest20sp1',

    );
}

# ----------------------------------------------------------------------
method SystemEnhancedCallLogsModifyRequest (@generic_params) {
    return $self->send_command( 'SystemEnhancedCallLogsModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserEnhancedCallLogsGetListRequest20 ($x0, @generic_params) {
    return $self->send_query(
        'UserEnhancedCallLogsGetListRequest20',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceExecutive
##
method SystemExecutiveGetRequest () {
    return $self->send_query(
        'SystemExecutiveGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemExecutiveModifyRequest (@generic_params) {
    return $self->send_command( 'SystemExecutiveModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserExecutiveAddFilteringSelectiveCriteriaRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'UserExecutiveAddFilteringSelectiveCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params,
        filter         => $x2,
        fromDnCriteria => $x3
    );
}

# ----------------------------------------------------------------------
method UserExecutiveDeleteFilteringSelectiveCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserExecutiveDeleteFilteringSelectiveCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserExecutiveGetAvailableAssistantListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserExecutiveGetAvailableAssistantListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserExecutiveGetAssistantRequest ($x0) {
    return $self->send_query( 'UserExecutiveGetAssistantRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserExecutiveGetFilteringRequest ($x0) {
    return $self->send_query( 'UserExecutiveGetFilteringRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserExecutiveGetFilteringSelectiveCriteriaRequest ($x0, $x1) {
    return $self->send_query(
        'UserExecutiveGetFilteringSelectiveCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserExecutiveGetScreeningAlertingRequest ($x0) {
    return $self->send_query( 'UserExecutiveGetScreeningAlertingRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserExecutiveModifyAssistantRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserExecutiveModifyAssistantRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserExecutiveModifyFilteringRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserExecutiveModifyFilteringRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserExecutiveModifyFilteringSelectiveCriteriaRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserExecutiveModifyFilteringSelectiveCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserExecutiveModifyScreeningAlertingRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserExecutiveModifyScreeningAlertingRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceExecutiveAssistant
##
method UserExecutiveAssistantGetRequest ($x0) {
    return $self->send_query( 'UserExecutiveAssistantGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserExecutiveAssistantModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserExecutiveAssistantModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceExternalCallingLineIDDelivery
##
method UserExternalCallingLineIDDeliveryGetRequest ($x0) {
    return $self->send_query( 'UserExternalCallingLineIDDeliveryGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserExternalCallingLineIDDeliveryModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserExternalCallingLineIDDeliveryModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceExternalCustomRingback
##
method ServiceProviderExternalCustomRingbackGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderExternalCustomRingbackGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderExternalCustomRingbackModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderExternalCustomRingbackModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserExternalCustomRingbackGetRequest ($x0) {
    return $self->send_query( 'UserExternalCustomRingbackGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserExternalCustomRingbackModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserExternalCustomRingbackModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceFaxMessaging
##
method UserFaxMessagingGetRequest17sp1 ($x0) {
    return $self->send_query( 'UserFaxMessagingGetRequest17sp1', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserFaxMessagingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserFaxMessagingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceFindMeFollowMe
##
method GroupFindMeFollowMeAddAlertingGroupRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupFindMeFollowMeAddAlertingGroupRequest',
        serviceUserId     => $x0,
        alertingGroupName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeAddAlertingGroupSelectiveCriteriaRequest ($x0, $x1, $x2, $x3, $x4, @generic_params) {
    return $self->send_command(
        'GroupFindMeFollowMeAddAlertingGroupSelectiveCriteriaRequest',
        serviceUserId     => $x0,
        alertingGroupName => $x1,
        criteriaName      => $x2,
        @generic_params,
        blacklisted    => $x3,
        fromDnCriteria => $x4
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeAddInstanceRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupFindMeFollowMeAddInstanceRequest',
        serviceProviderId      => $x0,
        groupId                => $x1,
        serviceUserId          => $x2,
        serviceInstanceProfile => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeAlertingGroupGetAvailableUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupFindMeFollowMeAlertingGroupGetAvailableUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeDeleteAlertingGroupRequest ($x0, $x1) {
    return $self->send_command(
        'GroupFindMeFollowMeDeleteAlertingGroupRequest',
        serviceUserId     => $x0,
        alertingGroupName => $x1
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeDeleteAlertingGroupSelectiveCriteriaRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupFindMeFollowMeDeleteAlertingGroupSelectiveCriteriaRequest',
        serviceUserId     => $x0,
        alertingGroupName => $x1,
        criteriaName      => $x2
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeDeleteInstanceRequest ($x0) {
    return $self->send_command( 'GroupFindMeFollowMeDeleteInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeGetAlertingGroupListRequest ($x0) {
    return $self->send_query( 'GroupFindMeFollowMeGetAlertingGroupListRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeGetAlertingGroupRequest ($x0, $x1) {
    return $self->send_query(
        'GroupFindMeFollowMeGetAlertingGroupRequest',
        serviceUserId     => $x0,
        alertingGroupName => $x1
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest',
        serviceUserId     => $x0,
        alertingGroupName => $x1,
        criteriaName      => $x2
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeGetInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupFindMeFollowMeGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeGetInstanceRequest19sp1 ($x0) {
    return $self->send_query( 'GroupFindMeFollowMeGetInstanceRequest19sp1', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeModifyActiveInstanceListRequest (@generic_params) {
    return $self->send_command( 'GroupFindMeFollowMeModifyActiveInstanceListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeModifyAlertingGroupListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupFindMeFollowMeModifyAlertingGroupListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeModifyAlertingGroupRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupFindMeFollowMeModifyAlertingGroupRequest',
        serviceUserId     => $x0,
        alertingGroupName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeModifyAlertingGroupSelectiveCriteriaRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupFindMeFollowMeModifyAlertingGroupSelectiveCriteriaRequest',
        serviceUserId     => $x0,
        alertingGroupName => $x1,
        criteriaName      => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFindMeFollowMeModifyInstanceRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupFindMeFollowMeModifyInstanceRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceFlexibleSeatingGuest
##
method GroupFlexibleSeatingAccessDeviceGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupFlexibleSeatingAccessDeviceGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupFlexibleSeatingHostGetInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupFlexibleSeatingHostGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFlexibleSeatingHostModifyActiveInstanceListRequest (@generic_params) {
    return $self->send_command( 'GroupFlexibleSeatingHostModifyActiveInstanceListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupFlexibleSeatingHostAddInstanceRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupFlexibleSeatingHostAddInstanceRequest',
        serviceProviderId      => $x0,
        groupId                => $x1,
        serviceUserId          => $x2,
        serviceInstanceProfile => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFlexibleSeatingHostDeleteInstanceRequest ($x0) {
    return $self->send_command( 'GroupFlexibleSeatingHostDeleteInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupFlexibleSeatingHostGetInstanceRequest ($x0) {
    return $self->send_query( 'GroupFlexibleSeatingHostGetInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupFlexibleSeatingHostModifyInstanceRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupFlexibleSeatingHostModifyInstanceRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFlexibleSeatingHostRoutingPoliciesGetRequest ($x0) {
    return $self->send_query( 'GroupFlexibleSeatingHostRoutingPoliciesGetRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupFlexibleSeatingHostRoutingPoliciesModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupFlexibleSeatingHostRoutingPoliciesModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupFlexibleSeatingHostGuestAssociationGetRequest ($x0) {
    return $self->send_query( 'GroupFlexibleSeatingHostGuestAssociationGetRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupFlexibleSeatingHostGuestAssociationModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupFlexibleSeatingHostGuestAssociationModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserFlexibleSeatingGuestGetAvailableHostListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserFlexibleSeatingGuestGetAvailableHostListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserFlexibleSeatingGuestGetRequest ($x0) {
    return $self->send_query( 'UserFlexibleSeatingGuestGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserFlexibleSeatingGuestModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserFlexibleSeatingGuestModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceGroupNightForwarding
##
method SystemGroupNightForwardingGetRequest () {
    return $self->send_query(
        'SystemGroupNightForwardingGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemGroupNightForwardingModifyRequest (@generic_params) {
    return $self->send_command( 'SystemGroupNightForwardingModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupGroupNightForwardingGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupGroupNightForwardingGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupGroupNightForwardingModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupGroupNightForwardingModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserGroupNightForwardingGetRequest ($x0) {
    return $self->send_query( 'UserGroupNightForwardingGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserGroupNightForwardingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserGroupNightForwardingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceGroupPaging
##
method GroupGroupPagingAddInstanceRequest ($x0, $x1, $x2, $x3, $x4, $x5, @generic_params) {
    return $self->send_command(
        'GroupGroupPagingAddInstanceRequest',
        serviceProviderId              => $x0,
        groupId                        => $x1,
        serviceUserId                  => $x2,
        serviceInstanceProfile         => $x3,
        confirmationToneTimeoutSeconds => $x4,
        deliverOriginatorCLIDInstead   => $x5,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingAddOriginatorListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupGroupPagingAddOriginatorListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingAddTargetListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupGroupPagingAddTargetListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingDeleteInstanceRequest ($x0) {
    return $self->send_command( 'GroupGroupPagingDeleteInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupGroupPagingDeleteOriginatorListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupGroupPagingDeleteOriginatorListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingDeleteTargetListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupGroupPagingDeleteTargetListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingGetAvailableOriginatorListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupGroupPagingGetAvailableOriginatorListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingGetAvailableTargetListRequest ($x0, @generic_params) {
    return $self->send_query(
        'GroupGroupPagingGetAvailableTargetListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingGetInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupGroupPagingGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingGetInstanceRequest19sp1 ($x0) {
    return $self->send_query( 'GroupGroupPagingGetInstanceRequest19sp1', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupGroupPagingGetOriginatorListRequest ($x0) {
    return $self->send_query( 'GroupGroupPagingGetOriginatorListRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupGroupPagingGetTargetListRequest ($x0) {
    return $self->send_query( 'GroupGroupPagingGetTargetListRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupGroupPagingModifyActiveInstanceListRequest (@generic_params) {
    return $self->send_command( 'GroupGroupPagingModifyActiveInstanceListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupGroupPagingModifyInstanceRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupGroupPagingModifyInstanceRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingModifyOriginatorListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupGroupPagingModifyOriginatorListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingModifyTargetListRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupGroupPagingModifyTargetListRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingTargetsCapacityGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupGroupPagingTargetsCapacityGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupGroupPagingTargetsCapacityModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupGroupPagingTargetsCapacityModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderGroupPagingTargetsCapacityGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderGroupPagingTargetsCapacityGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderGroupPagingTargetsCapacityModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderGroupPagingTargetsCapacityModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserGroupPagingGetListRequest ($x0) {
    return $self->send_query( 'UserGroupPagingGetListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
##
## ServiceHotelingGuest
##
method UserHotelingGuestGetAvailableUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserHotelingGuestGetAvailableUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserHotelingGuestGetRequest14sp4 ($x0) {
    return $self->send_query( 'UserHotelingGuestGetRequest14sp4', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserHotelingGuestModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserHotelingGuestModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceHotelingHost
##
method UserHotelingHostGetRequest17 ($x0) {
    return $self->send_query( 'UserHotelingHostGetRequest17', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserHotelingHostModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserHotelingHostModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceHuntGroup
##
method GroupHuntGroupAddInstanceRequest20 ($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, @generic_params) {
    return $self->send_command(
        'GroupHuntGroupAddInstanceRequest20',
        serviceProviderId      => $x0,
        groupId                => $x1,
        serviceUserId          => $x2,
        serviceInstanceProfile => $x3,
        policy                 => $x4,
        huntAfterNoAnswer      => $x5,
        noAnswerNumberOfRings  => $x6,
        forwardAfterTimeout    => $x7,
        forwardTimeoutSeconds  => $x8,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupHuntGroupDeleteInstanceRequest ($x0) {
    return $self->send_command( 'GroupHuntGroupDeleteInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupHuntGroupGetAvailableUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupHuntGroupGetAvailableUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupHuntGroupGetInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupHuntGroupGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupHuntGroupGetInstanceRequest20 ($x0) {
    return $self->send_query( 'GroupHuntGroupGetInstanceRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupHuntGroupModifyActiveInstanceListRequest (@generic_params) {
    return $self->send_command( 'GroupHuntGroupModifyActiveInstanceListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupHuntGroupModifyInstanceRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupHuntGroupModifyInstanceRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupHuntGroupModifyInstanceWeightedCallDistributionRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupHuntGroupModifyInstanceWeightedCallDistributionRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemHuntGroupGetRequest17 () {
    return $self->send_query(
        'SystemHuntGroupGetRequest17',

    );
}

# ----------------------------------------------------------------------
method SystemHuntGroupModifyRequest (@generic_params) {
    return $self->send_command( 'SystemHuntGroupModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceINIntegration
##
method UserINIntegrationGetRequest ($x0) {
    return $self->send_query( 'UserINIntegrationGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserINIntegrationModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserINIntegrationModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceInCallServiceActivation
##
method UserInCallServiceActivationGetRequest ($x0) {
    return $self->send_query( 'UserInCallServiceActivationGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserInCallServiceActivationModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserInCallServiceActivationModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderInCallServiceActivationGetRequest17 ($x0) {
    return $self->send_query( 'ServiceProviderInCallServiceActivationGetRequest17', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderInCallServiceActivationModifyRequest17 ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderInCallServiceActivationModifyRequest17',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemInCallServiceActivationGetRequest17 () {
    return $self->send_query(
        'SystemInCallServiceActivationGetRequest17',

    );
}

# ----------------------------------------------------------------------
method SystemInCallServiceActivationModifyRequest17 (@generic_params) {
    return $self->send_command( 'SystemInCallServiceActivationModifyRequest17', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceIncomingCallingPlan
##
method GroupIncomingCallingPlanGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupIncomingCallingPlanGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupIncomingCallingPlanModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupIncomingCallingPlanModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserIncomingCallingPlanGetRequest ($x0) {
    return $self->send_query( 'UserIncomingCallingPlanGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserIncomingCallingPlanModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserIncomingCallingPlanModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceInstantGroupCall
##
method GroupInstantGroupCallAddInstanceRequest14 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupInstantGroupCallAddInstanceRequest14',
        serviceProviderId      => $x0,
        groupId                => $x1,
        serviceUserId          => $x2,
        serviceInstanceProfile => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupInstantGroupCallDeleteInstanceRequest ($x0) {
    return $self->send_command( 'GroupInstantGroupCallDeleteInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupInstantGroupCallGetInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupInstantGroupCallGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupInstantGroupCallGetInstanceRequest19sp1 ($x0) {
    return $self->send_query( 'GroupInstantGroupCallGetInstanceRequest19sp1', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupInstantGroupCallModifyActiveInstanceListRequest (@generic_params) {
    return $self->send_command( 'GroupInstantGroupCallModifyActiveInstanceListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupInstantGroupCallModifyInstanceRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupInstantGroupCallModifyInstanceRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceIntegratedIMP
##
method GroupIntegratedIMPGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupIntegratedIMPGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupIntegratedIMPModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupIntegratedIMPModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderIntegratedIMPGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderIntegratedIMPGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderIntegratedIMPModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderIntegratedIMPModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemIntegratedIMPGetRequest19 () {
    return $self->send_query(
        'SystemIntegratedIMPGetRequest19',

    );
}

# ----------------------------------------------------------------------
method SystemIntegratedIMPModifyRequest (@generic_params) {
    return $self->send_command( 'SystemIntegratedIMPModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserIntegratedIMPGetRequest ($x0) {
    return $self->send_query( 'UserIntegratedIMPGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserIntegratedIMPModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserIntegratedIMPModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserIntegratedIMPGeneratePasswordRequest ($x0) {
    return $self->send_command( 'UserIntegratedIMPGeneratePasswordRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
##
## ServiceIntelligentNetworkServiceControl
##
method SystemIntelligentNetworkServiceControlGetRequest14 () {
    return $self->send_query(
        'SystemIntelligentNetworkServiceControlGetRequest14',

    );
}

# ----------------------------------------------------------------------
method SystemIntelligentNetworkServiceControlModifyRequest (@generic_params) {
    return $self->send_command( 'SystemIntelligentNetworkServiceControlModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserIntelligentNetworkServiceControlGetRequest ($x0) {
    return $self->send_query( 'UserIntelligentNetworkServiceControlGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserIntelligentNetworkServiceControlModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserIntelligentNetworkServiceControlModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceIntercept
##
method GroupInterceptGroupGetRequest16sp1 ($x0, $x1) {
    return $self->send_query(
        'GroupInterceptGroupGetRequest16sp1',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupInterceptGroupModifyRequest16 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupInterceptGroupModifyRequest16',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemInterceptUserAddDnListRequest (@generic_params) {
    return $self->send_command( 'SystemInterceptUserAddDnListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemInterceptUserDeleteDnListRequest (@generic_params) {
    return $self->send_command( 'SystemInterceptUserDeleteDnListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemInterceptUserGetDnListRequest () {
    return $self->send_query(
        'SystemInterceptUserGetDnListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemInterceptUserGetRequest () {
    return $self->send_query(
        'SystemInterceptUserGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemInterceptUserModifyDnRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemInterceptUserModifyDnRequest',
        phoneNumber => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemInterceptUserModifyRequest (@generic_params) {
    return $self->send_command( 'SystemInterceptUserModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserInterceptUserGetRequest16sp1 ($x0) {
    return $self->send_query( 'UserInterceptUserGetRequest16sp1', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserInterceptUserModifyRequest16 ($x0, @generic_params) {
    return $self->send_command(
        'UserInterceptUserModifyRequest16',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceInternalCallingLineIDDelivery
##
method UserInternalCallingLineIDDeliveryGetRequest ($x0) {
    return $self->send_query( 'UserInternalCallingLineIDDeliveryGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserInternalCallingLineIDDeliveryModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserInternalCallingLineIDDeliveryModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceInventoryReport
##
method GroupInventoryReportGetRequest ($x0, $x1, $x2, $x3, $x4, $x5, $x6, @generic_params) {
    return $self->send_query(
        'GroupInventoryReportGetRequest',
        serviceProviderId    => $x0,
        groupId              => $x1,
        includeUsers         => $x2,
        includeServices      => $x3,
        includeDns           => $x4,
        includeAccessDevices => $x5,
        includeDepartments   => $x6,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemInventoryReportGetRequest () {
    return $self->send_query(
        'SystemInventoryReportGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemInventoryReportModifyRequest (@generic_params) {
    return $self->send_command( 'SystemInventoryReportModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceLDAPIntegration
##
method GroupLDAPIntegrationGetDirectoryRequest ($x0, $x1) {
    return $self->send_query(
        'GroupLDAPIntegrationGetDirectoryRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupLDAPIntegrationModifyDirectoryRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupLDAPIntegrationModifyDirectoryRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupLDAPIntegrationGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupLDAPIntegrationGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupLDAPIntegrationModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupLDAPIntegrationModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderLDAPIntegrationGetDirectoryRequest ($x0) {
    return $self->send_query( 'ServiceProviderLDAPIntegrationGetDirectoryRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderLDAPIntegrationModifyDirectoryRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderLDAPIntegrationModifyDirectoryRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemLDAPIntegrationGetDirectoryRequest () {
    return $self->send_query(
        'SystemLDAPIntegrationGetDirectoryRequest',

    );
}

# ----------------------------------------------------------------------
method SystemLDAPIntegrationModifyDirectoryRequest (@generic_params) {
    return $self->send_command( 'SystemLDAPIntegrationModifyDirectoryRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserLDAPIntegrationGetDirectoryListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserLDAPIntegrationGetDirectoryListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserLDAPIntegrationGetDirectoryEntryRequest ($x0, $x1) {
    return $self->send_query(
        'UserLDAPIntegrationGetDirectoryEntryRequest',
        userId    => $x0,
        entryName => $x1
    );
}

# ----------------------------------------------------------------------
##
## ServiceLegacyAutomaticCallback
##
method SystemLegacyAutomaticCallbackGetLineTypeListRequest () {
    return $self->send_query(
        'SystemLegacyAutomaticCallbackGetLineTypeListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemLegacyAutomaticCallbackGetRequest () {
    return $self->send_query(
        'SystemLegacyAutomaticCallbackGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemLegacyAutomaticCallbackModifyLineTypeRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemLegacyAutomaticCallbackModifyLineTypeRequest',
        lineType => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemLegacyAutomaticCallbackModifyRequest (@generic_params) {
    return $self->send_command( 'SystemLegacyAutomaticCallbackModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserLegacyAutomaticCallbackGetRequest ($x0) {
    return $self->send_query( 'UserLegacyAutomaticCallbackGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserLegacyAutomaticCallbackModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserLegacyAutomaticCallbackModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceLocationBasedCallingRestrictions
##
method SystemLocationBasedCallingRestrictionsGetRequest17sp3 () {
    return $self->send_query(
        'SystemLocationBasedCallingRestrictionsGetRequest17sp3',

    );
}

# ----------------------------------------------------------------------
method SystemLocationBasedCallingRestrictionsModifyRequest (@generic_params) {
    return $self->send_command( 'SystemLocationBasedCallingRestrictionsModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceMWIDeliveryToMobileEndpoint
##
method UserMWIDeliveryToMobileEndpointGetRequest ($x0) {
    return $self->send_query( 'UserMWIDeliveryToMobileEndpointGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserMWIDeliveryToMobileEndpointModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserMWIDeliveryToMobileEndpointModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceMaliciousCallTrace
##
method ServiceProviderMaliciousCallTraceGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderMaliciousCallTraceGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderMaliciousCallTraceModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderMaliciousCallTraceModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemMaliciousCallTraceGetRequest () {
    return $self->send_query(
        'SystemMaliciousCallTraceGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemMaliciousCallTraceModifyRequest (@generic_params) {
    return $self->send_command( 'SystemMaliciousCallTraceModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserMaliciousCallTraceGetRequest ($x0) {
    return $self->send_query( 'UserMaliciousCallTraceGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserMaliciousCallTraceModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserMaliciousCallTraceModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceMeetMeConferencing
##
method GroupMeetMeConferencingAddInstanceRequest19 ($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10, $x11, @generic_params) {
    return $self->send_command(
        'GroupMeetMeConferencingAddInstanceRequest19',
        serviceProviderId      => $x0,
        groupId                => $x1,
        serviceUserId          => $x2,
        serviceInstanceProfile => $x3,
        allocatedPorts         => $x4,
        @generic_params,
        playWarningPrompt                     => $x5,
        conferenceEndWarningPromptMinutes     => $x6,
        enableMaxConferenceDuration           => $x7,
        maxConferenceDurationMinutes          => [ hours => $x8, minutes => $x9 ],
        maxScheduledConferenceDurationMinutes => [ hours => $x10, minutes => $x11 ]
    );
}

# ----------------------------------------------------------------------
method GroupMeetMeConferencingDeleteInstanceRequest ($x0) {
    return $self->send_command( 'GroupMeetMeConferencingDeleteInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupMeetMeConferencingGetAvailableUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupMeetMeConferencingGetAvailableUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupMeetMeConferencingGetInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupMeetMeConferencingGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupMeetMeConferencingGetInstanceRequest19sp1 ($x0) {
    return $self->send_query( 'GroupMeetMeConferencingGetInstanceRequest19sp1', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupMeetMeConferencingGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupMeetMeConferencingGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupMeetMeConferencingModifyActiveInstanceListRequest (@generic_params) {
    return $self->send_command( 'GroupMeetMeConferencingModifyActiveInstanceListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupMeetMeConferencingModifyInstanceRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupMeetMeConferencingModifyInstanceRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupMeetMeConferencingModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupMeetMeConferencingModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderMeetMeConferencingGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderMeetMeConferencingGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderMeetMeConferencingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderMeetMeConferencingModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemMeetMeConferencingGetRequest19 () {
    return $self->send_query(
        'SystemMeetMeConferencingGetRequest19',

    );
}

# ----------------------------------------------------------------------
method SystemMeetMeConferencingModifyRequest (@generic_params) {
    return $self->send_command( 'SystemMeetMeConferencingModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingAddConferenceRequest19 ($x0, $x1, $x2, $x3, $x4, $x5, $x6, $x7, $x8, $x9, @generic_params) {
    return $self->send_query(
        'UserMeetMeConferencingAddConferenceRequest19',
        userId   => $x0,
        bridgeId => $x1,
        title    => $x2,
        @generic_params,
        muteAllAttendeesOnEntry      => $x3,
        endConferenceOnModeratorExit => $x4,
        moderatorRequired            => $x5,
        requireSecurityPin           => $x6,
        allowUniqueIdentifier        => $x7,
        attendeeNotification         => $x8,
        conferenceSchedule           => $x9
    );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingDeleteConferenceListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserMeetMeConferencingDeleteConferenceListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingDeleteConferenceRecordingListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserMeetMeConferencingDeleteConferenceRecordingListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingGetAvailableDelegateListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'UserMeetMeConferencingGetAvailableDelegateListRequest',
        userId        => $x0,
        conferenceKey => [ bridgeId => $x1, conferenceId => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingGetBridgeListRequest ($x0) {
    return $self->send_query( 'UserMeetMeConferencingGetBridgeListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingGetConferenceDelegateListRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'UserMeetMeConferencingGetConferenceDelegateListRequest',
        userId        => $x0,
        conferenceKey => [ bridgeId => $x1, conferenceId => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingGetConferenceListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserMeetMeConferencingGetConferenceListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingGetConferenceRecordingListRequest ($x0) {
    return $self->send_query( 'UserMeetMeConferencingGetConferenceRecordingListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingGetConferenceRequest20 ($x0, $x1, $x2) {
    return $self->send_query(
        'UserMeetMeConferencingGetConferenceRequest20',
        userId        => $x0,
        conferenceKey => [ bridgeId => $x1, conferenceId => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingModifyConferenceRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'UserMeetMeConferencingModifyConferenceRequest',
        userId        => $x0,
        conferenceKey => [ bridgeId => $x1, conferenceId => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingModifyConferenceDelegateListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'UserMeetMeConferencingModifyConferenceDelegateListRequest',
        userId        => $x0,
        conferenceKey => [ bridgeId => $x1, conferenceId => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingGetConferenceGreetingRequest20 ($x0, $x1, $x2) {
    return $self->send_query(
        'UserMeetMeConferencingGetConferenceGreetingRequest20',
        userId        => $x0,
        conferenceKey => [ bridgeId => $x1, conferenceId => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserMeetMeConferencingModifyConferenceGreetingRequest20 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'UserMeetMeConferencingModifyConferenceGreetingRequest20',
        userId        => $x0,
        conferenceKey => [ bridgeId => $x1, conferenceId => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceMusicOnHold
##
method GroupMusicOnHoldAddInstanceRequest20 ($x0, $x1, $x2, $x3, $x4, $x5, $x6, @generic_params) {
    return $self->send_command(
        'GroupMusicOnHoldAddInstanceRequest20',
        serviceProviderId                  => $x0,
        groupId                            => $x1,
        department                         => [],
        isActiveDuringCallHold             => $x2,
        isActiveDuringCallPark             => $x3,
        isActiveDuringBusyCampOn           => $x4,
        source                             => $x5,
        useAlternateSourceForInternalCalls => $x6,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupMusicOnHoldDeleteInstanceRequest ($x0, $x1) {
    return $self->send_command(
        'GroupMusicOnHoldDeleteInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        department        => []
    );
}

# ----------------------------------------------------------------------
method GroupMusicOnHoldGetInstanceRequest20 ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupMusicOnHoldGetInstanceRequest20',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupMusicOnHoldGetDepartmentListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupMusicOnHoldGetDepartmentListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupMusicOnHoldModifyInstanceRequest20 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupMusicOnHoldModifyInstanceRequest20',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemMusicOnHoldGetRequest () {
    return $self->send_query(
        'SystemMusicOnHoldGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemMusicOnHoldModifyRequest (@generic_params) {
    return $self->send_command( 'SystemMusicOnHoldModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserMusicOnHoldGetRequest ($x0) {
    return $self->send_query( 'UserMusicOnHoldGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserMusicOnHoldModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserMusicOnHoldModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserMusicOnHoldUserGetRequest20 ($x0) {
    return $self->send_query( 'UserMusicOnHoldUserGetRequest20', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserMusicOnHoldUserModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'UserMusicOnHoldUserModifyRequest20',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceNumberPortabilityAnnouncement
##
method UserNumberPortabilityAnnouncementGetRequest ($x0) {
    return $self->send_query( 'UserNumberPortabilityAnnouncementGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserNumberPortabilityAnnouncementModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserNumberPortabilityAnnouncementModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceOutgoingCallingPlan
##
method GroupOutgoingCallingPlanAuthorizationCodeGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanAuthorizationCodeGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanCallMeNowGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanCallMeNowGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanCallMeNowModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanCallMeNowModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanDepartmentAuthorizationCodeAddListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanDepartmentAuthorizationCodeAddListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params, codeEntry => $x2
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanDepartmentAuthorizationCodeDeleteListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanDepartmentAuthorizationCodeDeleteListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params, code => $x2
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanDepartmentAuthorizationCodeGetListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupOutgoingCallingPlanDepartmentAuthorizationCodeGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanDigitPlanCallMeNowGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanDigitPlanCallMeNowGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanDigitPlanCallMeNowModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanDigitPlanCallMeNowModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanDigitPlanOriginatingGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanDigitPlanOriginatingGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanDigitPlanOriginatingModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanDigitPlanOriginatingModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanDigitPlanRedirectingGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanDigitPlanRedirectingGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanDigitPlanRedirectingModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanDigitPlanRedirectingModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanOriginatingGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanOriginatingGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanOriginatingModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanOriginatingModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanPinholeDigitPatternAddRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'GroupOutgoingCallingPlanPinholeDigitPatternAddRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        digitPattern      => $x3
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanPinholeDigitPatternDeleteListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanPinholeDigitPatternDeleteListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanPinholeDigitPatternGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanPinholeDigitPatternGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanPinholeDigitPatternModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanPinholeDigitPatternModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanPinholeDigitPlanOriginatingGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanPinholeDigitPlanOriginatingGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanPinholeDigitPlanOriginatingModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanPinholeDigitPlanOriginatingModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanPinholeDigitPlanRedirectingGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanPinholeDigitPlanRedirectingGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanPinholeDigitPlanRedirectingModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanPinholeDigitPlanRedirectingModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanRedirectingGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanRedirectingGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanRedirectingModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanRedirectingModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanRedirectedGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanRedirectedGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanRedirectedModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanRedirectedModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanTransferNumbersGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupOutgoingCallingPlanTransferNumbersGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupOutgoingCallingPlanTransferNumbersModifyListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupOutgoingCallingPlanTransferNumbersModifyListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemOutgoingCallingPlanCallTypeAddMappingRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'SystemOutgoingCallingPlanCallTypeAddMappingRequest',
        countryCode => $x0,
        digitMap    => $x1,
        callType    => $x2
    );
}

# ----------------------------------------------------------------------
method SystemOutgoingCallingPlanCallTypeDeleteMappingRequest ($x0, $x1) {
    return $self->send_command(
        'SystemOutgoingCallingPlanCallTypeDeleteMappingRequest',
        countryCode => $x0,
        digitMap    => $x1
    );
}

# ----------------------------------------------------------------------
method SystemOutgoingCallingPlanCallTypeGetListRequest () {
    return $self->send_query(
        'SystemOutgoingCallingPlanCallTypeGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemOutgoingCallingPlanCallTypeGetMappingListRequest (@generic_params) {
    return $self->send_query( 'SystemOutgoingCallingPlanCallTypeGetMappingListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemOutgoingCallingPlanGetRequest17sp3 () {
    return $self->send_query(
        'SystemOutgoingCallingPlanGetRequest17sp3',

    );
}

# ----------------------------------------------------------------------
method SystemOutgoingCallingPlanModifyRequest (@generic_params) {
    return $self->send_command( 'SystemOutgoingCallingPlanModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanAuthorizationCodeAddListRequest ($x0, $x1) {
    return $self->send_command(
        'UserOutgoingCallingPlanAuthorizationCodeAddListRequest',
        userId    => $x0,
        codeEntry => $x1
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanAuthorizationCodeDeleteListRequest ($x0, $x1) {
    return $self->send_command(
        'UserOutgoingCallingPlanAuthorizationCodeDeleteListRequest',
        userId => $x0,
        code   => $x1
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanAuthorizationCodeGetListRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanAuthorizationCodeGetListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanAuthorizationCodeGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanAuthorizationCodeGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanAuthorizationCodeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanAuthorizationCodeModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanCallMeNowGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanCallMeNowGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanCallMeNowModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanCallMeNowModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanDigitPlanCallMeNowGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanDigitPlanCallMeNowGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanDigitPlanCallMeNowModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanDigitPlanCallMeNowModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanDigitPlanOriginatingGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanDigitPlanOriginatingGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanDigitPlanOriginatingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanDigitPlanOriginatingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanDigitPlanRedirectingGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanDigitPlanRedirectingGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanDigitPlanRedirectingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanDigitPlanRedirectingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanOriginatingGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanOriginatingGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanOriginatingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanOriginatingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanPinholeDigitPlanCallMeNowGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanPinholeDigitPlanCallMeNowGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanPinholeDigitPlanCallMeNowModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanPinholeDigitPlanCallMeNowModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanPinholeDigitPlanOriginatingGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanPinholeDigitPlanOriginatingGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanPinholeDigitPlanOriginatingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanPinholeDigitPlanOriginatingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanPinholeDigitPlanRedirectingGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanPinholeDigitPlanRedirectingGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanPinholeDigitPlanRedirectingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanPinholeDigitPlanRedirectingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanRedirectingGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanRedirectingGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanRedirectingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanRedirectingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanRedirectedGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanRedirectedGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanRedirectedModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanRedirectedModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanSustainedAuthorizationCodeGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanSustainedAuthorizationCodeGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanSustainedAuthorizationCodeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanSustainedAuthorizationCodeModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanTransferNumbersGetRequest ($x0) {
    return $self->send_query( 'UserOutgoingCallingPlanTransferNumbersGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutgoingCallingPlanTransferNumbersModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutgoingCallingPlanTransferNumbersModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceOutlookIntegration
##
method UserOutlookIntegrationGetRequest ($x0) {
    return $self->send_query( 'UserOutlookIntegrationGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserOutlookIntegrationModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserOutlookIntegrationModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServicePhysicalLocation
##
method SystemPhysicalLocationGetRequest () {
    return $self->send_query(
        'SystemPhysicalLocationGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemPhysicalLocationModifyRequest (@generic_params) {
    return $self->send_command( 'SystemPhysicalLocationModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserPhysicalLocationGetRequest ($x0) {
    return $self->send_query( 'UserPhysicalLocationGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserPhysicalLocationModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserPhysicalLocationModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServicePolycomPhoneServices
##
method GroupPolycomPhoneServicesGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupPolycomPhoneServicesGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupPolycomPhoneServicesModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupPolycomPhoneServicesModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPolycomPhoneServicesGetRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'UserPolycomPhoneServicesGetRequest',
        userId       => $x0,
        accessDevice => [ deviceLevel => $x1, deviceName => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserPolycomPhoneServicesModifyRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'UserPolycomPhoneServicesModifyRequest',
        userId       => $x0,
        accessDevice => [ deviceLevel => $x1, deviceName => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPolycomPhoneServicesGetPrimaryEndpointListRequest ($x0) {
    return $self->send_query( 'UserPolycomPhoneServicesGetPrimaryEndpointListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
##
## ServicePreAlertingAnnouncement
##
method EnterprisePreAlertingAnnouncementGetRequest ($x0) {
    return $self->send_query( 'EnterprisePreAlertingAnnouncementGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterprisePreAlertingAnnouncementModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'EnterprisePreAlertingAnnouncementModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupPreAlertingAnnouncementGetRequest20 ($x0, $x1) {
    return $self->send_query(
        'GroupPreAlertingAnnouncementGetRequest20',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupPreAlertingAnnouncementModifyRequest20 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupPreAlertingAnnouncementModifyRequest20',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPreAlertingAnnouncementGetRequest20 ($x0) {
    return $self->send_query( 'UserPreAlertingAnnouncementGetRequest20', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserPreAlertingAnnouncementModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'UserPreAlertingAnnouncementModifyRequest20',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPreAlertingAnnouncementAddCriteriaRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'UserPreAlertingAnnouncementAddCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params,
        blacklisted    => $x2,
        fromDnCriteria => $x3
    );
}

# ----------------------------------------------------------------------
method UserPreAlertingAnnouncementModifyCriteriaRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserPreAlertingAnnouncementModifyCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPreAlertingAnnouncementDeleteCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserPreAlertingAnnouncementDeleteCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserPreAlertingAnnouncementGetCriteriaRequest ($x0, $x1) {
    return $self->send_query(
        'UserPreAlertingAnnouncementGetCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
##
## ServicePreferredCarrier
##
method GroupPreferredCarrierGroupGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupPreferredCarrierGroupGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupPreferredCarrierGroupModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupPreferredCarrierGroupModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderPreferredCarrierAddRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderPreferredCarrierAddRequest',
        serviceProviderId => $x0,
        countryCode       => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderPreferredCarrierDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'ServiceProviderPreferredCarrierDeleteRequest',
        serviceProviderId => $x0,
        countryCode       => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderPreferredCarrierGetAvailableCountryCodeListRequest ($x0) {
    return $self->send_query( 'ServiceProviderPreferredCarrierGetAvailableCountryCodeListRequest',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderPreferredCarrierGetCarrierListRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderPreferredCarrierGetCarrierListRequest',
        serviceProviderId => $x0,
        countryCode       => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderPreferredCarrierGetListRequest ($x0) {
    return $self->send_query( 'ServiceProviderPreferredCarrierGetListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderPreferredCarrierGetRequest ($x0, $x1) {
    return $self->send_query(
        'ServiceProviderPreferredCarrierGetRequest',
        serviceProviderId => $x0,
        countryCode       => $x1
    );
}

# ----------------------------------------------------------------------
method ServiceProviderPreferredCarrierModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'ServiceProviderPreferredCarrierModifyRequest',
        serviceProviderId => $x0,
        countryCode       => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemPreferredCarrierAddRequest ($x0, $x1, $x2, $x3, $x4, $x5) {
    return $self->send_command(
        'SystemPreferredCarrierAddRequest',
        carrier         => $x0,
        cic             => $x1,
        countryCode     => $x2,
        isIntraLata     => $x3,
        isInterLata     => $x4,
        isInternational => $x5
    );
}

# ----------------------------------------------------------------------
method SystemPreferredCarrierDeleteRequest ($x0) {
    return $self->send_command( 'SystemPreferredCarrierDeleteRequest', carrier => $x0 );
}

# ----------------------------------------------------------------------
method SystemPreferredCarrierGetGroupListRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemPreferredCarrierGetGroupListRequest',
        carrier => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemPreferredCarrierGetListRequest () {
    return $self->send_query(
        'SystemPreferredCarrierGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemPreferredCarrierGetRequest ($x0) {
    return $self->send_query( 'SystemPreferredCarrierGetRequest', carrier => $x0 );
}

# ----------------------------------------------------------------------
method SystemPreferredCarrierGetUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemPreferredCarrierGetUserListRequest',
        carrier => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemPreferredCarrierModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemPreferredCarrierModifyRequest',
        carrier => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPreferredCarrierUserGetRequest ($x0) {
    return $self->send_query( 'UserPreferredCarrierUserGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserPreferredCarrierUserModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserPreferredCarrierUserModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServicePrepaid
##
method UserPrepaidGetRequest ($x0) {
    return $self->send_query( 'UserPrepaidGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserPrepaidModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserPrepaidModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServicePriorityAlert
##
method UserPriorityAlertAddCriteriaRequest16 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'UserPriorityAlertAddCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params,
        blacklisted    => $x2,
        fromDnCriteria => $x3
    );
}

# ----------------------------------------------------------------------
method UserPriorityAlertDeleteCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserPriorityAlertDeleteCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserPriorityAlertGetCriteriaListRequest ($x0) {
    return $self->send_query( 'UserPriorityAlertGetCriteriaListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserPriorityAlertGetCriteriaRequest16 ($x0, $x1) {
    return $self->send_query(
        'UserPriorityAlertGetCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserPriorityAlertModifyActiveCriteriaListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserPriorityAlertModifyActiveCriteriaListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPriorityAlertModifyCriteriaRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserPriorityAlertModifyCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServicePrivacy
##
method GroupServiceInstancePrivacyGetRequest17sp4 ($x0) {
    return $self->send_query( 'GroupServiceInstancePrivacyGetRequest17sp4', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupServiceInstancePrivacyModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupServiceInstancePrivacyModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPrivacyGetAvailableMonitorsUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserPrivacyGetAvailableMonitorsUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPrivacyGetRequest13mp17 ($x0) {
    return $self->send_query( 'UserPrivacyGetRequest13mp17', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserPrivacyModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserPrivacyModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServicePushToTalk
##
method UserPushToTalkGetAvailableUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserPushToTalkGetAvailableUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserPushToTalkGetRequest ($x0) {
    return $self->send_query( 'UserPushToTalkGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserPushToTalkModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserPushToTalkModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceReceptionistEnterprise
##
method SystemBroadWorksReceptionistEnterpriseGetRequest () {
    return $self->send_query(
        'SystemBroadWorksReceptionistEnterpriseGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemBroadWorksReceptionistEnterpriseModifyRequest (@generic_params) {
    return $self->send_command( 'SystemBroadWorksReceptionistEnterpriseModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserBroadWorksReceptionistEnterpriseAddUserListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserBroadWorksReceptionistEnterpriseAddUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksReceptionistEnterpriseDeleteUserListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserBroadWorksReceptionistEnterpriseDeleteUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksReceptionistEnterpriseGetAvailableUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserBroadWorksReceptionistEnterpriseGetAvailableUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksReceptionistEnterpriseGetRequest ($x0) {
    return $self->send_query( 'UserBroadWorksReceptionistEnterpriseGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserBroadWorksReceptionistEnterpriseModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserBroadWorksReceptionistEnterpriseModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceReceptionistOffice
##
method UserBroadWorksReceptionistOfficeGetAvailableUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserBroadWorksReceptionistOfficeGetAvailableUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksReceptionistOfficeGetRequest ($x0) {
    return $self->send_query( 'UserBroadWorksReceptionistOfficeGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserBroadWorksReceptionistOfficeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserBroadWorksReceptionistOfficeModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceReceptionistSmallBusiness
##
method UserBroadWorksReceptionistSmallBusinessGetAvailableUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'UserBroadWorksReceptionistSmallBusinessGetAvailableUserListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserBroadWorksReceptionistSmallBusinessGetRequest ($x0) {
    return $self->send_query( 'UserBroadWorksReceptionistSmallBusinessGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserBroadWorksReceptionistSmallBusinessModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserBroadWorksReceptionistSmallBusinessModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceRemoteOffice
##
method UserRemoteOfficeGetRequest ($x0) {
    return $self->send_query( 'UserRemoteOfficeGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserRemoteOfficeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserRemoteOfficeModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceRoutePoint
##
method GroupRoutePointAddDNISRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupRoutePointAddDNISRequest',
        dnisKey => [ serviceUserId => $x0, name => $x1 ],
        @generic_params,
        useCustomDnisAnnouncementSettings => $x2,
        allowOutgoingACDCall              => $x3
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointAddInstanceRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupRoutePointAddInstanceRequest',
        serviceProviderId      => $x0,
        groupId                => $x1,
        serviceUserId          => $x2,
        serviceInstanceProfile => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointBouncedCallGetRequest ($x0) {
    return $self->send_query( 'GroupRoutePointBouncedCallGetRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointBouncedCallModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupRoutePointBouncedCallModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointDeleteDNISRequest ($x0, $x1) {
    return $self->send_command( 'GroupRoutePointDeleteDNISRequest', dnisKey => [ serviceUserId => $x0, name => $x1 ] );
}

# ----------------------------------------------------------------------
method GroupRoutePointDeleteInstanceRequest ($x0) {
    return $self->send_command( 'GroupRoutePointDeleteInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointDistinctiveRingingGetRequest ($x0) {
    return $self->send_query( 'GroupRoutePointDistinctiveRingingGetRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointDistinctiveRingingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupRoutePointDistinctiveRingingModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointGetAnnouncementRequest20 ($x0) {
    return $self->send_query( 'GroupRoutePointGetAnnouncementRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointGetDNISAgentListRequest ($x0, $x1) {
    return $self->send_query( 'GroupRoutePointGetDNISAgentListRequest',
        dnisKey => [ serviceUserId => $x0, name => $x1 ] );
}

# ----------------------------------------------------------------------
method GroupRoutePointGetDNISAnnouncementRequest20 ($x0, $x1) {
    return $self->send_query( 'GroupRoutePointGetDNISAnnouncementRequest20',
        dnisKey => [ serviceUserId => $x0, name => $x1 ] );
}

# ----------------------------------------------------------------------
method GroupRoutePointGetDNISListRequest ($x0) {
    return $self->send_query( 'GroupRoutePointGetDNISListRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointGetDNISRequest ($x0, $x1) {
    return $self->send_query( 'GroupRoutePointGetDNISRequest', dnisKey => [ serviceUserId => $x0, name => $x1 ] );
}

# ----------------------------------------------------------------------
method GroupRoutePointGetFailoverPolicyRequest ($x0) {
    return $self->send_query( 'GroupRoutePointGetFailoverPolicyRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointGetInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupRoutePointGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointGetInstanceRequest19sp1 ($x0) {
    return $self->send_query( 'GroupRoutePointGetInstanceRequest19sp1', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointForcedForwardingGetRequest20 ($x0) {
    return $self->send_query( 'GroupRoutePointForcedForwardingGetRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointForcedForwardingModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupRoutePointForcedForwardingModifyRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointHolidayServiceGetRequest20 ($x0) {
    return $self->send_query( 'GroupRoutePointHolidayServiceGetRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointHolidayServiceModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupRoutePointHolidayServiceModifyRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointModifyActiveInstanceListRequest (@generic_params) {
    return $self->send_command( 'GroupRoutePointModifyActiveInstanceListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupRoutePointModifyAnnouncementRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupRoutePointModifyAnnouncementRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointModifyDNISAnnouncementRequest20 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupRoutePointModifyDNISAnnouncementRequest20',
        dnisKey => [ serviceUserId => $x0, name => $x1 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointModifyDNISParametersRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupRoutePointModifyDNISParametersRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointModifyDNISRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupRoutePointModifyDNISRequest',
        dnisKey => [ serviceUserId => $x0, name => $x1 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointManualFailoverRequest ($x0) {
    return $self->send_command( 'GroupRoutePointManualFailoverRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointModifyFailoverPolicyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupRoutePointModifyFailoverPolicyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointModifyInstanceRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupRoutePointModifyInstanceRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointNightServiceGetRequest20 ($x0) {
    return $self->send_query( 'GroupRoutePointNightServiceGetRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointNightServiceModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupRoutePointNightServiceModifyRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointOverflowGetRequest20 ($x0) {
    return $self->send_query( 'GroupRoutePointOverflowGetRequest20', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointOverflowModifyRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'GroupRoutePointOverflowModifyRequest20',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointQueueCallDispositionCodeAddRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupRoutePointQueueCallDispositionCodeAddRequest',
        serviceUserId => $x0,
        code          => $x1,
        isActive      => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointQueueCallDispositionCodeDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'GroupRoutePointQueueCallDispositionCodeDeleteRequest',
        serviceUserId => $x0,
        code          => $x1
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointQueueCallDispositionCodeGetListRequest ($x0) {
    return $self->send_query( 'GroupRoutePointQueueCallDispositionCodeGetListRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointQueueCallDispositionCodeGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupRoutePointQueueCallDispositionCodeGetRequest',
        serviceUserId => $x0,
        code          => $x1
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointQueueCallDispositionCodeModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupRoutePointQueueCallDispositionCodeModifyRequest',
        serviceUserId => $x0,
        code          => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupRoutePointQueueCallDispositionCodeSettingsGetRequest ($x0) {
    return $self->send_query( 'GroupRoutePointQueueCallDispositionCodeSettingsGetRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupRoutePointQueueCallDispositionCodeSettingsModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupRoutePointQueueCallDispositionCodeSettingsModifyRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserRoutePointCallDispositionCodeGetAvailableListRequest ($x0) {
    return $self->send_query( 'UserRoutePointCallDispositionCodeGetAvailableListRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method UserRoutePointSupervisorGetListRequest ($x0) {
    return $self->send_query( 'UserRoutePointSupervisorGetListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserRoutePointSupervisorModifyListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserRoutePointSupervisorModifyListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceSMDIMessageDesk
##
method SystemSMDIMessageDeskAddServerRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'SystemSMDIMessageDeskAddServerRequest',
        deviceName => $x0,
        netAddress => $x1,
        port       => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSMDIMessageDeskDeleteServerRequest ($x0) {
    return $self->send_command( 'SystemSMDIMessageDeskDeleteServerRequest', deviceName => $x0 );
}

# ----------------------------------------------------------------------
method SystemSMDIMessageDeskGetServerListRequest () {
    return $self->send_query(
        'SystemSMDIMessageDeskGetServerListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSMDIMessageDeskModifyServerRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemSMDIMessageDeskModifyServerRequest',
        deviceName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSMDIMessageDeskAddServerRouteRequest ($x0, $x1) {
    return $self->send_command(
        'SystemSMDIMessageDeskAddServerRouteRequest',
        routeDestination => $x0,
        deviceName       => $x1
    );
}

# ----------------------------------------------------------------------
method SystemSMDIMessageDeskDeleteServerRouteRequest ($x0) {
    return $self->send_command( 'SystemSMDIMessageDeskDeleteServerRouteRequest', routeDestination => $x0 );
}

# ----------------------------------------------------------------------
method SystemSMDIMessageDeskGetServerRouteListRequest () {
    return $self->send_query(
        'SystemSMDIMessageDeskGetServerRouteListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSMDIMessageDeskModifyServerRouteRequest (@generic_params) {
    return $self->send_query( 'SystemSMDIMessageDeskModifyServerRouteRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserSMDIMessageDeskAddServerRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'UserSMDIMessageDeskAddServerRequest',
        userId     => $x0,
        deviceName => $x1,
        netAddress => $x2,
        port       => $x3
    );
}

# ----------------------------------------------------------------------
method UserSMDIMessageDeskDeleteServerListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserSMDIMessageDeskDeleteServerListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSMDIMessageDeskGetRequest ($x0) {
    return $self->send_query( 'UserSMDIMessageDeskGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserSMDIMessageDeskGetServerListRequest ($x0) {
    return $self->send_query( 'UserSMDIMessageDeskGetServerListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserSMDIMessageDeskModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserSMDIMessageDeskModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceSecurityClassification
##
method GroupTrunkGroupSecurityClassificationGetRequest ($x0, $x1, $x2) {
    return $self->send_query( 'GroupTrunkGroupSecurityClassificationGetRequest',
        trunkGroupKey => [ serviceProviderId => $x0, groupId => $x1, name => $x2 ] );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupSecurityClassificationModifyRequest ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'GroupTrunkGroupSecurityClassificationModifyRequest',
        trunkGroupKey                 => [ serviceProviderId => $x0, groupId => $x1, name => $x2 ],
        defaultSecurityClassification => $x3
    );
}

# ----------------------------------------------------------------------
method SystemSecurityClassificationGetClassificationRequest ($x0) {
    return $self->send_query( 'SystemSecurityClassificationGetClassificationRequest',
        securityClassificationName => $x0 );
}

# ----------------------------------------------------------------------
method SystemSecurityClassificationAddClassificationRequest ($x0, $x1) {
    return $self->send_command(
        'SystemSecurityClassificationAddClassificationRequest',
        securityClassificationName => $x0,
        audioFile                  => $x1
    );
}

# ----------------------------------------------------------------------
method SystemSecurityClassificationDeleteClassificationRequest ($x0) {
    return $self->send_command( 'SystemSecurityClassificationDeleteClassificationRequest',
        securityClassificationName => $x0 );
}

# ----------------------------------------------------------------------
method SystemSecurityClassificationGetRequest () {
    return $self->send_query(
        'SystemSecurityClassificationGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemSecurityClassificationModifyRequest (@generic_params) {
    return $self->send_command( 'SystemSecurityClassificationModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemSecurityClassificationModifyClassificationRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemSecurityClassificationModifyClassificationRequest',
        securityClassificationName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSecurityClassificationGetRequest ($x0) {
    return $self->send_query( 'UserSecurityClassificationGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserSecurityClassificationModifyRequest ($x0, $x1) {
    return $self->send_command(
        'UserSecurityClassificationModifyRequest',
        userId                 => $x0,
        securityClassification => $x1
    );
}

# ----------------------------------------------------------------------
method SystemSecurityClassificationGetClassificationUserUsageListRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemSecurityClassificationGetClassificationUserUsageListRequest',
        securityClassification => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSecurityClassificationGetClassificationTrunkGroupUsageListRequest ($x0, @generic_params) {
    return $self->send_query(
        'SystemSecurityClassificationGetClassificationTrunkGroupUsageListRequest',
        securityClassification => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceSelectiveCallAcceptance
##
method UserSelectiveCallAcceptanceAddCriteriaRequest16 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'UserSelectiveCallAcceptanceAddCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params,
        blacklisted    => $x2,
        fromDnCriteria => $x3
    );
}

# ----------------------------------------------------------------------
method UserSelectiveCallAcceptanceDeleteCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserSelectiveCallAcceptanceDeleteCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserSelectiveCallAcceptanceGetCriteriaListRequest ($x0) {
    return $self->send_query( 'UserSelectiveCallAcceptanceGetCriteriaListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserSelectiveCallAcceptanceGetCriteriaRequest16 ($x0, $x1) {
    return $self->send_query(
        'UserSelectiveCallAcceptanceGetCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserSelectiveCallAcceptanceModifyActiveCriteriaListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserSelectiveCallAcceptanceModifyActiveCriteriaListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSelectiveCallAcceptanceModifyCriteriaRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserSelectiveCallAcceptanceModifyCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceSelectiveCallRejection
##
method UserSelectiveCallRejectionAddCriteriaRequest16 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'UserSelectiveCallRejectionAddCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params, blacklisted => $x2
    );
}

# ----------------------------------------------------------------------
method UserSelectiveCallRejectionDeleteCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserSelectiveCallRejectionDeleteCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserSelectiveCallRejectionGetCriteriaListRequest ($x0) {
    return $self->send_query( 'UserSelectiveCallRejectionGetCriteriaListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserSelectiveCallRejectionGetCriteriaRequest16sp1 ($x0, $x1) {
    return $self->send_query(
        'UserSelectiveCallRejectionGetCriteriaRequest16sp1',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserSelectiveCallRejectionModifyActiveCriteriaListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserSelectiveCallRejectionModifyActiveCriteriaListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSelectiveCallRejectionModifyCriteriaRequest16 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserSelectiveCallRejectionModifyCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceSequentialRing
##
method UserSequentialRingAddCriteriaRequest16 ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'UserSequentialRingAddCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params,
        blacklisted    => $x2,
        fromDnCriteria => $x3
    );
}

# ----------------------------------------------------------------------
method UserSequentialRingDeleteCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserSequentialRingDeleteCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserSequentialRingGetCriteriaRequest16 ($x0, $x1) {
    return $self->send_query(
        'UserSequentialRingGetCriteriaRequest16',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserSequentialRingGetRequest14sp4 ($x0) {
    return $self->send_query( 'UserSequentialRingGetRequest14sp4', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserSequentialRingModifyCriteriaRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserSequentialRingModifyCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSequentialRingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserSequentialRingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceSeriesCompletion
##
method GroupSeriesCompletionAddInstanceRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupSeriesCompletionAddInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupSeriesCompletionDeleteInstanceRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupSeriesCompletionDeleteInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupSeriesCompletionGetAvailableUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupSeriesCompletionGetAvailableUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupSeriesCompletionGetInstanceListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupSeriesCompletionGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupSeriesCompletionGetInstanceRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupSeriesCompletionGetInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2
    );
}

# ----------------------------------------------------------------------
method GroupSeriesCompletionModifyInstanceRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupSeriesCompletionModifyInstanceRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSeriesCompletionGetRequest ($x0) {
    return $self->send_query( 'UserSeriesCompletionGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
##
## ServiceServiceScripts
##
method GroupServiceScriptsGroupClearLogRequest ($x0, $x1) {
    return $self->send_command(
        'GroupServiceScriptsGroupClearLogRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupServiceScriptsGroupGetLogRequest ($x0, $x1) {
    return $self->send_query(
        'GroupServiceScriptsGroupGetLogRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupServiceScriptsGroupGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupServiceScriptsGroupGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupServiceScriptsGroupModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupServiceScriptsGroupModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserServiceScriptsUserClearLogRequest ($x0) {
    return $self->send_command( 'UserServiceScriptsUserClearLogRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserServiceScriptsUserGetLogRequest ($x0) {
    return $self->send_query( 'UserServiceScriptsUserGetLogRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserServiceScriptsUserGetRequest ($x0) {
    return $self->send_query( 'UserServiceScriptsUserGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserServiceScriptsUserModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserServiceScriptsUserModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceSharedCallAppearance
##
method UserSharedCallAppearanceAddEndpointRequest14sp2 ($x0, $x1, $x2, $x3, $x4) {
    return $self->send_command(
        'UserSharedCallAppearanceAddEndpointRequest14sp2',
        userId               => $x0,
        accessDeviceEndpoint => $x1,
        isActive             => $x2,
        allowOrigination     => $x3,
        allowTermination     => $x4
    );
}

# ----------------------------------------------------------------------
method UserSharedCallAppearanceDeleteEndpointListRequest14 ($x0, @generic_params) {
    return $self->send_command(
        'UserSharedCallAppearanceDeleteEndpointListRequest14',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSharedCallAppearanceGetEndpointRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'UserSharedCallAppearanceGetEndpointRequest',
        userId               => $x0,
        accessDeviceEndpoint => [ accessDevice => $x1, linePort => $x2 ]
    );
}

# ----------------------------------------------------------------------
method UserSharedCallAppearanceGetRequest16sp2 ($x0) {
    return $self->send_query( 'UserSharedCallAppearanceGetRequest16sp2', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserSharedCallAppearanceModifyEndpointRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'UserSharedCallAppearanceModifyEndpointRequest',
        userId               => $x0,
        accessDeviceEndpoint => [ accessDevice => $x1, linePort => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSharedCallAppearanceModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserSharedCallAppearanceModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceSimultaneousRingFamily
##
method UserSimultaneousRingFamilyAddCriteriaRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'UserSimultaneousRingFamilyAddCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params,
        blacklisted    => $x2,
        fromDnCriteria => $x3
    );
}

# ----------------------------------------------------------------------
method UserSimultaneousRingFamilyDeleteCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserSimultaneousRingFamilyDeleteCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserSimultaneousRingFamilyGetCriteriaRequest ($x0, $x1) {
    return $self->send_query(
        'UserSimultaneousRingFamilyGetCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserSimultaneousRingFamilyGetRequest17 ($x0) {
    return $self->send_query( 'UserSimultaneousRingFamilyGetRequest17', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserSimultaneousRingFamilyModifyCriteriaRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserSimultaneousRingFamilyModifyCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSimultaneousRingFamilyModifyRequest17 ($x0, @generic_params) {
    return $self->send_command(
        'UserSimultaneousRingFamilyModifyRequest17',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceSimultaneousRingPersonal
##
method UserSimultaneousRingPersonalAddCriteriaRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'UserSimultaneousRingPersonalAddCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params,
        blacklisted    => $x2,
        fromDnCriteria => $x3
    );
}

# ----------------------------------------------------------------------
method UserSimultaneousRingPersonalDeleteCriteriaRequest ($x0, $x1) {
    return $self->send_command(
        'UserSimultaneousRingPersonalDeleteCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserSimultaneousRingPersonalGetCriteriaRequest ($x0, $x1) {
    return $self->send_query(
        'UserSimultaneousRingPersonalGetCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1
    );
}

# ----------------------------------------------------------------------
method UserSimultaneousRingPersonalGetRequest17 ($x0) {
    return $self->send_query( 'UserSimultaneousRingPersonalGetRequest17', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserSimultaneousRingPersonalModifyCriteriaRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserSimultaneousRingPersonalModifyCriteriaRequest',
        userId       => $x0,
        criteriaName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSimultaneousRingPersonalModifyRequest17 ($x0, @generic_params) {
    return $self->send_command(
        'UserSimultaneousRingPersonalModifyRequest17',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceSpeedDial100
##
method GroupSpeedDial100GetRequest17sp1 ($x0, $x1) {
    return $self->send_query(
        'GroupSpeedDial100GetRequest17sp1',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupSpeedDial100ModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupSpeedDial100ModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemSpeedDial100GetRequest17sp1 () {
    return $self->send_query(
        'SystemSpeedDial100GetRequest17sp1',

    );
}

# ----------------------------------------------------------------------
method SystemSpeedDial100ModifyRequest (@generic_params) {
    return $self->send_command( 'SystemSpeedDial100ModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method UserSpeedDial100AddListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserSpeedDial100AddListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSpeedDial100DeleteListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserSpeedDial100DeleteListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserSpeedDial100GetListRequest17sp1 ($x0) {
    return $self->send_query( 'UserSpeedDial100GetListRequest17sp1', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserSpeedDial100GetRequest ($x0, $x1) {
    return $self->send_command(
        'UserSpeedDial100GetRequest',
        userId    => $x0,
        speedCode => $x1
    );
}

# ----------------------------------------------------------------------
method UserSpeedDial100ModifyListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserSpeedDial100ModifyListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceSpeedDial8
##
method UserSpeedDial8GetListRequest ($x0) {
    return $self->send_query( 'UserSpeedDial8GetListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserSpeedDial8ModifyListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserSpeedDial8ModifyListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceThirdPartyIMP
##
method SystemThirdPartyIMPGetRequest19 () {
    return $self->send_query(
        'SystemThirdPartyIMPGetRequest19',

    );
}

# ----------------------------------------------------------------------
method SystemThirdPartyIMPModifyRequest (@generic_params) {
    return $self->send_command( 'SystemThirdPartyIMPModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceThirdPartyVoiceMailSupport
##
method UserThirdPartyVoiceMailSupportGetRequest17 ($x0) {
    return $self->send_query( 'UserThirdPartyVoiceMailSupportGetRequest17', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserThirdPartyVoiceMailSupportModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserThirdPartyVoiceMailSupportModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupThirdPartyVoiceMailSupportGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupThirdPartyVoiceMailSupportGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupThirdPartyVoiceMailSupportModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupThirdPartyVoiceMailSupportModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemThirdPartyVoiceMailSupportAddDnRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemThirdPartyVoiceMailSupportAddDnRequest',
        phoneNumber => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemThirdPartyVoiceMailSupportDeleteDnRequest ($x0) {
    return $self->send_command( 'SystemThirdPartyVoiceMailSupportDeleteDnRequest', phoneNumber => $x0 );
}

# ----------------------------------------------------------------------
method SystemThirdPartyVoiceMailSupportGetDnListRequest (@generic_params) {
    return $self->send_query( 'SystemThirdPartyVoiceMailSupportGetDnListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemThirdPartyVoiceMailSupportModifyDnRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemThirdPartyVoiceMailSupportModifyDnRequest',
        phoneNumber => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemThirdPartyVoiceMailSupportGetRequest17sp4 () {
    return $self->send_query(
        'SystemThirdPartyVoiceMailSupportGetRequest17sp4',

    );
}

# ----------------------------------------------------------------------
method SystemThirdPartyVoiceMailSupportModifyRequest (@generic_params) {
    return $self->send_command( 'SystemThirdPartyVoiceMailSupportModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceTrunkGroup
##
method EnterpriseEnterpriseTrunkAddRequest (@generic_params) {
    return $self->send_query( 'EnterpriseEnterpriseTrunkAddRequest', @generic_params );
}

# ----------------------------------------------------------------------
method EnterpriseEnterpriseTrunkAddUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseEnterpriseTrunkAddUserListRequest',
        serviceProviderId   => $x0,
        enterpriseTrunkName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseEnterpriseTrunkDeleteRequest ($x0, $x1) {
    return $self->send_command(
        'EnterpriseEnterpriseTrunkDeleteRequest',
        serviceProviderId   => $x0,
        enterpriseTrunkName => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseEnterpriseTrunkDeleteUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'EnterpriseEnterpriseTrunkDeleteUserListRequest',
        serviceProviderId   => $x0,
        enterpriseTrunkName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseEnterpriseTrunkGetAvailableTrunkGroupListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseEnterpriseTrunkGetAvailableTrunkGroupListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseEnterpriseTrunkGetAvailableUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseEnterpriseTrunkGetAvailableUserListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseEnterpriseTrunkGetListRequest ($x0) {
    return $self->send_query( 'EnterpriseEnterpriseTrunkGetListRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method EnterpriseEnterpriseTrunkGetRequest ($x0, $x1) {
    return $self->send_query(
        'EnterpriseEnterpriseTrunkGetRequest',
        serviceProviderId   => $x0,
        enterpriseTrunkName => $x1
    );
}

# ----------------------------------------------------------------------
method EnterpriseEnterpriseTrunkGetUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'EnterpriseEnterpriseTrunkGetUserListRequest',
        serviceProviderId   => $x0,
        enterpriseTrunkName => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method EnterpriseEnterpriseTrunkModifyRequest (@generic_params) {
    return $self->send_query( 'EnterpriseEnterpriseTrunkModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupEnterpriseTrunkAddRequest (@generic_params) {
    return $self->send_query( 'GroupEnterpriseTrunkAddRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupEnterpriseTrunkAddUserListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupEnterpriseTrunkAddUserListRequest',
        serviceProviderId   => $x0,
        groupId             => $x1,
        enterpriseTrunkName => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupEnterpriseTrunkDeleteRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupEnterpriseTrunkDeleteRequest',
        serviceProviderId   => $x0,
        groupId             => $x1,
        enterpriseTrunkName => $x2
    );
}

# ----------------------------------------------------------------------
method GroupEnterpriseTrunkDeleteUserListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupEnterpriseTrunkDeleteUserListRequest',
        serviceProviderId   => $x0,
        groupId             => $x1,
        enterpriseTrunkName => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupEnterpriseTrunkGetAvailableTrunkGroupListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupEnterpriseTrunkGetAvailableTrunkGroupListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupEnterpriseTrunkGetAvailableUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupEnterpriseTrunkGetAvailableUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupEnterpriseTrunkGetListRequest ($x0, $x1) {
    return $self->send_query(
        'GroupEnterpriseTrunkGetListRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupEnterpriseTrunkGetRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupEnterpriseTrunkGetRequest',
        serviceProviderId   => $x0,
        groupId             => $x1,
        enterpriseTrunkName => $x2
    );
}

# ----------------------------------------------------------------------
method GroupEnterpriseTrunkGetUserListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupEnterpriseTrunkGetUserListRequest',
        serviceProviderId   => $x0,
        groupId             => $x1,
        enterpriseTrunkName => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupEnterpriseTrunkModifyRequest (@generic_params) {
    return $self->send_query( 'GroupEnterpriseTrunkModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupAddInstanceRequest20sp1 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupTrunkGroupAddInstanceRequest20sp1',
        serviceProviderId => $x0,
        groupId           => $x1,
        name              => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupDeleteInstanceRequest14sp4 ($x0, $x1, $x2) {
    return $self->send_command( 'GroupTrunkGroupDeleteInstanceRequest14sp4',
        trunkGroupKey => [ serviceProviderId => $x0, groupId => $x1, name => $x2 ] );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupGetInstanceListRequest14sp4 ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupTrunkGroupGetInstanceListRequest14sp4',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupGetInstanceRequest20sp1 ($x0, $x1, $x2) {
    return $self->send_query( 'GroupTrunkGroupGetInstanceRequest20sp1',
        trunkGroupKey => [ serviceProviderId => $x0, groupId => $x1, name => $x2 ] );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupGetAvailableHostedUserListRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupTrunkGroupGetAvailableHostedUserListRequest',
        trunkGroupKey => [ serviceProviderId => $x0, groupId => $x1, name => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupGetInstanceUserListRequest14sp4 ($x0, $x1, $x2, @generic_params) {
    return $self->send_query(
        'GroupTrunkGroupGetInstanceUserListRequest14sp4',
        trunkGroupKey => [ serviceProviderId => $x0, groupId => $x1, name => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupGetRequest14sp9 ($x0, $x1) {
    return $self->send_query(
        'GroupTrunkGroupGetRequest14sp9',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupModifyInstanceRequest20sp1 ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupTrunkGroupModifyInstanceRequest20sp1',
        trunkGroupKey => [ serviceProviderId => $x0, groupId => $x1, name => $x2 ],
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupModifyRequest14sp9 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupTrunkGroupModifyRequest14sp9',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupUserCreationTaskAddRequest14sp4 (@generic_params) {
    return $self->send_query( 'GroupTrunkGroupUserCreationTaskAddRequest14sp4', @generic_params );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupUserCreationTaskDeleteRequest14sp4 ($x0, $x1, $x2, $x3) {
    return $self->send_command(
        'GroupTrunkGroupUserCreationTaskDeleteRequest14sp4',
        trunkGroupKey => [ serviceProviderId => $x0, groupId => $x1, name => $x2 ],
        taskName      => $x3
    );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupUserCreationTaskGetListRequest14sp4 ($x0, $x1, $x2) {
    return $self->send_query( 'GroupTrunkGroupUserCreationTaskGetListRequest14sp4',
        trunkGroupKey => [ serviceProviderId => $x0, groupId => $x1, name => $x2 ] );
}

# ----------------------------------------------------------------------
method GroupTrunkGroupUserCreationTaskGetRequest14sp4 ($x0, $x1, $x2, $x3) {
    return $self->send_query(
        'GroupTrunkGroupUserCreationTaskGetRequest14sp4',
        trunkGroupKey => [ serviceProviderId => $x0, groupId => $x1, name => $x2 ],
        taskName      => $x3
    );
}

# ----------------------------------------------------------------------
method ServiceProviderTrunkGroupGetRequest14sp1 ($x0) {
    return $self->send_query( 'ServiceProviderTrunkGroupGetRequest14sp1', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderTrunkGroupModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderTrunkGroupModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemTrunkGroupUserCreationTaskGetListRequest14sp4 () {
    return $self->send_query(
        'SystemTrunkGroupUserCreationTaskGetListRequest14sp4',

    );
}

# ----------------------------------------------------------------------
method SystemTrunkGroupGetRequest19sp1 () {
    return $self->send_query(
        'SystemTrunkGroupGetRequest19sp1',

    );
}

# ----------------------------------------------------------------------
method SystemTrunkGroupModifyRequest (@generic_params) {
    return $self->send_command( 'SystemTrunkGroupModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
##
## ServiceTwoStageDialing
##
method UserTwoStageDialingGetRequest13Mp20 ($x0) {
    return $self->send_query( 'UserTwoStageDialingGetRequest13Mp20', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserTwoStageDialingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserTwoStageDialingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemTwoStageDialingAddDnRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemTwoStageDialingAddDnRequest',
        phoneNumber => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemTwoStageDialingDeleteDnRequest ($x0) {
    return $self->send_command( 'SystemTwoStageDialingDeleteDnRequest', phoneNumber => $x0 );
}

# ----------------------------------------------------------------------
method SystemTwoStageDialingGetDnListRequest (@generic_params) {
    return $self->send_query( 'SystemTwoStageDialingGetDnListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemTwoStageDialingModifyDnRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemTwoStageDialingModifyDnRequest',
        phoneNumber => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceVideoAddOn
##
method UserVideoAddOnGetRequest19 ($x0) {
    return $self->send_query( 'UserVideoAddOnGetRequest19', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserVideoAddOnModifyRequest14 ($x0, @generic_params) {
    return $self->send_command(
        'UserVideoAddOnModifyRequest14',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceVirtualOnNetEnterpriseExtensions
##
method EnterpriseVirtualOnNetEnterpriseExtensionsGetUserListRequest ($x0, @generic_params) {
    return $self->send_query(
        'EnterpriseVirtualOnNetEnterpriseExtensionsGetUserListRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupVirtualOnNetEnterpriseExtensionsAddUserRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupVirtualOnNetEnterpriseExtensionsAddUserRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupVirtualOnNetEnterpriseExtensionsDeleteUserRequest ($x0, $x1, $x2) {
    return $self->send_command(
        'GroupVirtualOnNetEnterpriseExtensionsDeleteUserRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        phoneNumber       => $x2
    );
}

# ----------------------------------------------------------------------
method GroupVirtualOnNetEnterpriseExtensionsGetUserListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupVirtualOnNetEnterpriseExtensionsGetUserListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupVirtualOnNetEnterpriseExtensionsGetUserRequest ($x0, $x1, $x2) {
    return $self->send_query(
        'GroupVirtualOnNetEnterpriseExtensionsGetUserRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        phoneNumber       => $x2
    );
}

# ----------------------------------------------------------------------
method GroupVirtualOnNetEnterpriseExtensionsModifyUserRequest ($x0, $x1, $x2, @generic_params) {
    return $self->send_command(
        'GroupVirtualOnNetEnterpriseExtensionsModifyUserRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        phoneNumber       => $x2,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemVirtualOnNetCallTypeAddRequest ($x0, $x1) {
    return $self->send_command(
        'SystemVirtualOnNetCallTypeAddRequest',
        virtualOnNetCallTypeName     => $x0,
        virtualOnNetCallTypeCdrValue => $x1
    );
}

# ----------------------------------------------------------------------
method SystemVirtualOnNetCallTypeDeleteRequest ($x0) {
    return $self->send_command( 'SystemVirtualOnNetCallTypeDeleteRequest', virtualOnNetCallTypeName => $x0 );
}

# ----------------------------------------------------------------------
method SystemVirtualOnNetCallTypeGetListRequest () {
    return $self->send_query(
        'SystemVirtualOnNetCallTypeGetListRequest',

    );
}

# ----------------------------------------------------------------------
method SystemVirtualOnNetCallTypeModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'SystemVirtualOnNetCallTypeModifyRequest',
        virtualOnNetCallTypeName => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceVoiceMessaging
##
method GroupVoiceMessagingGroupGetRequest ($x0, $x1) {
    return $self->send_query(
        'GroupVoiceMessagingGroupGetRequest',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupVoiceMessagingGroupGetVoicePortalBrandingRequest20 ($x0, $x1) {
    return $self->send_query(
        'GroupVoiceMessagingGroupGetVoicePortalBrandingRequest20',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupVoiceMessagingGroupGetVoicePortalRequest19sp1 ($x0, $x1) {
    return $self->send_query(
        'GroupVoiceMessagingGroupGetVoicePortalRequest19sp1',
        serviceProviderId => $x0,
        groupId           => $x1
    );
}

# ----------------------------------------------------------------------
method GroupVoiceMessagingGroupModifyRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupVoiceMessagingGroupModifyRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupVoiceMessagingGroupModifyVoicePortalBrandingRequest20 ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupVoiceMessagingGroupModifyVoicePortalBrandingRequest20',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupVoiceMessagingGroupModifyVoicePortalRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'GroupVoiceMessagingGroupModifyVoicePortalRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderVoiceMessagingGroupGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderVoiceMessagingGroupGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest16 ($x0) {
    return $self->send_query( 'ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest16',
        serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderVoiceMessagingGroupGetVoicePortalRequest ($x0) {
    return $self->send_query( 'ServiceProviderVoiceMessagingGroupGetVoicePortalRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderVoiceMessagingGroupModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderVoiceMessagingGroupModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderVoiceMessagingGroupModifyVoicePortalBrandingRequest16 ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderVoiceMessagingGroupModifyVoicePortalBrandingRequest16',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method ServiceProviderVoiceMessagingGroupModifyVoicePortalRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderVoiceMessagingGroupModifyVoicePortalRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method SystemVoiceMessageSummaryUpdateGetRequest () {
    return $self->send_query(
        'SystemVoiceMessageSummaryUpdateGetRequest',

    );
}

# ----------------------------------------------------------------------
method SystemVoiceMessageSummaryUpdateModifyRequest (@generic_params) {
    return $self->send_command( 'SystemVoiceMessageSummaryUpdateModifyRequest', @generic_params );
}

# ----------------------------------------------------------------------
method SystemVoiceMessagingGroupGetRequest20 () {
    return $self->send_query(
        'SystemVoiceMessagingGroupGetRequest20',

    );
}

# ----------------------------------------------------------------------
method SystemVoiceMessagingGroupGetVoicePortalMenusRequest20 ($x0) {
    return $self->send_query( 'SystemVoiceMessagingGroupGetVoicePortalMenusRequest20', getDefaultMenuKeys => $x0 );
}

# ----------------------------------------------------------------------
method SystemVoiceMessagingGroupModifyRequest16 (@generic_params) {
    return $self->send_command( 'SystemVoiceMessagingGroupModifyRequest16', @generic_params );
}

# ----------------------------------------------------------------------
method SystemVoiceMessagingGroupModifyVoicePortalMenusRequest19 (@generic_params) {
    return $self->send_query( 'SystemVoiceMessagingGroupModifyVoicePortalMenusRequest19', @generic_params );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserAddAliasListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserVoiceMessagingUserAddAliasListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserDeleteAliasListRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserVoiceMessagingUserDeleteAliasListRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserGetAdvancedVoiceManagementRequest14sp3 ($x0) {
    return $self->send_query( 'UserVoiceMessagingUserGetAdvancedVoiceManagementRequest14sp3', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserGetAliasListRequest ($x0) {
    return $self->send_query( 'UserVoiceMessagingUserGetAliasListRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserGetDistributionListRequest ($x0, $x1) {
    return $self->send_query(
        'UserVoiceMessagingUserGetDistributionListRequest',
        userId => $x0,
        listId => $x1
    );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserGetGreetingRequest20 ($x0) {
    return $self->send_query( 'UserVoiceMessagingUserGetGreetingRequest20', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserGetOutgoingSMDIMWIRequest ($x0) {
    return $self->send_query( 'UserVoiceMessagingUserGetOutgoingSMDIMWIRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserGetVoiceManagementRequest17 ($x0) {
    return $self->send_query( 'UserVoiceMessagingUserGetVoiceManagementRequest17', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserGetVoicePortalRequest20 ($x0) {
    return $self->send_query( 'UserVoiceMessagingUserGetVoicePortalRequest20', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserModifyAdvancedVoiceManagementRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserVoiceMessagingUserModifyAdvancedVoiceManagementRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserModifyDistributionListRequest ($x0, $x1, @generic_params) {
    return $self->send_command(
        'UserVoiceMessagingUserModifyDistributionListRequest',
        userId => $x0,
        listId => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserModifyGreetingRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'UserVoiceMessagingUserModifyGreetingRequest20',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserModifyOutgoingSMDIMWIRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserVoiceMessagingUserModifyOutgoingSMDIMWIRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserModifyVoiceManagementRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserVoiceMessagingUserModifyVoiceManagementRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserVoiceMessagingUserModifyVoicePortalRequest20 ($x0, @generic_params) {
    return $self->send_command(
        'UserVoiceMessagingUserModifyVoicePortalRequest20',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceVoicePortalCalling
##
method UserVoicePortalCallingGetRequest ($x0) {
    return $self->send_query( 'UserVoicePortalCallingGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserVoicePortalCallingModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserVoicePortalCallingModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceVoiceXml
##
method GroupVoiceXmlAddInstanceRequest ($x0, $x1, $x2, $x3, @generic_params) {
    return $self->send_command(
        'GroupVoiceXmlAddInstanceRequest',
        serviceProviderId      => $x0,
        groupId                => $x1,
        serviceUserId          => $x2,
        serviceInstanceProfile => $x3,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupVoiceXmlDeleteInstanceRequest ($x0) {
    return $self->send_command( 'GroupVoiceXmlDeleteInstanceRequest', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupVoiceXmlGetInstanceListRequest ($x0, $x1, @generic_params) {
    return $self->send_query(
        'GroupVoiceXmlGetInstanceListRequest',
        serviceProviderId => $x0,
        groupId           => $x1,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method GroupVoiceXmlGetInstanceRequest19sp1 ($x0) {
    return $self->send_query( 'GroupVoiceXmlGetInstanceRequest19sp1', serviceUserId => $x0 );
}

# ----------------------------------------------------------------------
method GroupVoiceXmlModifyActiveInstanceListRequest (@generic_params) {
    return $self->send_command( 'GroupVoiceXmlModifyActiveInstanceListRequest', @generic_params );
}

# ----------------------------------------------------------------------
method GroupVoiceXmlModifyInstanceRequest ($x0, @generic_params) {
    return $self->send_command(
        'GroupVoiceXmlModifyInstanceRequest',
        serviceUserId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
##
## ServiceZoneCallingRestrictions
##
method ServiceProviderZoneCallingRestrictionsGetRequest ($x0) {
    return $self->send_query( 'ServiceProviderZoneCallingRestrictionsGetRequest', serviceProviderId => $x0 );
}

# ----------------------------------------------------------------------
method ServiceProviderZoneCallingRestrictionsModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'ServiceProviderZoneCallingRestrictionsModifyRequest',
        serviceProviderId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------
method UserZoneCallingRestrictionsGetRequest ($x0) {
    return $self->send_query( 'UserZoneCallingRestrictionsGetRequest', userId => $x0 );
}

# ----------------------------------------------------------------------
method UserZoneCallingRestrictionsModifyRequest ($x0, @generic_params) {
    return $self->send_command(
        'UserZoneCallingRestrictionsModifyRequest',
        userId => $x0,
        @generic_params
    );
}

# ----------------------------------------------------------------------

__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Broadworks::OCIP::Methods - Broadworks OCI-P Methods autogenerated from XML Schema

=head1 VERSION

version 0.08

=head1 AUTHOR

Nigel Metheringham <nigelm@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Nigel Metheringham.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
