use strict;
use warnings;

use Test::More;
use DBI;

use vars qw($test_dsn $test_user $test_password);
use lib 't', '.';
require "lib.pl";

my $dbh = DbiTestConnect($test_dsn, $test_user, $test_password, { PrintError => 0, RaiseError => 1 });
my $have_ssl = eval { $dbh->selectrow_hashref("SHOW VARIABLES WHERE Variable_name = 'have_ssl'") };
$dbh->disconnect();
plan skip_all => 'Server supports SSL connections, cannot test false-positive enforcement' if $have_ssl and $have_ssl->{Value} eq 'YES';

plan tests => 4;

$dbh = DBI->connect($test_dsn, '4yZ73s9qeECdWi', '64heUGwAsVoNqo', { PrintError => 0, RaiseError => 0, mariadb_ssl => 1 });
ok(!defined $dbh, 'DBD::MariaDB refused connection to non-SSL server with mariadb_ssl=1 and incorrect user and password');
is($DBI::err, 2026, 'DBD::MariaDB error message is SSL related') or diag('Error message: ' . ($DBI::errstr || 'unknown'));

$dbh = DBI->connect($test_dsn, '4yZ73s9qeECdWi', '64heUGwAsVoNqo', { PrintError => 0, RaiseError => 0, mariadb_ssl => 1, mariadb_ssl_verify_server_cert => 1, mariadb_ssl_ca_file => "" });
ok(!defined $dbh, 'DBD::MariaDB refused connection to non-SSL server with mariadb_ssl=1, mariadb_ssl_verify_server_cert=1 and incorrect user and password');
is($DBI::err, 2026, 'DBD::MariaDB error message is SSL related') or diag('Error message: ' . ($DBI::errstr || 'unknown'));
