use v6;

use Test;
use MessagePack::Unpacker;

plan 61;

$_ = MessagePack::Unpacker;

is .unpack(buf8.new(0x00)), 0x00, q[positive fixnum];
is .unpack(buf8.new(0x7f)), 0x7f, q[positive fixnum];

is .unpack(buf8.new(0xff)), -0x01, q[negative fixnum];
is .unpack(buf8.new(0xe0)), -0x20, q[negative fixnum];

is .unpack(buf8.new(0xcc, 0x00)), 0x00, q[uint8];
is .unpack(buf8.new(0xcc, 0xff)), 0xff, q[uint8];

is .unpack(buf8.new(0xcd, 0x00, 0x00)), 0x0000, q[uint16];
is .unpack(buf8.new(0xcd, 0x00, 0x01)), 0x0001, q[uint16];
is .unpack(buf8.new(0xcd, 0xff, 0xff)), 0xffff, q[uint16];

is .unpack(buf8.new(0xce, 0x00, 0x00, 0x00, 0x00)), 0x0000_0000, q[uint32];
is .unpack(buf8.new(0xce, 0x00, 0x00, 0x00, 0x01)), 0x0000_0001, q[uint32];
is .unpack(buf8.new(0xce, 0xff, 0xff, 0xff, 0xff)), 0xffff_ffff, q[uint32];

is .unpack(buf8.new((0xcf, 0x00 xx 8      ).flat)), 0x0000_0000_0000_0000, q[uint64];
is .unpack(buf8.new((0xcf, 0x00 xx 7, 0x01).flat)), 0x0000_0000_0000_0001, q[uint64];
is .unpack(buf8.new((0xcf, 0xff xx 8      ).flat)), 0xffff_ffff_ffff_ffff, q[uint64];

is .unpack(buf8.new(0xd0, 0x00)),  0x00, q[int8];
is .unpack(buf8.new(0xd0, 0x7f)),  0x7f, q[int8];
is .unpack(buf8.new(0xd0, 0xff)), -0x01, q[int8];
is .unpack(buf8.new(0xd0, 0x80)), -0x80, q[int8];

is .unpack(buf8.new(0xd1, 0x00, 0x00)),  0x0000, q[int16];
is .unpack(buf8.new(0xd1, 0x7f, 0xff)),  0x7fff, q[int16];
is .unpack(buf8.new(0xd1, 0xff, 0xff)), -0x0001, q[int16];
is .unpack(buf8.new(0xd1, 0x80, 0x00)), -0x8000, q[int16];

is .unpack(buf8.new(0xd2, 0x00, 0x00, 0x00, 0x00)),  0x0000_0000, q[int32];
is .unpack(buf8.new(0xd2, 0x7f, 0xff, 0xff, 0xff)),  0x7fff_ffff, q[int32];
is .unpack(buf8.new(0xd2, 0xff, 0xff, 0xff, 0xff)), -0x0000_0001, q[int32];
is .unpack(buf8.new(0xd2, 0x80, 0x00, 0x00, 0x00)), -0x8000_0000, q[int32];

is .unpack(buf8.new((0xd3,       0x00 xx 8).flat)),  0x0000_0000_0000_0000, q[int64];
is .unpack(buf8.new((0xd3, 0x7f, 0xff xx 7).flat)),  0x7fff_ffff_ffff_ffff, q[int64];
is .unpack(buf8.new((0xd3,       0xff xx 8).flat)), -0x0000_0000_0000_0001, q[int64];
is .unpack(buf8.new((0xd3, 0x80, 0x00 xx 7).flat)), -0x8000_0000_0000_0000, q[int64];

is .unpack(buf8.new(0xc0)), Any,   q[nil];
is .unpack(buf8.new(0xc2)), False, q[false];
is .unpack(buf8.new(0xc3)), True,  q[true];

is .unpack(buf8.new(0xca, 0x00, 0x00, 0x00, 0x00)),  0.0, q[float];
is .unpack(buf8.new(0xca, 0x3f, 0x00, 0x00, 0x00)),  0.5, q[float];
is .unpack(buf8.new(0xca, 0xbf, 0x00, 0x00, 0x00)), -0.5, q[float];

is .unpack(buf8.new(0xcb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00)),  0.0, q[double];
is .unpack(buf8.new(0xcb, 0x3f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00)),  0.5, q[double];
is .unpack(buf8.new(0xcb, 0xbf, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00)), -0.5, q[double];

is .unpack(buf8.new(0xa0                               )), "",       q[fixraw];
is .unpack(buf8.new((0xa3,      "ABC".encode.list).flat)), "ABC",    q[fixfaw];
is .unpack(buf8.new((0xbf, ("A" x 31).encode.list).flat)), "A" x 31, q[fixraw];

is .unpack(buf8.new(0xda, 0x00, 0x00                                   )), "",           q[raw16];
is .unpack(buf8.new((0xda, 0x00, 0x03,          "ABC".encode.list).flat)), "ABC",        q[raw16];
is .unpack(buf8.new((0xda, 0xff, 0xff, ("A" x 0xffff).encode.list).flat)), "A" x 0xffff, q[raw16];

is .unpack(buf8.new(0xdb, 0x00, 0x00, 0x00, 0x00                                     )), "",             q[raw32];
is .unpack(buf8.new((0xdb, 0x00, 0x00, 0x00, 0x03,            "ABC".encode.list).flat)), "ABC",          q[raw32];
is .unpack(buf8.new((0xdb, 0x00, 0x01, 0x00, 0x00, ("A" x 0x1_0000).encode.list).flat)), "A" x 0x1_0000, q[raw32];

is .unpack(buf8.new(0x90                  )), [],        q[fixarray];
is .unpack(buf8.new(0x93, 0x00, 0x01, 0x02)), [0, 1, 2], q[fixarray];

is .unpack(buf8.new(0xdc, 0x00, 0x00                  )), [],        q[array16];
is .unpack(buf8.new(0xdc, 0x00, 0x03, 0x00, 0x01, 0x02)), [0, 1, 2], q[array16];

is .unpack(buf8.new(0xdd, 0x00, 0x00, 0x00, 0x00                  )), [],        q[array32];
is .unpack(buf8.new(0xdd, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01, 0x02)), [0, 1, 2], q[array32];

is .unpack(buf8.new(0x80                        )), {},               q[fixmap];
is .unpack(buf8.new(0x82, 0x00, 0x01, 0x02, 0x03)), {0 => 1, 2 => 3}, q[fixmap];

is .unpack(buf8.new(0xde, 0x00, 0x00                        )), {},               q[map16];
is .unpack(buf8.new(0xde, 0x00, 0x02, 0x00, 0x01, 0x02, 0x03)), {0 => 1, 2 => 3}, q[map16];

is .unpack(buf8.new(0xdf, 0x00, 0x00, 0x00, 0x00                        )), {},               q[map32];
is .unpack(buf8.new(0xdf, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0x02, 0x03)), {0 => 1, 2 => 3}, q[map32];

# vim: ft=perl6 :

