<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::ICMP

SYNOPSIS
========

    use Net::Packet::ICMP :short;

    my $frame = Buf.new([...]);
    my $icmp = ICMP.decode($frame);

    # New ping request:
    my $icmp = ICMP.new(:type(8), :code(0));
    $icmp.id = 0xCAFE;
    $icmp.sequence_number = 0xBEEF;

EXPORTS
=======

    class Net::Packet::ICMP

:short trait adds export:

    constant ICMP ::= Net::Packet::ICMP

DESCRIPTION
===========



class Net::Packet::ICMP
-----------------------

    is Net::Packet::Base

### Attributes

    $.type    is rw is Int
    $.code    is rw is Int
    $.chksum  is rw is Int
      ICMP type/code/checksum field.

    $.hdr     is rw
      Rest-of-header, four bytes fields. Contents vary based on ICMP type and code.
      can either be of builtin type Buf, or C_Buf (from Net::Pcap).

### Methods

    .decode($frame, Net::Packet::Base $parent?) returns Net::Packet::ICMP
      Returns the ICMP packet corresponding to $frame.

    .id() returns Proxy is rw
      Returns a Proxy for the identifier of this packet. Only valid for specific
      combinations of $.type and $.code, as per ICMP specification, else it dies.
      Usage:
        $icmp.id = ...
        my $id = $eth.id.

    .sequence_number() returns Proxy is rw
      Returns a Proxy for the sequence number of this packet. Only valid for specific
      combinations of $.type and $.code, as per ICMP specification, else it dies.
      Usage:
        $icmp.sequence_number = ...
        my $id = $eth.sequence_number.
