<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Pcap::C_Buf;

SYNOPSIS
========

    use NativeCall;
    use Net::Pcap::C_Buf :short :util;

    sub strerror_r(int $err, OpaquePointer $buf, int $len) returns int is native { * };

    my $buf = C_Buf.calloc(256);
    strerror_r(0xFFFFFFFF, $buf, 256);
    say $buf.decode('ascii');

EXPORTS
=======

    class Net::Pcap::C_Buf

:short trait exports:

    constant C_Buf ::= Net::Pcap::C_Buf;

:util trait exports:

    sub C_calloc(...);
    sub C_malloc(...);
    sub C_memcpy(...);
    sub C_free(...);

DESCRIPTION
===========



Constants
---------

    constant uint8p = CArray[uint8];

Subroutines
-----------

    C_calloc(int $nelem, int $elsize) returns OpaquePointer
        is export(:util)
      Interface to the C calloc() function.

    C_malloc(int $size) returns OpaquePointer
        is export(:util)
      Interface to the C malloc() function.

    C_memcpy(OpaquePointer $dst, OpaquePointer $src, int $n) returns OpaquePointer
        is export(:util)
      Interface to the C memcpy() function.

    C_free(OpaquePointer $ptr)
        is export(:util)
      Interface to the C free() function

class Net::Pcap::C_Buf
----------------------

    does Positional

### Attributes

    $.ptr             is OpaquePointer
    $.carray          is uint8p
      Pointer to the C buffer
      $.carray contains this pointer cast to uint8p

    $.elems           is Int
      Number of elements (bytes) in the buffer.

    $.is_owner        is Bool
      Set if the Perl6 garbage collector needs to free the buffer before object destruction.

    $.is_freed  is rw is Bool
      Set if the buffer has been free()'d.

### Methods

    .new(OpaquePointer $ptr, Int $elems, Bool $is_owner = True) returns C_Buf
    .new(Buf $buf) returns C_Buf
      C_Buf constructor.

    .free()
      Free the buffer

    .malloc(int $size) returns C_Buf
      Calls malloc and constructs a C_Buf for the return pointer.

    .calloc(int $size) returns C_Buf
      Calls calloc and constructs a C_Buf for the return pointer.

    .clone() returns C_Buf
      Copies the buffer to a newly allocated area of memory and returns a C_Buf for the new buffer.

    .Buf() returns Buf
      Converts the C buffer to the builtin Buf type.

    .unpack_n(Int $i) returns Int
      Unpacks a 16-bit integer from the buffer, starting at position $i.

    .unpack_N(Int $i) returns Int
      Unpacks a 32-bit integer from the buffer, starting at position $i.

    .unpack(Str $str)
    .unpack(Int $start, Str $str)
      Calls unpack($str) on the buffer.
      If $start is given, start unpacking at position $start.

    .subbuf(Int $from, Int $len = slef.elems) returns C_Buf
      Copy part of the buffer to a newly allocated memory region.

    .decode($encoding = 'utf-8') returns Str
      Converts the buffer to the builtin Buf type and calls .decode($encoding) on it.
      It is C-string aware, so if ($encoding eq 'ascii') it will stop decoding when it
      finds a 0x00 byte.

    .at_pos(Int $pos) returns Int
      Returns the byte at position $pos. C_Buf does Positional so this code is called if C_Buf
      called with brackets like so $buf[1].

    .assign_pos(Int $pos, $assignee)
      Assignes the byte $assignee to position $pos. C_Buf does Positional so this code is called
      if the buffer is called with brackets to assign, like so: $buf[1] = 0;

    .bytes() returns Int
      Returns the number of bytes in the buffer.
