use v6.c;
use Test;
use Game::Sudoku;
use Game::Sudoku::Solver;

my %codes = (
    "003020600900305001001806400008102900700000008006708200002609500800203009005010300" =>
    "483921657967345821251876493548132976729564138136798245372689514814253769695417382",
    "904200007010000000000706500000800090020904060040002000001607000000000030300005702" =>
    "954213687617548923832796541763851294128974365549362178281637459475129836396485712",
    "300200000000107000706030500070009080900020004010800050009040301000702000000008006" =>
    "351286497492157638786934512275469183938521764614873259829645371163792845547318926",
);
for %codes.keys -> $code {
    my $game = solve-puzzle( Game::Sudoku.new( :code($code) ) );
    
    ok $game.complete, "Game is complete";
    ok $game.valid,    "Game is valid";
    ok $game.full,     "Game is full";
    is $game.Str, %codes{$code}, "got expected value";
}

done-testing;
