# -*- perl -*-

use Test::More tests => 5;

BEGIN { use_ok( 'WWW::Marvel' ); }

{
	my $api = WWW::Marvel->new({ public_key => 1234, private_key => 'abcd' });
	is($api->get_public_key, '1234', 'get public key');
	is($api->get_private_key, 'abcd', 'get private key');
}

{
	my $api = WWW::Marvel->new();
	$api->set_public_key(1234);
	$api->set_private_key('abcd');

	is($api->get_public_key, '1234', 'get public key');
	is($api->get_private_key, 'abcd', 'get private key');
}
