/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;

class MlibBinarizeOpImage
extends PointOpImage {
    private double thresh;

    public MlibBinarizeOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, double d) {
        super(renderedImage, MlibBinarizeOpImage.layoutHelper(renderedImage, imageLayout, map), map, true);
        this.thresh = d;
    }

    private static ImageLayout layoutHelper(RenderedImage renderedImage, ImageLayout imageLayout, Map map) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (!ImageUtil.isBinary(sampleModel)) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if ((colorModel = imageLayout2.getColorModel(null)) == null || !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
            imageLayout2.setColorModel(ImageUtil.getCompatibleColorModel(sampleModel, map));
        }
        return imageLayout2;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, raster);
        int n2 = writableRaster.getSampleModel().getDataType() | 0x100 | 0;
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n, false);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2, true);
        switch (mediaLibAccessor.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    Image.Thresh1((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (int[])new int[]{(int)this.thresh - 1}, (int[])new int[]{1}, (int[])new int[]{0});
                    ++n3;
                }
                break;
            }
            case 4: 
            case 5: {
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                mediaLibImage[] mediaLibImageArray3 = mediaLibAccessor2.getMediaLibImages();
                int n4 = 0;
                while (n4 < mediaLibImageArray3.length) {
                    Image.Thresh1_Fp((mediaLibImage)mediaLibImageArray3[n4], (mediaLibImage)mediaLibImageArray[n4], (double[])new double[]{this.thresh}, (double[])new double[]{1.0}, (double[])new double[]{0.0});
                    ++n4;
                }
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

