/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.resources.Errors;

abstract class AbstractUnit<Q extends Quantity<Q>>
implements Unit<Q>,
LenientComparable,
Serializable {
    private static final long serialVersionUID = -5559950920796714303L;
    private final String symbol;
    final transient byte scope;
    final transient short epsg;

    AbstractUnit(String string, byte by, short s) {
        this.symbol = string;
        this.scope = by;
        this.epsg = s;
    }

    final boolean isPrefixable() {
        return (this.scope & 1) != 0;
    }

    @Override
    public final String getSymbol() {
        return this.symbol;
    }

    @Override
    public final String getName() {
        try {
            return UnitFormat.getBundle(Locale.getDefault()).getString(this.symbol);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Override
    public abstract SystemUnit<Q> getSystemUnit();

    @Override
    public abstract Map<SystemUnit<?>, Integer> getBaseUnits();

    abstract Map<SystemUnit<?>, Fraction> getBaseSystemUnits();

    @Override
    public final boolean isCompatible(Unit<?> unit) {
        ArgumentChecks.ensureNonNull("that", unit);
        return this.getDimension().equals(unit.getDimension());
    }

    final String incompatible(Unit<?> unit) {
        return Errors.format((short)66, this, unit);
    }

    @Override
    public final Unit<Q> shift(double d) {
        return this.transform(LinearConverter.offset(d, 1.0));
    }

    @Override
    public final Unit<Q> multiply(double d) {
        double d2 = AbstractUnit.inverse(d);
        if (!Double.isNaN(d2)) {
            return this.divide(d2);
        }
        return this.transform(LinearConverter.scale(d, 1.0));
    }

    @Override
    public final Unit<Q> divide(double d) {
        double d2 = AbstractUnit.inverse(d);
        if (!Double.isNaN(d2)) {
            return this.multiply(d2);
        }
        return this.transform(LinearConverter.scale(1.0, d));
    }

    private static double inverse(double d) {
        double d2;
        double d3;
        if (Math.abs(d) < 1.0 && AbstractUnit.epsilonEquals(d3 = 1.0 / d, d2 = Math.rint(d3))) {
            return d2;
        }
        return Double.NaN;
    }

    static boolean epsilonEquals(double d, double d2) {
        return Math.abs(d - d2) <= Math.scalb(Math.ulp(d), 4);
    }

    @Override
    public final Unit<?> inverse() {
        return this.pow(-1);
    }

    ConventionalUnit<Q>[] related() {
        return null;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (comparisonMode.isIgnoringMetadata()) {
            return true;
        }
        AbstractUnit abstractUnit = (AbstractUnit)object;
        return AbstractUnit.equals(this.epsg, abstractUnit.epsg) && AbstractUnit.equals(this.scope, abstractUnit.scope) && Objects.equals(this.symbol, abstractUnit.symbol);
    }

    private static boolean equals(short s, short s2) {
        return s == 0 || s2 == 0 || s == s2;
    }

    public int hashCode() {
        return 31 * Objects.hashCode(this.symbol);
    }

    @Override
    public final String toString() {
        if (this.symbol != null) {
            return this.symbol;
        }
        return UnitFormat.INSTANCE.format(this);
    }

    static boolean isSymbolChar(int n) {
        return Character.isLetter(n) || Characters.isSubScript(n) || "\u00b0'\u2032\u2019\"\u2033%\u2030-_".indexOf(n) >= 0;
    }

    final Object readResolve() throws ObjectStreamException {
        Object object;
        if (this.symbol != null && Units.initialized && this.equals(object = UnitRegistry.putIfAbsent(this.symbol, this))) {
            return (Unit)object;
        }
        return this;
    }
}

