/*
 Copyright (C) 2016-2017 Alexander Borisov

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

 Author: lex.borisov@gmail.com (Alexander Borisov)
*/

#ifndef MyHTML_MyCSS_PROPERTY_RESOURCES_H
#define MyHTML_MyCSS_PROPERTY_RESOURCES_H
#pragma once

#define MyCSS_PROPERTY_STATIC_INDEX_FOR_SEARCH_SIZE 373
#define MyCSS_PROPERTY_VALUE_STATIC_INDEX_FOR_SEARCH_SIZE 397

static const mycss_property_index_static_entry_t mycss_property_index_static_for_search[] = 
{
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"background-attachment", 21, MyCSS_PROPERTY_TYPE_BACKGROUND_ATTACHMENT, mycss_property_parser_background_attachment, 0, 9},
	{"outline-color", 13, MyCSS_PROPERTY_TYPE_OUTLINE_COLOR, mycss_property_parser_outline_color, 0, 10},
	{"backface-visibility", 19, MyCSS_PROPERTY_TYPE_BACKFACE_VISIBILITY, mycss_property_parser_backface_visibility, 0, 11},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"quotes", 6, MyCSS_PROPERTY_TYPE_QUOTES, mycss_property_parser_quotes, 0, 14},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"border-collapse", 15, MyCSS_PROPERTY_TYPE_BORDER_COLLAPSE, mycss_property_parser_border_collapse, 374, 17},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"ruby-position", 13, MyCSS_PROPERTY_TYPE_RUBY_POSITION, mycss_property_parser_ruby_position, 0, 20},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"opacity", 7, MyCSS_PROPERTY_TYPE_OPACITY, mycss_property_parser_opacity, 0, 22},
	{"height", 6, MyCSS_PROPERTY_TYPE_HEIGHT, mycss_property_parser_height, 0, 23},
	{"fill-opacity", 12, MyCSS_PROPERTY_TYPE_FILL_OPACITY, mycss_property_parser_fill_opacity, 0, 24},
	{"margin-inline-start", 19, MyCSS_PROPERTY_TYPE_MARGIN_INLINE_START, mycss_property_parser_margin_inline_start, 0, 25},
	{"color-rendering", 15, MyCSS_PROPERTY_TYPE_COLOR_RENDERING, mycss_property_parser_color_rendering, 376, 26},
	{"cue-before", 10, MyCSS_PROPERTY_TYPE_CUE_BEFORE, mycss_property_parser_cue_before, 0, 27},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"display", 7, MyCSS_PROPERTY_TYPE_DISPLAY, mycss_property_parser_display, 0, 30},
	{"overflow-y", 10, MyCSS_PROPERTY_TYPE_OVERFLOW_Y, mycss_property_parser_overflow_y, 379, 31},
	{"transform", 9, MyCSS_PROPERTY_TYPE_TRANSFORM, mycss_property_parser_transform, 380, 32},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"text-shadow", 11, MyCSS_PROPERTY_TYPE_TEXT_SHADOW, mycss_property_parser_text_shadow, 0, 34},
	{"transition", 10, MyCSS_PROPERTY_TYPE_TRANSITION, mycss_property_parser_transition, 382, 35},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"offset-after", 12, MyCSS_PROPERTY_TYPE_OFFSET_AFTER, mycss_property_parser_offset_after, 0, 38},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"overflow-x", 10, MyCSS_PROPERTY_TYPE_OVERFLOW_X, mycss_property_parser_overflow_x, 383, 40},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"border-inline-start-width", 25, MyCSS_PROPERTY_TYPE_BORDER_INLINE_START_WIDTH, mycss_property_parser_border_inline_start_width, 0, 42},
	{"background-repeat", 17, MyCSS_PROPERTY_TYPE_BACKGROUND_REPEAT, mycss_property_parser_background_repeat, 0, 43},
	{"border-left-style", 17, MyCSS_PROPERTY_TYPE_BORDER_LEFT_STYLE, mycss_property_parser_border_left_style, 384, 44},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"indent-edge-reset", 17, MyCSS_PROPERTY_TYPE_INDENT_EDGE_RESET, mycss_property_parser_indent_edge_reset, 0, 46},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"flex-direction", 14, MyCSS_PROPERTY_TYPE_FLEX_DIRECTION, mycss_property_parser_flex_direction, 386, 48},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"border-right-color", 18, MyCSS_PROPERTY_TYPE_BORDER_RIGHT_COLOR, mycss_property_parser_border_right_color, 0, 50},
	{"fill", 4, MyCSS_PROPERTY_TYPE_FILL, mycss_property_parser_fill, 387, 51},
	{"text-decoration", 15, MyCSS_PROPERTY_TYPE_TEXT_DECORATION, mycss_property_parser_text_decoration, 388, 52},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"transform-box", 13, MyCSS_PROPERTY_TYPE_TRANSFORM_BOX, mycss_property_parser_transform_box, 389, 56},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"column-span", 11, MyCSS_PROPERTY_TYPE_COLUMN_SPAN, mycss_property_parser_column_span, 391, 58},
	{"wrap-through", 12, MyCSS_PROPERTY_TYPE_WRAP_THROUGH, mycss_property_parser_wrap_through, 392, 59},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"align-content", 13, MyCSS_PROPERTY_TYPE_ALIGN_CONTENT, mycss_property_parser_align_content, 0, 61},
	{"border-bottom-width", 19, MyCSS_PROPERTY_TYPE_BORDER_BOTTOM_WIDTH, mycss_property_parser_border_bottom_width, 0, 62},
	{"margin-block-start", 18, MyCSS_PROPERTY_TYPE_MARGIN_BLOCK_START, mycss_property_parser_margin_block_start, 0, 63},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"nav-up", 6, MyCSS_PROPERTY_TYPE_NAV_UP, mycss_property_parser_nav_up, 0, 67},
	{"border-left-color", 17, MyCSS_PROPERTY_TYPE_BORDER_LEFT_COLOR, mycss_property_parser_border_left_color, 0, 68},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"voice-duration", 14, MyCSS_PROPERTY_TYPE_VOICE_DURATION, mycss_property_parser_voice_duration, 393, 70},
	{"border-bottom-style", 19, MyCSS_PROPERTY_TYPE_BORDER_BOTTOM_STYLE, mycss_property_parser_border_bottom_style, 0, 71},
	{"border-top-width", 16, MyCSS_PROPERTY_TYPE_BORDER_TOP_WIDTH, mycss_property_parser_border_top_width, 0, 72},
	{"ruby-align", 10, MyCSS_PROPERTY_TYPE_RUBY_ALIGN, mycss_property_parser_ruby_align, 394, 73},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"text-size-adjust", 16, MyCSS_PROPERTY_TYPE_TEXT_SIZE_ADJUST, mycss_property_parser_text_size_adjust, 0, 76},
	{"text-decoration-line", 20, MyCSS_PROPERTY_TYPE_TEXT_DECORATION_LINE, mycss_property_parser_text_decoration_line, 0, 77},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"padding-bottom", 14, MyCSS_PROPERTY_TYPE_PADDING_BOTTOM, mycss_property_parser_padding_bottom, 0, 79},
	{"resize", 6, MyCSS_PROPERTY_TYPE_RESIZE, mycss_property_parser_resize, 0, 80},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"text-align-all", 14, MyCSS_PROPERTY_TYPE_TEXT_ALIGN_ALL, mycss_property_parser_text_align_all, 0, 83},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"marker-mid", 10, MyCSS_PROPERTY_TYPE_MARKER_MID, mycss_property_parser_marker_mid, 395, 85},
	{"unicode-bidi", 12, MyCSS_PROPERTY_TYPE_UNICODE_BIDI, mycss_property_parser_unicode_bidi, 396, 86},
	{"scroll-snap-type", 16, MyCSS_PROPERTY_TYPE_SCROLL_SNAP_TYPE, mycss_property_parser_scroll_snap_type, 0, 87},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"position", 8, MyCSS_PROPERTY_TYPE_POSITION, mycss_property_parser_position, 0, 89},
	{"column-width", 12, MyCSS_PROPERTY_TYPE_COLUMN_WIDTH, mycss_property_parser_column_width, 0, 90},
	{"offset-start", 12, MyCSS_PROPERTY_TYPE_OFFSET_START, mycss_property_parser_offset_start, 0, 91},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"user-select", 11, MyCSS_PROPERTY_TYPE_USER_SELECT, mycss_property_parser_user_select, 0, 93},
	{"border-left", 11, MyCSS_PROPERTY_TYPE_BORDER_LEFT, mycss_property_parser_border_left, 0, 94},
	{"box-decoration-break", 20, MyCSS_PROPERTY_TYPE_BOX_DECORATION_BREAK, mycss_property_parser_box_decoration_break, 0, 95},
	{"align-self", 10, MyCSS_PROPERTY_TYPE_ALIGN_SELF, mycss_property_parser_align_self, 398, 96},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"flex", 4, MyCSS_PROPERTY_TYPE_FLEX, mycss_property_parser_flex, 0, 98},
	{"border-top", 10, MyCSS_PROPERTY_TYPE_BORDER_TOP, mycss_property_parser_border_top, 0, 99},
	{"right", 5, MyCSS_PROPERTY_TYPE_RIGHT, mycss_property_parser_right, 401, 100},
	{"font-synthesis", 14, MyCSS_PROPERTY_TYPE_FONT_SYNTHESIS, mycss_property_parser_font_synthesis, 0, 101},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"font-stretch", 12, MyCSS_PROPERTY_TYPE_FONT_STRETCH, mycss_property_parser_font_stretch, 0, 104},
	{"stroke-opacity", 14, MyCSS_PROPERTY_TYPE_STROKE_OPACITY, mycss_property_parser_stroke_opacity, 0, 105},
	{"tab-size", 8, MyCSS_PROPERTY_TYPE_TAB_SIZE, mycss_property_parser_tab_size, 402, 106},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"color", 5, MyCSS_PROPERTY_TYPE_COLOR, mycss_property_parser_color, 403, 108},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"margin-top", 10, MyCSS_PROPERTY_TYPE_MARGIN_TOP, mycss_property_parser_margin_top, 0, 110},
	{"border-bottom", 13, MyCSS_PROPERTY_TYPE_BORDER_BOTTOM, mycss_property_parser_border_bottom, 0, 111},
	{"font-variant-alternates", 23, MyCSS_PROPERTY_TYPE_FONT_VARIANT_ALTERNATES, mycss_property_parser_font_variant_alternates, 0, 112},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"overflow", 8, MyCSS_PROPERTY_TYPE_OVERFLOW, mycss_property_parser_overflow, 0, 114},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"animation-play-state", 20, MyCSS_PROPERTY_TYPE_ANIMATION_PLAY_STATE, mycss_property_parser_animation_play_state, 0, 116},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"column-fill", 11, MyCSS_PROPERTY_TYPE_COLUMN_FILL, mycss_property_parser_column_fill, 405, 118},
	{"cue-after", 9, MyCSS_PROPERTY_TYPE_CUE_AFTER, mycss_property_parser_cue_after, 0, 119},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"word-spacing", 12, MyCSS_PROPERTY_TYPE_WORD_SPACING, mycss_property_parser_word_spacing, 0, 123},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"border-inline-end-style", 23, MyCSS_PROPERTY_TYPE_BORDER_INLINE_END_STYLE, mycss_property_parser_border_inline_end_style, 0, 125},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"outline-width", 13, MyCSS_PROPERTY_TYPE_OUTLINE_WIDTH, mycss_property_parser_outline_width, 0, 127},
	{"shape-rendering", 15, MyCSS_PROPERTY_TYPE_SHAPE_RENDERING, mycss_property_parser_shape_rendering, 0, 128},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"voice-family", 12, MyCSS_PROPERTY_TYPE_VOICE_FAMILY, mycss_property_parser_voice_family, 406, 130},
	{"left", 4, MyCSS_PROPERTY_TYPE_LEFT, mycss_property_parser_left, 0, 131},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"border-bottom-left-radius", 25, MyCSS_PROPERTY_TYPE_BORDER_BOTTOM_LEFT_RADIUS, mycss_property_parser_border_bottom_left_radius, 0, 136},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"word-break", 10, MyCSS_PROPERTY_TYPE_WORD_BREAK, mycss_property_parser_word_break, 0, 138},
	{"contain", 7, MyCSS_PROPERTY_TYPE_CONTAIN, mycss_property_parser_contain, 0, 139},
	{"voice-balance", 13, MyCSS_PROPERTY_TYPE_VOICE_BALANCE, mycss_property_parser_voice_balance, 0, 140},
	{"border-block-end", 16, MyCSS_PROPERTY_TYPE_BORDER_BLOCK_END, mycss_property_parser_border_block_end, 408, 141},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"outline", 7, MyCSS_PROPERTY_TYPE_OUTLINE, mycss_property_parser_outline, 409, 148},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"counter-increment", 17, MyCSS_PROPERTY_TYPE_COUNTER_INCREMENT, mycss_property_parser_counter_increment, 410, 150},
	{"font-feature-settings", 21, MyCSS_PROPERTY_TYPE_FONT_FEATURE_SETTINGS, mycss_property_parser_font_feature_settings, 0, 151},
	{"border-inline-start-style", 25, MyCSS_PROPERTY_TYPE_BORDER_INLINE_START_STYLE, mycss_property_parser_border_inline_start_style, 0, 152},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"direction", 9, MyCSS_PROPERTY_TYPE_DIRECTION, mycss_property_parser_direction, 0, 156},
	{"rest-after", 10, MyCSS_PROPERTY_TYPE_REST_AFTER, mycss_property_parser_rest_after, 0, 157},
	{"cue", 3, MyCSS_PROPERTY_TYPE_CUE, mycss_property_parser_cue, 411, 158},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"stroke-linecap", 14, MyCSS_PROPERTY_TYPE_STROKE_LINECAP, mycss_property_parser_stroke_linecap, 0, 162},
	{"break-before", 12, MyCSS_PROPERTY_TYPE_BREAK_BEFORE, mycss_property_parser_break_before, 413, 163},
	{"transition-timing-function", 26, MyCSS_PROPERTY_TYPE_TRANSITION_TIMING_FUNCTION, mycss_property_parser_transition_timing_function, 0, 164},
	{"list-style", 10, MyCSS_PROPERTY_TYPE_LIST_STYLE, mycss_property_parser_list_style, 0, 165},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"will-change", 11, MyCSS_PROPERTY_TYPE_WILL_CHANGE, mycss_property_parser_will_change, 416, 168},
	{"hyphens", 7, MyCSS_PROPERTY_TYPE_HYPHENS, mycss_property_parser_hyphens, 418, 169},
	{"animation", 9, MyCSS_PROPERTY_TYPE_ANIMATION, mycss_property_parser_animation, 420, 170},
	{"continue", 8, MyCSS_PROPERTY_TYPE_CONTINUE, mycss_property_parser_continue, 422, 171},
	{"line-height", 11, MyCSS_PROPERTY_TYPE_LINE_HEIGHT, mycss_property_parser_line_height, 424, 172},
	{"border-inline-end-width", 23, MyCSS_PROPERTY_TYPE_BORDER_INLINE_END_WIDTH, mycss_property_parser_border_inline_end_width, 0, 173},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"voice-range", 11, MyCSS_PROPERTY_TYPE_VOICE_RANGE, mycss_property_parser_voice_range, 426, 176},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"flex-basis", 10, MyCSS_PROPERTY_TYPE_FLEX_BASIS, mycss_property_parser_flex_basis, 427, 179},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"padding-inline-end", 18, MyCSS_PROPERTY_TYPE_PADDING_INLINE_END, mycss_property_parser_padding_inline_end, 0, 181},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"top", 3, MyCSS_PROPERTY_TYPE_TOP, mycss_property_parser_top, 428, 185},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"text-combine-upright", 20, MyCSS_PROPERTY_TYPE_TEXT_COMBINE_UPRIGHT, mycss_property_parser_text_combine_upright, 0, 188},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"bookmark-state", 14, MyCSS_PROPERTY_TYPE_BOOKMARK_STATE, mycss_property_parser_bookmark_state, 0, 190},
	{"touch-action", 12, MyCSS_PROPERTY_TYPE_TOUCH_ACTION, mycss_property_parser_touch_action, 0, 191},
	{"animation-direction", 19, MyCSS_PROPERTY_TYPE_ANIMATION_DIRECTION, mycss_property_parser_animation_direction, 0, 192},
	{"border-left-width", 17, MyCSS_PROPERTY_TYPE_BORDER_LEFT_WIDTH, mycss_property_parser_border_left_width, 430, 193},
	{"content", 7, MyCSS_PROPERTY_TYPE_CONTENT, mycss_property_parser_content, 431, 194},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"min-width", 9, MyCSS_PROPERTY_TYPE_MIN_WIDTH, mycss_property_parser_min_width, 433, 196},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"perspective-origin", 18, MyCSS_PROPERTY_TYPE_PERSPECTIVE_ORIGIN, mycss_property_parser_perspective_origin, 0, 199},
	{"empty-cells", 11, MyCSS_PROPERTY_TYPE_EMPTY_CELLS, mycss_property_parser_empty_cells, 0, 200},
	{"pause-after", 11, MyCSS_PROPERTY_TYPE_PAUSE_AFTER, mycss_property_parser_pause_after, 0, 201},
	{"font-size-adjust", 16, MyCSS_PROPERTY_TYPE_FONT_SIZE_ADJUST, mycss_property_parser_font_size_adjust, 0, 202},
	{"scroll-snap-align", 17, MyCSS_PROPERTY_TYPE_SCROLL_SNAP_ALIGN, mycss_property_parser_scroll_snap_align, 0, 203},
	{"cursor", 6, MyCSS_PROPERTY_TYPE_CURSOR, mycss_property_parser_cursor, 0, 204},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"rest-before", 11, MyCSS_PROPERTY_TYPE_REST_BEFORE, mycss_property_parser_rest_before, 0, 208},
	{"orphans", 7, MyCSS_PROPERTY_TYPE_ORPHANS, mycss_property_parser_orphans, 0, 209},
	{"text-justify", 12, MyCSS_PROPERTY_TYPE_TEXT_JUSTIFY, mycss_property_parser_text_justify, 435, 210},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"voice-stress", 12, MyCSS_PROPERTY_TYPE_VOICE_STRESS, mycss_property_parser_voice_stress, 0, 213},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"font-size", 9, MyCSS_PROPERTY_TYPE_FONT_SIZE, mycss_property_parser_font_size, 436, 215},
	{"border-bottom-right-radius", 26, MyCSS_PROPERTY_TYPE_BORDER_BOTTOM_RIGHT_RADIUS, mycss_property_parser_border_bottom_right_radius, 0, 216},
	{"background-image", 16, MyCSS_PROPERTY_TYPE_BACKGROUND_IMAGE, mycss_property_parser_background_image, 439, 217},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"scroll-padding", 14, MyCSS_PROPERTY_TYPE_SCROLL_PADDING, mycss_property_parser_scroll_padding, 0, 219},
	{"word-wrap", 9, MyCSS_PROPERTY_TYPE_WORD_WRAP, mycss_property_parser_word_wrap, 440, 220},
	{"border-block-start", 18, MyCSS_PROPERTY_TYPE_BORDER_BLOCK_START, mycss_property_parser_border_block_start, 0, 221},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"perspective", 11, MyCSS_PROPERTY_TYPE_PERSPECTIVE, mycss_property_parser_perspective, 0, 224},
	{"text-emphasis-position", 22, MyCSS_PROPERTY_TYPE_TEXT_EMPHASIS_POSITION, mycss_property_parser_text_emphasis_position, 0, 225},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"float", 5, MyCSS_PROPERTY_TYPE_FLOAT, mycss_property_parser_float, 0, 227},
	{"text-emphasis-color", 19, MyCSS_PROPERTY_TYPE_TEXT_EMPHASIS_COLOR, mycss_property_parser_text_emphasis_color, 0, 228},
	{"font-variant-caps", 17, MyCSS_PROPERTY_TYPE_FONT_VARIANT_CAPS, mycss_property_parser_font_variant_caps, 0, 229},
	{"text-decoration-style", 21, MyCSS_PROPERTY_TYPE_TEXT_DECORATION_STYLE, mycss_property_parser_text_decoration_style, 0, 230},
	{"box-sizing", 10, MyCSS_PROPERTY_TYPE_BOX_SIZING, mycss_property_parser_box_sizing, 0, 231},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"text-decoration-skip", 20, MyCSS_PROPERTY_TYPE_TEXT_DECORATION_SKIP, mycss_property_parser_text_decoration_skip, 441, 233},
	{"order", 5, MyCSS_PROPERTY_TYPE_ORDER, mycss_property_parser_order, 442, 234},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"pause", 5, MyCSS_PROPERTY_TYPE_PAUSE, mycss_property_parser_pause, 0, 238},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"string-set", 10, MyCSS_PROPERTY_TYPE_STRING_SET, mycss_property_parser_string_set, 0, 240},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"speak-as", 8, MyCSS_PROPERTY_TYPE_SPEAK_AS, mycss_property_parser_speak_as, 443, 242},
	{"border-inline-end", 17, MyCSS_PROPERTY_TYPE_BORDER_INLINE_END, mycss_property_parser_border_inline_end, 0, 243},
	{"border-right-style", 18, MyCSS_PROPERTY_TYPE_BORDER_RIGHT_STYLE, mycss_property_parser_border_right_style, 444, 244},
	{"appearance", 10, MyCSS_PROPERTY_TYPE_APPEARANCE, mycss_property_parser_appearance, 445, 245},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"columns", 7, MyCSS_PROPERTY_TYPE_COLUMNS, mycss_property_parser_columns, 447, 247},
	{"marker-side", 11, MyCSS_PROPERTY_TYPE_MARKER_SIDE, mycss_property_parser_marker_side, 0, 248},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"writing-mode", 12, MyCSS_PROPERTY_TYPE_WRITING_MODE, mycss_property_parser_writing_mode, 448, 251},
	{"nav-left", 8, MyCSS_PROPERTY_TYPE_NAV_LEFT, mycss_property_parser_nav_left, 0, 252},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"caption-side", 12, MyCSS_PROPERTY_TYPE_CAPTION_SIDE, mycss_property_parser_caption_side, 0, 256},
	{"wrap-flow", 9, MyCSS_PROPERTY_TYPE_WRAP_FLOW, mycss_property_parser_wrap_flow, 449, 257},
	{"font-variant-position", 21, MyCSS_PROPERTY_TYPE_FONT_VARIANT_POSITION, mycss_property_parser_font_variant_position, 0, 258},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"border", 6, MyCSS_PROPERTY_TYPE_BORDER, mycss_property_parser_border, 0, 266},
	{"stroke-linejoin", 15, MyCSS_PROPERTY_TYPE_STROKE_LINEJOIN, mycss_property_parser_stroke_linejoin, 0, 267},
	{"animation-name", 14, MyCSS_PROPERTY_TYPE_ANIMATION_NAME, mycss_property_parser_animation_name, 0, 268},
	{"column-rule-style", 17, MyCSS_PROPERTY_TYPE_COLUMN_RULE_STYLE, mycss_property_parser_column_rule_style, 450, 269},
	{"presentation-level", 18, MyCSS_PROPERTY_TYPE_PRESENTATION_LEVEL, mycss_property_parser_presentation_level, 0, 270},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"border-right", 12, MyCSS_PROPERTY_TYPE_BORDER_RIGHT, mycss_property_parser_border_right, 0, 272},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"outline-style", 13, MyCSS_PROPERTY_TYPE_OUTLINE_STYLE, mycss_property_parser_outline_style, 452, 274},
	{"background", 10, MyCSS_PROPERTY_TYPE_BACKGROUND, mycss_property_parser_background, 453, 275},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"z-index", 7, MyCSS_PROPERTY_TYPE_Z_INDEX, mycss_property_parser_z_index, 0, 279},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"stroke-width", 12, MyCSS_PROPERTY_TYPE_STROKE_WIDTH, mycss_property_parser_stroke_width, 0, 289},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"margin-right", 12, MyCSS_PROPERTY_TYPE_MARGIN_RIGHT, mycss_property_parser_margin_right, 454, 291},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"margin-inline-end", 17, MyCSS_PROPERTY_TYPE_MARGIN_INLINE_END, mycss_property_parser_margin_inline_end, 0, 293},
	{"border-block-start-width", 24, MyCSS_PROPERTY_TYPE_BORDER_BLOCK_START_WIDTH, mycss_property_parser_border_block_start_width, 0, 294},
	{"visibility", 10, MyCSS_PROPERTY_TYPE_VISIBILITY, mycss_property_parser_visibility, 455, 295},
	{"padding-block-start", 19, MyCSS_PROPERTY_TYPE_PADDING_BLOCK_START, mycss_property_parser_padding_block_start, 0, 296},
	{"text-emphasis-style", 19, MyCSS_PROPERTY_TYPE_TEXT_EMPHASIS_STYLE, mycss_property_parser_text_emphasis_style, 456, 297},
	{"region-fragment", 15, MyCSS_PROPERTY_TYPE_REGION_FRAGMENT, mycss_property_parser_region_fragment, 457, 298},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"padding-right", 13, MyCSS_PROPERTY_TYPE_PADDING_RIGHT, mycss_property_parser_padding_right, 0, 301},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"text-underline-position", 23, MyCSS_PROPERTY_TYPE_TEXT_UNDERLINE_POSITION, mycss_property_parser_text_underline_position, 0, 303},
	{"rest", 4, MyCSS_PROPERTY_TYPE_REST, mycss_property_parser_rest, 458, 304},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"text-indent", 11, MyCSS_PROPERTY_TYPE_TEXT_INDENT, mycss_property_parser_text_indent, 0, 309},
	{"bottom", 6, MyCSS_PROPERTY_TYPE_BOTTOM, mycss_property_parser_bottom, 0, 310},
	{"caret-color", 11, MyCSS_PROPERTY_TYPE_CARET_COLOR, mycss_property_parser_caret_color, 460, 311},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"stroke", 6, MyCSS_PROPERTY_TYPE_STROKE, mycss_property_parser_stroke, 0, 313},
	{"border-right-width", 18, MyCSS_PROPERTY_TYPE_BORDER_RIGHT_WIDTH, mycss_property_parser_border_right_width, 461, 314},
	{"border-block-start-color", 24, MyCSS_PROPERTY_TYPE_BORDER_BLOCK_START_COLOR, mycss_property_parser_border_block_start_color, 0, 315},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"font-variant-ligatures", 22, MyCSS_PROPERTY_TYPE_FONT_VARIANT_LIGATURES, mycss_property_parser_font_variant_ligatures, 462, 318},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"flex-shrink", 11, MyCSS_PROPERTY_TYPE_FLEX_SHRINK, mycss_property_parser_flex_shrink, 0, 322},
	{"border-spacing", 14, MyCSS_PROPERTY_TYPE_BORDER_SPACING, mycss_property_parser_border_spacing, 463, 323},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"margin", 6, MyCSS_PROPERTY_TYPE_MARGIN, mycss_property_parser_margin, 464, 325},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"flex-grow", 9, MyCSS_PROPERTY_TYPE_FLEX_GROW, mycss_property_parser_flex_grow, 465, 327},
	{"caret-shape", 11, MyCSS_PROPERTY_TYPE_CARET_SHAPE, mycss_property_parser_caret_shape, 466, 328},
	{"margin-left", 11, MyCSS_PROPERTY_TYPE_MARGIN_LEFT, mycss_property_parser_margin_left, 0, 329},
	{"marker", 6, MyCSS_PROPERTY_TYPE_MARKER, mycss_property_parser_marker, 467, 330},
	{"font", 4, MyCSS_PROPERTY_TYPE_FONT, mycss_property_parser_font, 0, 331},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"stroke-dasharray", 16, MyCSS_PROPERTY_TYPE_STROKE_DASHARRAY, mycss_property_parser_stroke_dasharray, 468, 333},
	{"border-width", 12, MyCSS_PROPERTY_TYPE_BORDER_WIDTH, mycss_property_parser_border_width, 0, 334},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"width", 5, MyCSS_PROPERTY_TYPE_WIDTH, mycss_property_parser_width, 0, 336},
	{"table-layout", 12, MyCSS_PROPERTY_TYPE_TABLE_LAYOUT, mycss_property_parser_table_layout, 0, 337},
	{"list-style-image", 16, MyCSS_PROPERTY_TYPE_LIST_STYLE_IMAGE, mycss_property_parser_list_style_image, 0, 338},
	{"animation-duration", 18, MyCSS_PROPERTY_TYPE_ANIMATION_DURATION, mycss_property_parser_animation_duration, 0, 339},
	{"voice-pitch", 11, MyCSS_PROPERTY_TYPE_VOICE_PITCH, mycss_property_parser_voice_pitch, 0, 340},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"image-rendering", 15, MyCSS_PROPERTY_TYPE_IMAGE_RENDERING, mycss_property_parser_image_rendering, 0, 344},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"pause-before", 12, MyCSS_PROPERTY_TYPE_PAUSE_BEFORE, mycss_property_parser_pause_before, 0, 346},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"padding-top", 11, MyCSS_PROPERTY_TYPE_PADDING_TOP, mycss_property_parser_padding_top, 0, 348},
	{"font-weight", 11, MyCSS_PROPERTY_TYPE_FONT_WEIGHT, mycss_property_parser_font_weight, 469, 349},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"border-block-end-color", 22, MyCSS_PROPERTY_TYPE_BORDER_BLOCK_END_COLOR, mycss_property_parser_border_block_end_color, 0, 351},
	{"caret", 5, MyCSS_PROPERTY_TYPE_CARET, mycss_property_parser_caret, 0, 352},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"speak", 5, MyCSS_PROPERTY_TYPE_SPEAK, mycss_property_parser_speak, 0, 354},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"align-items", 11, MyCSS_PROPERTY_TYPE_ALIGN_ITEMS, mycss_property_parser_align_items, 0, 362},
	{"shape-margin", 12, MyCSS_PROPERTY_TYPE_SHAPE_MARGIN, mycss_property_parser_shape_margin, 471, 363},
	{"font-family", 11, MyCSS_PROPERTY_TYPE_FONT_FAMILY, mycss_property_parser_font_family, 472, 364},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"min-height", 10, MyCSS_PROPERTY_TYPE_MIN_HEIGHT, mycss_property_parser_min_height, 474, 367},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"stroke-miterlimit", 17, MyCSS_PROPERTY_TYPE_STROKE_MITERLIMIT, mycss_property_parser_stroke_miterlimit, 475, 370},
	{NULL, 0, MyCSS_PROPERTY_TYPE_UNDEF, NULL, 0, 0},
	{"font-kerning", 12, MyCSS_PROPERTY_TYPE_FONT_KERNING, mycss_property_parser_font_kerning, 0, 372},
	{"animation-delay", 15, MyCSS_PROPERTY_TYPE_ANIMATION_DELAY, mycss_property_parser_animation_delay, 0, 373},
	{"background-size", 15, MyCSS_PROPERTY_TYPE_BACKGROUND_SIZE, mycss_property_parser_background_size, 375, 374},
	{"animation-fill-mode", 19, MyCSS_PROPERTY_TYPE_ANIMATION_FILL_MODE, mycss_property_parser_animation_fill_mode, 0, 375},
	{"border-inline-start", 19, MyCSS_PROPERTY_TYPE_BORDER_INLINE_START, mycss_property_parser_border_inline_start, 377, 376},
	{"border-image-outset", 19, MyCSS_PROPERTY_TYPE_BORDER_IMAGE_OUTSET, mycss_property_parser_border_image_outset, 378, 377},
	{"border-image-repeat", 19, MyCSS_PROPERTY_TYPE_BORDER_IMAGE_REPEAT, mycss_property_parser_border_image_repeat, 0, 378},
	{"transition-delay", 16, MyCSS_PROPERTY_TYPE_TRANSITION_DELAY, mycss_property_parser_transition_delay, 0, 379},
	{"margin-bottom", 13, MyCSS_PROPERTY_TYPE_MARGIN_BOTTOM, mycss_property_parser_margin_bottom, 381, 380},
	{"border-bottom-color", 19, MyCSS_PROPERTY_TYPE_BORDER_BOTTOM_COLOR, mycss_property_parser_border_bottom_color, 0, 381},
	{"text-align", 10, MyCSS_PROPERTY_TYPE_TEXT_ALIGN, mycss_property_parser_text_align, 0, 382},
	{"text-overflow", 13, MyCSS_PROPERTY_TYPE_TEXT_OVERFLOW, mycss_property_parser_text_overflow, 0, 383},
	{"background-position", 19, MyCSS_PROPERTY_TYPE_BACKGROUND_POSITION, mycss_property_parser_background_position, 385, 384},
	{"color-interpolation-filters", 27, MyCSS_PROPERTY_TYPE_COLOR_INTERPOLATION_FILTERS, mycss_property_parser_color_interpolation_filters, 0, 385},
	{"text-align-last", 15, MyCSS_PROPERTY_TYPE_TEXT_ALIGN_LAST, mycss_property_parser_text_align_last, 0, 386},
	{"widows", 6, MyCSS_PROPERTY_TYPE_WIDOWS, mycss_property_parser_widows, 0, 387},
	{"border-block-end-width", 22, MyCSS_PROPERTY_TYPE_BORDER_BLOCK_END_WIDTH, mycss_property_parser_border_block_end_width, 0, 388},
	{"list-style-position", 19, MyCSS_PROPERTY_TYPE_LIST_STYLE_POSITION, mycss_property_parser_list_style_position, 390, 389},
	{"animation-timing-function", 25, MyCSS_PROPERTY_TYPE_ANIMATION_TIMING_FUNCTION, mycss_property_parser_animation_timing_function, 0, 390},
	{"transform-style", 15, MyCSS_PROPERTY_TYPE_TRANSFORM_STYLE, mycss_property_parser_transform_style, 0, 391},
	{"animation-iteration-count", 25, MyCSS_PROPERTY_TYPE_ANIMATION_ITERATION_COUNT, mycss_property_parser_animation_iteration_count, 0, 392},
	{"vertical-align", 14, MyCSS_PROPERTY_TYPE_VERTICAL_ALIGN, mycss_property_parser_vertical_align, 0, 393},
	{"font-style", 10, MyCSS_PROPERTY_TYPE_FONT_STYLE, mycss_property_parser_font_style, 0, 394},
	{"marker-end", 10, MyCSS_PROPERTY_TYPE_MARKER_END, mycss_property_parser_marker_end, 0, 395},
	{"background-color", 16, MyCSS_PROPERTY_TYPE_BACKGROUND_COLOR, mycss_property_parser_background_color, 397, 396},
	{"border-top-color", 16, MyCSS_PROPERTY_TYPE_BORDER_TOP_COLOR, mycss_property_parser_border_top_color, 0, 397},
	{"bookmark-level", 14, MyCSS_PROPERTY_TYPE_BOOKMARK_LEVEL, mycss_property_parser_bookmark_level, 399, 398},
	{"bookmark-label", 14, MyCSS_PROPERTY_TYPE_BOOKMARK_LABEL, mycss_property_parser_bookmark_label, 400, 399},
	{"column-rule-width", 17, MyCSS_PROPERTY_TYPE_COLUMN_RULE_WIDTH, mycss_property_parser_column_rule_width, 0, 400},
	{"column-gap", 10, MyCSS_PROPERTY_TYPE_COLUMN_GAP, mycss_property_parser_column_gap, 0, 401},
	{"outline-offset", 14, MyCSS_PROPERTY_TYPE_OUTLINE_OFFSET, mycss_property_parser_outline_offset, 0, 402},
	{"clear", 5, MyCSS_PROPERTY_TYPE_CLEAR, mycss_property_parser_clear, 404, 403},
	{"overflow-wrap", 13, MyCSS_PROPERTY_TYPE_OVERFLOW_WRAP, mycss_property_parser_overflow_wrap, 0, 404},
	{"background-origin", 17, MyCSS_PROPERTY_TYPE_BACKGROUND_ORIGIN, mycss_property_parser_background_origin, 0, 405},
	{"text-orientation", 16, MyCSS_PROPERTY_TYPE_TEXT_ORIENTATION, mycss_property_parser_text_orientation, 407, 406},
	{"transform-origin", 16, MyCSS_PROPERTY_TYPE_TRANSFORM_ORIGIN, mycss_property_parser_transform_origin, 0, 407},
	{"column-rule-color", 17, MyCSS_PROPERTY_TYPE_COLUMN_RULE_COLOR, mycss_property_parser_column_rule_color, 0, 408},
	{"background-clip", 15, MyCSS_PROPERTY_TYPE_BACKGROUND_CLIP, mycss_property_parser_background_clip, 0, 409},
	{"glyph-orientation-vertical", 26, MyCSS_PROPERTY_TYPE_GLYPH_ORIENTATION_VERTICAL, mycss_property_parser_glyph_orientation_vertical, 0, 410},
	{"voice-volume", 12, MyCSS_PROPERTY_TYPE_VOICE_VOLUME, mycss_property_parser_voice_volume, 412, 411},
	{"border-color", 12, MyCSS_PROPERTY_TYPE_BORDER_COLOR, mycss_property_parser_border_color, 0, 412},
	{"break-inside", 12, MyCSS_PROPERTY_TYPE_BREAK_INSIDE, mycss_property_parser_break_inside, 414, 413},
	{"border-style", 12, MyCSS_PROPERTY_TYPE_BORDER_STYLE, mycss_property_parser_border_style, 415, 414},
	{"border-image", 12, MyCSS_PROPERTY_TYPE_BORDER_IMAGE, mycss_property_parser_border_image, 0, 415},
	{"white-space", 11, MyCSS_PROPERTY_TYPE_WHITE_SPACE, mycss_property_parser_white_space, 417, 416},
	{"font-variant-numeric", 20, MyCSS_PROPERTY_TYPE_FONT_VARIANT_NUMERIC, mycss_property_parser_font_variant_numeric, 0, 417},
	{"text-rendering", 14, MyCSS_PROPERTY_TYPE_TEXT_RENDERING, mycss_property_parser_text_rendering, 419, 418},
	{"inline-size-step", 16, MyCSS_PROPERTY_TYPE_INLINE_SIZE_STEP, mycss_property_parser_inline_size_step, 0, 419},
	{"max-lines", 9, MyCSS_PROPERTY_TYPE_MAX_LINES, mycss_property_parser_max_lines, 421, 420},
	{"shape-image-threshold", 21, MyCSS_PROPERTY_TYPE_SHAPE_IMAGE_THRESHOLD, mycss_property_parser_shape_image_threshold, 0, 421},
	{"padding-block-end", 17, MyCSS_PROPERTY_TYPE_PADDING_BLOCK_END, mycss_property_parser_padding_block_end, 423, 422},
	{"scroll-snap-margin", 18, MyCSS_PROPERTY_TYPE_SCROLL_SNAP_MARGIN, mycss_property_parser_scroll_snap_margin, 0, 423},
	{"column-count", 12, MyCSS_PROPERTY_TYPE_COLUMN_COUNT, mycss_property_parser_column_count, 425, 424},
	{"color-adjust", 12, MyCSS_PROPERTY_TYPE_COLOR_ADJUST, mycss_property_parser_color_adjust, 0, 425},
	{"break-after", 11, MyCSS_PROPERTY_TYPE_BREAK_AFTER, mycss_property_parser_break_after, 0, 426},
	{"justify-content", 15, MyCSS_PROPERTY_TYPE_JUSTIFY_CONTENT, mycss_property_parser_justify_content, 0, 427},
	{"padding", 7, MyCSS_PROPERTY_TYPE_PADDING, mycss_property_parser_padding, 429, 428},
	{"scroll-snap-stop", 16, MyCSS_PROPERTY_TYPE_SCROLL_SNAP_STOP, mycss_property_parser_scroll_snap_stop, 0, 429},
	{"text-decoration-color", 21, MyCSS_PROPERTY_TYPE_TEXT_DECORATION_COLOR, mycss_property_parser_text_decoration_color, 0, 430},
	{"nav-down", 8, MyCSS_PROPERTY_TYPE_NAV_DOWN, mycss_property_parser_nav_down, 432, 431},
	{"voice-rate", 10, MyCSS_PROPERTY_TYPE_VOICE_RATE, mycss_property_parser_voice_rate, 0, 432},
	{"max-width", 9, MyCSS_PROPERTY_TYPE_MAX_WIDTH, mycss_property_parser_max_width, 434, 433},
	{"letter-spacing", 14, MyCSS_PROPERTY_TYPE_LETTER_SPACING, mycss_property_parser_letter_spacing, 0, 434},
	{"margin-block-end", 16, MyCSS_PROPERTY_TYPE_MARGIN_BLOCK_END, mycss_property_parser_margin_block_end, 0, 435},
	{"fill-rule", 9, MyCSS_PROPERTY_TYPE_FILL_RULE, mycss_property_parser_fill_rule, 437, 436},
	{"box-suppress", 12, MyCSS_PROPERTY_TYPE_BOX_SUPPRESS, mycss_property_parser_box_suppress, 438, 437},
	{"text-transform", 14, MyCSS_PROPERTY_TYPE_TEXT_TRANSFORM, mycss_property_parser_text_transform, 0, 438},
	{"border-top-style", 16, MyCSS_PROPERTY_TYPE_BORDER_TOP_STYLE, mycss_property_parser_border_top_style, 0, 439},
	{"offset-end", 10, MyCSS_PROPERTY_TYPE_OFFSET_END, mycss_property_parser_offset_end, 0, 440},
	{"padding-inline-start", 20, MyCSS_PROPERTY_TYPE_PADDING_INLINE_START, mycss_property_parser_padding_inline_start, 0, 441},
	{"font-language-override", 22, MyCSS_PROPERTY_TYPE_FONT_LANGUAGE_OVERRIDE, mycss_property_parser_font_language_override, 0, 442},
	{"flex-wrap", 9, MyCSS_PROPERTY_TYPE_FLEX_WRAP, mycss_property_parser_flex_wrap, 0, 443},
	{"border-image-slice", 18, MyCSS_PROPERTY_TYPE_BORDER_IMAGE_SLICE, mycss_property_parser_border_image_slice, 0, 444},
	{"box-shadow", 10, MyCSS_PROPERTY_TYPE_BOX_SHADOW, mycss_property_parser_box_shadow, 446, 445},
	{"font-variant", 12, MyCSS_PROPERTY_TYPE_FONT_VARIANT, mycss_property_parser_font_variant, 0, 446},
	{"list-style-type", 15, MyCSS_PROPERTY_TYPE_LIST_STYLE_TYPE, mycss_property_parser_list_style_type, 0, 447},
	{"float-displace", 14, MyCSS_PROPERTY_TYPE_FLOAT_DISPLACE, mycss_property_parser_float_displace, 0, 448},
	{"ruby-merge", 10, MyCSS_PROPERTY_TYPE_RUBY_MERGE, mycss_property_parser_ruby_merge, 0, 449},
	{"color-interpolation", 19, MyCSS_PROPERTY_TYPE_COLOR_INTERPOLATION, mycss_property_parser_color_interpolation, 451, 450},
	{"border-top-left-radius", 22, MyCSS_PROPERTY_TYPE_BORDER_TOP_LEFT_RADIUS, mycss_property_parser_border_top_left_radius, 0, 451},
	{"offset-before", 13, MyCSS_PROPERTY_TYPE_OFFSET_BEFORE, mycss_property_parser_offset_before, 0, 452},
	{"hanging-punctuation", 19, MyCSS_PROPERTY_TYPE_HANGING_PUNCTUATION, mycss_property_parser_hanging_punctuation, 0, 453},
	{"marker-start", 12, MyCSS_PROPERTY_TYPE_MARKER_START, mycss_property_parser_marker_start, 0, 454},
	{"border-radius", 13, MyCSS_PROPERTY_TYPE_BORDER_RADIUS, mycss_property_parser_border_radius, 0, 455},
	{"border-inline-start-color", 25, MyCSS_PROPERTY_TYPE_BORDER_INLINE_START_COLOR, mycss_property_parser_border_inline_start_color, 0, 456},
	{"border-block-end-style", 22, MyCSS_PROPERTY_TYPE_BORDER_BLOCK_END_STYLE, mycss_property_parser_border_block_end_style, 0, 457},
	{"line-break", 10, MyCSS_PROPERTY_TYPE_LINE_BREAK, mycss_property_parser_line_break, 459, 458},
	{"shape-outside", 13, MyCSS_PROPERTY_TYPE_SHAPE_OUTSIDE, mycss_property_parser_shape_outside, 0, 459},
	{"clear-after", 11, MyCSS_PROPERTY_TYPE_CLEAR_AFTER, mycss_property_parser_clear_after, 0, 460},
	{"border-image-width", 18, MyCSS_PROPERTY_TYPE_BORDER_IMAGE_WIDTH, mycss_property_parser_border_image_width, 0, 461},
	{"font-variant-east-asian", 23, MyCSS_PROPERTY_TYPE_FONT_VARIANT_EAST_ASIAN, mycss_property_parser_font_variant_east_asian, 0, 462},
	{"line-height-step", 16, MyCSS_PROPERTY_TYPE_LINE_HEIGHT_STEP, mycss_property_parser_line_height_step, 0, 463},
	{"border-block-start-style", 24, MyCSS_PROPERTY_TYPE_BORDER_BLOCK_START_STYLE, mycss_property_parser_border_block_start_style, 0, 464},
	{"flex-flow", 9, MyCSS_PROPERTY_TYPE_FLEX_FLOW, mycss_property_parser_flex_flow, 0, 465},
	{"column-rule", 11, MyCSS_PROPERTY_TYPE_COLUMN_RULE, mycss_property_parser_column_rule, 0, 466},
	{"nav-right", 9, MyCSS_PROPERTY_TYPE_NAV_RIGHT, mycss_property_parser_nav_right, 0, 467},
	{"border-inline-end-color", 23, MyCSS_PROPERTY_TYPE_BORDER_INLINE_END_COLOR, mycss_property_parser_border_inline_end_color, 0, 468},
	{"text-emphasis", 13, MyCSS_PROPERTY_TYPE_TEXT_EMPHASIS, mycss_property_parser_text_emphasis, 470, 469},
	{"border-top-right-radius", 23, MyCSS_PROPERTY_TYPE_BORDER_TOP_RIGHT_RADIUS, mycss_property_parser_border_top_right_radius, 0, 470},
	{"transition-property", 19, MyCSS_PROPERTY_TYPE_TRANSITION_PROPERTY, mycss_property_parser_transition_property, 0, 471},
	{"padding-left", 12, MyCSS_PROPERTY_TYPE_PADDING_LEFT, mycss_property_parser_padding_left, 473, 472},
	{"transition-duration", 19, MyCSS_PROPERTY_TYPE_TRANSITION_DURATION, mycss_property_parser_transition_duration, 0, 473},
	{"max-height", 10, MyCSS_PROPERTY_TYPE_MAX_HEIGHT, mycss_property_parser_max_height, 0, 474},
	{"stroke-dashoffset", 17, MyCSS_PROPERTY_TYPE_STROKE_DASHOFFSET, mycss_property_parser_stroke_dashoffset, 0, 475},
};

static const mycss_property_value_index_static_entry_t mycss_property_value_index_static_for_search[] = 
{
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"reduced", 7, 0x010d, 0, 4},
	{"start", 5, 0x0146, 0, 5},
	{"ridge", 5, 0x0114, 398, 6},
	{"contain", 7, 0x0044, 399, 7},
	{"first", 5, 0x0073, 401, 8},
	{"relative", 8, 0x010f, 404, 9},
	{"open", 4, 0x00ea, 405, 10},
	{"row-resize", 10, 0x011a, 406, 11},
	{"same", 4, 0x0124, 407, 12},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"flex-start", 10, 0x007a, 409, 15},
	{"ltr", 3, 0x00be, 410, 16},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"x-weak", 6, 0x018c, 412, 23},
	{"table-header-group", 18, 0x015a, 415, 24},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"unse", 4, 0x016e, 0, 26},
	{"block", 5, 0x0026, 417, 27},
	{"x-strong", 8, 0x018b, 0, 28},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"linear", 6, 0x00b2, 421, 31},
	{"wavy", 4, 0x017a, 0, 32},
	{"jis90", 5, 0x00a6, 423, 33},
	{"wait", 4, 0x0179, 0, 34},
	{"jis83", 5, 0x00a5, 425, 35},
	{"lighter", 7, 0x00b0, 0, 36},
	{"ease-out", 8, 0x0061, 426, 37},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"alternate", 9, 0x0015, 427, 40},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"italic", 6, 0x00a2, 0, 42},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"vertical-rl", 11, 0x0175, 0, 44},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"super", 5, 0x0151, 0, 46},
	{"context-menu", 12, 0x004a, 428, 47},
	{"low", 3, 0x00bc, 429, 48},
	{"increment", 9, 0x0090, 431, 49},
	{"small-caps", 10, 0x013a, 432, 50},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"pointer", 7, 0x0102, 0, 52},
	{"sideways-rl", 11, 0x0131, 433, 53},
	{"dotted", 6, 0x005a, 434, 54},
	{"200", 3, 0x0004, 0, 55},
	{"currentcolor", 12, 0x0050, 0, 56},
	{"clear", 5, 0x0039, 435, 57},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"justify", 7, 0x00a7, 437, 61},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"filled", 6, 0x0071, 0, 63},
	{"smaller", 7, 0x0139, 438, 64},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"all", 3, 0x0010, 439, 66},
	{"avoid", 5, 0x001a, 0, 67},
	{"content-box", 11, 0x0047, 0, 68},
	{"extra-expanded", 14, 0x006c, 0, 69},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"top", 3, 0x0164, 440, 71},
	{"zoom-out", 8, 0x018f, 0, 72},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"match-parent", 12, 0x00c3, 0, 75},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"nowrap", 6, 0x00d7, 442, 79},
	{"justify-all", 11, 0x00a8, 0, 80},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"embed", 5, 0x0065, 443, 82},
	{"-length", 7, 0x019a, 0, 83},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"flat", 4, 0x0077, 444, 86},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"border-box", 10, 0x002a, 445, 89},
	{"500", 3, 0x0007, 446, 90},
	{"left", 4, 0x00ae, 450, 91},
	{"no-drop", 7, 0x00dd, 0, 92},
	{"xx-large", 8, 0x0181, 453, 93},
	{"force-end", 9, 0x007d, 0, 94},
	{"content-edge", 12, 0x0048, 0, 95},
	{"root", 4, 0x0117, 0, 96},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"discretionary-ligatures", 23, 0x0058, 0, 99},
	{"sideways-lr", 11, 0x0130, 0, 100},
	{"border-edge", 11, 0x002b, 0, 101},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"ew-resize", 9, 0x0068, 456, 103},
	{"balance-all", 11, 0x0020, 457, 104},
	{"pan-down", 8, 0x00f9, 0, 105},
	{"no-display", 10, 0x00dc, 0, 106},
	{"inter-character", 15, 0x009d, 0, 107},
	{"pan-x", 5, 0x00fd, 458, 108},
	{"x", 1, 0x0180, 0, 109},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"inline", 6, 0x0095, 460, 111},
	{"mixed", 5, 0x00cd, 0, 112},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"edges", 5, 0x0063, 461, 114},
	{"wrap", 4, 0x017d, 0, 115},
	{"nonzero", 7, 0x00d4, 0, 116},
	{"weak", 4, 0x017b, 0, 117},
	{"wrap-reverse", 12, 0x017e, 0, 118},
	{"flow", 4, 0x007b, 0, 119},
	{"bevel", 5, 0x0023, 0, 120},
	{"sticky", 6, 0x014b, 0, 121},
	{"upright", 7, 0x0171, 465, 122},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"stacked-fractions", 17, 0x0145, 0, 124},
	{"800", 3, 0x000a, 466, 125},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"contextual", 10, 0x0049, 468, 128},
	{"end", 3, 0x0066, 469, 129},
	{"flex", 4, 0x0078, 0, 130},
	{"preserve-3d", 11, 0x0105, 0, 131},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"min-content", 11, 0x00cb, 471, 135},
	{"layout", 6, 0x00ad, 473, 136},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"help", 4, 0x0087, 474, 144},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"recto", 5, 0x010c, 0, 148},
	{"icon", 4, 0x008f, 476, 149},
	{"ordinal", 7, 0x00ee, 477, 150},
	{"x-soft", 6, 0x018a, 478, 151},
	{"loose", 5, 0x00ba, 479, 152},
	{"middle", 6, 0x00c9, 0, 153},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"padding-box", 11, 0x00f4, 0, 157},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"inset", 5, 0x009b, 0, 160},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"isolate-override", 16, 0x00a1, 0, 162},
	{"soft", 4, 0x013c, 0, 163},
	{"no-content", 10, 0x00d9, 480, 164},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"no-common-ligatures", 19, 0x00d8, 0, 166},
	{"spell-out", 9, 0x0142, 481, 167},
	{"jis04", 5, 0x00a3, 483, 168},
	{"bar", 3, 0x0021, 485, 169},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"condensed", 9, 0x0043, 0, 173},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"bottom", 6, 0x002d, 0, 176},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"baseline", 8, 0x0022, 0, 182},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"fixed", 5, 0x0076, 486, 185},
	{"sans-serif", 10, 0x0125, 0, 186},
	{"optimizequality", 15, 0x00ec, 0, 187},
	{"complex", 7, 0x0042, 0, 188},
	{"all-petite-caps", 15, 0x0012, 0, 189},
	{"optimizespeed", 13, 0x00ed, 0, 190},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"pre", 3, 0x0103, 0, 192},
	{"auto", 4, 0x0018, 487, 193},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"current", 7, 0x004f, 489, 195},
	{"alias", 5, 0x000f, 492, 196},
	{"menu", 4, 0x00c7, 0, 197},
	{"over", 4, 0x00f1, 0, 198},
	{"300", 3, 0x0005, 494, 199},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"line-through", 12, 0x00b4, 0, 202},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"on", 2, 0x00e9, 0, 204},
	{"row", 3, 0x0119, 496, 205},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"avoid-column", 12, 0x001b, 497, 207},
	{"region", 6, 0x010e, 500, 208},
	{"balance", 7, 0x001f, 0, 209},
	{"expanded", 8, 0x006a, 0, 210},
	{"plaintext", 9, 0x0101, 501, 211},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"default", 7, 0x0053, 0, 213},
	{"proportional-nums", 17, 0x0109, 0, 214},
	{"butt", 4, 0x0033, 0, 215},
	{"square", 6, 0x0143, 502, 216},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"normal", 6, 0x00d5, 504, 218},
	{"right", 5, 0x0115, 0, 219},
	{"srgb", 4, 0x0144, 0, 220},
	{"inline-table", 12, 0x009a, 0, 221},
	{"off", 3, 0x00e7, 505, 222},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"medium", 6, 0x00c6, 507, 224},
	{"thin", 4, 0x0162, 509, 225},
	{"table-cell", 10, 0x0156, 0, 226},
	{"center", 6, 0x0037, 0, 227},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"monospace", 9, 0x00cf, 510, 229},
	{"text", 4, 0x015e, 511, 230},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"pan-up", 6, 0x00fc, 0, 232},
	{"column", 6, 0x003e, 0, 233},
	{"600", 3, 0x0008, 0, 234},
	{"always", 6, 0x0017, 0, 235},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"ultra-expanded", 14, 0x0169, 0, 237},
	{"inline-block", 12, 0x0096, 0, 238},
	{"outset", 6, 0x00ef, 0, 239},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"space-around", 12, 0x0140, 0, 242},
	{"column-reverse", 14, 0x003f, 0, 243},
	{"strict", 6, 0x014d, 512, 244},
	{"x-high", 6, 0x0184, 0, 245},
	{"fantasy", 7, 0x006e, 0, 246},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"closed", 6, 0x003c, 0, 248},
	{"weight", 6, 0x017c, 514, 249},
	{"paint", 5, 0x00f8, 0, 250},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"descendants", 11, 0x0054, 0, 255},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"double", 6, 0x005b, 0, 257},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"fill-box", 8, 0x0072, 0, 259},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"break-spaces", 12, 0x0031, 0, 261},
	{"dot", 3, 0x0059, 516, 262},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"repeat-x", 8, 0x0111, 0, 266},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"simplified", 10, 0x0133, 0, 268},
	{"900", 3, 0x000c, 517, 269},
	{"-color", 6, 0x0190, 0, 270},
	{"pan-y", 5, 0x00fe, 0, 271},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"both", 4, 0x002c, 0, 275},
	{"table-column", 12, 0x0157, 0, 276},
	{"copy", 4, 0x004b, 0, 277},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"sesameinitial", 13, 0x012c, 519, 279},
	{"grab", 4, 0x0082, 520, 280},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"scroll", 6, 0x0126, 0, 282},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"clip", 4, 0x003a, 0, 286},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"vertical-lr", 11, 0x0174, 0, 289},
	{"cell", 4, 0x0036, 0, 290},
	{"double-circle", 13, 0x005c, 0, 291},
	{"serif", 5, 0x012b, 0, 292},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"step-end", 8, 0x0149, 0, 294},
	{"bold", 4, 0x0028, 0, 295},
	{"horizontal-tb", 13, 0x008e, 0, 296},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"jis78", 5, 0x00a4, 522, 303},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"100", 3, 0x0003, 0, 308},
	{"pre-wrap", 8, 0x0107, 523, 309},
	{"grid", 4, 0x0084, 0, 310},
	{"ease", 4, 0x005e, 0, 311},
	{"90", 2, 0x000b, 525, 312},
	{"not-allowed", 11, 0x00d6, 0, 313},
	{"ruby-text", 9, 0x0120, 0, 314},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"0", 1, 0x0001, 526, 320},
	{"vertical", 8, 0x0173, 0, 321},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"0deg", 4, 0x0002, 0, 324},
	{"loud", 4, 0x00bb, 0, 325},
	{"x-slow", 6, 0x0188, 0, 326},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"hide", 4, 0x0089, 529, 332},
	{"solid", 5, 0x013d, 532, 333},
	{"fit-content", 11, 0x0075, 0, 334},
	{"common-ligatures", 16, 0x0041, 0, 335},
	{"moderate", 8, 0x00ce, 533, 336},
	{"bolder", 6, 0x0029, 0, 337},
	{"x-low", 5, 0x0187, 0, 338},
	{"break-word", 10, 0x0032, 0, 339},
	{"crosshair", 9, 0x004e, 0, 340},
	{"-percentage", 11, 0x019d, 0, 341},
	{"repeat", 6, 0x0110, 0, 342},
	{"400", 3, 0x0006, 0, 343},
	{"ne-resize", 9, 0x00d2, 535, 344},
	{"keep-all", 8, 0x00a9, 0, 345},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"list-item", 9, 0x00b7, 539, 347},
	{"spaces", 6, 0x013f, 0, 348},
	{"hanging", 7, 0x0086, 540, 349},
	{"y", 1, 0x018d, 541, 350},
	{"stretch", 7, 0x014c, 543, 351},
	{"show", 4, 0x012e, 544, 352},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"underline", 9, 0x016b, 545, 355},
	{"ease-in", 7, 0x005f, 0, 356},
	{"hidden", 6, 0x0088, 0, 357},
	{"ink", 3, 0x0094, 546, 358},
	{"local", 5, 0x00b9, 0, 359},
	{"line", 4, 0x00b1, 0, 360},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"manual", 6, 0x00c1, 547, 364},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"fragments", 9, 0x007f, 0, 366},
	{"move", 4, 0x00d0, 548, 367},
	{"padding-edge", 12, 0x00f5, 0, 368},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"unset", 5, 0x016f, 549, 371},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"table-row", 9, 0x015b, 0, 373},
	{"none", 4, 0x00d3, 551, 374},
	{"90deg", 5, 0x000d, 0, 375},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"700", 3, 0x0009, 553, 378},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"-number", 7, 0x019c, 0, 381},
	{"scroll-position", 15, 0x0127, 0, 382},
	{"verso", 5, 0x0172, 557, 383},
	{"repeat-y", 8, 0x0112, 0, 384},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"page", 4, 0x00f6, 558, 388},
	{"high", 4, 0x008a, 0, 389},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"ruby", 4, 0x011d, 0, 391},
	{"under", 5, 0x016a, 0, 392},
	{NULL, 0, MyCSS_PROPERTY_VALUE_UNDEF, 0, 0},
	{"isolate", 7, 0x00a0, 0, 394},
	{"fill", 4, 0x0070, 0, 395},
	{"mandatory", 9, 0x00bf, 0, 396},
	{"oldstyle-nums", 13, 0x00e8, 0, 397},
	{"-image", 6, 0x0196, 0, 398},
	{"caption", 7, 0x0035, 400, 399},
	{"historical-forms", 16, 0x008b, 0, 400},
	{"strong", 6, 0x014e, 402, 401},
	{"reverse", 7, 0x0113, 403, 402},
	{"no-contextual", 13, 0x00da, 0, 403},
	{"step-start", 10, 0x014a, 0, 404},
	{"ruby-base", 9, 0x011e, 0, 405},
	{"-family-name", 12, 0x0194, 0, 406},
	{"size", 4, 0x0134, 408, 407},
	{"row-reverse", 11, 0x011b, 0, 408},
	{"margin-edge", 11, 0x00c2, 0, 409},
	{"rtl", 3, 0x011c, 411, 410},
	{"running", 7, 0x0122, 0, 411},
	{"ellipsis", 8, 0x0064, 413, 412},
	{"s-resize", 8, 0x0153, 414, 413},
	{"separate", 8, 0x012a, 0, 414},
	{"table-footer-group", 18, 0x0159, 416, 415},
	{"table-column-group", 18, 0x0158, 0, 416},
	{"blink", 5, 0x0025, 418, 417},
	{"break", 5, 0x002f, 419, 418},
	{"static", 6, 0x0147, 420, 419},
	{"ultra-condensed", 15, 0x0168, 0, 420},
	{"larger", 6, 0x00ab, 422, 421},
	{"objects", 7, 0x00e5, 0, 422},
	{"invert", 6, 0x009f, 424, 423},
	{"indent", 6, 0x0091, 0, 424},
	{"evenodd", 7, 0x0067, 0, 425},
	{"triangle", 8, 0x0167, 0, 426},
	{"available", 9, 0x0019, 0, 427},
	{"bidi-override", 13, 0x0024, 0, 428},
	{"circle", 6, 0x0038, 430, 429},
	{"inline-flex", 11, 0x0097, 0, 430},
	{"proportional-width", 18, 0x010a, 0, 431},
	{"traditional", 11, 0x0165, 0, 432},
	{"lining-nums", 11, 0x00b5, 0, 433},
	{"dashed", 6, 0x0052, 0, 434},
	{"cover", 5, 0x004c, 436, 435},
	{"visible", 7, 0x0178, 0, 436},
	{"box-decoration", 14, 0x002e, 0, 437},
	{"xx-small", 8, 0x0182, 0, 438},
	{"sub", 3, 0x0150, 0, 439},
	{"overflow", 8, 0x00f2, 441, 440},
	{"list-container", 14, 0x00b6, 0, 441},
	{"w-resize", 8, 0x017f, 0, 442},
	{"full-width", 10, 0x0080, 0, 443},
	{"fast", 4, 0x006f, 0, 444},
	{"vertical-text", 13, 0x0176, 0, 445},
	{"groove", 6, 0x0085, 447, 446},
	{"proximity", 9, 0x010b, 448, 447},
	{"titling-caps", 12, 0x0163, 449, 448},
	{"tabular-nums", 12, 0x015d, 0, 449},
	{"last", 4, 0x00ac, 451, 450},
	{"rightwards", 10, 0x0116, 452, 451},
	{"status-bar", 10, 0x0148, 0, 452},
	{"flow-root", 9, 0x007c, 454, 453},
	{"space-between", 13, 0x0141, 455, 454},
	{"small-caption", 13, 0x013b, 0, 455},
	{"each-line", 9, 0x005d, 0, 456},
	{"inline-list-item", 16, 0x0099, 0, 457},
	{"paused", 6, 0x00ff, 459, 458},
	{"no-repeat", 9, 0x00e0, 0, 459},
	{"inside", 6, 0x009c, 0, 460},
	{"style", 5, 0x014f, 462, 461},
	{"slice", 5, 0x0136, 463, 462},
	{"space", 5, 0x013e, 464, 463},
	{"lowercase", 9, 0x00bd, 0, 464},
	{"cursive", 7, 0x0051, 0, 465},
	{"se-resize", 9, 0x012d, 467, 466},
	{"sw-resize", 9, 0x0152, 0, 467},
	{"-generic-family", 15, 0x0195, 0, 468},
	{"thick", 5, 0x0161, 470, 469},
	{"discard", 7, 0x0057, 0, 470},
	{"max-content", 11, 0x00c5, 472, 471},
	{"text-bottom", 11, 0x015f, 0, 472},
	{"view-box", 8, 0x0177, 0, 473},
	{"x-loud", 6, 0x0186, 475, 474},
	{"unicase", 7, 0x016d, 0, 475},
	{"forwards", 8, 0x007e, 0, 476},
	{"all-small-caps", 14, 0x0014, 0, 477},
	{"x-fast", 6, 0x0183, 0, 478},
	{"large", 5, 0x00aa, 0, 479},
	{"diagonal-fractions", 18, 0x0055, 0, 480},
	{"message-box", 11, 0x00c8, 482, 481},
	{"manipulation", 12, 0x00c0, 0, 482},
	{"contents", 8, 0x0046, 484, 483},
	{"absolute", 8, 0x000e, 0, 484},
	{"small", 5, 0x0138, 0, 485},
	{"no-discretionary-ligatures", 26, 0x00db, 0, 486},
	{"economy", 7, 0x0062, 488, 487},
	{"inter-word", 10, 0x009e, 0, 488},
	{"minimum", 7, 0x00ca, 490, 489},
	{"maximum", 7, 0x00c4, 491, 490},
	{"content", 7, 0x0045, 0, 491},
	{"collapse", 8, 0x003d, 493, 492},
	{"backwards", 9, 0x001e, 0, 493},
	{"miter", 5, 0x00cc, 495, 494},
	{"sideways", 8, 0x012f, 0, 495},
	{"x-small", 7, 0x0189, 0, 496},
	{"avoid-region", 12, 0x001d, 498, 497},
	{"alternate-reverse", 17, 0x0016, 499, 498},
	{"historical-ligatures", 20, 0x008c, 0, 499},
	{"run-in", 6, 0x0123, 0, 500},
	{"pan-right", 9, 0x00fb, 0, 501},
	{"flex-end", 8, 0x0079, 503, 502},
	{"semi-condensed", 14, 0x0128, 0, 503},
	{"progress", 8, 0x0108, 0, 504},
	{"exact", 5, 0x0069, 506, 505},
	{"table", 5, 0x0154, 0, 506},
	{"e-resize", 8, 0x006d, 508, 507},
	{"leftwards", 9, 0x00af, 0, 508},
	{"literal-punctuation", 19, 0x00b8, 0, 509},
	{"semi-expanded", 13, 0x0129, 0, 510},
	{"round", 5, 0x0118, 0, 511},
	{"silent", 6, 0x0132, 513, 512},
	{"extra-condensed", 15, 0x006b, 0, 513},
	{"zoom-in", 7, 0x018e, 515, 514},
	{"ease-in-out", 11, 0x0060, 0, 515},
	{"underscore", 10, 0x016c, 0, 516},
	{"outside", 7, 0x00f0, 518, 517},
	{"oblique", 7, 0x00e6, 0, 518},
	{"no-punctuation", 14, 0x00df, 0, 519},
	{"x-large", 7, 0x0185, 521, 520},
	{"geometricprecision", 18, 0x0081, 0, 521},
	{"inherit", 7, 0x0092, 0, 522},
	{"avoid-page", 10, 0x001c, 524, 523},
	{"crispedges", 10, 0x004d, 0, 524},
	{"grabbing", 8, 0x0083, 0, 525},
	{"digits", 6, 0x0056, 527, 526},
	{"pan-left", 8, 0x00fa, 528, 527},
	{"text-top", 8, 0x0160, 0, 528},
	{"nesw-resize", 11, 0x00d1, 530, 529},
	{"nwse-resize", 11, 0x00e2, 531, 530},
	{"table-caption", 13, 0x0155, 0, 531},
	{"transparent", 11, 0x0166, 0, 532},
	{"slashed-zero", 12, 0x0135, 534, 533},
	{"block-within-page", 17, 0x0027, 0, 534},
	{"nw-resize", 9, 0x00e3, 536, 535},
	{"ns-resize", 9, 0x00e1, 537, 536},
	{"col-resize", 10, 0x0040, 538, 537},
	{"capitalize", 10, 0x0034, 0, 538},
	{"no-historical-ligatures", 23, 0x00de, 0, 539},
	{"petite-caps", 11, 0x0100, 0, 540},
	{"n-resize", 8, 0x00e4, 542, 541},
	{"all-scroll", 10, 0x0013, 0, 542},
	{"table-row-group", 15, 0x015c, 0, 543},
	{"slow", 4, 0x0137, 0, 544},
	{"uppercase", 9, 0x0170, 0, 545},
	{"allow-end", 9, 0x0011, 0, 546},
	{"overline", 8, 0x00f3, 0, 547},
	{"horizontal", 10, 0x008d, 0, 548},
	{"clone", 5, 0x003b, 550, 549},
	{"inline-grid", 11, 0x0098, 0, 550},
	{"break-all", 9, 0x0030, 552, 551},
	{"linearrgb", 9, 0x00b3, 0, 552},
	{"initial", 7, 0x0093, 554, 553},
	{"pre-line", 8, 0x0106, 555, 554},
	{"preserve", 8, 0x0104, 556, 555},
	{"paginate", 8, 0x00f7, 0, 556},
	{"optimizelegibility", 18, 0x00eb, 0, 557},
	{"ruby-base-container", 19, 0x011f, 559, 558},
	{"ruby-text-container", 19, 0x0121, 0, 559},
};


#endif /* MyHTML_MyCSS_PROPERTY_RESOURCES_H */
