package Zed;

use POSIX;
use Term::ReadLine;

use Zed::Plugin;
use Zed::Output;
use Zed::Config::Env;
use Zed::Config::Space;

use strict;
use 5.008_005;
our $VERSION = '0.01';

sub _macro
{
    my ($text, $stat) = @_;
    my %plugins = Zed::Plugin::plugins();
    my %hash = 
    ( 
        %{ env('macro') }, 
        map{$_ => $_}keys %{$plugins{invoke}},
    );

    if($hash{$text})
    {
        return $hash{$text} if $stat == 0;
        return ();
    }
    my @grep = sort grep{ /^$text/ }keys %hash;
    $grep[$stat] ? $grep[$stat] : ();
}

sub _result
{
    return unless ref $_[0] eq 'ARRAY' 
              and ref $_[1] eq 'ARRAY' 
              and scalar @_ >= 2;

    my($suc, $fail, $result) = @_;

    $result ||= {};

    my( %group, %content, $count );

    push @{ $content{ $result->{$_} } }, $_ for keys %$result;

    while(my($text, $host) = each %content)
    {
        $count += 1;    
        my $group = "group". $count;
        $group{$group} = $host;
        if(@$host <= 5)
        {
            info("$group\[", join(',', @$host), "\]:");
        }else{
            info("$group\[", scalar @$host,"\]:");
        }
        text($text);
    }

    env( "result", {space => usespace(), "suc" => $suc, "fail" => $fail, "group" => \%group } );
    info(sprintf "\nsuc:[ %s ], fail:[ %s ]\n", scalar @$suc, scalar @$fail);
}

sub run
{
    my ($term, $attribs, $prompt) = Term::ReadLine->new(__PACKAGE__);
    my $hist = File::Spec->join( $ENV{ZED_HOME}, "history" );
    $term->ReadHistory($hist);
    $attribs = $term->Attribs;

    $attribs->{attempted_completion_function} = sub { 

        my($text, $line, $start, $end) = @_;

        if( substr($line, 0, $start) =~ /^\s*$/ )
        {
            return $term->completion_matches($text, \&_macro) 
            
        }elsif( $line =~ /^(\w+) / and $start ==  1 + length $1){

            my($sub, @word) = Zed::Plugin::complete_first( $1 );
            return unless $sub and @word = $sub->();
            return $term->completion_matches($text, sub{

                my ($text, $stat, @grep) = splice @_, 0, 2;

                @grep = sort grep{ /^$text/ } @word;
                $grep[$stat] ? $grep[$stat] : undef;
            }) 
            
        }
        return;
    };

    sigaction SIGINT, new POSIX::SigAction sub {
        $term->delete_text;
        $attribs->{point} = $attribs->{end} = 0;
        print "\n", $prompt;
        $|=1;
    } or die "Error setting SIGINT handler: $!\n";

    while(1)
    {
        $prompt = ( env("username")||"nouser" ) . "\@zed#> ";
        my $in = $term->readline($prompt);
        next unless $in; $in =~ s/ *$//;

        my( $cmd, undef, $param, @params ) = $in =~ /^(.+?)(\s+(.+))?$/;
        @params = grep{$_} split /\s/, $param if $param;
        warn "input($in) error\n" and next unless $cmd;

        debug("cmd: |$cmd|");
        debug("param: |$param|") if $param;
        debug("params:", \@params) if @params;

        last if $cmd eq 'quit';

        my($sub, @return, $after) = invoke($cmd);
        debug("get invoke:", ref $sub ? "suc" : "faild");

        @return = $sub ? $sub->(@params) : info("no invoke plugin(cmd: $cmd) defined") && next;

        _result( @return );
            
        #$term->addhistory($in);
    }
    $term->WriteHistory($hist) or warn "cannot write history file: $!\n";
}
1;
__END__

=encoding utf-8

=head1 NAME

Zed - Remote execution shell over SSH

=head1 SYNOPSIS

  # Just run zed
  > zed

=head1 DESCRIPTION

Zed is remote execution shell over SSH with many plugins to help you to manage servers.

Features below:

=over 4

=item execution over SSH

=item transfer file over scp

=item port detection

=item flexible way to manage targets

=item easy to type cmd with completion

=back

(Servers will not disconnect until you quit. So Large mount of servers may cause memory problem)

=head1 AUTHOR

SiYu Zhao E<lt>zuyis@cpan.orgE<gt>

=head1 COPYRIGHT

Copyright 2016- SiYu Zhao

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

=cut
