use strict;
use warnings;
use Test::More;
use lib qw(./lib ./blib/lib);
require './t/600-lhost-code';

my $enginename = 'GMX';
my $samplepath = sprintf("./set-of-emails/private/lhost-%s", lc $enginename);
my $enginetest = Sisimai::Lhost::Code->makeinquiry;
my $isexpected = {
    # INDEX => [['D.S.N.', 'replycode', 'REASON', 'hardbounce', 'toxic'], [...]]
    '1001'  => [['5.0.947', '',    'expired',         0, 0]],
    '1002'  => [['5.1.1',   '',    'userunknown',     1, 1]],
    '1003'  => [['5.2.2',   '',    'mailboxfull',     0, 1]],
    '1004'  => [['5.2.1',   '',    'userunknown',     1, 1],
                ['5.2.2',   '',    'mailboxfull',     0, 1]],
};

plan 'skip_all', sprintf("%s not found", $samplepath) unless -d $samplepath;
$enginetest->($enginename, $isexpected, 1, 0);
done_testing;

