#!perl
use Mojo::Base -strict;
use Test::More;
use Mojolicious::Lite;
use Test::Mojo;

plugin 'Mojolicious::Plugin::AWS';

my $t = Test::Mojo->new;

if ($ENV{AWS_REGION} && $ENV{AWS_S3_URL} && $ENV{AWS_ACCESS_KEY} && $ENV{AWS_SECRET_KEY}) {
    my $aws_region = $ENV{AWS_REGION};
    my $access_key = $ENV{AWS_ACCESS_KEY};
    my $secret_key = $ENV{AWS_SECRET_KEY};
    my $s3_url     = $ENV{AWS_S3_URL};

    $t->app->s3_retrieve(
        region     => $aws_region,
        access_key => $access_key,
        secret_key => $secret_key,
        url        => Mojo::URL->new($s3_url),
    )->then(
        sub {
            my $tx = shift;
            ok $tx->res->headers->header('x-amz-request-id'), 'response has version id header'
              or diag explain $tx->res->headers;
            like $tx->res->body, qr(widget_label), 'matching body';
        }
    )->catch(
        sub {
            my $err = shift;
            ok !$err, "an error occurred" or diag "Error: $err";
            ok 0;
        }
    )->wait;
}

done_testing();
