package Bundle::Math;
use strict;
use warnings;

$VERSION = '1.02';

1;

__END__

=head1 NAME

Bundle::Math - A bundle to install various mathematics related modules

=head1 SYNOPSIS

 perl -MCPAN -e 'install Bundle::Math'

=head1 CONTENTS

Bundle::Math::Approx     - Bundle related to interpolation and approximation

Bundle::Math::Base       - Bundle related to calculations between bases

Bundle::Math::Big        - Bundle of modules related to arbitrary size numbers

Bundle::Math::Calculus   - Bundle of modules related to calculus

Bundle::Math::Expression - Bundle: mathematic expression parsers and evaluators

Bundle::Math::Fractal    - Bundle of modules related to fractals

Bundle::Math::Financial  - Bundle of modules related to financial mathematics

Bundle::Math::Geometry   - Bundle of modules related to 2D and 3D geometry

Bundle::Math::Interface  - Bundle of modules interfacing with math libraries

Bundle::Math::Matrix     - Bundle related to matrix or vector calculation

Bundle::Math::Numeric    - Bundle of modules related to numeric algorithms

Bundle::Math::Random     - Bundle of modules related to random numbers

Bundle::Math::Statistics - Bundle of modules related to statistics

Bundle::Math::Symbolic   - Bundle of modules related to symbolic math

PDL                      - Perl Data Language

=head1 DESCRIPTION

This is a bundle of mathematics related modules. It is divided into
several categories as sub-bundles.

If you would like to see a specific module included in a future version of
this bundle, please send me an email or use rt.cpan.org.

=head1 AUTHOR

Steffen Mueller E<lt>bundlemath-module at steffen-mueller dot netE<gt>

=cut 
