use strict;
use warnings;
package Dist::Zilla::PluginBundle::CEBJYRE;
{
  $Dist::Zilla::PluginBundle::CEBJYRE::VERSION = '0.4.0';
}

# ABSTRACT: My default dzil plugins

use Moose;
with 'Dist::Zilla::Role::PluginBundle::Easy';


use Dist::Zilla::Plugin::PkgVersion;
use Dist::Zilla::Plugin::AutoPrereqs;
use Dist::Zilla::Plugin::PodWeaver;
use Dist::Zilla::Plugin::PodCoverageTests;
use Dist::Zilla::Plugin::PodSyntaxTests;
use Dist::Zilla::Plugin::NextRelease;
use Dist::Zilla::Plugin::CheckPrereqsIndexed;
use Dist::Zilla::Plugin::MetaJSON;
use Dist::Zilla::PluginBundle::Filter;
use Dist::Zilla::PluginBundle::Basic;
use Dist::Zilla::PluginBundle::Git;

sub configure {
  my $self = shift;
  my $payload = $self->payload;

  $self->add_plugins(
    [AutoPrereqs => $self->config_slice({prereq_skip => 'skip'})],
    qw(
      PkgVersion
      PodWeaver
      PodCoverageTests
      PodSyntaxTests
      NextRelease
      CheckPrereqsIndexed
      MetaJSON
  ));

  $self->add_bundle(Filter => {-bundle => '@Basic', -remove => ['MetaYAML']});
  my %git_config = map {substr($_, 4) => $payload->{$_}} grep {/^git_/} keys %$payload;
  $self->add_bundle(Git => \%git_config);
}

__PACKAGE__->meta->make_immutable;
no Moose;

1;

__END__
=pod

=head1 NAME

Dist::Zilla::PluginBundle::CEBJYRE - My default dzil plugins

=head1 VERSION

version 0.4.0

=head1 DESCRIPTION

Using this bundle is equivalent to:

  [AutoPrereqs]
  [PkgVersion]
  [PodWeaver]
  [PodCoverageTests]
  [PodSyntaxTests]
  [NextRelease]
  [CheckPrereqsIndexed]
  [MetaJSON]
  [@Filter]
  -bundle = @Basic
  -remove = MetaYAML
  [@Git]

where the C<@Filter> bundle is the C<@Basic> bundle with the C<MetaYAML>
plugin stripped out.
Configurations options may be passed into the Git bundle by prefacing the
usual option names with C<git_>. Likewise prerequisites generated by
C<AutoPrereqs> may be disregarded with C<prereq_skip>.

For example:

  [@CEBJYRE]
  git_push_to = github
  prereq_skip = Not::A::Real::Prereq

=head1 METHODS

=head2 configure

See L<Dist::Zilla::Role::PluginBundle::Easy>.

=head1 AUTHOR

Glenn Fowler <cebjyre@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2011 by Glenn Fowler.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

