# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BG;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20241212130803;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            43[1-6]|
            70[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [356]|
            4[124-7]|
            7[1-9]|
            8[1-6]|
            9[1-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              70|
              8
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            43[1-7]|
            7
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [48]|
            9[08]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '9',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'geographic' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'mobile' => '
          (?:
            43[07-9]|
            99[69]\\d
          )\\d{5}|
          (?:
            8[7-9]|
            98
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(700\\d{5})|(90\\d{6})',
                'toll_free' => '
          (?:
            00800\\d\\d|
            800
          )\\d{5}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{bg} = {"3595397", "Методиево\,\ Шумен",
"3597135", "Трудовец",
"359817", "Бяла\,\ Русе",
"3597548", "Годешево",
"3594334", "Елхово\,\ Ст\.\ Загора\,\ общ\.\ Николаево",
"35953437", "Габрица\,\ Шумен",
"3599784", "Киселево",
"3595578", "Терзийско\,\ Бургас",
"3596915", "Смочан",
"3593589", "Церово\,\ Пазарджик",
"3599339", "Макреш",
"3593198", "Чехларе",
"3596327", "Овча\ могила",
"3595714", "Карапелит",
"3595958", "Граматиково",
"35991202", "Кунино",
"359720", "Етрополе",
"3595716", "Паскалево",
"3595532", "Тополица",
"3594367", "Тъжа",
"3593020", "Давидково",
"3599353", "Кошава",
"35967306", "Градище\,\ Габр\.",
"3595910", "Черни\ връх\,\ Бургас",
"3593935", "Върбица\,\ Хаск\.",
"3594336", "Долно\ Изворово",
"3595527", "Соколово\,\ Бургас",
"35984735", "Свещари",
"3596553", "Оряховица\,\ Плевен",
"3593678", "Чакаларово",
"359650", "Левски\,\ Плевен",
"3596004", "Маково",
"3593519", "Величково\,\ Пазарджик",
"3595784", "Врачанци",
"3594132", "Оризово",
"35930459", "Бръщен",
"3594768", "Зимница\,\ Ямбол",
"3596985", "Румянцево",
"3596134", "Бяла\ черква\,\ В\.\ Търново",
"3593116", "Крумово\,\ Пловдив",
"35974207", "Генерал\ Тодоров",
"35930410", "Брезе\,\ Смол\.",
"3593568", "Виноградец",
"3593631", "Момчилград",
"3597523", "Гърмен",
"3597914", "Ваксево",
"3598163", "Бъзън",
"35951106", "Осеново\,\ Варна",
"3595353", "Веселиново\,\ Шумен",
"3593114", "Брестник",
"35971503", "Долно\ Камарци",
"35941333", "Средно\ градище",
"3596167", "Кесарево",
"3599527", "Вършец",
"3596539", "Градище\,\ Плевен",
"3596049", "Камбурово",
"3597916", "Багренци",
"35961203", "Емен",
"35984734", "Тодорово\,\ Разград",
"35966", "Габрово",
"3596006", "Пресиян",
"35961301", "Бяла\ река\,\ В\.\ Търново",
"35967397", "Ряховците",
"3596728", "Буря",
"3596136", "Сухиндол",
"35984761", "Градина\,\ Разград",
"359335", "Карлово",
"3593632", "Джебел",
"3598698", "Шуменци",
"3594323", "Тулово",
"3596535", "Козар\ Белене",
"35931396", "Домлян",
"35971338", "Осиковска\ Лакавица",
"35941119", "Елхово\,\ Ст\.\ Загора",
"3596148", "Павел",
"35971505", "Чурек",
"35941335", "Могилово",
"3594715", "Калчево",
"3593037", "Сивино",
"359417", "Раднево",
"3593547", "Сърница\,\ Пазарджик",
"35975215", "Тешово",
"3593107", "Граф\ Игнатиево",
"35957307", "Житен\,\ Добр\.",
"3595912", "Полски\ извор",
"3595530", "Пещерско",
"3594593", "Шивачево",
"359579", "Албена",
"3596989", "Торос",
"3595335", "Миланово\,\ Шумен",
"3593022", "Виево",
"35991668", "Манастирище",
"3593515", "Калугерово\,\ Пазарджик",
"3594747", "Денница\,\ Ямбол",
"35981264", "Пиперково",
"3594773", "Окоп",
"3596123", "Буковец\,\ В\.\ Търново",
"35984733", "Лудогорци",
"3593757", "Георги\ Добрево",
"3598131", "Борисово\,\ Русе",
"3597711", "Кладница",
"35971504", "Белопопци",
"35941334", "Съединение\,\ Ст\.\ Загора",
"3594130", "Спасово\,\ Ст\.\ Загора",
"3594557", "Биково",
"3597044", "Бабино",
"3594348", "Дунавци\,\ Ст\.\ Загора",
"3599335", "Цар\ Петрово",
"3593585", "Аканджиево",
"35975214", "Гайтаниново",
"35931402", "Скобелево\,\ Пловдив",
"3597712", "Батановци",
"3598132", "Юделник",
"3596919", "Слатина\,\ Ловеч",
"3597046", "Бобошево",
"35955502", "Суходол\,\ Бургас",
"3596968", "Добродан",
"3597139", "Джурово",
"35961107", "Момин\ сбор",
"3598127", "Караманово",
"3597933", "Грамаждано",
"35974203", "Рупите",
"3593556", "Радилово",
"3597176", "Храбърско",
"35931700", "Беловица",
"35957305", "Росица\,\ Добр\.",
"3597436", "Левуново",
"35935501", "Равногор",
"3599341", "Димово\,\ Видин",
"3595146", "Горен\ чифлик",
"35961104", "Водолей",
"35971220", "Гуцал",
"3596113", "Балван",
"3593159", "Белозем",
"3598626", "Средище\,\ Силистра",
"3598662", "Добротица\,\ Силистра",
"3594756", "Поляна\,\ Ямбол",
"3595144", "Камчия",
"3598117", "Мартен",
"35967393", "Душево",
"35959400", "Дъскотна",
"3594754", "Каменец\,\ Ямбол",
"3598624", "Калипетрово",
"359678", "Тетевен",
"3596929", "Радювене",
"3593554", "Козарско",
"3599342", "Иново",
"35941337", "Сърневец",
"3598661", "Тутракан",
"3597174", "Калотина",
"3598145", "Тръстеник\,\ Русе",
"3593133", "Калофер",
"3597434", "Струмяни",
"3599146", "Соколаре",
"3596032", "Зараево",
"35957304", "Дъбовик",
"359453", "Котел",
"3596542", "Въбел\,\ Плевен",
"3595341", "Хитрино",
"3595733", "Кардам\,\ Добр\.",
"3594104", "Кравино",
"35991401", "Враняк",
"3597057", "Мало\ село",
"3596991", "Ябланица",
"3599549", "Долна\ Рикса",
"35931392", "Дъбене",
"35991189", "Три\ кладенци",
"3596027", "Дралфа",
"35961105", "Присово",
"3593744", "Сърница\,\ Хаск\.",
"35931398", "Слатина\,\ Пловдив",
"359373", "Харманли",
"3595342", "Капитан\ Петко",
"3593320", "Орешец\,\ Пловдив",
"3596541", "Никопол",
"3594149", "Трънково\,\ Ст\.\ Загора",
"3596992", "Златна\ Панега",
"3595760", "Божурово\,\ Добр\.",
"3595759", "Кочмар",
"3593746", "Сираково\,\ Хаск\.",
"3596175", "Първомайци",
"3599144", "Нивянин",
"3593709", "Караманци",
"3598187", "Тетово",
"35963560", "Радишево",
"3594725", "Лесово",
"3594106", "Пъстрен",
"3597924", "Шишковци",
"3594729", "Кирилово\,\ Ямбол",
"3598660", "Тутракан",
"35941144", "Калояновец",
"3593162", "Градина\,\ Пловдив",
"3596179", "Крушето",
"3593705", "Въгларово",
"3593126", "Труд",
"3599724", "Станево",
"3595755", "Коларци",
"35984737", "Райнино",
"3596576", "Радомирци",
"3594145", "Знаменосец",
"35974321", "Хърсово\,\ Благ\.",
"3599172", "Селановци",
"35967394", "Богатово",
"3596954", "Врабево",
"3593529", "Мокрище",
"3599138", "Алтимир",
"3599726", "Замфир",
"35953220", "Памукчии\,\ Шумен",
"35931324", "Мраченик",
"3596718", "Драгановци",
"3596956", "Ломец\,\ Ловеч",
"3593645", "Аврен\,\ Кърдж\.",
"3599545", "Габровница",
"3598633", "Старо\ село\,\ Силистра",
"3597720", "Прибой",
"35951108", "Изворско",
"35961103", "Русаля",
"3596574", "Чомаковци",
"3599340", "Септемврийци\,\ Видин",
"3597926", "Коняво",
"3593772", "Момково",
"35953435", "Изгрев\,\ Шумен",
"3599517", "Кобиляк",
"3597423", "Коларово\,\ Благ\.",
"3599171", "Оряхово\,\ Враца",
"3593124", "Калековец",
"35974204", "Гега",
"35981886", "Черешово\,\ Русе",
"35935419", "Света\ Петка",
"3595724", "Дропла\,\ Добр\.",
"35941145", "Арнаутито",
"3598149", "Кацелово",
"3596925", "Владиня",
"35967395", "Горна\ Росица",
"3597142", "Костенец",
"3595761", "Батово",
"35984779", "Здравец\,\ Разград",
"3596030", "Светлен\,\ Търг\.",
"3594792", "Ботево\,\ Ямбол",
"3593321", "Тополово\,\ Пловдив",
"3596540", "Асеново\,\ Плевен",
"3593058", "Мугла",
"3595517", "Равнец\,\ Бургас",
"3597448", "Бачево",
"3593155", "Момино\ село",
"3595762", "Стефан\ Караджа\,\ Добр\.",
"35967302", "Кръвеник",
"3596990", "Малък\ извор\,\ Ловеч",
"3596063", "Баячево",
"3595138", "Добротич",
"3595726", "Царичино",
"3595105", "Приселци\,\ Варна",
"35937421", "Долно\ поле",
"35953434", "Ясенково",
"3593322", "Златовръх",
"3595340", "Висока\ поляна\,\ Шумен",
"35967308", "Ловнидол",
"3596969", "Беклемето",
"3597138", "Литаково",
"3597726", "Дрен",
"3599346", "Синаговци",
"3597105", "Малки\ Искър",
"3595141", "Старо\ Оряхово",
"3596950", "Гумощник",
"35960375", "Гърчиново",
"3598621", "Силистра",
"3597545", "Кочан",
"3599720", "Ковачица",
"3597035", "Червен\ брег",
"3594751", "Войника",
"35961607", "Балканци\,\ В\.\ Търново",
"3594113", "Преславен",
"3596918", "Дренов",
"35941113", "Пряпорец\,\ Ст\.\ Загора",
"3595575", "Прилеп\,\ Бургас",
"3593195", "Розовец",
"3597920", "Скриняно",
"3598664", "Поляна\,\ Силистра",
"3595142", "Долни\ чифлик",
"3593120", "Храбрино",
"35941171", "Дълбоки",
"3599513", "Бойчиновци",
"3597427", "Първомай\,\ Благ\.",
"3594752", "Първенец\,\ Ямбол",
"359723", "Ботевград",
"3598666", "Тутракан",
"359478", "Елхово\,\ Ямбол",
"3598622", "Алеково\,\ Силистра",
"3593552", "Брацигово",
"3597724", "Извор\,\ Перник",
"3599344", "Връв",
"3596570", "Девенци",
"35935393", "Смилец\,\ Пазарджик",
"3598637", "Малък\ Преславец",
"3597172", "Драгоман",
"3596034", "Славяново\,\ Търг\.",
"3593675", "Фотиново\,\ Кърдж\.",
"3596544", "Новачене\,\ Плевен",
"3594102", "Ястребово\,\ Ст\.\ Загора",
"35960374", "Горско\ Абланово",
"3596988", "Пещерна",
"3599141", "Малорад",
"35930412", "Девин",
"3595346", "Каменяк\,\ Шумен",
"35930418", "Буйново\,\ Смол\.",
"35947354", "Каменна\ река",
"3595344", "Велино",
"3597755", "Велковци\,\ Перник",
"3596149", "Куцина",
"3596067", "Кралево\,\ Търг\.",
"3596994", "Брестница\,\ Ловеч",
"3594101", "Опан",
"3595513", "Габър",
"3596546", "Лозица\,\ Плевен",
"3598699", "Търновци\,\ Силистра",
"3596036", "Садина",
"3599142", "Лазарово",
"3596725", "Гостилица",
"3593741", "Мандра",
"35935394", "Оборище\,\ Пазарджик",
"3597922", "Драговищица\,\ Кюст\.",
"3596117", "Дебелец\,\ В\.\ Търново",
"3593776", "Райкова\ могила",
"3593164", "Дълбок\ извор",
"3596571", "Лепица",
"35937701", "Сладун",
"3598695", "Ножарево",
"3597937", "Ръждавица",
"3596538", "Обнова",
"3596048", "Изворово\,\ Търг\.",
"35977221", "Кондофрей",
"3599722", "Сталийска\ махала",
"3596145", "Страхилово",
"3596952", "Орешак\,\ Ловеч",
"3599174", "Горни\ Вадин",
"3593121", "Рогош",
"3597921", "Жиленци",
"3594718", "Роза",
"3597430", "Дамяница",
"3599176", "Лесковец\,\ Враца",
"3593137", "Клисура\,\ Пловдив",
"3596572", "Сухаче",
"3593569", "Карабунар",
"35941114", "Лозен\,\ Ст\.\ Загора",
"3599721", "Долно\ Церовене",
"3598113", "Ново\ село\,\ Русе",
"3593774", "Левка",
"3597733", "Филиповци",
"3598620", "Силистра",
"3595338", "Троица",
"3593122", "Маноле",
"3593679", "Кирково",
"3593518", "Драгор",
"3595140", "Шкорпиловци",
"35963566", "Бръшляница",
"3593166", "Бяла\ река\,\ Пловдив",
"3593740", "Пчелари",
"35935251", "Братаница",
"3595766", "Методиево\,\ Добр\.",
"3596023", "Подгорица",
"359309", "Пампорово",
"3593326", "Патриарх\ Евтимово",
"35931706", "Сухозем",
"359747", "Разлог",
"3594100", "Столетово\,\ Ст\.\ Загора",
"3597144", "Костенец",
"3595737", "Люляково\,\ Добр\.",
"35947353", "Българска\ поляна",
"3595959", "Звездец",
"3597053", "Кочериново",
"3594794", "Овчи\ кладенец",
"3594345", "Радунци",
"3597146", "Черньово",
"3593588", "Мененкьово",
"35941115", "Борилово",
"3599338", "Шишенци",
"35941339", "Димитриево",
"3594796", "Генерал\ Тошево\,\ Ямбол",
"3595579", "Ведрово",
"35959406", "Разбойна\,\ Бургас",
"3599140", "Габаре",
"3597549", "Долен\,\ Благ\.",
"3595764", "Владимирово\,\ Добр\.",
"35960373", "Посабина",
"35937606", "Шишманово",
"3597039", "Самораново",
"3593324", "Избеглии",
"3596965", "Бели\ Осъм",
"35931708", "Песнопой\,\ Пловдив",
"3598442", "Завет\,\ Разград",
"3594332", "Ветрен\,\ Ст\.\ Загора",
"35931309", "Климент\,\ Пловдив",
"3595139", "Оборище\,\ Варна",
"35931702", "Долна\ махала\,\ Пловдив",
"3599782", "Буковец\,\ Монт\.",
"3593059", "Кутела",
"35971228", "Марица",
"3595536", "Мъглен",
"3595712", "Стожер",
"3594327", "Шейново",
"3594597", "Боров\ дол",
"35961109", "Въглевци",
"35959408", "Ръжица",
"3597193", "Голеш\,\ София",
"3595153", "Суворово",
"3595534", "Карагеоргиево",
"3594743", "Мамарчево",
"3594331", "Гурково\,\ Ст\.\ Загора",
"359554", "Слънчев\ бряг",
"35991185", "Пудрия",
"35963203", "Хаджидимитрово\,\ В\.\ Търново",
"35984266", "Просторно",
"3593543", "Дорково",
"35937602", "Черна\ могила\,\ Хаск\.",
"35960451", "Обител",
"3595711", "Овчарово\,\ Добр\.",
"3593103", "Милево",
"3598148", "Горно\ Абланово",
"3593111", "Първенец\,\ Пловдив",
"35961603", "Лозен\,\ В\.\ Търново",
"3596002", "Съединение\,\ Търг\.",
"3597157", "Саранци",
"3594553", "Раково\,\ Сливен",
"35941117", "Казанка",
"3595782", "Бенковски\,\ Добр\.",
"3593636", "Равен",
"35984721", "Липник",
"3594134", "Братя\ Даскалови",
"3596132", "Караисен",
"3594777", "Тенево",
"35931390", "Московец",
"3599139", "Търнава\,\ Враца",
"3597912", "Горна\ Гращица",
"3599567", "Долна\ Вереница",
"3593667", "Покрован",
"3593753", "Оряхово\,\ Хаск\.",
"3595781", "Свобода\,\ Добр\.",
"35991184", "Ракево",
"3596001", "Черковна\,\ Търг\.",
"3593528", "Говедаре",
"3593112", "Марково\,\ Пловдив",
"35984711", "Мортагоново",
"3598123", "Босилковци",
"35963568", "Буковлък",
"359910", "Мездра",
"3596178", "Стрелец\,\ В\.\ Търново",
"35946", "Ямбол",
"3593634", "Припек\,\ Кърдж\.",
"35963562", "Комарево\,\ Плевен",
"3594728", "Мелница",
"3597911", "Граница",
"3594136", "Черна\ гора\,\ Ст\.\ Загора",
"3593026", "Смилян",
"3595710", "Победа\,\ Добр\.",
"35963204", "Деляновци",
"3596323", "Българско\ сливово",
"359339", "Стамболийски\,\ Пловдив",
"3593708", "Орлово\,\ Хаск\.",
"3594330", "Николаево\,\ Ст\.\ Загора",
"3595393", "Иваново\,\ Шумен",
"35961502", "Горско\ Ново\ Село",
"3595758", "Кладенци",
"35930416", "Гьоврен",
"35930457", "Късак",
"3596943", "Горско\ Сливово",
"359676", "Дряново\,\ Габр\.",
"3595916", "Росен\,\ Бургас",
"35960377", "Априлово\,\ Търг\.",
"3599135", "Бърдарски\ геран",
"35931388", "Бегунци",
"35953222", "Марково\,\ Шумен",
"3593648", "Голямо\ Каменяне",
"3599548", "Крапчене",
"35967399", "Малки\ Вършец",
"359865", "Силистра",
"3595523", "Крумово\ градище",
"3595914", "Атия",
"3593024", "Търън",
"35961605", "Ново\ градище",
"35932", "Пловдив",
"3594363", "Габарево",
"35941149", "Ловец\,\ Ст\.\ Загора",
"3597910", "Берсин",
"35963205", "Червена",
"3597527", "Горно\ Дряново",
"3596928", "Къкрина",
"3594123", "Богомилово",
"3598167", "Церовец",
"3596557", "Брегаре",
"35993212", "Карбинци",
"3597042", "Коркина",
"35991183", "Фурен",
"3597532", "Буково\,\ Благ\.",
"3598136", "Стамболово\,\ Русе",
"3593055", "Елховец",
"35984774", "Голям\ извор\,\ Разград",
"3597445", "Баня\,\ Благ\.",
"3597714", "Мещица",
"3598134", "Малко\ Враново",
"3595108", "Садово\,\ Варна",
"3595135", "Стефан\ Караджа\,\ Варна",
"35961604", "Мирово\,\ В\.\ Търново",
"3597531", "Долно\ Дряново",
"3593623", "Бойно",
"3599523", "Бързия",
"3596163", "Камен\,\ В\.\ Търново",
"3593110", "Поповица",
"3597041", "Шатрово",
"35941110", "Старозагорски\ бани",
"3596714", "Поповци",
"3594712", "Кабиле",
"3595327", "Каспичан\,\ Шумен",
"3599134", "Търнак",
"3596578", "Реселец",
"3599553", "Превала",
"3593653", "Млечино",
"3595915", "Българово",
"3593767", "Браница",
"3596531", "Изгрев\,\ Плевен",
"3593025", "Баните",
"35931397", "Христо\ Даново",
"35955505", "Драчево",
"3595332", "Драгоево",
"3597163", "Искрец",
"3594567", "Баня\,\ Сливен",
"3595947", "Просеник",
"3594139", "Свобода\,\ Ст\.\ Загора",
"3593128", "Златитрап",
"3593512", "Хаджиево",
"3594711", "Безмер\,\ Ямбол",
"3597928", "Гърляно",
"3593639", "Нановица\,\ Кърдж\.",
"3596527", "Одърне",
"3599167", "Липница\,\ Враца",
"3596910", "Малиново",
"35957306", "Изворово\,\ Добр\.",
"3596042", "Илийно",
"3599136", "Галиче",
"3599728", "Сливата",
"3595743", "Шабла",
"359596", "Поморие",
"3593177", "Ново\ Железаре",
"359454", "Твърдица\,\ Сливен",
"3596532", "Българене\,\ Плевен",
"3596716", "Жълтеш",
"3596958", "Априлци\,\ Ловеч",
"3593511", "Огняново\,\ Пазарджик",
"35996", "Монтана",
"35991203", "Лик",
"3594153", "Мъдрец\,\ Ст\.\ Загора",
"3593582", "Момина\ клисура",
"3599332", "Раковица",
"3593054", "Подвис\,\ Смол\.",
"35963571", "Брестовец",
"3598475", "Лозница\,\ Разград",
"3597444", "Белица\,\ Благ\.",
"3593143", "Перущица",
"3598135", "Бабово",
"3597715", "Студена\,\ Перник",
"3595134", "Червенци",
"3599327", "Чупрене",
"3595553", "Орлинци",
"359550", "Созопол",
"35955504", "Богданово\,\ Бургас",
"3593581", "Белово",
"3595136", "Брестак",
"35981268", "Кривина\,\ Русе",
"35981262", "Бистренци",
"35956", "Бургас",
"35984269", "Недоклан",
"3596980", "Беленци",
"3593056", "Чепинци\,\ Смол\.",
"35974401", "Горно\ Драглище",
"35941338", "Целина",
"3595539", "Черноград",
"3595167", "Венчан",
"3597446", "Елешница\,\ Благ\.",
"35941332", "Найденово",
"35951127", "Разделна\,\ Варна",
"35971502", "Елешница\,\ София",
"35961106", "Ново\ село\,\ В\.\ Търново",
"3596563", "Брест\,\ Плевен",
"3599123", "Роман",
"3593510", "Овчеполци",
"3595148", "Рудник\,\ Варна",
"3595330", "Златар",
"3598628", "Цар\ Асен\,\ Силистра",
"3595535", "Лясково\,\ Бургас",
"3593927", "Черногорово\,\ Хаск\.",
"35953436", "Черноглавци",
"3593558", "Исперихово",
"3596911", "Лисец\,\ Ловеч",
"3597438", "Катунци",
"3597178", "Пролеша",
"3593932", "Бодрово",
"3593347", "Леново",
"3594710", "Болярско",
"3598677", "Сребърна",
"3597132", "Радотина",
"3595363", "Гусла",
"3596157", "Сливовица",
"3596530", "Трънчовица",
"3597127", "Широки\ дол",
"35967307", "Млечево",
"3596912", "Баховица",
"35961391", "Сломер",
"359727", "Сливница\,\ София",
"3597719", "Ярджиловци",
"3594523", "Стоил\ войвода",
"3593931", "Каснаково",
"359336", "Първомай\,\ Пловдив",
"35930419", "Ягодина",
"3596981", "Петревене",
"3599148", "Бъркачево",
"3595123", "Равна\,\ Варна",
"35984738", "Китанчево",
"35984732", "Йонково",
"3598643", "Златоклас",
"3596074", "Любичево",
"3599330", "Раброво",
"35941146", "Християново",
"3595968", "Каблешково\,\ Бургас",
"35960370", "Голямо\ градище",
"3596982", "Ъглен",
"3593029", "Петково\,\ Смол\.",
"3594357", "Горно\ Сахране",
"3594108", "Васил\ Левски\,\ Ст\.\ Загора",
"3596076", "Таймище",
"3595919", "Маринка",
"35967396", "Бериево",
"35931403", "Триводици",
"3593748", "Лясковец\,\ Хаск\.",
"359537", "Нови\ пазар\,\ Шумен",
"3598140", "Борово\,\ Русе",
"3599183", "Лиляче",
"35951104", "Долище\,\ Варна",
"3596146", "Полски\ Сеновец",
"3599542", "Смоляновци",
"35981461", "Каран\ Върбовка",
"3593701", "Елена\,\ Хаск\.",
"3593642", "Поточница",
"35974202", "Ключ",
"35967305", "Стоките",
"3593775", "Генералово",
"3595751", "Тервел\,\ Добр\.",
"3596549", "Санадиново",
"35984736", "Подайва",
"3596039", "Опака",
"3598696", "Суходол\,\ Силистра",
"3593783", "Свирково",
"3593702", "Царева\ поляна",
"3599541", "Доктор\ Йосифово",
"3598694", "Зебил",
"3593641", "Крумовград",
"3593165", "Караджалово",
"3595752", "Нова\ Камена",
"3594583", "Кипилово",
"35967392", "Яворец",
"3593019", "Писаница",
"3597187", "Буново\,\ София",
"3599175", "Остров",
"35967398", "Дамяново",
"3594142", "Трояново\,\ Ст\.\ Загора",
"3595349", "Студеница",
"3596144", "Долна\ Липница",
"359971", "Лом",
"3598669", "Гарван\,\ Силистра",
"35931393", "Войнягово",
"3596921", "Абланица\,\ Ловеч",
"359318", "Съединение\,\ Пловдив",
"3594346", "Голямо\ Дряново",
"3595102", "Падина\,\ Варна",
"3595765", "Ловчанци",
"35967304", "Крамолин",
"3593520", "Мирянци",
"3596733", "Кормянско",
"3593325", "Червен\,\ Пловдив",
"3596964", "Велчево\,\ Ловеч",
"3599113", "Мраморен",
"3599349", "Сланотрън",
"3594513", "Гавраилово",
"3596966", "Шипково",
"3597729", "Долна\ Диканя",
"3593151", "Раковски\,\ Пловдив",
"3597117", "Градец\,\ София",
"3596922", "Лешница\,\ Ловеч",
"3593713", "Динево",
"3597145", "Мирово\,\ София",
"3595101", "Дъбравино",
"3596937", "Соколово\,\ Ловеч",
"3594795", "Скалица",
"3594344", "Шаново",
"3597048", "Блажиево",
"3594799", "Голям\ манастир",
"3595576", "Лозарево",
"359861", "Силистра",
"3593196", "Дрангово\,\ Пловдив",
"3597149", "Живково\,\ София",
"3599317", "Арчар",
"35965165", "Писарово\,\ Плевен",
"3597725", "Кленовик",
"35931709", "Михилци",
"3597106", "Ямна",
"3599345", "Винарово\,\ Видин",
"3599540", "Белотинци",
"3597546", "Слащен",
"3598142", "Бъзовец\,\ Русе",
"35931308", "Богдан\,\ Пловдив",
"3597036", "Баланово",
"3594140", "Полски\ Градец",
"3596587", "Петокладенци",
"3597104", "Лъга",
"3598448", "Тертер",
"3597034", "Джерман",
"3593073", "Старцево",
"35981266", "Стърмен\,\ Русе",
"3595750", "Каблешково\,\ Добр\.",
"3595769", "Хитово",
"3597544", "Осина",
"3594338", "Крън",
"35951103", "Любен\ Каравелово",
"3593700", "Тракиец",
"35961108", "Плаково",
"3595574", "Съединение\,\ Бургас",
"35959409", "Череша",
"35931395", "Иганово",
"3595718", "Смолница",
"35971506", "Габра",
"35941336", "Яздач",
"3598665", "Искра\,\ Силистра",
"3598141", "Две\ могили",
"3593194", "Зелениково\,\ Пловдив",
"35961102", "Пчелище",
"3593522", "Гелеменово",
"3593118", "Садово\,\ Пловдив",
"3597754", "Кошарево",
"3593566", "Бошуля",
"3595345", "Развигорово",
"3595100", "Синдел",
"35969241", "Йоглав",
"3594737", "Синапово",
"35991180", "Лесура",
"3593676", "Бенковски\,\ Кърдж\.",
"35971337", "Калугерово\,\ София",
"35965617", "Искър\,\ Плевен",
"3593537", "Панагюрски\ колонии",
"35934", "Пазарджик",
"3595317", "Ивански",
"3594722", "Гранитово\,\ Ямбол",
"3596724", "Янтра\,\ Габр\.",
"359868", "Силистра",
"35951125", "Константиново\,\ Варна",
"35957308", "Чернооково\,\ Добр\.",
"35967303", "Батошево",
"3596545", "Любеново\,\ Плевен",
"35963569", "Каменец\,\ Плевен",
"3596035", "Паламарца",
"3593521", "Звъничево",
"3593674", "Самодива",
"3596726", "Скалско",
"3596138", "Недан",
"3594764", "Маленово",
"3593779", "Сива\ река",
"359306", "Рудозем",
"3593564", "Семчиново",
"3596920", "Лесидрен",
"35931394", "Васил\ Левски\,\ Пловдив",
"3596517", "Подем",
"3597918", "Ябълково\,\ Кюст\.",
"3593749", "Гарваново",
"3595756", "Божан",
"35941112", "Старозагорски\ бани",
"359953", "Берковица",
"35991186", "Баурене",
"3595918", "Русокастро",
"35941118", "Остра\ могила\,\ Ст\.\ Загора",
"3596575", "Телиш",
"3594146", "Диня",
"3598691", "Силистра",
"3599544", "Студено\ буче",
"3593644", "Егрек",
"3593028", "Арда",
"3594109", "Тракия",
"3596141", "Полски\ Тръмбеш",
"3599313", "Капитановци",
"3593706", "Тънково\,\ Хаск\.",
"3595969", "Гълъбец\,\ Бургас",
"3593125", "Ръжево\ Конаре",
"3597925", "Гюешево",
"3593190", "Върбен\,\ Пловдив",
"3593704", "Брягово\,\ Хаск\.",
"3598692", "Стефан\ Караджа\,\ Силистра",
"35935392", "Дюлево\,\ Пазарджик",
"3599149", "Буковец\,\ Враца",
"3595570", "Манолич",
"3599725", "Комощица",
"3597030", "Ресилово",
"3595754", "Зърнево",
"3596583", "Белене",
"35936401", "Странджево",
"3593077", "Средец\,\ Смол\.",
"3594144", "Ковачево\,\ Ст\.\ Загора",
"3599546", "Славотин",
"3593646", "Токачка",
"3596955", "Дълбок\ дол",
"35963567", "Градина\,\ Плевен",
"3596142", "Обединение",
"3593043", "Змеица",
"3596720", "Керека",
"3593533", "Бъта",
"359707", "Сапарева\ баня",
"35930413", "Девин",
"3593154", "Чалъкови",
"3595313", "Мадара",
"3597718", "Драгичево",
"35931707", "Черноземен",
"3598138", "Бръшлен",
"35971227", "Бели\ Искър",
"359331", "Асеновград",
"3598431", "Исперих",
"3596926", "Горно\ Павликене",
"3596962", "Черни\ Осъм",
"3594733", "Орлов\ дол",
"3594341", "Черганово",
"3597439", "Плоски",
"3597179", "Големо\ Малово",
"3595106", "Аврен\,\ Варна",
"35943616", "Турия",
"3596513", "Пордим",
"3593559", "Капитан\ Димитриево",
"35959407", "Сини\ рид",
"3598629", "Смилец\,\ Силистра",
"3594342", "Овощник",
"35941330", "Ценово\,\ Ст\.\ Загора",
"3593156", "Шишманци",
"3595149", "Голица",
"3595952", "Малко\ Търново",
"3595145", "Гроздьово",
"3598625", "Овен",
"35984776", "Хърсово\,\ Разград",
"3597541", "Сатовча",
"3597031", "Горна\ Козница",
"3595538", "Караново\,\ Бургас",
"3594755", "Тамарино",
"35961606", "Владислав",
"3593555", "Нова\ махала\,\ Пазарджик",
"3599187", "Лютаджик",
"3595571", "Сунгурларе",
"3598144", "Батишница",
"3593191", "Брезово\,\ Пловдив",
"3597175", "Габер",
"3595117", "Ботево\,\ Варна",
"3597435", "Склаве",
"3594587", "Ябланово",
"3597102", "Лопян",
"3597183", "Душанци",
"3597032", "Яхиново",
"3595572", "Бероново",
"3598690", "Силистра",
"35930415", "Девин",
"3593787", "Тянево\,\ Хаск\.",
"3593192", "Бабек",
"3593524", "Априлци\,\ Пазарджик",
"3596959", "Дебнево",
"3593671", "Подкова",
"3597752", "Режанци",
"3596960", "Белиш",
"3596737", "Крушево\,\ Габр\.",
"3599729", "Расово",
"3594761", "Стралджа",
"3599117", "Криводол",
"3599145", "Бреница\,\ Враца",
"3596174", "Драганово\,\ В\.\ Търново",
"3593561", "Септември",
"3594724", "Раздел\,\ Ямбол",
"3597929", "Соволяно",
"3593638", "Звездел",
"35930458", "Любча",
"35984730", "Голям\ Поровец",
"3596722", "Соколово\,\ Габр\.",
"35947201", "Изгрев\,\ Ямбол",
"35960372", "Крепча",
"3593717", "Конуш\,\ Хаск\.",
"3596176", "Поликраище",
"3594340", "Паничерево",
"3597751", "Брезник",
"3593129", "Скутаре",
"3593672", "Чорбаджийско",
"3594762", "Воденичане",
"35931387", "Пролом",
"3596933", "Голец",
"3594726", "Маломирово",
"3594138", "Гита",
"3594105", "Бяло\ поле",
"35960378", "Цар\ Асен\,\ Търг\.",
"3596579", "Рупци\,\ Плевен",
"3593562", "Славовица\,\ Пазарджик",
"3593526", "Динката",
"3594517", "Ичера",
"3593745", "Малък\ извор\,\ Хаск\.",
"35930414", "Девин",
"3596712", "Гъбене",
"3596536", "Аспарухово\,\ Плевен",
"3599132", "Кнежа",
"35971587", "Голема\ Раковица",
"3596046", "Врани\ кон",
"3594714", "Дражево",
"35947356", "Мрамор\,\ Ямбол",
"3593343", "Козаново",
"3596567", "Сомовит",
"3599127", "Лютидол",
"3595334", "Осмар",
"3599719", "Аспарухово\,\ Монт\.",
"35930456", "Чавдар\,\ Смол\.",
"3593778", "Студена\,\ Хаск\.",
"35930417", "Грохотно",
"35931703", "Житница\,\ Пловдив",
"359301", "Смолян",
"3593923", "Радиево",
"3593514", "Черногорово\,\ Пазарджик",
"3597123", "Ковачевци\,\ София",
"35960376", "Люблен",
"3599131", "Добролево",
"35963202", "Драгомирово\,\ В\.\ Търново",
"3595336", "Имренчево",
"3596711", "Кози\ рог",
"35937603", "Рогозиново",
"3594527", "Загорци\,\ Сливен",
"3593516", "Црънча\,\ Пазарджик",
"35935418", "Кръстава",
"3593168", "Езерово\,\ Пловдив",
"3598673", "Алфатар",
"35967390", "Шумата",
"3594716", "Веселиново\,\ Ямбол",
"3596044", "Долно\ Козарево",
"3596534", "Малчика",
"3595367", "Тодор\ Икономово",
"3596153", "Златарица",
"359610", "Павликени\,\ В\.\ Търново",
"3593119", "Гълъбово\,\ Пловдив",
"3593727", "Нова\ Надежда",
"35959403", "Речица",
"3595719", "Дончево",
"3595127", "Манастир\,\ Варна",
"3593052", "Лъки\,\ Пловдив",
"3593584", "Ветрен\,\ Пазарджик",
"359308", "Мадан\,\ Смол\.",
"35984778", "Богданци\,\ Разград",
"3598647", "Паисиево",
"35969031", "Галата",
"3597442", "Якоруда",
"35941351", "Партизанин",
"3595132", "Михалич\,\ Варна",
"35961602", "Царски\ извор",
"3595768", "Одринци\,\ Добр\.",
"3594339", "Юлиево",
"359675", "Севлиево",
"359724", "Ихтиман",
"35961608", "Горски\ Сеновец",
"3593328", "Долнослав",
"3593051", "Чепеларе",
"35967309", "Агатово",
"35963563", "Борислав",
"3599336", "Старопатица",
"3593586", "Боримечково",
"3597148", "Мухово",
"3595131", "Вълчи\ дол",
"3594798", "Савино",
"3596907", "Градежница",
"3594353", "Средногорово",
"3597045", "Голем\ Върбовник",
"35961503", "Чакали",
"3597167", "Церово\,\ София",
"3595943", "Вресово",
"3596916", "Брестово\,\ Ловеч",
"35959404", "Ясеново\,\ Бургас",
"3599348", "Неговановци",
"3597136", "Новачене\,\ София",
"3597728", "Друган",
"3595323", "Плиска",
"3593934", "Скобелево\,\ Хаск\.",
"3599557", "Горно\ Церовене",
"3593657", "Жълтуша",
"35976", "Перник",
"3596710", "Донино",
"35963565", "Мечка\,\ Плевен",
"3593763", "Българин",
"35991888", "Веслец\,\ Враца",
"35937604", "Върбово\,\ Хаск\.",
"3599130", "Тлачене",
"3598445", "Юпер",
"3595747", "Ваклино",
"35931704", "Иван\ Вазово",
"3597134", "Врачеш",
"3593173", "Паничери",
"359750", "Боровец\,\ София",
"3593936", "Горски\ извор\,\ Хаск\.",
"3594335", "Ръжена",
"3594157", "Разделна\,\ Ст\.\ Загора",
"3596914", "Сливек",
"3599163", "Хърлец",
"3596523", "Крушовица\,\ Плевен",
"359359", "Велинград",
"35953223", "Църквица",
"3599785", "Василовци\,\ Монт\.",
"35971224", "Шипочане",
"3598668", "Попина",
"3595715", "Попгригорово",
"359517", "Дългопол",
"3593115", "Куклен",
"3597743", "Дивля",
"3599323", "Дреновец",
"3595348", "Трем",
"35991188", "Галатин",
"35941116", "Сладък\ Кладенец",
"35991182", "Осен\,\ Враца",
"35931792", "Черничево\,\ Пловдив",
"35959405", "Зайчар",
"3595130", "Генерал\ Киселово",
"3595557", "Бистрец\,\ Бургас",
"3596998", "Голям\ извор\,\ Ловеч",
"35963564", "Биволаре",
"35938", "Хасково",
"3596072", "Добротица\,\ Търг\.",
"3595773", "Лозенец\,\ Добр\.",
"359457", "Нова\ Загора",
"3593050", "Букова\ поляна",
"3593147", "Ново\ село\,\ Пловдив",
"3596986", "Дъбен",
"3596548", "Дебово",
"3595163", "Млада\ гвардия",
"35931705", "Горна\ махала",
"3596135", "Върбовка",
"3596984", "Бежаново\,\ Ловеч",
"3599747", "Мокреш\,\ Монт\.",
"35971225", "Ново\ село\,\ София",
"3593693", "Лясково\,\ Кърдж\.",
"3596071", "Антоново",
"3597915", "Невестино\,\ Кюст\.",
"35941175", "Колена",
"3595119", "Игнатиево",
"3595727", "Сенокос\,\ Добр\.",
"3599189", "Паволче",
"35984467", "Сеслав",
"35984749", "Севар",
"3596543", "Муселиево",
"3595732", "Петлешково",
"3595516", "Индже\ войвода",
"3596033", "Медовина",
"3595168", "Петров\ дол\,\ Варна",
"35984769", "Гороцвет",
"35947202", "Жребино",
"35961309", "Горско\ Калугерово",
"3599328", "Долни\ Лом",
"3595731", "Генерал\ Тошево\,\ Добр\.",
"3595343", "Венец\,\ Шумен",
"3596060", "Овчарово\,\ Търг\.",
"35974386", "Пирин",
"3596112", "Самоводене",
"3597927", "Трекляно",
"3599168", "Бутан",
"3596528", "Вълчитрън",
"3599516", "Лехчево",
"35941356", "Рупките",
"3598663", "Ситово\,\ Силистра",
"35941174", "Подслон\,\ Ст\.\ Загора",
"35995277", "Черкаски",
"3599727", "Медковец",
"3597932", "Шипочано",
"3593178", "Красново",
"3599119", "Тишевица",
"3596957", "Голяма\ Желязна",
"3593075", "Долен\,\ Смол\.",
"35937703", "Димитровче",
"3599343", "Гомотарци",
"3594519", "Самуилово\,\ Сливен",
"3597723", "Долни\ Раковец",
"35931603", "Виница",
"3598630", "Силистра",
"3596111", "Къпиново\,\ В\.\ Търново",
"3595328", "Никола\ Козлево",
"35941489", "Боздуганово",
"3593132", "Баня\,\ Пловдив",
"3596577", "Бресте",
"3593768", "Доситеево",
"3594116", "Ракитница\,\ Ст\.\ Загора",
"3599514", "Владимирово\,\ Монт\.",
"3595948", "Снягово\,\ Бургас",
"35941277", "Загоре",
"3593719", "Книжовник",
"359670", "Троян\,\ Ловеч",
"3593127", "Царацово",
"3597143", "Вакарел",
"3595967", "Бата",
"35960380", "Дриново",
"3596061", "Голямо\ Соколово",
"3594793", "Бояджик",
"35963570", "Староселци",
"359559", "Карнобат",
"3597054", "Рила",
"3594358", "Скобелево\,\ Ст\.\ Загора",
"3594107", "Средец\,\ Ст\.\ Загора",
"35931605", "Буково\,\ Пловдив",
"3596024", "Руец",
"35971306", "Рашково",
"3594515", "Мокрен",
"3593747", "Татарево\,\ Хаск\.",
"35962", "Велико\ Търново",
"3596062", "Стража\,\ Търг\.",
"3593079", "Козарка",
"3595763", "Плачидол",
"3596026", "Макариополско",
"35935254", "Добровница",
"35937705", "Пъстрогор",
"3599115", "Чирен",
"3593323", "Болярци\,\ Пловдив",
"3599147", "Борован",
"35971471", "Очуша",
"35930256", "Гълъбово\,\ Смол\.",
"35930472", "Михалково",
"3598184", "Глоджево",
"3597056", "Мурсалево",
"35941111", "Старозагорски\ бани",
"3598678", "Срацимир\,\ Силистра",
"3594585", "Жеравна",
"3599173", "Галово",
"3596158", "Средни\ колиби",
"3597930", "Еремия",
"35984727", "Каменово\,\ Разград",
"3598116", "Иваново\,\ Русе",
"3598631", "Силистра",
"3593785", "Дряново\,\ Хаск\.",
"35931604", "Драгойново",
"35951539", "Левски\,\ Варна",
"3593163", "Искра\,\ Пловдив",
"3598114", "Пиргово",
"3597734", "Главановци\,\ Перник",
"3593773", "Капитан\ Андреево",
"35935255", "Росен\,\ Пазарджик",
"3595147", "Пчелник\,\ Варна",
"35937704", "Младиново",
"35984717", "Побит\ камък\,\ Разград",
"3598627", "Бабук",
"3597422", "Тополница\,\ Благ\.",
"3594757", "Недялско",
"3593928", "Долно\ Белево",
"35958", "Добрич",
"35935391", "Блатница",
"35936402", "Горна\ кула",
"3593130", "Каравелово\,\ Пловдив",
"3599185", "Бели\ Извор",
"3593557", "Бяга",
"35941173", "Братя\ Кунчеви",
"3597437", "Мелник",
"3595115", "Генерал\ Кантарджиево",
"359722", "Самоков",
"3597177", "Алдомировци",
"3593348", "Добралък",
"3598632", "Зафирово",
"3599559", "Горна\ Ковачица",
"3599560", "Безденица",
"3593754", "Лозен\,\ Хаск\.",
"3594770", "Генерал\ Инзово",
"35969240", "Хлевене",
"3597522", "Дъбница",
"3597118", "Драговищица\,\ София",
"35931791", "Бегово",
"35937707", "Щит",
"3594554", "Трапоклово",
"3596552", "Долна\ Митрополия",
"3595351", "Смядово",
"3596905", "Дивчовото",
"35974347", "Раздол",
"3597169", "Томпсън",
"3596938", "Каленик\,\ Ловеч",
"3597047", "Усойка",
"35936700", "Шопци",
"359721", "Костинброд",
"3594556", "Сотиря",
"3595125", "Градинарово",
"3597521", "Копривлен",
"3598645", "Межден",
"3593633", "Рогозче",
"3598161", "Ветово",
"35947193", "Могила\,\ Ямбол",
"3595352", "Янково",
"359538", "Велики\ Преслав",
"3596551", "Тръстеник\,\ Плевен",
"3598124", "Новград",
"3595749", "Крапец\,\ Добр\.",
"3593756", "Вълче\ поле",
"35935257", "Сарая",
"35984463", "Прелез",
"3599351", "Извор\,\ Видин",
"3594525", "Омарчево\,\ Сливен",
"3593149", "Цалапица",
"3594746", "Попово\,\ Ямбол",
"3593036", "Могилица",
"3595559", "Кубадин",
"3597188", "Петрич\,\ София",
"3595365", "Лятно",
"35971302", "Боженица",
"35960454", "Змейно",
"3593725", "Стамболийски\,\ Хаск\.",
"3593106", "Строево",
"3593544", "Костандово",
"3593034", "Левочево",
"3599352", "Дружба",
"359938", "Кула",
"359745", "Петрич\,\ Благ\.",
"3599749", "Черни\ връх\,\ Монт\.",
"3593104", "Ягодово\,\ Пловдив",
"35984725", "Киченица",
"3596359", "Глава",
"3599125", "Горна\ Бешовица",
"3596565", "Милковица",
"35930476", "Селча",
"3594744", "Голямо\ Крушево",
"3595533", "Пирне",
"359728", "Златица",
"35941358", "Опълченец",
"3597152", "Горна\ Малина",
"3596007", "Ралица",
"3599129", "Синьо\ бърдо",
"3596569", "Ленково",
"3596137", "Бутово",
"35941352", "Винарово\,\ Ст\.\ Загора",
"35969032", "Български\ извор",
"3596550", "Ставерци",
"3594772", "Симеоново\,\ Ямбол",
"35941274", "Самуилово\,\ Ст\.\ Загора",
"3599745", "Златия\,\ Монт\.",
"3597520", "Корница",
"35941019", "Венец\,\ Ст\.\ Загора",
"3598159", "Кошов",
"3593626", "Перперек",
"3599526", "Слатина\,\ Монт\.",
"3596166", "Виноград",
"3594124", "Змейово",
"3596518", "Рибен",
"35967774", "Белица\,\ Габр\.",
"3596122", "Беляковец",
"3597917", "Таваличево",
"3593662", "Железино",
"35984723", "Дянково",
"3593117", "Катуница",
"3593729", "Криво\ поле",
"3599524", "Ягодово\,\ Монт\.",
"3593624", "Чифлик\,\ Кърдж\.",
"3596164", "Бряговица",
"35930205", "Стърница",
"35931627", "Крушево\,\ Пловдив",
"3595555", "Факия",
"3594738", "Хлябово",
"3594126", "Хрищени",
"35984465", "Савин",
"3593538", "Елшица",
"3594771", "Маломир\,\ Ямбол",
"35984713", "Благоево\,\ Разград",
"3595318", "Средня",
"3593661", "Ивайловград",
"3599561", "Сумер",
"3596121", "Никюп",
"3597713", "Рударци",
"3593145", "Кричим",
"3598133", "Ряхово",
"3594529", "Съдиево\,\ Сливен",
"3596588", "Деков",
"3595394", "Бяла\ река\,\ Шумен",
"3595745", "Вранино",
"3595526", "Кликач",
"3594155", "Главан\,\ Ст\.\ Загора",
"3596944", "Крушуна",
"3594337", "Ясеново\,\ Ст\.\ Загора",
"3598649", "Яребица",
"3599787", "Смирненски\,\ Монт\.",
"3595717", "Ведрина",
"35951429", "Солник",
"3594322", "Ягода",
"3595129", "Блъсково",
"35941275", "Лясково\,\ Ст\.\ Загора",
"3596324", "Вардим",
"3597165", "Миланово\,\ София",
"3593023", "Момчиловци",
"359391", "Димитровград",
"35960453", "Моравка",
"3596909", "Малка\ Желязна",
"3594592", "Бяла\ паланка",
"3596326", "Морава",
"3594364", "Осетеново",
"35961706", "Писарево\,\ В\.\ Търново",
"3599318", "Буковец\,\ Видин",
"35974388", "Горно\ Спанчево",
"3595396", "Ловец\,\ Шумен",
"3595524", "Екзарх\ Антимово",
"3595913", "Крушевец",
"35984464", "Веселец\,\ Разград",
"3599555", "Копиловци\,\ Монт\.",
"3596946", "Чавдарци",
"3594321", "Мъглиж",
"35961406", "Каранци",
"3593349", "Боянци",
"3598164", "Писанец",
"3593752", "Малко\ градище",
"35981466", "Помен",
"3597524", "Абланица\,\ Благ\.",
"3597913", "Рашка\ Гращица",
"359702", "Бобов\ дол",
"3593695", "Комунига",
"3596770", "Плачковци",
"3594552", "Стара\ река\,\ Сливен",
"35984764", "Сейдол",
"3595783", "Котленци",
"3595165", "Невша",
"3596554", "Крушовене",
"3593929", "Голямо\ Асеново",
"359605", "Омуртаг",
"3596003", "Преселец",
"3596133", "Михалци",
"35974327", "Ново\ Делчево",
"35961304", "Димча",
"3596556", "Горна\ Митрополия",
"35993342", "Киреево",
"35984744", "Беловец",
"3597129", "Радуил",
"35967193", "Кметовци",
"3597717", "Дивотино",
"35930528", "Манастир\,\ Пловдив",
"3598137", "Голямо\ Враново",
"3595775", "Полковник\ Дяково",
"3593751", "Любимец",
"3598477", "Самуил",
"3599325", "Бело\ поле\,\ Видин",
"3596159", "Златарица",
"3597745", "Егълница",
"3593113", "Браниполе",
"3595354", "Риш",
"3599520", "Горно\ Озирово",
"3594551", "Бяла\,\ Сливен",
"3597526", "Рибново",
"3598679", "Кайнарджа",
"3598122", "Ценово\,\ Русе",
"3598166", "Сваленик",
"3599165", "Софрониево",
"3596525", "Бъркач",
"3599783", "Брусарци",
"3595713", "Стефаново\,\ Добр\.",
"3593101", "Войводиново",
"35941484", "Землен",
"3599356", "Каленик\,\ Видин",
"3593175", "Дълго\ поле\,\ Пловдив",
"35961305", "Лесичери",
"35984765", "Веселина",
"3594333", "Дъбово\,\ Ст\.\ Загора",
"3594741", "Болярово",
"3593542", "Ракитово",
"3595520", "Черково",
"3595325", "Войвода",
"3593032", "Средногорци",
"3599354", "Антимово\,\ Видин",
"3593102", "Караджово",
"3595917", "Извор\,\ Бургас",
"35984745", "Владимировци",
"3593765", "Иваново\,\ Хаск\.",
"359518", "Провадия",
"3593027", "Славейно",
"3597192", "Гинци",
"3594359", "Асен\,\ Ст\.\ Загора",
"3595945", "Добромир",
"3594742", "Стефан\ Караджово",
"3596590", "Ракита\,\ Плевен",
"35941179", "Хан\ Аспарухово",
"3593718", "Войводово\,\ Хаск\.",
"35960382", "Ковачевец",
"35963578", "Опанец\,\ Плевен",
"3597154", "Столник",
"3596161", "Стражица\,\ В\.\ Търново",
"3599521", "Замфирово",
"3597533", "Осиково\,\ Благ\.",
"3595949", "Планиница\,\ Бургас",
"3597043", "Големо\ село",
"3594137", "Верен",
"3594355", "Бузовград",
"35963572", "Ясен\,\ Плевен",
"35960388", "Горица\,\ Търг\.",
"35967194", "Гръблевци",
"35974495", "Юруково",
"3594774", "Крумово\,\ Ямбол",
"3593769", "Орешец\,\ Хаск\.",
"3594518", "Тополчане",
"3594122", "Еленино",
"35984743", "Брестовене",
"359749", "Банско",
"3595329", "Мировци",
"3599564", "Стубел",
"3593664", "Плевун",
"3596124", "Леденик",
"3595599", "Хаджиите",
"35961303", "Горна\ Липница",
"35984763", "Бели\ Лом",
"3596738", "Добромирка",
"3593666", "Попско",
"3596126", "Церова\ кория",
"3599522", "Котеновци",
"3593622", "Стремци",
"3597156", "Равно\ поле",
"35974402", "Годлево",
"35994", "Видин",
"3593637", "Груево",
"3596529", "Коиловци",
"3599169", "Рогозен",
"35941331", "Гранит",
"35974408", "Обидим",
"3594121", "Люляк",
"3594588", "Филаретово",
"3598675", "Айдемир",
"3595392", "Менгишево",
"3596591", "Горник",
"35931997", "Златосел",
"3596155", "Константин",
"3599329", "Рабиша",
"3596942", "Александрово\,\ Ловеч",
"3594361", "Павел\ баня",
"35977229", "Гълъбник",
"3597125", "Говедарци",
"3594324", "Шипка",
"3595521", "Венец\,\ Бургас",
"35969616", "Старо\ село\,\ Ловеч",
"3596322", "Алеково\,\ В\.\ Търново",
"35954", "Шумен",
"3595391", "Върбица\,\ Шумен",
"3594362", "Манолово",
"3596941", "Летница",
"3594326", "Енина",
"3593925", "Крум",
"3595537", "Съдиево\,\ Бургас",
"3595169", "Момчилово",
"3593100", "Белащица",
"3593699", "Габрово\,\ Кърдж\.",
"3599188", "Горно\ Пещене",
"3596321", "Горна\ Студена",
"3595522", "Искра\,\ Бургас",
"3595118", "Водица\,\ Варна",
"3592", "София",
"3593030", "Широка\ лъка",
"3593345", "Лясково\,\ Пловдив",
"35951537", "Чернево",
"3595511", "Лукойл\ Нефтохим",
"35969248", "Скобелево\,\ Ловеч",
"3596020", "Лиляк",
"359777", "Радомир",
"35971798", "Василовци\,Соф\.",
"35969242", "Пресяка",
"3593743", "Силен",
"3595734", "Преселенци",
"3597147", "Пчелин\,\ София",
"35984729", "Езерче",
"3599319", "Гъмзово",
"3596935", "Сопот\,\ Ловеч",
"3594797", "Гълъбинци",
"35936702", "Горски\ извор\,\ Кърдж\.",
"35978", "Кюстендил",
"3596908", "Глогово",
"35969612", "Терзийско\,\ Ловеч",
"3594103", "Бял\ извор\,\ Ст\.\ Загора",
"3599143", "Еница",
"3595128", "Житница\,\ Варна",
"3595736", "Василево",
"3598648", "Секулово",
"35937423", "Големанци",
"3595767", "Житница\,\ Добр\.",
"35984719", "Балкански",
"35982", "Русе",
"3596589", "Кулина\ вода",
"3593327", "Бачково",
"3596114", "Килифарево",
"35960386", "Водица\,\ Търг\.",
"3595319", "Друмево",
"3594112", "Бъдеще",
"3594528", "Любенова\ махала",
"3593049", "Беден",
"35974323", "Лозеница",
"35963576", "Тученица",
"3593167", "Брягово\,\ Пловдив",
"359848", "Кубрат",
"3597934", "Буново\,\ Кюст\.",
"3597185", "Челопеч",
"3595368", "Тъкач",
"3594739", "Радовец",
"35984393", "Вазово",
"3593136", "Розино\,\ Пловдив",
"3593728", "Славяново\,\ Хаск\.",
"3597936", "Слокощица",
"35931995", "Стрелци\,\ Пловдив",
"3596519", "Беглеж",
"3593553", "Батак\,\ Пазарджик",
"359350", "Пещера\,\ Пазарджик",
"3597433", "Кресна",
"3593134", "Сопот\,\ Пловдив",
"3598158", "Мечка\,\ Русе",
"3596568", "Дъбован",
"3599128", "Елисейна",
"3599512", "Бели\ брег",
"35974406", "Добърско",
"3596116", "Големаните",
"3593777", "Мезек",
"3595143", "Бяла\,\ Варна",
"35931258", "Главатар",
"35961101", "Велчево\,\ В\.\ Търново",
"3598623", "Голеш\,\ Силистра",
"3594753", "Зорница\,\ Ямбол",
"359470", "Тополовград",
"3596547", "Драгаш\ войвода",
"3597052", "Пастра",
"35941350", "Мирово\,\ Ст\.\ Загора",
"3599748", "Дългоделци",
"3596022", "Пробуда\,\ Търг\.",
"35937424", "Козлец",
"35931993", "Сърнегор",
"3596066", "Буйново\,\ Търг\.",
"3595723", "Гурково\,\ Добр\.",
"35942", "Стара\ Загора",
"3596515", "Славяново\,\ Плевен",
"3596064", "Голямо\ Ново",
"3595347", "Живково\,\ Шумен",
"35941279", "Стрелец\,\ Ст\.\ Загора",
"3596997", "Добревци\,\ Ловеч",
"3595558", "Дебелт",
"3597189", "Чавдар\,\ София",
"3593045", "Доспат",
"3596021", "Буховци",
"3593535", "Левски\,\ Пазарджик",
"3595315", "Царев\ брод",
"35974325", "Лиляново",
"3593148", "Йоаким\ Груево",
"3597731", "Трън",
"3598111", "Щръклево",
"3599723", "Трайково",
"35961402", "Стефан\ Стамболово",
"3595748", "Дуранкулак",
"3596585", "Белене",
"359337", "Хисаря",
"3596953", "Борима",
"3598636", "Главиница\,\ Силистра",
"359726", "Своге",
"35981462", "Волово",
"35984469", "Божурово\,\ Разград",
"3594158", "Искрица",
"3597923", "Вратца",
"359936", "Белоградчик",
"359701", "Дупница",
"35974201", "Капатово",
"3598667", "Белица\,\ Силистра",
"3597426", "Марикостиново",
"35984394", "Духовец",
"3596939", "Драгана",
"3597168", "Бов",
"3597732", "Вукан",
"3595580", "Трояново\,\ Бургас",
"3593123", "Калояново\,\ Пловдив",
"359619", "Лясковец\,\ В\.\ Търново",
"3599315", "Градец\,\ Видин",
"3597424", "Кърналово",
"3599347", "Бела\ Рада",
"35974324", "Струма",
"35967391", "Столът",
"3597727", "Ковачевци\,\ Перник",
"35961307", "Стамболово\,\ В\.\ Търново",
"3597119", "Дръмша",
"3596573", "Койнаре",
"3599558", "Гаврил\ Геново",
"3593658", "Падина\,\ Кърдж\.",
"3598634", "Нова\ Черна",
"35935252", "Тополи\ дол",
"3593711", "Долно\ Ботево",
"3596065", "Бистра\,\ Търг\.",
"3594734", "Срем",
"3599528", "Гаганица",
"3593628", "Миладиново",
"3597939", "Църварица",
"3596168", "Сушица\,\ В\.\ Търново",
"3599112", "Баница",
"35935258", "Цар\ Асен\,\ Пазарджик",
"3596732", "Сенник",
"3596516", "Искър\,\ Плевен",
"3593534", "Попинци",
"35963579", "Ралево",
"3593044", "Лясково\,\ Смол\.",
"3596727", "Ганчовец",
"3594511", "Сливенски\ минерални\ бани",
"3596119", "Дичин",
"3595314", "Белокопитово",
"3593153", "Стряма",
"35960389", "Кардам\,\ Търг\.",
"3593677", "Дрангово\,\ Кърдж\.",
"3593046", "Барутин",
"3593536", "Баня\,\ Пазарджик",
"3593712", "Малево\,\ Хаск\.",
"3595316", "Салманово",
"3599111", "Челопек",
"35974409", "Места",
"35930257", "Вишнево",
"35947203", "Трънково\,\ Ямбол",
"3593567", "Ковачево\,\ Пазарджик",
"35961703", "Върбица\,\ В\.\ Търново",
"3596514", "Долни\ Дъбник",
"359601", "Търговище",
"3596923", "Горан",
"3594512", "Блатец\,\ Сливен",
"3594736", "Светлина",
"3599314", "Дунавци\,\ Видин",
"3597425", "Кулата",
"3594368", "Търничени",
"35937702", "Мустрак",
"35984726", "Ушинци",
"3595739", "Пчеларово\,\ Добр\.",
"35930475", "Стоманево",
"359915", "Бяла\ Слатина",
"35977222", "Горна\ Диканя",
"3599182", "Девене",
"35974348", "Игралище",
"3596586", "Белене",
"3598635", "Цар\ Самуил",
"3593643", "Голяма\ Чинка",
"3593781", "Симеоновград",
"3595528", "Невестино\,\ Бургас",
"3595112", "Белослав",
"359608", "Попово\,\ Търг\.",
"3596584", "Белене",
"359570", "Каварна",
"3595753", "Орляк",
"3594582", "Градец\,\ Сливен",
"3597547", "Вълкосел",
"3596948", "Кърпачево",
"3594143", "Сърнево\,\ Ст\.\ Загора",
"3595577", "Подвис\,\ Бургас",
"3599181", "Краводер",
"35931602", "Татарево\,\ Пловдив",
"3593197", "Тюркмен",
"3596328", "Ореш",
"3593782", "Калугерово\,\ Хаск\.",
"3599316", "Ново\ село\,\ Видин",
"3593703", "Жълти\ бряг",
"35961704", "Правда\,\ В\.\ Търново",
"35952", "Варна",
"3596173", "Долна\ Оряховица",
"359860", "Силистра",
"35984740", "Бисерци",
"35947204", "Пчела",
"3594723", "Бояново\,\ Ямбол",
"3599110", "Вировско",
"35930411", "Девин",
"35984466", "Звънарци",
"3593523", "Синитево",
"359659", "Червен\ бряг",
"3596967", "Калейца",
"3598128", "Полско\ Косово",
"3597116", "Петърч",
"3598639", "Коларово\,\ Силистра",
"3594510", "Желю\ войвода",
"3593758", "Йерусалимово",
"3595735", "Красен\,\ Добр\.",
"35984760", "Трапище",
"3594347", "Розово\,\ Ст\.\ Загора",
"3596934", "Катунец",
"3593710", "Узунджово",
"3593038", "Чокманово",
"3597186", "Антон",
"3593548", "Пашово",
"3599180", "Голямо\ Пещене",
"35941357", "Зетьово\,\ Ст\.\ Загора",
"3593108", "Бойково",
"35995276", "Драганица",
"35961705", "Горски\ долен\ Тръмбеш",
"35973", "Благоевград",
"3598143", "Обретеник",
"3593135", "Кърнаре",
"35992", "Враца",
"3593071", "Златоград",
"3594748", "Воден\,\ Ямбол",
"359677", "Трявна",
"3596115", "Ресен",
"35941172", "Горно\ Ботево",
"35941178", "Оряховица\,\ Ст\.\ Загора",
"3598697", "Сокол\,\ Силистра",
"3597184", "Копривщица",
"3597935", "Долно\ село",
"35968", "Ловеч",
"3596147", "Иванча\,\ В\.\ Търново",
"35941276", "Могила\,\ Ст\.\ Загора",
"3593072", "Неделино",
"3596069", "Васил\ Левски\,\ Търг\.",
"3594580", "Боринци",
"35941480", "Коларово\,\ Ст\.\ Загора",
"359729", "Годеч",
"359361", "Кърджали",
"3598196", "Нисово",
"3595552", "Дюлево\,\ Бургас",
"359558", "Айтос",
"3593583", "Габровица",
"3599333", "Бойница",
"3599741", "Долни\ Цибър",
"3598640", "Правда\,\ Силистра",
"3593142", "Брестовица\,\ Пловдив",
"3595120", "Бозвелийско",
"3596077", "Стеврек",
"3594356", "Хаджидимитрово\,\ Ст\.\ Загора",
"3597155", "Лесново",
"35941354", "Малко\ Тръново",
"3596900", "Васильово",
"3594354", "Зимница\,\ Ст\.\ Загора",
"3596352", "Долни\ Луковит",
"3597058", "Стоб",
"3595551", "Средец\,\ Бургас",
"3599742", "Якимово",
"3594775", "Каравелово\,\ Ямбол",
"3596028", "Вардун",
"35937420", "Подкрепа",
"3596125", "Пушево",
"3593665", "Свирачи",
"3598194", "Сандрово",
"35947192", "Завой",
"3598118", "Николово\,\ Русе",
"3597126", "Горни\ Окол",
"3594595", "Сборище",
"3595333", "Хан\ Крум",
"3597162", "Лакатник",
"3596559", "Гостиля",
"3593924", "Крепост",
"3593513", "Мало\ Конаре",
"3596560", "Крета\,\ Плевен",
"3594713", "Стара\ река\,\ Ямбол",
"3598150", "Семерджиево",
"35984462", "Острово",
"3597529", "Брезница",
"3598676", "Ветрен\,\ Силистра",
"3596156", "Родина",
"35984", "Разград",
"3593344", "Новаково\,\ Пловдив",
"3599552", "Белимел",
"3593652", "Бял\ извор\,\ Кърдж\.",
"3593720", "Маджарово",
"3595742", "Раковски\,\ Добр\.",
"35953221", "Стоян\ Михайловски",
"3596533", "Стежерово",
"3596043", "Долно\ Новково",
"3598674", "Професор\ Иширково",
"359418", "Гълъбово\,\ Ст\.\ Загора",
"3594152", "Обручище",
"3596154", "Буйновци",
"3593346", "Мулдава",
"35941355", "Яворово",
"3597124", "Белчински\ бани",
"359631", "Свищов",
"3594520", "Коньово",
"3593651", "Ардино",
"3599551", "Георги\ Дамяново",
"3594325", "Кънчево",
"3593926", "Добрич\,\ Хаск\.",
"3595122", "Славейково\,\ Варна",
"3595518", "Рудник\,\ Бургас",
"3593057", "Пловдивци",
"35984728", "Раковски\,\ Разград",
"3595166", "Доброплодно",
"3594329", "Долно\ Сахране",
"3597447", "Добринище",
"3595774", "Коритен",
"35984722", "Ясеновец",
"35937706", "Чернодъб",
"3598642", "Дулово",
"35971398", "Осиковица",
"35977226", "Дебели\ лаг",
"3597415", "Селище\,\ Благ\.",
"3599324", "Ружинци",
"3595137", "Калоян",
"35969249", "Дойренци",
"3597744", "Еловдол\,\ Перник",
"35974346", "Цапарево",
"3596901", "Гложене\,\ Ловеч",
"35941353", "Плодовитово",
"3593696", "Пчеларово\,\ Кърдж\.",
"3599326", "Горни\ Лом",
"35984718", "Дряновец\,\ Разград",
"3595121", "Тутраканци",
"359746", "Сандански",
"3597525", "Баничан",
"3598641", "Окорш",
"35984712", "Костанденец",
"3598165", "Смирненски\,\ Русе",
"3599740", "Септемврийци\,\ Монт\.",
"3595164", "Неофит\ Рилски",
"3596555", "Байкал",
"35931606", "Воден\,\ Пловдив",
"3594599", "Червенаково",
"35963561", "Гривица",
"3596983", "Дерманци",
"3596902", "Рибарица\,\ Ловеч",
"3595776", "Черна\,\ Добр\.",
"3595324", "Хърсово\,\ Шумен",
"3599137", "Попица",
"3596129", "Габровци",
"3599569", "Липен",
"3599355", "Косово\,\ Видин",
"35935256", "Сбор\,\ Пазарджик",
"3593176", "Старосел",
"3596717", "Лесичарка",
"3599550", "Митровци",
"35931701", "Кръстевич",
"3593764", "Поляново\,\ Хаск\.",
"3598152", "Красен\,\ Русе",
"3594779", "Ханово",
"3593933", "Странско",
"3596526", "Върбица\,\ Плевен",
"3599166", "Хайредин",
"3594564", "Новоселец",
"3595944", "Руен\,\ Бургас",
"3596562", "Гиген",
"3599122", "Зверино",
"35971221", "Ярлово",
"3599518", "Мърчево",
"3595361", "Каолиново",
"3597159", "Априлово\,\ София",
"3593721", "Стамболово\,\ Хаск\.",
"3594118", "Памукчии\,\ Ст\.\ Загора",
"3594522", "Кортен",
"3596913", "Славяни",
"3596524", "Петърница",
"3599164", "Крушовица\,\ Враца",
"3594566", "Питово",
"3595946", "Трънак",
"3598151", "Просена",
"3593174", "Старо\ Железаре",
"3597133", "Правец",
"3595362", "Климент\,\ Шумен",
"3596561", "Гулянци",
"3599121", "Царевец\,\ Враца",
"35971304", "Липница\,\ София",
"3595326", "Върбяне",
"35944", "Сливен",
"3595740", "Горичане",
"3593722", "Минерални\ бани\,\ Хаск\.",
"3593766", "Бисер",
"35960458", "Веренци",
"3599746", "Разград\,\ Монт\.",
"3596068", "Божурка",
"3595133", "Генерал\ Колево\,\ Варна",
"3599525", "Долно\ Озирово",
"3593625", "Широко\ поле",
"3596165", "Асеново\,\ В\.\ Търново",
"3595554", "Момина\ църква",
"3599320", "Стакевци",
"3594351", "Копринка",
"3593053", "Хвойна",
"35974404", "Бабяк",
"35931401", "Кадиево",
"35963574", "Тодорово\,\ Плевен",
"3594749", "Ружица\,\ Ямбол",
"3594352", "Горно\ Черковище",
"35960384", "Гагово",
"3593146", "Куртово\ Конаре",
"3596987", "Карлуково",
"359973", "Козлодуй",
"3593109", "Лилково",
"3599744", "Вълчедръм",
"3593039", "Полковник\ Серафимово",
"3593549", "Грашево",
"3594125", "Михайлово\,\ Ст\.\ Загора",
"3595556", "Голямо\ Буково",
"3598192", "Хотанца",
"3598671", "Силистра",
"35931996", "Свежен",
"3597164", "Реброво",
"3597428", "Габрене",
"35969247", "Гостиня",
"3596151", "Елена\,\ В\.\ Търново",
"3593922", "Брод",
"35951538", "Изгрев\,\ Варна",
"3599133", "Комарево\,\ Враца",
"3593759", "Бориславци",
"35974405", "Краище\,\ Благ\.",
"3596713", "Враниловци",
"3595746", "Белгун",
"3593342", "Нареченски\ бани",
"3595320", "Пет\ могили\,\ Шумен",
"35953234", "Златна\ нива",
"3598638", "Богданци\,\ Силистра",
"3594156", "Априлово\,\ Ст\.\ Загора",
"3595525", "Деветак",
"3593937", "Ябълково\,\ Хаск\.",
"3599554", "Чипровци",
"3597137", "Скравена",
"3595395", "Чернооково\,\ Шумен",
"3598672", "Брадвари",
"3598129", "Лом\ Черковна",
"35961393", "Горско\ Косово",
"3595590", "Житосвят",
"35960385", "Ломци",
"3594154", "Медникарово",
"35963575", "Бохот",
"3599556", "Говежда",
"359618", "Горна\ Оряховица",
"3593921", "Меричлери",
"3596152", "Беброво",
"3597166", "Владо\ Тричков",
"359431", "Казанлък",
"3596917", "Българене\,\ Ловеч",
"3596325", "Козловец",
"3599160", "Гложене\,\ Враца",
"3596520", "Николаево\,\ Плевен",
"3593341", "Конуш\,\ Пловдив",
"3593587", "Сестримо",
"3595124", "Комарево\,\ Варна",
"3599337", "Грамада",
"3596329", "Царевец\,\ В\.\ Търново",
"3596906", "Черни\ Вит",
"3595772", "Телериг",
"3598644", "Чернолик",
"3593691", "Черноочeне",
"35961395", "Паскалевец",
"35960383", "Берковски",
"3595161", "Ветрино",
"35931108", "Богданица",
"3597742", "Калище",
"3599322", "Орешец\,\ Видин",
"35963573", "Дисевица",
"3598125", "Копривец",
"35974403", "Долно\ Драглище",
"359751", "Гоце\ Делчев",
"3595529", "Крушово\,\ Бургас",
"3595771", "Крушари",
"3593755", "Белица\,\ Хаск\.",
"35961302", "Батак\,\ В\.\ Търново",
"3597741", "Земен",
"3594350", "Горно\ Изворово",
"3595162", "Белоградец",
"3594369", "Александрово\,\ Ст\.\ Загора",
"35984768", "Синя\ вода",
"3595126", "Черковна\,\ Варна",
"3595738", "Спасово\,\ Добр\.",
"35951314", "Войводино",
"3598646", "Вокил",
"35961308", "Вишовград",
"3596521", "Садовец",
"3599161", "Мизия",
"3594717", "Чарган",
"3593035", "Върбина",
"3593340", "Нови\ извор",
"3594129", "Маджерито",
"3595366", "Браничево",
"3593545", "Драгиново",
"3593762", "Изворово\,\ Хаск\.",
"3593138", "Ведраре",
"3593726", "Клокотница",
"3593105", "Манолско\ Конаре",
"3595942", "Люляково\,\ Бургас",
"3594562", "Крива\ круша",
"3593920", "Златополе",
"3594526", "Млекарево",
"3599124", "Типченица",
"3595337", "Кочово",
"3596564", "Загражден\,\ Плевен",
"3593517", "Лесичово",
"35961394", "Дъскот",
"3594745", "Шарково",
"3594524", "Каменово\,\ Сливен",
"3596566", "Долни\ Вит",
"3599126", "Камено\ поле",
"3595321", "Правенци",
"3596118", "Вонеща\ вода",
"3596522", "Згалево",
"3599162", "Михайлово\,\ Враца",
"35931620", "Добри\ дол\,\ Пловдив",
"35991201", "Люти\ брод",
"3597120", "Долна\ баня",
"3597938", "Долно\ Уйно",
"3599529", "Боровци",
"3593629", "Мост",
"3596169", "Благоево\,\ В\.\ Търново",
"3596537", "Асеновци",
"3596047", "Зелена\ морава",
"3596150", "Златарица",
"3595941", "Скалак\,\ Бургас",
"3593724", "Сусам",
"3598156", "Червен\,\ Русе",
"35964", "Плевен",
"3598670", "Силистра",
"35941018", "Княжевско",
"3593527", "Алеко\ Константиново",
"3596963", "Балканец",
"359725", "Елин\ Пелин",
"3594732", "Устрем",
"3594516", "Кермен",
"3596734", "Петко\ Славейков",
"35969613", "Чифлик\,\ Ловеч",
"3593532", "Стрелча",
"3596177", "Янтра\,\ В\.\ Търново",
"3593042", "Борино",
"35941359", "Изворово\,\ Ст\.\ Загора",
"3598185", "Сеново",
"35969243", "Казачево",
"359748", "Симитли",
"3595312", "Дибич",
"3594727", "Малък\ манастир",
"3596511", "Победа\,\ Плевен",
"3595589", "Винарско",
"3597158", "Доганово",
"35961405", "Петко\ Каравелово",
"3596930", "Славщица",
"3594343", "Конаре\,\ Ст\.\ Загора",
"35981465", "Батин",
"3597110", "Опицвет",
"3596025", "Алваново",
"35967301", "Идилево",
"35961397", "Мусина",
"3594778", "Победа\,\ Ямбол",
"3596736", "Градница\,\ Габр\.",
"3596512", "Горни\ Дъбник",
"3596128", "Хотница",
"3599568", "Благово\,\ Монт\.",
"3595311", "Градище\,\ Шумен",
"35941270", "Малка\ Верея",
"3599116", "Костелево",
"3594514", "Крушаре",
"35937422", "Долни\ Главанак",
"3597735", "Лева\ река",
"3598115", "Червена\ вода",
"3596581", "Бяла\ вода\,\ Плевен",
"35930517", "Забърдо",
"3599312", "Брегово\,\ Видин",
"35951428", "Господиново\,\ Варна",
"35984392", "Белинци",
"3593786", "Навъсен",
"35930200", "Загражден\,\ Смол\.",
"3599184", "Оходен",
"359697", "Луковит",
"3594586", "Нейково\,\ Сливен",
"35974322", "Петрово\,\ Благ\.",
"3595114", "Езерово\,\ Варна",
"3598147", "Баниска",
"35981464", "Острица\,\ Русе",
"3596582", "Белене",
"3599186", "Згориград",
"3594584", "Тича",
"3595116", "Крумово\,\ Варна",
"3596143", "Масларево",
"3599311", "Кутово",
"35961306", "Патреш",
"3595519", "Зидарово",
"35984766", "Каменар\,\ Разград",
"3598693", "Звенимир",
"3593784", "Константиново\,\ Хаск\.",
"35951536", "Николаевка",
"3595515", "Камено",
"35931992", "Пъдарско",
"3595310", "Радко\ Димитриево",
"3593530", "Поибрене",
"35984720", "Топчии",
"35931998", "Чоба",
"3596723", "Царева\ ливада",
"359379", "Свиленград",
"3593040", "Триград",
"3593157", "Болярино",
"3597753", "Ноевци",
"3594730", "Княжево",
"3596931", "Угърчин",
"35969244", "Тепава",
"3598424", "Цар\ Калоян\,\ Разград",
"3596510", "Тотлебен",
"3593563", "Варвара\,\ Пазарджик",
"3597528", "Хаджидимово",
"3596927", "Умаревци",
"35984710", "Осенец",
"3593673", "Тихомир",
"3596558", "Славовица\,\ Плевен",
"35974496", "Филипово\,\ Благ\.",
"35969614", "Горно\ трапе",
"3594763", "Иречеково",
"359556", "Обзор",
"3596932", "Микре",
"35960387", "Глогинка",
"3599547", "Винище",
"3593647", "Черничево\,\ Кърдж\.",
"3593076", "Цацаровци",
"35935502", "Фотиново\,\ Пазарджик",
"35963577", "Пелишат",
"3596029", "Надарево",
"35961403", "Орловец",
"35959694", "Габерово",
"359590", "Царево",
"3597181", "Пирдоп",
"3599515", "Мадан\,\ Монт\.",
"35981463", "Могилино",
"359416", "Чирпан",
"3594115", "Кирилово\,\ Ст\.\ Загора",
"3595573", "Везенково",
"3593193", "Борец",
"35969245", "Деветаки",
"3593707", "Николово\,\ Хаск\.",
"35974407", "Кремен\,\ Благ\.",
"3597103", "Брусен\,\ София",
"359519", "Девня",
"3597182", "Мирково",
"3595757", "Безмер\,\ Добр\.",
"35960450", "Долна\ Хубавка",
"3596580", "Татари",
"35969615", "Балабанско",
"3593074", "Ерма\ река",
"3597033", "Крайници",
"3594147", "Любеново\,\ Ст\.\ Загора",
"359357", "Панагюрище",};
$areanames{en} = {"35930419", "Yagodina",
"3596981", "Petrevene",
"3596074", "Lyubichevo",
"3598643", "Zlatoklas",
"35984732", "Yonkovo",
"3599330", "Rabrovo",
"3599148", "Barkachevo",
"35984738", "Kitanchevo",
"3595123", "Ravna\,\ Varna",
"3593029", "Petkovo\,\ Smol\.",
"3596982", "aglen",
"3596076", "Taymishte",
"3594108", "Vasil\ Levski\,\ St\.\ Zagora",
"3594357", "Gorno\ Sahrane",
"35941146", "Hristianovo",
"35960370", "Golyamo\ gradishte",
"3595968", "Kableshkovo\,\ Burgas",
"359537", "Novi\ pazar\,\ Shumen",
"3593748", "Lyaskovets\,\ Hask\.",
"3595919", "Marinka",
"35931403", "Trivoditsi",
"35967396", "Berievo",
"3598628", "Tsar\ Asen\,\ Silistra",
"3595330", "Zlatar",
"3593927", "Chernogorovo\,\ Hask\.",
"3595535", "Lyaskovo\,\ Burgas",
"3596563", "Brest\,\ Pleven",
"3599123", "Roman",
"3595148", "Rudnik\,\ Varna",
"3593510", "Ovchepoltsi",
"3593932", "Bodrovo",
"3597178", "Prolesha",
"3597438", "Katuntsi",
"3594710", "Bolyarsko",
"3593347", "Lenovo",
"35953436", "Chernoglavtsi",
"3596911", "Lisets\,\ Lovech",
"3593558", "Isperihovo",
"3596157", "Slivovitsa",
"3596530", "Tranchovitsa",
"3598677", "Srebarna",
"3595363", "Gusla",
"3597132", "Radotina",
"359336", "Parvomay\,\ Plovdiv",
"3593931", "Kasnakovo",
"359727", "Slivnitsa\,\ Sofia",
"3597127", "Shiroki\ dol",
"35961391", "Slomer",
"3596912", "Bahovitsa",
"35967307", "Mlechevo",
"3594523", "Stoil\ voyvoda",
"3597719", "Yardzhilovtsi",
"35963571", "Brestovets",
"3597715", "Studena\,\ Pernik",
"3598135", "Babovo",
"3593143", "Perushtitsa",
"3598475", "Loznitsa\,\ Razgrad",
"3597444", "Belitsa\,\ Blag\.",
"3593054", "Podvis\,\ Smol\.",
"3599332", "Rakovitsa",
"3593582", "Momina\ klisura",
"35955504", "Bogdanovo\,\ Burgas",
"3595553", "Orlintsi",
"359550", "Sozopol",
"3599327", "Chuprene",
"3595134", "Cherventsi",
"35981262", "Bistrentsi",
"35984269", "Nedoklan",
"35956", "Burgas",
"3593581", "Belovo",
"35981268", "Krivina\,\ Ruse",
"3595136", "Brestak",
"35971502", "Eleshnitsa\,\ Sofia",
"35941332", "Naydenovo",
"35951127", "Razdelna\,\ Varna",
"3597446", "Eleshnitsa\,\ Blag\.",
"35961106", "Novo\ selo\,\ V\.\ Tarnovo",
"3593056", "Chepintsi\,\ Smol\.",
"3596980", "Belentsi",
"3595167", "Venchan",
"3595539", "Chernograd",
"35941338", "Tselina",
"35974401", "Gorno\ Draglishte",
"3595915", "Balgarovo",
"3599553", "Prevala",
"3593653", "Mlechino",
"3596578", "Reselets",
"3593767", "Branitsa",
"3596714", "Popovtsi",
"35941110", "Starozagorski\ bani",
"3595327", "Kaspichan\,\ Shumen",
"3599134", "Tarnak",
"3594712", "Kabile",
"3593512", "Hadzhievo",
"3593128", "Zlatitrap",
"3597163", "Iskrets",
"3595332", "Dragoevo",
"35955505", "Drachevo",
"3593025", "Banite",
"35931397", "Hristo\ Danovo",
"3596531", "Izgrev\,\ Pleven",
"3594139", "Svoboda\,\ St\.\ Zagora",
"3594567", "Banya\,\ Sliven",
"3595947", "Prosenik",
"3596910", "Malinovo",
"35957306", "Izvorovo\,\ Dobr\.",
"3596527", "Odarne",
"3599167", "Lipnitsa\,\ Vratsa",
"3594711", "Bezmer\,\ Yambol",
"3597928", "Garlyano",
"3593639", "Nanovitsa\,\ Kardzh\.",
"35991203", "Lik",
"3593511", "Ognyanovo\,\ Pazardzhik",
"35996", "Montana",
"3596958", "Apriltsi\,\ Lovech",
"3594153", "Madrets\,\ St\.\ Zagora",
"3599728", "Slivata",
"3599136", "Galiche",
"3596042", "Iliyno",
"3596716", "Zhaltesh",
"3596532", "Balgarene\,\ Pleven",
"359454", "Tvarditsa\,\ Sliven",
"359596", "Pomorie",
"3593177", "Novo\ Zhelezare",
"3595743", "Shabla",
"3595100", "Sindel",
"3594737", "Sinapovo",
"35991180", "Lesura",
"35969241", "Yoglav",
"3593118", "Sadovo\,\ Plovdiv",
"3593522", "Gelemenovo",
"3595345", "Razvigorovo",
"3593566", "Boshulya",
"3597754", "Kosharevo",
"3594722", "Granitovo\,\ Yambol",
"3595317", "Ivanski",
"35934", "Pazardzhik",
"35951125", "Konstantinovo\,\ Varna",
"359868", "Silistra",
"3596724", "Yantra\,\ Gabr\.",
"3593676", "Benkovski\,\ Kardzh\.",
"3593537", "Panagyurski\ kolonii",
"35965617", "Iskar\,\ Pleven",
"35971337", "Kalugerovo\,\ Sofia",
"3594764", "Malenovo",
"3596138", "Nedan",
"3596726", "Skalsko",
"3593779", "Siva\ reka",
"3596545", "Lyubenovo\,\ Pleven",
"35963569", "Kamenets\,\ Pleven",
"35967303", "Batoshevo",
"35957308", "Chernookovo\,\ Dobr\.",
"3593674", "Samodiva",
"3593521", "Zvanichevo",
"3596035", "Palamartsa",
"35931394", "Vasil\ Levski\,\ Plovdiv",
"3597918", "Yabalkovo\,\ Kyust\.",
"3596517", "Podem",
"3593564", "Semchinovo",
"359306", "Rudozem",
"3596920", "Lesidren",
"3597149", "Zhivkovo\,\ Sofia",
"3593196", "Drangovo\,\ Plovdiv",
"35965165", "Pisarovo\,\ Pleven",
"3599317", "Archar",
"3594799", "Golyam\ manastir",
"359861", "Silistra",
"3595576", "Lozarevo",
"3598142", "Bazovets\,\ Ruse",
"35931308", "Bogdan\,\ Plovdiv",
"3597546", "Slashten",
"3597036", "Balanovo",
"3599345", "Vinarovo\,\ Vidin",
"3597106", "Yamna",
"35931709", "Mihiltsi",
"3597725", "Klenovik",
"3599540", "Belotintsi",
"3595750", "Kableshkovo\,\ Dobr\.",
"35981266", "Starmen\,\ Ruse",
"3593073", "Startsevo",
"3597034", "Dzherman",
"3594338", "Kran",
"3597544", "Osina",
"3595769", "Hitovo",
"3594140", "Polski\ Gradets",
"3598448", "Terter",
"3597104", "Laga",
"3596587", "Petokladentsi",
"35941336", "Yazdach",
"3598665", "Iskra\,\ Silistra",
"35971506", "Gabra",
"3595718", "Smolnitsa",
"35961102", "Pchelishte",
"3598141", "Dve\ mogili",
"3593194", "Zelenikovo\,\ Plovdiv",
"35959409", "Cheresha",
"3595574", "Saedinenie\,\ Burgas",
"35961108", "Plakovo",
"3593700", "Trakiets",
"35951103", "Lyuben\ Karavelovo",
"35931395", "Iganovo",
"359318", "Saedinenie\,\ Plovdiv",
"3596921", "Ablanitsa\,\ Lovech",
"3594346", "Golyamo\ Dryanovo",
"35931393", "Voynyagovo",
"3598669", "Garvan\,\ Silistra",
"3596733", "Kormyansko",
"3593520", "Miryantsi",
"35967304", "Kramolin",
"3599113", "Mramoren",
"3596964", "Velchevo\,\ Lovech",
"3593325", "Cherven\,\ Plovdiv",
"3595102", "Padina\,\ Varna",
"3595765", "Lovchantsi",
"3597729", "Dolna\ Dikanya",
"3596966", "Shipkovo",
"3599349", "Slanotran",
"3594513", "Gavrailovoc",
"3597117", "Gradets\,\ Sofia",
"3596922", "Leshnitsa\,\ Lovech",
"3593151", "Rakovski\,\ Plovdiv",
"3594795", "Skalitsa",
"3596937", "Sokolovo\,\ Lovech",
"3594344", "Shanovo",
"3597048", "Blazhievo",
"3597145", "Mirovo\,\ Sofia",
"3593713", "Dinevo",
"3595101", "Dabravino",
"3596146", "Polski\ Senovets",
"35951104", "Dolishte\,\ Varna",
"3593642", "Potochnitsa",
"3599542", "Smolyanovtsi",
"35981461", "Karan\ Varbovka",
"3593701", "Elena\,\ Hask\.",
"3598140", "Borovo\,\ Ruse",
"3599183", "Lilyache",
"3596549", "Sanadinovo",
"35984736", "Podayva",
"3598696", "Suhodol\,\ Silistra",
"3596039", "Opaka",
"35974202", "Klyuch",
"3595751", "Tervel\,\ Dobr\.",
"3593775", "Generalovo",
"35967305", "Stokite",
"3598694", "Zebil",
"3599541", "Doktor\ Yosifovo",
"3593641", "Krumovgrad",
"3593702", "Tsareva\ polyana",
"3593783", "Svirkovo",
"3593165", "Karadzhalovo",
"3594142", "Troyanovo\,\ St\.\ Zagora",
"35967398", "Damyanovo",
"3599175", "Ostrov",
"359971", "Lom",
"3596144", "Dolna\ Lipnitsa",
"3595349", "Studenitsa",
"3594583", "Kipilovo",
"3595752", "Nova\ Kamena",
"3597187", "Bunovo\,\ Sofia",
"3593019", "Pisanitsa",
"35967392", "Yavorets",
"3599729", "Rasovo",
"3596737", "Krushevo\,\ Gabr\.",
"3599117", "Krivodol",
"3594761", "Straldzha",
"3593671", "Podkova",
"3596959", "Debnevo",
"3593524", "Apriltsi\,\ Pazardzhik",
"3596960", "Belish",
"3597752", "Rezhantsi",
"35930458", "Lyubcha",
"3597929", "Sovolyano",
"3593638", "Zvezdel",
"3594724", "Razdel\,\ Yambol",
"3596722", "Sokolovo\,\ Gabr\.",
"35984730", "Golyam\ Porovets",
"3599145", "Brenitsa\,\ Vratsa",
"3593561", "Septemvri",
"3596174", "Draganovo\,\ V\.\ Tarnovo",
"3596933", "Golets",
"35931387", "Prolom",
"3594762", "Vodenichane",
"35960378", "Tsar\ Asen\,\ Targ\.",
"3594105", "Byalo\ pole",
"3594138", "Gita",
"3594726", "Malomirovo",
"3597751", "Breznik",
"3594340", "Panicherevo",
"3596176", "Polikraishte",
"35947201", "Izgrev\,\ Yambol",
"35960372", "Krepcha",
"3593717", "Konush\,\ Hask\.",
"3593672", "Chorbadzhiysko",
"3593129", "Skutare",
"3594517", "Ichera",
"35930414", "Devin",
"3593745", "Malak\ izvor\,\ Hask\.",
"3596579", "Ruptsi\,\ Pleven",
"3593562", "Slavovitsa\,\ Pazardzhik",
"3593526", "Dinkata",
"3597541", "Satovcha",
"35984776", "Harsovo\,\ Razgrad",
"3598625", "Oven",
"3595538", "Karanovo\,\ Burgas",
"3594755", "Tamarino",
"3597031", "Gorna\ Koznitsa",
"3595952", "Malko\ Tarnovo",
"3595145", "Grozdyovo",
"3597435", "Sklave",
"3595117", "Botevo\,\ Varna",
"3597175", "Gaber",
"3598144", "Batishnitsa",
"3593191", "Brezovo\,\ Plovdiv",
"35961606", "Vladislav",
"3595571", "Sungurlare",
"3593555", "Nova\ mahala\,\ Pazardzhik",
"3599187", "Lyutadzhik",
"3597032", "Yahinovo",
"3594587", "Yablanovo",
"3597183", "Dushantsi",
"3597102", "Lopyan",
"3593787", "Tyanevo\,\ Hask\.",
"3593192", "Babek",
"35930415", "Devin",
"3598690", "Silistra",
"3595572", "Beronovo",
"3593154", "Chalakovi",
"3595313", "Madara",
"3598138", "Brashlen",
"35931707", "Chernozemen",
"3597718", "Dragichevo",
"3593043", "Zmeitsa",
"35930413", "Devin",
"359707", "Sapareva\ banya",
"3593533", "Bata",
"3596720", "Kereka",
"3596926", "Gorno\ Pavlikene",
"3594733", "Orlov\ dol",
"3594341", "Cherganovo",
"3596962", "Cherni\ Osam",
"359331", "Asenovgrad",
"35971227", "Beli\ Iskar",
"3598431", "Isperih",
"35943616", "Turia",
"35959407", "Sini\ rid",
"3593559", "Kapitan\ Dimitrievo",
"3596513", "Pordim",
"3597179", "Golemo\ Malovo",
"3597439", "Ploski",
"3595106", "Avren\,\ Varna",
"3594342", "Ovoshtnik",
"3595149", "Golitsa",
"3593156", "Shishmantsi",
"35941330", "Tsenovo\,\ St\.\ Zagora",
"3598629", "Smilets\,\ Silistra",
"3596575", "Telish",
"35991186", "Baurene",
"359953", "Berkovitsa",
"35941118", "Ostra\ mogila\,\ St\.\ Zagora",
"3595918", "Rusokastro",
"3599544", "Studeno\ buche",
"3598691", "Silistra",
"3593644", "Egrek",
"3594146", "Dinya",
"3595756", "Bozhan",
"35941112", "Starozagorski\ bani",
"3593749", "Garvanovo",
"3596141", "Polski\ Trambesh",
"3593125", "Razhevo\ Konare",
"3593706", "Tankovo\,\ Hask\.",
"3599313", "Kapitanovtsi",
"3595969", "Galabets\,\ Burgas",
"3593028", "Arda",
"3594109", "Trakia",
"3595570", "Manolich",
"3599149", "Bukovets\,\ Vratsa",
"3593704", "Bryagovo\,\ Hask\.",
"3598692", "Stefan\ Karadzha\,\ Silistra",
"35935392", "Dyulevo\,\ Pazardzhik",
"3597925", "Gyueshevo",
"3593190", "Varben\,\ Plovdiv",
"3596955", "Dalbok\ dol",
"3593646", "Tokachka",
"3599546", "Slavotin",
"3594144", "Kovachevo\,\ St\.\ Zagora",
"3593077", "Sredets\,\ Smol\.",
"3596142", "Obedinenie",
"35963567", "Gradina\,\ Pleven",
"3595754", "Zarnevo",
"3597030", "Resilovo",
"3599725", "Komoshtitsa",
"35936401", "Strandzhevo",
"3596583", "Belene",
"3595130", "General\ Kiselovo",
"35959405", "Zaychar",
"35931792", "Chernichevo\,\ Plovdiv",
"35991182", "Osen\,\ Vratsa",
"3595557", "Bistrets\,\ Burgas",
"3596998", "Golyam\ izvor\,\ Lovech",
"3599323", "Drenovets",
"3597743", "Divlya",
"3593115", "Kuklen",
"35991188", "Galatin",
"35941116", "Sladak\ Kladenets",
"3595348", "Trem",
"3596072", "Dobrotitsa\,\ Targ\.",
"3596986", "Daben",
"3593050", "Bukova\ polyana",
"359457", "Nova\ Zagora",
"3593147", "Novo\ selo\,\ Plovdiv",
"3595773", "Lozenets\,\ Dobr\.",
"35938", "Haskovo",
"35963564", "Bivolare",
"3596984", "Bezhanovo\,\ Lovech",
"3596135", "Varbovka",
"35931705", "Gorna\ mahala",
"3596548", "Debovo",
"3595163", "Mlada\ gvardia",
"3596071", "Antonovo",
"3597915", "Nevestino\,\ Kyust\.",
"3593693", "Lyaskovo\,\ Kardzh\.",
"3599747", "Mokresh\,\ Mont\.",
"35971225", "Novo\ selo\,\ Sofia",
"3597167", "Tserovo\,\ Sofia",
"35961503", "Chakali",
"35959404", "Yasenovo\,\ Burgas",
"3596916", "Brestovo\,\ Lovech",
"3595943", "Vresovo",
"3596710", "Donino",
"35976", "Pernik",
"35963565", "Mechka\,\ Pleven",
"3599557", "Gorno\ Tserovene",
"3593657", "Zhaltusha",
"3593934", "Skobelevo\,\ Hask\.",
"3599130", "Tlachene",
"35937604", "Varbovo\,\ Hask\.",
"35991888", "Veslets\,\ Vratsa",
"3593763", "Balgarin",
"3597728", "Drugan",
"3597136", "Novachene\,\ Sofia",
"3599348", "Negovanovtsi",
"3595323", "Pliska",
"359750", "Borovets\,\ Sofia",
"3594157", "Razdelna\,\ St\.\ Zagora",
"3594335", "Razhena",
"3593936", "Gorski\ izvor\,\ Hask\.",
"3597134", "Vrachesh",
"3593173", "Panicheri",
"35931704", "Ivan\ Vazovo",
"3595747", "Vaklino",
"3598445", "Yuper",
"3595715", "Popgrigorovo",
"35971224", "Shipochane",
"3598668", "Popina",
"359517", "Dalgopol",
"3599163", "Harlets",
"3596523", "Krushovitsa\,\ Pleven",
"359359", "Velingrad",
"3596914", "Slivek",
"3599785", "Vasilovtsi\,\ Mont\.",
"35953223", "Tsarkvitsa",
"35969031", "Galata",
"3598647", "Paisievo",
"35941351", "Partizanin",
"3597442", "Yakoruda",
"3595719", "Donchevo",
"359308", "Madan\,\ Smol\.",
"35984778", "Bogdantsi\,\ Razgrad",
"3593584", "Vetren\,\ Pazardzhik",
"3593052", "Laki\,\ Plovdiv",
"3595127", "Manastir\,\ Varna",
"359724", "Ihtiman",
"359675", "Sevlievo",
"3593328", "Dolnoslav",
"35961608", "Gorski\ Senovets",
"35961602", "Tsarski\ izvor",
"3595132", "Mihalich\,\ Varna",
"3594339", "Yulievo",
"3595768", "Odrintsi\,\ Dobr\.",
"35963563", "Borislav",
"35967309", "Agatovo",
"3593051", "Chepelare",
"3596907", "Gradezhnitsa",
"3594798", "Savino",
"3597045", "Golem\ Varbovnik",
"3594353", "Srednogorovo",
"3597148", "Muhovo",
"3593586", "Borimechkovo",
"3599336", "Staropatitsa",
"3595131", "Valchi\ dol",
"35947356", "Mramor\,\ Yambol",
"3593343", "Kozanovo",
"3596712", "Gabene",
"3596536", "Asparuhovo\,\ Pleven",
"3594714", "Drazhevo",
"3596046", "Vrani\ kon",
"35971587", "Golema\ Rakovitsa",
"3599132", "Knezha",
"3593514", "Chernogorovo\,\ Pazardzhik",
"3593923", "Radievo",
"359301", "Smolyan",
"35931703", "Zhitnitsa\,\ Plovdiv",
"3595334", "Osmar",
"3599127", "Lyutidol",
"3596567", "Somovit",
"35930417", "Grohotno",
"3593778", "Studena\,\ Hask\.",
"35930456", "Chavdar\,\ Smol\.",
"3599719", "Asparuhovo\,\ Mont\.",
"3593516", "Tsrancha\,\ Pazardzhik",
"3593168", "Ezerovo\,\ Plovdiv",
"35935418", "Krastava",
"35963202", "Dragomirovo\,\ V\.\ Tarnovo",
"3599131", "Dobrolevo",
"35960376", "Lyublen",
"3597123", "Kovachevtsi\,\ Sofia",
"3594527", "Zagortsi\,\ Sliven",
"35937603", "Rogozinovo",
"3596711", "Kozi\ rog",
"3595336", "Imrenchevo",
"3593119", "Galabovo\,\ Plovdiv",
"359610", "Pavlikeni\,\ V\.\ Tarnovo",
"3596153", "Zlataritsa",
"3593727", "Nova\ Nadezhda",
"35959403", "Rechitsa",
"3596044", "Dolno\ Kozarevo",
"35967390", "Shumata",
"3594716", "Veselinovo\,\ Yambol",
"3598673", "Alfatar",
"3596534", "Malchika",
"3595367", "Todor\ Ikonomovo",
"35984733", "Ludogortsi",
"3596123", "Bukovets\,\ V\.\ Tarnovo",
"3597711", "Kladnitsa",
"3598131", "Borisovo\,\ Ruse",
"3593757", "Georgi\ Dobrevo",
"35981264", "Piperkovo",
"3594773", "Okop",
"3597044", "Babino",
"3594348", "Dunavtsi\,\ St\.\ Zagora",
"3594130", "Spasovo\,\ St\.\ Zagora",
"35941334", "Saedinenie\,\ St\.\ Zagora",
"35971504", "Belopoptsi",
"3594557", "Bikovo",
"3598132", "Yudelnik",
"3597712", "Batanovtsi",
"3597046", "Boboshevo",
"3596919", "Slatina\,\ Lovech",
"3593585", "Akandzhievo",
"3599335", "Tsar\ Petrovo",
"35931402", "Skobelevo\,\ Plovdiv",
"35975214", "Gaytaninovo",
"3596968", "Dobrodan",
"3597139", "Dzhurovo",
"3598127", "Karamanovo",
"35961107", "Momin\ sbor",
"35955502", "Suhodol\,\ Burgas",
"3594323", "Tulovo",
"3598698", "Shumentsi",
"3596148", "Pavel",
"35941119", "Elhovo\,\ St\.\ Zagora",
"35971338", "Osikovska\ Lakavitsa",
"35941335", "Mogilovo",
"35971505", "Churek",
"35931396", "Domlyan",
"3596535", "Kozar\ Belene",
"35975215", "Teshovo",
"35957307", "Zhiten\,\ Dobr\.",
"3595912", "Polski\ izvor",
"3593107", "Graf\ Ignatievo",
"3594715", "Kalchevo",
"3593037", "Sivino",
"359417", "Radnevo",
"3593547", "Sarnitsa\,\ Pazardzhik",
"3593515", "Kalugerovo\,\ Pazardzhik",
"35991668", "Manastirishte",
"3594747", "Dennitsa\,\ Yambol",
"359579", "Albena",
"3594593", "Shivachevo",
"3595530", "Peshtersko",
"3593022", "Vievo",
"3595335", "Milanovo\,\ Shumen",
"3596989", "Toros",
"35930459", "Brashten",
"3594132", "Orizovo",
"3596134", "Byala\ cherkva\,\ V\.\ Tarnovo",
"3596985", "Rumyantsevo",
"3594768", "Zimnitsa\,\ Yambol",
"3593519", "Velichkovo\,\ Pazardzhik",
"3596004", "Makovo",
"359650", "Levski\,\ Pleven",
"3596553", "Oryahovitsa\,\ Pleven",
"3593678", "Chakalarovo",
"3595784", "Vrachantsi",
"3597914", "Vaksevo",
"3597523", "Garmen",
"3593631", "Momchilgrad",
"3598163", "Bazan",
"35974207", "General\ Todorov",
"35930410", "Breze\,\ Smol\.",
"3593116", "Krumovo\,\ Plovdiv",
"3593568", "Vinogradets",
"3596539", "Gradishte\,\ Pleven",
"3599527", "Varshets",
"3596167", "Kesarevo",
"35941333", "Sredno\ gradishte",
"35971503", "Dolno\ Kamartsi",
"3597916", "Bagrentsi",
"3596049", "Kamburovo",
"35951106", "Osenovo\,\ Varna",
"3593114", "Brestnik",
"3595353", "Veselinovo\,\ Shumen",
"3596136", "Suhindol",
"3596728", "Burya",
"359335", "Karlovo",
"3593632", "Dzhebel",
"35984761", "Gradina\,\ Razgrad",
"35984734", "Todorovo\,\ Razgrad",
"35966", "Gabrovo",
"35961203", "Emen",
"35961301", "Byala\ reka\,\ V\.\ Tarnovo",
"35967397", "Ryahovtsite",
"3596006", "Presian",
"3594334", "Elhovo\,\ St\.\ Zagora\,\ mun\.\ Nikolaevo",
"3597548", "Godeshevo",
"3597135", "Trudovets",
"3595397", "Metodievo\,\ Shumen",
"359817", "Byala\,\ Ruse",
"3596327", "Ovcha\ mogila",
"3593198", "Chehlare",
"3599339", "Makresh",
"3593589", "Tserovo\,\ Pazardzhik",
"3595714", "Karapelit",
"3599784", "Kiselevo",
"35953437", "Gabritsa\,\ Shumen",
"3596915", "Smochan",
"3595578", "Terziysko\,\ Burgas",
"3595532", "Topolitsa",
"3595716", "Paskalevo",
"359720", "Etropole",
"35991202", "Kunino",
"3593020", "Davidkovo",
"3594367", "Tazha",
"3595958", "Gramatikovo",
"35984735", "Sveshtari",
"3595527", "Sokolovo\,\ Burgas",
"3593935", "Varbitsa\,\ Hask\.",
"3594336", "Dolno\ Izvorovo",
"35967306", "Gradishte\,\ Gabr\.",
"3599353", "Koshava",
"3595910", "Cherni\ vrah\,\ Burgas",
"3596925", "Vladinya",
"3595724", "Dropla\,\ Dobr\.",
"3598149", "Katselovo",
"35941145", "Arnautito",
"3596030", "Svetlen\,\ Targ\.",
"3596540", "Asenovo\,\ Pleven",
"3593321", "Topolovo\,\ Plovdiv",
"3594792", "Botevo\,\ Yambol",
"35967395", "Gorna\ Rositsa",
"35984779", "Zdravets\,\ Razgrad",
"3595761", "Batovo",
"3597142", "Kostenets",
"3597448", "Bachevo",
"3593155", "Momino\ selo",
"3593058", "Mugla",
"3595517", "Ravnets\,\ Burgas",
"3595340", "Visoka\ polyana\,\ Shumen",
"3593322", "Zlatovrah",
"35953434", "Yasenkovo",
"35937421", "Dolno\ pole",
"35967308", "Lovnidol",
"35967302", "Kravenik",
"3596990", "Malak\ izvor\,\ Lovech",
"3595762", "Stefan\ Karadzha\,\ Dobr\.",
"3595105", "Priseltsi\,\ Varna",
"3595726", "Tsarichino",
"3595138", "Dobrotich",
"3596063", "Bayachevo",
"3593162", "Gradina\,\ Plovdiv",
"3596179", "Krusheto",
"35941144", "Kaloyanovets",
"3593126", "Trud",
"3593705", "Vaglarovo",
"3598660", "Tutrakan",
"3594729", "Kirilovo\,\ Yambol",
"3597924", "Shishkovtsi",
"3596576", "Radomirtsi",
"35984737", "Raynino",
"3599172", "Selanovtsi",
"35967394", "Bogatovo",
"3596954", "Vrabevo",
"3593529", "Mokrishte",
"35974321", "Harsovo\,\ Blag\.",
"3594145", "Znamenosets",
"3595755", "Kolartsi",
"3599724", "Stanevo",
"3598633", "Staro\ selo\,\ Silistra",
"3599545", "Gabrovnitsa",
"3593645", "Avren\,\ Kardzh\.",
"3596956", "Lomets\,\ Lovech",
"3599340", "Septemvriytsi\,\ Vidin",
"3596574", "Chomakovtsi",
"35961103", "Rusalya",
"35951108", "Izvorsko",
"3597720", "Priboy",
"35953220", "Pamukchii\,\ Shumen",
"3599726", "Zamfir",
"3599138", "Altimir",
"3596718", "Draganovtsi",
"35931324", "Mrachenik",
"35974204", "Gega",
"3593124", "Kalekovets",
"3599171", "Oryahovo\,\ Vratsa",
"3597423", "Kolarovo\,\ Blag\.",
"35935419", "Sveta\ Petka",
"35981886", "Chereshovo\,\ Ruse",
"3593772", "Momkovo",
"3597926", "Konyavo",
"3599517", "Kobilyak",
"35953435", "Izgrev\,\ Shumen",
"3594104", "Kravino",
"3596991", "Yablanitsa",
"3597057", "Malo\ selo",
"35991401", "Vranyak",
"3596032", "Zaraevo",
"3599146", "Sokolare",
"3595733", "Kardam\,\ Dobr\.",
"3595341", "Hitrino",
"3596542", "Vabel\,\ Pleven",
"359453", "Kotel",
"35957304", "Dabovik",
"3593744", "Sarnitsa\,\ Hask\.",
"35961105", "Prisovo",
"35931398", "Slatina\,\ Plovdiv",
"359373", "Harmanli",
"35931392", "Dabene",
"3599549", "Dolna\ Riksa",
"35991189", "Tri\ kladentsi",
"3596027", "Dralfa",
"3595760", "Bozhurovo\,\ Dobr\.",
"3596992", "Zlatna\ Panega",
"3593746", "Sirakovo\,\ Hask\.",
"3595759", "Kochmar",
"3596541", "Nikopol",
"3593320", "Oreshets\,\ Plovdiv",
"3595342", "Kapitan\ Petko",
"3594149", "Trankovo\,\ St\.\ Zagora",
"35963560", "Radishevo",
"3598187", "Tetovo",
"3594106", "Pastren",
"3594725", "Lesovo",
"3596175", "Parvomaytsi",
"3593709", "Karamantsi",
"3599144", "Nivyanin",
"35935501", "Ravnogor",
"3597436", "Levunovo",
"3597176", "Hrabarsko",
"35931700", "Belovitsa",
"35957305", "Rositsa\,\ Dobr\.",
"35974203", "Rupite",
"3597933", "Gramazhdano",
"3593556", "Radilovo",
"3598626", "Sredishte\,\ Silistra",
"3594756", "Polyana\,\ Yambol",
"3598662", "Dobrotitsa\,\ Silistra",
"3599341", "Dimovo\,\ Vidin",
"3593159", "Belozem",
"3596113", "Balvan",
"35961104", "Vodoley",
"35971220", "Gutsal",
"3595146", "Goren\ chiflik",
"3594754", "Kamenets\,\ Yambol",
"35959400", "Daskotna",
"359678", "Teteven",
"3598624", "Kalipetrovo",
"3598117", "Marten",
"3595144", "Kamchia",
"35967393", "Dushevo",
"3598661", "Tutrakan",
"35941337", "Sarnevets",
"3597434", "Strumyani",
"3598145", "Trastenik\,\ Ruse",
"3593133", "Kalofer",
"3597174", "Kalotina",
"3596929", "Radyuvene",
"3593554", "Kozarsko",
"3599342", "Inovo",
"35931706", "Suhozem",
"3593326", "Patriarh\ Evtimovo",
"3593740", "Pchelari",
"359309", "Pamporovo",
"3596023", "Podgoritsa",
"3595766", "Metodievo\,\ Dobr\.",
"35935251", "Bratanitsa",
"35947353", "Balgarska\ polyana",
"3594345", "Raduntsi",
"3594794", "Ovchi\ kladenets",
"3597053", "Kocherinovo",
"3595959", "Zvezdets",
"3594100", "Stoletovo\,\ St\.\ Zagora",
"359747", "Razlog",
"3595737", "Lyulyakovo\,\ Dobr\.",
"3597144", "Kostenets",
"3594796", "General\ Toshevo\,\ Yambol",
"35959406", "Razboyna\,\ Burgas",
"3599140", "Gabare",
"3595579", "Vedrovo",
"3599338", "Shishentsi",
"35941115", "Borilovo",
"3597146", "Chernyovo",
"3593588", "Menenkyovo",
"35941339", "Dimitrievo",
"3596965", "Beli\ Osam",
"3593324", "Izbeglii",
"35960373", "Posabina",
"3595764", "Vladimirovo\,\ Dobr\.",
"3597549", "Dolen\,\ Blag\.",
"3597039", "Samoranovo",
"35937606", "Shishmanovo",
"35937701", "Sladun",
"3596571", "Lepitsa",
"3593164", "Dalbok\ izvor",
"3598695", "Nozharevo",
"35935394", "Oborishte\,\ Pazardzhik",
"3593776", "Raykova\ mogila",
"3596117", "Debelets\,\ V\.\ Tarnovo",
"3597922", "Dragovishtitsa\,\ Kyust\.",
"3596145", "Strahilovo",
"3593121", "Rogosh",
"3596952", "Oreshak\,\ Lovech",
"3599174", "Gorni\ Vadin",
"3596538", "Obnova",
"3597937", "Razhdavitsa",
"3599722", "Staliyska\ mahala",
"35977221", "Kondofrey",
"3596048", "Izvorovo\,\ Targ\.",
"3599176", "Leskovets\,\ Vratsa",
"3593569", "Karabunar",
"3596572", "Suhache",
"35941114", "Lozen\,\ St\.\ Zagora",
"3593137", "Klisura\,\ Plovdiv",
"3594718", "Roza",
"3597921", "Zhilentsi",
"3597430", "Damyanitsa",
"3595140", "Shkorpilovtsi",
"3593518", "Dragor",
"3593679", "Kirkovo",
"3593122", "Manole",
"3593166", "Byala\ reka\,\ Plovdiv",
"35963566", "Brashlyanitsa",
"3593774", "Levka",
"3597733", "Filipovtsi",
"3598113", "Novo\ selo\,\ Ruse",
"3599721", "Dolno\ Tserovene",
"3595338", "Troitsa",
"3598620", "Silistra",
"35960374", "Gorsko\ Ablanovo",
"3594102", "Yastrebovo\,\ St\.\ Zagora",
"3596988", "Peshterna",
"3593675", "Fotinovo\,\ Kardzh\.",
"3596034", "Slavyanovo\,\ Targ\.",
"3596544", "Novachene\,\ Pleven",
"35930418", "Buynovo\,\ Smol\.",
"3599141", "Malorad",
"3595346", "Kamenyak\,\ Shumen",
"35930412", "Devin",
"3596994", "Brestnitsa\,\ Lovech",
"3594101", "Opan",
"3596149", "Kutsina",
"3597755", "Velkovtsi\,\ Pernik",
"3595344", "Velino",
"35947354", "Kamenna\ reka",
"3596067", "Kralevo\,\ Targ\.",
"3596725", "Gostilitsa",
"3593741", "Mandra",
"3596546", "Lozitsa\,\ Pleven",
"3595513", "Gabar",
"3599142", "Lazarovo",
"3598699", "Tarnovtsi\,\ Silistra",
"3596036", "Sadina",
"3597545", "Kochan",
"3598621", "Silistra",
"3594751", "Voynika",
"3597035", "Cherven\ breg",
"3599720", "Kovachitsa",
"3597105", "Malki\ Iskar",
"3599346", "Sinagovtsi",
"3597726", "Dren",
"3597138", "Litakovo",
"3596969", "Beklemeto",
"35960375", "Garchinovo",
"3596950", "Gumoshtnik",
"3595141", "Staro\ Oryahovo",
"3593195", "Rozovets",
"3598664", "Polyana\,\ Silistra",
"3597920", "Skrinyano",
"3594113", "Preslaven",
"35961607", "Balkantsi\,\ V\.\ Tarnovo",
"3595575", "Prilep\,\ Burgas",
"35941113", "Pryaporets\,\ St\.\ Zagora",
"3596918", "Drenov",
"359478", "Elhovo\,\ Yambol",
"3598666", "Tutrakan",
"3594752", "Parvenets\,\ Yambol",
"359723", "Botevgrad",
"3597427", "Parvomay\,\ Blag\.",
"3598622", "Alekovo\,\ Silistra",
"35941171", "Dalboki",
"3593120", "Hrabrino",
"3595142", "Dolni\ chiflik",
"3599513", "Boychinovtsi",
"3598637", "Malak\ Preslavets",
"35935393", "Smilets\,\ Pazardzhik",
"3597172", "Dragoman",
"3593552", "Bratsigovo",
"3599344", "Vrav",
"3596570", "Deventsi",
"3597724", "Izvor\,\ Pernik",
"3596928", "Kakrina",
"3597527", "Gorno\ Dryanovo",
"3598167", "Tserovets",
"3594123", "Bogomilovo",
"3597910", "Bersin",
"35963205", "Chervena",
"35991183", "Furen",
"3597042", "Korkina",
"3598136", "Stambolovo\,\ Ruse",
"3597532", "Bukovo\,\ Blag\.",
"3596557", "Bregare",
"35993212", "Karbintsi",
"3598134", "Malko\ Vranovo",
"3597714", "Meshtitsa",
"3597445", "Banya\,\ Blag\.",
"35984774", "Golyam\ izvor\,\ Razgrad",
"3593055", "Elhovets",
"3593623", "Boyno",
"3599523", "Barzia",
"3596163", "Kamen\,\ V\.\ Tarnovo",
"3597531", "Dolno\ Dryanovo",
"35961604", "Mirovo\,\ V\.\ Tarnovo",
"3597041", "Shatrovo",
"3593110", "Popovitsa",
"3595135", "Stefan\ Karadzha\,\ Varna",
"3595108", "Sadovo\,\ Varna",
"359339", "Stamboliyski\,\ Plovdiv",
"3596323", "Balgarsko\ slivovo",
"35963204", "Delyanovtsi",
"3593708", "Orlovo\,\ Hask\.",
"3593026", "Smilyan",
"3595710", "Pobeda\,\ Dobr\.",
"3595916", "Rosen\,\ Burgas",
"359676", "Dryanovo\,\ Gabr\.",
"3596943", "Gorsko\ Slivovo",
"35961502", "Gorsko\ Novo\ Selo",
"3594330", "Nikolaevo\,\ St\.\ Zagora",
"3595393", "Ivanovo\,\ Shumen",
"35930457", "Kasak",
"35930416", "Gyovren",
"3595758", "Kladentsi",
"359865", "Silistra",
"35967399", "Malki\ Varshets",
"3593648", "Golyamo\ Kamenyane",
"3599548", "Krapchene",
"3595914", "Atia",
"3595523", "Krumovo\ gradishte",
"3599135", "Bardarski\ geran",
"35960377", "Aprilovo\,\ Targ\.",
"35953222", "Markovo\,\ Shumen",
"35931388", "Beguntsi",
"35932", "Plovdiv",
"3594363", "Gabarevo",
"35941149", "Lovets\,\ St\.\ Zagora",
"35961605", "Novo\ gradishte",
"3593024", "Taran",
"3594134", "Bratya\ Daskalovi",
"35984721", "Lipnik",
"3593636", "Raven",
"3596132", "Karaisen",
"3596002", "Saedinenie\,\ Targ\.",
"3597157", "Sarantsi",
"35961603", "Lozen\,\ V\.\ Tarnovo",
"3593111", "Parvenets\,\ Plovdiv",
"3595782", "Benkovski\,\ Dobr\.",
"3594553", "Rakovo\,\ Sliven",
"35941117", "Kazanka",
"3599567", "Dolna\ Verenitsa",
"3593667", "Pokrovan",
"3597912", "Gorna\ Grashtitsa",
"3599139", "Tarnava\,\ Vratsa",
"3593753", "Oryahovo\,\ Hask\.",
"35931390", "Moskovets",
"3594777", "Tenevo",
"3598123", "Bosilkovtsi",
"35984711", "Mortagonovo",
"35991184", "Rakevo",
"3595781", "Svoboda\,\ Dobr\.",
"3593112", "Markovo\,\ Plovdiv",
"3593528", "Govedare",
"3596001", "Cherkovna\,\ Targ\.",
"3594136", "Cherna\ gora\,\ St\.\ Zagora",
"3594728", "Melnitsa",
"3597911", "Granitsa",
"35963562", "Komarevo\,\ Pleven",
"3593634", "Pripek\,\ Kardzh\.",
"359910", "Mezdra",
"3596178", "Strelets\,\ V\.\ Tarnovo",
"35963568", "Bukovlak",
"35946", "Yambol",
"3594332", "Vetren\,\ St\.\ Zagora",
"35931309", "Kliment\,\ Plovdiv",
"35931702", "Dolna\ mahala\,\ Plovdiv",
"3595139", "Oborishte\,\ Varna",
"3598442", "Zavet\,\ Razgrad",
"35931708", "Pesnopoy\,\ Plovdiv",
"3593059", "Kutela",
"3594327", "Sheynovo",
"3595536", "Maglen",
"35971228", "Maritsa",
"3595712", "Stozher",
"3599782", "Bukovets\,\ Mont\.",
"3595534", "Karageorgievo",
"359554", "Sunny\ Beach",
"35991185", "Pudria",
"3594743", "Mamarchevo",
"3594331", "Gurkovo\,\ St\.\ Zagora",
"35959408", "Razhitsa",
"3594597", "Borov\ dol",
"35961109", "Vaglevtsi",
"3595153", "Suvorovo",
"3597193", "Golesh\,\ Sofia",
"3595711", "Ovcharovo\,\ Dobr\.",
"3598148", "Gorno\ Ablanovo",
"3593103", "Milevo",
"35984266", "Prostorno",
"35963203", "Hadzhidimitrovo\,\ V\.\ Tarnovo",
"35960451", "Obitel",
"3593543", "Dorkovo",
"35937602", "Cherna\ mogila\,\ Hask\.",
"35941357", "Zetyovo\,\ St\.\ Zagora",
"3599180", "Golyamo\ Peshtene",
"3598143", "Obretenik",
"3593135", "Karnare",
"35973", "Blagoevgrad",
"35961705", "Gorski\ dolen\ Trambesh",
"35995276", "Draganitsa",
"3593108", "Boykovo",
"3593038", "Chokmanovo",
"3597186", "Anton",
"3593548", "Pashovo",
"3593071", "Zlatograd",
"3594748", "Voden\,\ Yambol",
"35992", "Vratsa",
"35941178", "Oryahovitsa\,\ St\.\ Zagora",
"3598697", "Sokol\,\ Silistra",
"359677", "Tryavna",
"35941172", "Gorno\ Botevo",
"3596115", "Resen",
"35941276", "Mogila\,\ St\.\ Zagora",
"3596147", "Ivancha\,\ V\.\ Tarnovo",
"359729", "Godech",
"35941480", "Kolarovo\,\ St\.\ Zagora",
"3594580", "Borintsi",
"3596069", "Vasil\ Levski\,\ Targ\.",
"3593072", "Nedelino",
"35968", "Lovech",
"3597935", "Dolno\ selo",
"3597184", "Koprivshtitsa",
"359860", "Silistra",
"35984740", "Bisertsi",
"3594723", "Boyanovo\,\ Yambol",
"35947204", "Pchela",
"3596173", "Dolna\ Oryahovitsa",
"35952", "Varna",
"35961704", "Pravda\,\ V\.\ Tarnovo",
"3596967", "Kaleytsa",
"3598128", "Polsko\ Kosovo",
"3597116", "Petarch",
"35984466", "Zvanartsi",
"35930411", "Devin",
"3599110", "Virovsko",
"3593523", "Sinitevo",
"359659", "Cherven\ bryag",
"3593758", "Yerusalimovo",
"3598639", "Kolarovo\,\ Silistra",
"3594510", "Zhelyu\ voyvoda",
"3593710", "Uzundzhovo",
"3594347", "Rozovo\,\ St\.\ Zagora",
"3596934", "Katunets",
"35984760", "Trapishte",
"3595735", "Krasen\,\ Dobr\.",
"3597425", "Kulata",
"3599314", "Dunavtsi\,\ Vidin",
"3595739", "Pchelarovo\,\ Dobr\.",
"35984726", "Ushintsi",
"35937702", "Mustrak",
"3594368", "Tarnicheni",
"3593781", "Simeonovgrad",
"3593643", "Golyama\ Chinka",
"3598635", "Tsar\ Samuil",
"3595112", "Beloslav",
"3595528", "Nevestino\,\ Burgas",
"3599182", "Devene",
"35977222", "Gorna\ Dikanya",
"359915", "Byala\ Slatina",
"35930475", "Stomanevo",
"3596586", "Belene",
"35974348", "Igralishte",
"3596948", "Karpachevo",
"3597547", "Valkosel",
"3594143", "Sarnevo\,\ St\.\ Zagora",
"3596584", "Belene",
"359608", "Popovo\,\ Targ\.",
"3594582", "Gradets\,\ Sliven",
"3595753", "Orlyak",
"359570", "Kavarna",
"3596328", "Oresh",
"3593197", "Tyurkmen",
"3599316", "Novo\ selo\,\ Vidin",
"3593703", "Zhalti\ bryag",
"3593782", "Kalugerovo\,\ Hask\.",
"35931602", "Tatarevo\,\ Plovdiv",
"3599181", "Kravoder",
"3595577", "Podvis\,\ Burgas",
"3599112", "Banitsa",
"3597939", "Tsarvaritsa",
"3599528", "Gaganitsa",
"3596168", "Sushitsa\,\ V\.\ Tarnovo",
"3593628", "Miladinovo",
"3594734", "Srem",
"3596732", "Sennik",
"3596516", "Iskar\,\ Pleven",
"35935258", "Tsar\ Asen\,\ Pazardzhik",
"3593711", "Dolno\ Botevo",
"35935252", "Topoli\ dol",
"3596065", "Bistra\,\ Targ\.",
"3594511", "Slivenski\ mineralni\ bani",
"3596727", "Ganchovets",
"3595314", "Belokopitovo",
"3593153", "Stryama",
"35960389", "Kardam\,\ Targ\.",
"3596119", "Dichin",
"35963579", "Ralevo",
"3593534", "Popintsi",
"3593044", "Lyaskovo\,\ Smol\.",
"3595316", "Salmanovo",
"35974409", "Mesta",
"3599111", "Chelopek",
"3593046", "Barutin",
"3593677", "Drangovo\,\ Kardzh\.",
"3593712", "Malevo\,\ Hask\.",
"3593536", "Banya\,\ Pazardzhik",
"3596923", "Goran",
"359601", "Targovishte",
"3596514", "Dolni\ Dabnik",
"35961703", "Varbitsa\,\ V\.\ Tarnovo",
"3594736", "Svetlina",
"3594512", "Blatets\,\ Sliven",
"35947203", "Trankovo\,\ Yambol",
"3593567", "Kovachevo\,\ Pazardzhik",
"35930257", "Vishnevo",
"3593764", "Polyanovo\,\ Hask\.",
"3598152", "Krasen\,\ Ruse",
"35931701", "Krastevich",
"3593933", "Stransko",
"3594779", "Hanovo",
"35935256", "Sbor\,\ Pazardzhik",
"3599355", "Kosovo\,\ Vidin",
"3596129", "Gabrovtsi",
"3599569", "Lipen",
"3595324", "Harsovo\,\ Shumen",
"3599137", "Popitsa",
"3599550", "Mitrovtsi",
"3596717", "Lesicharka",
"3593176", "Starosel",
"3597159", "Aprilovo\,\ Sofia",
"3593721", "Stambolovo\,\ Hask\.",
"3595944", "Ruen\,\ Burgas",
"3594564", "Novoselets",
"3596526", "Varbitsa\,\ Pleven",
"3599166", "Hayredin",
"3595361", "Kaolinovo",
"35971221", "Yarlovo",
"3599518", "Marchevo",
"3596562", "Gigen",
"3599122", "Zverino",
"3598151", "Prosena",
"3594522", "Korten",
"3594118", "Pamukchii\,\ St\.\ Zagora",
"3594566", "Pitovo",
"3595946", "Tranak",
"3599164", "Krushovitsa\,\ Vratsa",
"3596524", "Petarnitsa",
"3596913", "Slavyani",
"3593722", "Mineralni\ bani\,\ Hask\.",
"3595740", "Gorichane",
"35944", "Sliven",
"3593766", "Biser",
"35960458", "Verentsi",
"35971304", "Lipnitsa\,\ Sofia",
"3599121", "Tsarevets\,\ Vratsa",
"3596561", "Gulyantsi",
"3595362", "Kliment\,\ Shumen",
"3597133", "Pravets",
"3593174", "Staro\ Zhelezare",
"3595326", "Varbyane",
"3595774", "Koriten",
"3597447", "Dobrinishte",
"3598642", "Dulovo",
"35937706", "Chernodab",
"35984722", "Yasenovets",
"35984728", "Rakovski\,\ Razgrad",
"3593057", "Plovdivtsi",
"3595518", "Rudnik\,\ Burgas",
"3595122", "Slaveykovo\,\ Varna",
"3594329", "Dolno\ Sahrane",
"3595166", "Dobroplodno",
"35941353", "Plodovitovo",
"3596901", "Glozhene\,\ Lovech",
"35974346", "Tsaparevo",
"3593696", "Pchelarovo\,\ Kardzh\.",
"35977226", "Debeli\ lag",
"35971398", "Osikovitsa",
"3597744", "Elovdol\,\ Pernik",
"35969249", "Doyrentsi",
"3595137", "Kaloyan",
"3599324", "Ruzhintsi",
"3597415", "Selishte\,\ Blag\.",
"35984712", "Kostandenets",
"3598641", "Okorsh",
"3597525", "Banichan",
"359746", "Sandanski",
"3599740", "Septemvriytsi\,\ Mont\.",
"3598165", "Smirnenski\,\ Ruse",
"3599326", "Gorni\ Lom",
"3595121", "Tutrakantsi",
"35984718", "Dryanovets\,\ Razgrad",
"35963561", "Grivitsa",
"3594599", "Chervenakovo",
"3595776", "Cherna\,\ Dobr\.",
"3596902", "Ribaritsa\,\ Lovech",
"3596983", "Dermantsi",
"3596555", "Baykal",
"3595164", "Neofit\ Rilski",
"35931606", "Voden\,\ Plovdiv",
"3593513", "Malo\ Konare",
"3596559", "Gostilya",
"3593924", "Krepost",
"3596560", "Kreta\,\ Pleven",
"3594595", "Sborishte",
"3598118", "Nikolovo\,\ Ruse",
"3597126", "Gorni\ Okol",
"3597162", "Lakatnik",
"3595333", "Han\ Krum",
"3593344", "Novakovo\,\ Plovdiv",
"35984", "Razgrad",
"3596156", "Rodina",
"3599552", "Belimel",
"3593652", "Byal\ izvor\,\ Kardzh\.",
"3598676", "Vetren\,\ Silistra",
"3597529", "Breznitsa",
"35984462", "Ostrovo",
"3598150", "Semerdzhievo",
"3594713", "Stara\ reka\,\ Yambol",
"3594152", "Obruchishte",
"359418", "Galabovo\,\ St\.\ Zagora",
"3593346", "Muldava",
"35941355", "Yavorovo",
"3596154", "Buynovtsi",
"3596533", "Stezherovo",
"35953221", "Stoyan\ Mihaylovski",
"3595742", "Rakovski\,\ Dobr\.",
"3593720", "Madzharovo",
"3598674", "Profesor\ Ishirkovo",
"3596043", "Dolno\ Novkovo",
"3593651", "Ardino",
"3599551", "Georgi\ Damyanovo",
"3594520", "Konyovo",
"3593926", "Dobrich\,\ Hask\.",
"3594325", "Kanchevo",
"359631", "Svishtov",
"3597124", "Belchinski\ bani",
"359558", "Aytos",
"3598196", "Nisovo",
"3595552", "Dyulevo\,\ Burgas",
"359361", "Kardzhali",
"3595120", "Bozveliysko",
"3593142", "Brestovitsa\,\ Plovdiv",
"3594356", "Hadzhidimitrovo\,\ St\.\ Zagora",
"3596077", "Stevrek",
"3599333", "Boynitsa",
"3599741", "Dolni\ Tsibar",
"3593583", "Gabrovitsa",
"3598640", "Pravda\,\ Silistra",
"3594354", "Zimnitsa\,\ St\.\ Zagora",
"3595551", "Sredets\,\ Burgas",
"3597058", "Stob",
"3596352", "Dolni\ Lukovit",
"35941354", "Malko\ Tranovo",
"3597155", "Lesnovo",
"3596900", "Vasilyovo",
"3593665", "Svirachi",
"3596125", "Pushevo",
"35937420", "Podkrepa",
"35947192", "Zavoy",
"3598194", "Sandrovo",
"3594775", "Karavelovo\,\ Yambol",
"3596028", "Vardun",
"3599742", "Yakimovo",
"3593762", "Izvorovo\,\ Hask\.",
"3593105", "Manolsko\ Konare",
"3593726", "Klokotnitsa",
"3593138", "Vedrare",
"3593340", "Novi\ izvor",
"3594717", "Chargan",
"3593035", "Varbina",
"3599161", "Mizia",
"3596521", "Sadovets",
"3593545", "Draginovo",
"3595366", "Branichevo",
"3594129", "Madzherito",
"3593517", "Lesichovo",
"3594745", "Sharkovo",
"35961394", "Daskot",
"3593920", "Zlatopole",
"3595942", "Lyulyakovo\,\ Burgas",
"3594562", "Kriva\ krusha",
"3595337", "Kochovo",
"3599124", "Tipchenitsa",
"3596564", "Zagrazhden\,\ Pleven",
"3594526", "Mlekarevo",
"35931620", "Dobri\ dol\,\ Plovdiv",
"3597120", "Dolna\ banya",
"35991201", "Lyuti\ brod",
"3596566", "Dolni\ Vit",
"3599126", "Kameno\ pole",
"3594524", "Kamenovo\,\ Sliven",
"3596522", "Zgalevo",
"3599162", "Mihaylovo\,\ Vratsa",
"3596118", "Voneshta\ voda",
"3595321", "Praventsi",
"3593724", "Susam",
"3598670", "Silistra",
"35964", "Pleven",
"3598156", "Cherven\,\ Ruse",
"3596537", "Asenovtsi",
"3593629", "Most",
"3599529", "Borovtsi",
"3597938", "Dolno\ Uyno",
"3596169", "Blagoevo\,\ V\.\ Tarnovo",
"3595941", "Skalak\,\ Burgas",
"3596150", "Zlataritsa",
"3596047", "Zelena\ morava",
"3595772", "Telerig",
"3596906", "Cherni\ Vit",
"3593691", "Chernoochene",
"3598644", "Chernolik",
"3596329", "Tsarevets\,\ V\.\ Tarnovo",
"3599337", "Gramada",
"3595124", "Komarevo\,\ Varna",
"3593587", "Sestrimo",
"3598125", "Koprivets",
"35963573", "Disevitsa",
"35960383", "Berkovski",
"35961395", "Paskalevets",
"3599322", "Oreshets\,\ Vidin",
"3597742", "Kalishte",
"35931108", "Bogdanitsa",
"3595161", "Vetrino",
"3593755", "Belitsa\,\ Hask\.",
"3595771", "Krushari",
"35974403", "Dolno\ Draglishte",
"3595529", "Krushovo\,\ Burgas",
"359751", "Gotse\ Delchev",
"3598646", "Vokil",
"35951314", "Voyvodino",
"35961308", "Vishovgrad",
"3594350", "Gorno\ Izvorovo",
"3595162", "Belogradets",
"3597741", "Zemen",
"35961302", "Batak\,\ V\.\ Tarnovo",
"3595738", "Spasovo\,\ Dobr\.",
"3595126", "Cherkovna\,\ Varna",
"35984768", "Sinya\ voda",
"3594369", "Aleksandrovo\,\ St\.\ Zagora",
"3593922", "Brod",
"3596151", "Elena\,\ V\.\ Tarnovo",
"3597428", "Gabrene",
"35969247", "Gostinya",
"35951538", "Izgrev\,\ Varna",
"3598671", "Silistra",
"3597164", "Rebrovo",
"35931996", "Svezhen",
"3598638", "Bogdantsi\,\ Silistra",
"35953234", "Zlatna\ niva",
"3595320", "Pet\ mogili\,\ Shumen",
"3593342", "Narechenski\ bani",
"3599554", "Chiprovtsi",
"3593937", "Yabalkovo\,\ Hask\.",
"3595525", "Devetak",
"3594156", "Aprilovo\,\ St\.\ Zagora",
"3599133", "Komarevo\,\ Vratsa",
"3595746", "Belgun",
"3596713", "Vranilovtsi",
"35974405", "Kraishte\,\ Blag\.",
"3593759", "Borislavtsi",
"3599556", "Govezhda",
"3594154", "Mednikarovo",
"35963575", "Bohot",
"3596152", "Bebrovo",
"3593921", "Merichleri",
"359618", "Gorna\ Oryahovitsa",
"3595395", "Chernookovo\,\ Shumen",
"3597137", "Skravena",
"3595590", "Zhitosvyat",
"35960385", "Lomtsi",
"3598672", "Bradvari",
"35961393", "Gorsko\ Kosovo",
"3598129", "Lom\ Cherkovna",
"3596325", "Kozlovets",
"3593341", "Konush\,\ Plovdiv",
"3596520", "Nikolaevo\,\ Pleven",
"3599160", "Glozhene\,\ Vratsa",
"359431", "Kazanlak",
"3597166", "Vlado\ Trichkov",
"3596917", "Balgarene\,\ Lovech",
"3595554", "Momina\ tsarkva",
"3599525", "Dolno\ Ozirovo",
"3593625", "Shiroko\ pole",
"3596165", "Asenovo\,\ V\.\ Tarnovo",
"3594351", "Koprinka",
"3599320", "Stakevtsi",
"3599746", "Razgrad\,\ Mont\.",
"3596068", "Bozhurka",
"3595133", "General\ Kolevo\,\ Varna",
"35974404", "Babyak",
"3593053", "Hvoyna",
"35960384", "Gagovo",
"3594352", "Gorno\ Cherkovishte",
"3596987", "Karlukovo",
"3593146", "Kurtovo\ Konare",
"35931401", "Kadievo",
"3594749", "Ruzhitsa\,\ Yambol",
"35963574", "Todorovo\,\ Pleven",
"3593039", "Polkovnik\ Serafimovo",
"3598192", "Hotantsa",
"3595556", "Golyamo\ Bukovo",
"3594125", "Mihaylovo\,\ St\.\ Zagora",
"3593549", "Grashevo",
"359973", "Kozloduy",
"3599744", "Valchedram",
"3593109", "Lilkovo",
"3593076", "Tsatsarovtsi",
"3593647", "Chernichevo\,\ Kardzh\.",
"3599547", "Vinishte",
"3596029", "Nadarevo",
"35935502", "Fotinovo\,\ Pazardzhik",
"35963577", "Pelishat",
"35960387", "Gloginka",
"35981463", "Mogilino",
"359416", "Chirpan",
"35959694", "Gaberovo",
"35961403", "Orlovets",
"3599515", "Madan\,\ Mont\.",
"359590", "Tsarevo",
"3597181", "Pirdop",
"3593193", "Borets",
"3593707", "Nikolovo\,\ Hask\.",
"35969245", "Devetaki",
"3594115", "Kirilovo\,\ St\.\ Zagora",
"3595573", "Vezenkovo",
"35969615", "Balabansko",
"3596580", "Tatari",
"359357", "Panagyurishte",
"3594147", "Lyubenovo\,\ St\.\ Zagora",
"3597033", "Kraynitsi",
"3593074", "Erma\ reka",
"3597182", "Mirkovo",
"359519", "Devnya",
"35974407", "Kremen\,\ Blag\.",
"3597103", "Brusen\,\ Sofia",
"35960450", "Dolna\ Hubavka",
"3595757", "Bezmer\,\ Dobr\.",
"35984720", "Topchii",
"359379", "Svilengrad",
"35931998", "Choba",
"3596723", "Tsareva\ livada",
"3593530", "Poibrene",
"3593157", "Bolyarino",
"3593040", "Trigrad",
"3595515", "Kameno",
"35951536", "Nikolaevka",
"3595310", "Radko\ Dimitrievo",
"35931992", "Padarsko",
"3596931", "Ugarchin",
"3594730", "Knyazhevo",
"3597753", "Noevtsi",
"3596927", "Umarevtsi",
"3597528", "Hadzhidimovo",
"35984710", "Osenets",
"3596510", "Totleben",
"3598424", "Tsar\ Kaloyan\,\ Razgrad",
"35969244", "Tepava",
"3593563", "Varvara\,\ Pazardzhik",
"3596932", "Mikre",
"359556", "Obzor",
"3594763", "Irechekovo",
"3593673", "Tihomir",
"3596558", "Slavovitsa\,\ Pleven",
"35969614", "Gorno\ trape",
"35974496", "Filipovo\,\ Blag\.",
"3593786", "Navasen",
"35951428", "Gospodinovo\,\ Varna",
"35984392", "Belintsi",
"3599312", "Bregovo\,\ Vidin",
"35930200", "Zagrazhden\,\ Smol\.",
"3598115", "Chervena\ voda",
"3597735", "Leva\ reka",
"35930517", "Zabardo",
"3596581", "Byala\ voda\,\ Pleven",
"35974322", "Petrovo\,\ Blag\.",
"3598147", "Baniska",
"3595114", "Ezerovo\,\ Varna",
"3594586", "Neykovo\,\ Sliven",
"359697", "Lukovit",
"3599184", "Ohoden",
"3596143", "Maslarevo",
"3595116", "Krumovo\,\ Varna",
"3599311", "Kutovo",
"35981464", "Ostritsa\,\ Ruse",
"3596582", "Belene",
"3594584", "Ticha",
"3599186", "Zgorigrad",
"35984766", "Kamenar\,\ Razgrad",
"3595519", "Zidarovo",
"3593784", "Konstantinovo\,\ Hask\.",
"3598693", "Zvenimir",
"35961306", "Patresh",
"359725", "Elin\ Pelin",
"3594516", "Kermen",
"3594732", "Ustrem",
"3596963", "Balkanets",
"35969613", "Chiflik\,\ Lovech",
"3596734", "Petko\ Slaveykov",
"35941018", "Knyazhevsko",
"3593527", "Aleko\ Konstantinovo",
"35969243", "Kazachevo",
"3598185", "Senovo",
"3596511", "Pobeda\,\ Pleven",
"3594727", "Malak\ manastir",
"359748", "Simitli",
"3595312", "Dibich",
"3596177", "Yantra\,\ V\.\ Tarnovo",
"3593532", "Strelcha",
"35941359", "Izvorovo\,\ St\.\ Zagora",
"3593042", "Borino",
"3594343", "Konare\,\ St\.\ Zagora",
"35981465", "Batin",
"3597158", "Doganovo",
"3595589", "Vinarsko",
"35961405", "Petko\ Karavelovo",
"3596930", "Slavshtitsa",
"3595311", "Gradishte\,\ Shumen",
"3599568", "Blagovo\,\ Mont\.",
"3596128", "Hotnitsa",
"3596736", "Gradnitsa\,\ Gabr\.",
"3596512", "Gorni\ Dabnik",
"3594514", "Krushare",
"35937422", "Dolni\ Glavanak",
"3599116", "Kostelevo",
"35941270", "Malka\ Vereya",
"3597110", "Opitsvet",
"3594778", "Pobeda\,\ Yambol",
"35961397", "Musina",
"35967301", "Idilevo",
"3596025", "Alvanovo",
"3599173", "Galovo",
"3596158", "Sredni\ kolibi",
"35984727", "Kamenovo\,\ Razgrad",
"3597930", "Eremia",
"3594585", "Zheravna",
"3598678", "Sratsimir\,\ Silistra",
"35941111", "Starozagorski\ bani",
"3593785", "Dryanovo\,\ Hask\.",
"3598631", "Silistra",
"3593163", "Iskra\,\ Plovdiv",
"35951539", "Levski\,\ Varna",
"35931604", "Dragoynovo",
"3598116", "Ivanovo\,\ Ruse",
"3598627", "Babuk",
"35984717", "Pobit\ kamak\,\ Razgrad",
"35958", "Dobrich",
"35935391", "Blatnitsa",
"3593928", "Dolno\ Belevo",
"3594757", "Nedyalsko",
"3597422", "Topolnitsa\,\ Blag\.",
"3595147", "Pchelnik\,\ Varna",
"35937704", "Mladinovo",
"3597734", "Glavanovtsi\,\ Pernik",
"35935255", "Rosen\,\ Pazardzhik",
"3593773", "Kapitan\ Andreevo",
"3598114", "Pirgovo",
"3597177", "Aldomirovtsi",
"359722", "Samokov",
"3597437", "Melnik",
"3595115", "General\ Kantardzhievo",
"3598632", "Zafirovo",
"3593348", "Dobralak",
"3593130", "Karavelovo\,\ Plovdiv",
"35936402", "Gorna\ kula",
"35941173", "Bratya\ Kunchevi",
"3593557", "Byaga",
"3599185", "Beli\ Izvor",
"3597054", "Rila",
"359559", "Karnobat",
"35963570", "Staroseltsi",
"3594793", "Boyadzhik",
"3594107", "Sredets\,\ St\.\ Zagora",
"3594358", "Skobelevo\,\ St\.\ Zagora",
"3597143", "Vakarel",
"3596061", "Golyamo\ Sokolovo",
"35960380", "Drinovo",
"3595967", "Bata",
"3594515", "Mokren",
"35971306", "Rashkovo",
"35962", "Veliko\ Tarnovo",
"3593747", "Tatarevo\,\ Hask\.",
"3596024", "Ruets",
"35931605", "Bukovo\,\ Plovdiv",
"35937705", "Pastrogor",
"35935254", "Dobrovnitsa",
"3593323", "Bolyartsi\,\ Plovdiv",
"3599115", "Chiren",
"3596062", "Strazha\,\ Targ\.",
"3593079", "Kozarka",
"3596026", "Makariopolsko",
"3595763", "Plachidol",
"3597056", "Mursalevo",
"3598184", "Glodzhevo",
"35971471", "Ochusha",
"3599147", "Borovan",
"35930472", "Mihalkovo",
"35930256", "Galabovo\,\ Smol\.",
"35941356", "Rupkite",
"3598663", "Sitovo\,\ Silistra",
"35995277", "Cherkaski",
"35941174", "Podslon\,\ St\.\ Zagora",
"3599168", "Butan",
"3596528", "Valchitran",
"3596112", "Samovodene",
"3597927", "Treklyano",
"3599516", "Lehchevo",
"3593075", "Dolen\,\ Smol\.",
"3596957", "Golyama\ Zhelyazna",
"35937703", "Dimitrovche",
"3599727", "Medkovets",
"3599119", "Tishevitsa",
"3597932", "Shipochano",
"3593178", "Krasnovo",
"3596577", "Breste",
"3593132", "Banya\,\ Plovdiv",
"3593768", "Dositeevo",
"3597723", "Dolni\ Rakovets",
"3594519", "Samuilovo\,\ Sliven",
"3599343", "Gomotartsi",
"35941489", "Bozduganovo",
"3595328", "Nikola\ Kozlevo",
"3596111", "Kapinovo\,\ V\.\ Tarnovo",
"3598630", "Silistra",
"35931603", "Vinitsa",
"359670", "Troyan\,\ Lovech",
"3593719", "Knizhovnik",
"35941277", "Zagore",
"3593127", "Tsaratsovo",
"3599514", "Vladimirovo\,\ Mont\.",
"3594116", "Rakitnitsa\,\ St\.\ Zagora",
"3595948", "Snyagovo\,\ Burgas",
"3599189", "Pavolche",
"3595119", "Ignatievo",
"35941175", "Kolena",
"3595727", "Senokos\,\ Dobr\.",
"3595732", "Petleshkovo",
"3595516", "Indzhe\ voyvoda",
"3596543", "Muselievo",
"35984749", "Sevar",
"35984467", "Seslav",
"3595168", "Petrov\ dol\,\ Varna",
"3596033", "Medovina",
"35961309", "Gorsko\ Kalugerovo",
"35947202", "Zhrebino",
"35984769", "Gorotsvet",
"3596060", "Ovcharovo\,\ Targ\.",
"35974386", "Pirin",
"3599328", "Dolni\ Lom",
"3595343", "Venets\,\ Shumen",
"3595731", "General\ Toshevo\,\ Dobr\.",
"3594337", "Yasenovo\,\ St\.\ Zagora",
"3596944", "Krushuna",
"3594155", "Glavan\,\ St\.\ Zagora",
"3595526", "Klikach",
"3595745", "Vranino",
"3595394", "Byala\ reka\,\ Shumen",
"3596588", "Dekov",
"3594322", "Yagoda",
"35951429", "Solnik",
"3595717", "Vedrina",
"3596324", "Vardim",
"35941275", "Lyaskovo\,\ St\.\ Zagora",
"3595129", "Blaskovo",
"3598649", "Yarebitsa",
"3599787", "Smirnenski\,\ Mont\.",
"3594364", "Osetenovo",
"35961706", "Pisarevo\,\ V\.\ Tarnovo",
"3596326", "Morava",
"3599318", "Bukovets\,\ Vidin",
"3596909", "Malka\ Zhelyazna",
"35960453", "Moravka",
"359391", "Dimitrovgrad",
"3593023", "Momchilovtsi",
"3597165", "Milanovo\,\ Sofia",
"3594592", "Byala\ palanka",
"3596946", "Chavdartsi",
"3599555", "Kopilovtsi\,\ Mont\.",
"3595913", "Krushevets",
"35984464", "Veselets\,\ Razgrad",
"3595524", "Ekzarh\ Antimovo",
"3594321", "Maglizh",
"3595396", "Lovets\,\ Shumen",
"35974388", "Gorno\ Spanchevo",
"35941352", "Vinarovo\,\ St\.\ Zagora",
"3596137", "Butovo",
"3599129", "Sinyo\ bardo",
"3596569", "Lenkovo",
"3596550", "Stavertsi",
"35969032", "Balgarski\ izvor",
"3596007", "Ralitsa",
"3597152", "Gorna\ Malina",
"35941358", "Opalchenets",
"3594124", "Zmeyovo",
"3596166", "Vinograd",
"3599526", "Slatina\,\ Mont\.",
"3593626", "Perperek",
"35984723", "Dyankovo",
"3597917", "Tavalichevo",
"3596122", "Belyakovets",
"3593662", "Zhelezino",
"3596518", "Riben",
"35967774", "Belitsa\,\ Gabr\.",
"3599745", "Zlatia\,\ Mont\.",
"35941274", "Samuilovo\,\ St\.\ Zagora",
"3594772", "Simeonovo\,\ Yambol",
"3598159", "Koshov",
"35941019", "Venets\,\ St\.\ Zagora",
"3597520", "Kornitsa",
"3594126", "Hrishteni",
"35931627", "Krushevo\,\ Plovdiv",
"3594738", "Hlyabovo",
"3595555", "Fakia",
"35930205", "Starnitsa",
"3593624", "Chiflik\,\ Kardzh\.",
"3599524", "Yagodovo\,\ Mont\.",
"3596164", "Bryagovitsa",
"3593117", "Katunitsa",
"3593729", "Krivo\ pole",
"3596121", "Nikyup",
"3599561", "Sumer",
"3593661", "Ivaylovgrad",
"3595318", "Srednya",
"35984713", "Blagoevo\,\ Razgrad",
"3594529", "Sadievo\,\ Sliven",
"3593145", "Krichim",
"3598133", "Ryahovo",
"3597713", "Rudartsi",
"3594771", "Malomir\,\ Yambol",
"3593538", "Elshitsa",
"35984465", "Savin",
"3594746", "Popovo\,\ Yambol",
"3599351", "Izvor\,\ Vidin",
"35984463", "Prelez",
"35935257", "Saraya",
"3593149", "Tsalapitsa",
"3594525", "Omarchevo\,\ Sliven",
"35960454", "Zmeyno",
"35971302", "Bozhenitsa",
"3593106", "Stroevo",
"3593725", "Stamboliyski\,\ Hask\.",
"3593036", "Mogilitsa",
"3595365", "Lyatno",
"3597188", "Petrich\,\ Sofia",
"3595559", "Kubadin",
"35984725", "Kichenitsa",
"3593104", "Yagodovo\,\ Plovdiv",
"3599749", "Cherni\ vrah\,\ Mont\.",
"359745", "Petrich\,\ Blag\.",
"3593544", "Kostandovo",
"359938", "Kula",
"3599352", "Druzhba",
"3593034", "Levochevo",
"3594744", "Golyamo\ Krushevo",
"359728", "Zlatitsa",
"3595533", "Pirne",
"3596565", "Milkovitsa",
"3599125", "Gorna\ Beshovitsa",
"3596359", "Glava",
"35930476", "Selcha",
"3594770", "General\ Inzovo",
"3593754", "Lozen\,\ Hask\.",
"3597118", "Dragovishtitsa\,\ Sofia",
"35937707", "Shtit",
"35931791", "Begovo",
"3597522", "Dabnitsa",
"35969240", "Hlevene",
"3599559", "Gorna\ Kovachitsa",
"3599560", "Bezdenitsa",
"3597169", "Tompsan",
"35974347", "Razdol",
"3596938", "Kalenik\,\ Lovech",
"3596905", "Divchovoto",
"35936700", "Shoptsi",
"3597047", "Usoyka",
"3594554", "Trapoklovo",
"3595351", "Smyadovo",
"3596552", "Dolna\ Mitropolia",
"3593633", "Rogozche",
"3598645", "Mezhden",
"3597521", "Koprivlen",
"3598161", "Vetovo",
"35947193", "Mogila\,\ Yambol",
"3595125", "Gradinarovo",
"359721", "Kostinbrod",
"3594556", "Sotirya",
"3598124", "Novgrad",
"3593756", "Valche\ pole",
"3595749", "Krapets\,\ Dobr\.",
"3596551", "Trastenik\,\ Pleven",
"359538", "Veliki\ Preslav",
"3595352", "Yankovo",
"3599329", "Rabisha",
"3596155", "Konstantin",
"3594361", "Pavel\ banya",
"35977229", "Galabnik",
"3596942", "Aleksandrovo\,\ Lovech",
"3598675", "Aydemir",
"3594588", "Filaretovo",
"35931997", "Zlatosel",
"3596591", "Gornik",
"3595392", "Mengishevo",
"3594324", "Shipka",
"3596322", "Alekovo\,\ V\.\ Tarnovo",
"35969616", "Staro\ selo\,\ Lovech",
"3595521", "Venets\,\ Burgas",
"3597125", "Govedartsi",
"3596941", "Letnitsa",
"3594362", "Manolovo",
"3595169", "Momchilovo",
"3595537", "Sadievo\,\ Burgas",
"3594326", "Enina",
"3593925", "Krum",
"3595391", "Varbitsa\,\ Shumen",
"35954", "Shumen",
"3595118", "Voditsa\,\ Varna",
"3595522", "Iskra\,\ Burgas",
"3596321", "Gorna\ Studena",
"3593345", "Lyaskovo\,\ Plovdiv",
"3593030", "Shiroka\ laka",
"3592", "Sofia",
"3593100", "Belashtitsa",
"3599188", "Gorno\ Peshtene",
"3593699", "Gabrovo\,\ Kardzh\.",
"3597533", "Osikovo\,\ Blag\.",
"3596161", "Strazhitsa\,\ V\.\ Tarnovo",
"3599521", "Zamfirovo",
"35960388", "Goritsa\,\ Targ\.",
"35963572", "Yasen\,\ Pleven",
"3594355", "Buzovgrad",
"3594137", "Veren",
"3595949", "Planinitsa\,\ Burgas",
"3597043", "Golemo\ selo",
"3593718", "Voyvodovo\,\ Hask\.",
"35960382", "Kovachevets",
"35963578", "Opanets\,\ Pleven",
"3597154", "Stolnik",
"3594122", "Elenino",
"3594518", "Topolchane",
"3599564", "Stubel",
"3596124", "Ledenik",
"3593664", "Plevun",
"3595329", "Mirovtsi",
"35984743", "Brestovene",
"359749", "Bansko",
"3594774", "Krumovo\,\ Yambol",
"35974495", "Yurukovo",
"35967194", "Grablevtsi",
"3593769", "Oreshets\,\ Hask\.",
"3596126", "Tserova\ koria",
"3593666", "Popsko",
"3596738", "Dobromirka",
"35984763", "Beli\ Lom",
"3599522", "Kotenovtsi",
"3593622", "Stremtsi",
"35961303", "Gorna\ Lipnitsa",
"3595599", "Hadzhiite",
"3596529", "Koilovtsi",
"3599169", "Rogozen",
"3593637", "Gruevo",
"3594121", "Lyulyak",
"35974408", "Obidim",
"35941331", "Granit",
"35974402", "Godlevo",
"3597156", "Ravno\ pole",
"35994", "Vidin",
"3595713", "Stefanovo\,\ Dobr\.",
"3593101", "Voyvodinovo",
"3596525", "Barkach",
"3599165", "Sofronievo",
"3599783", "Brusartsi",
"3594333", "Dabovo\,\ St\.\ Zagora",
"3594741", "Bolyarovo",
"35984765", "Veselina",
"35941484", "Zemlen",
"3599356", "Kalenik\,\ Vidin",
"35961305", "Lesicheri",
"3593175", "Dalgo\ pole\,\ Plovdiv",
"3595917", "Izvor\,\ Burgas",
"35984745", "Vladimirovtsi",
"3593102", "Karadzhovo",
"3593765", "Ivanovo\,\ Hask\.",
"3595520", "Cherkovo",
"3593542", "Rakitovo",
"3599354", "Antimovo\,\ Vidin",
"3593032", "Srednogortsi",
"3595325", "Voyvoda",
"3596590", "Rakita\,\ Pleven",
"35941179", "Han\ Asparuhovo",
"3594742", "Stefan\ Karadzhovo",
"3593027", "Slaveyno",
"3597192", "Gintsi",
"359518", "Provadia",
"3595945", "Dobromir",
"3594359", "Asen\,\ St\.\ Zagora",
"35981466", "Pomen",
"3598164", "Pisanets",
"3593752", "Malko\ gradishte",
"3596770", "Plachkovtsi",
"3593695", "Komuniga",
"3597913", "Rashka\ Grashtitsa",
"359702", "Bobov\ dol",
"3597524", "Ablanitsa\,\ Blag\.",
"35961406", "Karantsi",
"3593349", "Boyantsi",
"35961304", "Dimcha",
"35974327", "Novo\ Delchevo",
"3596133", "Mihaltsi",
"3595783", "Kotlentsi",
"35984764", "Seydol",
"3594552", "Stara\ reka\,\ Sliven",
"3596003", "Preselets",
"359605", "Omurtag",
"3596554", "Krushovene",
"3593929", "Golyamo\ Asenovo",
"3595165", "Nevsha",
"35967193", "Kmetovtsi",
"3597129", "Raduil",
"3593751", "Lyubimets",
"3598477", "Samuil",
"3595775", "Polkovnik\ Dyakovo",
"35930528", "Manastir\,\ Plovdiv",
"3598137", "Golyamo\ Vranovo",
"3597717", "Divotino",
"35993342", "Kireevo",
"3596556", "Gorna\ Mitropolia",
"35984744", "Belovets",
"3598122", "Tsenovo\,\ Ruse",
"3598679", "Kaynardzha",
"3597526", "Ribnovo",
"3598166", "Svalenik",
"3595354", "Rish",
"3593113", "Branipole",
"3596159", "Zlataritsa",
"3597745", "Egalnitsa",
"3599325", "Belo\ pole\,\ Vidin",
"3594551", "Byala\,\ Sliven",
"3599520", "Gorno\ Ozirovo",
"35981462", "Volovo",
"359726", "Svoge",
"3598636", "Glavinitsa\,\ Silistra",
"3596953", "Borima",
"3594158", "Iskritsa",
"35984469", "Bozhurovo\,\ Razgrad",
"35961402", "Stefan\ Stambolovo",
"3599723", "Traykovo",
"3598111", "Shtraklevo",
"3597731", "Tran",
"359337", "Hisarya",
"3596585", "Belene",
"3595748", "Durankulak",
"3597426", "Marikostinovo",
"3598667", "Belitsa\,\ Silistra",
"359701", "Dupnitsa",
"359936", "Belogradchik",
"3597923", "Vrattsa",
"35974201", "Kapatovo",
"3597424", "Karnalovo",
"3599315", "Gradets\,\ Vidin",
"359619", "Lyaskovets\,\ V\.\ Tarnovo",
"3593123", "Kaloyanovo\,\ Plovdiv",
"3596939", "Dragana",
"3597168", "Bov",
"35984394", "Duhovets",
"3597732", "Vukan",
"3595580", "Troyanovo\,\ Burgas",
"3599558", "Gavril\ Genovo",
"3593658", "Padina\,\ Kardzh\.",
"3596573", "Koynare",
"3598634", "Nova\ Cherna",
"3597727", "Kovachevtsi\,\ Pernik",
"35967391", "Stolat",
"35961307", "Stambolovo\,\ V\.\ Tarnovo",
"35974324", "Struma",
"3599347", "Bela\ Rada",
"3597119", "Dramsha",
"3597052", "Pastra",
"35941350", "Mirovo\,\ St\.\ Zagora",
"3596547", "Dragash\ voyvoda",
"35942", "Stara\ Zagora",
"3596515", "Slavyanovo\,\ Pleven",
"3596022", "Probuda\,\ Targ\.",
"3599748", "Dalgodeltsi",
"3595723", "Gurkovo\,\ Dobr\.",
"3596066", "Buynovo\,\ Targ\.",
"35931993", "Sarnegor",
"35937424", "Kozlets",
"3597189", "Chavdar\,\ Sofia",
"3596997", "Dobrevtsi\,\ Lovech",
"3595558", "Debelt",
"3596064", "Golyamo\ Novo",
"35941279", "Strelets\,\ St\.\ Zagora",
"3595347", "Zhivkovo\,\ Shumen",
"3595315", "Tsarev\ brod",
"3593148", "Yoakim\ Gruevo",
"35974325", "Lilyanovo",
"3593045", "Dospat",
"3593535", "Levski\,\ Pazardzhik",
"3596021", "Buhovtsi",
"3593049", "Beden",
"35974323", "Lozenitsa",
"3593167", "Bryagovo\,\ Plovdiv",
"35963576", "Tuchenitsa",
"3595319", "Drumevo",
"35960386", "Voditsa\,\ Targ\.",
"3596114", "Kilifarevo",
"3594528", "Lyubenova\ mahala",
"3594112", "Badeshte",
"35984393", "Vazovo",
"3593728", "Slavyanovo\,\ Hask\.",
"3593136", "Rozino\,\ Plovdiv",
"359848", "Kubrat",
"3594739", "Radovets",
"3595368", "Takach",
"3597185", "Chelopech",
"3597934", "Bunovo\,\ Kyust\.",
"3593134", "Sopot\,\ Plovdiv",
"3597433", "Kresna",
"3598158", "Mechka\,\ Ruse",
"35931995", "Streltsi\,\ Plovdiv",
"3597936", "Slokoshtitsa",
"3593553", "Batak\,\ Pazardzhik",
"359350", "Peshtera\,\ Pazardzhik",
"3596519", "Beglezh",
"3598623", "Golesh\,\ Silistra",
"35961101", "Velchevo\,\ V\.\ Tarnovo",
"359470", "Topolovgrad",
"3594753", "Zornitsa\,\ Yambol",
"35974406", "Dobarsko",
"3599512", "Beli\ breg",
"3599128", "Eliseyna",
"3596568", "Dabovan",
"35931258", "Glavatar",
"3595143", "Byala\,\ Varna",
"3593777", "Mezek",
"3596116", "Golemanite",
"35969242", "Presyaka",
"359777", "Radomir",
"35971798", "Vasilovtsi\,Sof\.",
"3596020", "Lilyak",
"3593743", "Silen",
"35951537", "Chernevo",
"3595511", "Lukoil\ Neftochim",
"35969248", "Skobelevo\,\ Lovech",
"3596908", "Glogovo",
"35978", "Kyustendil",
"3596935", "Sopot\,\ Lovech",
"3594797", "Galabintsi",
"35936702", "Gorski\ izvor\,\ Kardzh\.",
"3594103", "Byal\ izvor\,\ St\.\ Zagora",
"35969612", "Terziysko\,\ Lovech",
"35984729", "Ezerche",
"3597147", "Pchelin\,\ Sofia",
"3595734", "Preselentsi",
"3599319", "Gamzovo",
"3598648", "Sekulovo",
"35937423", "Golemantsi",
"3599143", "Enitsa",
"3595736", "Vasilevo",
"3595128", "Zhitnitsa\,\ Varna",
"35982", "Ruse",
"3593327", "Bachkovo",
"3596589", "Kulina\ voda",
"35984719", "Balkanski",
"3595767", "Zhitnitsa\,\ Dobr\.",};
my $timezones = {
               '' => [
                       'Europe/Sofia'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+359|\D)//g;
      my $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;