# Generated by default/object.tt
package Paws::CloudWatchEvents::Archive;
  use Moose;
  has ArchiveName => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has EventCount => (is => 'ro', isa => 'Int');
  has EventSourceArn => (is => 'ro', isa => 'Str');
  has RetentionDays => (is => 'ro', isa => 'Int');
  has SizeBytes => (is => 'ro', isa => 'Int');
  has State => (is => 'ro', isa => 'Str');
  has StateReason => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::Archive

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::Archive object:

  $service_obj->Method(Att1 => { ArchiveName => $value, ..., StateReason => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::Archive object:

  $result = $service_obj->Method(...);
  $result->Att1->ArchiveName

=head1 DESCRIPTION

An C<Archive> object that contains details about an archive.

=head1 ATTRIBUTES


=head2 ArchiveName => Str

The name of the archive.


=head2 CreationTime => Str

The time stamp for the time that the archive was created.


=head2 EventCount => Int

The number of events in the archive.


=head2 EventSourceArn => Str

The ARN of the event bus associated with the archive. Only events from
this event bus are sent to the archive.


=head2 RetentionDays => Int

The number of days to retain events in the archive before they are
deleted.


=head2 SizeBytes => Int

The size of the archive, in bytes.


=head2 State => Str

The current state of the archive.


=head2 StateReason => Str

A description for the reason that the archive is in the current state.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

