# Generated by default/object.tt
package Paws::Appflow::ErrorInfo;
  use Moose;
  has ExecutionMessage => (is => 'ro', isa => 'Str', request_name => 'executionMessage', traits => ['NameInRequest']);
  has PutFailuresCount => (is => 'ro', isa => 'Int', request_name => 'putFailuresCount', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::ErrorInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::ErrorInfo object:

  $service_obj->Method(Att1 => { ExecutionMessage => $value, ..., PutFailuresCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::ErrorInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->ExecutionMessage

=head1 DESCRIPTION

Provides details in the event of a failed flow, including the failure
count and the related error messages.

=head1 ATTRIBUTES


=head2 ExecutionMessage => Str

Specifies the error message that appears if a flow fails.


=head2 PutFailuresCount => Int

Specifies the failure count for the attempted flow.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

