# Generated by default/object.tt
package Paws::ECS::LogConfiguration;
  use Moose;
  has LogDriver => (is => 'ro', isa => 'Str', request_name => 'logDriver', traits => ['NameInRequest'], required => 1);
  has Options => (is => 'ro', isa => 'Paws::ECS::LogConfigurationOptionsMap', request_name => 'options', traits => ['NameInRequest']);
  has SecretOptions => (is => 'ro', isa => 'ArrayRef[Paws::ECS::Secret]', request_name => 'secretOptions', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECS::LogConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECS::LogConfiguration object:

  $service_obj->Method(Att1 => { LogDriver => $value, ..., SecretOptions => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECS::LogConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->LogDriver

=head1 DESCRIPTION

The log configuration for the container. This parameter maps to
C<LogConfig> in the Create a container
(https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate)
section of the Docker Remote API
(https://docs.docker.com/engine/api/v1.35/) and the C<--log-driver>
option to C<docker run>
(https://docs.docker.com/engine/reference/commandline/run/).

By default, containers use the same logging driver that the Docker
daemon uses; however the container may use a different logging driver
than the Docker daemon by specifying a log driver configuration in the
container definition. For more information on the options for different
supported log drivers, see Configure logging drivers
(https://docs.docker.com/engine/admin/logging/overview/) in the Docker
documentation.

The following should be noted when specifying a log configuration for
your containers:

=over

=item *

Amazon ECS currently supports a subset of the logging drivers available
to the Docker daemon (shown in the valid values below). Additional log
drivers may be available in future releases of the Amazon ECS container
agent.

=item *

This parameter requires version 1.18 of the Docker Remote API or
greater on your container instance.

=item *

For tasks hosted on Amazon EC2 instances, the Amazon ECS container
agent must register the available logging drivers with the
C<ECS_AVAILABLE_LOGGING_DRIVERS> environment variable before containers
placed on that instance can use these log configuration options. For
more information, see Amazon ECS container agent configuration
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html)
in the I<Amazon Elastic Container Service Developer Guide>.

=item *

For tasks on AWS Fargate, because you do not have access to the
underlying infrastructure your tasks are hosted on, any additional
software needed will have to be installed outside of the task. For
example, the Fluentd output aggregators or a remote host running
Logstash to send Gelf logs to.

=back


=head1 ATTRIBUTES


=head2 B<REQUIRED> LogDriver => Str

The log driver to use for the container.

For tasks on AWS Fargate, the supported log drivers are C<awslogs>,
C<splunk>, and C<awsfirelens>.

For tasks hosted on Amazon EC2 instances, the supported log drivers are
C<awslogs>, C<fluentd>, C<gelf>, C<json-file>, C<journald>,
C<logentries>,C<syslog>, C<splunk>, and C<awsfirelens>.

For more information about using the C<awslogs> log driver, see Using
the awslogs log driver
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html)
in the I<Amazon Elastic Container Service Developer Guide>.

For more information about using the C<awsfirelens> log driver, see
Custom log routing
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html)
in the I<Amazon Elastic Container Service Developer Guide>.

If you have a custom driver that is not listed, you can fork the Amazon
ECS container agent project that is available on GitHub
(https://github.com/aws/amazon-ecs-agent) and customize it to work with
that driver. We encourage you to submit pull requests for changes that
you would like to have included. However, we do not currently provide
support for running modified copies of this software.


=head2 Options => L<Paws::ECS::LogConfigurationOptionsMap>

The configuration options to send to the log driver. This parameter
requires version 1.19 of the Docker Remote API or greater on your
container instance. To check the Docker Remote API version on your
container instance, log in to your container instance and run the
following command: C<sudo docker version --format
'{{.Server.APIVersion}}'>


=head2 SecretOptions => ArrayRef[L<Paws::ECS::Secret>]

The secrets to pass to the log configuration. For more information, see
Specifying Sensitive Data
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html)
in the I<Amazon Elastic Container Service Developer Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

