# Generated by default/object.tt
package Paws::Macie2::ObjectLevelStatistics;
  use Moose;
  has FileType => (is => 'ro', isa => 'Int', request_name => 'fileType', traits => ['NameInRequest']);
  has StorageClass => (is => 'ro', isa => 'Int', request_name => 'storageClass', traits => ['NameInRequest']);
  has Total => (is => 'ro', isa => 'Int', request_name => 'total', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::ObjectLevelStatistics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::ObjectLevelStatistics object:

  $service_obj->Method(Att1 => { FileType => $value, ..., Total => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::ObjectLevelStatistics object:

  $result = $service_obj->Method(...);
  $result->Att1->FileType

=head1 DESCRIPTION

Provides information about the total storage size (in bytes) or number
of objects that Amazon Macie can't analyze in one or more S3 buckets.
In a BucketMetadata or MatchingBucket object, this data is for a
specific bucket. In a GetBucketStatisticsResponse object, this data is
aggregated for all the buckets in the query results. If versioning is
enabled for a bucket, total storage size values are based on the size
of the latest version of each applicable object in the bucket.

=head1 ATTRIBUTES


=head2 FileType => Int

The total storage size (in bytes) or number of objects that Amazon
Macie can't analyze because the objects don't have a file name
extension for a supported file or storage format.


=head2 StorageClass => Int

The total storage size (in bytes) or number of objects that Amazon
Macie can't analyze because the objects use an unsupported storage
class.


=head2 Total => Int

The total storage size (in bytes) or number of objects that Amazon
Macie can't analyze because the objects use an unsupported storage
class or don't have a file name extension for a supported file or
storage format.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

