#########################################################################################
# Package        HiPi::Graphics::BitmapFont::Sans33
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::Sans33;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 33;
my $line_spacing = 4;
my $name = 'Sans 33';
my $space_width = 10;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 3, 
        'xoffset'  => 5, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 9, 
        'xoffset'  => 3, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0xE3, 0x80, ##  000   000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x60, 0xC0, ##           00     00    
            0x00, 0x60, 0xC0, ##           00     00    
            0x00, 0x61, 0xC0, ##           00    000    
            0x00, 0xE1, 0xC0, ##          000    000    
            0x00, 0xE1, 0xC0, ##          000    000    
            0x00, 0xC1, 0x80, ##          00     00     
            0x00, 0xC1, 0x80, ##          00     00     
            0x3F, 0xFF, 0xFC, ##    00000000000000000000
            0x3F, 0xFF, 0xFC, ##    00000000000000000000
            0x01, 0x83, 0x00, ##         00     00      
            0x01, 0x83, 0x00, ##         00     00      
            0x03, 0x87, 0x00, ##        000    000      
            0x03, 0x87, 0x00, ##        000    000      
            0x03, 0x06, 0x00, ##        00     00       
            0xFF, 0xFF, 0xF0, ##  00000000000000000000  
            0xFF, 0xFF, 0xF0, ##  00000000000000000000  
            0x06, 0x0C, 0x00, ##       00     00        
            0x06, 0x0C, 0x00, ##       00     00        
            0x0E, 0x1C, 0x00, ##      000    000        
            0x0E, 0x1C, 0x00, ##      000    000        
            0x0E, 0x1C, 0x00, ##      000    000        
            0x0C, 0x18, 0x00, ##      00     00         
            0x0C, 0x18, 0x00, ##      00     00         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x1F, 0xF0, ##     000000000   
            0x3F, 0xFC, ##    000000000000 
            0x73, 0x1C, ##   000  00   000 
            0xE3, 0x00, ##  000   00       
            0xE3, 0x00, ##  000   00       
            0xE3, 0x00, ##  000   00       
            0xE3, 0x00, ##  000   00       
            0xF3, 0x00, ##  0000  00       
            0x7B, 0x00, ##   0000 00       
            0x7F, 0xC0, ##   000000000     
            0x1F, 0xF8, ##     0000000000  
            0x03, 0xFC, ##        00000000 
            0x03, 0x3C, ##        00  0000 
            0x03, 0x1E, ##        00   0000
            0x03, 0x0E, ##        00    000
            0x03, 0x0E, ##        00    000
            0x03, 0x0E, ##        00    000
            0x83, 0x1E, ##  0     00   0000
            0xE3, 0x3C, ##  000   00  0000 
            0xFF, 0xF8, ##  0000000000000  
            0x3F, 0xE0, ##    000000000    
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x03, 0x00, ##        00       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 27, 
        'xoffset'  => 2, 
        'xadvance' => 31, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x1F, 0x00, 0x1C, 0x00, ##     00000           000     
            0x7F, 0xC0, 0x18, 0x00, ##   000000000         00      
            0x71, 0xC0, 0x30, 0x00, ##   000   000        00       
            0xE0, 0xE0, 0x30, 0x00, ##  000     000       00       
            0xE0, 0xE0, 0x60, 0x00, ##  000     000      00        
            0xE0, 0xE0, 0xC0, 0x00, ##  000     000     00         
            0xE0, 0xE0, 0xC0, 0x00, ##  000     000     00         
            0xE0, 0xE1, 0x80, 0x00, ##  000     000    00          
            0x71, 0xC3, 0x80, 0x00, ##   000   000    000          
            0x7F, 0xC3, 0x00, 0x00, ##   000000000    00           
            0x1F, 0x06, 0x1F, 0x00, ##     00000     00    00000   
            0x00, 0x0E, 0x3F, 0x80, ##              000   0000000  
            0x00, 0x0C, 0x71, 0xC0, ##              00   000   000 
            0x00, 0x18, 0xF1, 0xC0, ##             00   0000   000 
            0x00, 0x38, 0xE0, 0xE0, ##            000   000     000
            0x00, 0x30, 0xE0, 0xE0, ##            00    000     000
            0x00, 0x60, 0xE0, 0xE0, ##           00     000     000
            0x00, 0x60, 0xE0, 0xE0, ##           00     000     000
            0x00, 0xC0, 0xE0, 0xE0, ##          00      000     000
            0x01, 0x80, 0xF1, 0xE0, ##         00       0000   0000
            0x01, 0x80, 0x71, 0xC0, ##         00        000   000 
            0x03, 0x00, 0x3F, 0x80, ##        00          0000000  
            0x07, 0x00, 0x1F, 0x00, ##       000           00000   
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xF8, 0x00, ##        0000000         
            0x07, 0xFC, 0x00, ##       000000000        
            0x0E, 0x0C, 0x00, ##      000     00        
            0x1C, 0x00, 0x00, ##     000                
            0x1C, 0x00, 0x00, ##     000                
            0x1C, 0x00, 0x00, ##     000                
            0x1C, 0x00, 0x00, ##     000                
            0x1E, 0x00, 0x00, ##     0000               
            0x0F, 0x00, 0x00, ##      0000              
            0x0F, 0x80, 0x00, ##      00000             
            0x1F, 0xC0, 0x00, ##     0000000            
            0x39, 0xE0, 0x38, ##    000  0000       000 
            0x70, 0xF0, 0x38, ##   000    0000      000 
            0xE0, 0x70, 0x30, ##  000      000      00  
            0xE0, 0x78, 0x70, ##  000      0000    000  
            0xE0, 0x3C, 0x70, ##  000       0000   000  
            0xE0, 0x1E, 0xE0, ##  000        0000 000   
            0xE0, 0x0F, 0xE0, ##  000         0000000   
            0x70, 0x07, 0xC0, ##   000         00000    
            0x78, 0x07, 0xC0, ##   0000        00000    
            0x3C, 0x0F, 0xE0, ##    0000      0000000   
            0x1F, 0xFE, 0xF8, ##     000000000000 00000 
            0x07, 0xF0, 0x3C, ##       0000000      0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 3, 
        'xoffset'  => 3, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 7, 
        'xoffset'  => 3, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x0E, ##      000
            0x0C, ##      00 
            0x1C, ##     000 
            0x18, ##     00  
            0x38, ##    000  
            0x38, ##    000  
            0x70, ##   000   
            0x70, ##   000   
            0x70, ##   000   
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0x70, ##   000   
            0x70, ##   000   
            0x70, ##   000   
            0x30, ##    00   
            0x38, ##    000  
            0x38, ##    000  
            0x1C, ##     000 
            0x1C, ##     000 
            0x0E, ##      000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 7, 
        'xoffset'  => 3, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000    
            0x60, ##   00    
            0x70, ##   000   
            0x30, ##    00   
            0x38, ##    000  
            0x38, ##    000  
            0x1C, ##     000 
            0x1C, ##     000 
            0x1C, ##     000 
            0x0C, ##      00 
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x0E, ##      000
            0x1C, ##     000 
            0x1C, ##     000 
            0x1C, ##     000 
            0x18, ##     00  
            0x38, ##    000  
            0x38, ##    000  
            0x70, ##   000   
            0x70, ##   000   
            0xE0, ##  000    
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0xC3, 0x0C, ##  00    00    00
            0x73, 0x38, ##   000  00  000 
            0x1F, 0xE0, ##     00000000   
            0x0F, 0xC0, ##      000000    
            0x0F, 0xC0, ##      000000    
            0x1F, 0xE0, ##     00000000   
            0x73, 0x38, ##   000  00  000 
            0xC3, 0x0C, ##  00    00    00
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x03, 0x00, ##        00      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x70, 0x00, ##           000        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 4, 
        'xoffset'  => 3, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x70, ##   000
            0x70, ##   000
            0x60, ##   00 
            0xE0, ##  000 
            0xC0, ##  00  
            0xC0, ##  00  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 3, 
        'xoffset'  => 3, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 11, 
        'xoffset'  => 0, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xE0, ##          000
            0x00, 0xC0, ##          00 
            0x01, 0xC0, ##         000 
            0x01, 0xC0, ##         000 
            0x01, 0x80, ##         00  
            0x03, 0x80, ##        000  
            0x03, 0x80, ##        000  
            0x03, 0x00, ##        00   
            0x03, 0x00, ##        00   
            0x07, 0x00, ##       000   
            0x07, 0x00, ##       000   
            0x06, 0x00, ##       00    
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x0C, 0x00, ##      00     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x18, 0x00, ##     00      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x30, 0x00, ##    00       
            0x70, 0x00, ##   000       
            0x70, 0x00, ##   000       
            0x60, 0x00, ##   00        
            0xE0, 0x00, ##  000        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000     
            0x1F, 0xF8, ##     0000000000   
            0x3C, 0x3C, ##    0000    0000  
            0x38, 0x1C, ##    000      000  
            0x70, 0x0E, ##   000        000 
            0x70, 0x0E, ##   000        000 
            0x70, 0x0E, ##   000        000 
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0x60, 0x0E, ##   00         000 
            0x70, 0x0E, ##   000        000 
            0x70, 0x0E, ##   000        000 
            0x38, 0x1C, ##    000      000  
            0x3C, 0x3C, ##    0000    0000  
            0x1F, 0xF8, ##     0000000000   
            0x07, 0xE0, ##       000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 13, 
        'xoffset'  => 4, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000     
            0xFF, 0x00, ##  00000000     
            0xFF, 0x00, ##  00000000     
            0xC7, 0x00, ##  00   000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xC0, ##     0000000     
            0xFF, 0xF0, ##  000000000000   
            0xF0, 0x78, ##  0000     0000  
            0x80, 0x1C, ##  0          000 
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x1E, ##             0000
            0x00, 0x1C, ##             000 
            0x00, 0x3C, ##            0000 
            0x00, 0x78, ##           0000  
            0x00, 0xF0, ##          0000   
            0x01, 0xE0, ##         0000    
            0x03, 0xC0, ##        0000     
            0x07, 0x80, ##       0000      
            0x0F, 0x00, ##      0000       
            0x1E, 0x00, ##     0000        
            0x3C, 0x00, ##    0000         
            0x78, 0x00, ##   0000          
            0xF0, 0x00, ##  0000           
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7F, 0xC0, ##   000000000     
            0xFF, 0xF0, ##  000000000000   
            0xC0, 0x78, ##  00       0000  
            0x00, 0x3C, ##            0000 
            0x00, 0x1C, ##             000 
            0x00, 0x1C, ##             000 
            0x00, 0x1C, ##             000 
            0x00, 0x3C, ##            0000 
            0x00, 0x78, ##           0000  
            0x1F, 0xF0, ##     000000000   
            0x1F, 0xC0, ##     0000000     
            0x00, 0x70, ##           000   
            0x00, 0x18, ##             00  
            0x00, 0x1C, ##             000 
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x1E, ##             0000
            0x00, 0x1C, ##             000 
            0xC0, 0x78, ##  00       0000  
            0xFF, 0xF0, ##  000000000000   
            0x7F, 0xC0, ##   000000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x78, 0x00, ##           0000    
            0x00, 0xF8, 0x00, ##          00000    
            0x01, 0xF8, 0x00, ##         000000    
            0x01, 0xF8, 0x00, ##         000000    
            0x03, 0xB8, 0x00, ##        000 000    
            0x03, 0x38, 0x00, ##        00  000    
            0x07, 0x38, 0x00, ##       000  000    
            0x0E, 0x38, 0x00, ##      000   000    
            0x0C, 0x38, 0x00, ##      00    000    
            0x1C, 0x38, 0x00, ##     000    000    
            0x38, 0x38, 0x00, ##    000     000    
            0x30, 0x38, 0x00, ##    00      000    
            0x70, 0x38, 0x00, ##   000      000    
            0xE0, 0x38, 0x00, ##  000       000    
            0xC0, 0x38, 0x00, ##  00        000    
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x38, 0x00, ##            000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7F, 0xF8, ##   000000000000  
            0x7F, 0xF8, ##   000000000000  
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0x70, 0x00, ##   000           
            0x7F, 0xC0, ##   000000000     
            0x7F, 0xF0, ##   00000000000   
            0x60, 0x78, ##   00      0000  
            0x00, 0x3C, ##            0000 
            0x00, 0x1C, ##             000 
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x1C, ##             000 
            0x00, 0x3C, ##            0000 
            0xE0, 0x78, ##  000      0000  
            0xFF, 0xF0, ##  000000000000   
            0x7F, 0xC0, ##   000000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xFC, ##        00000000  
            0x0F, 0xFE, ##      00000000000 
            0x1E, 0x06, ##     0000      00 
            0x38, 0x00, ##    000           
            0x30, 0x00, ##    00            
            0x70, 0x00, ##   000            
            0x60, 0x00, ##   00             
            0xE3, 0xE0, ##  000   00000     
            0xEF, 0xF8, ##  000 000000000   
            0xFC, 0x3C, ##  000000    0000  
            0xF8, 0x0E, ##  00000       000 
            0xF0, 0x0E, ##  0000        000 
            0xF0, 0x07, ##  0000         000
            0xF0, 0x07, ##  0000         000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0x70, 0x07, ##   000         000
            0x70, 0x07, ##   000         000
            0x70, 0x0E, ##   000        000 
            0x38, 0x0E, ##    000       000 
            0x3C, 0x3C, ##    0000    0000  
            0x1F, 0xF8, ##     0000000000   
            0x07, 0xE0, ##       000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x00, 0x1C, ##             000 
            0x00, 0x1C, ##             000 
            0x00, 0x3C, ##            0000 
            0x00, 0x38, ##            000  
            0x00, 0x78, ##           0000  
            0x00, 0x78, ##           0000  
            0x00, 0x70, ##           000   
            0x00, 0xF0, ##          0000   
            0x00, 0xE0, ##          000    
            0x00, 0xE0, ##          000    
            0x01, 0xE0, ##         0000    
            0x01, 0xC0, ##         000     
            0x03, 0xC0, ##        0000     
            0x03, 0x80, ##        000      
            0x03, 0x80, ##        000      
            0x07, 0x80, ##       0000      
            0x07, 0x00, ##       000       
            0x07, 0x00, ##       000       
            0x0F, 0x00, ##      0000       
            0x0E, 0x00, ##      000        
            0x1E, 0x00, ##     0000        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000     
            0x1F, 0xF8, ##     0000000000   
            0x3C, 0x3C, ##    0000    0000  
            0x78, 0x1E, ##   0000      0000 
            0x70, 0x0E, ##   000        000 
            0x70, 0x0E, ##   000        000 
            0x70, 0x0E, ##   000        000 
            0x78, 0x1C, ##   0000      000  
            0x3C, 0x3C, ##    0000    0000  
            0x1F, 0xF0, ##     000000000    
            0x0F, 0xF8, ##      000000000   
            0x1C, 0x3C, ##     000    0000  
            0x30, 0x0E, ##    00        000 
            0x70, 0x0F, ##   000        0000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x0F, ##  000         0000
            0x70, 0x0E, ##   000        000 
            0x7C, 0x3E, ##   00000    00000 
            0x3F, 0xF8, ##    00000000000   
            0x0F, 0xF0, ##      00000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000     
            0x1F, 0xF0, ##     000000000    
            0x3C, 0x3C, ##    0000    0000  
            0x70, 0x1C, ##   000       000  
            0xF0, 0x0E, ##  0000        000 
            0xE0, 0x0E, ##  000         000 
            0xE0, 0x06, ##  000          00 
            0xE0, 0x07, ##  000          000
            0xE0, 0x0F, ##  000         0000
            0xE0, 0x0F, ##  000         0000
            0x70, 0x1F, ##   000       00000
            0x78, 0x3F, ##   0000     000000
            0x3F, 0xF7, ##    0000000000 000
            0x0F, 0xC7, ##      000000   000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x0E, ##              000 
            0x00, 0x0E, ##              000 
            0x00, 0x1C, ##             000  
            0x00, 0x1C, ##             000  
            0x70, 0x78, ##   000     0000   
            0x7F, 0xF0, ##   00000000000    
            0x3F, 0xC0, ##    00000000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 3, 
        'xoffset'  => 4, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 4, 
        'xoffset'  => 3, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000
            0x70, ##   000
            0x70, ##   000
            0x70, ##   000
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x00, ##      
            0x70, ##   000
            0x70, ##   000
            0x70, ##   000
            0x60, ##   00 
            0xE0, ##  000 
            0xC0, ##  00  
            0xC0, ##  00  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x70, ##                   000
            0x00, 0x03, 0xF0, ##                000000
            0x00, 0x1F, 0xE0, ##             00000000 
            0x00, 0x7F, 0x00, ##           0000000    
            0x03, 0xFC, 0x00, ##        00000000      
            0x1F, 0xE0, 0x00, ##     00000000         
            0xFF, 0x00, 0x00, ##  00000000            
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0x7F, 0x00, 0x00, ##   0000000            
            0x1F, 0xE0, 0x00, ##     00000000         
            0x03, 0xFC, 0x00, ##        00000000      
            0x00, 0x7F, 0x80, ##           00000000   
            0x00, 0x0F, 0xF0, ##              00000000
            0x00, 0x03, 0xF0, ##                000000
            0x00, 0x00, 0x70, ##                   000
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0xE0, 0x00, 0x00, ##  000                 
            0xFC, 0x00, 0x00, ##  000000              
            0x7F, 0x80, 0x00, ##   00000000           
            0x0F, 0xE0, 0x00, ##      0000000         
            0x03, 0xFC, 0x00, ##        00000000      
            0x00, 0x7F, 0x80, ##           00000000   
            0x00, 0x0F, 0xF0, ##              00000000
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x03, 0xF0, ##                000000
            0x00, 0x0F, 0xE0, ##              0000000 
            0x00, 0x7F, 0x80, ##           00000000   
            0x03, 0xFC, 0x00, ##        00000000      
            0x1F, 0xE0, 0x00, ##     00000000         
            0xFF, 0x00, 0x00, ##  00000000            
            0xFC, 0x00, 0x00, ##  000000              
            0xE0, 0x00, 0x00, ##  000                 
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000    
            0xFF, 0xE0, ##  00000000000  
            0xE0, 0xF0, ##  000     0000 
            0x80, 0x78, ##  0        0000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x70, ##           000 
            0x00, 0xF0, ##          0000 
            0x03, 0xE0, ##        00000  
            0x07, 0x80, ##       0000    
            0x07, 0x00, ##       000     
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x0E, 0x00, ##      000      
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 28, 
        'xoffset'  => 2, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xC0, 0x00, ##             0000000          
            0x00, 0xFF, 0xF8, 0x00, ##          0000000000000       
            0x03, 0xE0, 0x3E, 0x00, ##        00000       00000     
            0x07, 0x00, 0x07, 0x00, ##       000             000    
            0x0E, 0x00, 0x03, 0x80, ##      000               000   
            0x1C, 0x00, 0x01, 0xC0, ##     000                 000  
            0x38, 0x00, 0x00, 0xC0, ##    000                   00  
            0x30, 0x1F, 0x38, 0x60, ##    00       00000  000    00 
            0x60, 0x7F, 0xB8, 0x60, ##   00      00000000 000    00 
            0x60, 0xF0, 0xF8, 0x30, ##   00     0000    00000     00
            0xE0, 0xE0, 0x78, 0x30, ##  000     000      0000     00
            0xC1, 0xC0, 0x38, 0x30, ##  00     000        000     00
            0xC1, 0xC0, 0x38, 0x30, ##  00     000        000     00
            0xC1, 0xC0, 0x38, 0x30, ##  00     000        000     00
            0xC1, 0xC0, 0x38, 0x30, ##  00     000        000     00
            0xC1, 0xC0, 0x38, 0x60, ##  00     000        000    00 
            0xC1, 0xC0, 0x38, 0x60, ##  00     000        000    00 
            0xC0, 0xE0, 0x78, 0xC0, ##  00      000      0000   00  
            0x60, 0xF0, 0xF9, 0xC0, ##   00     0000    00000  000  
            0x60, 0x7F, 0xBF, 0x00, ##   00      00000000 000000    
            0x30, 0x1F, 0x3C, 0x00, ##    00       00000  0000      
            0x38, 0x00, 0x00, 0x00, ##    000                       
            0x1C, 0x00, 0x00, 0x00, ##     000                      
            0x0E, 0x00, 0x00, 0x00, ##      000                     
            0x07, 0x00, 0x0E, 0x00, ##       000            000     
            0x03, 0xE0, 0x3E, 0x00, ##        00000       00000     
            0x00, 0xFF, 0xF8, 0x00, ##          0000000000000       
            0x00, 0x3F, 0xC0, 0x00, ##            00000000          
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 22, 
        'xoffset'  => 0, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x01, 0xFC, 0x00, ##         0000000        
            0x01, 0xCE, 0x00, ##         000  000       
            0x01, 0xCE, 0x00, ##         000  000       
            0x03, 0x8F, 0x00, ##        000   0000      
            0x03, 0x87, 0x00, ##        000    000      
            0x07, 0x87, 0x00, ##       0000    000      
            0x07, 0x03, 0x80, ##       000      000     
            0x07, 0x03, 0x80, ##       000      000     
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x0E, 0x01, 0xC0, ##      000        000    
            0x0E, 0x01, 0xC0, ##      000        000    
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3C, 0x00, 0xE0, ##    0000          000   
            0x38, 0x00, 0x70, ##    000            000  
            0x38, 0x00, 0x70, ##    000            000  
            0x70, 0x00, 0x78, ##   000             0000 
            0x70, 0x00, 0x38, ##   000              000 
            0xF0, 0x00, 0x38, ##  0000              000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 16, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000     
            0xFF, 0xF8, ##  0000000000000   
            0xE0, 0x3C, ##  000       0000  
            0xE0, 0x1E, ##  000        0000 
            0xE0, 0x0E, ##  000         000 
            0xE0, 0x0E, ##  000         000 
            0xE0, 0x0E, ##  000         000 
            0xE0, 0x0E, ##  000         000 
            0xE0, 0x1E, ##  000        0000 
            0xE0, 0x3C, ##  000       0000  
            0xFF, 0xF0, ##  000000000000    
            0xFF, 0xF8, ##  0000000000000   
            0xE0, 0x1C, ##  000        000  
            0xE0, 0x0E, ##  000         000 
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x0E, ##  000         000 
            0xE0, 0x1E, ##  000        0000 
            0xFF, 0xFC, ##  00000000000000  
            0xFF, 0xF0, ##  000000000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0x00, ##          00000000   
            0x07, 0xFF, 0xE0, ##       00000000000000
            0x0F, 0x01, 0xE0, ##      0000       0000
            0x1C, 0x00, 0x60, ##     000           00
            0x38, 0x00, 0x20, ##    000             0
            0x70, 0x00, 0x00, ##   000               
            0x70, 0x00, 0x00, ##   000               
            0x70, 0x00, 0x00, ##   000               
            0xE0, 0x00, 0x00, ##  000                
            0xE0, 0x00, 0x00, ##  000                
            0xE0, 0x00, 0x00, ##  000                
            0xE0, 0x00, 0x00, ##  000                
            0xE0, 0x00, 0x00, ##  000                
            0xE0, 0x00, 0x00, ##  000                
            0xE0, 0x00, 0x00, ##  000                
            0xF0, 0x00, 0x00, ##  0000               
            0x70, 0x00, 0x00, ##   000               
            0x70, 0x00, 0x00, ##   000               
            0x38, 0x00, 0x20, ##    000             0
            0x1C, 0x00, 0x60, ##     000           00
            0x0F, 0x01, 0xE0, ##      0000       0000
            0x07, 0xFF, 0xE0, ##       00000000000000
            0x00, 0xFF, 0x00, ##          00000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x00, ##  00000000000        
            0xFF, 0xFC, 0x00, ##  00000000000000     
            0xE0, 0x1F, 0x00, ##  000        00000   
            0xE0, 0x07, 0x80, ##  000          0000  
            0xE0, 0x03, 0x80, ##  000           000  
            0xE0, 0x01, 0xC0, ##  000            000 
            0xE0, 0x01, 0xC0, ##  000            000 
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x00, 0xE0, ##  000             000
            0xE0, 0x01, 0xE0, ##  000            0000
            0xE0, 0x01, 0xC0, ##  000            000 
            0xE0, 0x01, 0xC0, ##  000            000 
            0xE0, 0x03, 0x80, ##  000           000  
            0xE0, 0x07, 0x80, ##  000          0000  
            0xE0, 0x1F, 0x00, ##  000        00000   
            0xFF, 0xFC, 0x00, ##  00000000000000     
            0xFF, 0xE0, 0x00, ##  00000000000        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 14, 
        'xoffset'  => 3, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xFF, 0xF8, ##  0000000000000 
            0xFF, 0xF8, ##  0000000000000 
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 20, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xFF, 0x00, ##         000000000    
            0x07, 0xFF, 0xE0, ##       00000000000000 
            0x0F, 0x01, 0xE0, ##      0000       0000 
            0x1C, 0x00, 0x60, ##     000           00 
            0x38, 0x00, 0x20, ##    000             0 
            0x70, 0x00, 0x00, ##   000                
            0x70, 0x00, 0x00, ##   000                
            0xF0, 0x00, 0x00, ##  0000                
            0xE0, 0x00, 0x00, ##  000                 
            0xE0, 0x00, 0x00, ##  000                 
            0xE0, 0x00, 0x00, ##  000                 
            0xE0, 0x0F, 0xF0, ##  000         00000000
            0xE0, 0x0F, 0xF0, ##  000         00000000
            0xE0, 0x00, 0x70, ##  000              000
            0xE0, 0x00, 0x70, ##  000              000
            0xE0, 0x00, 0x70, ##  000              000
            0x70, 0x00, 0x70, ##   000             000
            0x70, 0x00, 0x70, ##   000             000
            0x38, 0x00, 0x70, ##    000            000
            0x1C, 0x00, 0x70, ##     000           000
            0x0F, 0x01, 0xF0, ##      0000       00000
            0x07, 0xFF, 0xE0, ##       00000000000000 
            0x01, 0xFF, 0x00, ##         000000000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 18, 
        'xoffset'  => 3, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 3, 
        'xoffset'  => 3, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 8, 
        'xoffset'  => -2, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x07, ##       000
            0x0E, ##      000 
            0x1E, ##     0000 
            0xFC, ##  000000  
            0xF0, ##  0000    
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 18, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xE0, 0x07, 0x80, ##  000          0000 
            0xE0, 0x0F, 0x00, ##  000         0000  
            0xE0, 0x1E, 0x00, ##  000        0000   
            0xE0, 0x3C, 0x00, ##  000       0000    
            0xE0, 0x78, 0x00, ##  000      0000     
            0xE0, 0xF0, 0x00, ##  000     0000      
            0xE3, 0xE0, 0x00, ##  000   00000       
            0xE7, 0x80, 0x00, ##  000  0000         
            0xEF, 0x00, 0x00, ##  000 0000          
            0xFE, 0x00, 0x00, ##  0000000           
            0xFC, 0x00, 0x00, ##  000000            
            0xFE, 0x00, 0x00, ##  0000000           
            0xEF, 0x00, 0x00, ##  000 0000          
            0xE7, 0x80, 0x00, ##  000  0000         
            0xE3, 0xC0, 0x00, ##  000   0000        
            0xE1, 0xE0, 0x00, ##  000    0000       
            0xE0, 0xF0, 0x00, ##  000     0000      
            0xE0, 0x78, 0x00, ##  000      0000     
            0xE0, 0x3C, 0x00, ##  000       0000    
            0xE0, 0x1E, 0x00, ##  000        0000   
            0xE0, 0x0F, 0x00, ##  000         0000  
            0xE0, 0x07, 0x80, ##  000          0000 
            0xE0, 0x03, 0xC0, ##  000           0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xFC, 0x01, 0xF8, ##  000000         000000
            0xFC, 0x01, 0xF8, ##  000000         000000
            0xEC, 0x01, 0xB8, ##  000 00         00 000
            0xEE, 0x03, 0xB8, ##  000 000       000 000
            0xEE, 0x03, 0xB8, ##  000 000       000 000
            0xE6, 0x03, 0x38, ##  000  00       00  000
            0xE7, 0x07, 0x38, ##  000  000     000  000
            0xE3, 0x06, 0x38, ##  000   00     00   000
            0xE3, 0x8E, 0x38, ##  000   000   000   000
            0xE3, 0x8E, 0x38, ##  000   000   000   000
            0xE1, 0x8C, 0x38, ##  000    00   00    000
            0xE1, 0xDC, 0x38, ##  000    000 000    000
            0xE1, 0xDC, 0x38, ##  000    000 000    000
            0xE0, 0xD8, 0x38, ##  000     00 00     000
            0xE0, 0xF8, 0x38, ##  000     00000     000
            0xE0, 0x70, 0x38, ##  000      000      000
            0xE0, 0x70, 0x38, ##  000      000      000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 18, 
        'xoffset'  => 3, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0x01, 0xC0, ##  00000          000
            0xF8, 0x01, 0xC0, ##  00000          000
            0xFC, 0x01, 0xC0, ##  000000         000
            0xFC, 0x01, 0xC0, ##  000000         000
            0xFE, 0x01, 0xC0, ##  0000000        000
            0xEE, 0x01, 0xC0, ##  000 000        000
            0xE7, 0x01, 0xC0, ##  000  000       000
            0xE7, 0x01, 0xC0, ##  000  000       000
            0xE3, 0x81, 0xC0, ##  000   000      000
            0xE3, 0xC1, 0xC0, ##  000   0000     000
            0xE1, 0xC1, 0xC0, ##  000    000     000
            0xE1, 0xE1, 0xC0, ##  000    0000    000
            0xE0, 0xE1, 0xC0, ##  000     000    000
            0xE0, 0xF1, 0xC0, ##  000     0000   000
            0xE0, 0x71, 0xC0, ##  000      000   000
            0xE0, 0x39, 0xC0, ##  000       000  000
            0xE0, 0x39, 0xC0, ##  000       000  000
            0xE0, 0x1D, 0xC0, ##  000        000 000
            0xE0, 0x1F, 0xC0, ##  000        0000000
            0xE0, 0x0F, 0xC0, ##  000         000000
            0xE0, 0x0F, 0xC0, ##  000         000000
            0xE0, 0x07, 0xC0, ##  000          00000
            0xE0, 0x07, 0xC0, ##  000          00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xFC, 0x00, ##         0000000       
            0x07, 0xFF, 0x00, ##       00000000000     
            0x1F, 0x07, 0x80, ##     00000     0000    
            0x1C, 0x01, 0xC0, ##     000         000   
            0x38, 0x00, 0xE0, ##    000           000  
            0x70, 0x00, 0x70, ##   000             000 
            0x70, 0x00, 0x70, ##   000             000 
            0xF0, 0x00, 0x70, ##  0000             000 
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xF0, 0x00, 0x78, ##  0000             0000
            0x70, 0x00, 0x70, ##   000             000 
            0x70, 0x00, 0x70, ##   000             000 
            0x38, 0x00, 0xE0, ##    000           000  
            0x3C, 0x01, 0xC0, ##    0000         000   
            0x1F, 0x07, 0xC0, ##     00000     00000   
            0x07, 0xFF, 0x00, ##       00000000000     
            0x01, 0xFC, 0x00, ##         0000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000    
            0xFF, 0xF8, ##  0000000000000  
            0xE0, 0x3C, ##  000       0000 
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x1C, ##  000        000 
            0xE0, 0x3C, ##  000       0000 
            0xFF, 0xF8, ##  0000000000000  
            0xFF, 0xE0, ##  00000000000    
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xFC, 0x00, ##         0000000       
            0x07, 0xFF, 0x00, ##       00000000000     
            0x1F, 0x07, 0x80, ##     00000     0000    
            0x1C, 0x01, 0xC0, ##     000         000   
            0x38, 0x00, 0xE0, ##    000           000  
            0x70, 0x00, 0x70, ##   000             000 
            0x70, 0x00, 0x70, ##   000             000 
            0xF0, 0x00, 0x70, ##  0000             000 
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xE0, 0x00, 0x38, ##  000               000
            0xF0, 0x00, 0x78, ##  0000             0000
            0x70, 0x00, 0x70, ##   000             000 
            0x70, 0x00, 0x70, ##   000             000 
            0x38, 0x00, 0xE0, ##    000           000  
            0x1C, 0x01, 0xE0, ##     000         0000  
            0x1F, 0x07, 0xC0, ##     00000     00000   
            0x07, 0xFF, 0x00, ##       00000000000     
            0x01, 0xFE, 0x00, ##         00000000      
            0x00, 0x0F, 0x00, ##              0000     
            0x00, 0x07, 0x80, ##               0000    
            0x00, 0x03, 0xC0, ##                0000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 18, 
        'xoffset'  => 3, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x00, ##  00000000000       
            0xFF, 0xF8, 0x00, ##  0000000000000     
            0xE0, 0x3C, 0x00, ##  000       0000    
            0xE0, 0x1C, 0x00, ##  000        000    
            0xE0, 0x0E, 0x00, ##  000         000   
            0xE0, 0x0E, 0x00, ##  000         000   
            0xE0, 0x0E, 0x00, ##  000         000   
            0xE0, 0x0E, 0x00, ##  000         000   
            0xE0, 0x0E, 0x00, ##  000         000   
            0xE0, 0x1C, 0x00, ##  000        000    
            0xE0, 0x3C, 0x00, ##  000       0000    
            0xFF, 0xF8, 0x00, ##  0000000000000     
            0xFF, 0xF0, 0x00, ##  000000000000      
            0xE0, 0x78, 0x00, ##  000      0000     
            0xE0, 0x3C, 0x00, ##  000       0000    
            0xE0, 0x1C, 0x00, ##  000        000    
            0xE0, 0x1E, 0x00, ##  000        0000   
            0xE0, 0x0E, 0x00, ##  000         000   
            0xE0, 0x07, 0x00, ##  000          000  
            0xE0, 0x07, 0x00, ##  000          000  
            0xE0, 0x03, 0x80, ##  000           000 
            0xE0, 0x03, 0x80, ##  000           000 
            0xE0, 0x03, 0xC0, ##  000           0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xF8, ##      000000000   
            0x3F, 0xFE, ##    0000000000000 
            0x78, 0x0E, ##   0000       000 
            0x70, 0x02, ##   000          0 
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xF8, 0x00, ##  00000           
            0x7F, 0x80, ##   00000000       
            0x3F, 0xF0, ##    0000000000    
            0x1F, 0xFC, ##     00000000000  
            0x03, 0xFE, ##        000000000 
            0x00, 0x3E, ##            00000 
            0x00, 0x0F, ##              0000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x80, 0x0E, ##  0           000 
            0xF0, 0x3E, ##  0000      00000 
            0xFF, 0xFC, ##  00000000000000  
            0x1F, 0xE0, ##     00000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 20, 
        'xoffset'  => 0, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0xE0, 0x00, ##          000         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 18, 
        'xoffset'  => 3, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0xE0, 0x01, 0xC0, ##  000            000
            0x70, 0x03, 0x80, ##   000          000 
            0x78, 0x07, 0x80, ##   0000        0000 
            0x3C, 0x0F, 0x00, ##    0000      0000  
            0x1F, 0xFE, 0x00, ##     000000000000   
            0x07, 0xF8, 0x00, ##       00000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 22, 
        'xoffset'  => 0, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF0, 0x00, 0x38, ##  0000              000 
            0x70, 0x00, 0x38, ##   000              000 
            0x70, 0x00, 0x78, ##   000             0000 
            0x38, 0x00, 0x70, ##    000            000  
            0x38, 0x00, 0x70, ##    000            000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x1C, 0x00, 0xE0, ##     000          000   
            0x1C, 0x01, 0xE0, ##     000         0000   
            0x0E, 0x01, 0xC0, ##      000        000    
            0x0E, 0x01, 0xC0, ##      000        000    
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x07, 0x03, 0x80, ##       000      000     
            0x07, 0x03, 0x80, ##       000      000     
            0x07, 0x87, 0x00, ##       0000    000      
            0x03, 0x87, 0x00, ##        000    000      
            0x03, 0x8F, 0x00, ##        000   0000      
            0x01, 0xCE, 0x00, ##         000  000       
            0x01, 0xCE, 0x00, ##         000  000       
            0x01, 0xFC, 0x00, ##         0000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 30, 
        'xoffset'  => 1, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xE0, 0x07, 0x80, 0x38, ##  000          0000         000 
            0xF0, 0x07, 0x80, 0x38, ##  0000         0000         000 
            0x70, 0x0F, 0x80, 0x38, ##   000        00000         000 
            0x70, 0x0F, 0x80, 0x78, ##   000        00000        0000 
            0x70, 0x0F, 0xC0, 0x70, ##   000        000000       000  
            0x78, 0x0D, 0xC0, 0x70, ##   0000       00 000       000  
            0x38, 0x1C, 0xC0, 0x70, ##    000      000  00       000  
            0x38, 0x1C, 0xC0, 0xF0, ##    000      000  00      0000  
            0x38, 0x1C, 0xE0, 0xE0, ##    000      000  000     000   
            0x3C, 0x18, 0xE0, 0xE0, ##    0000     00   000     000   
            0x1C, 0x38, 0x60, 0xE0, ##     000    000    00     000   
            0x1C, 0x38, 0x61, 0xE0, ##     000    000    00    0000   
            0x1C, 0x38, 0x71, 0xC0, ##     000    000    000   000    
            0x1E, 0x30, 0x71, 0xC0, ##     0000   00     000   000    
            0x0E, 0x70, 0x31, 0xC0, ##      000  000      00   000    
            0x0E, 0x70, 0x3B, 0xC0, ##      000  000      000 0000    
            0x0E, 0x70, 0x3B, 0x80, ##      000  000      000 000     
            0x07, 0x60, 0x3B, 0x80, ##       000 00       000 000     
            0x07, 0xE0, 0x1B, 0x80, ##       000000        00 000     
            0x07, 0xE0, 0x1F, 0x80, ##       000000        000000     
            0x07, 0xE0, 0x1F, 0x00, ##       000000        00000      
            0x03, 0xC0, 0x1F, 0x00, ##        0000         00000      
            0x03, 0xC0, 0x0F, 0x00, ##        0000          0000      
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 20, 
        'xoffset'  => 1, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x78, 0x00, 0xE0, ##   0000           000 
            0x38, 0x01, 0xC0, ##    000          000  
            0x1C, 0x03, 0xC0, ##     000        0000  
            0x1E, 0x03, 0x80, ##     0000       000   
            0x0E, 0x07, 0x00, ##      000      000    
            0x07, 0x0F, 0x00, ##       000    0000    
            0x07, 0x8E, 0x00, ##       0000   000     
            0x03, 0x9C, 0x00, ##        000  000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xF8, 0x00, ##         000000       
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xF8, 0x00, ##         000000       
            0x03, 0xFC, 0x00, ##        00000000      
            0x03, 0x9C, 0x00, ##        000  000      
            0x07, 0x0E, 0x00, ##       000    000     
            0x0F, 0x0F, 0x00, ##      0000    0000    
            0x0E, 0x07, 0x00, ##      000      000    
            0x1C, 0x03, 0x80, ##     000        000   
            0x3C, 0x03, 0xC0, ##    0000        0000  
            0x38, 0x01, 0xC0, ##    000          000  
            0x70, 0x00, 0xE0, ##   000            000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 19, 
        'xoffset'  => 0, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xE0, 0x00, 0xE0, ##  000             000
            0x70, 0x01, 0xC0, ##   000           000 
            0x78, 0x03, 0xC0, ##   0000         0000 
            0x3C, 0x07, 0x80, ##    0000       0000  
            0x1C, 0x07, 0x00, ##     000       000   
            0x0E, 0x0E, 0x00, ##      000     000    
            0x0F, 0x1E, 0x00, ##      0000   0000    
            0x07, 0x1C, 0x00, ##       000   000     
            0x03, 0xB8, 0x00, ##        000 000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x01, 0xF0, 0x00, ##         00000       
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0xE0, 0x00, ##          000        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 19, 
        'xoffset'  => 1, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xE0, ##   000000000000000000
            0x7F, 0xFF, 0xE0, ##   000000000000000000
            0x00, 0x01, 0xC0, ##                 000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x07, 0x80, ##               0000  
            0x00, 0x0F, 0x00, ##              0000   
            0x00, 0x0E, 0x00, ##              000    
            0x00, 0x1E, 0x00, ##             0000    
            0x00, 0x3C, 0x00, ##            0000     
            0x00, 0x78, 0x00, ##           0000      
            0x00, 0xF0, 0x00, ##          0000       
            0x00, 0xF0, 0x00, ##          0000       
            0x01, 0xE0, 0x00, ##         0000        
            0x03, 0xC0, 0x00, ##        0000         
            0x07, 0x80, 0x00, ##       0000          
            0x0F, 0x80, 0x00, ##      00000          
            0x0F, 0x00, 0x00, ##      0000           
            0x1E, 0x00, 0x00, ##     0000            
            0x3C, 0x00, 0x00, ##    0000             
            0x7C, 0x00, 0x00, ##   00000             
            0x78, 0x00, 0x00, ##   0000              
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 7, 
        'xoffset'  => 3, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xE0, ##  000    
            0xFE, ##  0000000
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 11, 
        'xoffset'  => 0, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000        
            0xE0, 0x00, ##  000        
            0x60, 0x00, ##   00        
            0x70, 0x00, ##   000       
            0x70, 0x00, ##   000       
            0x30, 0x00, ##    00       
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x18, 0x00, ##     00      
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x0C, 0x00, ##      00     
            0x0C, 0x00, ##      00     
            0x0E, 0x00, ##      000    
            0x0E, 0x00, ##      000    
            0x06, 0x00, ##       00    
            0x07, 0x00, ##       000   
            0x07, 0x00, ##       000   
            0x03, 0x00, ##        00   
            0x03, 0x80, ##        000  
            0x03, 0x80, ##        000  
            0x01, 0x80, ##         00  
            0x01, 0xC0, ##         000 
            0x01, 0xC0, ##         000 
            0x00, 0xC0, ##          00 
            0x00, 0xC0, ##          00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 6, 
        'xoffset'  => 4, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xFC, 0x00, ##         0000000      
            0x03, 0x9E, 0x00, ##        000  0000     
            0x07, 0x0F, 0x00, ##       000    0000    
            0x0E, 0x07, 0x80, ##      000      0000   
            0x1C, 0x01, 0xC0, ##     000         000  
            0x38, 0x00, 0xE0, ##    000           000 
            0x70, 0x00, 0x70, ##   000             000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 17, 
        'xoffset'  => 0, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0x80, ##  00000000000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 7, 
        'xoffset'  => 3, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0xE0, ##  000    
            0x70, ##   000   
            0x38, ##    000  
            0x18, ##     00  
            0x1C, ##     000 
            0x0E, ##      000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 15, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xE0, ##     00000000    
            0x7F, 0xF8, ##   000000000000  
            0x70, 0x3C, ##   000      0000 
            0x40, 0x1C, ##   0         000 
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x00, 0x0E, ##              000
            0x0F, 0xFE, ##      00000000000
            0x3F, 0xFE, ##    0000000000000
            0x78, 0x0E, ##   0000       000
            0xF0, 0x0E, ##  0000        000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x1E, ##  000        0000
            0xE0, 0x3E, ##  000       00000
            0x78, 0x7E, ##   0000    000000
            0x3F, 0xEE, ##    000000000 000
            0x1F, 0x8E, ##     000000   000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 16, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE3, 0xE0, ##  000   00000     
            0xEF, 0xF8, ##  000 000000000   
            0xFC, 0x3C, ##  000000    0000  
            0xF8, 0x1E, ##  00000      0000 
            0xF0, 0x0E, ##  0000        000 
            0xF0, 0x0F, ##  0000        0000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x0F, ##  000         0000
            0xF0, 0x0E, ##  0000        000 
            0xF8, 0x1E, ##  00000      0000 
            0xFC, 0x3C, ##  000000    0000  
            0xEF, 0xF8, ##  000 000000000   
            0xE3, 0xE0, ##  000   00000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 14, 
        'xoffset'  => 2, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xF8, ##        0000000 
            0x1F, 0xFC, ##     00000000000
            0x3C, 0x0C, ##    0000      00
            0x78, 0x00, ##   0000         
            0x70, 0x00, ##   000          
            0x70, 0x00, ##   000          
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0xE0, 0x00, ##  000           
            0x70, 0x00, ##   000          
            0x70, 0x00, ##   000          
            0x78, 0x00, ##   0000         
            0x3C, 0x0C, ##    0000      00
            0x1F, 0xFC, ##     00000000000
            0x07, 0xF8, ##       00000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x07, 0xC7, ##       00000   000
            0x1F, 0xF7, ##     000000000 000
            0x3C, 0x3F, ##    0000    000000
            0x78, 0x1F, ##   0000      00000
            0x70, 0x0F, ##   000        0000
            0xF0, 0x0F, ##  0000        0000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x0F, ##  000         0000
            0x70, 0x0F, ##   000        0000
            0x78, 0x1F, ##   0000      00000
            0x3C, 0x3F, ##    0000    000000
            0x1F, 0xF7, ##     000000000 000
            0x07, 0xC7, ##       00000   000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000     
            0x1F, 0xF8, ##     0000000000   
            0x3C, 0x1C, ##    0000     000  
            0x70, 0x0E, ##   000        000 
            0x70, 0x0E, ##   000        000 
            0x60, 0x07, ##   00          000
            0xE0, 0x07, ##  000          000
            0xFF, 0xFF, ##  0000000000000000
            0xFF, 0xFF, ##  0000000000000000
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xF0, 0x00, ##  0000            
            0x70, 0x00, ##   000            
            0x78, 0x00, ##   0000           
            0x3C, 0x0E, ##    0000      000 
            0x1F, 0xFE, ##     000000000000 
            0x03, 0xF8, ##        0000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 12, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000
            0x0F, 0xE0, ##      0000000
            0x1E, 0x00, ##     0000    
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0xFF, 0xC0, ##  0000000000 
            0xFF, 0xC0, ##  0000000000 
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x1C, 0x00, ##     000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xC7, ##       00000   000
            0x1F, 0xF7, ##     000000000 000
            0x3C, 0x3F, ##    0000    000000
            0x78, 0x1F, ##   0000      00000
            0x70, 0x0F, ##   000        0000
            0xF0, 0x0F, ##  0000        0000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x0F, ##  000         0000
            0x70, 0x0F, ##   000        0000
            0x78, 0x1F, ##   0000      00000
            0x3C, 0x3F, ##    0000    000000
            0x1F, 0xF7, ##     000000000 000
            0x07, 0xC7, ##       00000   000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x0E, ##              000 
            0x00, 0x1E, ##             0000 
            0x30, 0x3C, ##    00      0000  
            0x3F, 0xF8, ##    00000000000   
            0x1F, 0xE0, ##     00000000     
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE0, 0x00, ##  000            
            0xE3, 0xF0, ##  000   000000   
            0xEF, 0xF8, ##  000 000000000  
            0xFC, 0x3C, ##  000000    0000 
            0xF0, 0x1C, ##  0000       000 
            0xF0, 0x0E, ##  0000        000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 3, 
        'xoffset'  => 3, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x1C, ##     000
            0x38, ##    000 
            0xF8, ##  00000 
            0xE0, ##  000   
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 16, 
        'xoffset'  => 3, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x1E, ##  000        0000 
            0xE0, 0x3C, ##  000       0000  
            0xE0, 0x78, ##  000      0000   
            0xE0, 0xE0, ##  000     000     
            0xE1, 0xC0, ##  000    000      
            0xE7, 0x80, ##  000  0000       
            0xEF, 0x00, ##  000 0000        
            0xFE, 0x00, ##  0000000         
            0xFC, 0x00, ##  000000          
            0xFE, 0x00, ##  0000000         
            0xEF, 0x00, ##  000 0000        
            0xE7, 0x80, ##  000  0000       
            0xE3, 0xC0, ##  000   0000      
            0xE1, 0xE0, ##  000    0000     
            0xE0, 0xF0, ##  000     0000    
            0xE0, 0x78, ##  000      0000   
            0xE0, 0x3C, ##  000       0000  
            0xE0, 0x1E, ##  000        0000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 3, 
        'xoffset'  => 3, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 25, 
        'xoffset'  => 3, 
        'xadvance' => 31, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xE3, 0xE0, 0x7C, 0x00, ##  000   00000      00000   
            0xEF, 0xF1, 0xFE, 0x00, ##  000 00000000   00000000  
            0xF8, 0x7B, 0x0F, 0x00, ##  00000    0000 00    0000 
            0xF0, 0x3A, 0x07, 0x00, ##  0000      000 0      000 
            0xF0, 0x1E, 0x03, 0x80, ##  0000       0000       000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0xE0, 0x1C, 0x03, 0x80, ##  000        000        000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE3, 0xF0, ##  000   000000   
            0xEF, 0xF8, ##  000 000000000  
            0xFC, 0x3C, ##  000000    0000 
            0xF0, 0x1C, ##  0000       000 
            0xF0, 0x0E, ##  0000        000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000     
            0x1F, 0xF8, ##     0000000000   
            0x3C, 0x3C, ##    0000    0000  
            0x78, 0x1E, ##   0000      0000 
            0x70, 0x0E, ##   000        000 
            0xF0, 0x0F, ##  0000        0000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x0F, ##  000         0000
            0x70, 0x0E, ##   000        000 
            0x78, 0x1E, ##   0000      0000 
            0x3C, 0x3C, ##    0000    0000  
            0x1F, 0xF8, ##     0000000000   
            0x07, 0xE0, ##       000000     
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 16, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE3, 0xE0, ##  000   00000     
            0xEF, 0xF8, ##  000 000000000   
            0xFC, 0x3C, ##  000000    0000  
            0xF8, 0x1E, ##  00000      0000 
            0xF0, 0x0E, ##  0000        000 
            0xF0, 0x0F, ##  0000        0000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x0F, ##  000         0000
            0xF0, 0x0E, ##  0000        000 
            0xF8, 0x1E, ##  00000      0000 
            0xFC, 0x3C, ##  000000    0000  
            0xEF, 0xF8, ##  000 000000000   
            0xE3, 0xE0, ##  000   00000     
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
            0xE0, 0x00, ##  000             
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xC7, ##       00000   000
            0x1F, 0xF7, ##     000000000 000
            0x3C, 0x3F, ##    0000    000000
            0x78, 0x1F, ##   0000      00000
            0x70, 0x0F, ##   000        0000
            0xF0, 0x0F, ##  0000        0000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x07, ##  000          000
            0xE0, 0x0F, ##  000         0000
            0x70, 0x0F, ##   000        0000
            0x78, 0x1F, ##   0000      00000
            0x3C, 0x3F, ##    0000    000000
            0x1F, 0xF7, ##     000000000 000
            0x07, 0xC7, ##       00000   000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
            0x00, 0x07, ##               000
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 10, 
        'xoffset'  => 3, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE3, 0xC0, ##  000   0000
            0xEF, 0xC0, ##  000 000000
            0xFC, 0x00, ##  000000    
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0xE0, 0x00, ##  000       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0xE0, ##     00000000  
            0x3F, 0xF0, ##    0000000000 
            0x70, 0x30, ##   000      00 
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xE0, 0x00, ##  000          
            0xF0, 0x00, ##  0000         
            0x7F, 0x00, ##   0000000     
            0x7F, 0xC0, ##   000000000   
            0x1F, 0xF0, ##     000000000 
            0x03, 0xF8, ##        0000000
            0x00, 0x78, ##           0000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0xE0, 0x70, ##  000      000 
            0xFF, 0xE0, ##  00000000000  
            0x3F, 0x80, ##    0000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x38, 0x00, ##    000      
            0x1C, 0x00, ##     000     
            0x1F, 0xE0, ##     00000000
            0x07, 0xE0, ##       000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 15, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x0E, ##  000         000
            0xE0, 0x1E, ##  000        0000
            0x70, 0x1E, ##   000       0000
            0x78, 0x7E, ##   0000    000000
            0x3F, 0xEE, ##    000000000 000
            0x1F, 0x8E, ##     000000   000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xE0, 0x03, 0x80, ##  000           000
            0xF0, 0x07, 0x00, ##  0000         000 
            0x70, 0x07, 0x00, ##   000         000 
            0x70, 0x07, 0x00, ##   000         000 
            0x38, 0x0E, 0x00, ##    000       000  
            0x38, 0x0E, 0x00, ##    000       000  
            0x38, 0x0E, 0x00, ##    000       000  
            0x1C, 0x1C, 0x00, ##     000     000   
            0x1C, 0x1C, 0x00, ##     000     000   
            0x1C, 0x3C, 0x00, ##     000    0000   
            0x0E, 0x38, 0x00, ##      000   000    
            0x0E, 0x38, 0x00, ##      000   000    
            0x07, 0x70, 0x00, ##       000 000     
            0x07, 0x70, 0x00, ##       000 000     
            0x07, 0x70, 0x00, ##       000 000     
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xE0, 0x3C, 0x07, ##  000       0000       000
            0x70, 0x3C, 0x06, ##   000      0000       00 
            0x70, 0x3C, 0x0E, ##   000      0000      000 
            0x70, 0x7E, 0x0E, ##   000     000000     000 
            0x70, 0x7E, 0x0E, ##   000     000000     000 
            0x38, 0x76, 0x0C, ##    000    000 00     00  
            0x38, 0x66, 0x1C, ##    000    00  00    000  
            0x38, 0xE7, 0x1C, ##    000   000  000   000  
            0x18, 0xE7, 0x1C, ##     00   000  000   000  
            0x1C, 0xE3, 0x18, ##     000  000   00   00   
            0x1C, 0xC3, 0x38, ##     000  00    00  000   
            0x1D, 0xC3, 0xB8, ##     000 000    000 000   
            0x0D, 0xC3, 0xB8, ##      00 000    000 000   
            0x0F, 0x81, 0xB0, ##      00000      00 00    
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x07, 0x81, 0xF0, ##       0000      00000    
            0x07, 0x00, 0xE0, ##       000        000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x70, 0x07, 0x00, ##   000         000 
            0x38, 0x0E, 0x00, ##    000       000  
            0x3C, 0x1E, 0x00, ##    0000     0000  
            0x1C, 0x1C, 0x00, ##     000     000   
            0x0E, 0x38, 0x00, ##      000   000    
            0x0F, 0x78, 0x00, ##      0000 0000    
            0x07, 0xF0, 0x00, ##       0000000     
            0x03, 0xE0, 0x00, ##        00000      
            0x01, 0xC0, 0x00, ##         000       
            0x03, 0xE0, 0x00, ##        00000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0x70, 0x00, ##       000 000     
            0x0E, 0x38, 0x00, ##      000   000    
            0x1E, 0x3C, 0x00, ##     0000   0000   
            0x3C, 0x1C, 0x00, ##    0000     000   
            0x38, 0x0E, 0x00, ##    000       000  
            0x70, 0x0F, 0x00, ##   000        0000 
            0xF0, 0x07, 0x80, ##  0000         0000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x70, 0x03, 0x80, ##   000          000
            0x70, 0x03, 0x80, ##   000          000
            0x70, 0x07, 0x80, ##   000         0000
            0x38, 0x07, 0x00, ##    000        000 
            0x38, 0x07, 0x00, ##    000        000 
            0x1C, 0x0E, 0x00, ##     000      000  
            0x1C, 0x0E, 0x00, ##     000      000  
            0x1C, 0x0E, 0x00, ##     000      000  
            0x0E, 0x1C, 0x00, ##      000    000   
            0x0E, 0x1C, 0x00, ##      000    000   
            0x06, 0x38, 0x00, ##       00   000    
            0x07, 0x38, 0x00, ##       000  000    
            0x07, 0x38, 0x00, ##       000  000    
            0x03, 0xF0, 0x00, ##        000000     
            0x03, 0xF0, 0x00, ##        000000     
            0x03, 0xE0, 0x00, ##        00000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xE0, 0x00, ##         0000      
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0xC0, 0x00, ##         000       
            0x01, 0x80, 0x00, ##         00        
            0x03, 0x80, 0x00, ##        000        
            0x07, 0x80, 0x00, ##       0000        
            0x3F, 0x00, 0x00, ##    000000         
            0x3E, 0x00, 0x00, ##    00000          
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x00, 0x3C, ##            0000
            0x00, 0x78, ##           0000 
            0x00, 0x70, ##           000  
            0x00, 0xE0, ##          000   
            0x01, 0xE0, ##         0000   
            0x03, 0xC0, ##        0000    
            0x03, 0x80, ##        000     
            0x07, 0x00, ##       000      
            0x0E, 0x00, ##      000       
            0x1E, 0x00, ##     0000       
            0x3C, 0x00, ##    0000        
            0x38, 0x00, ##    000         
            0x70, 0x00, ##   000          
            0xE0, 0x00, ##  000           
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 13, 
        'xoffset'  => 4, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xF8, ##          00000
            0x03, 0xF8, ##        0000000
            0x07, 0x80, ##       0000    
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x0E, 0x00, ##      000      
            0xFC, 0x00, ##  000000       
            0xFC, 0x00, ##  000000       
            0x0E, 0x00, ##      000      
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x00, ##       000     
            0x07, 0x80, ##       0000    
            0x03, 0xF8, ##        0000000
            0x00, 0xF8, ##          00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 3, 
        'xoffset'  => 4, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 12, 
        'xoffset'  => 4, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x00, ##  0000        
            0xFC, 0x00, ##  000000      
            0x1C, 0x00, ##     000      
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x07, 0x00, ##       000    
            0x03, 0xF0, ##        000000
            0x03, 0xF0, ##        000000
            0x07, 0x00, ##       000    
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x1E, 0x00, ##     0000     
            0xFC, 0x00, ##  000000      
            0xF0, 0x00, ##  0000        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x1F, 0x80, 0x10, ##     000000          0
            0x7F, 0xF0, 0x70, ##   00000000000     000
            0xE0, 0xFF, 0xE0, ##  000     00000000000 
            0x80, 0x1F, 0x80, ##  0          000000   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 10, 
        'xoffset'  => 3, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1E, 0x00, ##     0000   
            0x7F, 0x80, ##   00000000 
            0x61, 0x80, ##   00    00 
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0xC0, 0xC0, ##  00      00
            0x61, 0x80, ##   00    00 
            0x7F, 0x80, ##   00000000 
            0x1E, 0x00, ##     0000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { '65' => -1, '66' => -1, '71' => 1, '74' => 2, '79' => 1, '81' => 1, '84' => -3, '86' => -2, '87' => -1, '88' => -2, '89' => -4, '111' => 1, '118' => -1, '121' => -1, },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { '45' => -1, '46' => -1, '58' => -1, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -2, '86' => -2, '87' => -2, '89' => -2, '99' => -1, '100' => -1, '101' => -1, '102' => -1, '111' => -1, '113' => -1, '116' => -1, '118' => -2, '119' => -1, '121' => -2, },  # A
    '66' => { '67' => -1, '71' => -1, '79' => -1, '83' => -1, '86' => -1, '87' => -1, '89' => -2, },  # B
    '67' => { '89' => -1, },  # C
    '68' => { '65' => -1, '86' => -1, '89' => -2, },  # D
    '69' => { },  # E
    '70' => { '46' => -5, '58' => -2, '65' => -3, '83' => -1, '84' => -1, '97' => -3, '101' => -2, '105' => -2, '111' => -1, '114' => -2, '117' => -2, '121' => -3, },  # F
    '71' => { '84' => -1, '89' => -2, },  # G
    '72' => { '46' => -1, },  # H
    '73' => { },  # I
    '74' => { '45' => -1, '65' => -1, },  # J
    '75' => { '45' => -3, '65' => -1, '67' => -2, '79' => -2, '84' => -2, '85' => -1, '87' => -1, '89' => -1, '97' => -1, '101' => -2, '111' => -2, '117' => -2, '121' => -2, },  # K
    '76' => { '45' => -1, '65' => 1, '79' => -1, '84' => -4, '85' => -2, '86' => -4, '87' => -3, '89' => -4, '101' => -1, '111' => -1, '117' => -1, '121' => -3, },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { '45' => 1, '46' => -1, '58' => -1, '65' => -1, '86' => -1, '88' => -2, '89' => -2, },  # O
    '80' => { '45' => -1, '46' => -5, '65' => -2, '89' => -1, '97' => -1, '101' => -1, '105' => -1, '110' => -1, '111' => -1, '114' => -1, '115' => -1, '117' => -1, },  # P
    '81' => { '45' => 1, },  # Q
    '82' => { '45' => -1, '46' => -1, '58' => -1, '65' => -1, '67' => -2, '84' => -2, '86' => -2, '87' => -1, '89' => -2, '97' => -1, '101' => -1, '111' => -1, '117' => -1, '121' => -2, },  # R
    '83' => { '65' => 1, },  # S
    '84' => { '45' => -3, '46' => -4, '58' => -4, '65' => -2, '67' => -2, '97' => -5, '99' => -5, '101' => -5, '105' => -1, '111' => -5, '114' => -5, '115' => -5, '117' => -5, '119' => -5, '121' => -5, },  # T
    '85' => { '90' => -1, },  # U
    '86' => { '45' => -2, '46' => -4, '58' => -3, '65' => -2, '79' => -1, '97' => -2, '101' => -2, '105' => -1, '111' => -2, '117' => -2, '121' => -1, },  # V
    '87' => { '45' => -1, '46' => -4, '58' => -2, '65' => -2, '97' => -2, '101' => -2, '105' => -1, '111' => -2, '114' => -1, '117' => -1, '121' => -1, },  # W
    '88' => { '45' => -2, '67' => -2, '79' => -2, '84' => -1, '101' => -1, },  # X
    '89' => { '45' => -4, '46' => -6, '58' => -4, '65' => -2, '67' => -2, '79' => -2, '97' => -4, '101' => -4, '105' => -1, '111' => -4, '117' => -4, },  # Y
    '90' => { '45' => -1, },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { '120' => -1, },  # e
    '102' => { '45' => -2, '46' => -2, '58' => -1, '116' => -1, '119' => -1, '121' => -1, },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { '97' => -1, '101' => -1, '111' => -1, '117' => -1, '121' => -1, },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { '45' => 1, '46' => -1, '120' => -1, },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { '45' => -2, '46' => -3, '58' => -1, '99' => -1, '100' => -1, '101' => -1, '103' => -1, '104' => -1, '109' => -1, '110' => -1, '111' => -1, '113' => -1, '120' => -1, },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { '45' => -1, '46' => -2, '58' => -2, },  # v
    '119' => { '46' => -3, '58' => -2, },  # w
    '120' => { '99' => -1, '101' => -1, '111' => -1, },  # x
    '121' => { '45' => -1, '46' => -5, '58' => -2, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '176' => { },  # °
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
