package XUL::Node::Application::PeriodicTable::BoxLayout;

use strict;
use warnings;
use Carp;
use XUL::Node;

use base 'XUL::Node::Application::PeriodicTable::Base';

sub get_demo_box {
	VBox(FILL,
		GroupBox(
			Caption(label => 'flexiness'),
			HBox(
				Button(label => "No Flex"),
				Button(label => "No Flex"),
				Button(label => "No Flex"),
				Button(label => "No Flex"),
				Button(label => "No Flex"),
			),
			HBox(
				Button(label => "There's a"),
				Button(label => "spacer"),
				Spacer(FLEX),
				Button(label => "in the"),
				Button(label => "middle"),
			),
			HBox(
				Button(label => "This spacer ->"),
				Spacer(flex => 2),
				Button(label => "is bigger than this spacer, ->"),
				Spacer(FLEX),
				Button(label => "so there!"),
			),
			HBox(
				Button(label => "No Flex"),
				Button(label => "No Flex"),
				Button(FLEX, label => "flex=1"),
				Button(label => "No Flex"),
				Button(label => "No Flex"),
			),
			HBox(
				Button(FLEX, label => "flex=1"),
				Button(flex => 2, label => "flex=2"),
				Button(flex => 3, label => "flex=3"),
				Button(flex => 4, label => "flex=4"),
				Button(flex => 5, label => "flex=5"),
			),
			HBox(
				Button(FLEX, label => "flex=1"),
				Button(FLEX, label => "flex=1"),
				Button(FLEX, label => "flex=1"),
				Button(FLEX, label => "flex=1"),
				Button(FLEX, label => "flex=1"),
			),
		),
		GroupBox(
			Caption(label => 'direction'),
			HBox(DIR_FORWARD,
				Button(label => 'Here'),
				Button(label => 'the'),
				Button(label => 'direction'),
				Button(label => 'is'),
				Button(label => 'forward'),
			),
			HBox(DIR_REVERSE,
				Button(label => 'Here'),
				Button(label => 'the'),
				Button(label => 'direction'),
				Button(label => 'is'),
				Button(label => 'reverse'),
			),
			HBox(
				Button(ordinal => 4, label => 'Here the'),
				Button(ordinal => 1, label => 'ordinal'),
				Button(ordinal => 3, label => 'attribute'),
				Button(ordinal => 2, label => 'sets the order.'),
			),
		),
		GroupBox(
			Caption(label => 'packing'),
			HBox(PACK_START,
				Button(label => 'Here'),
				Button(label => 'the'),
				Button(label => 'packing'),
				Button(label => 'is'),
				Button(label => 'start'),
			),
			HBox(PACK_CENTER,
				Button(label => 'Here'),
				Button(label => 'the'),
				Button(label => 'packing'),
				Button(label => 'is'),
				Button(label => 'center'),
			),
			HBox(PACK_END,
				Button(label => 'Here'),
				Button(label => 'the'),
				Button(label => 'packing'),
				Button(label => 'is'),
				Button(label => 'end'),
			),
			HBox(PACK_START,
				Button(label => 'Here'),
				Button(label => 'packing'),
				Button(label => 'yields'),
				Button(label => 'to'),
				Button(FLEX, label => 'flex'),
			),
		),
		GroupBox(
			Caption(label => 'alignment'),
			HBox(ALIGN_START,
				Button(ORIENT_VERTICAL,
					label => 'Here',
					image => 'images/betty_boop.xbm',
				),
				Button(ORIENT_VERTICAL,
					Label(value => 'the'),
					Label(value => 'alignment'),
				),
				Button(label => 'is', image => 'images/betty_boop.xbm'),
				Button(label => 'start'),
			),
			HBox(ALIGN_CENTER,
				Button(ORIENT_VERTICAL,
					label => 'Here',
					image => 'images/betty_boop.xbm',
				),
				Button(ORIENT_VERTICAL,
					Label(value => 'the'),
					Label(value => 'alignment'),
				),
				Button(label => 'is', image => 'images/betty_boop.xbm'),
				Button(label => 'center'),
			),
			HBox(ALIGN_END,
				Button(ORIENT_VERTICAL,
					label => 'Here',
					image => 'images/betty_boop.xbm',
				),
				Button(ORIENT_VERTICAL,
					Label(value => 'the'),
					Label(value => 'alignment'),
				),
				Button(label => 'is', image => 'images/betty_boop.xbm'),
				Button(label => 'end'),
			),
			HBox(ALIGN_BASELINE,
				Button(ORIENT_VERTICAL,
					label => 'Here',
					image => 'images/betty_boop.xbm',
				),
				Button(ORIENT_VERTICAL,
					Label(value => 'the'),
					Label(value => 'alignment'),
				),
				Button(label => 'is', image => 'images/betty_boop.xbm'),
				Button(label => 'baseline'),
			),
			HBox(ALIGN_STRETCH,
				Button(ORIENT_VERTICAL,
					label => 'Here',
					image => 'images/betty_boop.xbm',
				),
				Button(ORIENT_VERTICAL,
					Label(value => 'the'),
					Label(value => 'alignment'),
				),
				Button(label => 'is', image => 'images/betty_boop.xbm'),
				Button(label => 'stretch'),
			),
		),
		GroupBox(ORIENT_HORIZONTAL,
			Caption(label => 'equality'),
			VBox(equalsize => 'always',
				Button(ORIENT_VERTICAL,
					label => 'Here',
					image => 'images/betty_boop.xbm',
				),
				Button(ORIENT_VERTICAL,
					Label(value => 'the'),
					Label(value => 'equalsize'),
					Label(value => 'attribute'),
				),
				Button(label => 'is', image => 'images/betty_boop.xbm'),
				Button(label => 'always'),
			),
			VBox(equalsize => 'never',
				Button(ORIENT_VERTICAL,
					label => 'Here',
					image => 'images/betty_boop.xbm',
				),
				Button(ORIENT_VERTICAL,
					Label(value => 'the'),
					Label(value => 'equalsize'),
					Label(value => 'attribute'),
				),
				Button(label => 'is', image => 'images/betty_boop.xbm'),
				Button(label => 'never'),
			),
		),
		GroupBox(
			Caption(label => 'hiddeness'),
			HBox(
				Label(value => 'Every other button in the line below is hidden'),
			),
			HBox(
				Button(label => 'Every'),
				Button(label => 'other', hidden => 1),
				Button(label => 'button'),
				Button(label => 'in', hidden => 1),
				Button(label => 'the'),
				Button(label => 'line', hidden => 1),
				Button(label => 'below'),
				Button(label => 'is', hidden => 1),
				Button(label => 'hidden'),
			),
		),
	);
}

1;
