# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

#	to_text_axfr.t
#x
######################### We start with some black magic to print on failure.
# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN {
	$| = 1; print "1..14\n"; 
	*CORE::GLOBAL::localtime = \&localtime;
}
END {print "not ok 1\n" unless $loaded;}

#use diagnostics;
use Net::DNS::Dig;
use Net::DNS::Codes qw(:all);
use Net::DNS::ToolKit qw(
	put1char
	get1char
	inet_aton
	getflags
	putflags
);
use Net::DNS::ToolKit::RR;
use Net::DNS::ToolKit::Debug qw(
	print_head
	print_buf
);

$loaded = 1;
print "ok 1\n";
######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

$test = 2;

sub ok {
  print "ok $test\n";
  ++$test;
}

$Net::DNS::Dig::VERSION = sprintf("%d.%02d",0,1);       # always test as version 0.01
Net::DNS::Dig::_set_NS(inet_aton('12.34.56.78'),inet_aton('23.45.67.89'));

package MyTest;

require './recurse2txt';

package main;

sub expect {
  my $x = shift;
  my @exp;
  foreach(split(/\n/,$x)) {
    if ($_ =~ /0x\w+\s+(\d+) /) {
      push @exp,$1;
    }
  }
  return @exp;
}

sub print_ptrs {
  foreach(@_) {
    print "$_ ";
  }
  print "\n";
}

sub chk_exp {
  my($bp,$exp) = @_;
  my @expect = expect($$exp);
  foreach(0..length($$bp) -1) {
    $char = get1char($bp,$_);
    next if $char == $expect[$_];
    print "buffer mismatch $_, got: $char, exp: $expect[$_]\nnot ";
    last;
  }
  &ok;
}

my $ques = q
| 0	:  0101_0010  0x52   82  R  
  1	:  1001_0101  0x95  149    
  2	:  0000_0001  0x01    1    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0000_0000  0x00    0    
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0111  0x07    7    
  13	:  0110_0101  0x65  101  e  
  14	:  0111_1000  0x78  120  x  
  15	:  0110_0001  0x61   97  a  
  16	:  0110_1101  0x6D  109  m  
  17	:  0111_0000  0x70  112  p  
  18	:  0110_1100  0x6C  108  l  
  19	:  0110_0101  0x65  101  e  
  20	:  0000_0011  0x03    3    
  21	:  0110_0011  0x63   99  c  
  22	:  0110_1111  0x6F  111  o  
  23	:  0110_1101  0x6D  109  m  
  24	:  0000_0000  0x00    0    
  25	:  0000_0000  0x00    0    
  26	:  1111_1100  0xFC  252    
  27	:  0000_0000  0x00    0    
  28	:  0000_0001  0x01    1    |;

my $ans = q
| 0	:  0101_0010  0x52   82  R  
  1	:  1001_0101  0x95  149    
  2	:  1000_0101  0x85  133    
  3	:  0000_0000  0x00    0    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0011_0110  0x36   54  6  
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0111  0x07    7    
  13	:  0110_0101  0x65  101  e  
  14	:  0111_1000  0x78  120  x  
  15	:  0110_0001  0x61   97  a  
  16	:  0110_1101  0x6D  109  m  
  17	:  0111_0000  0x70  112  p  
  18	:  0110_1100  0x6C  108  l  
  19	:  0110_0101  0x65  101  e  
  20	:  0000_0011  0x03    3    
  21	:  0110_0011  0x63   99  c  
  22	:  0110_1111  0x6F  111  o  
  23	:  0110_1101  0x6D  109  m  
  24	:  0000_0000  0x00    0    
  25	:  0000_0000  0x00    0    
  26	:  1111_1100  0xFC  252    
  27	:  0000_0000  0x00    0    
  28	:  0000_0001  0x01    1    
  29	:  1100_0000  0xC0  192    
  30	:  0000_1100  0x0C   12    
  31	:  0000_0000  0x00    0    
  32	:  0000_0110  0x06    6    
  33	:  0000_0000  0x00    0    
  34	:  0000_0001  0x01    1    
  35	:  0000_0000  0x00    0    
  36	:  0000_0000  0x00    0    
  37	:  0010_1010  0x2A   42  *  
  38	:  0011_0000  0x30   48  0  
  39	:  0000_0000  0x00    0    
  40	:  0011_0000  0x30   48  0  
  41	:  0000_0101  0x05    5    
  42	:  0110_1110  0x6E  110  n  
  43	:  0110_0001  0x61   97  a  
  44	:  0110_1101  0x6D  109  m  
  45	:  0110_0101  0x65  101  e  
  46	:  0111_0011  0x73  115  s  
  47	:  0000_0111  0x07    7    
  48	:  0110_0101  0x65  101  e  
  49	:  0111_1000  0x78  120  x  
  50	:  0110_0001  0x61   97  a  
  51	:  0110_1101  0x6D  109  m  
  52	:  0111_0000  0x70  112  p  
  53	:  0110_1100  0x6C  108  l  
  54	:  0110_0101  0x65  101  e  
  55	:  0000_0011  0x03    3    
  56	:  0110_1110  0x6E  110  n  
  57	:  0110_0101  0x65  101  e  
  58	:  0111_0100  0x74  116  t  
  59	:  0000_0000  0x00    0    
  60	:  0000_0110  0x06    6    
  61	:  0111_0011  0x73  115  s  
  62	:  0111_1001  0x79  121  y  
  63	:  0111_0011  0x73  115  s  
  64	:  0110_0001  0x61   97  a  
  65	:  0110_0100  0x64  100  d  
  66	:  0110_1101  0x6D  109  m  
  67	:  1100_0000  0xC0  192    
  68	:  0000_1100  0x0C   12    
  69	:  0111_0111  0x77  119  w  
  70	:  1101_1110  0xDE  222    
  71	:  1111_0100  0xF4  244    
  72	:  1111_0110  0xF6  246    
  73	:  0000_0000  0x00    0    
  74	:  0000_0000  0x00    0    
  75	:  1010_1000  0xA8  168    
  76	:  1100_0000  0xC0  192    
  77	:  0000_0000  0x00    0    
  78	:  0000_0000  0x00    0    
  79	:  0000_1110  0x0E   14    
  80	:  0001_0000  0x10   16    
  81	:  0000_0000  0x00    0    
  82	:  0000_0011  0x03    3    
  83	:  1111_0100  0xF4  244    
  84	:  1000_0000  0x80  128    
  85	:  0000_0000  0x00    0    
  86	:  0000_0000  0x00    0    
  87	:  0010_1010  0x2A   42  *  
  88	:  0011_0000  0x30   48  0  
  89	:  1100_0000  0xC0  192    
  90	:  0000_1100  0x0C   12    
  91	:  0000_0000  0x00    0    
  92	:  0000_0010  0x02    2    
  93	:  0000_0000  0x00    0    
  94	:  0000_0001  0x01    1    
  95	:  0000_0000  0x00    0    
  96	:  0000_0000  0x00    0    
  97	:  0010_1010  0x2A   42  *  
  98	:  0011_0000  0x30   48  0  
  99	:  0000_0000  0x00    0    
  100	:  0000_0110  0x06    6    
  101	:  0000_0011  0x03    3    
  102	:  0110_1110  0x6E  110  n  
  103	:  0111_0011  0x73  115  s  
  104	:  0011_0001  0x31   49  1  
  105	:  1100_0000  0xC0  192    
  106	:  0000_1100  0x0C   12    
  107	:  1100_0000  0xC0  192    
  108	:  0000_1100  0x0C   12    
  109	:  0000_0000  0x00    0    
  110	:  0000_0010  0x02    2    
  111	:  0000_0000  0x00    0    
  112	:  0000_0001  0x01    1    
  113	:  0000_0000  0x00    0    
  114	:  0000_0000  0x00    0    
  115	:  0010_1010  0x2A   42  *  
  116	:  0011_0000  0x30   48  0  
  117	:  0000_0000  0x00    0    
  118	:  0000_0110  0x06    6    
  119	:  0000_0011  0x03    3    
  120	:  0110_1110  0x6E  110  n  
  121	:  0111_0011  0x73  115  s  
  122	:  0011_0000  0x30   48  0  
  123	:  1100_0000  0xC0  192    
  124	:  0000_1100  0x0C   12    
  125	:  1100_0000  0xC0  192    
  126	:  0000_1100  0x0C   12    
  127	:  0000_0000  0x00    0    
  128	:  0000_0001  0x01    1    
  129	:  0000_0000  0x00    0    
  130	:  0000_0001  0x01    1    
  131	:  0000_0000  0x00    0    
  132	:  0000_0000  0x00    0    
  133	:  0010_1010  0x2A   42  *  
  134	:  0011_0000  0x30   48  0  
  135	:  0000_0000  0x00    0    
  136	:  0000_0100  0x04    4    
  137	:  1101_0011  0xD3  211    
  138	:  1110_0111  0xE7  231    
  139	:  1001_0001  0x91  145    
  140	:  1110_1000  0xE8  232    
  141	:  1100_0000  0xC0  192    
  142	:  0000_1100  0x0C   12    
  143	:  0000_0000  0x00    0    
  144	:  0000_1111  0x0F   15    
  145	:  0000_0000  0x00    0    
  146	:  0000_0001  0x01    1    
  147	:  0000_0000  0x00    0    
  148	:  0000_0000  0x00    0    
  149	:  0010_1010  0x2A   42  *  
  150	:  0011_0000  0x30   48  0  
  151	:  0000_0000  0x00    0    
  152	:  0000_1000  0x08    8    
  153	:  0000_0000  0x00    0    
  154	:  0000_1010  0x0A   10    
  155	:  0000_0011  0x03    3    
  156	:  0110_1101  0x6D  109  m  
  157	:  0111_1000  0x78  120  x  
  158	:  0011_0001  0x31   49  1  
  159	:  1100_0000  0xC0  192    
  160	:  0000_1100  0x0C   12    
  161	:  1100_0000  0xC0  192    
  162	:  0000_1100  0x0C   12    
  163	:  0000_0000  0x00    0    
  164	:  0000_1111  0x0F   15    
  165	:  0000_0000  0x00    0    
  166	:  0000_0001  0x01    1    
  167	:  0000_0000  0x00    0    
  168	:  0000_0000  0x00    0    
  169	:  0010_1010  0x2A   42  *  
  170	:  0011_0000  0x30   48  0  
  171	:  0000_0000  0x00    0    
  172	:  0000_1000  0x08    8    
  173	:  0000_0000  0x00    0    
  174	:  0011_0010  0x32   50  2  
  175	:  0000_0011  0x03    3    
  176	:  0110_1101  0x6D  109  m  
  177	:  0111_1000  0x78  120  x  
  178	:  0011_0010  0x32   50  2  
  179	:  1100_0000  0xC0  192    
  180	:  0000_1100  0x0C   12    
  181	:  1100_0000  0xC0  192    
  182	:  0000_1100  0x0C   12    
  183	:  0000_0000  0x00    0    
  184	:  0000_1111  0x0F   15    
  185	:  0000_0000  0x00    0    
  186	:  0000_0001  0x01    1    
  187	:  0000_0000  0x00    0    
  188	:  0000_0000  0x00    0    
  189	:  0010_1010  0x2A   42  *  
  190	:  0011_0000  0x30   48  0  
  191	:  0000_0000  0x00    0    
  192	:  0000_1000  0x08    8    
  193	:  0000_0000  0x00    0    
  194	:  0110_0100  0x64  100  d  
  195	:  0000_0011  0x03    3    
  196	:  0110_1101  0x6D  109  m  
  197	:  0111_1000  0x78  120  x  
  198	:  0011_0011  0x33   51  3  
  199	:  1100_0000  0xC0  192    
  200	:  0000_1100  0x0C   12    
  201	:  0000_1010  0x0A   10    
  202	:  0111_0011  0x73  115  s  
  203	:  0111_0100  0x74  116  t  
  204	:  0111_0010  0x72  114  r  
  205	:  0110_1111  0x6F  111  o  
  206	:  0110_1110  0x6E  110  n  
  207	:  0110_0111  0x67  103  g  
  208	:  0110_1000  0x68  104  h  
  209	:  0110_1111  0x6F  111  o  
  210	:  0110_1100  0x6C  108  l  
  211	:  0110_0100  0x64  100  d  
  212	:  1100_0000  0xC0  192    
  213	:  0000_1100  0x0C   12    
  214	:  0000_0000  0x00    0    
  215	:  0000_0101  0x05    5    
  216	:  0000_0000  0x00    0    
  217	:  0000_0001  0x01    1    
  218	:  0000_0000  0x00    0    
  219	:  0000_0000  0x00    0    
  220	:  0010_1010  0x2A   42  *  
  221	:  0011_0000  0x30   48  0  
  222	:  0000_0000  0x00    0    
  223	:  0000_0010  0x02    2    
  224	:  1100_0000  0xC0  192    
  225	:  0110_0101  0x65  101  e  
  226	:  0000_0011  0x03    3    
  227	:  0110_0110  0x66  102  f  
  228	:  0111_0100  0x74  116  t  
  229	:  0111_0000  0x70  112  p  
  230	:  1100_0000  0xC0  192    
  231	:  0000_1100  0x0C   12    
  232	:  0000_0000  0x00    0    
  233	:  0000_0101  0x05    5    
  234	:  0000_0000  0x00    0    
  235	:  0000_0001  0x01    1    
  236	:  0000_0000  0x00    0    
  237	:  0000_0000  0x00    0    
  238	:  0010_1010  0x2A   42  *  
  239	:  0011_0000  0x30   48  0  
  240	:  0000_0000  0x00    0    
  241	:  0000_0010  0x02    2    
  242	:  1100_0000  0xC0  192    
  243	:  0110_0101  0x65  101  e  
  244	:  0000_0100  0x04    4    
  245	:  0110_1000  0x68  104  h  
  246	:  0110_1111  0x6F  111  o  
  247	:  0110_1101  0x6D  109  m  
  248	:  0110_0101  0x65  101  e  
  249	:  1100_0000  0xC0  192    
  250	:  0000_1100  0x0C   12    
  251	:  0000_0000  0x00    0    
  252	:  0000_0101  0x05    5    
  253	:  0000_0000  0x00    0    
  254	:  0000_0001  0x01    1    
  255	:  0000_0000  0x00    0    
  256	:  0000_0000  0x00    0    
  257	:  0010_1010  0x2A   42  *  
  258	:  0011_0000  0x30   48  0  
  259	:  0000_0000  0x00    0    
  260	:  0000_0010  0x02    2    
  261	:  1100_0000  0xC0  192    
  262	:  0110_0101  0x65  101  e  
  263	:  0000_0010  0x02    2    
  264	:  0110_1100  0x6C  108  l  
  265	:  0110_0010  0x62   98  b  
  266	:  1100_0000  0xC0  192    
  267	:  0000_1100  0x0C   12    
  268	:  0000_0000  0x00    0    
  269	:  0000_0101  0x05    5    
  270	:  0000_0000  0x00    0    
  271	:  0000_0001  0x01    1    
  272	:  0000_0000  0x00    0    
  273	:  0000_0000  0x00    0    
  274	:  0010_1010  0x2A   42  *  
  275	:  0011_0000  0x30   48  0  
  276	:  0000_0000  0x00    0    
  277	:  0000_1100  0x0C   12    
  278	:  0000_1001  0x09    9    
  279	:  0110_1100  0x6C  108  l  
  280	:  0110_1111  0x6F  111  o  
  281	:  0110_0011  0x63   99  c  
  282	:  0110_0001  0x61   97  a  
  283	:  0110_1100  0x6C  108  l  
  284	:  0110_1000  0x68  104  h  
  285	:  0110_1111  0x6F  111  o  
  286	:  0111_0011  0x73  115  s  
  287	:  0111_0100  0x74  116  t  
  288	:  1100_0000  0xC0  192    
  289	:  0000_1100  0x0C   12    
  290	:  1100_0001  0xC1  193    
  291	:  0001_0110  0x16   22    
  292	:  0000_0000  0x00    0    
  293	:  0000_0001  0x01    1    
  294	:  0000_0000  0x00    0    
  295	:  0000_0001  0x01    1    
  296	:  0000_0000  0x00    0    
  297	:  0000_0000  0x00    0    
  298	:  0010_1010  0x2A   42  *  
  299	:  0011_0000  0x30   48  0  
  300	:  0000_0000  0x00    0    
  301	:  0000_0100  0x04    4    
  302	:  0111_1111  0x7F  127    
  303	:  0000_0000  0x00    0    
  304	:  0000_0000  0x00    0    
  305	:  0000_0001  0x01    1    
  306	:  0000_1000  0x08    8    
  307	:  0110_1100  0x6C  108  l  
  308	:  0110_1111  0x6F  111  o  
  309	:  0110_1111  0x6F  111  o  
  310	:  0111_0000  0x70  112  p  
  311	:  0110_0010  0x62   98  b  
  312	:  0110_0001  0x61   97  a  
  313	:  0110_0011  0x63   99  c  
  314	:  0110_1011  0x6B  107  k  
  315	:  1100_0000  0xC0  192    
  316	:  0000_1100  0x0C   12    
  317	:  0000_0000  0x00    0    
  318	:  0000_0101  0x05    5    
  319	:  0000_0000  0x00    0    
  320	:  0000_0001  0x01    1    
  321	:  0000_0000  0x00    0    
  322	:  0000_0000  0x00    0    
  323	:  0010_1010  0x2A   42  *  
  324	:  0011_0000  0x30   48  0  
  325	:  0000_0000  0x00    0    
  326	:  0000_0010  0x02    2    
  327	:  1100_0001  0xC1  193    
  328	:  0001_0110  0x16   22    
  329	:  1100_0000  0xC0  192    
  330	:  1001_1011  0x9B  155    
  331	:  0000_0000  0x00    0    
  332	:  0000_0001  0x01    1    
  333	:  0000_0000  0x00    0    
  334	:  0000_0001  0x01    1    
  335	:  0000_0000  0x00    0    
  336	:  0000_0000  0x00    0    
  337	:  0010_1010  0x2A   42  *  
  338	:  0011_0000  0x30   48  0  
  339	:  0000_0000  0x00    0    
  340	:  0000_0100  0x04    4    
  341	:  0001_1100  0x1C   28    
  342	:  0000_0010  0x02    2    
  343	:  0100_0011  0x43   67  C  
  344	:  0011_0010  0x32   50  2  
  345	:  1100_0000  0xC0  192    
  346	:  1001_1011  0x9B  155    
  347	:  0000_0000  0x00    0    
  348	:  0000_1111  0x0F   15    
  349	:  0000_0000  0x00    0    
  350	:  0000_0001  0x01    1    
  351	:  0000_0000  0x00    0    
  352	:  0000_0000  0x00    0    
  353	:  0010_1010  0x2A   42  *  
  354	:  0011_0000  0x30   48  0  
  355	:  0000_0000  0x00    0    
  356	:  0000_0100  0x04    4    
  357	:  0000_0000  0x00    0    
  358	:  0000_1010  0x0A   10    
  359	:  1100_0000  0xC0  192    
  360	:  1001_1011  0x9B  155    
  361	:  1100_0000  0xC0  192    
  362	:  1001_1011  0x9B  155    
  363	:  0000_0000  0x00    0    
  364	:  0001_0000  0x10   16    
  365	:  0000_0000  0x00    0    
  366	:  0000_0001  0x01    1    
  367	:  0000_0000  0x00    0    
  368	:  0000_0000  0x00    0    
  369	:  0010_1010  0x2A   42  *  
  370	:  0011_0000  0x30   48  0  
  371	:  0000_0000  0x00    0    
  372	:  0000_1110  0x0E   14    
  373	:  0000_1101  0x0D   13    
  374	:  0111_0110  0x76  118  v  
  375	:  0011_1101  0x3D   61  =  
  376	:  0111_0011  0x73  115  s  
  377	:  0111_0000  0x70  112  p  
  378	:  0110_0110  0x66  102  f  
  379	:  0011_0001  0x31   49  1  
  380	:  0010_0000  0x20   32     
  381	:  0110_0001  0x61   97  a  
  382	:  0010_0000  0x20   32     
  383	:  0010_1101  0x2D   45  -  
  384	:  0110_0001  0x61   97  a  
  385	:  0110_1100  0x6C  108  l  
  386	:  0110_1100  0x6C  108  l  
  387	:  1100_0000  0xC0  192    
  388	:  0110_0101  0x65  101  e  
  389	:  0000_0000  0x00    0    
  390	:  0000_0001  0x01    1    
  391	:  0000_0000  0x00    0    
  392	:  0000_0001  0x01    1    
  393	:  0000_0000  0x00    0    
  394	:  0000_0000  0x00    0    
  395	:  0010_1010  0x2A   42  *  
  396	:  0011_0000  0x30   48  0  
  397	:  0000_0000  0x00    0    
  398	:  0000_0100  0x04    4    
  399	:  0011_0011  0x33   51  3  
  400	:  1110_0111  0xE7  231    
  401	:  0001_0010  0x12   18    
  402	:  1001_0010  0x92  146    
  403	:  1100_0000  0xC0  192    
  404	:  0110_0101  0x65  101  e  
  405	:  0000_0000  0x00    0    
  406	:  0000_1111  0x0F   15    
  407	:  0000_0000  0x00    0    
  408	:  0000_0001  0x01    1    
  409	:  0000_0000  0x00    0    
  410	:  0000_0000  0x00    0    
  411	:  0010_1010  0x2A   42  *  
  412	:  0011_0000  0x30   48  0  
  413	:  0000_0000  0x00    0    
  414	:  0000_0100  0x04    4    
  415	:  0000_0000  0x00    0    
  416	:  0000_1010  0x0A   10    
  417	:  1100_0000  0xC0  192    
  418	:  1001_1011  0x9B  155    
  419	:  1100_0000  0xC0  192    
  420	:  0110_0101  0x65  101  e  
  421	:  0000_0000  0x00    0    
  422	:  0001_0000  0x10   16    
  423	:  0000_0000  0x00    0    
  424	:  0000_0001  0x01    1    
  425	:  0000_0000  0x00    0    
  426	:  0000_0000  0x00    0    
  427	:  0010_1010  0x2A   42  *  
  428	:  0011_0000  0x30   48  0  
  429	:  0000_0000  0x00    0    
  430	:  0000_1110  0x0E   14    
  431	:  0000_1101  0x0D   13    
  432	:  0111_0110  0x76  118  v  
  433	:  0011_1101  0x3D   61  =  
  434	:  0111_0011  0x73  115  s  
  435	:  0111_0000  0x70  112  p  
  436	:  0110_0110  0x66  102  f  
  437	:  0011_0001  0x31   49  1  
  438	:  0010_0000  0x20   32     
  439	:  0110_0001  0x61   97  a  
  440	:  0010_0000  0x20   32     
  441	:  0010_1101  0x2D   45  -  
  442	:  0110_0001  0x61   97  a  
  443	:  0110_1100  0x6C  108  l  
  444	:  0110_1100  0x6C  108  l  
  445	:  1100_0000  0xC0  192    
  446	:  1010_1111  0xAF  175    
  447	:  0000_0000  0x00    0    
  448	:  0000_0001  0x01    1    
  449	:  0000_0000  0x00    0    
  450	:  0000_0001  0x01    1    
  451	:  0000_0000  0x00    0    
  452	:  0000_0000  0x00    0    
  453	:  0010_1010  0x2A   42  *  
  454	:  0011_0000  0x30   48  0  
  455	:  0000_0000  0x00    0    
  456	:  0000_0100  0x04    4    
  457	:  1101_0011  0xD3  211    
  458	:  1110_0111  0xE7  231    
  459	:  1001_0001  0x91  145    
  460	:  1110_0001  0xE1  225    
  461	:  1100_0000  0xC0  192    
  462	:  1010_1111  0xAF  175    
  463	:  0000_0000  0x00    0    
  464	:  0000_1111  0x0F   15    
  465	:  0000_0000  0x00    0    
  466	:  0000_0001  0x01    1    
  467	:  0000_0000  0x00    0    
  468	:  0000_0000  0x00    0    
  469	:  0010_1010  0x2A   42  *  
  470	:  0011_0000  0x30   48  0  
  471	:  0000_0000  0x00    0    
  472	:  0000_0100  0x04    4    
  473	:  0000_0000  0x00    0    
  474	:  0000_1010  0x0A   10    
  475	:  1100_0000  0xC0  192    
  476	:  1010_1111  0xAF  175    
  477	:  1100_0000  0xC0  192    
  478	:  1010_1111  0xAF  175    
  479	:  0000_0000  0x00    0    
  480	:  0001_0000  0x10   16    
  481	:  0000_0000  0x00    0    
  482	:  0000_0001  0x01    1    
  483	:  0000_0000  0x00    0    
  484	:  0000_0000  0x00    0    
  485	:  0010_1010  0x2A   42  *  
  486	:  0011_0000  0x30   48  0  
  487	:  0000_0000  0x00    0    
  488	:  0000_1110  0x0E   14    
  489	:  0000_1101  0x0D   13    
  490	:  0111_0110  0x76  118  v  
  491	:  0011_1101  0x3D   61  =  
  492	:  0111_0011  0x73  115  s  
  493	:  0111_0000  0x70  112  p  
  494	:  0110_0110  0x66  102  f  
  495	:  0011_0001  0x31   49  1  
  496	:  0010_0000  0x20   32     
  497	:  0110_0001  0x61   97  a  
  498	:  0010_0000  0x20   32     
  499	:  0010_1101  0x2D   45  -  
  500	:  0110_0001  0x61   97  a  
  501	:  0110_1100  0x6C  108  l  
  502	:  0110_1100  0x6C  108  l  
  503	:  0000_0101  0x05    5    
  504	:  0110_1101  0x6D  109  m  
  505	:  0110_0001  0x61   97  a  
  506	:  0110_1001  0x69  105  i  
  507	:  0110_1100  0x6C  108  l  
  508	:  0011_0100  0x34   52  4  
  509	:  1100_0000  0xC0  192    
  510	:  0000_1100  0x0C   12    
  511	:  0000_0000  0x00    0    
  512	:  0000_0001  0x01    1    
  513	:  0000_0000  0x00    0    
  514	:  0000_0001  0x01    1    
  515	:  0000_0000  0x00    0    
  516	:  0000_0000  0x00    0    
  517	:  0010_1010  0x2A   42  *  
  518	:  0011_0000  0x30   48  0  
  519	:  0000_0000  0x00    0    
  520	:  0000_0100  0x04    4    
  521	:  0001_1100  0x1C   28    
  522	:  0000_0010  0x02    2    
  523	:  0100_0011  0x43   67  C  
  524	:  0011_0011  0x33   51  3  
  525	:  1100_0001  0xC1  193    
  526	:  1111_0111  0xF7  247    
  527	:  0000_0000  0x00    0    
  528	:  0000_1111  0x0F   15    
  529	:  0000_0000  0x00    0    
  530	:  0000_0001  0x01    1    
  531	:  0000_0000  0x00    0    
  532	:  0000_0000  0x00    0    
  533	:  0010_1010  0x2A   42  *  
  534	:  0011_0000  0x30   48  0  
  535	:  0000_0000  0x00    0    
  536	:  0000_0100  0x04    4    
  537	:  0000_0000  0x00    0    
  538	:  0000_1010  0x0A   10    
  539	:  1100_0001  0xC1  193    
  540	:  1111_0111  0xF7  247    
  541	:  1100_0001  0xC1  193    
  542	:  1111_0111  0xF7  247    
  543	:  0000_0000  0x00    0    
  544	:  0001_0000  0x10   16    
  545	:  0000_0000  0x00    0    
  546	:  0000_0001  0x01    1    
  547	:  0000_0000  0x00    0    
  548	:  0000_0000  0x00    0    
  549	:  0010_1010  0x2A   42  *  
  550	:  0011_0000  0x30   48  0  
  551	:  0000_0000  0x00    0    
  552	:  0000_1110  0x0E   14    
  553	:  0000_1101  0x0D   13    
  554	:  0111_0110  0x76  118  v  
  555	:  0011_1101  0x3D   61  =  
  556	:  0111_0011  0x73  115  s  
  557	:  0111_0000  0x70  112  p  
  558	:  0110_0110  0x66  102  f  
  559	:  0011_0001  0x31   49  1  
  560	:  0010_0000  0x20   32     
  561	:  0110_0001  0x61   97  a  
  562	:  0010_0000  0x20   32     
  563	:  0010_1101  0x2D   45  -  
  564	:  0110_0001  0x61   97  a  
  565	:  0110_1100  0x6C  108  l  
  566	:  0110_1100  0x6C  108  l  
  567	:  0000_0101  0x05    5    
  568	:  0110_1101  0x6D  109  m  
  569	:  0110_0001  0x61   97  a  
  570	:  0110_1001  0x69  105  i  
  571	:  0110_1100  0x6C  108  l  
  572	:  0011_0001  0x31   49  1  
  573	:  1100_0000  0xC0  192    
  574	:  0000_1100  0x0C   12    
  575	:  0000_0000  0x00    0    
  576	:  0000_0001  0x01    1    
  577	:  0000_0000  0x00    0    
  578	:  0000_0001  0x01    1    
  579	:  0000_0000  0x00    0    
  580	:  0000_0000  0x00    0    
  581	:  0010_1010  0x2A   42  *  
  582	:  0011_0000  0x30   48  0  
  583	:  0000_0000  0x00    0    
  584	:  0000_0100  0x04    4    
  585	:  1101_0011  0xD3  211    
  586	:  1110_0111  0xE7  231    
  587	:  1001_0001  0x91  145    
  588	:  1110_0010  0xE2  226    
  589	:  1100_0010  0xC2  194    
  590	:  0011_0111  0x37   55  7  
  591	:  0000_0000  0x00    0    
  592	:  0001_0000  0x10   16    
  593	:  0000_0000  0x00    0    
  594	:  0000_0001  0x01    1    
  595	:  0000_0000  0x00    0    
  596	:  0000_0000  0x00    0    
  597	:  0010_1010  0x2A   42  *  
  598	:  0011_0000  0x30   48  0  
  599	:  0000_0000  0x00    0    
  600	:  0000_1110  0x0E   14    
  601	:  0000_1101  0x0D   13    
  602	:  0111_0110  0x76  118  v  
  603	:  0011_1101  0x3D   61  =  
  604	:  0111_0011  0x73  115  s  
  605	:  0111_0000  0x70  112  p  
  606	:  0110_0110  0x66  102  f  
  607	:  0011_0001  0x31   49  1  
  608	:  0010_0000  0x20   32     
  609	:  0110_0001  0x61   97  a  
  610	:  0010_0000  0x20   32     
  611	:  0010_1101  0x2D   45  -  
  612	:  0110_0001  0x61   97  a  
  613	:  0110_1100  0x6C  108  l  
  614	:  0110_1100  0x6C  108  l  
  615	:  1100_0010  0xC2  194    
  616	:  0011_0111  0x37   55  7  
  617	:  0000_0000  0x00    0    
  618	:  0000_0001  0x01    1    
  619	:  0000_0000  0x00    0    
  620	:  0000_0001  0x01    1    
  621	:  0000_0000  0x00    0    
  622	:  0000_0000  0x00    0    
  623	:  0010_1010  0x2A   42  *  
  624	:  0011_0000  0x30   48  0  
  625	:  0000_0000  0x00    0    
  626	:  0000_0100  0x04    4    
  627	:  0001_1100  0x1C   28    
  628	:  0000_0010  0x02    2    
  629	:  0100_0011  0x43   67  C  
  630	:  0011_1000  0x38   56  8  
  631	:  1100_0010  0xC2  194    
  632	:  0011_0111  0x37   55  7  
  633	:  0000_0000  0x00    0    
  634	:  0001_0000  0x10   16    
  635	:  0000_0000  0x00    0    
  636	:  0000_0001  0x01    1    
  637	:  0000_0000  0x00    0    
  638	:  0000_0000  0x00    0    
  639	:  0010_1010  0x2A   42  *  
  640	:  0011_0000  0x30   48  0  
  641	:  0000_0000  0x00    0    
  642	:  0000_1110  0x0E   14    
  643	:  0000_1101  0x0D   13    
  644	:  0111_0110  0x76  118  v  
  645	:  0011_1101  0x3D   61  =  
  646	:  0111_0011  0x73  115  s  
  647	:  0111_0000  0x70  112  p  
  648	:  0110_0110  0x66  102  f  
  649	:  0011_0001  0x31   49  1  
  650	:  0010_0000  0x20   32     
  651	:  0110_0001  0x61   97  a  
  652	:  0010_0000  0x20   32     
  653	:  0010_1101  0x2D   45  -  
  654	:  0110_0001  0x61   97  a  
  655	:  0110_1100  0x6C  108  l  
  656	:  0110_1100  0x6C  108  l  
  657	:  1100_0000  0xC0  192    
  658	:  1100_0011  0xC3  195    
  659	:  0000_0000  0x00    0    
  660	:  0000_0001  0x01    1    
  661	:  0000_0000  0x00    0    
  662	:  0000_0001  0x01    1    
  663	:  0000_0000  0x00    0    
  664	:  0000_0000  0x00    0    
  665	:  0010_1010  0x2A   42  *  
  666	:  0011_0000  0x30   48  0  
  667	:  0000_0000  0x00    0    
  668	:  0000_0100  0x04    4    
  669	:  0001_1100  0x1C   28    
  670	:  0000_0010  0x02    2    
  671	:  0100_0011  0x43   67  C  
  672	:  0011_0100  0x34   52  4  
  673	:  1100_0000  0xC0  192    
  674	:  1100_0011  0xC3  195    
  675	:  0000_0000  0x00    0    
  676	:  0001_0000  0x10   16    
  677	:  0000_0000  0x00    0    
  678	:  0000_0001  0x01    1    
  679	:  0000_0000  0x00    0    
  680	:  0000_0000  0x00    0    
  681	:  0010_1010  0x2A   42  *  
  682	:  0011_0000  0x30   48  0  
  683	:  0000_0000  0x00    0    
  684	:  0000_1110  0x0E   14    
  685	:  0000_1101  0x0D   13    
  686	:  0111_0110  0x76  118  v  
  687	:  0011_1101  0x3D   61  =  
  688	:  0111_0011  0x73  115  s  
  689	:  0111_0000  0x70  112  p  
  690	:  0110_0110  0x66  102  f  
  691	:  0011_0001  0x31   49  1  
  692	:  0010_0000  0x20   32     
  693	:  0110_0001  0x61   97  a  
  694	:  0010_0000  0x20   32     
  695	:  0010_1101  0x2D   45  -  
  696	:  0110_0001  0x61   97  a  
  697	:  0110_1100  0x6C  108  l  
  698	:  0110_1100  0x6C  108  l  
  699	:  0000_0010  0x02    2    
  700	:  0111_0011  0x73  115  s  
  701	:  0111_0100  0x74  116  t  
  702	:  1100_0000  0xC0  192    
  703	:  0000_1100  0x0C   12    
  704	:  0000_0000  0x00    0    
  705	:  0000_1111  0x0F   15    
  706	:  0000_0000  0x00    0    
  707	:  0000_0001  0x01    1    
  708	:  0000_0000  0x00    0    
  709	:  0000_0000  0x00    0    
  710	:  0010_1010  0x2A   42  *  
  711	:  0011_0000  0x30   48  0  
  712	:  0000_0000  0x00    0    
  713	:  0000_0100  0x04    4    
  714	:  0000_0000  0x00    0    
  715	:  0000_1010  0x0A   10    
  716	:  1100_0010  0xC2  194    
  717	:  0011_0111  0x37   55  7  
  718	:  1100_0010  0xC2  194    
  719	:  1011_1011  0xBB  187    
  720	:  0000_0000  0x00    0    
  721	:  0000_1111  0x0F   15    
  722	:  0000_0000  0x00    0    
  723	:  0000_0001  0x01    1    
  724	:  0000_0000  0x00    0    
  725	:  0000_0000  0x00    0    
  726	:  0010_1010  0x2A   42  *  
  727	:  0011_0000  0x30   48  0  
  728	:  0000_0000  0x00    0    
  729	:  0000_0100  0x04    4    
  730	:  0000_0000  0x00    0    
  731	:  0110_0100  0x64  100  d  
  732	:  1100_0000  0xC0  192    
  733	:  1100_0011  0xC3  195    
  734	:  0000_0011  0x03    3    
  735	:  0110_0100  0x64  100  d  
  736	:  0110_1110  0x6E  110  n  
  737	:  0111_0011  0x73  115  s  
  738	:  1100_0000  0xC0  192    
  739	:  0000_1100  0x0C   12    
  740	:  0000_0000  0x00    0    
  741	:  0000_0001  0x01    1    
  742	:  0000_0000  0x00    0    
  743	:  0000_0001  0x01    1    
  744	:  0000_0000  0x00    0    
  745	:  0000_0000  0x00    0    
  746	:  0010_1010  0x2A   42  *  
  747	:  0011_0000  0x30   48  0  
  748	:  0000_0000  0x00    0    
  749	:  0000_0100  0x04    4    
  750	:  0001_1100  0x1C   28    
  751	:  0000_0010  0x02    2    
  752	:  0100_0011  0x43   67  C  
  753	:  0011_0010  0x32   50  2  
  754	:  1100_0000  0xC0  192    
  755	:  0111_0111  0x77  119  w  
  756	:  0000_0000  0x00    0    
  757	:  0000_0001  0x01    1    
  758	:  0000_0000  0x00    0    
  759	:  0000_0001  0x01    1    
  760	:  0000_0000  0x00    0    
  761	:  0000_0000  0x00    0    
  762	:  0010_1010  0x2A   42  *  
  763	:  0011_0000  0x30   48  0  
  764	:  0000_0000  0x00    0    
  765	:  0000_0100  0x04    4    
  766	:  1101_0011  0xD3  211    
  767	:  1110_0111  0xE7  231    
  768	:  1001_0001  0x91  145    
  769	:  1110_0001  0xE1  225    
  770	:  1100_0000  0xC0  192    
  771	:  0111_0111  0x77  119  w  
  772	:  0000_0000  0x00    0    
  773	:  0000_1111  0x0F   15    
  774	:  0000_0000  0x00    0    
  775	:  0000_0001  0x01    1    
  776	:  0000_0000  0x00    0    
  777	:  0000_0000  0x00    0    
  778	:  0010_1010  0x2A   42  *  
  779	:  0011_0000  0x30   48  0  
  780	:  0000_0000  0x00    0    
  781	:  0000_0100  0x04    4    
  782	:  0000_0000  0x00    0    
  783	:  0000_1010  0x0A   10    
  784	:  1100_0000  0xC0  192    
  785	:  1010_1111  0xAF  175    
  786	:  1100_0000  0xC0  192    
  787	:  0111_0111  0x77  119  w  
  788	:  0000_0000  0x00    0    
  789	:  0001_0000  0x10   16    
  790	:  0000_0000  0x00    0    
  791	:  0000_0001  0x01    1    
  792	:  0000_0000  0x00    0    
  793	:  0000_0000  0x00    0    
  794	:  0010_1010  0x2A   42  *  
  795	:  0011_0000  0x30   48  0  
  796	:  0000_0000  0x00    0    
  797	:  0000_1110  0x0E   14    
  798	:  0000_1101  0x0D   13    
  799	:  0111_0110  0x76  118  v  
  800	:  0011_1101  0x3D   61  =  
  801	:  0111_0011  0x73  115  s  
  802	:  0111_0000  0x70  112  p  
  803	:  0110_0110  0x66  102  f  
  804	:  0011_0001  0x31   49  1  
  805	:  0010_0000  0x20   32     
  806	:  0110_0001  0x61   97  a  
  807	:  0010_0000  0x20   32     
  808	:  0010_1101  0x2D   45  -  
  809	:  0110_0001  0x61   97  a  
  810	:  0110_1100  0x6C  108  l  
  811	:  0110_1100  0x6C  108  l  
  812	:  0000_0100  0x04    4    
  813	:  0111_0000  0x70  112  p  
  814	:  0110_1111  0x6F  111  o  
  815	:  0111_0000  0x70  112  p  
  816	:  0011_0011  0x33   51  3  
  817	:  1100_0000  0xC0  192    
  818	:  0000_1100  0x0C   12    
  819	:  0000_0000  0x00    0    
  820	:  0000_0101  0x05    5    
  821	:  0000_0000  0x00    0    
  822	:  0000_0001  0x01    1    
  823	:  0000_0000  0x00    0    
  824	:  0000_0000  0x00    0    
  825	:  0010_1010  0x2A   42  *  
  826	:  0011_0000  0x30   48  0  
  827	:  0000_0000  0x00    0    
  828	:  0000_0010  0x02    2    
  829	:  1100_0001  0xC1  193    
  830	:  1111_0111  0xF7  247    
  831	:  0000_0110  0x06    6    
  832	:  0110_0001  0x61   97  a  
  833	:  0110_1101  0x6D  109  m  
  834	:  0110_0010  0x62   98  b  
  835	:  0110_1100  0x6C  108  l  
  836	:  0110_1001  0x69  105  i  
  837	:  0110_1110  0x6E  110  n  
  838	:  1100_0000  0xC0  192    
  839	:  0000_1100  0x0C   12    
  840	:  0000_0000  0x00    0    
  841	:  0000_0101  0x05    5    
  842	:  0000_0000  0x00    0    
  843	:  0000_0001  0x01    1    
  844	:  0000_0000  0x00    0    
  845	:  0000_0000  0x00    0    
  846	:  0010_1010  0x2A   42  *  
  847	:  0011_0000  0x30   48  0  
  848	:  0000_0000  0x00    0    
  849	:  0000_0010  0x02    2    
  850	:  1100_0000  0xC0  192    
  851	:  0010_1111  0x2F   47  /  
  852	:  0000_1010  0x0A   10    
  853	:  0110_1100  0x6C  108  l  
  854	:  0110_1001  0x69  105  i  
  855	:  0111_0100  0x74  116  t  
  856	:  0111_0100  0x74  116  t  
  857	:  0110_1100  0x6C  108  l  
  858	:  0110_0101  0x65  101  e  
  859	:  0110_0110  0x66  102  f  
  860	:  0110_1001  0x69  105  i  
  861	:  0111_0011  0x73  115  s  
  862	:  0110_1000  0x68  104  h  
  863	:  1100_0000  0xC0  192    
  864	:  0000_1100  0x0C   12    
  865	:  0000_0000  0x00    0    
  866	:  0000_0001  0x01    1    
  867	:  0000_0000  0x00    0    
  868	:  0000_0001  0x01    1    
  869	:  0000_0000  0x00    0    
  870	:  0000_0000  0x00    0    
  871	:  0010_1010  0x2A   42  *  
  872	:  0011_0000  0x30   48  0  
  873	:  0000_0000  0x00    0    
  874	:  0000_0100  0x04    4    
  875	:  0001_1100  0x1C   28    
  876	:  0000_0010  0x02    2    
  877	:  0100_0011  0x43   67  C  
  878	:  0011_0011  0x33   51  3  
  879	:  1100_0011  0xC3  195    
  880	:  0101_0100  0x54   84  T  
  881	:  0000_0000  0x00    0    
  882	:  0000_1111  0x0F   15    
  883	:  0000_0000  0x00    0    
  884	:  0000_0001  0x01    1    
  885	:  0000_0000  0x00    0    
  886	:  0000_0000  0x00    0    
  887	:  0010_1010  0x2A   42  *  
  888	:  0011_0000  0x30   48  0  
  889	:  0000_0000  0x00    0    
  890	:  0000_0100  0x04    4    
  891	:  0000_0000  0x00    0    
  892	:  0000_1010  0x0A   10    
  893	:  1100_0001  0xC1  193    
  894	:  1111_0111  0xF7  247    
  895	:  1100_0011  0xC3  195    
  896	:  0101_0100  0x54   84  T  
  897	:  0000_0000  0x00    0    
  898	:  0001_0000  0x10   16    
  899	:  0000_0000  0x00    0    
  900	:  0000_0001  0x01    1    
  901	:  0000_0000  0x00    0    
  902	:  0000_0000  0x00    0    
  903	:  0010_1010  0x2A   42  *  
  904	:  0011_0000  0x30   48  0  
  905	:  0000_0000  0x00    0    
  906	:  0000_1110  0x0E   14    
  907	:  0000_1101  0x0D   13    
  908	:  0111_0110  0x76  118  v  
  909	:  0011_1101  0x3D   61  =  
  910	:  0111_0011  0x73  115  s  
  911	:  0111_0000  0x70  112  p  
  912	:  0110_0110  0x66  102  f  
  913	:  0011_0001  0x31   49  1  
  914	:  0010_0000  0x20   32     
  915	:  0110_0001  0x61   97  a  
  916	:  0010_0000  0x20   32     
  917	:  0010_1101  0x2D   45  -  
  918	:  0110_0001  0x61   97  a  
  919	:  0110_1100  0x6C  108  l  
  920	:  0110_1100  0x6C  108  l  
  921	:  0000_0100  0x04    4    
  922	:  0110_1100  0x6C  108  l  
  923	:  0110_1111  0x6F  111  o  
  924	:  0110_1111  0x6F  111  o  
  925	:  0110_1011  0x6B  107  k  
  926	:  1100_0000  0xC0  192    
  927	:  0000_1100  0x0C   12    
  928	:  0000_0000  0x00    0    
  929	:  0000_0101  0x05    5    
  930	:  0000_0000  0x00    0    
  931	:  0000_0001  0x01    1    
  932	:  0000_0000  0x00    0    
  933	:  0000_0000  0x00    0    
  934	:  0010_1010  0x2A   42  *  
  935	:  0011_0000  0x30   48  0  
  936	:  0000_0000  0x00    0    
  937	:  0000_0010  0x02    2    
  938	:  1100_0000  0xC0  192    
  939	:  0010_1111  0x2F   47  /  
  940	:  0000_0011  0x03    3    
  941	:  0111_0011  0x73  115  s  
  942	:  0110_0101  0x65  101  e  
  943	:  0110_0101  0x65  101  e  
  944	:  1100_0000  0xC0  192    
  945	:  0000_1100  0x0C   12    
  946	:  0000_0000  0x00    0    
  947	:  0000_0101  0x05    5    
  948	:  0000_0000  0x00    0    
  949	:  0000_0001  0x01    1    
  950	:  0000_0000  0x00    0    
  951	:  0000_0000  0x00    0    
  952	:  0010_1010  0x2A   42  *  
  953	:  0011_0000  0x30   48  0  
  954	:  0000_0000  0x00    0    
  955	:  0000_1001  0x09    9    
  956	:  0000_0110  0x06    6    
  957	:  0110_1100  0x6C  108  l  
  958	:  0110_1111  0x6F  111  o  
  959	:  0110_1111  0x6F  111  o  
  960	:  0110_1011  0x6B  107  k  
  961	:  0111_0101  0x75  117  u  
  962	:  0111_0000  0x70  112  p  
  963	:  1100_0000  0xC0  192    
  964	:  0010_1111  0x2F   47  /  
  965	:  0000_0011  0x03    3    
  966	:  0111_0111  0x77  119  w  
  967	:  0111_0111  0x77  119  w  
  968	:  0111_0111  0x77  119  w  
  969	:  1100_0011  0xC3  195    
  970	:  1010_1100  0xAC  172    
  971	:  0000_0000  0x00    0    
  972	:  0000_0101  0x05    5    
  973	:  0000_0000  0x00    0    
  974	:  0000_0001  0x01    1    
  975	:  0000_0000  0x00    0    
  976	:  0000_0000  0x00    0    
  977	:  0010_1010  0x2A   42  *  
  978	:  0011_0000  0x30   48  0  
  979	:  0000_0000  0x00    0    
  980	:  0000_0010  0x02    2    
  981	:  1100_0011  0xC3  195    
  982	:  1011_1100  0xBC  188    
  983	:  0000_0100  0x04    4    
  984	:  0110_0010  0x62   98  b  
  985	:  0110_1111  0x6F  111  o  
  986	:  0111_0010  0x72  114  r  
  987	:  0110_0111  0x67  103  g  
  988	:  1100_0000  0xC0  192    
  989	:  0000_1100  0x0C   12    
  990	:  0000_0000  0x00    0    
  991	:  0000_0001  0x01    1    
  992	:  0000_0000  0x00    0    
  993	:  0000_0001  0x01    1    
  994	:  0000_0000  0x00    0    
  995	:  0000_0000  0x00    0    
  996	:  0010_1010  0x2A   42  *  
  997	:  0011_0000  0x30   48  0  
  998	:  0000_0000  0x00    0    
  999	:  0000_0100  0x04    4    
  1000	:  1101_0011  0xD3  211    
  1001	:  1110_0111  0xE7  231    
  1002	:  1001_0001  0x91  145    
  1003	:  1110_0110  0xE6  230    
  1004	:  1100_0011  0xC3  195    
  1005	:  1101_0111  0xD7  215    
  1006	:  0000_0000  0x00    0    
  1007	:  0000_1111  0x0F   15    
  1008	:  0000_0000  0x00    0    
  1009	:  0000_0001  0x01    1    
  1010	:  0000_0000  0x00    0    
  1011	:  0000_0000  0x00    0    
  1012	:  0010_1010  0x2A   42  *  
  1013	:  0011_0000  0x30   48  0  
  1014	:  0000_0000  0x00    0    
  1015	:  0000_0100  0x04    4    
  1016	:  0000_0000  0x00    0    
  1017	:  0000_1010  0x0A   10    
  1018	:  1100_0000  0xC0  192    
  1019	:  1001_1011  0x9B  155    
  1020	:  1100_0011  0xC3  195    
  1021	:  1101_0111  0xD7  215    
  1022	:  0000_0000  0x00    0    
  1023	:  0000_1111  0x0F   15    
  1024	:  0000_0000  0x00    0    
  1025	:  0000_0001  0x01    1    
  1026	:  0000_0000  0x00    0    
  1027	:  0000_0000  0x00    0    
  1028	:  0010_1010  0x2A   42  *  
  1029	:  0011_0000  0x30   48  0  
  1030	:  0000_0000  0x00    0    
  1031	:  0000_0100  0x04    4    
  1032	:  0000_0000  0x00    0    
  1033	:  0001_0100  0x14   20    
  1034	:  1100_0000  0xC0  192    
  1035	:  1010_1111  0xAF  175    
  1036	:  0000_0100  0x04    4    
  1037	:  0111_0011  0x73  115  s  
  1038	:  0110_1101  0x6D  109  m  
  1039	:  0111_0100  0x74  116  t  
  1040	:  0111_0000  0x70  112  p  
  1041	:  1100_0000  0xC0  192    
  1042	:  0000_1100  0x0C   12    
  1043	:  0000_0000  0x00    0    
  1044	:  0000_0101  0x05    5    
  1045	:  0000_0000  0x00    0    
  1046	:  0000_0001  0x01    1    
  1047	:  0000_0000  0x00    0    
  1048	:  0000_0000  0x00    0    
  1049	:  0010_1010  0x2A   42  *  
  1050	:  0011_0000  0x30   48  0  
  1051	:  0000_0000  0x00    0    
  1052	:  0000_0010  0x02    2    
  1053	:  1100_0001  0xC1  193    
  1054	:  1111_0111  0xF7  247    
  1055	:  0000_1000  0x08    8    
  1056	:  0111_0100  0x74  116  t  
  1057	:  0110_1001  0x69  105  i  
  1058	:  0110_1101  0x6D  109  m  
  1059	:  0110_0101  0x65  101  e  
  1060	:  0110_1000  0x68  104  h  
  1061	:  0110_1111  0x6F  111  o  
  1062	:  0111_0011  0x73  115  s  
  1063	:  0111_0100  0x74  116  t  
  1064	:  1100_0000  0xC0  192    
  1065	:  0000_1100  0x0C   12    
  1066	:  0000_0000  0x00    0    
  1067	:  0000_0101  0x05    5    
  1068	:  0000_0000  0x00    0    
  1069	:  0000_0001  0x01    1    
  1070	:  0000_0000  0x00    0    
  1071	:  0000_0000  0x00    0    
  1072	:  0010_1010  0x2A   42  *  
  1073	:  0011_0000  0x30   48  0  
  1074	:  0000_0000  0x00    0    
  1075	:  0000_0010  0x02    2    
  1076	:  1100_0000  0xC0  192    
  1077	:  0111_0111  0x77  119  w  
  1078	:  0000_1000  0x08    8    
  1079	:  0110_1101  0x6D  109  m  
  1080	:  0110_1111  0x6F  111  o  
  1081	:  0111_0101  0x75  117  u  
  1082	:  0110_1110  0x6E  110  n  
  1083	:  0111_0100  0x74  116  t  
  1084	:  0110_0001  0x61   97  a  
  1085	:  0110_1001  0x69  105  i  
  1086	:  0110_1110  0x6E  110  n  
  1087	:  1100_0000  0xC0  192    
  1088	:  0000_1100  0x0C   12    
  1089	:  0000_0000  0x00    0    
  1090	:  0000_1111  0x0F   15    
  1091	:  0000_0000  0x00    0    
  1092	:  0000_0001  0x01    1    
  1093	:  0000_0000  0x00    0    
  1094	:  0000_0000  0x00    0    
  1095	:  0010_1010  0x2A   42  *  
  1096	:  0011_0000  0x30   48  0  
  1097	:  0000_0000  0x00    0    
  1098	:  0001_0011  0x13   19    
  1099	:  0000_0000  0x00    0    
  1100	:  0000_1010  0x0A   10    
  1101	:  0000_0101  0x05    5    
  1102	:  0110_1101  0x6D  109  m  
  1103	:  0110_0001  0x61   97  a  
  1104	:  0110_1001  0x69  105  i  
  1105	:  0110_1100  0x6C  108  l  
  1106	:  0011_0001  0x31   49  1  
  1107	:  0000_1000  0x08    8    
  1108	:  0110_1101  0x6D  109  m  
  1109	:  0111_1000  0x78  120  x  
  1110	:  0110_1101  0x6D  109  m  
  1111	:  0110_0001  0x61   97  a  
  1112	:  0110_1001  0x69  105  i  
  1113	:  0110_1100  0x6C  108  l  
  1114	:  0110_0101  0x65  101  e  
  1115	:  0111_0010  0x72  114  r  
  1116	:  1100_0000  0xC0  192    
  1117	:  0001_0100  0x14   20    
  1118	:  0000_0011  0x03    3    
  1119	:  0111_0111  0x77  119  w  
  1120	:  0111_0111  0x77  119  w  
  1121	:  0111_0111  0x77  119  w  
  1122	:  1100_0000  0xC0  192    
  1123	:  0000_1100  0x0C   12    
  1124	:  0000_0000  0x00    0    
  1125	:  0000_0101  0x05    5    
  1126	:  0000_0000  0x00    0    
  1127	:  0000_0001  0x01    1    
  1128	:  0000_0000  0x00    0    
  1129	:  0000_0000  0x00    0    
  1130	:  0010_1010  0x2A   42  *  
  1131	:  0011_0000  0x30   48  0  
  1132	:  0000_0000  0x00    0    
  1133	:  0000_0010  0x02    2    
  1134	:  1100_0000  0xC0  192    
  1135	:  0000_1100  0x0C   12    
  1136	:  0000_0111  0x07    7    
  1137	:  0111_0000  0x70  112  p  
  1138	:  0110_1111  0x6F  111  o  
  1139	:  0110_1100  0x6C  108  l  
  1140	:  0110_0101  0x65  101  e  
  1141	:  0110_0011  0x63   99  c  
  1142	:  0110_0001  0x61   97  a  
  1143	:  0111_0100  0x74  116  t  
  1144	:  1100_0000  0xC0  192    
  1145	:  0000_1100  0x0C   12    
  1146	:  0000_0000  0x00    0    
  1147	:  0000_1101  0x0D   13    
  1148	:  0000_0000  0x00    0    
  1149	:  0000_0001  0x01    1    
  1150	:  0000_0000  0x00    0    
  1151	:  0000_0000  0x00    0    
  1152	:  0010_1010  0x2A   42  *  
  1153	:  0011_0000  0x30   48  0  
  1154	:  0000_0000  0x00    0    
  1155	:  0001_0110  0x16   22    
  1156	:  0000_1000  0x08    8    
  1157	:  0111_0010  0x72  114  r  
  1158	:  0110_0101  0x65  101  e  
  1159	:  0111_0011  0x73  115  s  
  1160	:  0110_0101  0x65  101  e  
  1161	:  0111_0010  0x72  114  r  
  1162	:  0111_0110  0x76  118  v  
  1163	:  0110_0101  0x65  101  e  
  1164	:  0110_0100  0x64  100  d  
  1165	:  0000_1100  0x0C   12    
  1166	:  0110_0110  0x66  102  f  
  1167	:  0110_1111  0x6F  111  o  
  1168	:  0111_0010  0x72  114  r  
  1169	:  0010_0000  0x20   32     
  1170	:  0111_0000  0x70  112  p  
  1171	:  0110_1111  0x6F  111  o  
  1172	:  0110_1100  0x6C  108  l  
  1173	:  0110_1001  0x69  105  i  
  1174	:  0111_0100  0x74  116  t  
  1175	:  0110_1001  0x69  105  i  
  1176	:  0110_0011  0x63   99  c  
  1177	:  0111_0011  0x73  115  s  
  1178	:  1100_0000  0xC0  192    
  1179	:  0000_1100  0x0C   12    
  1180	:  0000_0000  0x00    0    
  1181	:  0000_0110  0x06    6    
  1182	:  0000_0000  0x00    0    
  1183	:  0000_0001  0x01    1    
  1184	:  0000_0000  0x00    0    
  1185	:  0000_0000  0x00    0    
  1186	:  0010_1010  0x2A   42  *  
  1187	:  0011_0000  0x30   48  0  
  1188	:  0000_0000  0x00    0    
  1189	:  0001_1000  0x18   24    
  1190	:  1100_0000  0xC0  192    
  1191	:  0010_1001  0x29   41  )  
  1192	:  1100_0000  0xC0  192    
  1193	:  0011_1100  0x3C   60  <  
  1194	:  0111_0111  0x77  119  w  
  1195	:  1101_1110  0xDE  222    
  1196	:  1111_0100  0xF4  244    
  1197	:  1111_0110  0xF6  246    
  1198	:  0000_0000  0x00    0    
  1199	:  0000_0000  0x00    0    
  1200	:  1010_1000  0xA8  168    
  1201	:  1100_0000  0xC0  192    
  1202	:  0000_0000  0x00    0    
  1203	:  0000_0000  0x00    0    
  1204	:  0000_1110  0x0E   14    
  1205	:  0001_0000  0x10   16    
  1206	:  0000_0000  0x00    0    
  1207	:  0000_0011  0x03    3    
  1208	:  1111_0100  0xF4  244    
  1209	:  1000_0000  0x80  128    
  1210	:  0000_0000  0x00    0    
  1211	:  0000_0000  0x00    0    
  1212	:  0010_1010  0x2A   42  *  
  1213	:  0011_0000  0x30   48  0  |;

# ; <<>> dig.pl 1.11 <<>> -d -t axfr @eagle.is.bizsystems.com example.com
# ;;
# example.com.		  10800	IN	SOA	names.example.net. sysadm.example.com. 2011100406 43200 3600 259200 10800 
# example.com.		  10800	IN	NS	ns1.example.com. 
# example.com.		  10800	IN	NS	ns0.example.com. 
# example.com.		  10800	IN	A	211.231.145.232 
# example.com.		  10800	IN	MX	10 mx1.example.com. 
# example.com.		  10800	IN	MX	50 mx2.example.com. 
# example.com.		  10800	IN	MX	100 mx3.example.com. 
# stronghold.example.com. 10800	IN	CNAME	ns1.example.com. 
# ftp.example.com.	  10800	IN	CNAME	ns1.example.com. 
# home.example.com.	  10800	IN	CNAME	ns1.example.com. 
# lb.example.com.	  10800	IN	CNAME	localhost.example.com. 
# localhost.example.com.  10800	IN	A	127.0.0.1 
# loopback.example.com.	  10800	IN	CNAME	localhost.example.com. 
# mx1.example.com.	  10800	IN	A	28.2.67.50 
# mx1.example.com.	  10800	IN	MX	10 mx1.example.com. 
# mx1.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# ns1.example.com.	  10800	IN	A	51.231.18.146 
# ns1.example.com.	  10800	IN	MX	10 mx1.example.com. 
# ns1.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# mx2.example.com.	  10800	IN	A	211.231.145.225 
# mx2.example.com.	  10800	IN	MX	10 mx2.example.com. 
# mx2.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# mail4.example.com.	  10800	IN	A	28.2.67.51 
# mail4.example.com.	  10800	IN	MX	10 mail4.example.com. 
# mail4.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# mail1.example.com.	  10800	IN	A	211.231.145.226 
# mail1.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# mail1.example.com.	  10800	IN	A	28.2.67.56 
# mail1.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# mx3.example.com.	  10800	IN	A	28.2.67.52 
# mx3.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# st.example.com.	  10800	IN	MX	10 mail1.example.com. 
# st.example.com.	  10800	IN	MX	100 mx3.example.com. 
# dns.example.com.	  10800	IN	A	28.2.67.50 
# ns0.example.com.	  10800	IN	A	211.231.145.225 
# ns0.example.com.	  10800	IN	MX	10 mx2.example.com. 
# ns0.example.com.	  10800	IN	TXT	"v=spf1 a -all" 
# pop3.example.com.	  10800	IN	CNAME	mail4.example.com. 
# amblin.example.com.	  10800	IN	CNAME	example.net. 
# littlefish.example.com. 10800	IN	A	28.2.67.51 
# littlefish.example.com. 10800	IN	MX	10 mail4.example.com. 
# littlefish.example.com. 10800	IN	TXT	"v=spf1 a -all" 
# look.example.com.	  10800	IN	CNAME	example.net. 
# see.example.com.	  10800	IN	CNAME	lookup.example.net. 
# www.see.example.com.	  10800	IN	CNAME	lookup.example.net. 
# borg.example.com.	  10800	IN	A	211.231.145.230 
# borg.example.com.	  10800	IN	MX	10 mx1.example.com. 
# borg.example.com.	  10800	IN	MX	20 mx2.example.com. 
# smtp.example.com.	  10800	IN	CNAME	mail4.example.com. 
# timehost.example.com.	  10800	IN	CNAME	ns0.example.com. 
# mountain.example.com.	  10800	IN	MX	10 mail1.mxmailer.com. 
# www.example.com.	  10800	IN	CNAME	example.com. 
# polecat.example.com.	  10800	IN	HINFO	"reserved" "for politics" 
# example.com.		  10800	IN	SOA	names.example.net. sysadm.example.com. 2011100406 43200 3600 259200 10800 
# 
# ;; Query time: 332 ms
# ;; SERVER: 192.168.1.164# 53(names.example.net)
# ;; WHEN: Tue Oct  4 18:53:02 2011
# ;; MSG SIZE rcvd: 1214 -- XFR size: 55 records
# 


# input:	data pointer
# returns:	pointer to query buffer
#
sub makebuf {
  my $dp = shift;
  my @data = split("\n",$$dp);
  my $off = 0;
  my $buffer = '';
  foreach (@data) {
    $_ =~ /0x.{2}\s+(\d+)/;
    $off = put1char(\$buffer,$off,$1);
  }
  return \$buffer;
}

{
	undef local $^W;
	*Net::DNS::Dig::ndd_gethostbyaddr = \&mygethostbyaddr;
}

# dummy localtime
sub localtime {
  return 'Mon Oct  3 13:41:57 2011';
}

# dummy mygethostbyaddr
sub mygethostbyaddr {
  return 'names.example.net';
}

my $ap = makebuf(\$ans);
my $qp = makebuf(\$ques);

my $soacount = 0;
my($get,$put,$parse) = new Net::DNS::ToolKit::RR;

## test 2	check server failure
my $dig = new Net::DNS::Dig;
$dig->{SERVER} = '12.34.56.78';
my $rp = $dig->_proc_body($ap,$qp,$get,$put,\$soacount);
#print_head($rp);
#print "\n";
#print_head($qp);
chk_exp($rp,\$ans);

## test 3	check object contents
my $exp = q|495	= {
	'ANSWER'	=> [{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> ['names.example.net','sysadm.example.com',2011100406,43200,3600,259200,10800,],
		'RDLEN'	=> 48,
		'TTL'	=> 10800,
		'TYPE'	=> 6,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> ['ns1.example.com',],
		'RDLEN'	=> 6,
		'TTL'	=> 10800,
		'TYPE'	=> 2,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> ['ns0.example.com',],
		'RDLEN'	=> 6,
		'TTL'	=> 10800,
		'TYPE'	=> 2,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> ['',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> [10,'mx1.example.com',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> [50,'mx2.example.com',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> [100,'mx3.example.com',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'stronghold.example.com',
		'RDATA'	=> ['ns1.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ftp.example.com',
		'RDATA'	=> ['ns1.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'home.example.com',
		'RDATA'	=> ['ns1.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'lb.example.com',
		'RDATA'	=> ['localhost.example.com',],
		'RDLEN'	=> 12,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'localhost.example.com',
		'RDATA'	=> ['  ',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'loopback.example.com',
		'RDATA'	=> ['localhost.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx1.example.com',
		'RDATA'	=> ['C2',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx1.example.com',
		'RDATA'	=> [10,'mx1.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx1.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns1.example.com',
		'RDATA'	=> ['3',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns1.example.com',
		'RDATA'	=> [10,'mx1.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns1.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx2.example.com',
		'RDATA'	=> ['',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx2.example.com',
		'RDATA'	=> [10,'mx2.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx2.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail4.example.com',
		'RDATA'	=> ['C3',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail4.example.com',
		'RDATA'	=> [10,'mail4.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail4.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail1.example.com',
		'RDATA'	=> ['',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail1.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail1.example.com',
		'RDATA'	=> ['C8',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mail1.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx3.example.com',
		'RDATA'	=> ['C4',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mx3.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'st.example.com',
		'RDATA'	=> [10,'mail1.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'st.example.com',
		'RDATA'	=> [100,'mx3.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'dns.example.com',
		'RDATA'	=> ['C2',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns0.example.com',
		'RDATA'	=> ['',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns0.example.com',
		'RDATA'	=> [10,'mx2.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'ns0.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'pop3.example.com',
		'RDATA'	=> ['mail4.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'amblin.example.com',
		'RDATA'	=> ['example.net',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'littlefish.example.com',
		'RDATA'	=> ['C3',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'littlefish.example.com',
		'RDATA'	=> [10,'mail4.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'littlefish.example.com',
		'RDATA'	=> ['v=spf1 a -all',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 16,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'look.example.com',
		'RDATA'	=> ['example.net',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'see.example.com',
		'RDATA'	=> ['lookup.example.net',],
		'RDLEN'	=> 9,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'www.see.example.com',
		'RDATA'	=> ['lookup.example.net',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'borg.example.com',
		'RDATA'	=> ['',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 1,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'borg.example.com',
		'RDATA'	=> [10,'mx1.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'borg.example.com',
		'RDATA'	=> [20,'mx2.example.com',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'smtp.example.com',
		'RDATA'	=> ['mail4.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'timehost.example.com',
		'RDATA'	=> ['ns0.example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'mountain.example.com',
		'RDATA'	=> [10,'mail1.mxmailer.com',],
		'RDLEN'	=> 19,
		'TTL'	=> 10800,
		'TYPE'	=> 15,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'www.example.com',
		'RDATA'	=> ['example.com',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 5,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'polecat.example.com',
		'RDATA'	=> ['reserved','for politics',],
		'RDLEN'	=> 22,
		'TTL'	=> 10800,
		'TYPE'	=> 13,
	},
{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'RDATA'	=> ['names.example.net','sysadm.example.com',2011100406,43200,3600,259200,10800,],
		'RDLEN'	=> 24,
		'TTL'	=> 10800,
		'TYPE'	=> 6,
	},
],
	'BYTES'	=> 1214,
	'Class'	=> 'IN',
	'HEADER'	=> {
		'AA'	=> 1,
		'AD'	=> 0,
		'ANCOUNT'	=> 54,
		'ARCOUNT'	=> 0,
		'CD'	=> 0,
		'ID'	=> 21141,
		'MBZ'	=> 0,
		'NSCOUNT'	=> 0,
		'OPCODE'	=> 0,
		'QDCOUNT'	=> 1,
		'QR'	=> 1,
		'RA'	=> 0,
		'RCODE'	=> 0,
		'RD'	=> 1,
		'TC'	=> 0,
	},
	'NRECS'	=> 55,
	'PeerAddr'	=> ['12.34.56.78','23.45.67.89',],
	'PeerPort'	=> 53,
	'Proto'	=> 'UDP',
	'QUESTION'	=> [{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'TYPE'	=> 252,
	},
],
	'Recursion'	=> 256,
	'SERVER'	=> '12.34.56.78',
	'Timeout'	=> 15,
	'_SS'	=> {
		'12.34.56.78'	=> '"8N',
		'23.45.67.89'	=> '-CY',
	},
};
|;

#print MyTest::Dumper($dig);
my $got = MyTest::Dumper($dig);
print "proc_body failed\ngot: $got\nexp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 4	check that soacount is incremented
print "soacount increment failed, got $soacount, exp 2\nnot "
	unless $soacount == 2;
&ok;

$soacount = 0;

## test 5	build text object
$dig->{ELAPSED} = 56;
my $tobj = $dig->to_text();
$exp = q|497	= {
	'ANSWER'	=> [{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['names.example.net.','sysadm.example.com.',2011100406,43200,3600,259200,10800,],
		'RDLEN'	=> 48,
		'TTL'	=> 10800,
		'TYPE'	=> 'SOA',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 6,
		'TTL'	=> 10800,
		'TYPE'	=> 'NS',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['ns0.example.com.',],
		'RDLEN'	=> 6,
		'TTL'	=> 10800,
		'TYPE'	=> 'NS',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['211.231.145.232',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> [50,'mx2.example.com.',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> [100,'mx3.example.com.',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'stronghold.example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ftp.example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'home.example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'lb.example.com.',
		'RDATA'	=> ['localhost.example.com.',],
		'RDLEN'	=> 12,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'localhost.example.com.',
		'RDATA'	=> ['127.0.0.1',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'loopback.example.com.',
		'RDATA'	=> ['localhost.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx1.example.com.',
		'RDATA'	=> ['28.2.67.50',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx1.example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns1.example.com.',
		'RDATA'	=> ['51.231.18.146',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns1.example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx2.example.com.',
		'RDATA'	=> ['211.231.145.225',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx2.example.com.',
		'RDATA'	=> [10,'mx2.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx2.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail4.example.com.',
		'RDATA'	=> ['28.2.67.51',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail4.example.com.',
		'RDATA'	=> [10,'mail4.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail4.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['211.231.145.226',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['28.2.67.56',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx3.example.com.',
		'RDATA'	=> ['28.2.67.52',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx3.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'st.example.com.',
		'RDATA'	=> [10,'mail1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'st.example.com.',
		'RDATA'	=> [100,'mx3.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'dns.example.com.',
		'RDATA'	=> ['28.2.67.50',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns0.example.com.',
		'RDATA'	=> ['211.231.145.225',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns0.example.com.',
		'RDATA'	=> [10,'mx2.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns0.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'pop3.example.com.',
		'RDATA'	=> ['mail4.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'amblin.example.com.',
		'RDATA'	=> ['example.net.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'littlefish.example.com.',
		'RDATA'	=> ['28.2.67.51',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'littlefish.example.com.',
		'RDATA'	=> [10,'mail4.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'littlefish.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'look.example.com.',
		'RDATA'	=> ['example.net.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'see.example.com.',
		'RDATA'	=> ['lookup.example.net.',],
		'RDLEN'	=> 9,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'www.see.example.com.',
		'RDATA'	=> ['lookup.example.net.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'borg.example.com.',
		'RDATA'	=> ['211.231.145.230',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'borg.example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'borg.example.com.',
		'RDATA'	=> [20,'mx2.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'smtp.example.com.',
		'RDATA'	=> ['mail4.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'timehost.example.com.',
		'RDATA'	=> ['ns0.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mountain.example.com.',
		'RDATA'	=> [10,'mail1.mxmailer.com.',],
		'RDLEN'	=> 19,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'www.example.com.',
		'RDATA'	=> ['example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'polecat.example.com.',
		'RDATA'	=> ['"reserved"','"for politics"',],
		'RDLEN'	=> 22,
		'TTL'	=> 10800,
		'TYPE'	=> 'HINFO',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['names.example.net.','sysadm.example.com.',2011100406,43200,3600,259200,10800,],
		'RDLEN'	=> 24,
		'TTL'	=> 10800,
		'TYPE'	=> 'SOA',
	},
],
	'BYTES'	=> 1214,
	'Class'	=> 'IN',
	'ELAPSED'	=> 56,
	'HEADER'	=> {
		'AA'	=> 1,
		'AD'	=> 0,
		'ANCOUNT'	=> 54,
		'ARCOUNT'	=> 0,
		'CD'	=> 0,
		'ID'	=> 21141,
		'MBZ'	=> 0,
		'NSCOUNT'	=> 0,
		'OPCODE'	=> 'QUERY',
		'QDCOUNT'	=> 1,
		'QR'	=> 1,
		'RA'	=> 0,
		'RCODE'	=> 'NOERROR',
		'RD'	=> 1,
		'TC'	=> 0,
	},
	'NRECS'	=> 55,
	'PeerAddr'	=> ['12.34.56.78','23.45.67.89',],
	'PeerPort'	=> 53,
	'Proto'	=> 'UDP',
	'QUESTION'	=> [{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'TYPE'	=> 'AXFR',
	},
],
	'Recursion'	=> 256,
	'SERVER'	=> '12.34.56.78',
	'TEXT'	=> '
; <<>> Net::DNS::Dig 0.01 <<>> -t axfr example.com.
;;
example.com.	10800	IN	SOA	 names.example.net. sysadm.example.com. 2011100406 43200 3600 259200 10800
example.com.	10800	IN	NS	 ns1.example.com.
example.com.	10800	IN	NS	 ns0.example.com.
example.com.	10800	IN	A	 211.231.145.232
example.com.	10800	IN	MX	 10 mx1.example.com.
example.com.	10800	IN	MX	 50 mx2.example.com.
example.com.	10800	IN	MX	 100 mx3.example.com.
stronghold.example.com.	10800	IN	CNAME	 ns1.example.com.
ftp.example.com.	10800	IN	CNAME	 ns1.example.com.
home.example.com.	10800	IN	CNAME	 ns1.example.com.
lb.example.com.	10800	IN	CNAME	 localhost.example.com.
localhost.example.com.	10800	IN	A	 127.0.0.1
loopback.example.com.	10800	IN	CNAME	 localhost.example.com.
mx1.example.com.	10800	IN	A	 28.2.67.50
mx1.example.com.	10800	IN	MX	 10 mx1.example.com.
mx1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
ns1.example.com.	10800	IN	A	 51.231.18.146
ns1.example.com.	10800	IN	MX	 10 mx1.example.com.
ns1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mx2.example.com.	10800	IN	A	 211.231.145.225
mx2.example.com.	10800	IN	MX	 10 mx2.example.com.
mx2.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mail4.example.com.	10800	IN	A	 28.2.67.51
mail4.example.com.	10800	IN	MX	 10 mail4.example.com.
mail4.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mail1.example.com.	10800	IN	A	 211.231.145.226
mail1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mail1.example.com.	10800	IN	A	 28.2.67.56
mail1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mx3.example.com.	10800	IN	A	 28.2.67.52
mx3.example.com.	10800	IN	TXT	 "v=spf1 a -all"
st.example.com.	10800	IN	MX	 10 mail1.example.com.
st.example.com.	10800	IN	MX	 100 mx3.example.com.
dns.example.com.	10800	IN	A	 28.2.67.50
ns0.example.com.	10800	IN	A	 211.231.145.225
ns0.example.com.	10800	IN	MX	 10 mx2.example.com.
ns0.example.com.	10800	IN	TXT	 "v=spf1 a -all"
pop3.example.com.	10800	IN	CNAME	 mail4.example.com.
amblin.example.com.	10800	IN	CNAME	 example.net.
littlefish.example.com.	10800	IN	A	 28.2.67.51
littlefish.example.com.	10800	IN	MX	 10 mail4.example.com.
littlefish.example.com.	10800	IN	TXT	 "v=spf1 a -all"
look.example.com.	10800	IN	CNAME	 example.net.
see.example.com.	10800	IN	CNAME	 lookup.example.net.
www.see.example.com.	10800	IN	CNAME	 lookup.example.net.
borg.example.com.	10800	IN	A	 211.231.145.230
borg.example.com.	10800	IN	MX	 10 mx1.example.com.
borg.example.com.	10800	IN	MX	 20 mx2.example.com.
smtp.example.com.	10800	IN	CNAME	 mail4.example.com.
timehost.example.com.	10800	IN	CNAME	 ns0.example.com.
mountain.example.com.	10800	IN	MX	 10 mail1.mxmailer.com.
www.example.com.	10800	IN	CNAME	 example.com.
polecat.example.com.	10800	IN	HINFO	 "reserved" "for politics"
example.com.	10800	IN	SOA	 names.example.net. sysadm.example.com. 2011100406 43200 3600 259200 10800
;; Query time: 56 ms
;; SERVER: 12.34.56.78# 53(12.34.56.78)
;; WHEN: Mon Oct  3 13:41:57 2011
;; MSG SIZE rcvd: 1214 -- XFR size: 55 records
',
	'Timeout'	=> 15,
	'_SS'	=> {
		'12.34.56.78'	=> '"8N',
		'23.45.67.89'	=> '-CY',
	},
};
|;
$got = MyTest::Dumper($tobj);
print "to_text conversion failed\ngot: $got\nexp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 6	check that soacount did not increment
print "failed soacount increment, got: $soacount, exp: 0\nnot "
	unless $soacount == 0;
&ok;

## test 7	check server failure

$dig = new Net::DNS::Dig;
$dig->{SERVER} = '12.34.56.78';
$rp = $dig->_proc_body($ap,$qp,$get,$put,\$soacount);
#print_head($rp);
#print "\n";
#print_head($qp);
chk_exp($rp,\$ans);

## test 8	check object contents
$exp = q|497	= {
	'ANSWER'	=> [{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['names.example.net.','sysadm.example.com.',2011100406,43200,3600,259200,10800,],
		'RDLEN'	=> 48,
		'TTL'	=> 10800,
		'TYPE'	=> 'SOA',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 6,
		'TTL'	=> 10800,
		'TYPE'	=> 'NS',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['ns0.example.com.',],
		'RDLEN'	=> 6,
		'TTL'	=> 10800,
		'TYPE'	=> 'NS',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['211.231.145.232',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> [50,'mx2.example.com.',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> [100,'mx3.example.com.',],
		'RDLEN'	=> 8,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'stronghold.example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ftp.example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'home.example.com.',
		'RDATA'	=> ['ns1.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'lb.example.com.',
		'RDATA'	=> ['localhost.example.com.',],
		'RDLEN'	=> 12,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'localhost.example.com.',
		'RDATA'	=> ['127.0.0.1',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'loopback.example.com.',
		'RDATA'	=> ['localhost.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx1.example.com.',
		'RDATA'	=> ['28.2.67.50',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx1.example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns1.example.com.',
		'RDATA'	=> ['51.231.18.146',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns1.example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx2.example.com.',
		'RDATA'	=> ['211.231.145.225',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx2.example.com.',
		'RDATA'	=> [10,'mx2.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx2.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail4.example.com.',
		'RDATA'	=> ['28.2.67.51',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail4.example.com.',
		'RDATA'	=> [10,'mail4.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail4.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['211.231.145.226',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['28.2.67.56',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mail1.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx3.example.com.',
		'RDATA'	=> ['28.2.67.52',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mx3.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'st.example.com.',
		'RDATA'	=> [10,'mail1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'st.example.com.',
		'RDATA'	=> [100,'mx3.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'dns.example.com.',
		'RDATA'	=> ['28.2.67.50',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns0.example.com.',
		'RDATA'	=> ['211.231.145.225',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns0.example.com.',
		'RDATA'	=> [10,'mx2.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'ns0.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'pop3.example.com.',
		'RDATA'	=> ['mail4.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'amblin.example.com.',
		'RDATA'	=> ['example.net.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'littlefish.example.com.',
		'RDATA'	=> ['28.2.67.51',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'littlefish.example.com.',
		'RDATA'	=> [10,'mail4.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'littlefish.example.com.',
		'RDATA'	=> ['"v=spf1 a -all"',],
		'RDLEN'	=> 14,
		'TTL'	=> 10800,
		'TYPE'	=> 'TXT',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'look.example.com.',
		'RDATA'	=> ['example.net.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'see.example.com.',
		'RDATA'	=> ['lookup.example.net.',],
		'RDLEN'	=> 9,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'www.see.example.com.',
		'RDATA'	=> ['lookup.example.net.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'borg.example.com.',
		'RDATA'	=> ['211.231.145.230',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'A',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'borg.example.com.',
		'RDATA'	=> [10,'mx1.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'borg.example.com.',
		'RDATA'	=> [20,'mx2.example.com.',],
		'RDLEN'	=> 4,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'smtp.example.com.',
		'RDATA'	=> ['mail4.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'timehost.example.com.',
		'RDATA'	=> ['ns0.example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'mountain.example.com.',
		'RDATA'	=> [10,'mail1.mxmailer.com.',],
		'RDLEN'	=> 19,
		'TTL'	=> 10800,
		'TYPE'	=> 'MX',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'www.example.com.',
		'RDATA'	=> ['example.com.',],
		'RDLEN'	=> 2,
		'TTL'	=> 10800,
		'TYPE'	=> 'CNAME',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'polecat.example.com.',
		'RDATA'	=> ['"reserved"','"for politics"',],
		'RDLEN'	=> 22,
		'TTL'	=> 10800,
		'TYPE'	=> 'HINFO',
	},
{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'RDATA'	=> ['names.example.net.','sysadm.example.com.',2011100406,43200,3600,259200,10800,],
		'RDLEN'	=> 24,
		'TTL'	=> 10800,
		'TYPE'	=> 'SOA',
	},
],
	'BYTES'	=> 1214,
	'Class'	=> 'IN',
	'ELAPSED'	=> 56,
	'HEADER'	=> {
		'AA'	=> 1,
		'AD'	=> 0,
		'ANCOUNT'	=> 54,
		'ARCOUNT'	=> 0,
		'CD'	=> 0,
		'ID'	=> 21141,
		'MBZ'	=> 0,
		'NSCOUNT'	=> 0,
		'OPCODE'	=> 'QUERY',
		'QDCOUNT'	=> 1,
		'QR'	=> 1,
		'RA'	=> 0,
		'RCODE'	=> 'NOERROR',
		'RD'	=> 1,
		'TC'	=> 0,
	},
	'NRECS'	=> 55,
	'PeerAddr'	=> ['12.34.56.78','23.45.67.89',],
	'PeerPort'	=> 53,
	'Proto'	=> 'UDP',
	'QUESTION'	=> [{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'TYPE'	=> 'AXFR',
	},
],
	'Recursion'	=> 256,
	'SERVER'	=> '12.34.56.78',
	'TEXT'	=> '
; <<>> Net::DNS::Dig 0.01 <<>> -t axfr example.com.
;;
example.com.	10800	IN	SOA	 names.example.net. sysadm.example.com. 2011100406 43200 3600 259200 10800
example.com.	10800	IN	NS	 ns1.example.com.
example.com.	10800	IN	NS	 ns0.example.com.
example.com.	10800	IN	A	 211.231.145.232
example.com.	10800	IN	MX	 10 mx1.example.com.
example.com.	10800	IN	MX	 50 mx2.example.com.
example.com.	10800	IN	MX	 100 mx3.example.com.
stronghold.example.com.	10800	IN	CNAME	 ns1.example.com.
ftp.example.com.	10800	IN	CNAME	 ns1.example.com.
home.example.com.	10800	IN	CNAME	 ns1.example.com.
lb.example.com.	10800	IN	CNAME	 localhost.example.com.
localhost.example.com.	10800	IN	A	 127.0.0.1
loopback.example.com.	10800	IN	CNAME	 localhost.example.com.
mx1.example.com.	10800	IN	A	 28.2.67.50
mx1.example.com.	10800	IN	MX	 10 mx1.example.com.
mx1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
ns1.example.com.	10800	IN	A	 51.231.18.146
ns1.example.com.	10800	IN	MX	 10 mx1.example.com.
ns1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mx2.example.com.	10800	IN	A	 211.231.145.225
mx2.example.com.	10800	IN	MX	 10 mx2.example.com.
mx2.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mail4.example.com.	10800	IN	A	 28.2.67.51
mail4.example.com.	10800	IN	MX	 10 mail4.example.com.
mail4.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mail1.example.com.	10800	IN	A	 211.231.145.226
mail1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mail1.example.com.	10800	IN	A	 28.2.67.56
mail1.example.com.	10800	IN	TXT	 "v=spf1 a -all"
mx3.example.com.	10800	IN	A	 28.2.67.52
mx3.example.com.	10800	IN	TXT	 "v=spf1 a -all"
st.example.com.	10800	IN	MX	 10 mail1.example.com.
st.example.com.	10800	IN	MX	 100 mx3.example.com.
dns.example.com.	10800	IN	A	 28.2.67.50
ns0.example.com.	10800	IN	A	 211.231.145.225
ns0.example.com.	10800	IN	MX	 10 mx2.example.com.
ns0.example.com.	10800	IN	TXT	 "v=spf1 a -all"
pop3.example.com.	10800	IN	CNAME	 mail4.example.com.
amblin.example.com.	10800	IN	CNAME	 example.net.
littlefish.example.com.	10800	IN	A	 28.2.67.51
littlefish.example.com.	10800	IN	MX	 10 mail4.example.com.
littlefish.example.com.	10800	IN	TXT	 "v=spf1 a -all"
look.example.com.	10800	IN	CNAME	 example.net.
see.example.com.	10800	IN	CNAME	 lookup.example.net.
www.see.example.com.	10800	IN	CNAME	 lookup.example.net.
borg.example.com.	10800	IN	A	 211.231.145.230
borg.example.com.	10800	IN	MX	 10 mx1.example.com.
borg.example.com.	10800	IN	MX	 20 mx2.example.com.
smtp.example.com.	10800	IN	CNAME	 mail4.example.com.
timehost.example.com.	10800	IN	CNAME	 ns0.example.com.
mountain.example.com.	10800	IN	MX	 10 mail1.mxmailer.com.
www.example.com.	10800	IN	CNAME	 example.com.
polecat.example.com.	10800	IN	HINFO	 "reserved" "for politics"
example.com.	10800	IN	SOA	 names.example.net. sysadm.example.com. 2011100406 43200 3600 259200 10800
;; Query time: 56 ms
;; SERVER: 12.34.56.78# 53(12.34.56.78)
;; WHEN: Mon Oct  3 13:41:57 2011
;; MSG SIZE rcvd: 1214 -- XFR size: 55 records
',
	'Timeout'	=> 15,
	'_SS'	=> {
		'12.34.56.78'	=> '"8N',
		'23.45.67.89'	=> '-CY',
	},
};
|;
$got = MyTest::Dumper($tobj);
print "to_text conversion failed\ngot: $got\nexp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 9	check that soacount incremented
print "soacount increment failed, got: $soacount, exp: 2\nnot "
	unless $soacount == 2;
&ok;

$soacount = 0;

## test 10	check server failure
$dig = new Net::DNS::Dig;
$dig->{SERVER} = '12.34.56.78';
my $flags = getflags($ap);
$flags |= &NOTAUTH;
putflags($ap, $flags);
#print_head($qp);
#print MyTest::Dumper($dig);

my $ans2 = q
| 0	:  0101_0010  0x52   82  R  
  1	:  1001_0101  0x95  149    
  2	:  1000_0101  0x85  133    
  3	:  0000_1001  0x09    9    
  4	:  0000_0000  0x00    0    
  5	:  0000_0001  0x01    1    
  6	:  0000_0000  0x00    0    
  7	:  0011_0110  0x36   54  6  
  8	:  0000_0000  0x00    0    
  9	:  0000_0000  0x00    0    
  10	:  0000_0000  0x00    0    
  11	:  0000_0000  0x00    0    
  12	:  0000_0111  0x07    7    
  13	:  0110_0101  0x65  101  e  
  14	:  0111_1000  0x78  120  x  
  15	:  0110_0001  0x61   97  a  
  16	:  0110_1101  0x6D  109  m  
  17	:  0111_0000  0x70  112  p  
  18	:  0110_1100  0x6C  108  l  
  19	:  0110_0101  0x65  101  e  
  20	:  0000_0011  0x03    3    
  21	:  0110_0011  0x63   99  c  
  22	:  0110_1111  0x6F  111  o  
  23	:  0110_1101  0x6D  109  m  
  24	:  0000_0000  0x00    0    
  25	:  0000_0000  0x00    0    
  26	:  1111_1100  0xFC  252    
  27	:  0000_0000  0x00    0    
  28	:  0000_0001  0x01    1    
  29	:  1100_0000  0xC0  192    
  30	:  0000_1100  0x0C   12    
  31	:  0000_0000  0x00    0    
  32	:  0000_0110  0x06    6    
  33	:  0000_0000  0x00    0    
  34	:  0000_0001  0x01    1    
  35	:  0000_0000  0x00    0    
  36	:  0000_0000  0x00    0    
  37	:  0010_1010  0x2A   42  *  
  38	:  0011_0000  0x30   48  0  
  39	:  0000_0000  0x00    0    
  40	:  0011_0000  0x30   48  0  
  41	:  0000_0101  0x05    5    
  42	:  0110_1110  0x6E  110  n  
  43	:  0110_0001  0x61   97  a  
  44	:  0110_1101  0x6D  109  m  
  45	:  0110_0101  0x65  101  e  
  46	:  0111_0011  0x73  115  s  
  47	:  0000_0111  0x07    7    
  48	:  0110_0101  0x65  101  e  
  49	:  0111_1000  0x78  120  x  
  50	:  0110_0001  0x61   97  a  
  51	:  0110_1101  0x6D  109  m  
  52	:  0111_0000  0x70  112  p  
  53	:  0110_1100  0x6C  108  l  
  54	:  0110_0101  0x65  101  e  
  55	:  0000_0011  0x03    3    
  56	:  0110_1110  0x6E  110  n  
  57	:  0110_0101  0x65  101  e  
  58	:  0111_0100  0x74  116  t  
  59	:  0000_0000  0x00    0    
  60	:  0000_0110  0x06    6    
  61	:  0111_0011  0x73  115  s  
  62	:  0111_1001  0x79  121  y  
  63	:  0111_0011  0x73  115  s  
  64	:  0110_0001  0x61   97  a  
  65	:  0110_0100  0x64  100  d  
  66	:  0110_1101  0x6D  109  m  
  67	:  1100_0000  0xC0  192    
  68	:  0000_1100  0x0C   12    
  69	:  0111_0111  0x77  119  w  
  70	:  1101_1110  0xDE  222    
  71	:  1111_0100  0xF4  244    
  72	:  1111_0110  0xF6  246    
  73	:  0000_0000  0x00    0    
  74	:  0000_0000  0x00    0    
  75	:  1010_1000  0xA8  168    
  76	:  1100_0000  0xC0  192    
  77	:  0000_0000  0x00    0    
  78	:  0000_0000  0x00    0    
  79	:  0000_1110  0x0E   14    
  80	:  0001_0000  0x10   16    
  81	:  0000_0000  0x00    0    
  82	:  0000_0011  0x03    3    
  83	:  1111_0100  0xF4  244    
  84	:  1000_0000  0x80  128    
  85	:  0000_0000  0x00    0    
  86	:  0000_0000  0x00    0    
  87	:  0010_1010  0x2A   42  *  
  88	:  0011_0000  0x30   48  0  
  89	:  1100_0000  0xC0  192    
  90	:  0000_1100  0x0C   12    
  91	:  0000_0000  0x00    0    
  92	:  0000_0010  0x02    2    
  93	:  0000_0000  0x00    0    
  94	:  0000_0001  0x01    1    
  95	:  0000_0000  0x00    0    
  96	:  0000_0000  0x00    0    
  97	:  0010_1010  0x2A   42  *  
  98	:  0011_0000  0x30   48  0  
  99	:  0000_0000  0x00    0    
  100	:  0000_0110  0x06    6    
  101	:  0000_0011  0x03    3    
  102	:  0110_1110  0x6E  110  n  
  103	:  0111_0011  0x73  115  s  
  104	:  0011_0001  0x31   49  1  
  105	:  1100_0000  0xC0  192    
  106	:  0000_1100  0x0C   12    
  107	:  1100_0000  0xC0  192    
  108	:  0000_1100  0x0C   12    
  109	:  0000_0000  0x00    0    
  110	:  0000_0010  0x02    2    
  111	:  0000_0000  0x00    0    
  112	:  0000_0001  0x01    1    
  113	:  0000_0000  0x00    0    
  114	:  0000_0000  0x00    0    
  115	:  0010_1010  0x2A   42  *  
  116	:  0011_0000  0x30   48  0  
  117	:  0000_0000  0x00    0    
  118	:  0000_0110  0x06    6    
  119	:  0000_0011  0x03    3    
  120	:  0110_1110  0x6E  110  n  
  121	:  0111_0011  0x73  115  s  
  122	:  0011_0000  0x30   48  0  
  123	:  1100_0000  0xC0  192    
  124	:  0000_1100  0x0C   12    
  125	:  1100_0000  0xC0  192    
  126	:  0000_1100  0x0C   12    
  127	:  0000_0000  0x00    0    
  128	:  0000_0001  0x01    1    
  129	:  0000_0000  0x00    0    
  130	:  0000_0001  0x01    1    
  131	:  0000_0000  0x00    0    
  132	:  0000_0000  0x00    0    
  133	:  0010_1010  0x2A   42  *  
  134	:  0011_0000  0x30   48  0  
  135	:  0000_0000  0x00    0    
  136	:  0000_0100  0x04    4    
  137	:  1101_0011  0xD3  211    
  138	:  1110_0111  0xE7  231    
  139	:  1001_0001  0x91  145    
  140	:  1110_1000  0xE8  232    
  141	:  1100_0000  0xC0  192    
  142	:  0000_1100  0x0C   12    
  143	:  0000_0000  0x00    0    
  144	:  0000_1111  0x0F   15    
  145	:  0000_0000  0x00    0    
  146	:  0000_0001  0x01    1    
  147	:  0000_0000  0x00    0    
  148	:  0000_0000  0x00    0    
  149	:  0010_1010  0x2A   42  *  
  150	:  0011_0000  0x30   48  0  
  151	:  0000_0000  0x00    0    
  152	:  0000_1000  0x08    8    
  153	:  0000_0000  0x00    0    
  154	:  0000_1010  0x0A   10    
  155	:  0000_0011  0x03    3    
  156	:  0110_1101  0x6D  109  m  
  157	:  0111_1000  0x78  120  x  
  158	:  0011_0001  0x31   49  1  
  159	:  1100_0000  0xC0  192    
  160	:  0000_1100  0x0C   12    
  161	:  1100_0000  0xC0  192    
  162	:  0000_1100  0x0C   12    
  163	:  0000_0000  0x00    0    
  164	:  0000_1111  0x0F   15    
  165	:  0000_0000  0x00    0    
  166	:  0000_0001  0x01    1    
  167	:  0000_0000  0x00    0    
  168	:  0000_0000  0x00    0    
  169	:  0010_1010  0x2A   42  *  
  170	:  0011_0000  0x30   48  0  
  171	:  0000_0000  0x00    0    
  172	:  0000_1000  0x08    8    
  173	:  0000_0000  0x00    0    
  174	:  0011_0010  0x32   50  2  
  175	:  0000_0011  0x03    3    
  176	:  0110_1101  0x6D  109  m  
  177	:  0111_1000  0x78  120  x  
  178	:  0011_0010  0x32   50  2  
  179	:  1100_0000  0xC0  192    
  180	:  0000_1100  0x0C   12    
  181	:  1100_0000  0xC0  192    
  182	:  0000_1100  0x0C   12    
  183	:  0000_0000  0x00    0    
  184	:  0000_1111  0x0F   15    
  185	:  0000_0000  0x00    0    
  186	:  0000_0001  0x01    1    
  187	:  0000_0000  0x00    0    
  188	:  0000_0000  0x00    0    
  189	:  0010_1010  0x2A   42  *  
  190	:  0011_0000  0x30   48  0  
  191	:  0000_0000  0x00    0    
  192	:  0000_1000  0x08    8    
  193	:  0000_0000  0x00    0    
  194	:  0110_0100  0x64  100  d  
  195	:  0000_0011  0x03    3    
  196	:  0110_1101  0x6D  109  m  
  197	:  0111_1000  0x78  120  x  
  198	:  0011_0011  0x33   51  3  
  199	:  1100_0000  0xC0  192    
  200	:  0000_1100  0x0C   12    
  201	:  0000_1010  0x0A   10    
  202	:  0111_0011  0x73  115  s  
  203	:  0111_0100  0x74  116  t  
  204	:  0111_0010  0x72  114  r  
  205	:  0110_1111  0x6F  111  o  
  206	:  0110_1110  0x6E  110  n  
  207	:  0110_0111  0x67  103  g  
  208	:  0110_1000  0x68  104  h  
  209	:  0110_1111  0x6F  111  o  
  210	:  0110_1100  0x6C  108  l  
  211	:  0110_0100  0x64  100  d  
  212	:  1100_0000  0xC0  192    
  213	:  0000_1100  0x0C   12    
  214	:  0000_0000  0x00    0    
  215	:  0000_0101  0x05    5    
  216	:  0000_0000  0x00    0    
  217	:  0000_0001  0x01    1    
  218	:  0000_0000  0x00    0    
  219	:  0000_0000  0x00    0    
  220	:  0010_1010  0x2A   42  *  
  221	:  0011_0000  0x30   48  0  
  222	:  0000_0000  0x00    0    
  223	:  0000_0010  0x02    2    
  224	:  1100_0000  0xC0  192    
  225	:  0110_0101  0x65  101  e  
  226	:  0000_0011  0x03    3    
  227	:  0110_0110  0x66  102  f  
  228	:  0111_0100  0x74  116  t  
  229	:  0111_0000  0x70  112  p  
  230	:  1100_0000  0xC0  192    
  231	:  0000_1100  0x0C   12    
  232	:  0000_0000  0x00    0    
  233	:  0000_0101  0x05    5    
  234	:  0000_0000  0x00    0    
  235	:  0000_0001  0x01    1    
  236	:  0000_0000  0x00    0    
  237	:  0000_0000  0x00    0    
  238	:  0010_1010  0x2A   42  *  
  239	:  0011_0000  0x30   48  0  
  240	:  0000_0000  0x00    0    
  241	:  0000_0010  0x02    2    
  242	:  1100_0000  0xC0  192    
  243	:  0110_0101  0x65  101  e  
  244	:  0000_0100  0x04    4    
  245	:  0110_1000  0x68  104  h  
  246	:  0110_1111  0x6F  111  o  
  247	:  0110_1101  0x6D  109  m  
  248	:  0110_0101  0x65  101  e  
  249	:  1100_0000  0xC0  192    
  250	:  0000_1100  0x0C   12    
  251	:  0000_0000  0x00    0    
  252	:  0000_0101  0x05    5    
  253	:  0000_0000  0x00    0    
  254	:  0000_0001  0x01    1    
  255	:  0000_0000  0x00    0    
  256	:  0000_0000  0x00    0    
  257	:  0010_1010  0x2A   42  *  
  258	:  0011_0000  0x30   48  0  
  259	:  0000_0000  0x00    0    
  260	:  0000_0010  0x02    2    
  261	:  1100_0000  0xC0  192    
  262	:  0110_0101  0x65  101  e  
  263	:  0000_0010  0x02    2    
  264	:  0110_1100  0x6C  108  l  
  265	:  0110_0010  0x62   98  b  
  266	:  1100_0000  0xC0  192    
  267	:  0000_1100  0x0C   12    
  268	:  0000_0000  0x00    0    
  269	:  0000_0101  0x05    5    
  270	:  0000_0000  0x00    0    
  271	:  0000_0001  0x01    1    
  272	:  0000_0000  0x00    0    
  273	:  0000_0000  0x00    0    
  274	:  0010_1010  0x2A   42  *  
  275	:  0011_0000  0x30   48  0  
  276	:  0000_0000  0x00    0    
  277	:  0000_1100  0x0C   12    
  278	:  0000_1001  0x09    9    
  279	:  0110_1100  0x6C  108  l  
  280	:  0110_1111  0x6F  111  o  
  281	:  0110_0011  0x63   99  c  
  282	:  0110_0001  0x61   97  a  
  283	:  0110_1100  0x6C  108  l  
  284	:  0110_1000  0x68  104  h  
  285	:  0110_1111  0x6F  111  o  
  286	:  0111_0011  0x73  115  s  
  287	:  0111_0100  0x74  116  t  
  288	:  1100_0000  0xC0  192    
  289	:  0000_1100  0x0C   12    
  290	:  1100_0001  0xC1  193    
  291	:  0001_0110  0x16   22    
  292	:  0000_0000  0x00    0    
  293	:  0000_0001  0x01    1    
  294	:  0000_0000  0x00    0    
  295	:  0000_0001  0x01    1    
  296	:  0000_0000  0x00    0    
  297	:  0000_0000  0x00    0    
  298	:  0010_1010  0x2A   42  *  
  299	:  0011_0000  0x30   48  0  
  300	:  0000_0000  0x00    0    
  301	:  0000_0100  0x04    4    
  302	:  0111_1111  0x7F  127    
  303	:  0000_0000  0x00    0    
  304	:  0000_0000  0x00    0    
  305	:  0000_0001  0x01    1    
  306	:  0000_1000  0x08    8    
  307	:  0110_1100  0x6C  108  l  
  308	:  0110_1111  0x6F  111  o  
  309	:  0110_1111  0x6F  111  o  
  310	:  0111_0000  0x70  112  p  
  311	:  0110_0010  0x62   98  b  
  312	:  0110_0001  0x61   97  a  
  313	:  0110_0011  0x63   99  c  
  314	:  0110_1011  0x6B  107  k  
  315	:  1100_0000  0xC0  192    
  316	:  0000_1100  0x0C   12    
  317	:  0000_0000  0x00    0    
  318	:  0000_0101  0x05    5    
  319	:  0000_0000  0x00    0    
  320	:  0000_0001  0x01    1    
  321	:  0000_0000  0x00    0    
  322	:  0000_0000  0x00    0    
  323	:  0010_1010  0x2A   42  *  
  324	:  0011_0000  0x30   48  0  
  325	:  0000_0000  0x00    0    
  326	:  0000_0010  0x02    2    
  327	:  1100_0001  0xC1  193    
  328	:  0001_0110  0x16   22    
  329	:  1100_0000  0xC0  192    
  330	:  1001_1011  0x9B  155    
  331	:  0000_0000  0x00    0    
  332	:  0000_0001  0x01    1    
  333	:  0000_0000  0x00    0    
  334	:  0000_0001  0x01    1    
  335	:  0000_0000  0x00    0    
  336	:  0000_0000  0x00    0    
  337	:  0010_1010  0x2A   42  *  
  338	:  0011_0000  0x30   48  0  
  339	:  0000_0000  0x00    0    
  340	:  0000_0100  0x04    4    
  341	:  0001_1100  0x1C   28    
  342	:  0000_0010  0x02    2    
  343	:  0100_0011  0x43   67  C  
  344	:  0011_0010  0x32   50  2  
  345	:  1100_0000  0xC0  192    
  346	:  1001_1011  0x9B  155    
  347	:  0000_0000  0x00    0    
  348	:  0000_1111  0x0F   15    
  349	:  0000_0000  0x00    0    
  350	:  0000_0001  0x01    1    
  351	:  0000_0000  0x00    0    
  352	:  0000_0000  0x00    0    
  353	:  0010_1010  0x2A   42  *  
  354	:  0011_0000  0x30   48  0  
  355	:  0000_0000  0x00    0    
  356	:  0000_0100  0x04    4    
  357	:  0000_0000  0x00    0    
  358	:  0000_1010  0x0A   10    
  359	:  1100_0000  0xC0  192    
  360	:  1001_1011  0x9B  155    
  361	:  1100_0000  0xC0  192    
  362	:  1001_1011  0x9B  155    
  363	:  0000_0000  0x00    0    
  364	:  0001_0000  0x10   16    
  365	:  0000_0000  0x00    0    
  366	:  0000_0001  0x01    1    
  367	:  0000_0000  0x00    0    
  368	:  0000_0000  0x00    0    
  369	:  0010_1010  0x2A   42  *  
  370	:  0011_0000  0x30   48  0  
  371	:  0000_0000  0x00    0    
  372	:  0000_1110  0x0E   14    
  373	:  0000_1101  0x0D   13    
  374	:  0111_0110  0x76  118  v  
  375	:  0011_1101  0x3D   61  =  
  376	:  0111_0011  0x73  115  s  
  377	:  0111_0000  0x70  112  p  
  378	:  0110_0110  0x66  102  f  
  379	:  0011_0001  0x31   49  1  
  380	:  0010_0000  0x20   32     
  381	:  0110_0001  0x61   97  a  
  382	:  0010_0000  0x20   32     
  383	:  0010_1101  0x2D   45  -  
  384	:  0110_0001  0x61   97  a  
  385	:  0110_1100  0x6C  108  l  
  386	:  0110_1100  0x6C  108  l  
  387	:  1100_0000  0xC0  192    
  388	:  0110_0101  0x65  101  e  
  389	:  0000_0000  0x00    0    
  390	:  0000_0001  0x01    1    
  391	:  0000_0000  0x00    0    
  392	:  0000_0001  0x01    1    
  393	:  0000_0000  0x00    0    
  394	:  0000_0000  0x00    0    
  395	:  0010_1010  0x2A   42  *  
  396	:  0011_0000  0x30   48  0  
  397	:  0000_0000  0x00    0    
  398	:  0000_0100  0x04    4    
  399	:  0011_0011  0x33   51  3  
  400	:  1110_0111  0xE7  231    
  401	:  0001_0010  0x12   18    
  402	:  1001_0010  0x92  146    
  403	:  1100_0000  0xC0  192    
  404	:  0110_0101  0x65  101  e  
  405	:  0000_0000  0x00    0    
  406	:  0000_1111  0x0F   15    
  407	:  0000_0000  0x00    0    
  408	:  0000_0001  0x01    1    
  409	:  0000_0000  0x00    0    
  410	:  0000_0000  0x00    0    
  411	:  0010_1010  0x2A   42  *  
  412	:  0011_0000  0x30   48  0  
  413	:  0000_0000  0x00    0    
  414	:  0000_0100  0x04    4    
  415	:  0000_0000  0x00    0    
  416	:  0000_1010  0x0A   10    
  417	:  1100_0000  0xC0  192    
  418	:  1001_1011  0x9B  155    
  419	:  1100_0000  0xC0  192    
  420	:  0110_0101  0x65  101  e  
  421	:  0000_0000  0x00    0    
  422	:  0001_0000  0x10   16    
  423	:  0000_0000  0x00    0    
  424	:  0000_0001  0x01    1    
  425	:  0000_0000  0x00    0    
  426	:  0000_0000  0x00    0    
  427	:  0010_1010  0x2A   42  *  
  428	:  0011_0000  0x30   48  0  
  429	:  0000_0000  0x00    0    
  430	:  0000_1110  0x0E   14    
  431	:  0000_1101  0x0D   13    
  432	:  0111_0110  0x76  118  v  
  433	:  0011_1101  0x3D   61  =  
  434	:  0111_0011  0x73  115  s  
  435	:  0111_0000  0x70  112  p  
  436	:  0110_0110  0x66  102  f  
  437	:  0011_0001  0x31   49  1  
  438	:  0010_0000  0x20   32     
  439	:  0110_0001  0x61   97  a  
  440	:  0010_0000  0x20   32     
  441	:  0010_1101  0x2D   45  -  
  442	:  0110_0001  0x61   97  a  
  443	:  0110_1100  0x6C  108  l  
  444	:  0110_1100  0x6C  108  l  
  445	:  1100_0000  0xC0  192    
  446	:  1010_1111  0xAF  175    
  447	:  0000_0000  0x00    0    
  448	:  0000_0001  0x01    1    
  449	:  0000_0000  0x00    0    
  450	:  0000_0001  0x01    1    
  451	:  0000_0000  0x00    0    
  452	:  0000_0000  0x00    0    
  453	:  0010_1010  0x2A   42  *  
  454	:  0011_0000  0x30   48  0  
  455	:  0000_0000  0x00    0    
  456	:  0000_0100  0x04    4    
  457	:  1101_0011  0xD3  211    
  458	:  1110_0111  0xE7  231    
  459	:  1001_0001  0x91  145    
  460	:  1110_0001  0xE1  225    
  461	:  1100_0000  0xC0  192    
  462	:  1010_1111  0xAF  175    
  463	:  0000_0000  0x00    0    
  464	:  0000_1111  0x0F   15    
  465	:  0000_0000  0x00    0    
  466	:  0000_0001  0x01    1    
  467	:  0000_0000  0x00    0    
  468	:  0000_0000  0x00    0    
  469	:  0010_1010  0x2A   42  *  
  470	:  0011_0000  0x30   48  0  
  471	:  0000_0000  0x00    0    
  472	:  0000_0100  0x04    4    
  473	:  0000_0000  0x00    0    
  474	:  0000_1010  0x0A   10    
  475	:  1100_0000  0xC0  192    
  476	:  1010_1111  0xAF  175    
  477	:  1100_0000  0xC0  192    
  478	:  1010_1111  0xAF  175    
  479	:  0000_0000  0x00    0    
  480	:  0001_0000  0x10   16    
  481	:  0000_0000  0x00    0    
  482	:  0000_0001  0x01    1    
  483	:  0000_0000  0x00    0    
  484	:  0000_0000  0x00    0    
  485	:  0010_1010  0x2A   42  *  
  486	:  0011_0000  0x30   48  0  
  487	:  0000_0000  0x00    0    
  488	:  0000_1110  0x0E   14    
  489	:  0000_1101  0x0D   13    
  490	:  0111_0110  0x76  118  v  
  491	:  0011_1101  0x3D   61  =  
  492	:  0111_0011  0x73  115  s  
  493	:  0111_0000  0x70  112  p  
  494	:  0110_0110  0x66  102  f  
  495	:  0011_0001  0x31   49  1  
  496	:  0010_0000  0x20   32     
  497	:  0110_0001  0x61   97  a  
  498	:  0010_0000  0x20   32     
  499	:  0010_1101  0x2D   45  -  
  500	:  0110_0001  0x61   97  a  
  501	:  0110_1100  0x6C  108  l  
  502	:  0110_1100  0x6C  108  l  
  503	:  0000_0101  0x05    5    
  504	:  0110_1101  0x6D  109  m  
  505	:  0110_0001  0x61   97  a  
  506	:  0110_1001  0x69  105  i  
  507	:  0110_1100  0x6C  108  l  
  508	:  0011_0100  0x34   52  4  
  509	:  1100_0000  0xC0  192    
  510	:  0000_1100  0x0C   12    
  511	:  0000_0000  0x00    0    
  512	:  0000_0001  0x01    1    
  513	:  0000_0000  0x00    0    
  514	:  0000_0001  0x01    1    
  515	:  0000_0000  0x00    0    
  516	:  0000_0000  0x00    0    
  517	:  0010_1010  0x2A   42  *  
  518	:  0011_0000  0x30   48  0  
  519	:  0000_0000  0x00    0    
  520	:  0000_0100  0x04    4    
  521	:  0001_1100  0x1C   28    
  522	:  0000_0010  0x02    2    
  523	:  0100_0011  0x43   67  C  
  524	:  0011_0011  0x33   51  3  
  525	:  1100_0001  0xC1  193    
  526	:  1111_0111  0xF7  247    
  527	:  0000_0000  0x00    0    
  528	:  0000_1111  0x0F   15    
  529	:  0000_0000  0x00    0    
  530	:  0000_0001  0x01    1    
  531	:  0000_0000  0x00    0    
  532	:  0000_0000  0x00    0    
  533	:  0010_1010  0x2A   42  *  
  534	:  0011_0000  0x30   48  0  
  535	:  0000_0000  0x00    0    
  536	:  0000_0100  0x04    4    
  537	:  0000_0000  0x00    0    
  538	:  0000_1010  0x0A   10    
  539	:  1100_0001  0xC1  193    
  540	:  1111_0111  0xF7  247    
  541	:  1100_0001  0xC1  193    
  542	:  1111_0111  0xF7  247    
  543	:  0000_0000  0x00    0    
  544	:  0001_0000  0x10   16    
  545	:  0000_0000  0x00    0    
  546	:  0000_0001  0x01    1    
  547	:  0000_0000  0x00    0    
  548	:  0000_0000  0x00    0    
  549	:  0010_1010  0x2A   42  *  
  550	:  0011_0000  0x30   48  0  
  551	:  0000_0000  0x00    0    
  552	:  0000_1110  0x0E   14    
  553	:  0000_1101  0x0D   13    
  554	:  0111_0110  0x76  118  v  
  555	:  0011_1101  0x3D   61  =  
  556	:  0111_0011  0x73  115  s  
  557	:  0111_0000  0x70  112  p  
  558	:  0110_0110  0x66  102  f  
  559	:  0011_0001  0x31   49  1  
  560	:  0010_0000  0x20   32     
  561	:  0110_0001  0x61   97  a  
  562	:  0010_0000  0x20   32     
  563	:  0010_1101  0x2D   45  -  
  564	:  0110_0001  0x61   97  a  
  565	:  0110_1100  0x6C  108  l  
  566	:  0110_1100  0x6C  108  l  
  567	:  0000_0101  0x05    5    
  568	:  0110_1101  0x6D  109  m  
  569	:  0110_0001  0x61   97  a  
  570	:  0110_1001  0x69  105  i  
  571	:  0110_1100  0x6C  108  l  
  572	:  0011_0001  0x31   49  1  
  573	:  1100_0000  0xC0  192    
  574	:  0000_1100  0x0C   12    
  575	:  0000_0000  0x00    0    
  576	:  0000_0001  0x01    1    
  577	:  0000_0000  0x00    0    
  578	:  0000_0001  0x01    1    
  579	:  0000_0000  0x00    0    
  580	:  0000_0000  0x00    0    
  581	:  0010_1010  0x2A   42  *  
  582	:  0011_0000  0x30   48  0  
  583	:  0000_0000  0x00    0    
  584	:  0000_0100  0x04    4    
  585	:  1101_0011  0xD3  211    
  586	:  1110_0111  0xE7  231    
  587	:  1001_0001  0x91  145    
  588	:  1110_0010  0xE2  226    
  589	:  1100_0010  0xC2  194    
  590	:  0011_0111  0x37   55  7  
  591	:  0000_0000  0x00    0    
  592	:  0001_0000  0x10   16    
  593	:  0000_0000  0x00    0    
  594	:  0000_0001  0x01    1    
  595	:  0000_0000  0x00    0    
  596	:  0000_0000  0x00    0    
  597	:  0010_1010  0x2A   42  *  
  598	:  0011_0000  0x30   48  0  
  599	:  0000_0000  0x00    0    
  600	:  0000_1110  0x0E   14    
  601	:  0000_1101  0x0D   13    
  602	:  0111_0110  0x76  118  v  
  603	:  0011_1101  0x3D   61  =  
  604	:  0111_0011  0x73  115  s  
  605	:  0111_0000  0x70  112  p  
  606	:  0110_0110  0x66  102  f  
  607	:  0011_0001  0x31   49  1  
  608	:  0010_0000  0x20   32     
  609	:  0110_0001  0x61   97  a  
  610	:  0010_0000  0x20   32     
  611	:  0010_1101  0x2D   45  -  
  612	:  0110_0001  0x61   97  a  
  613	:  0110_1100  0x6C  108  l  
  614	:  0110_1100  0x6C  108  l  
  615	:  1100_0010  0xC2  194    
  616	:  0011_0111  0x37   55  7  
  617	:  0000_0000  0x00    0    
  618	:  0000_0001  0x01    1    
  619	:  0000_0000  0x00    0    
  620	:  0000_0001  0x01    1    
  621	:  0000_0000  0x00    0    
  622	:  0000_0000  0x00    0    
  623	:  0010_1010  0x2A   42  *  
  624	:  0011_0000  0x30   48  0  
  625	:  0000_0000  0x00    0    
  626	:  0000_0100  0x04    4    
  627	:  0001_1100  0x1C   28    
  628	:  0000_0010  0x02    2    
  629	:  0100_0011  0x43   67  C  
  630	:  0011_1000  0x38   56  8  
  631	:  1100_0010  0xC2  194    
  632	:  0011_0111  0x37   55  7  
  633	:  0000_0000  0x00    0    
  634	:  0001_0000  0x10   16    
  635	:  0000_0000  0x00    0    
  636	:  0000_0001  0x01    1    
  637	:  0000_0000  0x00    0    
  638	:  0000_0000  0x00    0    
  639	:  0010_1010  0x2A   42  *  
  640	:  0011_0000  0x30   48  0  
  641	:  0000_0000  0x00    0    
  642	:  0000_1110  0x0E   14    
  643	:  0000_1101  0x0D   13    
  644	:  0111_0110  0x76  118  v  
  645	:  0011_1101  0x3D   61  =  
  646	:  0111_0011  0x73  115  s  
  647	:  0111_0000  0x70  112  p  
  648	:  0110_0110  0x66  102  f  
  649	:  0011_0001  0x31   49  1  
  650	:  0010_0000  0x20   32     
  651	:  0110_0001  0x61   97  a  
  652	:  0010_0000  0x20   32     
  653	:  0010_1101  0x2D   45  -  
  654	:  0110_0001  0x61   97  a  
  655	:  0110_1100  0x6C  108  l  
  656	:  0110_1100  0x6C  108  l  
  657	:  1100_0000  0xC0  192    
  658	:  1100_0011  0xC3  195    
  659	:  0000_0000  0x00    0    
  660	:  0000_0001  0x01    1    
  661	:  0000_0000  0x00    0    
  662	:  0000_0001  0x01    1    
  663	:  0000_0000  0x00    0    
  664	:  0000_0000  0x00    0    
  665	:  0010_1010  0x2A   42  *  
  666	:  0011_0000  0x30   48  0  
  667	:  0000_0000  0x00    0    
  668	:  0000_0100  0x04    4    
  669	:  0001_1100  0x1C   28    
  670	:  0000_0010  0x02    2    
  671	:  0100_0011  0x43   67  C  
  672	:  0011_0100  0x34   52  4  
  673	:  1100_0000  0xC0  192    
  674	:  1100_0011  0xC3  195    
  675	:  0000_0000  0x00    0    
  676	:  0001_0000  0x10   16    
  677	:  0000_0000  0x00    0    
  678	:  0000_0001  0x01    1    
  679	:  0000_0000  0x00    0    
  680	:  0000_0000  0x00    0    
  681	:  0010_1010  0x2A   42  *  
  682	:  0011_0000  0x30   48  0  
  683	:  0000_0000  0x00    0    
  684	:  0000_1110  0x0E   14    
  685	:  0000_1101  0x0D   13    
  686	:  0111_0110  0x76  118  v  
  687	:  0011_1101  0x3D   61  =  
  688	:  0111_0011  0x73  115  s  
  689	:  0111_0000  0x70  112  p  
  690	:  0110_0110  0x66  102  f  
  691	:  0011_0001  0x31   49  1  
  692	:  0010_0000  0x20   32     
  693	:  0110_0001  0x61   97  a  
  694	:  0010_0000  0x20   32     
  695	:  0010_1101  0x2D   45  -  
  696	:  0110_0001  0x61   97  a  
  697	:  0110_1100  0x6C  108  l  
  698	:  0110_1100  0x6C  108  l  
  699	:  0000_0010  0x02    2    
  700	:  0111_0011  0x73  115  s  
  701	:  0111_0100  0x74  116  t  
  702	:  1100_0000  0xC0  192    
  703	:  0000_1100  0x0C   12    
  704	:  0000_0000  0x00    0    
  705	:  0000_1111  0x0F   15    
  706	:  0000_0000  0x00    0    
  707	:  0000_0001  0x01    1    
  708	:  0000_0000  0x00    0    
  709	:  0000_0000  0x00    0    
  710	:  0010_1010  0x2A   42  *  
  711	:  0011_0000  0x30   48  0  
  712	:  0000_0000  0x00    0    
  713	:  0000_0100  0x04    4    
  714	:  0000_0000  0x00    0    
  715	:  0000_1010  0x0A   10    
  716	:  1100_0010  0xC2  194    
  717	:  0011_0111  0x37   55  7  
  718	:  1100_0010  0xC2  194    
  719	:  1011_1011  0xBB  187    
  720	:  0000_0000  0x00    0    
  721	:  0000_1111  0x0F   15    
  722	:  0000_0000  0x00    0    
  723	:  0000_0001  0x01    1    
  724	:  0000_0000  0x00    0    
  725	:  0000_0000  0x00    0    
  726	:  0010_1010  0x2A   42  *  
  727	:  0011_0000  0x30   48  0  
  728	:  0000_0000  0x00    0    
  729	:  0000_0100  0x04    4    
  730	:  0000_0000  0x00    0    
  731	:  0110_0100  0x64  100  d  
  732	:  1100_0000  0xC0  192    
  733	:  1100_0011  0xC3  195    
  734	:  0000_0011  0x03    3    
  735	:  0110_0100  0x64  100  d  
  736	:  0110_1110  0x6E  110  n  
  737	:  0111_0011  0x73  115  s  
  738	:  1100_0000  0xC0  192    
  739	:  0000_1100  0x0C   12    
  740	:  0000_0000  0x00    0    
  741	:  0000_0001  0x01    1    
  742	:  0000_0000  0x00    0    
  743	:  0000_0001  0x01    1    
  744	:  0000_0000  0x00    0    
  745	:  0000_0000  0x00    0    
  746	:  0010_1010  0x2A   42  *  
  747	:  0011_0000  0x30   48  0  
  748	:  0000_0000  0x00    0    
  749	:  0000_0100  0x04    4    
  750	:  0001_1100  0x1C   28    
  751	:  0000_0010  0x02    2    
  752	:  0100_0011  0x43   67  C  
  753	:  0011_0010  0x32   50  2  
  754	:  1100_0000  0xC0  192    
  755	:  0111_0111  0x77  119  w  
  756	:  0000_0000  0x00    0    
  757	:  0000_0001  0x01    1    
  758	:  0000_0000  0x00    0    
  759	:  0000_0001  0x01    1    
  760	:  0000_0000  0x00    0    
  761	:  0000_0000  0x00    0    
  762	:  0010_1010  0x2A   42  *  
  763	:  0011_0000  0x30   48  0  
  764	:  0000_0000  0x00    0    
  765	:  0000_0100  0x04    4    
  766	:  1101_0011  0xD3  211    
  767	:  1110_0111  0xE7  231    
  768	:  1001_0001  0x91  145    
  769	:  1110_0001  0xE1  225    
  770	:  1100_0000  0xC0  192    
  771	:  0111_0111  0x77  119  w  
  772	:  0000_0000  0x00    0    
  773	:  0000_1111  0x0F   15    
  774	:  0000_0000  0x00    0    
  775	:  0000_0001  0x01    1    
  776	:  0000_0000  0x00    0    
  777	:  0000_0000  0x00    0    
  778	:  0010_1010  0x2A   42  *  
  779	:  0011_0000  0x30   48  0  
  780	:  0000_0000  0x00    0    
  781	:  0000_0100  0x04    4    
  782	:  0000_0000  0x00    0    
  783	:  0000_1010  0x0A   10    
  784	:  1100_0000  0xC0  192    
  785	:  1010_1111  0xAF  175    
  786	:  1100_0000  0xC0  192    
  787	:  0111_0111  0x77  119  w  
  788	:  0000_0000  0x00    0    
  789	:  0001_0000  0x10   16    
  790	:  0000_0000  0x00    0    
  791	:  0000_0001  0x01    1    
  792	:  0000_0000  0x00    0    
  793	:  0000_0000  0x00    0    
  794	:  0010_1010  0x2A   42  *  
  795	:  0011_0000  0x30   48  0  
  796	:  0000_0000  0x00    0    
  797	:  0000_1110  0x0E   14    
  798	:  0000_1101  0x0D   13    
  799	:  0111_0110  0x76  118  v  
  800	:  0011_1101  0x3D   61  =  
  801	:  0111_0011  0x73  115  s  
  802	:  0111_0000  0x70  112  p  
  803	:  0110_0110  0x66  102  f  
  804	:  0011_0001  0x31   49  1  
  805	:  0010_0000  0x20   32     
  806	:  0110_0001  0x61   97  a  
  807	:  0010_0000  0x20   32     
  808	:  0010_1101  0x2D   45  -  
  809	:  0110_0001  0x61   97  a  
  810	:  0110_1100  0x6C  108  l  
  811	:  0110_1100  0x6C  108  l  
  812	:  0000_0100  0x04    4    
  813	:  0111_0000  0x70  112  p  
  814	:  0110_1111  0x6F  111  o  
  815	:  0111_0000  0x70  112  p  
  816	:  0011_0011  0x33   51  3  
  817	:  1100_0000  0xC0  192    
  818	:  0000_1100  0x0C   12    
  819	:  0000_0000  0x00    0    
  820	:  0000_0101  0x05    5    
  821	:  0000_0000  0x00    0    
  822	:  0000_0001  0x01    1    
  823	:  0000_0000  0x00    0    
  824	:  0000_0000  0x00    0    
  825	:  0010_1010  0x2A   42  *  
  826	:  0011_0000  0x30   48  0  
  827	:  0000_0000  0x00    0    
  828	:  0000_0010  0x02    2    
  829	:  1100_0001  0xC1  193    
  830	:  1111_0111  0xF7  247    
  831	:  0000_0110  0x06    6    
  832	:  0110_0001  0x61   97  a  
  833	:  0110_1101  0x6D  109  m  
  834	:  0110_0010  0x62   98  b  
  835	:  0110_1100  0x6C  108  l  
  836	:  0110_1001  0x69  105  i  
  837	:  0110_1110  0x6E  110  n  
  838	:  1100_0000  0xC0  192    
  839	:  0000_1100  0x0C   12    
  840	:  0000_0000  0x00    0    
  841	:  0000_0101  0x05    5    
  842	:  0000_0000  0x00    0    
  843	:  0000_0001  0x01    1    
  844	:  0000_0000  0x00    0    
  845	:  0000_0000  0x00    0    
  846	:  0010_1010  0x2A   42  *  
  847	:  0011_0000  0x30   48  0  
  848	:  0000_0000  0x00    0    
  849	:  0000_0010  0x02    2    
  850	:  1100_0000  0xC0  192    
  851	:  0010_1111  0x2F   47  /  
  852	:  0000_1010  0x0A   10    
  853	:  0110_1100  0x6C  108  l  
  854	:  0110_1001  0x69  105  i  
  855	:  0111_0100  0x74  116  t  
  856	:  0111_0100  0x74  116  t  
  857	:  0110_1100  0x6C  108  l  
  858	:  0110_0101  0x65  101  e  
  859	:  0110_0110  0x66  102  f  
  860	:  0110_1001  0x69  105  i  
  861	:  0111_0011  0x73  115  s  
  862	:  0110_1000  0x68  104  h  
  863	:  1100_0000  0xC0  192    
  864	:  0000_1100  0x0C   12    
  865	:  0000_0000  0x00    0    
  866	:  0000_0001  0x01    1    
  867	:  0000_0000  0x00    0    
  868	:  0000_0001  0x01    1    
  869	:  0000_0000  0x00    0    
  870	:  0000_0000  0x00    0    
  871	:  0010_1010  0x2A   42  *  
  872	:  0011_0000  0x30   48  0  
  873	:  0000_0000  0x00    0    
  874	:  0000_0100  0x04    4    
  875	:  0001_1100  0x1C   28    
  876	:  0000_0010  0x02    2    
  877	:  0100_0011  0x43   67  C  
  878	:  0011_0011  0x33   51  3  
  879	:  1100_0011  0xC3  195    
  880	:  0101_0100  0x54   84  T  
  881	:  0000_0000  0x00    0    
  882	:  0000_1111  0x0F   15    
  883	:  0000_0000  0x00    0    
  884	:  0000_0001  0x01    1    
  885	:  0000_0000  0x00    0    
  886	:  0000_0000  0x00    0    
  887	:  0010_1010  0x2A   42  *  
  888	:  0011_0000  0x30   48  0  
  889	:  0000_0000  0x00    0    
  890	:  0000_0100  0x04    4    
  891	:  0000_0000  0x00    0    
  892	:  0000_1010  0x0A   10    
  893	:  1100_0001  0xC1  193    
  894	:  1111_0111  0xF7  247    
  895	:  1100_0011  0xC3  195    
  896	:  0101_0100  0x54   84  T  
  897	:  0000_0000  0x00    0    
  898	:  0001_0000  0x10   16    
  899	:  0000_0000  0x00    0    
  900	:  0000_0001  0x01    1    
  901	:  0000_0000  0x00    0    
  902	:  0000_0000  0x00    0    
  903	:  0010_1010  0x2A   42  *  
  904	:  0011_0000  0x30   48  0  
  905	:  0000_0000  0x00    0    
  906	:  0000_1110  0x0E   14    
  907	:  0000_1101  0x0D   13    
  908	:  0111_0110  0x76  118  v  
  909	:  0011_1101  0x3D   61  =  
  910	:  0111_0011  0x73  115  s  
  911	:  0111_0000  0x70  112  p  
  912	:  0110_0110  0x66  102  f  
  913	:  0011_0001  0x31   49  1  
  914	:  0010_0000  0x20   32     
  915	:  0110_0001  0x61   97  a  
  916	:  0010_0000  0x20   32     
  917	:  0010_1101  0x2D   45  -  
  918	:  0110_0001  0x61   97  a  
  919	:  0110_1100  0x6C  108  l  
  920	:  0110_1100  0x6C  108  l  
  921	:  0000_0100  0x04    4    
  922	:  0110_1100  0x6C  108  l  
  923	:  0110_1111  0x6F  111  o  
  924	:  0110_1111  0x6F  111  o  
  925	:  0110_1011  0x6B  107  k  
  926	:  1100_0000  0xC0  192    
  927	:  0000_1100  0x0C   12    
  928	:  0000_0000  0x00    0    
  929	:  0000_0101  0x05    5    
  930	:  0000_0000  0x00    0    
  931	:  0000_0001  0x01    1    
  932	:  0000_0000  0x00    0    
  933	:  0000_0000  0x00    0    
  934	:  0010_1010  0x2A   42  *  
  935	:  0011_0000  0x30   48  0  
  936	:  0000_0000  0x00    0    
  937	:  0000_0010  0x02    2    
  938	:  1100_0000  0xC0  192    
  939	:  0010_1111  0x2F   47  /  
  940	:  0000_0011  0x03    3    
  941	:  0111_0011  0x73  115  s  
  942	:  0110_0101  0x65  101  e  
  943	:  0110_0101  0x65  101  e  
  944	:  1100_0000  0xC0  192    
  945	:  0000_1100  0x0C   12    
  946	:  0000_0000  0x00    0    
  947	:  0000_0101  0x05    5    
  948	:  0000_0000  0x00    0    
  949	:  0000_0001  0x01    1    
  950	:  0000_0000  0x00    0    
  951	:  0000_0000  0x00    0    
  952	:  0010_1010  0x2A   42  *  
  953	:  0011_0000  0x30   48  0  
  954	:  0000_0000  0x00    0    
  955	:  0000_1001  0x09    9    
  956	:  0000_0110  0x06    6    
  957	:  0110_1100  0x6C  108  l  
  958	:  0110_1111  0x6F  111  o  
  959	:  0110_1111  0x6F  111  o  
  960	:  0110_1011  0x6B  107  k  
  961	:  0111_0101  0x75  117  u  
  962	:  0111_0000  0x70  112  p  
  963	:  1100_0000  0xC0  192    
  964	:  0010_1111  0x2F   47  /  
  965	:  0000_0011  0x03    3    
  966	:  0111_0111  0x77  119  w  
  967	:  0111_0111  0x77  119  w  
  968	:  0111_0111  0x77  119  w  
  969	:  1100_0011  0xC3  195    
  970	:  1010_1100  0xAC  172    
  971	:  0000_0000  0x00    0    
  972	:  0000_0101  0x05    5    
  973	:  0000_0000  0x00    0    
  974	:  0000_0001  0x01    1    
  975	:  0000_0000  0x00    0    
  976	:  0000_0000  0x00    0    
  977	:  0010_1010  0x2A   42  *  
  978	:  0011_0000  0x30   48  0  
  979	:  0000_0000  0x00    0    
  980	:  0000_0010  0x02    2    
  981	:  1100_0011  0xC3  195    
  982	:  1011_1100  0xBC  188    
  983	:  0000_0100  0x04    4    
  984	:  0110_0010  0x62   98  b  
  985	:  0110_1111  0x6F  111  o  
  986	:  0111_0010  0x72  114  r  
  987	:  0110_0111  0x67  103  g  
  988	:  1100_0000  0xC0  192    
  989	:  0000_1100  0x0C   12    
  990	:  0000_0000  0x00    0    
  991	:  0000_0001  0x01    1    
  992	:  0000_0000  0x00    0    
  993	:  0000_0001  0x01    1    
  994	:  0000_0000  0x00    0    
  995	:  0000_0000  0x00    0    
  996	:  0010_1010  0x2A   42  *  
  997	:  0011_0000  0x30   48  0  
  998	:  0000_0000  0x00    0    
  999	:  0000_0100  0x04    4    
  1000	:  1101_0011  0xD3  211    
  1001	:  1110_0111  0xE7  231    
  1002	:  1001_0001  0x91  145    
  1003	:  1110_0110  0xE6  230    
  1004	:  1100_0011  0xC3  195    
  1005	:  1101_0111  0xD7  215    
  1006	:  0000_0000  0x00    0    
  1007	:  0000_1111  0x0F   15    
  1008	:  0000_0000  0x00    0    
  1009	:  0000_0001  0x01    1    
  1010	:  0000_0000  0x00    0    
  1011	:  0000_0000  0x00    0    
  1012	:  0010_1010  0x2A   42  *  
  1013	:  0011_0000  0x30   48  0  
  1014	:  0000_0000  0x00    0    
  1015	:  0000_0100  0x04    4    
  1016	:  0000_0000  0x00    0    
  1017	:  0000_1010  0x0A   10    
  1018	:  1100_0000  0xC0  192    
  1019	:  1001_1011  0x9B  155    
  1020	:  1100_0011  0xC3  195    
  1021	:  1101_0111  0xD7  215    
  1022	:  0000_0000  0x00    0    
  1023	:  0000_1111  0x0F   15    
  1024	:  0000_0000  0x00    0    
  1025	:  0000_0001  0x01    1    
  1026	:  0000_0000  0x00    0    
  1027	:  0000_0000  0x00    0    
  1028	:  0010_1010  0x2A   42  *  
  1029	:  0011_0000  0x30   48  0  
  1030	:  0000_0000  0x00    0    
  1031	:  0000_0100  0x04    4    
  1032	:  0000_0000  0x00    0    
  1033	:  0001_0100  0x14   20    
  1034	:  1100_0000  0xC0  192    
  1035	:  1010_1111  0xAF  175    
  1036	:  0000_0100  0x04    4    
  1037	:  0111_0011  0x73  115  s  
  1038	:  0110_1101  0x6D  109  m  
  1039	:  0111_0100  0x74  116  t  
  1040	:  0111_0000  0x70  112  p  
  1041	:  1100_0000  0xC0  192    
  1042	:  0000_1100  0x0C   12    
  1043	:  0000_0000  0x00    0    
  1044	:  0000_0101  0x05    5    
  1045	:  0000_0000  0x00    0    
  1046	:  0000_0001  0x01    1    
  1047	:  0000_0000  0x00    0    
  1048	:  0000_0000  0x00    0    
  1049	:  0010_1010  0x2A   42  *  
  1050	:  0011_0000  0x30   48  0  
  1051	:  0000_0000  0x00    0    
  1052	:  0000_0010  0x02    2    
  1053	:  1100_0001  0xC1  193    
  1054	:  1111_0111  0xF7  247    
  1055	:  0000_1000  0x08    8    
  1056	:  0111_0100  0x74  116  t  
  1057	:  0110_1001  0x69  105  i  
  1058	:  0110_1101  0x6D  109  m  
  1059	:  0110_0101  0x65  101  e  
  1060	:  0110_1000  0x68  104  h  
  1061	:  0110_1111  0x6F  111  o  
  1062	:  0111_0011  0x73  115  s  
  1063	:  0111_0100  0x74  116  t  
  1064	:  1100_0000  0xC0  192    
  1065	:  0000_1100  0x0C   12    
  1066	:  0000_0000  0x00    0    
  1067	:  0000_0101  0x05    5    
  1068	:  0000_0000  0x00    0    
  1069	:  0000_0001  0x01    1    
  1070	:  0000_0000  0x00    0    
  1071	:  0000_0000  0x00    0    
  1072	:  0010_1010  0x2A   42  *  
  1073	:  0011_0000  0x30   48  0  
  1074	:  0000_0000  0x00    0    
  1075	:  0000_0010  0x02    2    
  1076	:  1100_0000  0xC0  192    
  1077	:  0111_0111  0x77  119  w  
  1078	:  0000_1000  0x08    8    
  1079	:  0110_1101  0x6D  109  m  
  1080	:  0110_1111  0x6F  111  o  
  1081	:  0111_0101  0x75  117  u  
  1082	:  0110_1110  0x6E  110  n  
  1083	:  0111_0100  0x74  116  t  
  1084	:  0110_0001  0x61   97  a  
  1085	:  0110_1001  0x69  105  i  
  1086	:  0110_1110  0x6E  110  n  
  1087	:  1100_0000  0xC0  192    
  1088	:  0000_1100  0x0C   12    
  1089	:  0000_0000  0x00    0    
  1090	:  0000_1111  0x0F   15    
  1091	:  0000_0000  0x00    0    
  1092	:  0000_0001  0x01    1    
  1093	:  0000_0000  0x00    0    
  1094	:  0000_0000  0x00    0    
  1095	:  0010_1010  0x2A   42  *  
  1096	:  0011_0000  0x30   48  0  
  1097	:  0000_0000  0x00    0    
  1098	:  0001_0011  0x13   19    
  1099	:  0000_0000  0x00    0    
  1100	:  0000_1010  0x0A   10    
  1101	:  0000_0101  0x05    5    
  1102	:  0110_1101  0x6D  109  m  
  1103	:  0110_0001  0x61   97  a  
  1104	:  0110_1001  0x69  105  i  
  1105	:  0110_1100  0x6C  108  l  
  1106	:  0011_0001  0x31   49  1  
  1107	:  0000_1000  0x08    8    
  1108	:  0110_1101  0x6D  109  m  
  1109	:  0111_1000  0x78  120  x  
  1110	:  0110_1101  0x6D  109  m  
  1111	:  0110_0001  0x61   97  a  
  1112	:  0110_1001  0x69  105  i  
  1113	:  0110_1100  0x6C  108  l  
  1114	:  0110_0101  0x65  101  e  
  1115	:  0111_0010  0x72  114  r  
  1116	:  1100_0000  0xC0  192    
  1117	:  0001_0100  0x14   20    
  1118	:  0000_0011  0x03    3    
  1119	:  0111_0111  0x77  119  w  
  1120	:  0111_0111  0x77  119  w  
  1121	:  0111_0111  0x77  119  w  
  1122	:  1100_0000  0xC0  192    
  1123	:  0000_1100  0x0C   12    
  1124	:  0000_0000  0x00    0    
  1125	:  0000_0101  0x05    5    
  1126	:  0000_0000  0x00    0    
  1127	:  0000_0001  0x01    1    
  1128	:  0000_0000  0x00    0    
  1129	:  0000_0000  0x00    0    
  1130	:  0010_1010  0x2A   42  *  
  1131	:  0011_0000  0x30   48  0  
  1132	:  0000_0000  0x00    0    
  1133	:  0000_0010  0x02    2    
  1134	:  1100_0000  0xC0  192    
  1135	:  0000_1100  0x0C   12    
  1136	:  0000_0111  0x07    7    
  1137	:  0111_0000  0x70  112  p  
  1138	:  0110_1111  0x6F  111  o  
  1139	:  0110_1100  0x6C  108  l  
  1140	:  0110_0101  0x65  101  e  
  1141	:  0110_0011  0x63   99  c  
  1142	:  0110_0001  0x61   97  a  
  1143	:  0111_0100  0x74  116  t  
  1144	:  1100_0000  0xC0  192    
  1145	:  0000_1100  0x0C   12    
  1146	:  0000_0000  0x00    0    
  1147	:  0000_1101  0x0D   13    
  1148	:  0000_0000  0x00    0    
  1149	:  0000_0001  0x01    1    
  1150	:  0000_0000  0x00    0    
  1151	:  0000_0000  0x00    0    
  1152	:  0010_1010  0x2A   42  *  
  1153	:  0011_0000  0x30   48  0  
  1154	:  0000_0000  0x00    0    
  1155	:  0001_0110  0x16   22    
  1156	:  0000_1000  0x08    8    
  1157	:  0111_0010  0x72  114  r  
  1158	:  0110_0101  0x65  101  e  
  1159	:  0111_0011  0x73  115  s  
  1160	:  0110_0101  0x65  101  e  
  1161	:  0111_0010  0x72  114  r  
  1162	:  0111_0110  0x76  118  v  
  1163	:  0110_0101  0x65  101  e  
  1164	:  0110_0100  0x64  100  d  
  1165	:  0000_1100  0x0C   12    
  1166	:  0110_0110  0x66  102  f  
  1167	:  0110_1111  0x6F  111  o  
  1168	:  0111_0010  0x72  114  r  
  1169	:  0010_0000  0x20   32     
  1170	:  0111_0000  0x70  112  p  
  1171	:  0110_1111  0x6F  111  o  
  1172	:  0110_1100  0x6C  108  l  
  1173	:  0110_1001  0x69  105  i  
  1174	:  0111_0100  0x74  116  t  
  1175	:  0110_1001  0x69  105  i  
  1176	:  0110_0011  0x63   99  c  
  1177	:  0111_0011  0x73  115  s  
  1178	:  1100_0000  0xC0  192    
  1179	:  0000_1100  0x0C   12    
  1180	:  0000_0000  0x00    0    
  1181	:  0000_0110  0x06    6    
  1182	:  0000_0000  0x00    0    
  1183	:  0000_0001  0x01    1    
  1184	:  0000_0000  0x00    0    
  1185	:  0000_0000  0x00    0    
  1186	:  0010_1010  0x2A   42  *  
  1187	:  0011_0000  0x30   48  0  
  1188	:  0000_0000  0x00    0    
  1189	:  0001_1000  0x18   24    
  1190	:  1100_0000  0xC0  192    
  1191	:  0010_1001  0x29   41  )  
  1192	:  1100_0000  0xC0  192    
  1193	:  0011_1100  0x3C   60  <  
  1194	:  0111_0111  0x77  119  w  
  1195	:  1101_1110  0xDE  222    
  1196	:  1111_0100  0xF4  244    
  1197	:  1111_0110  0xF6  246    
  1198	:  0000_0000  0x00    0    
  1199	:  0000_0000  0x00    0    
  1200	:  1010_1000  0xA8  168    
  1201	:  1100_0000  0xC0  192    
  1202	:  0000_0000  0x00    0    
  1203	:  0000_0000  0x00    0    
  1204	:  0000_1110  0x0E   14    
  1205	:  0001_0000  0x10   16    
  1206	:  0000_0000  0x00    0    
  1207	:  0000_0011  0x03    3    
  1208	:  1111_0100  0xF4  244    
  1209	:  1000_0000  0x80  128    
  1210	:  0000_0000  0x00    0    
  1211	:  0000_0000  0x00    0    
  1212	:  0010_1010  0x2A   42  *  
  1213	:  0011_0000  0x30   48  0  |;

$rp = $dig->_proc_body($ap,$qp,$get,$put,\$soacount);
#print_head($rp);
#print "\n";
#print_head($qp);
#print_buf($rp);
chk_exp($rp,\$ans2);

## test 11	check object contents
$exp = q|35	= {
	'BYTES'	=> 29,
	'Class'	=> 'IN',
	'HEADER'	=> {
		'AA'	=> 1,
		'AD'	=> 0,
		'ANCOUNT'	=> 54,
		'ARCOUNT'	=> 0,
		'CD'	=> 0,
		'ID'	=> 21141,
		'MBZ'	=> 0,
		'NSCOUNT'	=> 0,
		'OPCODE'	=> 0,
		'QDCOUNT'	=> 1,
		'QR'	=> 1,
		'RA'	=> 0,
		'RCODE'	=> 9,
		'RD'	=> 1,
		'TC'	=> 0,
	},
	'NRECS'	=> 1,
	'PeerAddr'	=> ['12.34.56.78','23.45.67.89',],
	'PeerPort'	=> 53,
	'Proto'	=> 'UDP',
	'QUESTION'	=> [{
		'CLASS'	=> 1,
		'NAME'	=> 'example.com',
		'TYPE'	=> 252,
	},
],
	'Recursion'	=> 256,
	'SERVER'	=> '12.34.56.78',
	'Timeout'	=> 15,
	'_SS'	=> {
		'12.34.56.78'	=> '"8N',
		'23.45.67.89'	=> '-CY',
	},
};
|;

#print MyTest::Dumper($dig);

$got = MyTest::Dumper($dig);
print "proc_body failed\ngot: $got\nexp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 12	check that soacount is not incremented
print "soacount increment failed, got $soacount, exp 0\nnot "
	unless $soacount == 0;
&ok;

$soacount = 0;

## test 13	build text object
$dig->{ELAPSED} = 56;
$tobj = $dig->to_text();
$exp = q|37	= {
	'BYTES'	=> 29,
	'Class'	=> 'IN',
	'ELAPSED'	=> 56,
	'HEADER'	=> {
		'AA'	=> 1,
		'AD'	=> 0,
		'ANCOUNT'	=> 54,
		'ARCOUNT'	=> 0,
		'CD'	=> 0,
		'ID'	=> 21141,
		'MBZ'	=> 0,
		'NSCOUNT'	=> 0,
		'OPCODE'	=> 'QUERY',
		'QDCOUNT'	=> 1,
		'QR'	=> 1,
		'RA'	=> 0,
		'RCODE'	=> 'NOTAUTH',
		'RD'	=> 1,
		'TC'	=> 0,
	},
	'NRECS'	=> 1,
	'PeerAddr'	=> ['12.34.56.78','23.45.67.89',],
	'PeerPort'	=> 53,
	'Proto'	=> 'UDP',
	'QUESTION'	=> [{
		'CLASS'	=> 'IN',
		'NAME'	=> 'example.com.',
		'TYPE'	=> 'AXFR',
	},
],
	'Recursion'	=> 256,
	'SERVER'	=> '12.34.56.78',
	'TEXT'	=> '
; <<>> Net::DNS::Dig 0.01 <<>> -t axfr example.com.
;;
; Transfer failed.
',
	'Timeout'	=> 15,
	'_SS'	=> {
		'12.34.56.78'	=> '"8N',
		'23.45.67.89'	=> '-CY',
	},
};
|;
$got = MyTest::Dumper($tobj);
print "to_text conversion failed\ngot: $got\nexp: $exp\nnot "
	unless $got eq $exp;
&ok;

## test 14	check that soacount incremented
print "soacount increment failed, got: $soacount, exp: 0\nnot "
	unless $soacount == 0;
&ok;

$soacount = 0;

1;
