#!/usr/bin/perl

package eBay::API::XML::DataType::OrderTransactionArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. OrderTransactionArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::OrderTransactionArrayType

=head1 DESCRIPTION

Contains a list of orders, transactions, or both, each of OrderTransactionType.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::OrderTransactionArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::OrderTransactionType;


my @gaProperties = ( [ 'OrderTransaction', 'ns:OrderTransactionType', '1'
	     ,'eBay::API::XML::DataType::OrderTransactionType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setOrderTransaction()

The individual order or transaction.

#    Argument: reference to an array  
                      of 'ns:OrderTransactionType'

=cut

sub setOrderTransaction {
  my $self = shift;
  $self->{'OrderTransaction'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getOrderTransaction()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeleteFromSoldList

#    Returns: reference to an array  
                      of 'ns:OrderTransactionType'

=cut

sub getOrderTransaction {
  my $self = shift;
  return $self->_getDataTypeArray('OrderTransaction');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
