/*    BreakIterator.xs
 *
 *    $Id: BreakIterator.xs,v 1.2 2001/02/12 03:52:05 bstell Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "picu/picu_util.h"
#include  "picu/Locale.h"
#include  "unicode/brkiter.h"
#include  "unicode/chariter.h"

static int debugLevel = 0;

/*
 * Note: constant_iv returns a integer (not double)
 */
static IV
constant_iv(char *name, int arg)
{
    errno = 0;
    switch (*name) {
#if 0
add more cases as needed
    case 'A':
        break;
#endif
    case 'D':
            if (strEQ(name, "DONE"))
                return BreakIterator::DONE;
        break;
    }
    errno = EINVAL;
    return 0;

/* if a value should be defined but is not */
not_there:
    errno = ENOENT;
    return 0;
}

MODULE = ICU::BreakIterator    PACKAGE = ICU::BreakIterator  

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

IV
constant_iv(name,arg)
        char *name
        int   arg

BreakIterator *
createCharacterInstance(CLASS, where, svr_status)
        char *CLASS;
        Picu_Locale *where;
        SV *svr_status;
    PREINIT:
        UErrorCode status = U_ZERO_ERROR;
    CODE:
        DEBUG100("BreakIterator::createCharacterInstance");
        if (!SVIsIntRef(svr_status)) {
            Perl_croak(aTHX_ "ICU::BreakIterator::createCharacterInstance: "
                           "status must be an integer reference");
        }
        status = (UErrorCode)SvIV(SvRV(svr_status));
        RETVAL = BreakIterator::createCharacterInstance(*where->getIcuLocale(), status);
        sv_setiv(SvRV(svr_status), (IV)status);
    OUTPUT:
        RETVAL

BreakIterator *
createLineInstance(CLASS, where, svr_status)
        char *CLASS;
        Picu_Locale *where;
        SV *svr_status;
    PREINIT:
        UErrorCode status = U_ZERO_ERROR;
    CODE:
        DEBUG100("BreakIterator::createLineInstance");
        if (!SVIsIntRef(svr_status)) {
            Perl_croak(aTHX_ "ICU::BreakIterator::createLineInstance: "
                           "status must be an integer reference");
        }
        status = (UErrorCode)SvIV(SvRV(svr_status));
        RETVAL = BreakIterator::createLineInstance(*where->getIcuLocale(), status);
        sv_setiv(SvRV(svr_status), (IV)status);
    OUTPUT:
        RETVAL

BreakIterator *
createSentenceInstance(CLASS, where, svr_status)
        char *CLASS;
        Picu_Locale *where;
        SV *svr_status;
    PREINIT:
        UErrorCode status = U_ZERO_ERROR;
    CODE:
        DEBUG100("BreakIterator::createSentenceInstance");
        if (!SVIsIntRef(svr_status)) {
            Perl_croak(aTHX_ "ICU::BreakIterator::createSentenceInstance: "
                           "status must be an integer reference");
        }
        status = (UErrorCode)SvIV(SvRV(svr_status));
        RETVAL = BreakIterator::createSentenceInstance(*where->getIcuLocale(), status);
        sv_setiv(SvRV(svr_status), (IV)status);
    OUTPUT:
        RETVAL

BreakIterator *
createWordInstance(CLASS, where, svr_status)
        char *CLASS;
        Picu_Locale *where;
        SV *svr_status;
    PREINIT:
        UErrorCode status = U_ZERO_ERROR;
    CODE:
        DEBUG100("BreakIterator::createWordInstance");
        if (!SVIsIntRef(svr_status)) {
            Perl_croak(aTHX_ "ICU::BreakIterator::createWordInstance: "
                           "status must be an integer reference");
        }
        status = (UErrorCode)SvIV(SvRV(svr_status));
        RETVAL = BreakIterator::createWordInstance(*where->getIcuLocale(), status);
        sv_setiv(SvRV(svr_status), (IV)status);
    OUTPUT:
        RETVAL

IV
BreakIterator::current()
    CODE:
        DEBUG100("BreakIterator::current()");
        RETVAL = THIS->current();
    OUTPUT:
        RETVAL

void
BreakIterator::DESTROY()
    CODE:
        DEBUG100("BreakIterator::DESTROY()");
        delete THIS;

IV
BreakIterator::first()
    CODE:
        DEBUG100("BreakIterator::first()");
        RETVAL = THIS->first();
    OUTPUT:
        RETVAL

IV
BreakIterator::following(offset)
        int offset;
    CODE:
        DEBUG100("BreakIterator::following()");
        RETVAL = THIS->following(offset);
    OUTPUT:
        RETVAL

void
getAvailableLocales(CLASS)
        char *CLASS;
    PREINIT:
        int i;
        int32_t count;
        const Locale *locales;
    PPCODE:
    locales = BreakIterator::getAvailableLocales(count);
    EXTEND(SP, count);
    for (i=0; i<count; i++) {
        SV *sv = sv_newmortal();
        Picu_Locale *ppL = new Picu_Locale(&locales[i], 0);
        sv_setref_pv(sv, Locale_class_string, (void *)ppL);
        PUSHs(sv);
    }

const CharacterIterator *
BreakIterator::getText()
    CODE:   
        RETVAL = &(THIS->getText());

const char *
BreakIterator::getDisplayName(objLocale, displayLocale=0)
        Picu_Locale *objLocale;
        Picu_Locale *displayLocale;
    PREINIT:
        UnicodeString dispName;
        U8 *u8str; 
        uint32_t u8len;
    CODE:   
        if (!IS_LOCALE_OBJECT(ST(1))) {
            Perl_croak("var is *NOT* type %s", Locale_class_string);
        }
        if ((displayLocale) && (IS_LOCALE_OBJECT(ST(2)))) {
            DEBUG100("got displayLocale");
            THIS->getDisplayName(*objLocale->getIcuLocale(), 
                             *displayLocale->getIcuLocale(), dispName);
        } else {
            DEBUG100("no displayLocale");
            THIS->getDisplayName(*objLocale->getIcuLocale(), dispName);
        }

        u8str = UnicodeStringToU8String(dispName, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len); 
    OUTPUT: 


IV
BreakIterator::isBoundary(offset)
        int offset;
    CODE:
        DEBUG100("BreakIterator::isBoundary()");
        RETVAL = THIS->isBoundary(offset);
    OUTPUT:
        RETVAL

IV
BreakIterator::last()
    CODE:
        DEBUG100("BreakIterator::last()");
        RETVAL = THIS->last();
    OUTPUT:
        RETVAL

IV
BreakIterator::next(...)
    CODE:
        DEBUG100("BreakIterator::next()");
        if (items > 2) {
            Perl_croak(aTHX_ "Usage: $bi->next([offset])");
        }
        if (items == 2) {
            int offset = SvIV(ST(1));
            RETVAL = THIS->next(offset);
        }
        else {
            RETVAL = THIS->next();
        }
    OUTPUT:
        RETVAL

IV
BreakIterator::preceding(offset)
        int offset;
    CODE:
        DEBUG100("BreakIterator::preceding()");
        RETVAL = THIS->preceding(offset);
    OUTPUT:
        RETVAL

IV
BreakIterator::previous()
    CODE:
        DEBUG100("BreakIterator::previous()");
        RETVAL = THIS->previous();
    OUTPUT:
        RETVAL

void
BreakIterator::setText(text)
        const char *text;
    PREINIT:
        UnicodeString utext(text, "UTF-8");
    CODE:
        THIS->setText(utext);

int
setDebugLevel(...)
    CODE:
        RETVAL = debugLevel; // return old value
        if (items > 1) {
            Perl_croak(aTHX_ "Usage: ICU::BreakIterator::setDebugLevel([new_debug_level])");
        }
        else if (items == 1) {
            debugLevel = SvIV(ST(0));
        }
        DEBUG100("debugLevel = %d", debugLevel);
    OUTPUT:
        RETVAL

