/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.graph;

import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DocNode
extends Node
implements Cloneable {
    public static final int MATCH_CONTENT_OFF = 0;
    public static final int MATCH_CONTENT_STRING = 1;
    public static final int MATCH_CONTENT_SUBSTRING = 2;
    public static final int MATCH_CONTENT_REGEXP = 3;
    boolean matchFont = false;
    boolean matchFontSize = false;
    boolean matchBold = false;
    boolean matchItalic = false;
    int matchContent = 0;
    String matchContentString = "";
    int matchMaxLength = -1;
    int matchMinLength = -1;
    boolean removeFromInstance = false;
    protected String segType;
    protected float segX1;
    protected float segX2;
    protected float segY1;
    protected float segY2;
    protected String segText;
    protected String segFontName;
    protected float segFontSize;
    protected boolean extractContent;
    public static Color NODE_COLOR = Color.red.darker();
    public static Color EXAMPLE_AND_FOUND_INSTANCE_COLOUR = new Color(255, 127, 0);
    public static Color EXAMPLE_INSTANCE_COLOUR = new Color(255, 127, 0);
    public static Color FOUND_INSTANCE_COLOUR = new Color(255, 127, 0);
    public static Color MOUSE_OVER_HYPERLINK_COLOR = Color.cyan;
    public static Color HIGHLIGHTED_COLOR = new Color(255, 127, 0);
    public static int DEFAULT_TYPE = 3;
    public static final Font SMALL_TAG_FONT = new Font("Tahoma", 0, 8);
    public static final Font TEXT_FONT = new Font("Tahoma", 0, 10);
    String url;
    protected boolean foundInstance = false;
    protected boolean exampleInstance = false;

    public DocNode(GenericSegment gs) {
        this.setFields(gs);
    }

    public void setFields(GenericSegment gs) {
        this.segX1 = gs.getX1();
        this.segX2 = gs.getX2();
        this.segY1 = gs.getY1();
        this.segY2 = gs.getY2();
        this.segType = gs.tagName();
        if (gs instanceof TextSegment) {
            TextSegment ts = (TextSegment)gs;
            this.segText = ts.getText();
            this.segFontName = ts.getFontName();
            this.segFontSize = ts.getFontSize();
        }
        this.lbl = this.nodeText();
        this.font = TEXT_FONT;
        this.typ = 2;
        this.removeFromInstance = false;
        this.setID(new Integer(gs.hashCode()).toString());
    }

    protected void setCommonFields() {
    }

    public DocNode(Element nodeElement) {
        this.setFields(nodeElement);
    }

    public void setFields(Element nodeElement) {
        NodeList nl = nodeElement.getElementsByTagName("segment-id");
        Element el = (Element)nl.item(0);
        NodeList textNL = el.getChildNodes();
        String val = textNL.item(0).getNodeValue().trim();
        this.setID(val);
        nl = nodeElement.getElementsByTagName("x1");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.segX1 = Float.parseFloat(val);
        nl = nodeElement.getElementsByTagName("x2");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.segX2 = Float.parseFloat(val);
        nl = nodeElement.getElementsByTagName("y1");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.segY1 = Float.parseFloat(val);
        nl = nodeElement.getElementsByTagName("y2");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.segY2 = Float.parseFloat(val);
        nl = nodeElement.getElementsByTagName("remove-from-instance");
        if (nl.getLength() > 0) {
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            val = textNL.item(0).getNodeValue().trim();
            this.removeFromInstance = Boolean.parseBoolean(val);
        } else {
            this.removeFromInstance = false;
        }
        nl = nodeElement.getElementsByTagName("segment-type");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        this.segType = val = textNL.item(0).getNodeValue().trim();
        if (nodeElement.getChildNodes().getLength() >= 39) {
            nl = nodeElement.getElementsByTagName("extract-content");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            val = textNL.item(0).getNodeValue().trim();
            this.extractContent = Boolean.parseBoolean(val);
            nl = nodeElement.getElementsByTagName("text");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            if (textNL.getLength() > 0) {
                this.segText = val = textNL.item(0).getNodeValue().trim();
            }
            nl = nodeElement.getElementsByTagName("font-name");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            this.segFontName = val = textNL.item(0).getNodeValue().trim();
            nl = nodeElement.getElementsByTagName("font-size");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            val = textNL.item(0).getNodeValue().trim();
            this.segFontSize = Float.parseFloat(val);
            nl = nodeElement.getElementsByTagName("match-font");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            val = textNL.item(0).getNodeValue().trim();
            this.matchFont = Boolean.parseBoolean(val);
            nl = nodeElement.getElementsByTagName("match-font-size");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            val = textNL.item(0).getNodeValue().trim();
            this.matchFontSize = Boolean.parseBoolean(val);
            nl = nodeElement.getElementsByTagName("match-bold");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            val = textNL.item(0).getNodeValue().trim();
            this.matchBold = Boolean.parseBoolean(val);
            nl = nodeElement.getElementsByTagName("match-italic");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            val = textNL.item(0).getNodeValue().trim();
            this.matchItalic = Boolean.parseBoolean(val);
            nl = nodeElement.getElementsByTagName("match-content");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            val = textNL.item(0).getNodeValue().trim();
            this.matchContent = Integer.parseInt(val);
            nl = nodeElement.getElementsByTagName("match-content-string");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            if (textNL.getLength() > 0) {
                this.matchContentString = val = textNL.item(0).getNodeValue().trim();
            }
            nl = nodeElement.getElementsByTagName("match-max-length");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            val = textNL.item(0).getNodeValue().trim();
            this.matchMaxLength = Integer.parseInt(val);
            nl = nodeElement.getElementsByTagName("match-min-length");
            el = (Element)nl.item(0);
            textNL = el.getChildNodes();
            val = textNL.item(0).getNodeValue().trim();
            this.matchMinLength = Integer.parseInt(val);
            this.segType = "text-segment";
        } else {
            this.segType = "generic-segment";
        }
        this.lbl = this.nodeText();
        this.font = TEXT_FONT;
        this.typ = 2;
        DocNode.setNodeTextFont((Font)TEXT_FONT);
        DocNode.setNodeType((int)2);
        this.setBackColor(NODE_COLOR);
    }

    public String toString() {
        return "DocNode: text: " + this.segText + " x1: " + this.segX1 + " x2: " + this.segX2 + " y1: " + this.segY1 + " y2: " + this.segY2 + " segType: " + this.segType;
    }

    public void addAsXMLNode(Document resultDocument, Element parent) {
        Element newNodeElement = resultDocument.createElement("node");
        this.setXMLNodeAttributes(resultDocument, newNodeElement);
        parent.appendChild(newNodeElement);
    }

    public void setXMLNodeAttributes(Document resultDocument, Element nodeElement) {
        Element newAttribElement = resultDocument.createElement("segment-id");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(this.getID()));
        newAttribElement = resultDocument.createElement("x1");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Float.toString(this.segX1)));
        newAttribElement = resultDocument.createElement("x2");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Float.toString(this.segX2)));
        newAttribElement = resultDocument.createElement("y1");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Float.toString(this.segY1)));
        newAttribElement = resultDocument.createElement("y2");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Float.toString(this.segY2)));
        newAttribElement = resultDocument.createElement("remove-from-instance");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.removeFromInstance)));
        newAttribElement = resultDocument.createElement("extract-content");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.extractContent)));
        newAttribElement = resultDocument.createElement("segment-type");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(this.segType));
        newAttribElement = resultDocument.createElement("text");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Utils.removeInvalidXMLCharacters(this.segText)));
        newAttribElement = resultDocument.createElement("font-name");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(this.segFontName));
        newAttribElement = resultDocument.createElement("font-size");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Float.toString(this.segFontSize)));
        newAttribElement = resultDocument.createElement("match-font");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.matchFont)));
        newAttribElement = resultDocument.createElement("match-font-size");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.matchFontSize)));
        newAttribElement = resultDocument.createElement("match-bold");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.matchBold)));
        newAttribElement = resultDocument.createElement("match-italic");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.matchItalic)));
        newAttribElement = resultDocument.createElement("match-content");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Integer.toString(this.matchContent)));
        newAttribElement = resultDocument.createElement("match-content-string");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(this.matchContentString));
        newAttribElement = resultDocument.createElement("match-max-length");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Integer.toString(this.matchMaxLength)));
        newAttribElement = resultDocument.createElement("match-min-length");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Integer.toString(this.matchMinLength)));
    }

    public boolean isTextSegment() {
        return this.segType != "image-segment" && this.segType != "line-segment" && this.segType != "rect-segment";
    }

    public String nodeText() {
        if (this.segType.equals("text-block") || this.segType.equals("text-segment") || this.segType.equals("text-line")) {
            if (this.segText.length() > 40) {
                return String.valueOf(this.segText.substring(0, 36)) + "...";
            }
            return this.segText;
        }
        return "[" + this.segType + "]";
    }

    public void clearWrapperEdits() {
        this.removeFromInstance = false;
        this.extractContent = false;
        this.matchFont = false;
        this.matchFontSize = false;
        this.matchContent = 0;
        this.matchContentString = "";
        this.matchMaxLength = -1;
        this.matchMinLength = -1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public boolean isBold() {
        if (this.segFontName == null) {
            return false;
        }
        return Utils.containsSubstring(this.segFontName, "Bold") || Utils.containsSubstring(this.segFontName, "bold") || Utils.containsSubstring(this.segFontName, "Black") || Utils.containsSubstring(this.segFontName, "black") || Utils.containsSubstring(this.segFontName, "Heavy") || Utils.containsSubstring(this.segFontName, "heavy");
    }

    public boolean isItalic() {
        if (this.segFontName == null) {
            return false;
        }
        return Utils.containsSubstring(this.segFontName, "Italic") || Utils.containsSubstring(this.segFontName, "italic") || Utils.containsSubstring(this.segFontName, "Cursive") || Utils.containsSubstring(this.segFontName, "cursive") || Utils.containsSubstring(this.segFontName, "Kursiv") || Utils.containsSubstring(this.segFontName, "kursiv");
    }

    public String toSBText() {
        return "ID: " + this.getID();
    }

    public GenericSegment toGenericSegment() {
        if (this.isTextSegment()) {
            return new TextSegment(this.segX1, this.segX2, this.segY1, this.segY2, this.segText, this.segFontName, this.segFontSize);
        }
        return new GenericSegment(this.segX1, this.segX2, this.segY1, this.segY2);
    }

    public boolean isMatchFont() {
        return this.matchFont;
    }

    public void setMatchFont(boolean matchFont) {
        this.matchFont = matchFont;
    }

    public boolean isMatchFontSize() {
        return this.matchFontSize;
    }

    public void setMatchFontSize(boolean matchFontSize) {
        this.matchFontSize = matchFontSize;
    }

    public boolean isMatchBold() {
        return this.matchBold;
    }

    public void setMatchBold(boolean matchBold) {
        this.matchBold = matchBold;
    }

    public boolean isMatchItalic() {
        return this.matchItalic;
    }

    public void setMatchItalic(boolean matchItalic) {
        this.matchItalic = matchItalic;
    }

    public int getMatchContent() {
        return this.matchContent;
    }

    public void setMatchContent(int matchContent) {
        this.matchContent = matchContent;
    }

    public String getMatchContentString() {
        return this.matchContentString;
    }

    public void setMatchContentString(String matchContentString) {
        this.matchContentString = matchContentString;
    }

    public int getMatchMaxLength() {
        return this.matchMaxLength;
    }

    public void setMatchMaxLength(int matchMaxLength) {
        this.matchMaxLength = matchMaxLength;
    }

    public int getMatchMinLength() {
        return this.matchMinLength;
    }

    public void setMatchMinLength(int matchMinLength) {
        this.matchMinLength = matchMinLength;
    }

    public boolean isExtractContent() {
        return this.extractContent;
    }

    public void setExtractContent(boolean extractContent) {
        this.extractContent = extractContent;
    }

    public boolean isRemoveFromInstance() {
        return this.removeFromInstance;
    }

    public void setRemoveFromInstance(boolean removeFromInstance) {
        this.removeFromInstance = removeFromInstance;
    }

    public boolean isFoundInstance() {
        return this.foundInstance;
    }

    public void setFoundInstance(boolean foundInstance) {
        this.foundInstance = foundInstance;
    }

    public boolean isExampleInstance() {
        return this.exampleInstance;
    }

    public void setExampleInstance(boolean exampleInstance) {
        this.exampleInstance = exampleInstance;
    }

    public String getSegType() {
        return this.segType;
    }

    public void setSegType(String segType) {
        this.segType = segType;
    }

    public float getSegX1() {
        return this.segX1;
    }

    public void setSegX1(float segX1) {
        this.segX1 = segX1;
    }

    public float getSegX2() {
        return this.segX2;
    }

    public void setSegX2(float segX2) {
        this.segX2 = segX2;
    }

    public float segXmid() {
        return Utils.avg(this.segX1, this.segX2);
    }

    public float getSegY1() {
        return this.segY1;
    }

    public void setSegY1(float segY1) {
        this.segY1 = segY1;
    }

    public float getSegY2() {
        return this.segY2;
    }

    public void setSegY2(float segY2) {
        this.segY2 = segY2;
    }

    public float segYmid() {
        return Utils.avg(this.segY1, this.segY2);
    }

    public String getSegText() {
        return this.segText;
    }

    public void setSegText(String segText) {
        this.segText = segText;
    }

    public String getSegFontName() {
        return this.segFontName;
    }

    public void setSegFontName(String segFontName) {
        this.segFontName = segFontName;
    }

    public float getSegFontSize() {
        return this.segFontSize;
    }

    public void setSegFontSize(float segFontSize) {
        this.segFontSize = segFontSize;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getWidth() {
        this.lbl = this.getLabel();
        if (this.fontMetrics != null && this.lbl != null) {
            if (this.typ != 3) {
                return this.fontMetrics.stringWidth(this.lbl) + 8;
            }
            return this.fontMetrics.stringWidth(this.lbl) + 28;
        }
        return 8;
    }

    public int getHeight() {
        if (this.fontMetrics != null) {
            return this.fontMetrics.getHeight() + 2;
        }
        return 8;
    }

    Color myBrighter(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        if (b > r + 64 && b > g + 64) {
            r += 32;
            g += 32;
        }
        r = Math.min(r + 144, 255);
        g = Math.min(g + 144, 255);
        b = Math.min(b + 144, 255);
        return new Color(r, g, b);
    }

    public void paint(Graphics g, TGPanel tgPanel) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(Utils.hints);
        if (!this.intersects(tgPanel.getSize())) {
            return;
        }
        this.paintNodeBody(g, tgPanel);
        int ix = (int)this.drawx;
        int iy = (int)this.drawy;
        int h = this.getHeight();
        int w = this.getWidth();
        if (this.visibleEdgeCount() < this.edgeCount()) {
            int tagX = ix + (w - 6) / 2 - 2 + w % 2;
            int tagY = iy - h / 2 - 3;
            String hiddenEdgeStr = String.valueOf(this.edgeCount() - this.visibleEdgeCount());
            g.setColor(Color.red);
            g.fillRect(tagX, tagY, 3 + 5 * hiddenEdgeStr.length(), 8);
            g.setColor(Color.white);
            g.setFont(SMALL_TAG_FONT);
            g.drawString(hiddenEdgeStr, tagX + 2, tagY + 7);
        }
    }

    public Color getPaintUnselectedBackColor() {
        if (this.fixed) {
            return BACK_FIXED_COLOR;
        }
        if (this.markedForRemoval) {
            return this.backColor.darker().darker();
        }
        if (this.justMadeLocal) {
            return this.myBrighter(this.backColor);
        }
        return this.backColor;
    }

    public Color getPaintTextColor(TGPanel tgPanel) {
        return this.textColor;
    }

    public Color getPaintBackColor(TGPanel tgPanel) {
        Color col;
        if (this.extractContent) {
            col = Color.YELLOW;
        } else {
            boolean matchTypography;
            boolean isMatchContent = this.matchContent != 0 || this.matchMinLength != -1 || this.matchMaxLength != -1;
            col = this.getPaintUnselectedBackColor();
            boolean bl = matchTypography = this.isMatchFont() || this.isMatchFontSize() || this.isMatchBold() || this.isMatchItalic();
            if (matchTypography && !isMatchContent) {
                col = Color.MAGENTA.darker();
            } else if (matchTypography && isMatchContent) {
                col = Color.PINK.darker();
            } else if (!matchTypography && isMatchContent) {
                col = Color.cyan.darker();
            }
        }
        if (this == tgPanel.getSelect()) {
            col = col.darker();
        }
        if (this.isRemoveFromInstance()) {
            col = this.myBrighter(col);
        }
        return col;
    }

    public Color getPaintBorderColor(TGPanel tgPanel) {
        if (this == tgPanel.getSelect()) {
            if (this.fixed) {
                return BACK_FIXED_COLOR;
            }
            if (this.markedForRemoval) {
                return new Color(100, 60, 40);
            }
            if (this.justMadeLocal) {
                return new Color(255, 220, 200);
            }
            if (this.isRemoveFromInstance()) {
                return this.myBrighter(this.backColor);
            }
            return this.backColor;
        }
        return super.getPaintBorderColor(tgPanel);
    }
}

