/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.afm.AFMParser;
import org.apache.fontbox.afm.FontMetric;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorAFM;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PDFont
implements COSObjectable {
    protected COSDictionary font;
    private Encoding fontEncoding = null;
    private PDFontDescriptor fontDescriptor = null;
    protected PDMatrix fontMatrix = null;
    protected CMap cmap = null;
    protected CMap toUnicodeCmap = null;
    private boolean hasToUnicode = false;
    protected static Map<String, CMap> cmapObjects = Collections.synchronizedMap(new HashMap());
    private List<Float> widths = null;
    private static final Map<String, FontMetric> afmObjects = Collections.unmodifiableMap(PDFont.getAdobeFontMetrics());
    protected static final String resourceRootCMAP = "org/apache/pdfbox/resources/cmap/";
    private static final String resourceRootAFM = "org/apache/pdfbox/resources/afm/";
    private FontMetric afm = null;
    private COSBase encoding = null;
    private static final String[] SINGLE_CHAR_STRING = new String[256];
    private static final String[][] DOUBLE_CHAR_STRING = new String[256][256];
    private String subtype = null;
    private boolean type1Font;
    private boolean trueTypeFont;
    private boolean typeFont;
    private boolean type0Font;

    private static Map<String, FontMetric> getAdobeFontMetrics() {
        HashMap<String, FontMetric> metrics = new HashMap<String, FontMetric>();
        PDFont.addAdobeFontMetric(metrics, "Courier-Bold");
        PDFont.addAdobeFontMetric(metrics, "Courier-BoldOblique");
        PDFont.addAdobeFontMetric(metrics, "Courier");
        PDFont.addAdobeFontMetric(metrics, "Courier-Oblique");
        PDFont.addAdobeFontMetric(metrics, "Helvetica");
        PDFont.addAdobeFontMetric(metrics, "Helvetica-Bold");
        PDFont.addAdobeFontMetric(metrics, "Helvetica-BoldOblique");
        PDFont.addAdobeFontMetric(metrics, "Helvetica-Oblique");
        PDFont.addAdobeFontMetric(metrics, "Symbol");
        PDFont.addAdobeFontMetric(metrics, "Times-Bold");
        PDFont.addAdobeFontMetric(metrics, "Times-BoldItalic");
        PDFont.addAdobeFontMetric(metrics, "Times-Italic");
        PDFont.addAdobeFontMetric(metrics, "Times-Roman");
        PDFont.addAdobeFontMetric(metrics, "ZapfDingbats");
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAdobeFontMetric(Map<String, FontMetric> metrics, String name) {
        block5: {
            try {
                String resource = resourceRootAFM + name + ".afm";
                InputStream afmStream = ResourceLoader.loadResource(resource);
                if (afmStream == null) break block5;
                try {
                    AFMParser parser = new AFMParser(afmStream);
                    parser.parse();
                    metrics.put(name, parser.getResult());
                }
                finally {
                    afmStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void clearResources() {
        cmapObjects.clear();
    }

    public PDFont() {
        this.font = new COSDictionary();
        this.font.setItem(COSName.TYPE, (COSBase)COSName.FONT);
    }

    public PDFont(COSDictionary fontDictionary) {
        this.font = fontDictionary;
        this.determineEncoding();
    }

    public PDFontDescriptor getFontDescriptor() {
        if (this.fontDescriptor == null) {
            COSDictionary fd = (COSDictionary)this.font.getDictionaryObject(COSName.FONT_DESC);
            if (fd != null) {
                this.fontDescriptor = new PDFontDescriptorDictionary(fd);
            } else {
                this.getAFM();
                if (this.afm != null) {
                    this.fontDescriptor = new PDFontDescriptorAFM(this.afm);
                }
            }
        }
        return this.fontDescriptor;
    }

    public void setFontDescriptor(PDFontDescriptorDictionary fdDictionary) {
        COSDictionary dic = null;
        if (fdDictionary != null) {
            dic = fdDictionary.getCOSDictionary();
        }
        this.font.setItem(COSName.FONT_DESC, (COSBase)dic);
        this.fontDescriptor = fdDictionary;
    }

    protected abstract void determineEncoding();

    @Override
    public COSBase getCOSObject() {
        return this.font;
    }

    public abstract float getFontWidth(byte[] var1, int var2, int var3) throws IOException;

    public abstract float getFontHeight(byte[] var1, int var2, int var3) throws IOException;

    public float getStringWidth(String string) throws IOException {
        byte[] data = string.getBytes("ISO-8859-1");
        float totalWidth = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            totalWidth += this.getFontWidth(data, i, 1);
        }
        return totalWidth;
    }

    public abstract float getAverageFontWidth() throws IOException;

    public void drawString(String string, Graphics g, float fontSize, AffineTransform at, float x, float y) throws IOException {
        this.drawString(string, null, g, fontSize, at, x, y);
    }

    public abstract void drawString(String var1, int[] var2, Graphics var3, float var4, AffineTransform var5, float var6, float var7) throws IOException;

    public int getCodeFromArray(byte[] data, int offset, int length) {
        int code = 0;
        for (int i = 0; i < length; ++i) {
            code <<= 8;
            code |= (data[offset + i] + 256) % 256;
        }
        return code;
    }

    protected float getFontWidthFromAFMFile(int code) throws IOException {
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            String characterName = this.fontEncoding.getName(code);
            retval = metric.getCharacterWidth(characterName);
        }
        return retval;
    }

    protected float getAverageFontWidthFromAFMFile() throws IOException {
        float retval = 0.0f;
        FontMetric metric = this.getAFM();
        if (metric != null) {
            retval = metric.getAverageCharacterWidth();
        }
        return retval;
    }

    protected FontMetric getAFM() {
        if (this.isType1Font() && this.afm == null) {
            COSBase baseFont = this.font.getDictionaryObject(COSName.BASE_FONT);
            String name = null;
            if (baseFont instanceof COSName) {
                name = ((COSName)baseFont).getName();
                if (name.indexOf("+") > -1) {
                    name = name.substring(name.indexOf("+") + 1);
                }
            } else if (baseFont instanceof COSString) {
                COSString string = (COSString)baseFont;
                name = string.getString();
            }
            if (name != null) {
                this.afm = afmObjects.get(name);
            }
        }
        return this.afm;
    }

    protected COSBase getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.font.getDictionaryObject(COSName.ENCODING);
        }
        return this.encoding;
    }

    protected void setEncoding(COSBase encodingValue) {
        this.font.setItem(COSName.ENCODING, encodingValue);
        this.encoding = encodingValue;
    }

    protected String cmapEncoding(int code, int length, boolean isCIDFont, CMap sourceCmap) throws IOException {
        String retval = null;
        if (sourceCmap == null) {
            sourceCmap = this.cmap;
        }
        if (sourceCmap != null && (retval = sourceCmap.lookup(code, length)) == null && isCIDFont) {
            retval = sourceCmap.lookupCID(code);
        }
        return retval;
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        String retval = null;
        int code = this.getCodeFromArray(c, offset, length);
        if (this.toUnicodeCmap != null) {
            retval = this.cmapEncoding(code, length, false, this.toUnicodeCmap);
        }
        if (retval == null && this.cmap != null) {
            retval = this.cmapEncoding(code, length, false, this.cmap);
        }
        if (retval == null) {
            if (this.fontEncoding != null) {
                retval = this.fontEncoding.getCharacter(code);
            }
            if (retval == null && (this.cmap == null || length == 2)) {
                retval = PDFont.getStringFromArray(c, offset, length);
            }
        }
        return retval;
    }

    public int encodeToCID(byte[] c, int offset, int length) throws IOException {
        int code = -1;
        if (this.encode(c, offset, length) != null) {
            code = this.getCodeFromArray(c, offset, length);
        }
        return code;
    }

    private static String getStringFromArray(byte[] c, int offset, int length) throws IOException {
        String retval = null;
        if (length == 1) {
            retval = SINGLE_CHAR_STRING[(c[offset] + 256) % 256];
        } else if (length == 2) {
            retval = DOUBLE_CHAR_STRING[(c[offset] + 256) % 256][(c[offset + 1] + 256) % 256];
        } else {
            throw new IOException("Error:Unknown character length:" + length);
        }
        return retval;
    }

    protected CMap parseCmap(String cmapRoot, InputStream cmapStream) {
        CMap targetCmap = null;
        if (cmapStream != null) {
            CMapParser parser = new CMapParser();
            try {
                targetCmap = parser.parse(cmapRoot, cmapStream);
                if (cmapRoot != null) {
                    cmapObjects.put(targetCmap.getName(), targetCmap);
                }
            }
            catch (IOException exception) {
                // empty catch block
            }
        }
        return targetCmap;
    }

    public void setFontEncoding(Encoding enc) {
        this.fontEncoding = enc;
    }

    public Encoding getFontEncoding() {
        return this.fontEncoding;
    }

    public String getType() {
        return this.font.getNameAsString(COSName.TYPE);
    }

    public String getSubType() {
        if (this.subtype == null) {
            this.subtype = this.font.getNameAsString(COSName.SUBTYPE);
            this.type1Font = "Type1".equals(this.subtype);
            this.trueTypeFont = "TrueType".equals(this.subtype);
            this.type0Font = "Type0".equals(this.subtype);
            this.typeFont = this.type1Font || "Type0".equals(this.subtype) || this.trueTypeFont;
        }
        return this.subtype;
    }

    protected boolean isType1Font() {
        this.getSubType();
        return this.type1Font;
    }

    protected boolean isType0Font() {
        this.getSubType();
        return this.type0Font;
    }

    private boolean isTrueTypeFont() {
        this.getSubType();
        return this.trueTypeFont;
    }

    private boolean isTypeFont() {
        this.getSubType();
        return this.typeFont;
    }

    public String getBaseFont() {
        return this.font.getNameAsString(COSName.BASE_FONT);
    }

    public void setBaseFont(String baseFont) {
        this.font.setName(COSName.BASE_FONT, baseFont);
    }

    public int getFirstChar() {
        return this.font.getInt(COSName.FIRST_CHAR, -1);
    }

    public void setFirstChar(int firstChar) {
        this.font.setInt(COSName.FIRST_CHAR, firstChar);
    }

    public int getLastChar() {
        return this.font.getInt(COSName.LAST_CHAR, -1);
    }

    public void setLastChar(int lastChar) {
        this.font.setInt(COSName.LAST_CHAR, lastChar);
    }

    public List<Float> getWidths() {
        COSArray array;
        if (this.widths == null && (array = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS)) != null) {
            this.widths = COSArrayList.convertFloatCOSArrayToList(array);
        }
        return this.widths;
    }

    public void setWidths(List<Float> widthsList) {
        this.widths = widthsList;
        this.font.setItem(COSName.WIDTHS, (COSBase)COSArrayList.converterToCOSArray(this.widths));
    }

    public PDMatrix getFontMatrix() {
        if (this.fontMatrix == null) {
            COSArray array = (COSArray)this.font.getDictionaryObject(COSName.FONT_MATRIX);
            if (array == null) {
                array = new COSArray();
                array.add(new COSFloat(0.001f));
                array.add(COSInteger.ZERO);
                array.add(COSInteger.ZERO);
                array.add(new COSFloat(0.001f));
                array.add(COSInteger.ZERO);
                array.add(COSInteger.ZERO);
            }
            this.fontMatrix = new PDMatrix(array);
        }
        return this.fontMatrix;
    }

    public abstract PDRectangle getFontBoundingBox() throws IOException;

    public boolean equals(Object other) {
        return other instanceof PDFont && ((PDFont)other).getCOSObject() == this.getCOSObject();
    }

    public int hashCode() {
        return this.getCOSObject().hashCode();
    }

    public float getFontWidth(int charCode) {
        float width = -1.0f;
        int firstChar = this.getFirstChar();
        int lastChar = this.getLastChar();
        if (charCode >= firstChar && charCode <= lastChar) {
            this.getWidths();
            if (this.widths != null) {
                width = this.widths.get(charCode - firstChar).floatValue();
            }
        } else {
            PDFontDescriptor fd = this.getFontDescriptor();
            if (fd instanceof PDFontDescriptorDictionary) {
                width = fd.getMissingWidth();
            }
        }
        return width;
    }

    protected boolean hasToUnicode() {
        return this.hasToUnicode;
    }

    protected void setHasToUnicode(boolean hasToUnicodeValue) {
        this.hasToUnicode = hasToUnicodeValue;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            try {
                PDFont.SINGLE_CHAR_STRING[i] = new String(new byte[]{(byte)i}, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            for (int j = 0; j < 256; ++j) {
                try {
                    PDFont.DOUBLE_CHAR_STRING[i][j] = new String(new byte[]{(byte)i, (byte)j}, "UTF-16BE");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

