/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import java.util.Set;
import thredds.inventory.DateExtractorFromName;
import ucar.ma2.Array;
import ucar.nc2.NCdump;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.Fmrc;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationOuterDimension;
import ucar.nc2.util.CancelTask;

public class AggregationFmrc
extends AggregationOuterDimension {
    protected static Set<NetcdfDataset.Enhance> fmrcEnhanceMode = NetcdfDataset.getDefaultEnhanceMode();
    private boolean debug = false;
    private Fmrc fmrc;
    private String runMatcher;

    public AggregationFmrc(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, Aggregation.Type.forecastModelRunCollection, recheckS);
    }

    public void addDirectoryScanFmrc(String dirName, String suffix, String regexpPatternString, String subdirs, String olderThan, String runMatcher, String forecastMatcher, String offsetMatcher) throws IOException {
        this.runMatcher = runMatcher;
        this.isDate = true;
        this.datasetManager.addDirectoryScan(dirName, suffix, regexpPatternString, subdirs, olderThan, null);
        if (runMatcher != null) {
            DateExtractorFromName dateExtractor = new DateExtractorFromName(runMatcher, false);
            this.datasetManager.setDateExtractor(dateExtractor);
        }
    }

    protected void makeDatasets(CancelTask cancelTask) throws IOException {
        super.makeDatasets(cancelTask);
        for (Aggregation.Dataset ds : this.datasets) {
            ds.enhance = fmrcEnhanceMode;
        }
    }

    public void getDetailInfo(Formatter f) {
        super.getDetailInfo(f);
        if (this.runMatcher != null) {
            f.format("  runMatcher=%s%n", this.runMatcher);
        }
    }

    protected void buildNetcdfDataset(CancelTask cancelTask) throws IOException {
        DateExtractorFromName dateExtractor = null;
        if (this.runMatcher != null) {
            dateExtractor = new DateExtractorFromName(this.runMatcher, false);
        }
        if (dateExtractor == null && this.dateFormatMark != null) {
            dateExtractor = new DateExtractorFromName(this.dateFormatMark, true);
        }
        this.fmrc = new Fmrc(this.datasetManager);
        this.fmrc.getDataset2D(this.ncDataset);
    }

    protected void rebuildDataset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] arg) throws IOException {
        String defaultFilename = "C:/data/rap/fmrc.xml";
        String filename = arg.length > 0 ? arg[0] : defaultFilename;
        GridDataset gds = GridDataset.open(filename);
        GridDatatype gg = gds.findGridDatatype("T");
        GridCoordSystem gsys = gg.getCoordinateSystem();
        CoordinateAxis1DTime rtaxis = gsys.getRunTimeAxis();
        CoordinateAxis taxis2D = gsys.getTimeAxis();
        Array data = taxis2D.read();
        NCdump.printArray(data, "2D time array", System.out, null);
        System.out.println("Run Time, Valid Times");
        Date[] runtimes = rtaxis.getTimeDates();
        for (int i = 0; i < runtimes.length; ++i) {
            System.out.println("\n" + runtimes[i]);
            CoordinateAxis1DTime taxis = gsys.getTimeAxisForRun(i);
            Date[] times = taxis.getTimeDates();
            for (int j = 0; j < times.length; ++j) {
                System.out.println("   " + times[j]);
            }
        }
    }
}

