/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen;

import com.mchange.v1.lang.ClassUtils;
import com.mchange.v2.codegen.IndentedWriter;
import java.io.File;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class CodegenUtils {
    public static String getModifierString(int modifiers) {
        StringBuffer sb = new StringBuffer(32);
        if (Modifier.isPublic(modifiers)) {
            sb.append("public ");
        }
        if (Modifier.isProtected(modifiers)) {
            sb.append("protected ");
        }
        if (Modifier.isPrivate(modifiers)) {
            sb.append("private ");
        }
        if (Modifier.isAbstract(modifiers)) {
            sb.append("abstract ");
        }
        if (Modifier.isStatic(modifiers)) {
            sb.append("static ");
        }
        if (Modifier.isFinal(modifiers)) {
            sb.append("final ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            sb.append("synchronized ");
        }
        if (Modifier.isTransient(modifiers)) {
            sb.append("transient ");
        }
        if (Modifier.isVolatile(modifiers)) {
            sb.append("volatile ");
        }
        if (Modifier.isStrict(modifiers)) {
            sb.append("strictfp ");
        }
        if (Modifier.isNative(modifiers)) {
            sb.append("native ");
        }
        if (Modifier.isInterface(modifiers)) {
            sb.append("interface ");
        }
        return sb.toString().trim();
    }

    public static Class unarrayClass(Class cl) {
        Class<?> out = cl;
        while (out.isArray()) {
            out = out.getComponentType();
        }
        return out;
    }

    public static boolean inSamePackage(String cn1, String cn2) {
        int pkgdot = cn1.lastIndexOf(46);
        int pkgdot2 = cn2.lastIndexOf(46);
        if (pkgdot < 0 || pkgdot2 < 0) {
            return true;
        }
        if (cn1.substring(0, pkgdot).equals(cn1.substring(0, pkgdot))) {
            return cn2.indexOf(46) < 0;
        }
        return false;
    }

    public static String fqcnLastElement(String fqcn) {
        return ClassUtils.fqcnLastElement(fqcn);
    }

    public static String methodSignature(Method m) {
        return CodegenUtils.methodSignature(m, null);
    }

    public static String methodSignature(Method m, String[] argNames) {
        return CodegenUtils.methodSignature(1, m, argNames);
    }

    public static String methodSignature(int modifiers, Method m, String[] argNames) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(CodegenUtils.getModifierString(modifiers));
        sb.append(' ');
        sb.append(ClassUtils.simpleClassName(m.getReturnType()));
        sb.append(' ');
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] cls = m.getParameterTypes();
        int len = cls.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(ClassUtils.simpleClassName(cls[i]));
            sb.append(' ');
            sb.append(argNames == null ? String.valueOf((char)(97 + i)) : argNames[i]);
        }
        sb.append(')');
        Class<?>[] excClasses = m.getExceptionTypes();
        if (excClasses.length > 0) {
            sb.append(" throws ");
            int len2 = excClasses.length;
            for (int i = 0; i < len2; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(ClassUtils.simpleClassName(excClasses[i]));
            }
        }
        return sb.toString();
    }

    public static String methodCall(Method m) {
        return CodegenUtils.methodCall(m, null);
    }

    public static String methodCall(Method m, String[] argNames) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] cls = m.getParameterTypes();
        int len = cls.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(argNames == null ? CodegenUtils.generatedArgumentName(i) : argNames[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public static String generatedArgumentName(int index) {
        return String.valueOf((char)(97 + index));
    }

    public static String simpleClassName(Class cl) {
        return ClassUtils.simpleClassName(cl);
    }

    public static IndentedWriter toIndentedWriter(Writer w) {
        return w instanceof IndentedWriter ? (IndentedWriter)w : new IndentedWriter(w);
    }

    public static String packageNameToFileSystemDirPath(String packageName) {
        StringBuffer sb = new StringBuffer(packageName);
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            if (sb.charAt(i) != '.') continue;
            sb.setCharAt(i, File.separatorChar);
        }
        sb.append(File.separatorChar);
        return sb.toString();
    }

    private CodegenUtils() {
    }
}

