#!/usr/bin/perl

package eBay::API::XML::Call::GetSellerTransactions;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSellerTransactions.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSellerTransactions

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSellerTransactions inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetSellerTransactions::GetSellerTransactionsRequestType;
use eBay::API::XML::Call::GetSellerTransactions::GetSellerTransactionsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetSellerTransactions';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSellerTransactions::GetSellerTransactionsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSellerTransactions::GetSellerTransactionsResponseType';
}

#
# input properties
#

=head2 setIncludeContainingOrder()

Whether to retrieve the order information.
Default is false.
Will not return the ContainingOrder information for an Express transaction that was part of an Express order.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeContainingOrder {
   my $self   = shift;
   my $sIncludeContainingOrder = shift;
   $self->getRequestDataType()->setIncludeContainingOrder($sIncludeContainingOrder);
}

=head2 setIncludeFinalValueFee()

Indicates whether to include final value fees in the response.
For most listing types, the fee is returned in Transaction.FinalValueFee.
For Dutch auctions that end with bids (not Buy It Now purchases), the fee
is returned in Item.SellingStatus.FinalValueFee.
The Final Value Fee for FixedPriceItem, StoresFixedPrice, and Buy It Now
Dutch listing types is returned on a transaction by transaction basis.
For all other listing types, including Chinese and Dutch (no Buy It Now
purchases), the Final Value Fee is returned when the listing status is
Completed.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeFinalValueFee {
   my $self   = shift;
   my $sIncludeFinalValueFee = shift;
   $self->getRequestDataType()->setIncludeFinalValueFee($sIncludeFinalValueFee);
}

=head2 setModTimeFrom()

Also see NumberOfDays which, if used, takes precedence over ModTimeFrom and
ModTimeTo. If you prefer to use ModTimeFrom and
ModTimeTo, you specify the time range within which
retrieved transactions' statuses were modified.
ModTimeFrom is the earlier (older) date and ModTimeTo is the later (more recent) date.
If you specify this value, and do not specify the other end of the range,
then the time range is 30 days.
The time range between ModTimeFrom to ModTimeTo
cannot be greater than 30 days.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut
       
sub setModTimeFrom {
   my $self   = shift;
   my $sModTimeFrom = shift;
   $self->getRequestDataType()->setModTimeFrom($sModTimeFrom);
}

=head2 setModTimeTo()

Also see NumberOfDays which, if used, takes precedence over ModTimeFrom and
ModTimeTo. If you prefer to use ModTimeFrom and
ModTimeTo, you specify the time range within which
retrieved transactions' statuses were modified.
ModTimeFrom is the earlier (older) date and ModTimeTo is the later (more recent) date.
If you specify this value, and do not specify the other end of the range,
then the time range is 30 days.
The time range between ModTimeFrom to ModTimeTo
cannot be greater than 30 days.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut
       
sub setModTimeTo {
   my $self   = shift;
   my $sModTimeTo = shift;
   $self->getRequestDataType()->setModTimeTo($sModTimeTo);
}

=head2 setNumberOfDays()

NumberOfDays enables you to specify the number of days' worth
of new and modified transactions that you want to retrieve.
The call response contains the transactions
whose status was modified within the
specified number of days since the API call was made.
NumberOfDays is often preferable to using
the ModTimeFrom and ModTimeTo filters because you only need to specify
one value.
If you use NumberOfDays, then ModTimeFrom and ModTimeTo are ignored.
For this field, one day is defined as 24 hours.

Max: 30

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setNumberOfDays {
   my $self   = shift;
   my $sNumberOfDays = shift;
   $self->getRequestDataType()->setNumberOfDays($sNumberOfDays);
}

=head2 setPagination()

Child elements control pagination of the output. Use its EntriesPerPage
property to control the number of transactions to return per call and its
PageNumber property to specify the page of data to return.

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut
       
sub setPagination {
   my $self   = shift;
   my $pPagination = shift;
   $self->getRequestDataType()->setPagination($pPagination);
}

=head2 setPlatform()

Name of the eBay co-branded site upon which the transaction was made.
This will serve as a filter for the transactions to get emitted in the response.

  RequiredInput: No
#    Argument: 'ns:TransactionPlatformCodeType'

=cut
       
sub setPlatform {
   my $self   = shift;
   my $sPlatform = shift;
   $self->getRequestDataType()->setPlatform($sPlatform);
}

=head2 setSKUArray()

Specifies a set of seller SKUs to use as a filter. Only items with the
specified SKUs are returned. Do not specify this tag if you do not want to
filter by SKU. Corresponds to the SKU property that is part of ItemType
and that can be provided when, for example, you use the AddItem call.

  RequiredInput: No
#    Argument: 'ns:SKUArrayType'

=cut
       
sub setSKUArray {
   my $self   = shift;
   my $pSKUArray = shift;
   $self->getRequestDataType()->setSKUArray($pSKUArray);
}



#
# output properties
#

=head2 isHasMoreTransactions()

Indicates whether there are additional transactions to retrieve.
That is, indicates whether more pages of data are available to be
returned, given the filters that were specified in the request.
Returns false for the last page of data.

  Returned: Always
  Details: DetailLevel: none, ReturnAll, ItemReturnDescription
#    Returns: 'xs:boolean'

=cut
       
sub isHasMoreTransactions {
   my $self = shift;
   return $self->getResponseDataType()->isHasMoreTransactions();
}

=head2 getPageNumber()

Page number for the page of transactions the response returned.

  Returned: Always
  Details: DetailLevel: none, ReturnAll, ItemReturnDescription
#    Returns: 'xs:int'

=cut
       
sub getPageNumber {
   my $self = shift;
   return $self->getResponseDataType()->getPageNumber();
}

=head2 getPaginationResult()

Contains the total number of pages (TotalNumberOfPages) and the total number
of entries (TotalNumberOfEntries) that could be returned given repeated calls
that use the same selection criteria as the call that returned this response.

  Returned: Always
  Details: DetailLevel: none, ReturnAll, ItemReturnDescription
#    Returns: 'ns:PaginationResultType'

=cut
       
sub getPaginationResult {
   my $self = shift;
   return $self->getResponseDataType()->getPaginationResult();
}

=head2 isPayPalPreferred()

Indicates whether the seller has the preference enabled that shows that the seller
prefers PayPal as the method of payment for an item. This preference is indicated on
an item's View Item page and is intended to influence a buyer to use PayPal
to pay for the item.

  Returned: Always
  Details: DetailLevel: none, ReturnAll, ItemReturnDescription
#    Returns: 'xs:boolean'

=cut
       
sub isPayPalPreferred {
   my $self = shift;
   return $self->getResponseDataType()->isPayPalPreferred();
}

=head2 getReturnedTransactionCountActual()

Number of transactions retrieved in the current page of results just returned.
May be a lower value than TransactionsPerPage if the page returned is the last
page and more than one page of data exists.

  Returned: Always
  Details: DetailLevel: none, ReturnAll, ItemReturnDescription
#    Returns: 'xs:int'

=cut
       
sub getReturnedTransactionCountActual {
   my $self = shift;
   return $self->getResponseDataType()->getReturnedTransactionCountActual();
}

=head2 getSeller()

Contains information about the seller whose transactions are being returned.
See the reference guide for information about the fields of the Seller object
that are returned.

  Returned: Always
  Details: DetailLevel: none, ReturnAll
#    Returns: 'ns:UserType'

=cut
       
sub getSeller {
   my $self = shift;
   return $self->getResponseDataType()->getSeller();
}

=head2 getTransactionArray()

List of Transaction objects representing the seller's recent sales.
Each Transaction object contains the data for one purchase
(of one or more items in the same listing).
See the reference guide for more information about the fields that are returned
for each transaction.

  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
#    Returns: 'ns:TransactionArrayType'

=cut
       
sub getTransactionArray {
   my $self = shift;
   return $self->getResponseDataType()->getTransactionArray();
}

=head2 getTransactionsPerPage()

Number of transactions returned per page (per call). May be a higher value
than ReturnedTransactionCountActual if the page returned is the last page
and more than one page of data exists.

  Returned: Always
  Details: DetailLevel: none, ReturnAll, ItemReturnDescription
#    Returns: 'xs:int'

=cut
       
sub getTransactionsPerPage {
   my $self = shift;
   return $self->getResponseDataType()->getTransactionsPerPage();
}





1;   
