# Copyrights 2001-2025 by [Mark Overmeer <markov@cpan.org>].
#  For other contributors see ChangeLog.
# See the manual pages for details on the licensing terms.
# Pod stripped from pm file by OODoc 2.02.
# This code is part of distribution Mail-Message.  Meta-POD processed with
# OODoc into POD and HTML manual-pages.  See README.md
# Copyright Mark Overmeer.  Licensed under the same terms as Perl itself.

package Mail::Message;
use vars '$VERSION';
$VERSION = '3.018_001';


use strict;
use warnings;

use Mail::Box::Parser::Lines ();

use Scalar::Util  qw(blessed);


sub _scalar2lines($)
{   my $lines = [ split /^/, ${$_[0]} ];
#   pop @$lines if @$lines && ! length $lines->[-1];
	$lines;
}

sub read($@)
{   # try avoiding copy of large strings
    my ($class, undef, %args) = @_;
	my $trusted      = exists $args{trusted} ? $args{trusted} : 1;
    my $strip_status = exists $args{strip_status_fields} ? delete $args{strip_status_fields} : 1;
	my $body_type    = $args{body_type};
	my $pclass       = $args{parser_class};

	my $parser;
    my $ref     = ref $_[1];

    if($args{seekable})
    {   $parser = ($pclass // 'Mail::Box::Parser::Perl')->new(%args,
            filename  => "file ($ref)",
            file      => $_[1],
            trusted   => $trusted,
        );
    }
	else
    {   my ($source, $lines);
        if(!$ref)
        {   $source = 'scalar';
            $lines  = _scalar2lines \$_[1];
        }
        elsif($ref eq 'SCALAR')
        {   $source = 'ref scalar';
            $lines  = _scalar2lines $_[1];
        }
        elsif($ref eq 'ARRAY')
        {   $source = 'array of lines';
            $lines  = $_[1];
        }
        elsif($ref eq 'GLOB' || (blessed $_[1] && $_[1]->isa('IO::Handle')))
        {   $source = "file ($ref)";
			local $/ = undef;   # slurp
            $lines  = _scalar2lines \$_[1]->getline;
        }
        else
        {   $class->log(ERROR => "Cannot read message from $_[1]/$ref");
            return undef;
        }
    
        $parser = ($pclass // 'Mail::Box::Parser::Lines')->new(%args,
            source  => $source,
            lines   => $lines,
            trusted => $trusted,
        );

		$body_type = 'Mail::Message::Body::Lines';
    }

    my $self = $class->new(%args);
    $self->readFromParser($parser, $body_type);
    $self->addReport($parser);

    $parser->stop;

    my $head = $self->head;
    $head->get('Message-ID')
        or $head->set('Message-ID' => '<'.$self->messageId.'>');

    $head->delete('Status', 'X-Status')
        if $strip_status;

    $self;
}

1;
