# Generated by default/object.tt
package Paws::FMS::AwsEc2NetworkInterfaceViolation;
  use Moose;
  has ViolatingSecurityGroups => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ViolationTarget => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FMS::AwsEc2NetworkInterfaceViolation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FMS::AwsEc2NetworkInterfaceViolation object:

  $service_obj->Method(Att1 => { ViolatingSecurityGroups => $value, ..., ViolationTarget => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FMS::AwsEc2NetworkInterfaceViolation object:

  $result = $service_obj->Method(...);
  $result->Att1->ViolatingSecurityGroups

=head1 DESCRIPTION

Violations for network interfaces associated with an EC2 instance.

=head1 ATTRIBUTES


=head2 ViolatingSecurityGroups => ArrayRef[Str|Undef]

List of security groups that violate the rules specified in the master
security group of the AWS Firewall Manager policy.


=head2 ViolationTarget => Str

The resource ID of the network interface.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

