#include "uulib/unparse.h"

static const char *fmt_lower =
  "%08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x";

static const char *fmt_upper =
  "%08X-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X";

static const char *fmt_lower6 =
  "%08x-%04x-%04x-%04x-%02x%02x%02x%02x%02x%02x";

static const char *fmt_upper6 =
  "%08X-%04X-%04X-%04X-%02X%02X%02X%02X%02X%02X";

#ifdef UUID_UNPARSE_DEFAULT_UPPER
#define FMT_DEFAULT fmt_upper
#else
#define FMT_DEFAULT fmt_lower
#endif

#ifdef UUID_UNPARSE_DEFAULT_UPPER6
#define FMT_DEFAULT6 fmt_upper6
#else
#define FMT_DEFAULT6 fmt_lower6
#endif

static void uu_unparse_x(const struct uu *in, char *out, const char *fmt) {
  sprintf(out, fmt,
    in->time_low,
    in->time_mid,
    in->time_high_and_version,
    in->clock_seq_and_variant >> 8,
    in->clock_seq_and_variant & 0xFF,
    in->node[0],
    in->node[1],
    in->node[2],
    in->node[3],
    in->node[4],
    in->node[5]
  );
}

void uu_unparse_lower(const struct uu *in, char *out) {
  uu_unparse_x(in, out,  fmt_lower);
}

void uu_unparse_upper(const struct uu *in, char *out) {
  uu_unparse_x(in, out, fmt_upper);
}

void uu_unparse(const struct uu *in, char *out) {
  uu_unparse_x(in, out, FMT_DEFAULT);
}

static void uu_unparse_x6(const struct uu6 *in, char *out, const char *fmt) {
  sprintf(out, fmt,
    in->time_high,
    in->time_mid,
    in->time_low_and_version,
    in->clock_seq_and_variant,
    in->node[0],
    in->node[1],
    in->node[2],
    in->node[3],
    in->node[4],
    in->node[5]
  );
}

void uu_unparse_lower6(const struct uu6 *in, char *out) {
  uu_unparse_x6(in, out,  fmt_lower6);
}

void uu_unparse_upper6(const struct uu6 *in, char *out) {
  uu_unparse_x6(in, out, fmt_upper6);
}

void uu_unparse6(const struct uu6 *in, char *out) {
  uu_unparse_x6(in, out, FMT_DEFAULT6);
}

/* ex:set ts=2 sw=2 itab=spaces: */
