# Generated by default/object.tt
package Paws::Connect::Reference;
  use Moose;
  has Type => (is => 'ro', isa => 'Str', required => 1);
  has Value => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::Reference

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::Reference object:

  $service_obj->Method(Att1 => { Type => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::Reference object:

  $result = $service_obj->Method(...);
  $result->Att1->Type

=head1 DESCRIPTION

A link that an agent selects to complete a given task. You can have up
to 4,096 UTF-8 bytes across all references for a contact.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Type => Str

A valid URL.


=head2 B<REQUIRED> Value => Str

A formatted URL that displays to an agent in the Contact Control Panel
(CCP)



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

