/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import java.util.Arrays;
import java.util.Map;
import org.openqa.grid.common.exception.GridException;

public enum SeleniumProtocol {
    Selenium("/selenium-server/driver"),
    WebDriver("/wd/hub");

    private String path;

    private SeleniumProtocol(String path) {
        this.path = path;
    }

    public static SeleniumProtocol fromCapabilitiesMap(Map<String, Object> capabilities) {
        String type = (String)capabilities.get("seleniumProtocol");
        if (type == null || type.trim().isEmpty()) {
            return WebDriver;
        }
        try {
            return SeleniumProtocol.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw new GridException(type + " isn't a valid protocol type for grid. Valid values :[" + Arrays.toString((Object[])SeleniumProtocol.values()) + "]", e);
        }
    }

    public String getPathConsideringCapabilitiesMap(Map<String, Object> capabilities) {
        String localPath = (String)capabilities.get("path");
        if (localPath != null) {
            return localPath;
        }
        return this.path;
    }

    public String getPath() {
        return this.path;
    }

    @Deprecated
    public boolean isSelenium() {
        return Selenium.equals((Object)this);
    }
}

